/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.fast.BaseLinkedHSet;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.semantic.HHViewUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfCuname;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDefaultConstructorDef;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfVunit;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedPackage;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;

public class RfClass
extends RfParamsHolder
implements IRfClassElement,
IBitFieldRegister {
    private static final long serialVersionUID = 2L;
    public static final RfClass CIRCULAR_INHERITANCE = new RfClass("[CIRCULAR INHERITANCE]", false, true);
    public static final RfClass CIRCULAR_ASSIGN_OR_INSTANCE = new RfClass("[CIRCULAR ASSIGNMENT OR INSTANTIATION]", false, true);
    public static final Set<Class<? extends IRfNamedElement>> SCOPE_PREFIX_KIND = new HashSet<Class<? extends IRfNamedElement>>();
    public static final Set<Class<? extends IRfNamedElement>> CLASS_PARENT_KIND = new HashSet<Class<? extends IRfNamedElement>>();
    public static final Set<String> ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS = new HashSet<String>();
    private boolean fIsInterfaceClass;
    private ClassParent fExtendedType;
    private List<ClassParent> fImplementedTypes;
    private transient boolean hasCircularInheritance;
    private transient boolean hasAncestorWithParametricDependency;
    private transient RfThisImplicitVariable fThis;
    private transient RfSuperImplicitVariable fSuper;
    private transient RfFunction fImplicitConstructor;
    private transient LinkedHashSet<RfClass> fChildren;
    private transient Map<RfSpecializedClass, RfSpecializedClass> specializations;
    private transient RfClass defaultSpecialization;
    private transient int portListParametersCount = -1;
    private transient ListContainer<RfField> cachedElabConstants;
    private transient Map<String, IHidObject> cachedElabConstantDefaultExpressions;
    private transient MacroCallInfo fMacroCallInfo;

    static {
        SCOPE_PREFIX_KIND.add(RfPackage.class);
        SCOPE_PREFIX_KIND.add(RfPredefinedPackage.class);
        SCOPE_PREFIX_KIND.add(RfCuname.class);
        SCOPE_PREFIX_KIND.add(RfClass.class);
        SCOPE_PREFIX_KIND.add(RfPredefinedClass.class);
        SCOPE_PREFIX_KIND.add(RfTypeAlias.class);
        SCOPE_PREFIX_KIND.add(RfPredefinedTypeAlias.class);
        SCOPE_PREFIX_KIND.add(RfField.class);
        CLASS_PARENT_KIND.add(RfField.class);
        CLASS_PARENT_KIND.add(RfClass.class);
        CLASS_PARENT_KIND.add(RfPredefinedClass.class);
        CLASS_PARENT_KIND.add(RfTypeAlias.class);
        CLASS_PARENT_KIND.add(RfPredefinedTypeAlias.class);
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("randomize");
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("srandom");
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("get_randstate");
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("set_randstate");
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("constraint_mode");
        ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.add("rand_mode");
    }

    protected RfClass(String name, boolean escaped, boolean hasCircularInheritance) {
        super(name, escaped);
        this.hasCircularInheritance = hasCircularInheritance;
    }

    public RfClass(String name, boolean escaped, MacroCallInfo macroInfo, int qualifiers, boolean isInterface) {
        super(name, escaped);
        this.setQualifiers(qualifiers);
        this.fMacroCallInfo = macroInfo;
        this.fIsInterfaceClass = isInterface;
    }

    protected RfClass(RfClass clazz) {
        this(clazz.getName(), clazz.isEscaped(), clazz.fMacroCallInfo, clazz.getQualifiers(), clazz.fIsInterfaceClass);
        this.hasCircularInheritance = clazz.hasCircularInheritance;
        this.setGenericClass(clazz);
        this.setEnclosingScope(clazz.getEnclosingScope());
        this.setParamNames(clazz.getParamNames());
        this.setTypeParamNames(clazz.getTypeParamNames());
        this.setEnumNames(clazz.getEnumNames());
        this.setActionBlockNames(clazz.getActionBlockNames());
        this.setPureFuncNames(clazz.getPureFuncNames());
        this.setVirtualFuncNames(clazz.getVirtualFuncNames());
        this.setHidHolder(clazz.getHidHolder());
        this.setMacroZone(clazz.getMacroZone());
        this.setParentTypes(clazz.getExtendedType(), clazz.getImplementedTypes(), clazz.getExtendedArguments(), null);
        this.internalSetImportsExports(clazz.fImportsExports);
    }

    public final void init(MacroCallInfo macroCallInfo, int qualifiers, boolean isInterface) {
        this.setQualifiers(qualifiers);
        this.fMacroCallInfo = macroCallInfo;
        this.fIsInterfaceClass = isInterface;
    }

    public final boolean hasCircularInheritance() {
        return this.hasCircularInheritance;
    }

    public final boolean hasParameterDependentAncestor() {
        return this.hasAncestorWithParametricDependency;
    }

    @Override
    public final <T extends IRfNamedElement> List<T> getLocalMembers(boolean hideDuplicates, Class<T> clazz) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        ArrayList<RfNamedElement> result = null;
        if (members != null) {
            result = new ArrayList<RfNamedElement>();
            if (clazz == RfVunit.class) {
                Set<String> vunitNames = this.getVunitNames();
                if (vunitNames == null || vunitNames.isEmpty()) {
                    return null;
                }
                for (String vunitName : vunitNames) {
                    RfNamedElement vunit = (RfNamedElement)members.get((Object)vunitName);
                    if (clazz.isInstance(vunit)) {
                        result.add(vunit);
                        continue;
                    }
                    if (!(vunit instanceof RfDuplicate)) continue;
                    ((RfDuplicate)vunit).getLocalMembers(hideDuplicates, result, clazz);
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result;
            }
            if (clazz == RfActionBlock.class) {
                Set<String> actionBlockNames = this.getActionBlockNames();
                if (actionBlockNames == null || actionBlockNames.isEmpty()) {
                    return null;
                }
                for (String actionBlockName : actionBlockNames) {
                    RfNamedElement actionBlock = (RfNamedElement)members.get((Object)actionBlockName);
                    if (clazz.isInstance(actionBlock)) {
                        result.add(actionBlock);
                        continue;
                    }
                    if (!(actionBlock instanceof RfDuplicate)) continue;
                    ((RfDuplicate)actionBlock).getLocalMembers(hideDuplicates, result, clazz);
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result;
            }
            for (RfNamedElement member : members.values()) {
                if (clazz == RfField.class && (member instanceof RfCoverpoint || member instanceof RfInstance)) continue;
                if (clazz.isInstance(member)) {
                    result.add(member);
                    continue;
                }
                if (!(member instanceof RfDuplicate)) continue;
                ((RfDuplicate)member).getLocalMembers(hideDuplicates, result, clazz);
            }
        }
        if (RfFunction.class.isAssignableFrom(clazz)) {
            if (result == null) {
                result = new ArrayList();
            }
            String methodName = "randomize";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "pre_randomize";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "post_randomize";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            if (this.fIsInterfaceClass) {
                return result.isEmpty() ? null : result;
            }
            methodName = "srandom";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "get_randstate";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "set_randstate";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "constraint_mode";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
            methodName = "rand_mode";
            if (members == null || !members.containsKey((Object)methodName)) {
                result.add(this.getPredefinedMethod(methodName));
            }
        }
        return result == null || result.isEmpty() ? null : result;
    }

    @Override
    public final DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(boolean rawMembers) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.internalGetMembers();
        if (rawMembers) {
            return members;
        }
        DVTLinkedHashMap result = new DVTLinkedHashMap(members);
        String methodName = "randomize";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "pre_randomize";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "post_randomize";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        if (this.fIsInterfaceClass) {
            return result;
        }
        methodName = "srandom";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "get_randstate";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "set_randstate";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "constraint_mode";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        methodName = "rand_mode";
        if (members == null || !members.containsKey((Object)methodName)) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        return result;
    }

    @Override
    public final <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers, boolean incremental) {
        T result = super.getLocalMember(clazz, name, true, incremental);
        if (result != null || rawMembers) {
            return result;
        }
        if (RfFunction.class.isAssignableFrom(clazz)) {
            return (T)this.getPredefinedMethod(name);
        }
        return null;
    }

    @Override
    public final RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members != null) {
            RfNamedElement candidate = (RfNamedElement)members.get((Object)name);
            if (candidate instanceof RfDuplicate) {
                return ((RfDuplicate)candidate).getLastMember(classes, exclude);
            }
            if (candidate != null && (classes == null || classes.contains(candidate.getClass()))) {
                return candidate;
            }
        }
        if (classes == null || classes.contains(RfFunction.class) || classes.contains(RfPredefinedFunction.class)) {
            return this.getPredefinedMethod(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPortListParametersCount() {
        if (this.portListParametersCount < 0) {
            RfClass rfClass = this.getGenericClass();
            synchronized (rfClass) {
                if (this.cachedElabConstants == null) {
                    this.cacheElabConstants();
                }
            }
        }
        return this.portListParametersCount;
    }

    @NotNull
    public List<RfField> getPortListParameters() {
        return this.getLocalElabConstants().subList(0, this.portListParametersCount);
    }

    @NotNull
    public List<RfField> getLocalParameters() {
        ArrayList<RfField> localParameters = new ArrayList<RfField>(this.portListParametersCount);
        for (RfField elabConstant : this.getLocalElabConstants()) {
            if (!elabConstant.isAnyParameter()) continue;
            localParameters.add(elabConstant);
        }
        return localParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RfField> getLocalElabConstants() {
        if (this.cachedElabConstants == null) {
            RfClass rfClass = this.getGenericClass();
            synchronized (rfClass) {
                if (this.cachedElabConstants == null) {
                    this.cacheElabConstants();
                }
            }
        }
        return OptimizedUtils.asList(this.cachedElabConstants, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, IHidObject> getElabConstantDefaultExpressions() {
        if (this.cachedElabConstantDefaultExpressions == null) {
            RfClass rfClass = this.getGenericClass();
            synchronized (rfClass) {
                if (this.cachedElabConstantDefaultExpressions == null) {
                    this.cacheElabConstants();
                }
            }
        }
        return this.cachedElabConstantDefaultExpressions;
    }

    @Override
    public final IELParamValue getElabConstantValue(String name) {
        IELParamValue parameterValue = this.getLocalElabConstantValue(name);
        if (parameterValue != null) {
            return parameterValue;
        }
        RfClass parent = this.getParent();
        if (parent != null && (parameterValue = parent.getLocalElabConstantValue(name)) != null) {
            return parameterValue;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfParamsHolder) {
            return enclosingScope.getLocalElabConstantValue(name);
        }
        return null;
    }

    private RfPredefinedFunction getPredefinedMethod(String name) {
        RfPredefinedFunction predefined = null;
        if ("randomize".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), null, 0, "Generates random values for all the active random variables in the object, subject to the active constraints");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("pre_randomize".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), null, 0, "Method automatically called by randomize() before computing new random values");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("post_randomize".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), null, 0, "Method automatically called by randomize() after computing new random values");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (this.fIsInterfaceClass) {
            return null;
        }
        if ("srandom".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), Arrays.asList(new ArgInfo("seed", RfProject.getSimpleDataType("int"), null)), 0, "Allows manually seeding the RNG of objects or threads");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("get_randstate".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("string"), null, 0, "Retrieves the current state of an object's RNG");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("set_randstate".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), Arrays.asList(new ArgInfo("state", RfProject.getSimpleDataType("string"), null)), 0, "Sets the state of an object's RNG");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("constraint_mode".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType(""), Arrays.asList(new ArgInfo("on_off", RfProject.getSimpleDataType("bit"), null)), 1, "Control whether a constraint is active or inactive");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if ("rand_mode".equals(name)) {
            predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), Arrays.asList(new ArgInfo("on_off", RfProject.getSimpleDataType("bit"), null)), 0, "The rand_mode() method can be used to control whether a random variable is active or inactive. When a random variable is inactive, it is treated the same as if it had not been declared rand or randc. Inactivevariables are not randomized by the randomize() method, and their values are treated as state variables bythe solver. All random variables are initially active.");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        return predefined;
    }

    @Override
    public final boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public final boolean canStaticAccess() {
        return true;
    }

    @Override
    public final String getSignature(RfTypesResolver resolver) {
        return String.valueOf(this.fIsInterfaceClass ? "interface class " : "class ") + this.printScope() + this.getName();
    }

    @Override
    public final String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    @Override
    public final RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        if (this.fIsInterfaceClass) {
            return null;
        }
        if (DVTStringUtil.regionMatches((String)"this", (String)prefix, (int)matchType)) {
            if (this.fThis == null) {
                this.fThis = new RfThisImplicitVariable(this);
            }
            return this.fThis;
        }
        return null;
    }

    @Override
    public final RfSuperImplicitVariable getSuperImplicitVariable(String prefix, int matchType) {
        if (this.fIsInterfaceClass) {
            return null;
        }
        if (this.fExtendedType != null && this.fExtendedType.fDataType != null && DVTStringUtil.regionMatches((String)"super", (String)prefix, (int)matchType)) {
            if (this.fSuper == null) {
                this.fSuper = new RfSuperImplicitVariable(this);
            }
            return this.fSuper;
        }
        return null;
    }

    public int getBitSize() {
        return -1;
    }

    public final RfClass getParent() {
        return this.fExtendedType == null ? null : this.fExtendedType.fClass;
    }

    public final List<RfClass> getParentInterfaces() {
        if (this.fImplementedTypes == null || this.fImplementedTypes.isEmpty()) {
            return null;
        }
        ArrayList<RfClass> result = new ArrayList<RfClass>(this.fImplementedTypes.size());
        for (ClassParent implementedType : this.fImplementedTypes) {
            if (implementedType.fClass == null) continue;
            result.add(implementedType.fClass);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public boolean hasImplements() {
        return this.fImplementedTypes != null && !this.fImplementedTypes.isEmpty();
    }

    public final boolean hasDirtyClassParent(ClassParent classParent) {
        if (classParent.fDataType == null || classParent.fDataType.fType == null) {
            return classParent.fClass != null;
        }
        if (classParent.fClass == null || classParent.fClass.isDirtyElement()) {
            return true;
        }
        if (classParent.fParameter != null && classParent.fParameter.isDirtyElement()) {
            return true;
        }
        if (classParent.fClass instanceof RfSpecializedClass) {
            if (classParent.fParameter != null) {
                if (!classParent.fDataType.fType.equals(classParent.fParameter.getName()) && !classParent.fDataType.fType.equals(classParent.fClass.getName())) {
                    return true;
                }
            } else {
                if (classParent.fDataType.fOrderedParamAssignments == null) {
                    return true;
                }
                List<RfField> parameters = classParent.fClass.getLocalParameters(384);
                if (parameters == null) {
                    return true;
                }
                if (parameters.size() != classParent.fDataType.fOrderedParamAssignments.size()) {
                    return true;
                }
                Iterator<RfField> iterator = parameters.iterator();
                for (DataType dataType : classParent.fDataType.fOrderedParamAssignments) {
                    DataType paramDataType = iterator.next().getDataType();
                    if (paramDataType != null && paramDataType.equals(dataType)) continue;
                    return true;
                }
            }
        }
        if (classParent.fParameter == null && !classParent.fDataType.fType.equals(classParent.fClass.getName())) {
            return true;
        }
        DataType packageScope = classParent.fDataType.fPackageScope;
        if (packageScope == null) {
            return false;
        }
        RfNamedElement enclosingScope = classParent.fClass;
        return (enclosingScope = enclosingScope.getEnclosingScope()) == null || !packageScope.getType().equals(enclosingScope.getName());
    }

    protected final void resolveClassParent(RfProject rfProject, RfNamedElement sourceElement, HashSet<String> incrementalAddedTypeNames, IdentityHSet<RfClass> resolvedGenericClasses, RfTypesResolver typesResolver, boolean forceRecomputeOnImportChanged) {
        if (!(this instanceof RfSpecializedClass) && resolvedGenericClasses != null && !resolvedGenericClasses.add((Object)this)) {
            return;
        }
        this.resolveClassParent(this.fExtendedType, rfProject, sourceElement, incrementalAddedTypeNames, resolvedGenericClasses, RfTypesResolver.create(typesResolver), true, forceRecomputeOnImportChanged);
        this.resolveClassParentImplements(rfProject, sourceElement, incrementalAddedTypeNames, resolvedGenericClasses, typesResolver, forceRecomputeOnImportChanged);
    }

    @Override
    protected final void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        this.resolveDefaultInConstructor(rfProject);
        ELWidthCheckContext elabContext = configInfo.getElabContext();
        boolean prevReducedChecksValue = false;
        if (elabContext != null) {
            prevReducedChecksValue = elabContext.setReducedChecks(true);
        }
        try {
            super.resolveHids(configInfo, triggerError, ignoreDirty, semanticEnabled, skipMemberClasses);
            this.checkNotImplementedPureFunctions(rfProject);
            this.checkNonVirtualClassPureFunctions(rfProject);
            this.checkInconsistentVirtualFunctions(rfProject, configInfo);
            this.checkInvalidSuperCallInImplicitConstructor(rfProject);
        }
        finally {
            if (elabContext != null) {
                elabContext.setReducedChecks(prevReducedChecksValue);
            }
        }
    }

    @Override
    protected void resolveHidOperators(ConfigInfo configInfo, boolean triggerError, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        ELWidthCheckContext elabContext = configInfo != null ? configInfo.getElabContext() : null;
        boolean prevReducedChecksValue = false;
        if (elabContext != null) {
            prevReducedChecksValue = elabContext.setReducedChecks(true);
        }
        try {
            super.resolveHidOperators(configInfo, triggerError, semanticEnabled, skipMemberClasses);
        }
        finally {
            if (elabContext != null) {
                elabContext.setReducedChecks(prevReducedChecksValue);
            }
        }
    }

    private void resolveDefaultInConstructor(RfProject project) {
        RfFunction constructor = this.getLocalMember(RfFunction.class, "new", false);
        if (constructor == null) {
            return;
        }
        RfDefElement constructorDeclaration = constructor.getDeclaration();
        if (constructorDeclaration == null) {
            return;
        }
        RfClass parent = this.getParent();
        if (parent == null) {
            return;
        }
        RfFunction parentConstructor = parent.getLocalMember(RfFunction.class, "new", false);
        if (parentConstructor == null) {
            return;
        }
        List<RfField> parentConstructorArguments = parentConstructor.getArgumentsWithPrefix("", 2);
        if (parentConstructorArguments.isEmpty()) {
            return;
        }
        Collection declarations = constructor.getDeclarations();
        boolean reportNoExtendedClass = true;
        for (RfDefElement declaration : declarations) {
            if (!(declaration instanceof RfFunctionDef)) continue;
            LineInfo defaultLineInfo = ((RfFunctionDef)declaration).getDefaultLineInfo();
            if (defaultLineInfo == null) {
                return;
            }
            if (reportNoExtendedClass && this.getExtendedType() == null) {
                reportNoExtendedClass = false;
                ParserPath parserPath = constructorDeclaration.getParserPath();
                int line = constructorDeclaration.getStartLine();
                int startOffset = constructorDeclaration.getStartOffset();
                int endOffset = startOffset + constructorDeclaration.getName().length();
                project.addSemanticError(1, "ILLEGAL_DEFAULT_IN_CONSTRUCTOR: Class ''{0}'' does not extend another class", this.getLibPkgScope(), startOffset, endOffset, null, line, parserPath, this.getName());
                return;
            }
            RfDefaultConstructorDef defaultKeywordDeclaration = new RfDefaultConstructorDef(this.getFile(), "default", defaultLineInfo, defaultLineInfo, null, null);
            defaultKeywordDeclaration.setParentDef(declaration);
            declaration.addChild(defaultKeywordDeclaration);
            for (RfField parentConstructorArgument : parentConstructorArguments) {
                RfField initialValueField;
                RfField constructorArgument = constructor.getLocalMember(RfField.class, parentConstructorArgument.getName(), true);
                if (constructorArgument != null) {
                    RfDefElement constArgDeclaration = constructorArgument.getDeclaration();
                    if (!(constArgDeclaration instanceof RfDefaultConstructorDef)) {
                        ParserPath parserPath = declaration.getParserPath();
                        int line = constructorArgument.getLine();
                        int startOffset = constructorArgument.getOffset();
                        int endOffset = startOffset + constructorArgument.getName().length();
                        project.addSemanticError(1, "ILLEGAL_DEFAULT_IN_CONSTRUCTOR: Argument ''{0}'' already exists in parent constructor", this.getLibPkgScope(), startOffset, endOffset, null, line, parserPath, constructorArgument.getName());
                        continue;
                    }
                    constructorArgument.addDeclaration(defaultKeywordDeclaration);
                    continue;
                }
                String initialValue = parentConstructorArgument.getInitialValue(false);
                if (initialValue != null && (initialValueField = parent.getLocalMember(RfField.class, initialValue, true, false)) != null && initialValueField.isPrivate()) {
                    ParserPath parserPath = declaration.getParserPath();
                    int line = declaration.getStartLine();
                    int startOffset = declaration.getStartOffset();
                    int endOffset = startOffset + declaration.getName().length();
                    project.addSemanticError(1, "ILLEGAL_DEFAULT_IN_CONSTRUCTOR: Initial value ''{0}'' of parent constructor field ''{1}'' is a 'local' member", this.getLibPkgScope(), startOffset, endOffset, null, line, parserPath, initialValue, parentConstructorArgument.getName());
                    continue;
                }
                RfField newField = new RfField(parentConstructorArgument);
                newField.addDeclaration(defaultKeywordDeclaration);
                constructor.addMember(newField);
            }
        }
    }

    @Override
    public void elaborateConstants(ELManager manager) {
    }

    public void elaborateParents(ELManager manager) {
        if (this.fExtendedType != null && this.fExtendedType.fClass != null) {
            RfPackage enclosingPackage = this.fExtendedType.fClass.getEnclosingScope(RfPackage.class);
            if (enclosingPackage != null) {
                enclosingPackage.elaborateConstants(manager);
            } else {
                RfLibrary enclosingLibrary = this.fExtendedType.fClass.getEnclosingLibrary();
                if (enclosingLibrary != null) {
                    enclosingLibrary.elaborateConstants(manager);
                }
            }
        }
        if (this.fImplementedTypes != null) {
            for (ClassParent implem : this.fImplementedTypes) {
                if (implem == null || implem.fClass == null) continue;
                RfPackage enclosingPackage = implem.fClass.getEnclosingScope(RfPackage.class);
                if (enclosingPackage != null) {
                    enclosingPackage.elaborateConstants(manager);
                    continue;
                }
                RfLibrary enclosingLibrary = implem.fClass.getEnclosingLibrary();
                if (enclosingLibrary == null) continue;
                enclosingLibrary.elaborateConstants(manager);
            }
        }
    }

    private void checkInconsistentVirtualFunctions(RfProject rfProject, ConfigInfo configInfo) {
        HashSet<String> classFuncNames = new HashSet<String>();
        HashMap<String, RfFunction> functionsByFunctionName = new HashMap<String, RfFunction>();
        for (RfFunction function : this.getLocalMembers(RfFunction.class)) {
            if (function instanceof RfPredefinedFunction) continue;
            String functionName = function.getName();
            classFuncNames.add(functionName);
            functionsByFunctionName.put(functionName, function);
        }
        if (classFuncNames.isEmpty()) {
            return;
        }
        RfClass parentClass = this;
        while ((parentClass = parentClass.getParent()) != null) {
            if (classFuncNames.isEmpty()) break;
            HashSet classFunctionNamesCopy = new HashSet(classFuncNames);
            Set<String> parentClassVirtualFuncNames = this.getVirtualFuncNames(parentClass);
            if (parentClassVirtualFuncNames == null || parentClassVirtualFuncNames.isEmpty()) continue;
            classFunctionNamesCopy.retainAll(parentClassVirtualFuncNames);
            for (String virtualFunctionName : classFunctionNamesCopy) {
                RfFunction virtualMethod = parentClass.getLocalMember(RfFunction.class, virtualFunctionName, true);
                RfFunction overrideMethod = (RfFunction)functionsByFunctionName.get(virtualFunctionName);
                if (overrideMethod == null || virtualMethod == null) continue;
                if (RfXvmFactory.isXVMFieldAutomationFunction(overrideMethod)) {
                    return;
                }
                this.checkSameSignature(rfProject, virtualMethod, overrideMethod, this.getLibPkgScope(), configInfo);
                classFuncNames.remove(virtualFunctionName);
            }
        }
    }

    private void checkInvalidSuperCallInImplicitConstructor(RfProject project) {
        if (this.getExtendedArguments() != null) {
            return;
        }
        RfFunction myConstructor = this.getLocalMember(RfFunction.class, "new", false);
        if (myConstructor != null) {
            return;
        }
        RfClass parent = this.getParent();
        if (parent == null) {
            return;
        }
        RfFunction parentConstructor = parent.getLocalMember(RfFunction.class, "new", false);
        if (parentConstructor == null) {
            return;
        }
        List<IRfFieldElement> arguments = parentConstructor.getArguments();
        if (arguments != null && !arguments.isEmpty()) {
            boolean hasAllArgumentsDefaultValues = true;
            for (IRfFieldElement argument : arguments) {
                String initialValue = argument.getInitialValue(false);
                if (initialValue != null) continue;
                hasAllArgumentsDefaultValues = false;
                break;
            }
            if (hasAllArgumentsDefaultValues) {
                return;
            }
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null) {
                return;
            }
            Set<RfNamedElement> namedElementsWithEncryptedCode = project.getNamedElementsWithEncryptedCode();
            if (namedElementsWithEncryptedCode != null && namedElementsWithEncryptedCode.contains(this)) {
                return;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", this.getName());
            attributes.put("QUICKFIX_KIND", 69);
            ParserPath parserPath = declaration.getParserPath();
            int line = declaration.getStartLine();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + declaration.getName().length();
            project.addSemanticError(1, "IMPLICIT_CONSTRUCTOR: Super class constructor ''{0}.new'' has non-default arguments", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, parent.getName());
        }
    }

    private Set<String> getVirtualFuncNames(RfClass clazz) {
        Set<String> virtualFuncNames1 = clazz.getVirtualFuncNames();
        Set<String> virtualFuncNames2 = clazz.getPureFuncNames();
        if (virtualFuncNames1 == null || virtualFuncNames1.isEmpty()) {
            return virtualFuncNames2;
        }
        if (virtualFuncNames2 == null || virtualFuncNames2.isEmpty()) {
            return virtualFuncNames1;
        }
        HashSet<String> virtualFuncNames = new HashSet<String>();
        virtualFuncNames.addAll(virtualFuncNames1);
        virtualFuncNames.addAll(virtualFuncNames2);
        return virtualFuncNames;
    }

    private void checkSameSignature(RfProject rfProject, RfFunction virtualMethod, RfFunction overrideMethod, LibraryPackageScope libPkgScope, ConfigInfo configInfo) {
        RfDefElement overrideMethodDecl = overrideMethod.getDeclaration();
        if (overrideMethodDecl == null) {
            return;
        }
        RfFileDef defFile = overrideMethodDecl.getDefFile();
        if (defFile == null) {
            return;
        }
        ParserPath parserPath = defFile.getParserPath();
        RfDefElement virtualMethodDecl = virtualMethod.getDeclaration();
        if (virtualMethodDecl == null) {
            return;
        }
        boolean virtualMethodIsTask = virtualMethod.isTask();
        boolean overrideMethodIsTask = overrideMethod.isTask();
        int line = overrideMethodDecl.getStartLine();
        String overrideMethodFullName = String.valueOf(this.getName()) + "." + overrideMethod.getName();
        String virtualMethodFullName = String.valueOf(virtualMethod.getEnclosingScopeName(RfModule.class, RfInterface.class, RfProgram.class, RfClass.class, RfSpecializedClass.class)) + "." + virtualMethod.getName();
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_KIND", 40);
        attributes.put("QUICKFIX_ELEMENT_NAME", overrideMethod.getName());
        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)virtualMethod).toString());
        if (virtualMethodIsTask && !overrideMethodIsTask) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Function ''{0}'' overrides task ''{1}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethod.getName().length(), attributes, line, parserPath, overrideMethodFullName, virtualMethodFullName);
            return;
        }
        if (!virtualMethodIsTask && overrideMethodIsTask) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Task ''{0}'' overrides function ''{1}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethod.getName().length(), attributes, line, parserPath, overrideMethodFullName, virtualMethodFullName);
            return;
        }
        this.checkFunctionType(rfProject, parserPath, virtualMethod, overrideMethod, libPkgScope, virtualMethodFullName, overrideMethodFullName, configInfo);
        this.checkArguments(rfProject, virtualMethodDecl, overrideMethodDecl, virtualMethod, overrideMethod, parserPath, libPkgScope, configInfo);
        this.checkQualifiers(rfProject, parserPath, virtualMethod, overrideMethod, libPkgScope, virtualMethodFullName, overrideMethodFullName);
    }

    private String getMethodQualifiersName(RfElement element) {
        if (element.isProtected()) {
            return "protected";
        }
        if (element.isPrivate()) {
            return "local";
        }
        return "public";
    }

    private void checkQualifiers(RfProject rfProject, ParserPath parserPath, RfFunction virtualMethod, RfFunction overrideMethod, LibraryPackageScope libPkgScope, String virtualMethodFullName, String overrideMethodFullName) {
        String overrideQualifiersName;
        String virtualQualifiersName = this.getMethodQualifiersName(virtualMethod);
        if (!virtualQualifiersName.equals(overrideQualifiersName = this.getMethodQualifiersName(overrideMethod))) {
            RfDefElement overrideMethodDecl = overrideMethod.getDeclaration();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_KIND", 57);
            attributes.put("QUICKFIX_ELEMENT_NAME", overrideMethod.getName());
            attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)virtualMethod).toString());
            rfProject.addSemanticError(2, "OVERRIDE_VIRTUAL_METHOD: Qualifier ''{0}'' of method ''{1}'' does not match qualifier ''{2}'' of overridden ''{3}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethod.getName().length(), attributes, overrideMethodDecl.getStartLine(), parserPath, overrideQualifiersName, overrideMethodFullName, virtualQualifiersName, virtualMethodFullName);
        }
    }

    private void checkFunctionType(RfProject rfProject, ParserPath parserPath, RfFunction virtualMethod, RfFunction overrideMethod, LibraryPackageScope libPkgScope, String virtualMethodFullName, String overrideMethodFullName, ConfigInfo configInfo) {
        String typeName = virtualMethod.implicitTypeName();
        RfDefElement virtualMethodDecl = virtualMethod.getDeclaration();
        DataType virtualMethodDataType = ((RfFunctionDef)virtualMethodDecl).getTypeInfoOrImplicit(typeName, virtualMethod);
        RfDefElement overrideMethodDecl = overrideMethod.getDeclaration();
        DataType overrideMethodDataType = ((RfFunctionDef)overrideMethodDecl).getTypeInfoOrImplicit(typeName, overrideMethod);
        this.addReferenceToIdentifierName(overrideMethod.getName());
        if (overrideMethodDataType == null || virtualMethodDataType == null || overrideMethodDataType.equalsDataTypeTypeName(virtualMethodDataType)) {
            return;
        }
        String overrideTypeName = overrideMethodDataType.getTypeName("logic", null);
        String virtualTypeName = virtualMethodDataType.getTypeName("logic", null);
        int startOffset = overrideMethodDataType.getOffset();
        int endOffset = startOffset + overrideTypeName.length();
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_KIND", 40);
        attributes.put("QUICKFIX_ELEMENT_NAME", overrideMethod.getName());
        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)virtualMethod).toString());
        if ("void".equals(overrideMethodDataType.getType()) || "void".equals(virtualMethodDataType.getType())) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Return data type ''{0}'' of method ''{1}'' does not match ''{2}'' of overridden ''{3}''", libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideTypeName, overrideMethodFullName, virtualTypeName, virtualMethodFullName);
        }
        if (this.isMatchingTypes(virtualMethodDataType, overrideMethodDataType, virtualMethod, overrideMethod, false, configInfo)) {
            return;
        }
        rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Return data type ''{0}'' of method ''{1}'' does not match ''{2}'' of overridden ''{3}''", libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideTypeName, overrideMethodFullName, virtualTypeName, virtualMethodFullName);
    }

    private void checkArguments(RfProject rfProject, RfDefElement virtualMethodDecl, RfDefElement overrideMethodDecl, RfFunction virtualMethodNamedElement, RfFunction overrideMethodNamedElement, ParserPath parserPath, LibraryPackageScope libPkgScope, ConfigInfo configInfo) {
        if (virtualMethodNamedElement == null || overrideMethodNamedElement == null) {
            return;
        }
        List<ArgInfo> virtualMethodArgsInfo = ((RfFunctionDef)virtualMethodDecl).getArgumentInfos();
        List<ArgInfo> overrideMethodArgsInfo = ((RfFunctionDef)overrideMethodDecl).getArgumentInfos();
        if (virtualMethodArgsInfo == null && overrideMethodArgsInfo == null) {
            return;
        }
        String overrideMethodFullName = String.valueOf(this.getName()) + "." + overrideMethodNamedElement.getName();
        String virtualMethodFullName = String.valueOf(virtualMethodNamedElement.getEnclosingScopeName(RfModule.class, RfInterface.class, RfProgram.class, RfClass.class, RfSpecializedClass.class)) + "." + virtualMethodNamedElement.getName();
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_KIND", 40);
        attributes.put("QUICKFIX_ELEMENT_NAME", overrideMethodNamedElement.getName());
        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)virtualMethodNamedElement).toString());
        if (overrideMethodArgsInfo == null && virtualMethodArgsInfo != null) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Number of arguments ''{0}'' of method ''{1}'' does not match ''{2}'' of overridden ''{3}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethodNamedElement.getName().length(), attributes, overrideMethodDecl.getStartLine(), parserPath, 0, overrideMethodFullName, virtualMethodArgsInfo.size(), virtualMethodFullName);
            return;
        }
        if (virtualMethodArgsInfo == null && overrideMethodArgsInfo != null) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Number of arguments ''{0}'' of method ''{1}'' does not match ''{2}'' of overridden ''{3}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethodNamedElement.getName().length(), attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodArgsInfo.size(), overrideMethodFullName, 0, virtualMethodFullName);
            return;
        }
        if (virtualMethodArgsInfo == null || overrideMethodArgsInfo == null) {
            return;
        }
        if (virtualMethodArgsInfo.size() != overrideMethodArgsInfo.size()) {
            rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Number of arguments ''{0}'' of method ''{1}'' does not match ''{2}'' of overridden ''{3}''", libPkgScope, overrideMethodDecl.getStartOffset(), overrideMethodDecl.getStartOffset() + overrideMethodNamedElement.getName().length(), attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodArgsInfo.size(), overrideMethodFullName, virtualMethodArgsInfo.size(), virtualMethodFullName);
            return;
        }
        List<RfField> overrideMethodArgs = overrideMethodNamedElement.getArgumentsWithPrefix("", 2);
        int i = 0;
        while (i < virtualMethodArgsInfo.size()) {
            ArgInfo virtualMethodArgInfo = virtualMethodArgsInfo.get(i);
            ArgInfo overrideMethodArgInfo = overrideMethodArgsInfo.get(i);
            if (virtualMethodArgInfo != null && overrideMethodArgInfo != null) {
                String virtualMethodArgName = virtualMethodArgInfo.getName();
                String overrideMethodArgName = overrideMethodArgInfo.getName();
                DataType virtualMethodArgDataType = virtualMethodArgInfo.getDataType();
                DataType overrideMethodArgDataType = overrideMethodArgInfo.getDataType();
                if (virtualMethodArgDataType != null && overrideMethodArgDataType != null) {
                    byte overrideMethodArgDirection;
                    byte virtualMethodArgDirection;
                    String virtualMethodArgType = virtualMethodArgDataType.getTypeName("logic", null);
                    String overrideMethodArgType = overrideMethodArgDataType.getTypeName("logic", null);
                    if (!this.isMatchingTypes(virtualMethodArgDataType, overrideMethodArgDataType, virtualMethodNamedElement, overrideMethodNamedElement, true, configInfo)) {
                        boolean isImplicit = overrideMethodArgDataType.getType() == null;
                        RfNamedElement overrideMethodArgument = overrideMethodArgs.get(i);
                        int argStartOffset = isImplicit ? overrideMethodArgument.getStartOffset() : overrideMethodArgDataType.getOffset();
                        int argEndOffset = argStartOffset + (isImplicit ? overrideMethodArgument.getName().length() : overrideMethodArgType.length());
                        rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Type ''{1}'' of argument ''{2}'' for method ''{0}'' does not match ''{4}'' of overridden ''{3}''", libPkgScope, argStartOffset, argEndOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodFullName, overrideMethodArgType, overrideMethodArgName, virtualMethodFullName, virtualMethodArgType, virtualMethodArgName);
                    }
                    if (!virtualMethodArgName.equals(overrideMethodArgName)) {
                        int startOffset = overrideMethodArgInfo.getStartInfo().realOffset;
                        int endOffset = startOffset + overrideMethodArgInfo.getName().length();
                        rfProject.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_VIRTUAL_METHOD_OVERRIDE_ARG_NAME, libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodFullName, overrideMethodArgType, overrideMethodArgName, virtualMethodFullName, virtualMethodArgType, virtualMethodArgName);
                    }
                    if ((virtualMethodArgDirection = virtualMethodArgDataType.getDirection()) != (overrideMethodArgDirection = overrideMethodArgDataType.getDirection())) {
                        int startOffset = overrideMethodArgInfo.getStartInfo().realOffset;
                        int endOffset = startOffset + overrideMethodArgInfo.getName().length();
                        rfProject.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Direction ''{1}'' of argument ''{3}'' for method ''{0}'' does not match ''{5}'' of overridden ''{4}''", libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodFullName, RfClass.getArgumentDirectionString(overrideMethodArgDirection), overrideMethodArgType, overrideMethodArgName, virtualMethodFullName, RfClass.getArgumentDirectionString(virtualMethodArgDirection), virtualMethodArgType, virtualMethodArgName);
                    }
                    String virtualMethodArgInitValue = virtualMethodArgInfo.getInitialValue();
                    String overrideMethodArgInitValue = overrideMethodArgInfo.getInitialValue();
                    int startOffset = overrideMethodArgInfo.getStartInfo().realOffset;
                    int endOffset = startOffset + overrideMethodArgInfo.getName().length();
                    if (virtualMethodArgInitValue != null && overrideMethodArgInitValue == null) {
                        rfProject.addSemanticError(2, "OVERRIDE_VIRTUAL_METHOD: Missing default value of argument ''{2}'' for method ''{0}'' (overridden ''{3}'' provides a default value)", libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodFullName, overrideMethodArgType, overrideMethodArgName, virtualMethodFullName, virtualMethodArgType, virtualMethodArgName, virtualMethodArgInitValue);
                    } else if (virtualMethodArgInitValue == null && overrideMethodArgInitValue != null) {
                        rfProject.addSemanticError(2, "OVERRIDE_VIRTUAL_METHOD: Unexpected default value of argument ''{2}'' for method ''{0}'' (overridden ''{4}'' does not provide a default value)", libPkgScope, startOffset, endOffset, attributes, overrideMethodDecl.getStartLine(), parserPath, overrideMethodFullName, overrideMethodArgType, overrideMethodArgName, overrideMethodArgInitValue, virtualMethodFullName, virtualMethodArgType, virtualMethodArgName);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isMatchingTypes(DataType virtualDataType, DataType overrideDataType, RfFunction virtualMethod, RfFunction overrideMethod, boolean forceClassMatching, ConfigInfo configInfo) {
        RfPredefinedField dummyLHSide = new RfPredefinedField("", virtualDataType, 1, 0, null, null);
        dummyLHSide.setEnclosingScope(virtualMethod);
        RfPredefinedField dummyRHSide = new RfPredefinedField("", overrideDataType, 1, 0, null, null);
        dummyRHSide.setEnclosingScope(overrideMethod);
        ISDataAbstract result = SEvaluator.INSTANCE.checkTypeCompatibility(dummyLHSide, dummyRHSide, forceClassMatching, true, (IRfNamedElement)this, configInfo);
        return !SDataUtils.isIllegalDataType((ISDataAbstract)result);
    }

    public static String getArgumentDirectionString(byte direction) {
        switch (direction) {
            case 1: {
                return "input";
            }
            case 3: {
                return "output";
            }
            case 2: {
                return "inout";
            }
        }
        return "";
    }

    protected void checkNotImplementedPureFunctions(RfProject rfProject) {
        RfNamedElement specializedClassOccurrence;
        if (this.isVirtual() || this.fIsInterfaceClass) {
            return;
        }
        RfNamedElement rfNamedElement = specializedClassOccurrence = this instanceof RfSpecializedClass && this.hasPortListParameters() ? ((RfSpecializedClass)this).getLastSpecializedClassOccurrence() : null;
        if (!this.extendsUnresolvedTypeParameter()) {
            Set<String> unimplPureFunctions;
            RfDefElement declaration = specializedClassOccurrence != null ? specializedClassOccurrence.getDeclaration() : this.getDeclaration();
            String name = this.getName();
            if (declaration == null) {
                return;
            }
            if (this.hasVirtualParentOrInterface() && (unimplPureFunctions = this.getUnimplementedPureFunctions()) != null && !unimplPureFunctions.isEmpty()) {
                LibraryPackageScope libPkgScope = this.getLibPkgScope();
                ParserPath parserPath = declaration.getParserPath();
                DataType occurrenceDataType = specializedClassOccurrence instanceof RfAssociatedType ? ((RfAssociatedType)specializedClassOccurrence).getDataType() : null;
                int line = occurrenceDataType != null ? occurrenceDataType.getLine() : declaration.getStartLine();
                int startOffset = occurrenceDataType != null ? occurrenceDataType.getOffset() : declaration.getStartOffset();
                int endOffset = startOffset + name.length();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                attributes.put("QUICKFIX_KIND", 30);
                attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this.getGenericClass()).toString());
                rfProject.addSemanticError(1, "NOT_IMPLEMENTED_PURE_VIRTUAL: Sub-class ''{0}'' does not implement pure virtual method(s) from super-classes: {1}", libPkgScope, startOffset, endOffset, attributes, line, parserPath, name, DVTStringUtil.join(unimplPureFunctions, (String)", "));
            }
        }
    }

    private boolean extendsUnresolvedTypeParameter() {
        if (!this.hasAncestorWithParametricDependency) {
            return false;
        }
        RfClass parent = this;
        do {
            RfField extendedParameter;
            if ((extendedParameter = parent.getExtendedParameter()) == null) continue;
            return !(this.getElabConstantValue(extendedParameter.getName()) instanceof ELParamValues.ParamValueType);
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    private boolean hasVirtualParentOrInterface() {
        if (this.fExtendedType != null && this.fExtendedType.fClass != null && this.fExtendedType.fClass.isVirtual()) {
            return true;
        }
        return this.fImplementedTypes != null && !this.fImplementedTypes.isEmpty();
    }

    private void checkNonVirtualClassPureFunctions(RfProject rfProject) {
        if (this.isVirtual() || this.fIsInterfaceClass) {
            return;
        }
        Set<String> pureFuncNames = this.getPureFuncNames();
        if (pureFuncNames != null && !pureFuncNames.isEmpty()) {
            LibraryPackageScope libPkgScope = this.getLibPkgScope();
            for (String pureFuncName : pureFuncNames) {
                RfDefElement declaration;
                RfFunction pureFunction = this.getLocalMember(RfFunction.class, pureFuncName, true);
                if (pureFunction == null || !pureFunction.isPure() || (declaration = pureFunction.getDeclaration()) == null) continue;
                ParserPath parserPath = declaration.getParserPath();
                int line = declaration.getStartLine();
                int startOffset = declaration.getStartOffset();
                int endOffset = startOffset + pureFuncName.length();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", this.getName());
                attributes.put("QUICKFIX_KIND", 29);
                rfProject.addSemanticError(1, "ILLEGAL_PURE_VIRTUAL: Pure virtual method prototype ''{0}'' cannot be declared in non-virtual class", libPkgScope, startOffset, endOffset, attributes, line, parserPath, pureFuncName);
            }
        }
    }

    public final Set<String> getUnimplementedPureFunctions() {
        HashSet<String> pureFunctionNames = new HashSet<String>();
        this.recusiveCollectPureFuncNames(pureFunctionNames);
        if (pureFunctionNames.isEmpty()) {
            return pureFunctionNames;
        }
        Iterator pureFunctionNamesIterator = pureFunctionNames.iterator();
        block0: while (pureFunctionNamesIterator.hasNext()) {
            String pureFunctionName = (String)pureFunctionNamesIterator.next();
            RfClass parent = this;
            do {
                RfFunction function;
                if ((function = parent.getLocalMember(RfFunction.class, pureFunctionName, true)) == null || function.isPure()) continue;
                pureFunctionNamesIterator.remove();
                continue block0;
            } while ((parent = parent.getParent()) != null);
        }
        return pureFunctionNames;
    }

    public final List<RfFunction> getQuickFixUnimplementedPureVirtualMethods() {
        return this.getQuickFixUnimplementedPureVirtualMethods(-1, null);
    }

    public final List<RfFunction> getQuickFixUnimplementedPureVirtualMethods(int limit, Predicate<? super String> nameFilter) {
        ArrayList<RfFunction> unimplementedPureFunctions = new ArrayList<RfFunction>();
        LinkedHashSet<String> pureFunctionNames = new LinkedHashSet<String>();
        this.recusiveCollectPureFuncNames(pureFunctionNames);
        if (pureFunctionNames.isEmpty()) {
            return null;
        }
        Iterator pureFunctionNamesIterator = pureFunctionNames.iterator();
        while (pureFunctionNamesIterator.hasNext()) {
            if (limit != -1 && unimplementedPureFunctions.size() >= limit) break;
            String pureFunctionName = (String)pureFunctionNamesIterator.next();
            if (nameFilter != null && !nameFilter.test(pureFunctionName)) continue;
            LinkedList<RfClass> parents = new LinkedList<RfClass>();
            parents.add(this);
            boolean isNotImplemented = true;
            RfFunction function = null;
            while (!parents.isEmpty()) {
                RfClass parent = (RfClass)parents.poll();
                RfFunction tempFunc = parent.getLocalMember(RfFunction.class, pureFunctionName, true);
                if (tempFunc != null && !(function = tempFunc).isPure()) {
                    isNotImplemented = false;
                    break;
                }
                if (parent.getParentInterfaces() != null) {
                    parents.addAll(parent.getParentInterfaces());
                }
                if (parent.getParent() == null) continue;
                parents.add(parent.getParent());
            }
            if (function == null || !isNotImplemented) continue;
            unimplementedPureFunctions.add(function);
        }
        if (unimplementedPureFunctions.isEmpty()) {
            return null;
        }
        return unimplementedPureFunctions;
    }

    public final void recusiveCollectPureFuncNames(Collection<String> pureFunctionNames) {
        this.recusiveGetPureFuncNamesInParentClass(pureFunctionNames);
        this.recusiveGetPureFuncNamesInParentInterfaces(pureFunctionNames);
    }

    private void recusiveGetPureFuncNamesInParentClass(Collection<String> pureFunctionNames) {
        RfClass parent = this.getParent();
        if (parent != null) {
            Set<String> pureFuncNames = parent.getPureFuncNames();
            if (pureFuncNames != null && !pureFuncNames.isEmpty()) {
                pureFunctionNames.addAll(pureFuncNames);
            }
            parent.recusiveGetPureFuncNamesInParentClass(pureFunctionNames);
            parent.recusiveGetPureFuncNamesInParentInterfaces(pureFunctionNames);
        }
    }

    private void recusiveGetPureFuncNamesInParentInterfaces(Collection<String> pureFunctionNames) {
        List<RfClass> parentInterfaces = this.getParentInterfaces();
        if (parentInterfaces != null && !parentInterfaces.isEmpty()) {
            for (RfClass parentInterface : parentInterfaces) {
                Set<String> pureFuncNames = parentInterface.getPureFuncNames();
                if (pureFuncNames != null && !pureFuncNames.isEmpty()) {
                    pureFunctionNames.addAll(pureFuncNames);
                }
                parentInterface.recusiveGetPureFuncNamesInParentInterfaces(pureFunctionNames);
            }
        }
    }

    private void resolveClassParentImplements(RfProject rfProject, RfNamedElement sourceElement, HashSet<String> incrementalAddedTypeNames, IdentityHSet<RfClass> resolvedGenericClasses, RfTypesResolver typesResolver, boolean forceRecomputeOnImportChanged) {
        if (this.fImplementedTypes == null || this.fImplementedTypes.isEmpty()) {
            return;
        }
        for (ClassParent implementedType : this.fImplementedTypes) {
            this.resolveClassParent(implementedType, rfProject, sourceElement, incrementalAddedTypeNames, resolvedGenericClasses, RfTypesResolver.create(typesResolver), false, forceRecomputeOnImportChanged);
        }
    }

    private void resolveClassParent(ClassParent classParent, RfProject rfProject, RfNamedElement sourceElement, HashSet<String> incrementalAddedTypeNames, IdentityHSet<RfClass> resolvedGenericClasses, RfTypesResolver typesResolver, boolean extendsNotImplements, boolean forceRecomputeOnImportChanged) {
        boolean isGeneric = !(this instanceof RfSpecializedClass);
        RfClass prevExtendedClass = null;
        boolean hasTypeAliasParent = false;
        try {
            RfFunction constructor;
            int startOffset;
            int endOffset;
            int startOffset2;
            int line;
            HashMap<String, Object> attributes;
            String unknownTypeName;
            if (classParent == null) {
                return;
            }
            if (classParent.fDataType == null || classParent.fDataType.fType == null) {
                classParent.fClass = null;
                classParent.fParameter = null;
                return;
            }
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (enclosingScope == null) {
                return;
            }
            if (isGeneric && !typesResolver.addVisitedElement(this)) {
                return;
            }
            String className = this.getName();
            String parentName = classParent.fDataType.fType;
            boolean shouldIncrementalRecompute = forceRecomputeOnImportChanged;
            prevExtendedClass = classParent.fClass;
            if (forceRecomputeOnImportChanged || this.hasDirtyClassParent(classParent)) {
                shouldIncrementalRecompute = classParent.fClass != null | classParent.fParameter != null;
                classParent.fClass = null;
                classParent.fParameter = null;
                this.fSuper = null;
            }
            shouldIncrementalRecompute |= this.shouldIncrementalRecompute(incrementalAddedTypeNames, className, parentName, forceRecomputeOnImportChanged);
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null && !this.isPredefined()) {
                return;
            }
            boolean isInnerGenericClass = !(this instanceof RfSpecializedClass) && this.getEnclosingScope() instanceof RfClass;
            DataType packageScope = classParent.fDataType.fPackageScope;
            ParserPath parserPath = declaration == null ? null : declaration.getParserPath();
            ParametricDependency parametricDependency = new ParametricDependency(1);
            RfNamedElement parentScope = this;
            if (packageScope != null) {
                this.addReference(packageScope.getType());
                this.addReferenceToIdentifierName(packageScope.getType());
                if (shouldIncrementalRecompute |= this.shouldIncrementalRecompute(incrementalAddedTypeNames, className, packageScope.getType(), forceRecomputeOnImportChanged)) {
                    parentScope = this.getLocalMember(RfField.class, parentName, true);
                    if (parentScope == null || !((RfField)parentScope).isTypeParameter()) {
                        parentScope = this.getEnclosingScope().getMember(packageScope.getType(), SCOPE_PREFIX_KIND, null, true, true, false, true, false);
                    }
                    if (parentScope == null || parentScope instanceof RfAssociatedType.RfAmbiguousElementInfo) {
                        classParent.fClass = null;
                        classParent.fParameter = null;
                        this.fSuper = null;
                        if (parentScope == null && isInnerGenericClass && ((RfClass)this.getEnclosingScope()).hasAncestorWithParametricDependency) {
                            this.hasAncestorWithParametricDependency = true;
                            return;
                        }
                        String unknownTypeName2 = packageScope.getTypeName("logic", null);
                        HashMap<String, Object> attributes2 = new HashMap<String, Object>(4);
                        attributes2.put("QUICKFIX_ELEMENT_NAME", unknownTypeName2);
                        attributes2.put("QUICKFIX_KIND", extendsNotImplements ? 20 : 21);
                        if (parentScope != null) {
                            attributes2.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)parentScope).toString());
                        }
                        int line2 = packageScope.getLine();
                        int startOffset3 = packageScope.getOffset();
                        int endOffset2 = startOffset3 + packageScope.getType().length();
                        if (parentScope instanceof RfAssociatedType.RfAmbiguousElementInfo) {
                            rfProject.addSemanticError(1, "MULTIPLE_PACKAGES: Name ''{0}'' exists in multiple imported packages (''{1}'', ''{2}'', and possibly others)", this.getLibPkgScope(), startOffset3, endOffset2, attributes2, line2, parserPath, unknownTypeName2, ((RfAssociatedType.RfAmbiguousElementInfo)parentScope).getFirstPackageName(), ((RfAssociatedType.RfAmbiguousElementInfo)parentScope).getSecondPackageName());
                        } else if (extendsNotImplements) {
                            rfProject.addSemanticError(1, "EXTEND_CLASS: Extending non existing class ''{0}''", this.getLibPkgScope(), startOffset3, endOffset2, attributes2, line2, parserPath, unknownTypeName2);
                        } else {
                            rfProject.addSemanticError(1, "IMPLEMENT_INTERFACE_CLASS: Implementing non existing interface class ''{0}''", this.getLibPkgScope(), startOffset3, endOffset2, attributes2, line2, parserPath, unknownTypeName2);
                        }
                        return;
                    }
                }
                if (isInnerGenericClass && packageScope.getParametricDependencyValue() == 0) {
                    parametricDependency.value |= RfTypesResolver.getAncestorParametricDependencyValue(parentScope, enclosingScope, true);
                }
                if (parentScope instanceof RfAssociatedType) {
                    parentScope = typesResolver.computeAssociatedType((RfAssociatedType)parentScope, parametricDependency, this, packageScope, null, true, true, true);
                }
                if (parentScope instanceof RfClass) {
                    if ((parentScope = typesResolver.computeClass((RfClass)parentScope, this, null, parametricDependency, true, true, false)) == CIRCULAR_ASSIGN_OR_INSTANCE) {
                        parentScope = typesResolver.getNamedElement();
                    } else if (!(parentScope instanceof RfSpecializedClass)) {
                        ((RfClass)parentScope).resolveClassParent(rfProject, sourceElement, incrementalAddedTypeNames, resolvedGenericClasses, typesResolver, forceRecomputeOnImportChanged);
                    }
                }
                packageScope.updateParametricDependencyValue(parametricDependency.value);
                if (parametricDependency.value != 15) {
                    parametricDependency.value |= parentScope.getInducedParametricDependencyValue();
                }
            }
            boolean hasInnerClassesInfo = classParent.fDataType.fInnerClassesInfo != null && !classParent.fDataType.fInnerClassesInfo.isEmpty();
            RfNamedElement parentCandidate = null;
            if (shouldIncrementalRecompute) {
                this.addReference(parentName);
                this.addReferenceToIdentifierName(parentName);
                classParent.fClass = null;
                classParent.fParameter = null;
                if (parentScope instanceof RfNamedElement) {
                    parentCandidate = ((RfNamedElement)parentScope).getLocalMember(RfField.class, parentName, true);
                }
                if (parentCandidate == null || !((RfField)parentCandidate).isTypeParameter()) {
                    if (parentScope == this) {
                        parentCandidate = enclosingScope.getMember(parentName, CLASS_PARENT_KIND, null, packageScope == null, true, false, true, false, this.getIndexInfo());
                    } else {
                        parentCandidate = parentScope.getMember(parentName, CLASS_PARENT_KIND, null, packageScope == null, true, false, true, false, this.getIndexInfo());
                        if (parentCandidate == null && packageScope != null && parentScope instanceof RfPackage && (parentCandidate = parentScope.getMember(parentName, CLASS_PARENT_KIND, null, true, true, false, true, false)) != null) {
                            unknownTypeName = classParent.fDataType.getTypeName("logic", null);
                            attributes = new HashMap(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", parentName);
                            attributes.put("QUICKFIX_KIND", 50);
                            attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
                            line = classParent.fDataType.getLine();
                            startOffset2 = classParent.fDataType.getOffsetOf(null);
                            endOffset = startOffset2 + unknownTypeName.length();
                            rfProject.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_IMPORT_TYPE_WITHOUT_EXPORT, this.getLibPkgScope(), startOffset2, endOffset, attributes, line, parserPath, parentScope.getName(), parentName);
                        }
                    }
                }
                if (isInnerGenericClass && classParent.fDataType.getParametricDependencyValue() == 0) {
                    parametricDependency.value |= RfTypesResolver.getAncestorParametricDependencyValue(parentCandidate, parentScope, true);
                }
                if (parentCandidate instanceof RfAssociatedType) {
                    if (!hasInnerClassesInfo && parentCandidate instanceof RfField && ((RfField)parentCandidate).isTypeParameter()) {
                        classParent.fParameter = (RfField)parentCandidate;
                    }
                    hasTypeAliasParent = parentCandidate instanceof RfTypeAlias;
                    parentCandidate = typesResolver.computeAssociatedType((RfAssociatedType)parentCandidate, parametricDependency, this, classParent.fDataType, null, packageScope != null, true, hasInnerClassesInfo);
                }
            } else {
                parentCandidate = classParent.fClass;
                if (parentCandidate == null) {
                    parentCandidate = classParent.fParameter;
                }
            }
            if (parentCandidate instanceof RfAssociatedType.RfUnresolvedTypeInfo && ((RfAssociatedType.RfUnresolvedTypeInfo)parentCandidate).isIllegalCunitAccess() && classParent.fParameter == null) {
                unknownTypeName = classParent.fDataType.getTypeName("logic", null);
                attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", unknownTypeName);
                attributes.put("QUICKFIX_KIND", extendsNotImplements ? 20 : 21);
                line = classParent.fDataType.getLine();
                startOffset2 = classParent.fDataType.getOffset();
                endOffset = startOffset2 + unknownTypeName.length();
                rfProject.addSemanticError(1, "ILLEGAL_CUNIT_REFERENCE: Reference to compilation unit identifier ''{0}'' not allowed in package", this.getLibPkgScope(), startOffset2, endOffset, null, line, parserPath, unknownTypeName);
                parentCandidate = ((RfAssociatedType.RfUnresolvedTypeInfo)parentCandidate).getSourceElement();
                if (parentCandidate instanceof RfTypeAlias) {
                    parentCandidate = ((RfTypeAlias)parentCandidate).getTranslatedType(typesResolver);
                }
            }
            if (!(parentCandidate instanceof RfClass)) {
                this.fSuper = null;
                classParent.fDataType.updateParametricDependencyValue(parametricDependency.value);
                if (parametricDependency.value >= 7) {
                    this.hasAncestorWithParametricDependency |= true;
                    if (!this.isComplete()) {
                        return;
                    }
                }
                unknownTypeName = classParent.fDataType.getTypeName("logic", null);
                int line3 = classParent.fDataType.getLine();
                startOffset = classParent.fDataType.getOffset();
                int endOffset3 = startOffset + classParent.fDataType.getType().length();
                if (this instanceof RfSpecializedClass && extendsNotImplements && parentCandidate != null) {
                    rfProject.addSemanticError(1, "EXTEND_CLASS: Class ''{0}'' extending non-class type ''{1}'' when elaborating ''{2}''", this.getLibPkgScope(), startOffset, endOffset3, null, line3, parserPath, this.getName(), parentCandidate != null ? parentCandidate.getName() : unknownTypeName, this.getQualifiedName());
                    return;
                }
                HashMap<String, Object> attributes3 = new HashMap<String, Object>(4);
                attributes3.put("QUICKFIX_ELEMENT_NAME", unknownTypeName);
                attributes3.put("QUICKFIX_KIND", extendsNotImplements ? 20 : 21);
                if (parentScope != null) {
                    attributes3.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)parentScope).toString());
                }
                if (parentCandidate instanceof RfAssociatedType.RfAmbiguousElementInfo) {
                    rfProject.addSemanticError(1, "MULTIPLE_PACKAGES: Name ''{0}'' exists in multiple imported packages (''{1}'', ''{2}'', and possibly others)", this.getLibPkgScope(), startOffset, endOffset3, attributes3, line3, parserPath, unknownTypeName, ((RfAssociatedType.RfAmbiguousElementInfo)parentCandidate).getFirstPackageName(), ((RfAssociatedType.RfAmbiguousElementInfo)parentCandidate).getSecondPackageName());
                } else if (extendsNotImplements) {
                    rfProject.addSemanticError(1, "EXTEND_CLASS: Extending non existing class ''{0}''", this.getLibPkgScope(), startOffset, endOffset3, attributes3, line3, parserPath, unknownTypeName);
                } else {
                    rfProject.addSemanticError(1, "IMPLEMENT_INTERFACE_CLASS: Implementing non existing interface class ''{0}''", this.getLibPkgScope(), startOffset, endOffset3, attributes3, line3, parserPath, unknownTypeName);
                }
                return;
            }
            parentCandidate = typesResolver.computeClass((RfClass)parentCandidate, this, classParent.fDataType, parametricDependency, hasInnerClassesInfo, true, false);
            classParent.fDataType.updateParametricDependencyValue(parametricDependency.value);
            if (parametricDependency.value != 15) {
                parametricDependency.value |= parentScope.getInducedParametricDependencyValue();
            }
            if (hasInnerClassesInfo) {
                Iterator<DataType> innerClassesInfoIt = classParent.fDataType.fInnerClassesInfo.iterator();
                do {
                    DataType innerClassInfo = innerClassesInfoIt.next();
                    parentScope = parentCandidate;
                    if (parentScope == CIRCULAR_ASSIGN_OR_INSTANCE) {
                        parentCandidate = typesResolver.getNamedElement();
                    } else if (!(parentScope instanceof RfSpecializedClass)) {
                        ((RfClass)parentScope).resolveClassParent(rfProject, sourceElement, incrementalAddedTypeNames, resolvedGenericClasses, typesResolver, forceRecomputeOnImportChanged);
                    }
                    if (shouldIncrementalRecompute |= this.shouldIncrementalRecompute(incrementalAddedTypeNames, className, innerClassInfo.fType, forceRecomputeOnImportChanged)) {
                        this.addReference(innerClassInfo.fType);
                        this.addReferenceToIdentifierName(innerClassInfo.fType);
                        parentCandidate = parentScope.getMember(innerClassInfo.fType, CLASS_PARENT_KIND, null, false, false, false, true, false);
                        if (parentCandidate instanceof RfField) {
                            parentCandidate = null;
                        }
                    }
                    if (isInnerGenericClass && innerClassInfo.getParametricDependencyValue() == 0) {
                        parametricDependency.value |= RfTypesResolver.getAncestorParametricDependencyValue(parentCandidate, parentScope, true);
                    }
                    if (parentCandidate instanceof RfAssociatedType) {
                        if (!hasInnerClassesInfo && parentCandidate instanceof RfField && ((RfField)parentCandidate).isTypeParameter()) {
                            classParent.fParameter = (RfField)parentCandidate;
                        }
                        parentCandidate = typesResolver.computeAssociatedType((RfAssociatedType)parentCandidate, parametricDependency, this, innerClassInfo, null, false, true, innerClassesInfoIt.hasNext());
                    }
                    if (!(parentCandidate instanceof RfClass)) {
                        this.fSuper = null;
                        classParent.fDataType.updateParametricDependencyValue(parametricDependency.value);
                        if (parametricDependency.value >= 7) {
                            this.hasAncestorWithParametricDependency |= true;
                            if (!this.isComplete()) {
                                return;
                            }
                        }
                        DataType unknownType = classParent.fDataType;
                        String unknownTypeName3 = unknownType.getTypeName("logic", null);
                        int line4 = unknownType.getLine();
                        int startOffset4 = unknownType.getOffsetOf(null);
                        int endOffset4 = startOffset4 + unknownTypeName3.length();
                        if (this instanceof RfSpecializedClass) {
                            if (extendsNotImplements) {
                                rfProject.addSemanticError(1, "EXTEND_CLASS: Class ''{0}'' extending non-class type ''{1}'' when elaborating ''{2}''", this.getLibPkgScope(), startOffset4, endOffset4, null, line4, parserPath, this.getName(), parentCandidate != null ? parentCandidate.getName() : unknownTypeName3, this.getQualifiedName());
                            }
                            return;
                        }
                        HashMap<String, Object> attributes4 = new HashMap<String, Object>(4);
                        attributes4.put("QUICKFIX_ELEMENT_NAME", unknownTypeName3);
                        attributes4.put("QUICKFIX_KIND", extendsNotImplements ? 20 : 21);
                        if (parentScope != null) {
                            attributes4.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)parentScope).toString());
                        }
                        if (parentScope instanceof RfAssociatedType.RfAmbiguousElementInfo) {
                            rfProject.addSemanticError(1, "MULTIPLE_PACKAGES: Name ''{0}'' exists in multiple imported packages (''{1}'', ''{2}'', and possibly others)", this.getLibPkgScope(), startOffset4, endOffset4, attributes4, line4, parserPath, unknownTypeName3, ((RfAssociatedType.RfAmbiguousElementInfo)parentScope).getFirstPackageName(), ((RfAssociatedType.RfAmbiguousElementInfo)parentScope).getSecondPackageName());
                        } else if (extendsNotImplements) {
                            rfProject.addSemanticError(1, "EXTEND_CLASS: Extending non existing class ''{0}''", this.getLibPkgScope(), startOffset4, endOffset4, attributes4, line4, parserPath, unknownTypeName3);
                        } else {
                            rfProject.addSemanticError(1, "IMPLEMENT_INTERFACE_CLASS: Implementing non existing interface class ''{0}''", this.getLibPkgScope(), startOffset4, endOffset4, attributes4, line4, parserPath, unknownTypeName3);
                        }
                        return;
                    }
                    if (parentCandidate instanceof RfClass) {
                        parentCandidate = typesResolver.computeClass((RfClass)parentCandidate, this, innerClassInfo, parametricDependency, innerClassesInfoIt.hasNext(), true, false);
                    }
                    innerClassInfo.updateParametricDependencyValue(parametricDependency.value);
                } while (innerClassesInfoIt.hasNext());
            }
            if (!this.recursiveParamsCheck(classParent.fDataType.fOrderedParamAssignments, rfProject, extendsNotImplements)) {
                classParent.fClass = null;
                return;
            }
            classParent.fClass = parentCandidate;
            this.hasAncestorWithParametricDependency |= parametricDependency.value >= 7 | classParent.fClass.hasAncestorWithParametricDependency;
            if (classParent.fParameter == null) {
                this.checkDefBeforeUse(new int[1], this, rfProject, declaration, parserPath, classParent.fDataType, parentCandidate);
            }
            if (extendsNotImplements && classParent.fClass != null && classParent.fConstructorCall == null && classParent.fArguments != null && !classParent.fArguments.isEmpty() && (constructor = classParent.fClass.getConstructorWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null) {
                int line5 = classParent.fDataType.getLine();
                startOffset = classParent.fDataType.getOffset();
                HidOccurrence occurrence = new HidOccurrence(startOffset, -1, line5, 0L, null);
                RfHid hid = STransformer.makeStandInHid(classParent.fClass.getName(), constructor, occurrence, 0L);
                if (hid != null) {
                    hid.setElement(constructor);
                    RfHidAccessArgs accessArgs = STransformer.makeStandInAccessArgs(hid, classParent.fArguments);
                    if (accessArgs != null) {
                        classParent.fConstructorCall = accessArgs;
                        if (!HidUtils.isResolved((IHidObject)classParent.fArguments.get(0))) {
                            ConfigInfo configInfo = new ConfigInfo(incrementalAddedTypeNames != null, rfProject, this.getEnclosingLibrary(), true, rfProject.getToolCompat());
                            accessArgs.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), this, constructor, parserPath, typesResolver, null, (byte)3, false, true, false);
                            SEvaluator.INSTANCE.calculateMethodCall(configInfo, accessArgs, this, true);
                        }
                    }
                }
            }
            if (this.checkCircularInheritance(rfProject, this, this, false)) {
                classParent.fClass = CIRCULAR_INHERITANCE;
                return;
            }
            try {
                String name;
                if (extendsNotImplements && classParent.fClass != null && !this.fIsInterfaceClass && classParent.fClass.fIsInterfaceClass) {
                    name = classParent.fClass.getName();
                    int line6 = classParent.fDataType.getLine();
                    startOffset = classParent.fDataType.getOffset();
                    int endOffset5 = startOffset + name.length();
                    HashMap<String, Object> attributes5 = new HashMap<String, Object>(4);
                    attributes5.put("QUICKFIX_ELEMENT_NAME", name);
                    attributes5.put("QUICKFIX_KIND", 58);
                    rfProject.addSemanticError(1, "EXTEND_INTERFACE_CLASS: Extending interface class ''{0}'' by non-interface class not allowed", this.getLibPkgScope(), startOffset, endOffset5, attributes5, line6, parserPath, name);
                }
                if (!(extendsNotImplements || classParent.fClass == null || this.fIsInterfaceClass || classParent.fClass.fIsInterfaceClass)) {
                    name = classParent.fClass.getName();
                    int line7 = classParent.fDataType.getLine();
                    startOffset = classParent.fDataType.getOffset();
                    int endOffset6 = startOffset + name.length();
                    HashMap<String, Object> attributes6 = new HashMap<String, Object>(4);
                    attributes6.put("QUICKFIX_ELEMENT_NAME", name);
                    attributes6.put("QUICKFIX_KIND", 59);
                    rfProject.addSemanticError(1, "IMPLEMENT_CLASS: Implementing non-interface class ''{0}'' by class not allowed", this.getLibPkgScope(), startOffset, endOffset6, attributes6, line7, parserPath, name);
                }
            }
            catch (BuildCancelException buildCancelException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("DEBUG: " + e.getClass().getSimpleName() + " when resolving class parent for '" + this.printScope() + this.getName() + "' at line " + this.getLine() + " in file " + this.getFile().getParserPath());
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (classParent != null) {
                    classParent.fClass = null;
                }
                this.fSuper = null;
            }
        }
        finally {
            if (isGeneric) {
                typesResolver.removeVisitedElement(this);
            }
            if (classParent != null && classParent.fClass != prevExtendedClass) {
                if (prevExtendedClass != null) {
                    prevExtendedClass.getGenericClass().removeChild(this.getGenericClass());
                }
                if (classParent.fClass != null && classParent.fClass.getGenericClass() != CIRCULAR_INHERITANCE) {
                    boolean isComplete = this.isComplete();
                    RfClass genericParent = classParent.fClass.getGenericClass();
                    RfClass generic = this.getGenericClass();
                    genericParent.addChild(generic);
                    if ((genericParent != classParent.fClass || generic != this) && isComplete) {
                        classParent.fClass.addChild(this);
                    }
                    if (!hasTypeAliasParent && classParent.fParameter == null && (isComplete || this == generic)) {
                        ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, true, rfProject.getToolCompat());
                        RfAssociatedType.checkParamValues(classParent.fDataType, classParent.fClass, genericParent, null, true, this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER), this.getLibPkgScope(), this.getFile(), (ObjectSet<IRfNamedElement>)new ObjectOpenHashSet(), rfProject, configInfo);
                    }
                }
            }
        }
    }

    @Override
    public final IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (!this.fIsInterfaceClass && (classes == null || classes.contains(RfField.class))) {
            if ("super".equals(name)) {
                return this.getSuperImplicitVariable(name, 1);
            }
            if ("this".equals(name)) {
                return this.getThisImplicitVariable(name, 1);
            }
        }
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
        if (skipParents) {
            return result;
        }
        if (!(result == null || result == exclude || exclude instanceof RfFunction && result instanceof RfFunction || exclude instanceof RfConstraint && result instanceof RfConstraint)) {
            return result;
        }
        if (this.fExtendedType != null && this.fExtendedType.fClass != null) {
            result = this.fExtendedType.fClass.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
            if (visited != null) {
                visited.remove(this.fExtendedType.fClass);
            }
            if (!(result == null || result == exclude || exclude instanceof RfFunction && result instanceof RfFunction || exclude instanceof RfConstraint && result instanceof RfConstraint)) {
                return result;
            }
        }
        if (this.fImplementedTypes != null && !this.fImplementedTypes.isEmpty()) {
            for (ClassParent implementedType : this.fImplementedTypes) {
                if (implementedType.fClass == null) continue;
                result = implementedType.fClass.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
                if (visited != null) {
                    visited.remove(implementedType.fClass);
                }
                if (result == null || result == exclude || exclude instanceof RfFunction && result instanceof RfFunction || exclude instanceof RfConstraint && result instanceof RfConstraint) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public boolean hasLocalMembers() {
        return true;
    }

    protected RfNamedElement getCircularInheritanceUsage() {
        return this;
    }

    public final void checkCircularInheritence(RfProject rfProject) {
        this.checkCircularInheritance(rfProject, this, this, true);
    }

    private boolean checkCircularInheritance(RfProject rfProject, RfClass startClazz, RfClass clazz, boolean reportError) {
        if (rfProject == null || clazz == null) {
            return false;
        }
        RfClass parent = clazz.fExtendedType == null ? null : clazz.fExtendedType.fClass;
        RfNamedElement usageElement = startClazz.getCircularInheritanceUsage();
        if (parent != null && this.checkCircularInheritence(rfProject, startClazz, parent, usageElement, reportError)) {
            return true;
        }
        if (clazz.fIsInterfaceClass && clazz.fImplementedTypes != null && !clazz.fImplementedTypes.isEmpty()) {
            for (ClassParent implementedType : clazz.fImplementedTypes) {
                parent = implementedType.fClass;
                if (!this.checkCircularInheritence(rfProject, startClazz, parent, usageElement, reportError)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkCircularInheritence(RfProject rfProject, RfClass startClazz, RfClass parent, RfNamedElement usageElement, boolean reportError) {
        if (parent == null) {
            return false;
        }
        boolean areEqual = startClazz.equals(parent);
        if (!reportError && areEqual) {
            return true;
        }
        boolean shouldSignalError = !startClazz.hasCircularInheritance && (usageElement != parent.getCircularInheritanceUsage() || parent.getClass() == RfClass.class);
        boolean isCircularParent = parent.getGenericClass() == CIRCULAR_INHERITANCE || parent.getGenericClass() == CIRCULAR_ASSIGN_OR_INSTANCE;
        RfDefElement declaration = null;
        if (parent.getExtendedParameter() != null || this instanceof RfSpecializedClass) {
            startClazz.hasCircularInheritance |= isCircularParent;
        }
        if (reportError && shouldSignalError && isCircularParent && usageElement != null && (declaration = usageElement.getDeclaration()) != null) {
            DataType dataType = usageElement instanceof RfAssociatedType ? ((RfAssociatedType)usageElement).getDataType() : null;
            int line = dataType != null ? dataType.getLine() : declaration.getStartLine();
            int startOffset = dataType != null ? dataType.getOffset() : declaration.getStartOffset();
            String name = startClazz.getName();
            int endOffset = startOffset + name.length();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", name);
            attributes.put("QUICKFIX_KIND", 23);
            rfProject.addSemanticError(1, "CIRCULAR_INHERITANCE: Class ''{0}'' extends itself", usageElement.getLibPkgScope(), startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
            return true;
        }
        return areEqual || isCircularParent || this.checkCircularInheritance(rfProject, startClazz, parent, reportError);
    }

    private boolean shouldIncrementalRecompute(HashSet<String> incrementalAddedTypeNames, String className, String extendName, boolean forceRecomputeOnImportChanged) {
        if (forceRecomputeOnImportChanged) {
            return true;
        }
        if (incrementalAddedTypeNames == null) {
            return true;
        }
        if (incrementalAddedTypeNames.contains(className)) {
            return true;
        }
        return incrementalAddedTypeNames.contains(extendName);
    }

    private boolean recursiveParamsCheck(List<DataType> params, RfProject rfProject, boolean extendsNotImplements) {
        if (params == null || params.isEmpty()) {
            return true;
        }
        RfNamedElement paramScope = this;
        for (DataType param : params) {
            int dotPosition;
            if (param.fOrderedParamAssignments == null || param.fOrderedParamAssignments.isEmpty()) {
                return true;
            }
            String paramName = param.fType;
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath = declaration == null ? null : declaration.getParserPath();
            int line = param.getLine();
            int startOffset = param.getOffset();
            DataType packageScope = param.fPackageScope;
            if (packageScope != null) {
                HashSet<RfClass> visited = new HashSet<RfClass>();
                visited.add(this);
                paramScope = this.getPackageOrClassScope(packageScope.getType());
                if (paramScope == null) {
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    attributes.put("QUICKFIX_ELEMENT_NAME", paramName);
                    attributes.put("QUICKFIX_KIND", extendsNotImplements ? 20 : 21);
                    int endOffset = startOffset + paramName.length();
                    if (extendsNotImplements) {
                        rfProject.addSemanticError(1, "EXTEND_CLASS: Extending non existing class ''{0}''", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, paramName);
                    } else {
                        rfProject.addSemanticError(1, "IMPLEMENT_INTERFACE_CLASS: Implementing non existing interface class ''{0}''", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, paramName);
                    }
                    this.fSuper = null;
                    return false;
                }
            }
            RfMembersHolder candidate = null;
            int n = dotPosition = paramName.startsWith("enum/") || paramName.startsWith("struct/") || paramName.startsWith("union/") ? -1 : paramName.indexOf(46);
            if (paramScope instanceof RfNamedElement && dotPosition != -1 && dotPosition + 1 < paramName.length()) {
                String interfaceName = paramName.substring(0, dotPosition);
                candidate = ((RfNamedElement)paramScope).getInterfaceWithPrefix(interfaceName, 1, 3);
                if (candidate != null) {
                    String modportName = paramName.substring(dotPosition + 1);
                    candidate = candidate.getModportWithPrefix(modportName, 1, 1);
                }
            } else if (paramScope instanceof RfNamedElement && param.isVirtualInterface()) {
                candidate = ((RfNamedElement)paramScope).getInterfaceWithPrefix(paramName, 1, 3);
            } else {
                boolean isTypeParameter;
                candidate = paramScope.getMember(paramName, DVTRfUtils.MEMBERS_TYPES_NO_TYPE_ALIAS, null, packageScope == null, true, false, true, false);
                boolean bl = isTypeParameter = candidate instanceof RfField && ((RfField)((Object)candidate)).isTypeParameter();
                if (candidate == null || !isTypeParameter) {
                    candidate = paramScope.getMember(paramName, DVTRfUtils.MEMBERS_TYPES, null, packageScope == null, true, true, true, false);
                }
            }
            if (candidate == null) {
                String typeName = param.getTypeName("logic", null);
                int endOffset = startOffset + typeName.length();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", packageScope);
                attributes.put("QUICKFIX_KIND", 10);
                rfProject.addSemanticError(1, "NON_EXISTING_TYPE: Non existing type ''{0}''", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, typeName);
                return false;
            }
            this.recursiveParamsCheck(param.fOrderedParamAssignments, rfProject, extendsNotImplements);
        }
        return true;
    }

    private final void addChild(RfClass clazz) {
        if (clazz == null || clazz == this) {
            return;
        }
        if (this.fChildren == null) {
            this.fChildren = new LinkedHashSet();
        }
        this.fChildren.add(clazz);
    }

    protected final void removeChild(RfClass clazz) {
        if (this.fChildren == null) {
            return;
        }
        this.fChildren.remove(clazz);
    }

    public final boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public Set<RfClass> getChildren() {
        return this.fChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RfSpecializedClass addSpecialization(RfSpecializedClass specialization) {
        if (this.isPredefined()) {
            return null;
        }
        RfClass rfClass = this;
        synchronized (rfClass) {
            if (this.specializations == null) {
                this.specializations = new BaseLinkedHSet<RfSpecializedClass>(16){
                    private static final long serialVersionUID = 1L;

                    public int hash(Object key) {
                        if (key == null) {
                            return 0;
                        }
                        int hash = ((RfSpecializedClass)key).hashCodeSpecialized();
                        return hash ^ hash >>> 16;
                    }
                };
            }
            return this.specializations.putIfAbsent(specialization, specialization);
        }
    }

    @Override
    public final void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        this.portListParametersCount = -1;
        this.hasCircularInheritance = false;
        if (this.cachedElabConstantDefaultExpressions != null) {
            this.cachedElabConstantDefaultExpressions.clear();
        }
        this.cachedElabConstantDefaultExpressions = null;
        this.cachedElabConstants = null;
        super.removeDef(incrementalDeltaContainer, def);
    }

    @Deprecated
    protected final void cleanupSpecializations() {
        if (this.specializations == null) {
            return;
        }
        Iterator<RfSpecializedClass> iterator = this.specializations.keySet().iterator();
        while (iterator.hasNext()) {
            RfClass specializedClass = iterator.next();
            if (((RfSpecializedClass)specializedClass).getLastExistingSpecializedOccurrenceDeclaration() != null || specializedClass == this.getDefaultSpecialization(null)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeSpecialization(RfSpecializedClass specialization) {
        if (this.specializations == null || specialization.getGenericClass() != this) {
            return;
        }
        RfClass rfClass = this;
        synchronized (rfClass) {
            this.specializations.remove(specialization);
        }
    }

    public final Set<RfSpecializedClass> getSpecializations() {
        if (this.specializations == null) {
            return null;
        }
        this.cleanupSpecializations();
        return this.specializations.keySet();
    }

    @Override
    public final List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public final RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public final List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public final RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    protected final <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        boolean equals = (matchType & 1) != 0;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        if ((equals || first) && size > 0 || limit100 && size >= 100) {
            return;
        }
        if (localMembersKind == RfTypeAlias.class && local >= 2) {
            List<RfClass> parentInterfaces;
            RfClass parent = this;
            if ((parent = parent.getParent()) != null && visited != null && !visited.contains(parent)) {
                visited.add(parent);
                parent.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier == IRfNamedElement.AccessModifier.SHOW_PUBLIC ? IRfNamedElement.AccessModifier.SHOW_PUBLIC : IRfNamedElement.AccessModifier.SHOW_PROTECTED, imported);
            }
            if ((parentInterfaces = this.getParentInterfaces()) != null && visited != null && !visited.contains(parent)) {
                for (RfClass parentInterface : parentInterfaces) {
                    visited.add(parentInterface);
                    parentInterface.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier == IRfNamedElement.AccessModifier.SHOW_PUBLIC ? IRfNamedElement.AccessModifier.SHOW_PUBLIC : IRfNamedElement.AccessModifier.SHOW_PROTECTED, imported);
                }
            }
        }
    }

    @Override
    public final List<RfFunction> getConstructorsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        if (this.fIsInterfaceClass) {
            return new NullProtectedList<RfFunction>();
        }
        LinkedHashMap<String, RfFunction> resultMap = new LinkedHashMap<String, RfFunction>();
        Set<IRfNamedElement> visitedImports = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visitedImports, resultMap, RfFunction.class, 3, RfProject.fConstructorValidator, false, matchType, prefix, -1, local, accessModifier, false);
        if (resultMap.isEmpty() && DVTStringUtil.regionMatches((String)"new", (String)prefix, (int)matchType)) {
            resultMap.put("new", this.getImplicitConstructor());
        }
        return new NullProtectedList<RfFunction>((Collection<RfFunction>)resultMap.values());
    }

    @Override
    public final RfFunction getConstructorWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        if (this.fIsInterfaceClass) {
            return null;
        }
        HashMap<String, RfFunction> resultMap = new HashMap<String, RfFunction>(1);
        Set<IRfNamedElement> visitedImports = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visitedImports, resultMap, RfFunction.class, 3, RfProject.fConstructorValidator, true, matchType, prefix, -1, local, accessModifier, false);
        if (resultMap.isEmpty() && DVTStringUtil.regionMatches((String)"new", (String)prefix, (int)matchType)) {
            resultMap.put("new", this.getImplicitConstructor());
        }
        return resultMap.isEmpty() ? null : (RfFunction)resultMap.values().iterator().next();
    }

    private RfFunction getImplicitConstructor() {
        if (this.fImplicitConstructor == null) {
            this.fImplicitConstructor = new RfPredefinedFunction("new", new DataType(this.getName()), null, 2, "Implicit constructor");
            this.fImplicitConstructor.setEnclosingScope(this);
        }
        return this.fImplicitConstructor;
    }

    public final boolean isSubClass(RfClass ancestorClass) {
        return this.isSubClass(ancestorClass, false, true);
    }

    public final boolean isSubClass(RfClass ancestorClass, boolean exitIfUnknownHierarchy, boolean strictEqual) {
        if (ancestorClass == null) {
            return false;
        }
        if ((ancestorClass = ancestorClass.getGenericClass()) == null) {
            return false;
        }
        boolean ancestorIsInterfaceClass = ancestorClass.isInterfaceClass();
        RfClass parent = this;
        do {
            boolean isEqual;
            parent = parent.getGenericClass();
            boolean bl = strictEqual ? parent == ancestorClass : (isEqual = parent.equals(ancestorClass));
            if (isEqual) {
                return true;
            }
            if (exitIfUnknownHierarchy && (parent.getExtendedParameter() != null || parent.getParent() == null && parent.hasExtend())) {
                return true;
            }
            if (!ancestorIsInterfaceClass || !parent.implementsInterfaceClass(ancestorClass, exitIfUnknownHierarchy, strictEqual)) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    private boolean implementsInterfaceClass(RfClass ancestorInterfaceClass, boolean exitIfUnknownHierarchy, boolean strictEqual) {
        if (ancestorInterfaceClass == null) {
            return false;
        }
        List<RfClass> parentInterfaces = this.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return exitIfUnknownHierarchy && this.hasImplements();
        }
        for (RfClass parentInterface : parentInterfaces) {
            boolean isEqual;
            parentInterface = parentInterface.getGenericClass();
            boolean bl = strictEqual ? ancestorInterfaceClass == parentInterface : (isEqual = ancestorInterfaceClass.equals(parentInterface));
            if (isEqual) {
                return true;
            }
            if (exitIfUnknownHierarchy && (parentInterface.getExtendedParameter() != null || parentInterface.getParent() == null && parentInterface.hasExtend())) {
                return true;
            }
            if (!parentInterface.implementsInterfaceClass(ancestorInterfaceClass, exitIfUnknownHierarchy, strictEqual)) continue;
            return true;
        }
        return false;
    }

    public final boolean isChildOf(String prefix, boolean equals) {
        return this.isSubClass(prefix, equals);
    }

    public final boolean isSubClass(String prefix, boolean equals) {
        if (prefix == null) {
            return false;
        }
        RfClass parent = this;
        while (parent != null) {
            if (equals ? prefix.equals(parent.getName()) : parent.getName() != null && parent.getName().startsWith(prefix)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public final MacroCallInfo getMacroCallInfo() {
        return this.fMacroCallInfo;
    }

    public final void setMacroCallInfo(MacroCallInfo macroCalls) {
        this.fMacroCallInfo = macroCalls;
    }

    public boolean hasExtend() {
        return this.fExtendedType != null;
    }

    public final DataType getExtendedType() {
        return this.fExtendedType == null ? null : this.fExtendedType.fDataType;
    }

    public final RfField getExtendedParameter() {
        return this.fExtendedType == null ? null : this.fExtendedType.fParameter;
    }

    public final List<IHidObject> getExtendedArguments() {
        return this.fExtendedType == null ? null : this.fExtendedType.fArguments;
    }

    public final RfHidAccessArgs getExtendedConstructorCall() {
        return this.fExtendedType == null ? null : this.fExtendedType.fConstructorCall;
    }

    public final boolean hasCompleteParent() {
        return this.fExtendedType != null && this.fExtendedType.isComplete();
    }

    public final List<DataType> getImplementedTypes() {
        if (this.fImplementedTypes == null || this.fImplementedTypes.isEmpty()) {
            return null;
        }
        ArrayList<DataType> result = new ArrayList<DataType>(this.fImplementedTypes.size());
        for (ClassParent implementedType : this.fImplementedTypes) {
            if (implementedType.fDataType == null) continue;
            result.add(implementedType.fDataType);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public final boolean hasCompleteImplements() {
        if (this.fImplementedTypes == null || this.fImplementedTypes.isEmpty()) {
            return true;
        }
        for (ClassParent implementedType : this.fImplementedTypes) {
            if (implementedType.isComplete()) continue;
            return false;
        }
        return true;
    }

    public final void setParentTypes(DataType extendedType, List<DataType> implementedTypes, List<IHidObject> arguments, IncrementalDeltaContainer delta) {
        if (this.fExtendedType == null && extendedType == null) {
            this.fExtendedType = null;
            this.fSuper = null;
        } else if (this.fExtendedType != null && extendedType == null) {
            if (this.fExtendedType.fClass != null) {
                this.fExtendedType.fClass.removeChild(this);
            }
            this.fExtendedType = null;
            this.fSuper = null;
            if (delta != null) {
                delta.changedClassParent(this);
            }
        } else if (this.fExtendedType == null && extendedType != null) {
            this.fExtendedType = new ClassParent(extendedType, arguments);
            if (delta != null) {
                delta.changedClassParent(this);
            }
        } else if (this.fExtendedType != null && extendedType != null) {
            DataType prevExtendType = this.fExtendedType.fDataType;
            this.fExtendedType.fDataType = extendedType;
            this.fExtendedType.fArguments = arguments;
            if (prevExtendType == null || !prevExtendType.equalsDataTypeClassParent(extendedType)) {
                if (this.fExtendedType.fClass != null) {
                    this.fExtendedType.fClass.removeChild(this);
                }
                this.fExtendedType.fClass = null;
                this.fExtendedType.fParameter = null;
                this.fExtendedType.fConstructorCall = null;
                if (delta != null) {
                    delta.changedClassParent(this);
                }
            }
        }
        if (implementedTypes == null || implementedTypes.isEmpty()) {
            this.fImplementedTypes = null;
        } else {
            this.fImplementedTypes = new ArrayList<ClassParent>();
            for (DataType implementedType : implementedTypes) {
                this.fImplementedTypes.add(new ClassParent(implementedType, null));
            }
        }
    }

    public final boolean isInterfaceClass() {
        return this.fIsInterfaceClass;
    }

    protected final DataType getTranslatedExtendedType() {
        return this.getExtendedType();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.portListParametersCount = -1;
    }

    @Override
    public final int getMemberSelect() {
        return 2;
    }

    @Override
    public final String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_CLASS: Duplicate class ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public final int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public final Image getImage() {
        if (this.fIsInterfaceClass) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
    }

    public void cleanSpecializations() {
        if (this.specializations != null) {
            this.specializations.clear();
        }
        this.specializations = null;
    }

    @Override
    public final void deepClean() {
        super.deepClean();
        this.cleanSpecializations();
        this.fExtendedType = null;
        this.fImplementedTypes = null;
        if (this.fChildren != null) {
            this.fChildren.clear();
        }
        this.fChildren = null;
        this.fThis = null;
        this.fSuper = null;
    }

    @Override
    public final IRfNamedElement semanticGetLocalMember(String prefix, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumPrefix, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (visited != null && visited.contains(this)) {
            return null;
        }
        if (!this.fIsInterfaceClass) {
            if (!recursiveCall && prefix.equals("new")) {
                RfFunction classConstructor = this.getLocalMember(RfFunction.class, prefix, false);
                classConstructor = classConstructor == null ? this.getImplicitConstructor() : classConstructor;
                return classConstructor;
            }
            if (!recursiveCall && prefix.equals("this")) {
                if (this.fThis == null) {
                    this.fThis = new RfThisImplicitVariable(this);
                }
                return this.fThis;
            }
            if (this.fExtendedType != null && this.fExtendedType.fDataType != null && !recursiveCall && prefix.equals("super")) {
                if (this.fSuper == null) {
                    this.fSuper = new RfSuperImplicitVariable(this);
                }
                return this.fSuper;
            }
        }
        return super.semanticGetLocalMember(prefix, hid, parserPath, prevScope, visited, enumPrefix, isFirst, isLast, recursiveCall);
    }

    public final boolean isChildOfClass(RfNamedElement parentCandidate) {
        if (parentCandidate instanceof RfSpecializedClass) {
            parentCandidate = ((RfSpecializedClass)parentCandidate).getGenericClass();
        }
        RfClass parent = this.getParent();
        while (parent != null) {
            if (parentCandidate == parent.getGenericClass()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public final boolean isChildOfClassOrInterface(RfNamedElement parentCandidate) {
        if (parentCandidate instanceof RfSpecializedClass) {
            parentCandidate = ((RfSpecializedClass)parentCandidate).getGenericClass();
        }
        RfClass parent = this;
        LinkedList<RfClass> candidates = new LinkedList<RfClass>();
        candidates.add(parent);
        RfClass candidate = null;
        while ((candidate = (RfClass)candidates.poll()) != null) {
            List<RfClass> parentInterfaces;
            if (parentCandidate == candidate.getGenericClass()) {
                return true;
            }
            if (candidate.getParent() != null) {
                candidates.add(candidate.getParent());
            }
            if ((parentInterfaces = candidate.getParentInterfaces()) == null) continue;
            candidates.addAll(parentInterfaces);
        }
        return false;
    }

    public final boolean isAncestorOfClassScope(IRfScopeElement potentialClassScope) {
        while (potentialClassScope instanceof RfClass) {
            if (potentialClassScope == this || ((RfClass)potentialClassScope).isChildOfClassOrInterface(this)) {
                return true;
            }
            potentialClassScope = potentialClassScope.getEnclosingScope();
        }
        return false;
    }

    public final boolean isBitStream() {
        return this.isBitStream(new HashSet<IRfNamedElement>());
    }

    public final boolean isPackedBitStream() {
        return false;
    }

    public final boolean hasParent(RfClass possible) {
        RfClass parent = this.fExtendedType == null ? null : this.fExtendedType.fClass;
        while (parent != null) {
            if (parent.getGenericClass().equals(possible)) {
                return true;
            }
            RfClass rfClass = parent = parent.fExtendedType == null ? null : parent.fExtendedType.fClass;
        }
        return false;
    }

    public RfClass getGenericClass() {
        return this;
    }

    protected void setGenericClass(RfClass genericClass) {
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getClass() == obj.getClass();
    }

    @Override
    public int hashCode() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return super.hashCode();
        }
        if (enclosingScope instanceof RfSpecializedClass) {
            enclosingScope = ((RfSpecializedClass)enclosingScope).getGenericClass();
        }
        return 31 * super.hashCode() + enclosingScope.hashCode();
    }

    public final RfForwardTypedef getTypedefDeclaration() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        RfForwardTypedef typedef = enclosingScope.getFirstLocalMember(RfForwardTypedef.class, this.getName());
        if (typedef == null) {
            return null;
        }
        if (typedef.getDeclarationIndex() < this.getDeclarationIndex()) {
            return typedef;
        }
        if (typedef.getDeclarationIndex() == this.getDeclarationIndex()) {
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null) {
                return null;
            }
            RfDefElement declaration2 = typedef.getDeclaration();
            if (declaration2 == null) {
                return null;
            }
            if (declaration2.getStartOffset() < declaration.getStartOffset()) {
                return typedef;
            }
        }
        return null;
    }

    @Override
    public final boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        if (visitor instanceof HHViewUtils.MakeWrapperVisitor) {
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath = declaration != null ? declaration.getParserPath() : null;
            visitor.setParserPath(parserPath);
            RfHidAccessArgs hidAccess = this.getExtendedConstructorCall();
            if (hidAccess != null && hidAccess.getParentHid() != null) {
                hidAccess.getParentHid().visitHidObject(rfProject, visitor);
            }
        }
        return super.visitHidObject(rfProject, visitor);
    }

    public final boolean xIsNullableXValueHolder() {
        return true;
    }

    public final boolean xIsClass(boolean resolveTypeAlias) {
        return true;
    }

    public final boolean xShouldBeSpecializedClass(boolean resolveTypeAlias) {
        return this.shouldBeSpecialized();
    }

    public final boolean xCanCastTo(IRfNamedElement namedElement) {
        boolean isPotentialEquals;
        if (!((namedElement = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)namedElement)) instanceof RfClass)) {
            return false;
        }
        boolean bl = isPotentialEquals = this.getGenericClass() == ((RfClass)namedElement).getGenericClass();
        if (!isPotentialEquals) {
            return this.isChildOfClassOrInterface((RfClass)namedElement);
        }
        return this.equals(namedElement);
    }

    public final RfFunction xGetConstructor() {
        RfFunction member = this.getLocalMember(RfFunction.class, "new", true);
        if (member != null) {
            return member;
        }
        return this.getImplicitConstructor();
    }

    public IRfClassElement xGetParent() {
        return this.getParent();
    }

    public final DataType xGetParentDataType() {
        return this.fExtendedType == null ? null : this.fExtendedType.fDataType;
    }

    @Override
    public final void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        RfClass parent;
        DVTLinkedHashMap<String, RfNamedElement> members = this.getGenericClass().getLocalMembers(true);
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members.values()) {
                if (member.isAnonymous()) continue;
                result.add(DVTStringUtil.intern((String)member.getName()));
            }
        }
        if ((parent = this.getParent()) != null) {
            parent.xCollectMemberNames(result, false);
        }
        if (!isAddPredefined) {
            return;
        }
        result.add(DVTStringUtil.intern((String)"randomize"));
        result.add(DVTStringUtil.intern((String)"pre_randomize"));
        result.add(DVTStringUtil.intern((String)"post_randomize"));
        result.add(DVTStringUtil.intern((String)"srandom"));
        result.add(DVTStringUtil.intern((String)"get_randstate"));
        result.add(DVTStringUtil.intern((String)"set_randstate"));
        result.add(DVTStringUtil.intern((String)"constraint_mode"));
        result.add(DVTStringUtil.intern((String)"rand_mode"));
    }

    public final HidAccess xGetImplicitSuperNewCall(HidOccurrence occurrence, IHidEvaluationGuardian guardian) {
        RfClass parent = this.getParent();
        if (parent == null) {
            return null;
        }
        RfFunction constructor = parent.xGetConstructor();
        List<IRfFieldElement> arguments = constructor.getArguments();
        List<IHidObject> constructorArgs = this.getExtendedArguments();
        if (constructorArgs == null) {
            for (IRfFieldElement argument : arguments) {
                if (argument.getInitialValue(false) != null) continue;
                guardian.logError("Implicit call of super.new() with non-default arguments (explicit call required)");
                break;
            }
        } else {
            int nofSpecifiedArguments = constructorArgs.size();
            if (arguments.size() > nofSpecifiedArguments) {
                guardian.logError("Implicit call of super.new() with non-default arguments (explicit call required)");
            }
        }
        RfSuperImplicitVariable superNamedElement = this.fSuper == null ? new RfSuperImplicitVariable(this) : this.fSuper;
        RfHid superHid = STransformer.makeStandInHid("super", superNamedElement, occurrence, 0L);
        RfHid newHid = STransformer.makeStandInHid("new", constructor, occurrence, 0L);
        STransformer.makeStandInAccess(superHid, newHid, 0);
        return STransformer.makeStandInAccessArgs(newHid, constructorArgs);
    }

    public boolean xRuntimeElabMissingConstructor(XValueHolderFactory factory) {
        if (!factory.hasEncryptedCode((IRfScopeElement)this)) {
            return false;
        }
        RfClass parent = this.getParent();
        if (parent == null) {
            return false;
        }
        RfFunction thisConstructor = this.xGetConstructor();
        if (!thisConstructor.isPredefined()) {
            return false;
        }
        RfFunction superConstructor = null;
        while ((superConstructor = parent.xGetConstructor()).isPredefined() && factory.hasEncryptedCode((IRfScopeElement)parent) && (parent = parent.getParent()) != null) {
        }
        if (superConstructor.isPredefined()) {
            return false;
        }
        List<IRfFieldElement> superConstructorArgs = superConstructor.getArguments();
        return superConstructorArgs != null && !superConstructorArgs.isEmpty();
    }

    public List<IRfFieldElement> xGetRuntimeElabDummyConstructorArgs() {
        RfClass parent = this.getParent();
        if (parent == null) {
            return Collections.emptyList();
        }
        RfFunction thisConstructor = this.xGetConstructor();
        if (!thisConstructor.isPredefined()) {
            return thisConstructor.getArguments();
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return Collections.emptyList();
        }
        RfFunction superConstructor = null;
        do {
            if ((superConstructor = parent.xGetConstructor()) != null) continue;
            return Collections.emptyList();
        } while (superConstructor.isPredefined() && rfProject.xHasEncryptedCode(parent) && (parent = parent.getParent()) != null);
        List<IRfFieldElement> superArguments = superConstructor.getArguments();
        ArrayList<IRfFieldElement> thisArguments = new ArrayList<IRfFieldElement>(superArguments.size());
        for (IRfFieldElement superArgument : superArguments) {
            RfField thisArgument = new RfField((RfField)superArgument);
            thisArgument.setEnclosingScope(thisConstructor);
            IRfDefElement argDeclaration = superArgument.getDeclaration();
            thisArgument.addDeclaration(new RfFieldDef((RfFileDef)argDeclaration.getDefFile(), thisArgument.getName(), LineInfo.UNKNOWN, LineInfo.UNKNOWN, null, null));
            thisArgument.setEnclosingScope(this);
            thisArguments.add(thisArgument);
            thisConstructor.addMember(thisArgument);
        }
        return thisArguments;
    }

    public ListContainer<IHidObject> xGetRuntimeElabDummyConstructor(XValueHolderFactory factory, HidOccurrence occurrence) {
        RfClass parent = this.getParent();
        if (parent == null) {
            return ListContainer.emptyContainer();
        }
        ArrayListContainer bodyStatements = new ArrayListContainer(8);
        List<IRfFieldElement> thisArguments = this.xGetRuntimeElabDummyConstructorArgs();
        RfFunction superConstructor = parent.xGetConstructor();
        List<IRfFieldElement> superArguments = parent.xGetRuntimeElabDummyConstructorArgs();
        ArrayList<RfHidOperator> argConnections = new ArrayList<RfHidOperator>();
        int i = 0;
        while (i < thisArguments.size()) {
            IRfFieldElement thisArgument = thisArguments.get(i);
            HidOperator argDeclaration = HidEvalCenter.INSTANCE.createDeclaration(thisArgument);
            bodyStatements.add((Object)argDeclaration);
            int j = 0;
            while (j < superArguments.size()) {
                IRfFieldElement superArgument = superArguments.get(j);
                if (thisArgument.getName().equals(superArgument.getName())) {
                    RfHid formalArgHid = RfHid.create(IHidImplicitConstants.ImplicitType.IMPLICIT_CONNECTED_STRING, null, (IRfNamedElement)superArgument, occurrence, null);
                    RfHid actualArgHid = RfHid.create(thisArgument.getName(), null, (IRfNamedElement)thisArgument, occurrence, null);
                    HidOperatorOccurrence opOccurrence = new HidOperatorOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER, null);
                    RfHidOperator argConnection = RfHidOperator.create(IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ".", opOccurrence, this.getMacroZone());
                    argConnection.setLHValue((IHidObject)formalArgHid);
                    argConnection.setRHValues((ListContainer)actualArgHid);
                    argConnections.add(argConnection);
                    break;
                }
                ++j;
            }
            ++i;
        }
        RfHidAccessArgs accessArgs = new RfHidAccessArgs(Integer.MIN_VALUE, null, argConnections, null, null);
        accessArgs.setAssociatedType(parent);
        RfHid rfHidNew = RfHid.create("new", null, superConstructor, occurrence, null);
        rfHidNew.addAccess(accessArgs);
        RfHidAccess access = new RfHidAccess(0, null, null);
        access.setAssociatedType(parent);
        rfHidNew.addParentAccess(access);
        if (this.fSuper == null) {
            this.fSuper = new RfSuperImplicitVariable(this);
        }
        access.setParentHid(RfHid.create("super", null, this.fSuper, occurrence, null));
        HidOperator methodCallPlaceholder = HidEvalCenter.INSTANCE.createMethodCallPlaceholder((IHidObject)accessArgs, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine());
        bodyStatements.add((Object)methodCallPlaceholder);
        return bodyStatements;
    }

    @Override
    public final IRfMethodElement xGetLocalMethod(String name) {
        IRfMethodElement result = super.xGetLocalMethod(name);
        if ("pre_randomize".equals(name) || "post_randomize".equals(name)) {
            if (result != null && result.getDeclaration() != null) {
                return result;
            }
            return null;
        }
        return result;
    }

    public final IRfMethodElement xGetClassMethod(String name) {
        RfClass parent = this;
        do {
            IRfMethodElement result;
            if ((result = parent.xGetLocalMethod(name)) == null) continue;
            return result;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public final IRfNamedElement xGetComputedElement(IHidEvaluator enclosingOrDescendantScope, boolean isLinterStaticAnalysisMode) {
        if (!this.shouldBeSpecialized()) {
            return this;
        }
        if (enclosingOrDescendantScope == null) {
            return isLinterStaticAnalysisMode ? this : this.getDefaultSpecialization(null);
        }
        RfTypesResolver resolver = RfTypesResolver.create(enclosingOrDescendantScope, null, null, 0, false);
        RfNamedElement specialization = resolver.getSpecializedElementScope(this);
        return isLinterStaticAnalysisMode ? ((RfClass)specialization).getGenericClass() : (specialization == this ? this.getDefaultSpecialization(resolver.getHierarchyPath()) : specialization);
    }

    public RfClass getDefaultSpecialization(ElementPath hierarchyPath) {
        if (this.defaultSpecialization != null && hierarchyPath == null) {
            return this.defaultSpecialization;
        }
        ArrayDeque<RfClass> specializableClassScopes = new ArrayDeque<RfClass>(3);
        RfNamedElement scope = this.getGenericClass();
        do {
            if (!scope.shouldBeSpecialized()) continue;
            specializableClassScopes.push((RfClass)scope);
        } while ((scope = scope.getEnclosingScope()) instanceof RfClass);
        if (specializableClassScopes.isEmpty() || scope instanceof IRfDesignElement && !(scope instanceof IRfLibraryElement) && hierarchyPath == null) {
            this.defaultSpecialization = this;
            return this.defaultSpecialization;
        }
        ParametricDependency parametricDependency = new ParametricDependency(1);
        RfTypesResolver typesResolver = RfTypesResolver.create(scope, hierarchyPath, this.getRfProject().getNonELManager(), 0);
        for (RfClass specializableClassScope : specializableClassScopes) {
            scope = typesResolver.computeClass(specializableClassScope, scope, null, parametricDependency, false, false, false);
        }
        this.defaultSpecialization = (RfClass)typesResolver.getNamedElement();
        return this.defaultSpecialization;
    }

    public final String getGenericParameters2() {
        StringBuilder result = new StringBuilder();
        try {
            List<RfField> parameters = this.getLocalParameters(256);
            if (parameters != null && !parameters.isEmpty()) {
                result.append("\\<");
                int i = 0;
                while (i < parameters.size()) {
                    result.append(parameters.get(i).getName());
                    if (i < parameters.size() - 1) {
                        result.append(", ");
                    }
                    ++i;
                }
                result.append("\\>");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    public final String getReplacedParameters2() {
        RfClass parent = this.getParent();
        if (parent == null) {
            return "";
        }
        int portListParametersCount = parent.getPortListParametersCount();
        if (portListParametersCount == 0) {
            return "";
        }
        Map localElabConstantValues = parent.getLocalElabConstantValues();
        if (localElabConstantValues == null || localElabConstantValues.isEmpty()) {
            return "";
        }
        int i = 0;
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : localElabConstantValues.entrySet()) {
            IRfNamedElement namedElement;
            if (i == portListParametersCount) break;
            IELParamValue value = (IELParamValue)entry.getValue();
            String paramReplacedName = null;
            paramReplacedName = value instanceof ELParamValues.ParamValueType ? ((namedElement = ((ELParamValues.ParamValueType)value).getNamedElement()) != null ? String.valueOf((String)entry.getKey()) + " : " + namedElement.getQualifiedName(51) : (String)entry.getKey()) : String.valueOf((String)entry.getKey()) + " : " + value.toNiceString(null, -1, true, false);
            if (i++ == 0) {
                result.append("<").append(paramReplacedName);
                continue;
            }
            result.append(", ").append(paramReplacedName);
        }
        return result.append(">").toString();
    }

    public final int getUVMRegisterWidthMacroValue() {
        List<VlogMacroInfo> allMacros = this.getRfProject().getAllMacros();
        if (allMacros == null) {
            return 0;
        }
        for (VlogMacroInfo macro : allMacros) {
            List<StringReplace> replacement;
            VlogMacroText macroText = macro.getMacroText();
            if (macroText == null || !"UVM_REG_DATA_WIDTH".equals(macro.getName()) || (replacement = macroText.getReplacement()) == null || replacement.isEmpty()) continue;
            return Integer.valueOf(replacement.get(0).getString().trim());
        }
        return 0;
    }

    public final boolean isUvmTestClass() {
        RfClass parent = this.getParent();
        while (parent != null) {
            if ("uvm_pkg::uvm_test".equals(parent.getFullName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public final boolean isUvmRegClass() {
        RfClass parent = this.getParent();
        while (parent != null) {
            if ("uvm_pkg::uvm_reg".equals(parent.getFullName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public final int getBitFieldDiagramSize(ElementPath path) {
        if (!this.isUvmRegClass()) {
            return 0;
        }
        final LinkedHashSet newCalls = new LinkedHashSet();
        this.visitHidObject(null, new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                if (!(hidObject instanceof Hid)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)((Hid)hidObject));
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!"new".equals(methodCall.method.getName()) || methodCall.argumentValuesMapRaw == null || !methodCall.argumentValuesMapRaw.entrySet().stream().anyMatch(e -> e.getKey() instanceof IRfFieldElement && "n_bits".equals(((IRfFieldElement)e.getKey()).getName()))) continue;
                    newCalls.add(methodCall);
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        if (newCalls.isEmpty()) {
            int uvmRegisterDataWidth = this.getUVMRegisterWidthMacroValue();
            return uvmRegisterDataWidth > 0 ? uvmRegisterDataWidth : 32;
        }
        MethodCall constructor = (MethodCall)newCalls.iterator().next();
        Map argumentValuesMapRaw = constructor.argumentValuesMapRaw;
        Optional<Map.Entry> findFirst = argumentValuesMapRaw.entrySet().stream().filter(e -> e.getKey() != null && "n_bits".equals(((IRfFieldElement)e.getKey()).getName())).findFirst();
        IHidObject value = findFirst.isPresent() ? (IHidObject)findFirst.get().getValue() : null;
        return value instanceof IHidImplicit ? Integer.valueOf(value.toString().trim()) : 32;
    }

    public final Map<Integer, List<BitField>> getBitFields(ElementPath path, int size) {
        LinkedHashMap<Integer, List<BitField>> lanes = new LinkedHashMap<Integer, List<BitField>>();
        if (!this.isUvmRegClass()) {
            return lanes;
        }
        try {
            Map<String, String> registerFieldsNames = RfClass.getRegisterFieldNames(this);
            Set<MethodCall> configureCalls = RfClass.getRegisterConfigureCalls(this, "configure");
            LinkedList<BitField> lane = new LinkedList<BitField>();
            BitField.Color color = BitField.Color.GREEN;
            ELManager manager = new ELManager(this.getRfProject().getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
            ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
            for (MethodCall configureCall : configureCalls) {
                String bitfieldName;
                Hid parentHid;
                Hid methodHid = configureCall.getMethodHid();
                if (methodHid == null || !((parentHid = methodHid.getParentHid()) instanceof Hid) || (bitfieldName = registerFieldsNames.get(parentHid.getName())) == null) continue;
                BitField bitField = new BitField();
                for (Map.Entry argument : configureCall.argumentValuesMapRaw.entrySet()) {
                    IELParamValue evaluatedValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)argument.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)((IRfNamedElement)argument.getKey()), (boolean)true), (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN));
                    if (evaluatedValue == null) continue;
                    switch (((IRfFieldElement)argument.getKey()).getName()) {
                        case "size": {
                            bitField.setSize(evaluatedValue.intValue());
                            break;
                        }
                        case "lsb_pos": {
                            bitField.setPosition(evaluatedValue.intValue());
                            break;
                        }
                        case "access": {
                            bitField.setAccess(ELUtils.valueToString((IELParamValue)evaluatedValue).replace("\"", ""));
                            break;
                        }
                        case "volatile": {
                            bitField.setVolatile(evaluatedValue.intValue());
                            break;
                        }
                        case "reset": {
                            bitField.setResetValue(argument.getValue() instanceof IHidImplicit ? ((IHidObject)argument.getValue()).toString() : ELUtils.valueToString((IELParamValue)evaluatedValue));
                            break;
                        }
                        case "has_reset": {
                            bitField.setHasReset(evaluatedValue.intValue());
                            break;
                        }
                        case "is_rand": {
                            bitField.setRandomized(evaluatedValue.intValue());
                            break;
                        }
                        case "individually_accessible": {
                            bitField.setAccessible(evaluatedValue.intValue());
                            break;
                        }
                    }
                }
                if (bitField.getSize() == 0) continue;
                bitField.setName(bitfieldName);
                bitField.setColor(color);
                lane.add(bitField);
                color = BitField.Color.values()[(color.ordinal() + 1) % BitField.Color.values().length];
                BitField.Color color2 = color = color == BitField.Color.PADDING ? BitField.Color.RED : color;
            }
            if (!lane.isEmpty()) {
                lanes.put(0, this.addUnusedBitFields(lane, size));
            }
        }
        catch (NumberFormatException numberFormatException) {
            DVTLogger.INSTANCE.logError((Throwable)new Exception("Bitfield - Failed to determine the width for " + this.getSignature()));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return lanes;
    }

    private List<BitField> addUnusedBitFields(List<BitField> bitfields, int size) {
        if (bitfields.isEmpty()) {
            return bitfields;
        }
        LinkedList<BitField> result = new LinkedList<BitField>();
        bitfields.sort((o1, o2) -> o1.getPosition() - o2.getPosition());
        int lastPositionUsed = 0;
        int closestNextPositionUsed = 0;
        closestNextPositionUsed = bitfields.get(0).getPosition();
        if (lastPositionUsed != closestNextPositionUsed) {
            result.add(BitField.BitfieldBuilder.createUnused((int)(closestNextPositionUsed - lastPositionUsed), (int)lastPositionUsed));
        }
        int i = 0;
        while (i < bitfields.size()) {
            lastPositionUsed = 0;
            closestNextPositionUsed = 0;
            result.add(bitfields.get(i));
            if (i == bitfields.size() - 1) {
                lastPositionUsed = bitfields.get(bitfields.size() - 1).getPosition() + bitfields.get(bitfields.size() - 1).getSize();
                closestNextPositionUsed = size;
            } else {
                lastPositionUsed = bitfields.get(i).getPosition() + bitfields.get(i).getSize();
                closestNextPositionUsed = bitfields.get(i + 1).getPosition();
            }
            if (lastPositionUsed != closestNextPositionUsed) {
                result.add(BitField.BitfieldBuilder.createUnused((int)(closestNextPositionUsed - lastPositionUsed), (int)lastPositionUsed));
            }
            ++i;
        }
        return result;
    }

    public static Set<MethodCall> getRegisterConfigureCalls(IRfNamedElement registerClass, final String methodName) {
        final LinkedHashSet<MethodCall> configureCalls = new LinkedHashSet<MethodCall>();
        registerClass.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                if (!(hidObject instanceof Hid)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)((Hid)hidObject));
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!methodName.equals(methodCall.method.getName())) continue;
                    configureCalls.add(methodCall);
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        return configureCalls;
    }

    private static Map<String, String> getRegisterFieldNames(IRfNamedElement registerClass) {
        final HashMap<String, String> registerFieldsNames = new HashMap<String, String>();
        registerClass.visitHidObject(null, (IHidVisitor)new IHidVisitor<IHidOperator>(){

            public boolean visit(IHidOperator hidOperator) {
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                if (!(hidOperator.getLHValue() instanceof IHid)) {
                    return true;
                }
                ListContainer rhValues = hidOperator.getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    return true;
                }
                List asList = OptimizedUtils.asList((ListContainer)rhValues, (boolean)false);
                ArrayList flattenToHids = new ArrayList(HidUtils.flattenToHids((List)asList, (Set)HidFlatteningOption.NONE_EXCLUDED));
                if (flattenToHids.size() == 3) {
                    IHid potentialCreateCall = (IHid)flattenToHids.get(0);
                    IRfNamedElement functionElement = potentialCreateCall.getElement();
                    if (functionElement == null || !"create".equals(functionElement.getName()) && !"new".equals(functionElement.getName())) {
                        return true;
                    }
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)potentialCreateCall);
                    if (methodCalls == null || methodCalls.isEmpty()) {
                        return true;
                    }
                    MethodCall methodCall = (MethodCall)methodCalls.get(0);
                    IRfNamedElement nameMember = methodCall.method.getLocalMember(null, "name", null);
                    Set nameArgumentValue = (Set)methodCall.argumentValuesMap.get(nameMember);
                    if (nameArgumentValue == null || nameArgumentValue.isEmpty()) {
                        return true;
                    }
                    for (IHid value : nameArgumentValue) {
                        registerFieldsNames.put(((IHid)hidOperator.getLHValue()).getName(), value.getName().replace("\"", ""));
                    }
                } else {
                    registerFieldsNames.put(((IHid)hidOperator.getLHValue()).getName(), ((IHid)hidOperator.getLHValue()).getName());
                }
                return true;
            }

            public Class<IHidOperator> getType() {
                return IHidOperator.class;
            }
        });
        return registerFieldsNames;
    }

    public final IBitFieldRegister.BitFieldKind getBitFieldKind() {
        return IBitFieldRegister.BitFieldKind.VLOG_UVM_REG;
    }

    public final String getBitFieldDiagramHeader() {
        return "Bit Fields of UVM register";
    }

    public final String computeXVMFactoryRegisterId() {
        Collection<? extends IRfNamedElement> xGetLocalMembers = this.xGetLocalMembers();
        if (xGetLocalMembers == null || xGetLocalMembers.isEmpty()) {
            return null;
        }
        List collect = xGetLocalMembers.stream().filter(member -> member instanceof RfField && "type_name".equals(member.getName())).collect(Collectors.toList());
        for (IRfNamedElement rfNamedElement : collect) {
            if (!((RfField)rfNamedElement).isMacroDefinedTypeNameField()) continue;
            String initialValue = ((IRfFieldElement)rfNamedElement).getInitialValue(false);
            if (initialValue == null || "".equals(initialValue)) {
                return this.getName();
            }
            if (initialValue.length() <= 2) {
                return this.getName();
            }
            return initialValue.substring(1, initialValue.length() - 1);
        }
        return this.getName();
    }

    public boolean xHasParent(String possible) {
        RfClass parent = this.fExtendedType == null ? null : this.fExtendedType.fClass;
        while (parent != null) {
            if (parent.getGenericClass().getName().equals(possible)) {
                return true;
            }
            RfClass rfClass = parent = parent.fExtendedType == null ? null : parent.fExtendedType.fClass;
        }
        return false;
    }

    public void getChildrenRecursive(Set<RfClass> result) {
        if (!this.hasChildren()) {
            return;
        }
        for (RfClass child : this.getChildren()) {
            result.add(child);
            child.getChildrenRecursive(result);
        }
    }

    private void cacheElabConstants() {
        DVTLinkedHashMap<String, RfNamedElement> members;
        boolean[] hasSortedConstants;
        ArrayList<RfField> elabConstants;
        int elabConstantsCount;
        Map<String, RfNamedElement> enumValueNames;
        Set<String> parameterNames;
        block22: {
            block24: {
                block23: {
                    parameterNames = this.getParamNames();
                    enumValueNames = this.getEnumNames();
                    elabConstantsCount = (parameterNames != null ? parameterNames.size() : 0) + (enumValueNames != null ? enumValueNames.size() : 0);
                    elabConstants = new ArrayList<RfField>(elabConstantsCount);
                    hasSortedConstants = new boolean[]{true};
                    this.portListParametersCount = 0;
                    members = this.getLocalMembers(true);
                    if (members != null) break block22;
                    if (elabConstants.isEmpty()) break block23;
                    if (!hasSortedConstants[0]) {
                        Collections.sort(elabConstants, (leftLC, rightLC) -> leftLC == rightLC ? 0 : (leftLC.isDeclaredBefore(this.getRfProject(), (RfNamedElement)rightLC) ? -1 : 1));
                    }
                    this.cachedElabConstants = OptimizedUtils.listContainerCreate(elabConstants, (boolean)true);
                    break block24;
                }
                this.cachedElabConstants = ListContainer.emptyContainer();
            }
            return;
        }
        try {
            for (RfNamedElement member : members) {
                if (member instanceof RfField && ((RfField)member).isElabConstant()) {
                    this.portListParametersCount += ((RfField)member).isInParameterPortList() ? 1 : 0;
                    if (hasSortedConstants[0] && !elabConstants.isEmpty()) {
                        hasSortedConstants[0] = RfUtils.internalFastCheckIsSorted(elabConstants.get(elabConstants.size() - 1), member);
                    }
                    elabConstants.add((RfField)member);
                    continue;
                }
                if (member instanceof RfDuplicate) {
                    Collection<RfNamedElement> duplicateMembers = member.getMembers();
                    if (duplicateMembers == null) continue;
                    for (RfNamedElement duplicateMember : duplicateMembers) {
                        if (!(duplicateMember instanceof RfField) || !((RfField)duplicateMember).isElabConstant()) continue;
                        this.portListParametersCount += ((RfField)duplicateMember).isInParameterPortList() ? 1 : 0;
                        if (hasSortedConstants[0] && !elabConstants.isEmpty()) {
                            hasSortedConstants[0] = RfUtils.internalFastCheckIsSorted(elabConstants.get(elabConstants.size() - 1), member);
                        }
                        elabConstants.add((RfField)duplicateMember);
                    }
                    continue;
                }
                if (member instanceof RfTypeAlias) {
                    member = ((RfTypeAlias)member).getAssociatedTypeNoParams2();
                }
                if (!(member instanceof RfStruct)) continue;
                RfClass.cacheEnumElements((RfStruct)member, elabConstants, hasSortedConstants);
            }
        }
        catch (Throwable throwable) {
            if (!elabConstants.isEmpty()) {
                if (!hasSortedConstants[0]) {
                    Collections.sort(elabConstants, (leftLC, rightLC) -> leftLC == rightLC ? 0 : (leftLC.isDeclaredBefore(this.getRfProject(), (RfNamedElement)rightLC) ? -1 : 1));
                }
                this.cachedElabConstants = OptimizedUtils.listContainerCreate(elabConstants, (boolean)true);
            } else {
                this.cachedElabConstants = ListContainer.emptyContainer();
            }
            throw throwable;
        }
        if (!elabConstants.isEmpty()) {
            if (!hasSortedConstants[0]) {
                Collections.sort(elabConstants, (leftLC, rightLC) -> leftLC == rightLC ? 0 : (leftLC.isDeclaredBefore(this.getRfProject(), (RfNamedElement)rightLC) ? -1 : 1));
            }
            this.cachedElabConstants = OptimizedUtils.listContainerCreate(elabConstants, (boolean)true);
        } else {
            this.cachedElabConstants = ListContainer.emptyContainer();
        }
        if (elabConstantsCount > 0) {
            List<? extends HidOperatorWrapper> assignWrappers = this.getSortedAssignsToComputeConstants(false);
            if (assignWrappers != null) {
                this.cachedElabConstantDefaultExpressions = new HashMap<String, IHidObject>(elabConstantsCount);
                for (HidOperatorWrapper assignWrapper : assignWrappers) {
                    HidOperator operator = (HidOperator)assignWrapper.hidObject;
                    String name = ((IHid)operator.getLHValue()).getName();
                    if ((parameterNames == null || !parameterNames.contains(name)) && (enumValueNames == null || !enumValueNames.containsKey(name))) continue;
                    this.cachedElabConstantDefaultExpressions.put(name, operator.getFirstRHValue());
                }
            } else {
                this.cachedElabConstantDefaultExpressions = Collections.emptyMap();
            }
        } else {
            this.cachedElabConstantDefaultExpressions = Collections.emptyMap();
        }
    }

    private static final void cacheEnumElements(RfStruct source, ArrayList<RfField> elabConstants, boolean[] hasSortedConstants) {
        DVTLinkedHashMap<String, RfNamedElement> members = source.getLocalMembers(true);
        if (members == null) {
            return;
        }
        for (RfNamedElement member : members) {
            if (member instanceof RfField && ((RfField)member).isEnumElement()) {
                if (hasSortedConstants[0] && !elabConstants.isEmpty()) {
                    hasSortedConstants[0] = RfUtils.internalFastCheckIsSorted(elabConstants.get(elabConstants.size() - 1), member);
                }
                elabConstants.add((RfField)member);
                continue;
            }
            if (member instanceof RfDuplicate) {
                Collection<RfNamedElement> duplicateMembers = member.getMembers();
                if (duplicateMembers == null) continue;
                for (RfNamedElement duplicateMember : duplicateMembers) {
                    if (!(duplicateMember instanceof RfField) || !((RfField)duplicateMember).isEnumElement()) continue;
                    if (hasSortedConstants[0] && !elabConstants.isEmpty()) {
                        hasSortedConstants[0] = RfUtils.internalFastCheckIsSorted(elabConstants.get(elabConstants.size() - 1), duplicateMember);
                    }
                    elabConstants.add((RfField)duplicateMember);
                }
                continue;
            }
            if (member instanceof RfTypeAlias) {
                member = ((RfTypeAlias)member).getAssociatedTypeNoParams2();
            }
            if (!(member instanceof RfStruct)) continue;
            RfClass.cacheEnumElements((RfStruct)member, elabConstants, hasSortedConstants);
        }
    }

    public boolean hasOnlyDefaultSpecialization() {
        RfNamedElement scope = this.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfInstanceHolder && !(scope instanceof RfLibrary) || !(scope instanceof RfClass)) break;
            if (scope.hasAnyElabConstant()) {
                return !((RfClass)scope).hasPortListParameters();
            }
            scope = scope.getEnclosingScope();
        }
        return !this.hasPortListParameters() && this.hasAnyElabConstant();
    }

    public boolean shouldBeSpecialized() {
        RfNamedElement scope = this;
        do {
            if (scope.hasAnyElabConstant()) {
                return true;
            }
            if (!((scope = scope.getEnclosingScope()) instanceof RfInstanceHolder) || scope instanceof RfLibrary) continue;
            return true;
        } while (scope instanceof RfClass);
        return false;
    }

    public boolean isComplete() {
        return !this.shouldBeSpecialized();
    }

    public int getParentParametricdDependencyValue() {
        DataType extendedType = this.getExtendedType();
        if (extendedType == null) {
            return 1;
        }
        if (extendedType.fInnerClassesInfo != null && !extendedType.fInnerClassesInfo.isEmpty()) {
            extendedType = extendedType.fInnerClassesInfo.get(extendedType.fInnerClassesInfo.size() - 1);
        }
        return extendedType.getParametricDependencyValue();
    }

    public int getParentInterfaceParametricdDependencyValue(int parentIdx) {
        if (this.fImplementedTypes == null || parentIdx >= this.fImplementedTypes.size()) {
            return 1;
        }
        DataType implementedType = this.fImplementedTypes.get((int)parentIdx).fDataType;
        return implementedType == null ? 1 : implementedType.getParametricDependencyValue();
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement resolverElement = typesResolver.getSpecializedElementScope(this);
        if (resolverElement instanceof RfSpecializedClass && this.equals(((RfSpecializedClass)resolverElement).getGenericClass())) {
            ((RfSpecializedClass)resolverElement).getQualifiedName(result, typesResolver, scope, options, previous);
        } else {
            super.getQualifiedName(result, typesResolver, scope, options, previous);
        }
    }

    private static final class ClassParent
    implements Serializable {
        private static final long serialVersionUID = 2L;
        DataType fDataType;
        List<IHidObject> fArguments;
        transient RfClass fClass;
        transient RfField fParameter;
        transient RfHidAccessArgs fConstructorCall;

        ClassParent(DataType dataType, List<IHidObject> arguments) {
            this.fDataType = dataType;
            this.fArguments = arguments;
        }

        boolean isComplete() {
            return this.fClass != null || this.fParameter != null;
        }
    }
}

