/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class RfClockingBlock
extends RfMembersHolder
implements IRfClockingBlockElement {
    private static final long serialVersionUID = 1L;
    protected transient String fDefaultNetType;
    protected Set<String> fSignalNames;

    public RfClockingBlock(String name, boolean escaped, Set<String> signalNames) {
        super(name, escaped);
        this.fSignalNames = signalNames;
    }

    @Override
    public String getDefaultNetType(IRfNamedElement element) {
        if (this.fDefaultNetType != null) {
            return this.fDefaultNetType;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        this.fDefaultNetType = enclosing != null ? enclosing.getDefaultNetType(this) : "wire";
        return this.fDefaultNetType;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        if (this.hasNoDefs(false)) {
            this.fDefaultNetType = null;
        }
    }

    public void init(Set<String> signalNames) {
        this.fSignalNames = signalNames;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "clocking block: " + this.getName();
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (localMembersKind == RfField.class && localMembersSelect == 0 && local <= 2) {
            boolean strictEquals;
            boolean bl = strictEquals = matchType == 1;
            if (strictEquals) {
                if (this.hasClockingSignal(prefix)) {
                    super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                    if (result == null || result.isEmpty()) {
                        enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                    }
                }
            } else {
                super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                if (result != null && !result.isEmpty()) {
                    Iterator<Z> it = result.values().iterator();
                    while (it.hasNext()) {
                        IRfNamedElement candidate = (IRfNamedElement)it.next();
                        if (candidate.getEnclosingScope() == this || this.hasClockingSignal(candidate.getName())) continue;
                        it.remove();
                    }
                }
            }
        } else {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        }
    }

    public Set<String> getSignalNames() {
        return this.fSignalNames;
    }

    public boolean hasClockingSignal(String signalName) {
        if (this.fSignalNames == null) {
            return false;
        }
        return this.fSignalNames.contains(signalName);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_CLOCKING: Duplicate clocking block ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLOCKING);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.fSignalNames != null) {
            this.fSignalNames.clear();
        }
        this.fSignalNames = null;
    }

    public IRfInstanceElement xGetInstance() {
        RfInstance instance = RfInstance.create(this.getName(), false, new DataType(this.getName()), 0, null, null);
        instance.internalSetTransientAssociatedType(this);
        return instance;
    }

    public HidOperator xGetEventControl(IHidEvaluationGuardian guadian) {
        HidOperator eventControl = XGlobalCache.INSTANCE.getCBEventControl((IRfClockingBlockElement)this);
        if (eventControl != null) {
            return eventControl;
        }
        List<IHidOperator> clockingEvents = this.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CLOCKING_EVENT}, true);
        if (clockingEvents == null || clockingEvents.isEmpty()) {
            return null;
        }
        IHidOperator clockingEvent = clockingEvents.get(0);
        if (clockingEvent == null || !(clockingEvent.getLHValue() instanceof IHidOperator)) {
            return null;
        }
        IHidObject expr = clockingEvent.getLHValue();
        HidOperatorOccurrence occurrence = clockingEvent.getOccurrence();
        eventControl = STransformer.makeStandInOperator(expr, Collections.emptyList(), clockingEvent.getOperatorType(), clockingEvent.getOperatorKind(), clockingEvent.getOperatorText(), occurrence, HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER);
        XGlobalCache.INSTANCE.cacheCBEventControl((IRfClockingBlockElement)this, eventControl);
        return eventControl;
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VLOG_INSTANCE;
    }

    public Collection<? extends IRfInstanceElement> getLocalInstances() {
        return null;
    }

    public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        return null;
    }

    public List<? extends IRfPortElement> getLocalPorts() {
        return this.getLocalMembers(true, RfModportPort.class);
    }

    public List<? extends IRfNamedElement> getLocalParameters() {
        return null;
    }

    public List<? extends IRfNamedElement> getPortListParameters() {
        return null;
    }

    public List<? extends IRfNamedElement> getLocalElabConstants() {
        return null;
    }

    public Collection<? extends IRfFieldElement> getLocalSignals() {
        return this.getLocalMembers(true, RfModportPort.class);
    }

    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        return null;
    }

    public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfBlockElement getBlockWithPrefix(String prefix, int matchType) {
        return null;
    }
}

