/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;

public class RfClockingBlockDef
extends RfDefElement {
    private static final long serialVersionUID = 1L;
    private int relativeOffsetToLabel;
    private int relativeLineToLabel;

    public RfClockingBlockDef(RfFileDef file, WrapperInfo info) {
        super(file, info);
        if (info != null) {
            LineInfo startInfo = info.getStartInfo();
            LineInfo labelInfo = info.getLabelInfo();
            this.relativeOffsetToLabel = labelInfo == null || startInfo == null ? 0 : labelInfo.realOffset - startInfo.realOffset;
            this.relativeLineToLabel = labelInfo == null || startInfo == null ? 0 : labelInfo.line - startInfo.line;
        }
    }

    public String getInfo() {
        return this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    public int getLabelStartOffset() {
        return super.getStartOffset() + this.relativeOffsetToLabel;
    }

    public int getLabelStartLine() {
        return super.getStartLine() + this.relativeLineToLabel;
    }
}

