/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.List;
import java.util.Objects;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfComputedCovergroup
extends RfCovergroup {
    private static final long serialVersionUID = 1L;
    private RfCovergroup originalCovergroup;
    private ElementPath hierarchyPath;

    public RfComputedCovergroup(RfCovergroup genericCovergroup, RfNamedElement enclosingScope, ElementPath hierarchyPath) {
        super(genericCovergroup, enclosingScope);
        this.originalCovergroup = genericCovergroup;
        this.hierarchyPath = hierarchyPath;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.originalCovergroup.hasNoDefs(rawDefs);
    }

    @Override
    public boolean isComplete() {
        return this.hierarchyPath != null || super.isComplete();
    }

    @Override
    public RfCovergroup getOriginal() {
        return this.originalCovergroup;
    }

    public ElementPath getHierarchyPath() {
        return this.hierarchyPath;
    }

    @Override
    public RfDefElement getDeclaration() {
        return this.originalCovergroup.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return this.originalCovergroup.getDeclarations();
    }

    @Override
    public Class<? extends RfNamedElement> getCustomClass() {
        return this.originalCovergroup.getCustomClass();
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement enclosingScope;
        if (previous != null && IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
            return;
        }
        if (this.hierarchyPath != null) {
            result.append(this.hierarchyPath).append('.');
        } else if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = this.getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
        }
        result.append(this.getName());
        if (previous != null) {
            result.append(previous.isObjectStatic() ? "::" : ".");
        }
    }

    public int hashCodeComputed() {
        return Objects.hash(this.hierarchyPath, this.getEnclosingScope());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.hashCodeComputed();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfComputedCovergroup other = (RfComputedCovergroup)obj;
        return Objects.equals(this.hierarchyPath, other.hierarchyPath) && this.getEnclosingScope().equals(other.getEnclosingScope());
    }

    @Override
    public String toString() {
        return this.getQualifiedName(5);
    }
}

