/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class RfComputedListType
extends RfListType {
    private static final long serialVersionUID = 1L;
    public static final Dimension DYNAMIC_DIMENSION = new Dimension(){
        private static final long serialVersionUID = 1L;

        @Override
        public int getSize() {
            return -1;
        }

        public String toString() {
            return "";
        }
    };
    public static final Dimension QUEUE_DIMENSION = new Dimension(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isQueue() {
            return true;
        }

        @Override
        public int getSize() {
            return -1;
        }

        public String toString() {
            return "$";
        }
    };
    private static final ExpressionDimension UNDEFINED_SIZE_DIMENSION = new ExpressionDimension((IHidObject)RfHidImplicit.makeImplicit("", 0));
    private static final int[] PACKED_EMPTY = new int[0];
    private final byte packedSign;
    private final byte nofPackedDimensions;
    private final boolean isComplete;
    private boolean hasCachedHashCode;
    private int cachedHashCode;
    private int bitSize;
    private final IRfTypeElement baseElementType;
    private final Dimension[] dimensions;

    public static RfComputedListType of(RfBitVectorScalarType oneBitScalarType, int bitSize, int sign) {
        Dimension computedDimension = bitSize < 0 ? UNDEFINED_SIZE_DIMENSION : new RangeDimension(bitSize - 1, 0);
        DataType dataType = new DataType(oneBitScalarType.getName());
        dataType.appendPackedDimension(new IndexType(computedDimension.toString()));
        dataType.setSign(sign);
        return new RfComputedListType(dataType, null, oneBitScalarType, new Dimension[]{computedDimension}, 1, sign);
    }

    public static RfComputedListType of(DataType dataType, RfNamedElement occurrence, IRfTypeElement baseElementType, Dimension[] dimensions, int nofPackedDimensions, int packedSign) {
        return new RfComputedListType(dataType, occurrence, baseElementType, dimensions, nofPackedDimensions, packedSign);
    }

    protected RfComputedListType(DataType dataType, RfNamedElement occurrence, IRfTypeElement baseElementType, Dimension[] dimensions, int nofPackedDimensions, int packedSign) {
        super(dataType, occurrence);
        this.baseElementType = baseElementType;
        this.dimensions = dimensions;
        this.nofPackedDimensions = (byte)nofPackedDimensions;
        this.packedSign = (byte)packedSign;
        this.bitSize = -3;
        this.isComplete = baseElementType.isComplete() && Arrays.stream(dimensions).allMatch(Dimension::isComplete);
        this.kind = this.internalGetListKind();
    }

    @Override
    protected byte internalGetListKind() {
        Dimension dimension = this.getLastDimension();
        if (dimension == DYNAMIC_DIMENSION) {
            return 2;
        }
        if (dimension.isQueue()) {
            return 3;
        }
        if (dimension.isType() && !this.isPacked()) {
            return 4;
        }
        return 1;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean isPacked() {
        return this.nofPackedDimensions == this.dimensions.length;
    }

    @Override
    public boolean isPackedBitStream() {
        return this.isPacked();
    }

    @Override
    public boolean isBitStream() {
        if (this.isPackedBitStream()) {
            return true;
        }
        if (!this.baseElementType.isBitStream()) {
            return false;
        }
        Dimension[] dimensionArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dimension = dimensionArray[n2];
            if (dimension instanceof TypeDimension && !((TypeDimension)dimension).type.isBitStream()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasAnyDynamicDimension() {
        int idx = this.dimensions.length - 1;
        while (idx >= this.nofPackedDimensions) {
            if (this.dimensions[idx] == DYNAMIC_DIMENSION) {
                return true;
            }
            --idx;
        }
        return false;
    }

    public boolean hasAnyAssociativeDimension() {
        int idx = this.dimensions.length - 1;
        while (idx >= this.nofPackedDimensions) {
            if (this.dimensions[idx].isType()) {
                return true;
            }
            --idx;
        }
        return false;
    }

    public boolean hasAnyQueueDimension() {
        int idx = this.dimensions.length - 1;
        while (idx >= this.nofPackedDimensions) {
            if (this.dimensions[idx] == QUEUE_DIMENSION || this.dimensions[idx] instanceof BoundQueueDimension) {
                return true;
            }
            --idx;
        }
        return false;
    }

    public byte getPackedSign() {
        return this.packedSign;
    }

    public byte getSign() {
        return this.isPacked() ? this.packedSign : (byte)0;
    }

    public byte getBitState() {
        return this.isPacked() ? this.baseElementType.getBitState() : (byte)0;
    }

    public int getBitSize() {
        if (this.bitSize != -3) {
            return this.bitSize;
        }
        this.bitSize = this.baseElementType.getBitSize();
        if (this.bitSize < 0) {
            return this.bitSize;
        }
        Dimension[] dimensionArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dimension = dimensionArray[n2];
            int dimensionSize = dimension.getSize();
            this.bitSize = dimensionSize < 0 ? Math.min(this.bitSize, dimensionSize) : this.bitSize * dimensionSize;
            ++n2;
        }
        return this.bitSize;
    }

    public int getUnpackedSize() {
        int unpackedSize = 1;
        int idx = this.nofPackedDimensions;
        while (idx < this.dimensions.length) {
            int dimensionSize = this.dimensions[idx].getSize();
            unpackedSize = dimensionSize < 0 ? Math.min(unpackedSize, dimensionSize) : dimensionSize;
            ++idx;
        }
        return unpackedSize;
    }

    @Override
    public int getNofPackedDimensions() {
        return this.nofPackedDimensions;
    }

    @Override
    public int getNofUnpackedDimensions() {
        return this.dimensions.length - this.nofPackedDimensions;
    }

    @Override
    public int getNofDimensions() {
        return this.dimensions.length;
    }

    public Dimension[] getDimensions(int nofDimensionsDelta) {
        return Arrays.copyOf(this.dimensions, this.dimensions.length + nofDimensionsDelta);
    }

    public Dimension getLastDimension() {
        return this.dimensions[this.dimensions.length - 1];
    }

    @Override
    public IRfNamedElement getAssociatedBaseType(RfTypesResolver typesResolver) {
        typesResolver.update((IRfNamedElement)this.baseElementType, this.getOccurrence(), false, false);
        return this.baseElementType;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        IRfNamedElement assocType;
        if (this.dimensions.length == 1) {
            typesResolver.update((IRfNamedElement)this.baseElementType, this.getOccurrence(), false, false);
            return this.baseElementType;
        }
        DataType dataType = this.getDataType().copy();
        if (dataType.hasUnpackedDimension()) {
            dataType.decreaseUnpackedDimension();
        } else if (dataType.hasPackedDimension()) {
            dataType.decreasePackedDimension();
        }
        RfNamedElement occurrence = this.getOccurrence();
        if (!dataType.hasPackedDimension() && !dataType.hasUnpackedDimension() && (assocType = new RfAssociatedTypeWrapper(dataType, occurrence.getEnclosingScope()).getAssociatedTypeNoLastLevelParams(typesResolver)) instanceof RfAssociatedType) {
            dataType = ((RfAssociatedType)assocType).getDataType();
        }
        Dimension[] dimensions = Arrays.copyOf(this.dimensions, this.dimensions.length - 1);
        RfComputedListType assocType2 = RfComputedListType.of(dataType, occurrence, this.baseElementType, dimensions, this.nofPackedDimensions - (this.isPacked() ? (byte)1 : 0), this.packedSign);
        typesResolver.update(assocType2, occurrence, false, false);
        return assocType2;
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        IRfNamedElement assocType = this.internalGetTransientAssociatedType();
        if (assocType == null) {
            assocType = this.getAssociatedTypeNoLastLevelParams(typesResolver, null);
            this.internalSetTransientAssociatedType(assocType);
        } else {
            typesResolver.update(assocType, this.getOccurrence(), false, false);
        }
        return assocType;
    }

    public RfComputedListType getSimpleBitVectorType() {
        if (!this.isPacked()) {
            return null;
        }
        if (this.baseElementType.getBitSize() == 1 && this.nofPackedDimensions == 1) {
            return this;
        }
        return RfComputedListType.of(this.baseElementType.getBitState() == 1 ? RfBitVectorScalarType.BIT : RfBitVectorScalarType.LOGIC, this.getBitSize(), this.packedSign);
    }

    public IRfTypeElement getFirstPackedSubElementType() {
        int nofDimensions = Math.min(this.nofPackedDimensions, this.dimensions.length - 1);
        if (nofDimensions == 0) {
            return this.baseElementType;
        }
        DataType dataType = this.getDataType().copy();
        int counter = 0;
        while (counter < nofDimensions) {
            if (dataType.hasUnpackedDimension()) {
                dataType.decreaseUnpackedDimension();
            } else if (dataType.hasPackedDimension()) {
                dataType.decreasePackedDimension();
            }
            ++counter;
        }
        return new RfComputedListType(dataType, this.getOccurrence(), this.baseElementType, Arrays.copyOf(this.dimensions, nofDimensions), nofDimensions, this.packedSign);
    }

    public RfBitVectorScalarType getBitVectorScalarType() {
        if (this.dimensions.length != 1 || !(this.dimensions[0] instanceof RangeDimension) || !(this.baseElementType instanceof RfBitVectorScalarType)) {
            return null;
        }
        RangeDimension computedDimension = (RangeDimension)this.dimensions[0];
        RfBitVectorScalarType baseScalarType = (RfBitVectorScalarType)this.baseElementType;
        return baseScalarType.getBitSize() != 1 ? null : RfBitVectorScalarType.getBitVectorScalar(computedDimension.right - computedDimension.left + 1, this.getDataType().getSign(), baseScalarType.getBitState());
    }

    public IRfTypeElement getIndexType() {
        Dimension lastComputedDimension = this.dimensions[this.dimensions.length - 1];
        return lastComputedDimension instanceof TypeDimension ? ((TypeDimension)lastComputedDimension).type : RfBitVectorScalarType.INT;
    }

    @Override
    public IRfNamedElement getIndexType(int dimensionIdx) {
        if (dimensionIdx < 0 || dimensionIdx >= this.dimensions.length) {
            return null;
        }
        Dimension lastComputedDimension = this.dimensions[this.dimensions.length - 1 - dimensionIdx];
        if (lastComputedDimension instanceof TypeDimension) {
            return ((TypeDimension)lastComputedDimension).type;
        }
        if (lastComputedDimension instanceof ExpressionDimension) {
            IHidObject expression = ((ExpressionDimension)lastComputedDimension).expression;
            if (!(expression instanceof RfHid)) {
                return RfBitVectorScalarType.INT;
            }
            IRfNamedElement element = ((RfHid)expression).getElement();
            if (element instanceof RfField && ((RfField)element).isTypeParameter()) {
                return element;
            }
        }
        return RfBitVectorScalarType.INT;
    }

    @Override
    public String getAssociatedTypeName(IRfScopeElement scope, RfTypesResolver typesResolver, int qualifiedNameOptions, boolean useDataType, boolean keepMacros, boolean noDimensionsForArrayOfInstances) {
        if (useDataType) {
            return super.getAssociatedTypeName(scope, typesResolver, qualifiedNameOptions, useDataType, keepMacros, noDimensionsForArrayOfInstances);
        }
        return this.getAssociatedType(typesResolver).getQualifiedName(qualifiedNameOptions | 4);
    }

    public boolean checkUnpackedDimensionsCompatibility(RfComputedListType other) {
        if (this.getNofUnpackedDimensions() != other.getNofUnpackedDimensions()) {
            return false;
        }
        int thisPackedDimesnionsOffset = this.getNofPackedDimensions();
        int otherPackedDimesnionsOffset = other.getNofPackedDimensions();
        int idx = 0;
        while (idx < this.getNofUnpackedDimensions()) {
            Dimension thisDimension = this.dimensions[thisPackedDimesnionsOffset + idx];
            Dimension otherDimension = other.dimensions[otherPackedDimesnionsOffset + idx];
            if (!(thisDimension instanceof ExpressionDimension && otherDimension instanceof ExpressionDimension || thisDimension.equals(otherDimension))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public boolean checkPackedDimensionsCompatibility(RfComputedListType other) {
        if (this.getNofPackedDimensions() != other.getNofPackedDimensions()) {
            return false;
        }
        int idx = 0;
        while (idx < this.getNofPackedDimensions()) {
            Dimension thisDimension = this.dimensions[idx];
            Dimension otherDimension = other.dimensions[idx];
            if (!(thisDimension instanceof ExpressionDimension && otherDimension instanceof ExpressionDimension || !(thisDimension instanceof RangeDimension && otherDimension instanceof RangeDimension ? ((RangeDimension)thisDimension).getSize() != ((RangeDimension)otherDimension).getSize() : !thisDimension.equals(otherDimension)))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        int index;
        if (this.baseElementType instanceof RfNamedElement) {
            ((RfNamedElement)this.baseElementType).getQualifiedName(result, typesResolver, scope, options, null);
        } else {
            result.append(this.baseElementType.getQualifiedName(scope, typesResolver.getHierarchyPath(), options));
        }
        if (!(this.packedSign != 1 || this.baseElementType instanceof RfStruct || this.baseElementType instanceof RfBitVectorScalarType && this.baseElementType.getBitSize() > 1)) {
            result.append(" signed");
        }
        if (this.nofPackedDimensions > 0) {
            index = this.nofPackedDimensions - 1;
            while (index >= 0) {
                this.dimensions[index].getCompleteName(result, scope, typesResolver, options);
                --index;
            }
        }
        if (this.dimensions.length > this.nofPackedDimensions) {
            result.append(" #");
            index = this.dimensions.length - 1;
            while (index >= this.nofPackedDimensions) {
                this.dimensions[index].getCompleteName(result, scope, typesResolver, options);
                --index;
            }
        }
        result.append(previous == null ? "" : ".");
    }

    @Override
    public int hashCode() {
        if (this.hasCachedHashCode) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = 31 * (31 * (this.nofPackedDimensions << 2 | this.packedSign) + Arrays.hashCode(this.dimensions)) + this.baseElementType.hashCode();
        this.hasCachedHashCode = true;
        return this.cachedHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RfComputedListType)) {
            return false;
        }
        RfComputedListType other = (RfComputedListType)obj;
        if (this.hasCachedHashCode & other.hasCachedHashCode & this.cachedHashCode != other.cachedHashCode) {
            return false;
        }
        if (this.packedSign != other.packedSign | this.nofPackedDimensions != other.nofPackedDimensions | this.isComplete ^ other.isComplete) {
            return false;
        }
        return this.baseElementType.equals(other.baseElementType) && Arrays.equals(this.dimensions, other.dimensions);
    }

    @Override
    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        BitVectorContext baseElementContext = this.baseElementType.getBitVectorContext(evaluator, guardian, origin);
        if (baseElementContext == null) {
            return null;
        }
        int computedDimensionIdx = 0;
        DVTNumber contextNumber = baseElementContext.getContextNumber();
        if (this.nofPackedDimensions > 0) {
            if (!(contextNumber instanceof VlogBitVector)) {
                return null;
            }
            VlogBitVector contextBitVector = (VlogBitVector)contextNumber;
            int bitSize = contextBitVector.getSize();
            int packedDelta = this.nofPackedDimensions * 2;
            int[] basePacked = bitSize > 1 || contextBitVector.isStruct(true) ? contextBitVector.getArrayDimensions() : PACKED_EMPTY;
            int[] packed = new int[basePacked.length + packedDelta];
            int packedIdx = packedDelta;
            while (packedIdx > 0) {
                Dimension computedDimension;
                if (!((computedDimension = this.dimensions[computedDimensionIdx++]) instanceof RangeDimension)) {
                    return BitVectorContext.of(null, (IRfNamedElement)this, (IRfNamedElement)origin);
                }
                packed[--packedIdx] = ((RangeDimension)computedDimension).right;
                packed[--packedIdx] = ((RangeDimension)computedDimension).left;
                bitSize *= ((RangeDimension)computedDimension).getSize();
            }
            if (basePacked != PACKED_EMPTY) {
                System.arraycopy(basePacked, 0, packed, packedDelta, basePacked.length);
            }
            contextNumber = VlogBitVector.create((this.packedSign == 1 ? 1 : 0) != 0, (int)(bitSize - 1), (int)0, (int[])packed, (boolean)contextBitVector.is4State(), (boolean)contextBitVector.isString(), (boolean)contextBitVector.isUnion(), (boolean)false, (Map)contextBitVector.getMemberInfoByName(), null);
        }
        if (this.dimensions.length > this.nofPackedDimensions) {
            while (computedDimensionIdx < this.dimensions.length) {
                Dimension computedDimension = this.dimensions[computedDimensionIdx];
                if (computedDimension instanceof ExpressionDimension) {
                    return BitVectorContext.of(null, (IRfNamedElement)this, (IRfNamedElement)origin);
                }
                contextNumber = computedDimension instanceof RangeDimension ? new DVTUnpackedArray(((RangeDimension)computedDimension).left, ((RangeDimension)computedDimension).right, contextNumber) : new DVTUnpackedArray(-1, -1, contextNumber);
                ++computedDimensionIdx;
            }
        }
        return BitVectorContext.of((DVTNumber)contextNumber, (IRfNamedElement)this, (IRfNamedElement)origin);
    }

    public int[] xGetComputedBounds() {
        Dimension dimension = this.dimensions[this.dimensions.length - 1];
        if (dimension instanceof RangeDimension) {
            return new int[]{((RangeDimension)dimension).left, ((RangeDimension)dimension).right};
        }
        if (dimension instanceof BoundQueueDimension) {
            int[] nArray = new int[2];
            nArray[1] = ((BoundQueueDimension)dimension).bound;
            return nArray;
        }
        return null;
    }

    @Override
    public BitVectorContext xGetIndexBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        return this.getIndexType().getBitVectorContext(evaluator, guardian, origin);
    }

    @Override
    public IRfNamedElement xGetAssociatedType(IHidEvaluator occurenceScope) {
        DataType dataType = this.getDataType().copy();
        if (dataType.hasUnpackedDimension()) {
            dataType.decreaseUnpackedDimension();
        } else if (dataType.hasPackedDimension()) {
            dataType.decreasePackedDimension();
        }
        if (!dataType.isArray()) {
            return super.xGetAssociatedType(occurenceScope);
        }
        Dimension[] reducedComputedDimensions = Arrays.copyOf(this.dimensions, this.dimensions.length - 1);
        return RfComputedListType.of(dataType, this.getOccurrence(), this.baseElementType, reducedComputedDimensions, this.nofPackedDimensions - (this.isPacked() ? (byte)1 : 0), this.packedSign);
    }

    @Override
    public IHidObject xGetRangeObject() {
        if (this.isComplete() || this.isPacked()) {
            return null;
        }
        Dimension lastDimension = this.dimensions[this.dimensions.length - 1];
        return lastDimension instanceof ExpressionDimension ? ((ExpressionDimension)lastDimension).expression : null;
    }

    public IRfListType xGetTypeWithRangeSelect(XComputedSelect computedRangeSelect) {
        return RfTypesResolver.create((IRfScopeElement)this, this.getRfProject(), 0).computeListType(this, computedRangeSelect);
    }

    public static final class BoundQueueDimension
    implements Dimension {
        private static final long serialVersionUID = 1L;
        public final int bound;

        public BoundQueueDimension(int bound) {
            this.bound = bound;
        }

        @Override
        public boolean isQueue() {
            return true;
        }

        @Override
        public int getSize() {
            return -1;
        }

        public int hashCode() {
            return QUEUE_DIMENSION.hashCode() + this.bound;
        }

        public boolean equals(Object obj) {
            return obj instanceof RangeDimension && this.bound == ((BoundQueueDimension)obj).bound;
        }

        public String toString() {
            return "$ : " + this.bound;
        }
    }

    public static interface Dimension
    extends Serializable {
        default public boolean isType() {
            return false;
        }

        default public boolean isQueue() {
            return false;
        }

        default public boolean isComplete() {
            return true;
        }

        default public int getSize() {
            return -2;
        }

        default public void getCompleteName(StringBuilder result, IRfScopeElement scope, RfTypesResolver typesResolver, int options) {
            result.append('[').append(this).append(']');
        }
    }

    public static final class ExpressionDimension
    implements Dimension {
        private static final long serialVersionUID = 1L;
        public final IHidObject expression;

        public ExpressionDimension(IHidObject expression) {
            this.expression = expression;
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isType() {
            IHid hid = HidUtils.getHidFrom((IHidObject)this.expression);
            if (!(hid instanceof Hid)) {
                return false;
            }
            IRfNamedElement hidElement = ((Hid)hid).getElement();
            return hidElement == null || hid.getParametricDependencyValue() != 15 && (hidElement instanceof IRfTypeElement || hidElement instanceof RfTypeAlias || hidElement instanceof RfField && ((RfField)hidElement).isTypeParameter());
        }

        @Override
        public boolean isQueue() {
            if (!(this.expression instanceof RfHidOperator)) {
                return false;
            }
            IHidObject lhValue = ((RfHidOperator)this.expression).getLHValue();
            return lhValue instanceof RfHidImplicit && ((RfHidImplicit)lhValue).isDollar();
        }

        @Override
        public int getSize() {
            return this.isType() ? -1 : -2;
        }

        public int hashCode() {
            return this.expression.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ExpressionDimension && this.expression.equals(((ExpressionDimension)obj).expression);
        }

        public String toString() {
            StringBuilder stringBuilder = HidUtils.toStringBuilder((IHidObject)this.expression, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
            if (this.expression instanceof RfHidOperator && ((RfHidOperator)this.expression).isRangeOrPartSelect()) {
                stringBuilder.deleteCharAt(0).deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
    }

    public static final class RangeDimension
    implements Dimension {
        private static final long serialVersionUID = 1L;
        public final int left;
        public final int right;

        public RangeDimension(int right) {
            this.left = 0;
            this.right = right - 1;
        }

        public RangeDimension(int left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int getSize() {
            return Math.abs(this.right - this.left) + 1;
        }

        public int hashCode() {
            return 36353 * this.left + this.right;
        }

        public boolean equals(Object obj) {
            return obj instanceof RangeDimension && this.left == ((RangeDimension)obj).left & this.right == ((RangeDimension)obj).right;
        }

        public String toString() {
            return String.valueOf(this.left) + ":" + this.right;
        }
    }

    public static final class TypeDimension
    implements Dimension {
        private static final long serialVersionUID = 1L;
        public final IRfTypeElement type;

        public TypeDimension(IRfTypeElement type) {
            this.type = type;
        }

        @Override
        public boolean isType() {
            return true;
        }

        @Override
        public boolean isComplete() {
            return this.type.isComplete();
        }

        @Override
        public int getSize() {
            return -1;
        }

        @Override
        public void getCompleteName(StringBuilder result, IRfScopeElement scope, RfTypesResolver typesResolver, int options) {
            result.append('[');
            if (this.type instanceof RfNamedElement) {
                ((RfNamedElement)this.type).getQualifiedName(result, typesResolver, scope, options, null);
            } else {
                result.append(this.type.getQualifiedName(scope, typesResolver.getHierarchyPath(), options));
            }
            result.append(']');
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TypeDimension && this.type.equals(((TypeDimension)obj).type);
        }

        public String toString() {
            return this.type.getQualifiedName();
        }
    }
}

