/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.IWaveViwerComputedStruct;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfSpecializedType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfComputedStruct
extends RfStruct
implements IWaveViwerComputedStruct {
    private static final long serialVersionUID = 1L;
    private transient MemberInfo[] membersInfo;
    private transient int bitSize;
    private transient byte bitState;
    private ElementPath hierarchyPath;
    private RfStruct originalStruct;

    public RfComputedStruct(RfStruct genericStruct, RfNamedElement enclosingSpecializedElement, ElementPath hierarchyPath) {
        super(genericStruct, enclosingSpecializedElement);
        this.originalStruct = genericStruct;
        this.hierarchyPath = hierarchyPath;
        this.bitSize = -3;
        this.bitState = 0;
    }

    @Override
    protected synchronized void internalInit(IHidEvaluator evaluator, IRfNamedElement origin) {
        IRfNamedElement memberType;
        RfTypesResolver typesResolver;
        if (this.bitSize != -3) {
            return;
        }
        this.bitSize = -2;
        ParametricDependency parametricDependency = new ParametricDependency(1);
        RfProject rfProject = this.getRfProject();
        ELManager elabManager = rfProject.getELManager() != null && rfProject.getELManager().isPermanentElaboration() || this.hierarchyPath != null && !this.hierarchyPath.isEmpty() ? rfProject.getELManager() : rfProject.getNonELManager();
        RfTypesResolver rfTypesResolver = typesResolver = evaluator == null ? RfTypesResolver.create(this, this.hierarchyPath, elabManager, 0) : RfTypesResolver.create(evaluator, origin, this.hierarchyPath, 0, true);
        if (this.isEnum()) {
            if (this.enumBaseDataType == null) {
                this.initEnum(null);
            }
            IRfNamedElement enumBaseTypeCandidate = typesResolver.computeAssociatedType(new RfAssociatedTypeWrapper(this.enumBaseDataType, this, this.getEnclosingScope()), parametricDependency, this, null, null, true, false, false);
            this.enumBaseDataType.updateParametricDependencyValue(parametricDependency.value);
            if (!(enumBaseTypeCandidate instanceof IRfTypeElement) || enumBaseTypeCandidate instanceof RfStruct && ((RfStruct)enumBaseTypeCandidate).isEnum()) {
                return;
            }
            this.enumBaseType = (IRfTypeElement)enumBaseTypeCandidate;
            this.sign = this.enumBaseType.getSign();
            this.bitState = this.enumBaseType.getBitState();
            this.bitSize = this.enumBaseType.getBitSize();
            return;
        }
        DVTLinkedHashMap<String, RfNamedElement> members = this.internalGetMembers();
        if (members == null) {
            this.sign = 0;
            this.bitState = 0;
            return;
        }
        boolean isUnion = this.isUnion();
        ArrayList<MemberInfo> membersInfo = new ArrayList<MemberInfo>();
        Iterator memberIt = members.iterator();
        LinkedHashMap<RfField, IRfTypeElement> unionFieldTypes = isUnion ? new LinkedHashMap<RfField, IRfTypeElement>() : null;
        int bitSize = 0;
        while (memberIt.hasNext()) {
            RfField actualMember;
            RfNamedElement member = (RfNamedElement)memberIt.next();
            if (member instanceof RfDuplicate && (actualMember = ((RfDuplicate)member).getLastMember(RfField.class)) != null) {
                member = actualMember;
            }
            if (!(member instanceof RfField)) continue;
            RfField fieldMember = (RfField)member;
            RfTypesResolver memberTypeResolver = memberIt.hasNext() ? RfTypesResolver.create(typesResolver) : typesResolver;
            memberType = fieldMember.internalGetTransientAssociatedType();
            if (memberType == null) {
                memberType = memberTypeResolver.computeAssociatedType(fieldMember, new ParametricDependency(1), fieldMember, null, null, true, false, false);
            }
            if (memberType instanceof RfTypeAlias) {
                memberType = ((RfTypeAlias)memberType).getTranslatedType(memberTypeResolver);
            }
            if (!(memberType instanceof IRfTypeElement)) {
                this.sign = 0;
                this.bitState = 0;
                return;
            }
            if (memberType instanceof RfStruct) {
                ((RfStruct)memberType).internalInit(evaluator, origin);
            }
            this.bitState = (byte)(this.bitState | ((IRfTypeElement)memberType).getBitState());
            int memberBitSize = ((IRfTypeElement)memberType).getBitSize();
            if (unionFieldTypes != null) {
                unionFieldTypes.put(fieldMember, (IRfTypeElement)memberType);
                if (bitSize < 0) continue;
                bitSize = memberBitSize < 0 ? Math.min(bitSize, memberBitSize) : Math.max(bitSize, memberBitSize);
                continue;
            }
            membersInfo.add(new MemberInfo(fieldMember, bitSize, (IRfTypeElement)memberType));
            if (bitSize < 0) continue;
            int n = bitSize = memberBitSize < 0 ? Math.min(bitSize, memberBitSize) : bitSize + memberBitSize;
        }
        if (unionFieldTypes != null) {
            for (Map.Entry fieldWithType : unionFieldTypes.entrySet()) {
                RfField memberField = (RfField)fieldWithType.getKey();
                memberType = (IRfTypeElement)fieldWithType.getValue();
                membersInfo.add(new MemberInfo(memberField, bitSize - memberType.getBitSize(), (IRfTypeElement)memberType));
            }
        }
        this.bitSize = bitSize;
        MemberInfo[] memberInfoArray = this.membersInfo = bitSize != -2 ? membersInfo.toArray(new MemberInfo[0]) : null;
        if (!this.isPacked) {
            this.sign = 0;
            this.bitState = 0;
        }
    }

    @Override
    public void initStructUnion(boolean isPacked, int sign) {
        super.initStructUnion(isPacked, sign);
        this.bitState = 0;
        this.bitSize = -3;
    }

    @Override
    public void initEnum(DataType baseDataType) {
        super.initEnum(baseDataType);
        if (baseDataType == null) {
            this.bitState = this.enumBaseType.getBitState();
            this.bitSize = this.enumBaseType.getBitSize();
        } else {
            this.bitState = 0;
            this.bitSize = -3;
        }
    }

    @Override
    public boolean isDirtyElement() {
        return this.originalStruct.isDirtyElement();
    }

    @Override
    public boolean isDefinedInParameterPortList() {
        return this.originalStruct.isDefinedInParameterPortList();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.originalStruct.hasNoDefs(rawDefs);
    }

    @Override
    public RfStruct getOriginal() {
        return this.originalStruct;
    }

    public ElementPath getHierarchyPath() {
        return this.hierarchyPath;
    }

    public byte getBitState() {
        if (this.isPacked) {
            this.internalInit();
        }
        return this.bitState;
    }

    public int getBitSize() {
        this.internalInit();
        return this.bitSize;
    }

    @Override
    public RfDefElement getDeclaration() {
        return this.originalStruct.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return this.originalStruct.getDeclarations();
    }

    @Override
    public Class<? extends RfNamedElement> getCustomClass() {
        return this.originalStruct.getCustomClass();
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.bitState = 0;
        this.bitSize = -3;
        this.membersInfo = null;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.bitState = 0;
        this.bitSize = -3;
        this.membersInfo = null;
    }

    @Override
    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        DVTUnpackedStruct dVTUnpackedStruct;
        this.internalInit(evaluator, origin);
        if (this.isEnum()) {
            if (this.enumBaseType == null) {
                return null;
            }
            BitVectorContext dataTypeContext = this.enumBaseType.getBitVectorContext(evaluator, guardian, (IRfNamedElement)this);
            return dataTypeContext != null ? BitVectorContext.of((DVTNumber)dataTypeContext.getContextNumber(), (IRfNamedElement)this, (IRfNamedElement)origin) : null;
        }
        if (this.membersInfo == null) {
            if (!guardian.isLinterStaticAnalysisMode() || !this.isPacked()) {
                return null;
            }
            return BitVectorContext.of((DVTNumber)VlogBitVector.create((this.getSign() == 1 ? 1 : 0) != 0, (int)0, (int)0, null, (boolean)false, (boolean)false, (boolean)this.isUnion(), (boolean)true, null, null), (IRfNamedElement)this, (IRfNamedElement)origin);
        }
        LinkedHashMap<String, StructMemberContextInfo> membersContextInfo = new LinkedHashMap<String, StructMemberContextInfo>(this.membersInfo.length);
        int idx = 0;
        while (idx < this.membersInfo.length) {
            membersContextInfo.put(this.membersInfo[idx].member.getName(), this.membersInfo[idx].toStructMemberContextInfo(evaluator, guardian));
            ++idx;
        }
        boolean isUnion = this.isUnion();
        if (this.isPacked) {
            int[] nArray = new int[2];
            nArray[0] = this.bitSize - 1;
            dVTUnpackedStruct = VlogBitVector.create((this.getSign() == 1 ? 1 : 0) != 0, (int)(this.bitSize - 1), (int)0, (int[])nArray, (boolean)false, (boolean)false, (boolean)isUnion, (boolean)false, membersContextInfo, null);
        } else {
            dVTUnpackedStruct = DVTUnpackedStruct.ofInfo(membersContextInfo, (boolean)isUnion);
        }
        return BitVectorContext.of((DVTNumber)dVTUnpackedStruct, (IRfNamedElement)this, (IRfNamedElement)origin);
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        if (previous != null) {
            IRfScopeElement structScope = scope;
            while (structScope instanceof RfStruct) {
                if (this.getName().equals(structScope.getName())) {
                    return;
                }
                structScope = ((RfStruct)structScope).getEnclosingScope();
            }
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options)) {
            if (this.hierarchyPath != null) {
                result.append(this.hierarchyPath).append('.');
            } else {
                IRfNamedElement resolverElement = typesResolver.getNamedElement();
                RfNamedElement enclosingScope = (resolverElement != null && resolverElement.getName().equals(this.getName()) ? (RfNamedElement)resolverElement : this).getEnclosingScope();
                if (enclosingScope != null && !(enclosingScope instanceof RfProject)) {
                    enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
                }
            }
        }
        if (this.aliasName != null) {
            result.append(this.aliasName);
        } else {
            String name = this.getName();
            result.append(IRfNamedElement.QualifiedNameOptions.contains((int)8, (int)options) ? name : name.substring(0, name.indexOf(47)));
        }
        if (previous != null) {
            result.append(previous.isObjectStatic() ? "::" : ".");
        }
    }

    public int hashCodeComputed() {
        return Objects.hash(this.hierarchyPath, this.getEnclosingScope());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.hashCodeComputed();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfComputedStruct other = (RfComputedStruct)obj;
        if (!Objects.equals(this.hierarchyPath, other.hierarchyPath)) {
            return false;
        }
        return this.getEnclosingScope().equals(other.getEnclosingScope());
    }

    @Override
    public String toString() {
        RfStruct structScope = this;
        while (structScope.getEnclosingScope() instanceof RfStruct) {
            structScope = (RfStruct)structScope.getEnclosingScope();
        }
        if (structScope.getHierarchyPath() == null && !(structScope.getEnclosingScope() instanceof IRfSpecializedType)) {
            return this.aliasName != null ? this.aliasName : this.getName();
        }
        return this.getQualifiedName(5);
    }

    @Override
    public boolean isComplete() {
        return this.hierarchyPath != null || super.isComplete();
    }

    public WStructMetadata getStructMetadata(String structName, boolean isBigEndian) {
        if (isBigEndian) {
            WStructMetadata wStructMetadata = new WStructMetadata(structName, 0, this.getBitSize() - 1, this.getBigEndianMembersMetadata(0));
            if (this.isEnum()) {
                this.createEnumItems(this, wStructMetadata);
            }
            return wStructMetadata;
        }
        WStructMetadata wStructMetadata = new WStructMetadata(structName, this.getBitSize() - 1, 0, this.getLittleEndianMembersMetadata(this.bitSize - 1));
        if (this.isEnum()) {
            this.createEnumItems(this, wStructMetadata);
        }
        return wStructMetadata;
    }

    /*
     * WARNING - void declaration
     */
    public List<WStructMetadata> getBigEndianMembersMetadata(int startIndexInParent) {
        if (this.membersInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<WStructMetadata> membersMetadata = new ArrayList<WStructMetadata>();
        int memberStartIndex = startIndexInParent;
        int memberEndIndex = memberStartIndex - 1;
        int i = 0;
        while (i < this.membersInfo.length) {
            memberStartIndex = memberEndIndex + 1;
            MemberInfo memberInfo = this.membersInfo[i];
            if (memberInfo != null) {
                String memberName = memberInfo.member.getName();
                IRfTypeElement memberInfoType = memberInfo.type;
                memberEndIndex = memberStartIndex + memberInfoType.getBitSize() - 1;
                if (memberInfoType instanceof RfComputedListType && ((RfComputedListType)memberInfoType).getAssociatedBaseType() instanceof IWaveViwerComputedStruct) {
                    RfComputedListType.Dimension[] allDimensions = ((RfComputedListType)memberInfoType).getDimensions(((RfComputedListType)memberInfoType).getNofPackedDimensions());
                    int nOfChildren = 1;
                    RfComputedListType.Dimension[] dimensionArray = allDimensions;
                    int n = allDimensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RfComputedListType.Dimension dimension = dimensionArray[n2];
                        if (dimension != null) {
                            nOfChildren *= dimension.getSize();
                        }
                        ++n2;
                    }
                    innerChildren = new ArrayList();
                    this.collectBigEndianPackedArrayInnerChildren(innerChildren, memberName, memberStartIndex, memberInfoType, nOfChildren);
                    membersMetadata.add(new WStructMetadata(String.valueOf(memberName) + ((RfComputedListType)memberInfoType).getPackedDimension(), memberStartIndex, memberEndIndex, innerChildren));
                } else if (!(memberInfoType instanceof IWaveViwerComputedStruct)) {
                    membersMetadata.add(new WStructMetadata(memberName, memberStartIndex, memberEndIndex, Collections.emptyList()));
                } else {
                    void rfStruct;
                    List innerMembers = ((IWaveViwerComputedStruct)memberInfoType).getBigEndianMembersMetadata(memberStartIndex);
                    WStructMetadata structMetadata = new WStructMetadata(memberName, memberStartIndex, memberEndIndex, innerMembers);
                    membersMetadata.add(structMetadata);
                    IRfTypeElement iRfTypeElement = memberInfoType;
                    if (iRfTypeElement instanceof RfStruct && (innerChildren = (RfStruct)iRfTypeElement) == (RfStruct)iRfTypeElement && rfStruct.isEnum()) {
                        this.createEnumItems((RfStruct)memberInfoType, structMetadata);
                    }
                }
            }
            ++i;
        }
        return membersMetadata;
    }

    private void collectBigEndianPackedArrayInnerChildren(List<WStructMetadata> innerChildren, String memberName, int memberStartIndex, IRfTypeElement memberInfoType, int nOfChildren) {
        int childStartIndex = memberStartIndex;
        int i = 0;
        while (i <= nOfChildren) {
            List innerMembers = ((IWaveViwerComputedStruct)((RfComputedListType)memberInfoType).getAssociatedBaseType()).getBigEndianMembersMetadata(childStartIndex);
            int childEndIndex = childStartIndex + memberInfoType.getBitSize() / nOfChildren - 1;
            WStructMetadata structMetadata = new WStructMetadata(String.valueOf(memberName) + "[" + i + "]", childStartIndex, childEndIndex, innerMembers);
            innerChildren.add(structMetadata);
            if (memberInfoType instanceof RfStruct var11_11 && rfStruct.isEnum()) {
                this.createEnumItems((RfStruct)memberInfoType, structMetadata);
                childStartIndex += memberInfoType.getBitSize() / nOfChildren;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<WStructMetadata> getLittleEndianMembersMetadata(int startIndexInParent) {
        if (this.membersInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<WStructMetadata> membersMetadata = new ArrayList<WStructMetadata>();
        int memberStartIndex = startIndexInParent;
        int memberEndIndex = memberStartIndex + 1;
        int i = 0;
        while (i < this.membersInfo.length) {
            memberStartIndex = memberEndIndex - 1;
            MemberInfo memberInfo = this.membersInfo[i];
            if (memberInfo != null) {
                String memberName = memberInfo.member.getName();
                IRfTypeElement memberInfoType = memberInfo.type;
                memberEndIndex = memberStartIndex - memberInfoType.getBitSize() + 1;
                if (memberInfoType instanceof RfComputedListType && ((RfComputedListType)memberInfoType).getAssociatedBaseType() instanceof IWaveViwerComputedStruct) {
                    RfComputedListType.Dimension[] allDimensions = ((RfComputedListType)memberInfoType).getDimensions(((RfComputedListType)memberInfoType).getNofPackedDimensions());
                    int nOfChildren = 1;
                    RfComputedListType.Dimension[] dimensionArray = allDimensions;
                    int n = allDimensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RfComputedListType.Dimension dimension = dimensionArray[n2];
                        if (dimension != null) {
                            nOfChildren *= dimension.getSize();
                        }
                        ++n2;
                    }
                    innerChildren = new ArrayList();
                    this.collectLittleEndianPackedArrayInnerChildren(innerChildren, memberName, memberStartIndex, memberInfoType, nOfChildren);
                    membersMetadata.add(new WStructMetadata(String.valueOf(memberName) + ((RfComputedListType)memberInfoType).getPackedDimension(), memberStartIndex, memberEndIndex, innerChildren));
                } else if (!(memberInfoType instanceof IWaveViwerComputedStruct)) {
                    membersMetadata.add(new WStructMetadata(memberName, memberStartIndex, memberEndIndex, Collections.emptyList()));
                } else {
                    void rfStruct;
                    List innerMembers = ((IWaveViwerComputedStruct)memberInfoType).getLittleEndianMembersMetadata(memberStartIndex);
                    WStructMetadata structMetadata = new WStructMetadata(memberName, memberStartIndex, memberEndIndex, innerMembers);
                    membersMetadata.add(structMetadata);
                    IRfTypeElement iRfTypeElement = memberInfoType;
                    if (iRfTypeElement instanceof RfStruct && (innerChildren = (RfStruct)iRfTypeElement) == (RfStruct)iRfTypeElement && rfStruct.isEnum()) {
                        this.createEnumItems((RfStruct)memberInfoType, structMetadata);
                    }
                }
            }
            ++i;
        }
        return membersMetadata;
    }

    private void collectLittleEndianPackedArrayInnerChildren(List<WStructMetadata> innerChildren, String memberName, int memberStartIndex, IRfTypeElement memberInfoType, int nOfChildren) {
        int childStartIndex = memberStartIndex;
        int i = nOfChildren - 1;
        while (i >= 0) {
            List innerMembers = ((IWaveViwerComputedStruct)((RfComputedListType)memberInfoType).getAssociatedBaseType()).getLittleEndianMembersMetadata(childStartIndex);
            int childEndIndex = childStartIndex - memberInfoType.getBitSize() / nOfChildren + 1;
            WStructMetadata structMetadata = new WStructMetadata(String.valueOf(memberName) + "[" + i + "]", childStartIndex, childEndIndex, innerMembers);
            innerChildren.add(structMetadata);
            if (memberInfoType instanceof RfStruct var11_11 && rfStruct.isEnum()) {
                this.createEnumItems((RfStruct)memberInfoType, structMetadata);
                childStartIndex -= memberInfoType.getBitSize() / nOfChildren;
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createEnumItems(RfStruct struct, WStructMetadata structMetadata) {
        Collection<RfNamedElement> members = struct.getMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return;
        }
        String pathString = enclosingScope.elementPathName();
        if (pathString == null || pathString.isEmpty()) {
            return;
        }
        ElementPath path = ElementPath.create((String[])pathString.split("\\."));
        if (path == null) {
            return;
        }
        ELManager elabManager = rfProject.getELManager();
        if (elabManager == null) {
            return;
        }
        RfTypesResolver typesResolver = RfTypesResolver.create(struct, path, elabManager, 0);
        HashMap<String, String> enumItems = new HashMap<String, String>();
        for (RfNamedElement member : members) {
            void field;
            RfField rfField;
            RfNamedElement rfNamedElement = member;
            if (!(rfNamedElement instanceof RfField) || (rfField = (RfField)rfNamedElement) != (RfField)rfNamedElement || !field.isEnumElement()) continue;
            String memberName = member.getName();
            IELParamValue paramValue = typesResolver.getValueDirectly(memberName);
            if (paramValue == null) {
                String initialValue = field.getInitialValue(true);
                if (initialValue == null) continue;
                int intVal = DVTStringUtil.parseInt((String)initialValue, (int)-1);
                enumItems.put(Integer.toBinaryString(intVal), memberName);
                continue;
            }
            DVTNumber elParamValue = paramValue.getDVTNumber();
            String enumStringValue = elParamValue.toString(2, false, false);
            enumStringValue = DVTVCDUtils.removeStartingZerosFromBinaryString((String)enumStringValue);
            enumItems.put(enumStringValue, memberName);
        }
        structMetadata.setEnumItems(enumItems);
    }

    private static class MemberInfo {
        public final RfField member;
        public final int index;
        public final IRfTypeElement type;

        public MemberInfo(RfField member, int index, IRfTypeElement type) {
            this.member = member;
            this.index = index;
            this.type = type;
        }

        public StructMemberContextInfo toStructMemberContextInfo(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            if (this.type instanceof RfClass) {
                return new StructMemberContextInfo(this.index, this.member.getName(), BitVectorContext.of(null, (IRfNamedElement)this.type, (IRfNamedElement)this.member));
            }
            return new StructMemberContextInfo(this.index, this.member.getName(), this.type.getBitVectorContext(evaluator, guardian, (IRfNamedElement)this.member));
        }
    }
}

