/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.semantic.HHViewUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfConfigurationRule;
import ro.amiq.vlogdt.model.reflection.RfConfigurationRuleDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

public class RfConfiguration
extends RfMembersHolder
implements IRfConfiguration,
Serializable {
    private static final long serialVersionUID = 2L;
    private List<List<Identifier>> designTops;
    private transient List<IRfDesignElement> resolvedDesignTops;
    private IRfConfigurationRule defaultRule;
    private transient List<IRfLibraryElement> defaultLiblist;
    private Map<ElementPath, List<IRfConfigurationRule>> cellRules;
    private Map<ElementPath, List<IRfConfigurationRule>> instanceRules;
    private ParserPath parserPath;
    private IRfLibraryElement enclosingLibrary;

    public RfConfiguration(String name, boolean escaped, ParserPath parserPath, IRfLibraryElement enclosingLibrary) {
        super(name, escaped);
        this.parserPath = parserPath;
        this.enclosingLibrary = enclosingLibrary;
        this.init();
    }

    public RfConfiguration(ElementPath prefixPath, RfConfiguration hierarchicalConfiguration) {
        super(hierarchicalConfiguration.getName(), hierarchicalConfiguration.isEscaped());
        this.parserPath = hierarchicalConfiguration.parserPath;
        this.enclosingLibrary = hierarchicalConfiguration.enclosingLibrary;
        this.designTops = hierarchicalConfiguration.designTops;
        this.resolvedDesignTops = hierarchicalConfiguration.resolvedDesignTops;
        this.defaultLiblist = hierarchicalConfiguration.defaultLiblist;
        this.defaultRule = hierarchicalConfiguration.defaultRule;
        this.cellRules = hierarchicalConfiguration.cellRules;
        this.setHidHolder(hierarchicalConfiguration.getHidHolder());
        if (hierarchicalConfiguration.instanceRules != null && !hierarchicalConfiguration.instanceRules.isEmpty()) {
            this.instanceRules = new LinkedHashMap<ElementPath, List<IRfConfigurationRule>>(OptimizedUtils.noRehashSize((int)hierarchicalConfiguration.instanceRules.size()));
            for (List<IRfConfigurationRule> ruleList : hierarchicalConfiguration.instanceRules.values()) {
                for (IRfConfigurationRule instanceRule : ruleList) {
                    ElementPath newElementPath = ElementPath.usePrefix((ElementPath)prefixPath, (ElementPath)instanceRule.getElementDescription(), (int)1);
                    List<IRfConfigurationRule> existingRules = this.instanceRules.get(newElementPath);
                    if (existingRules == null) {
                        existingRules = new ArrayList<IRfConfigurationRule>();
                        this.instanceRules.put(newElementPath, existingRules);
                    }
                    existingRules.add(instanceRule);
                }
            }
        }
    }

    public void init() {
        this.instanceRules = new LinkedHashMap<ElementPath, List<IRfConfigurationRule>>();
        this.cellRules = new LinkedHashMap<ElementPath, List<IRfConfigurationRule>>();
    }

    public void addDesignTop(List<Identifier> designName) {
        if (this.designTops == null) {
            this.designTops = new ArrayList<List<Identifier>>();
        }
        this.designTops.add(designName);
    }

    public String getConfigName() {
        if (this.enclosingLibrary == null) {
            return this.getName();
        }
        return DVTStringUtil.appendString((Object[])new Object[]{this.enclosingLibrary.getName(), ".", this.getName()});
    }

    public void clean() {
        if (this.designTops != null) {
            this.designTops.clear();
        }
        this.designTops = null;
        if (this.cellRules != null) {
            this.cellRules.clear();
        }
        if (this.instanceRules != null) {
            this.instanceRules.clear();
        }
        this.defaultRule = null;
    }

    public void cleanResolved() {
        if (this.resolvedDesignTops != null) {
            this.resolvedDesignTops.clear();
        }
        this.resolvedDesignTops = null;
        if (this.defaultLiblist != null) {
            this.defaultLiblist.clear();
        }
        this.defaultLiblist = null;
    }

    @Override
    public void deepClean() {
        this.clean();
        this.cleanResolved();
        this.parserPath = null;
        this.enclosingLibrary = null;
        super.deepClean();
    }

    public boolean hasRelevantPathPrefix(ElementPath instancePath) {
        if (this.cellRules != null && !this.cellRules.isEmpty()) {
            for (ElementPath relevantPath : this.cellRules.keySet()) {
                if (!instancePath.isPrefixOf(relevantPath)) continue;
                return true;
            }
        }
        if (this.instanceRules != null && !this.instanceRules.isEmpty()) {
            for (ElementPath relevantPath : this.instanceRules.keySet()) {
                if (!instancePath.isPrefixOf(relevantPath)) continue;
                return true;
            }
        }
        return false;
    }

    public ElementPath getRelevantLiblistPath(ElementPath instancePath, Set<ElementPath> relevantInstancePaths) {
        if (instancePath == null || instancePath == ElementPath.EMPTY_PATH) {
            return instancePath;
        }
        if (relevantInstancePaths == null || relevantInstancePaths.isEmpty()) {
            return ElementPath.EMPTY_PATH;
        }
        ElementPath lastRelevantPath = ElementPath.EMPTY_PATH;
        for (ElementPath relevantPath : relevantInstancePaths) {
            if (relevantPath == ElementPath.EMPTY_PATH || lastRelevantPath != ElementPath.EMPTY_PATH && relevantPath.length() < lastRelevantPath.length() || !relevantPath.isPrefixOf(instancePath)) continue;
            lastRelevantPath = relevantPath;
        }
        return lastRelevantPath;
    }

    private final void addBindingRule(Map<ElementPath, List<IRfConfigurationRule>> rules, List<Identifier> instancePath, IRfConfigurationRule.ConfigCoverage configType, IRfConfigurationRule.ConfigKind configKind, List<Identifier> list, RfFileDef fileDef, LineInfo startInfo, DataType parametersDataType) {
        ElementPath elementDescription = this.toElementPath(instancePath);
        List<IRfConfigurationRule> existingRules = rules.get(elementDescription);
        if (existingRules == null) {
            existingRules = new ArrayList<IRfConfigurationRule>();
            rules.put(elementDescription, existingRules);
        }
        String uniqueName = IRfConfigurationRule.getUniqueName((int)startInfo.realOffset, (int)startInfo.virtOffset, (int)startInfo.line);
        RfConfigurationRule configRule = new RfConfigurationRule(uniqueName, configType, configKind, elementDescription, list, parametersDataType);
        RfConfigurationRuleDef configurationRuleDef = new RfConfigurationRuleDef(fileDef, uniqueName, startInfo);
        configRule.addDeclaration(configurationRuleDef);
        RfDefElement enclosingConfigurationDef = this.getDeclaration();
        if (enclosingConfigurationDef != null) {
            enclosingConfigurationDef.addChild(configurationRuleDef);
        }
        configRule.setEnclosingScope(this);
        existingRules.add(configRule);
    }

    public void addDefaultLiblist(List<Identifier> libList, RfFileDef fileDef, LineInfo startInfo) {
        LinkedHashMap<ElementPath, List<IRfConfigurationRule>> defaultRules = new LinkedHashMap<ElementPath, List<IRfConfigurationRule>>(2);
        this.addBindingRule(defaultRules, Collections.emptyList(), IRfConfigurationRule.ConfigCoverage.DEFAULT, IRfConfigurationRule.ConfigKind.LIBLIST, libList, fileDef, startInfo, null);
        this.defaultRule = !defaultRules.isEmpty() ? (IRfConfigurationRule)((List)defaultRules.values().iterator().next()).iterator().next() : null;
    }

    public void addInstanceLiblist(List<Identifier> instancePath, List<Identifier> libList, RfFileDef fileDef, LineInfo startInfo) {
        this.addBindingRule(this.instanceRules, instancePath, IRfConfigurationRule.ConfigCoverage.INSTANCE, IRfConfigurationRule.ConfigKind.LIBLIST, libList, fileDef, startInfo, null);
    }

    public void addInstanceUse(List<Identifier> instancePath, List<Identifier> useName, RfFileDef fileDef, LineInfo startInfo, DataType parametersDataType) {
        this.addBindingRule(this.instanceRules, instancePath, IRfConfigurationRule.ConfigCoverage.INSTANCE, IRfConfigurationRule.ConfigKind.USE, useName, fileDef, startInfo, parametersDataType);
    }

    public void addCellLiblist(List<Identifier> cellName, List<Identifier> libList, RfFileDef fileDef, LineInfo startInfo) {
        this.addBindingRule(this.cellRules, cellName, IRfConfigurationRule.ConfigCoverage.CELL, IRfConfigurationRule.ConfigKind.LIBLIST, libList, fileDef, startInfo, null);
    }

    public void addCellUse(List<Identifier> cellName, List<Identifier> useName, RfFileDef fileDef, LineInfo startInfo, DataType parametersDataType) {
        this.addBindingRule(this.cellRules, cellName, IRfConfigurationRule.ConfigCoverage.CELL, IRfConfigurationRule.ConfigKind.USE, useName, fileDef, startInfo, parametersDataType);
    }

    private final ElementPath toElementPath(List<Identifier> elementDescription) {
        if (elementDescription == null || elementDescription.isEmpty()) {
            return ElementPath.EMPTY_PATH;
        }
        ElementPath result = null;
        for (Identifier id : elementDescription) {
            String segment = id.getName();
            if (id.getSelect() != null) {
                segment = String.valueOf(segment) + id.getSelect();
            }
            result = ElementPath.join(result, (String)segment);
        }
        return result;
    }

    public void resolveConfiguration(IRfSingleLangProject singleLangProject) {
        if (!(singleLangProject instanceof RfProject)) {
            return;
        }
        RfProject rfProject = (RfProject)singleLangProject;
        try {
            this.resolvedDesignTops = this.resolveDesignTops(rfProject, this.enclosingLibrary, this.designTops);
            this.defaultLiblist = this.resolveLiblist(rfProject, this.enclosingLibrary, this.defaultRule != null ? this.defaultRule.list() : null);
            this.resolveBindingRules(rfProject, this.enclosingLibrary, this.cellRules);
            this.resolveBindingRules(rfProject, this.enclosingLibrary, this.instanceRules);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected List<IRfDesignElement> resolveDesignTops(RfProject rfProject, IRfLibraryElement currentLibrary, List<List<Identifier>> designTops) {
        block7: {
            if (designTops != null && !designTops.isEmpty()) break block7;
            return null;
        }
        try {
            LibraryPackageScope libPkgScope = currentLibrary.getLibPkgScope();
            ArrayList<IRfDesignElement> resolvedDesignTops = new ArrayList<IRfDesignElement>();
            for (List<Identifier> designTop : designTops) {
                if (designTop.size() != 1 && designTop.size() != 2) continue;
                Identifier libraryName = designTop.size() == 2 ? designTop.get(0) : new Identifier(currentLibrary.getName(), -1, -1);
                Identifier designName = designTop.size() == 2 ? designTop.get(1) : designTop.get(0);
                List<IRfLibraryElement> libraries = this.getLibraries(rfProject, currentLibrary, libraryName.getName());
                if (libraries == null || libraries.isEmpty()) {
                    int line = libraryName.getLine();
                    int startOffset = libraryName.getOffset();
                    int endOffset = startOffset + libraryName.getName().length();
                    rfProject.addSemanticError(2, "UNDECLARED_LIBRARY: Library ''{0}'' is not declared", libPkgScope, startOffset, endOffset, null, line, this.parserPath, libraryName.getName());
                    continue;
                }
                IRfNamedElement candidate = null;
                for (IRfLibraryElement library : libraries) {
                    candidate = library.getMember(designName.getName(), DVTRfUtils.MEMBERS_DESIGN, null, true, true, false, true, false);
                    if (candidate != null) break;
                }
                if (candidate == null) {
                    int line = designName.getLine();
                    int startOffset = designName.getOffset();
                    int endOffset = startOffset + designName.getName().length();
                    rfProject.addSemanticError(2, "UNDECLARED_MODULE: Module ''{0}'' is not declared", libPkgScope, startOffset, endOffset, null, line, this.parserPath, designName.getName());
                    continue;
                }
                resolvedDesignTops.add((IRfDesignElement)candidate);
            }
            return resolvedDesignTops;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected List<IRfLibraryElement> resolveLiblist(RfProject rfProject, IRfLibraryElement currentLibrary, List<Identifier> liblist) {
        block5: {
            if (liblist != null && !liblist.isEmpty()) break block5;
            return null;
        }
        try {
            LibraryPackageScope libPkgScope = currentLibrary == null ? null : currentLibrary.getLibPkgScope();
            ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
            for (Identifier libraryName : liblist) {
                List<IRfLibraryElement> libraries = this.getLibraries(rfProject, currentLibrary, libraryName.getName());
                if (libraries == null || libraries.isEmpty()) {
                    int line;
                    if (currentLibrary == null || (line = libraryName.getLine()) == -1) continue;
                    int startOffset = libraryName.getOffset();
                    int endOffset = startOffset + libraryName.getName().length();
                    rfProject.addSemanticError(2, "UNDECLARED_LIBRARY: Library ''{0}'' is not declared", libPkgScope, startOffset, endOffset, null, line, this.parserPath, libraryName.getName());
                    continue;
                }
                result.addAll(libraries);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private List<IRfLibraryElement> getLibraries(RfProject rfProject, IRfLibraryElement currentLibrary, String libraryName) {
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        if (currentLibrary != null && libraryName.equals(currentLibrary.getName())) {
            result.add(currentLibrary);
        } else {
            RfLibrary library = rfProject.getLibraryWithPrefix(libraryName, 1);
            if (library != null) {
                result.add(library);
            }
        }
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        List otherLibraries = mixedLangProject.getLibrariesWithPrefix((IRfSingleLangProject)rfProject, libraryName, 1);
        if (otherLibraries != null && !otherLibraries.isEmpty()) {
            result.addAll(otherLibraries);
        }
        return result;
    }

    private void resolveBindingRules(RfProject rfProject, IRfLibraryElement currentLibrary, Map<ElementPath, List<IRfConfigurationRule>> bindingRulesMap) {
        try {
            if (bindingRulesMap == null || bindingRulesMap.isEmpty()) {
                return;
            }
            LibraryPackageScope libPkgScope = currentLibrary.getLibPkgScope();
            for (List<IRfConfigurationRule> bindingRules : bindingRulesMap.values()) {
                if (bindingRules == null || bindingRules.isEmpty()) continue;
                block3: for (IRfConfigurationRule bindingRule : bindingRules) {
                    bindingRule.setResolvedDesignMapping(null);
                    bindingRule.setResolvedLiblist(null);
                    List binding = bindingRule.list();
                    if (bindingRule.getRuleKind() == IRfConfigurationRule.ConfigKind.LIBLIST) {
                        List<IRfLibraryElement> resolvedLiblist = this.resolveLiblist(rfProject, currentLibrary, binding);
                        bindingRule.setResolvedLiblist(resolvedLiblist);
                        continue;
                    }
                    if (bindingRule.getRuleKind() != IRfConfigurationRule.ConfigKind.USE || binding.size() != 1 && binding.size() != 2) continue;
                    Identifier libraryName = binding.size() == 2 ? (Identifier)binding.get(0) : new Identifier(currentLibrary.getName(), -1, -1);
                    Identifier designName = binding.size() == 2 ? (Identifier)binding.get(1) : (Identifier)binding.get(0);
                    this.enclosingLibrary.addReference(designName.getName(), (IRfNamedElement)this);
                    List<IRfLibraryElement> libraries = this.getLibraries(rfProject, currentLibrary, libraryName.getName());
                    if (libraries == null || libraries.isEmpty()) {
                        int line = libraryName.getLine();
                        int startOffset = libraryName.getOffset();
                        int endOffset = startOffset + libraryName.getName().length();
                        rfProject.addSemanticError(2, "UNDECLARED_LIBRARY: Library ''{0}'' is not declared", libPkgScope, startOffset, endOffset, null, line, this.parserPath, libraryName.getName());
                        continue;
                    }
                    IRfDesignElement candidate = null;
                    if (!designName.isConfig()) {
                        for (IRfLibraryElement library : libraries) {
                            candidate = library.getDesignWithPrefix(designName.getName(), 1);
                            if (candidate == null) continue;
                            bindingRule.setResolvedDesignMapping((IRfNamedElement)candidate);
                            continue block3;
                        }
                    }
                    for (IRfLibraryElement library : libraries) {
                        candidate = library.getMember(designName.getName(), DVTRfUtils.MEMBERS_CONFIG, null, true, true, false, true, false);
                        if (!(candidate instanceof IRfConfiguration)) continue;
                        bindingRule.setResolvedDesignMapping((IRfNamedElement)candidate);
                        continue block3;
                    }
                    int line = designName.getLine();
                    int startOffset = designName.getOffset();
                    int endOffset = startOffset + designName.getName().length();
                    String message = designName.isConfig() ? "UNDECLARED_CONFIGURATION: Configuration ''{0}'' is not declared" : "UNDECLARED_MODULE: Module ''{0}'' is not declared";
                    rfProject.addSemanticError(2, message, libPkgScope, startOffset, endOffset, null, line, this.parserPath, designName.getName());
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<IRfDesignElement> getDesignTops() {
        return this.resolvedDesignTops;
    }

    public IRfDesignElement getFirstDesignTop() {
        if (this.resolvedDesignTops == null || this.resolvedDesignTops.isEmpty() || this.resolvedDesignTops.get(0) == null) {
            return ELConstants.UNRESOLVED_INSTANCE_TYPE;
        }
        return this.resolvedDesignTops.get(0);
    }

    private final IRfConfigurationRule getBindingRule(IRfConfigurationRule.ConfigKind configKind, ElementPath instancePath, Map<ElementPath, List<IRfConfigurationRule>> bindingRules) {
        if (bindingRules == null || bindingRules.isEmpty()) {
            return null;
        }
        List<IRfConfigurationRule> rulesList = bindingRules.get(instancePath);
        if (rulesList == null || rulesList.isEmpty()) {
            return null;
        }
        for (IRfConfigurationRule rule : rulesList) {
            if (rule.getRuleKind() != configKind) continue;
            return rule;
        }
        return null;
    }

    public IRfConfigurationRule getInstanceRule(IRfConfigurationRule.ConfigKind configKind, ElementPath instancePath) {
        return this.getBindingRule(configKind, instancePath, this.instanceRules);
    }

    public IRfConfigurationRule getCellRule(IRfConfigurationRule.ConfigKind configKind, String elementName) {
        return this.getBindingRule(configKind, ElementPath.join(null, (String)elementName), this.cellRules);
    }

    public IRfConfigurationRule getCellRule(IRfLibraryElement library, String elementName) {
        return this.getBindingRule(IRfConfigurationRule.ConfigKind.USE, ElementPath.join((ElementPath)ElementPath.join(null, (String)library.getName()), (String)elementName), this.cellRules);
    }

    public boolean isDummyConfig() {
        return false;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "configuration " + this.getName();
    }

    public List<IRfLibraryElement> getDefaultLiblist() {
        return this.defaultLiblist;
    }

    public void setDefaultLiblist(List<IRfLibraryElement> libList) {
        this.defaultLiblist = libList;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONFIGURATION);
    }

    public static void getTopModulesWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, IRfElementFilter elementFilter, RfProject rfProject) {
        if (rfProject == null) {
            return;
        }
        ELManager manager = rfProject.getELManager();
        if (manager == null) {
            return;
        }
        try {
            manager.getTopDesignsWithPrefix(result, prefix, matchType, elementFilter);
        }
        catch (MaxSizeReachedException maxSizeReachedException) {}
    }

    public static IRfDesignElement getTopModule(String name, RfProject rfProject) {
        if (rfProject == null || name == null) {
            return null;
        }
        ELManager manager = rfProject.getELManager();
        if (manager == null) {
            return null;
        }
        return manager.getTopDesign(name);
    }

    protected List<HidOperatorWrapper> getSortedAssignsToComputeConstants(boolean withScope) {
        return HidOperatorVisitorWithPaths.getSortedHidOperators((IRfNamedElement)this, (HidOperatorQualifier[])ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY, (boolean)true);
    }

    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        if (visitor instanceof HHViewUtils.MakeWrapperVisitor) {
            this.internalVisitHidObject(rfProject, visitor, this.instanceRules);
            this.internalVisitHidObject(rfProject, visitor, this.cellRules);
        }
        return super.visitHidObject(rfProject, visitor);
    }

    private void internalVisitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor, Map<ElementPath, List<IRfConfigurationRule>> rulesMap) {
        if (rulesMap == null) {
            return;
        }
        for (Map.Entry<ElementPath, List<IRfConfigurationRule>> instanceRuleEntry : rulesMap.entrySet()) {
            List<IRfConfigurationRule> rules = instanceRuleEntry.getValue();
            if (rules == null || rules.isEmpty()) continue;
            for (IRfConfigurationRule rule : rules) {
                RfHidHolder paramHolder;
                DataType dataType = ((RfConfigurationRule)rule).getDataType();
                if (dataType == null || (paramHolder = dataType.getParamValuesHolder()) == null) continue;
                paramHolder.visitHidObject(rfProject, visitor);
            }
        }
    }

    public Map<ElementPath, List<IRfConfigurationRule>> getInstanceRules() {
        return this.instanceRules;
    }

    public IRfConfiguration getRelativeConfig(ElementPath path) {
        if (path == null) {
            return this;
        }
        RfConfiguration rfConfiguration = new RfConfiguration(path, this);
        return rfConfiguration;
    }
}

