/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfConfigurationRule
extends RfAssociatedType
implements IRfConfigurationRule,
Serializable {
    private static final long serialVersionUID = 2L;
    private ElementPath elementDescription;
    private IRfConfigurationRule.ConfigCoverage ruleType;
    private IRfConfigurationRule.ConfigKind ruleKind;
    private List<Identifier> identifiersList;
    private transient List<IRfLibraryElement> resolvedLiblist;
    private transient IRfNamedElement resolvedMapping;
    private static final DataType DATA_TYPE_UNKNOWN = new DataType("");

    public RfConfigurationRule(String name, IRfConfigurationRule.ConfigCoverage ruleType, IRfConfigurationRule.ConfigKind ruleKind, ElementPath elementDescription, List<Identifier> identifiersList, DataType parametersDataType) {
        super(name, false, parametersDataType != null ? parametersDataType : DATA_TYPE_UNKNOWN);
        this.ruleType = ruleType;
        this.ruleKind = ruleKind;
        this.identifiersList = identifiersList;
        this.elementDescription = elementDescription;
    }

    public IRfConfigurationRule.ConfigCoverage getRuleCoverage() {
        return this.ruleType;
    }

    public IRfConfigurationRule.ConfigKind getRuleKind() {
        return this.ruleKind;
    }

    public List<Identifier> list() {
        return this.identifiersList;
    }

    public void setResolvedLiblist(List<IRfLibraryElement> resolveLiblist) {
        this.resolvedLiblist = resolveLiblist;
    }

    public void setResolvedDesignMapping(IRfNamedElement resolvedMapping) {
        this.resolvedMapping = resolvedMapping;
    }

    public IRfNamedElement getResolvedDesignMapping(ElementPath prefix) {
        if (this.resolvedMapping == null) {
            return ELConstants.UNRESOLVED_INSTANCE_TYPE;
        }
        if (!(this.resolvedMapping instanceof IRfConfiguration) || prefix == null) {
            return this.resolvedMapping;
        }
        IRfConfiguration configuration = (IRfConfiguration)this.resolvedMapping;
        return configuration.getRelativeConfig(prefix);
    }

    public ElementPath getElementDescription() {
        return this.elementDescription;
    }

    public List<IRfLibraryElement> getResolvedLiblist() {
        return this.resolvedLiblist;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "config rule";
    }

    public Map<String, HidOperatorWrapper> getParameterOverrides(boolean markElabOperators) {
        IRfNamedElement design = this.getResolvedDesignMapping(null);
        if (!(design instanceof IRfDesignElement)) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.fParamValuesHolder == null) {
            return null;
        }
        HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY);
        dataType.fParamValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
        return RfConfigurationRule.internalGetParameterOverrides((IRfDesignElement)design, ELUtils.internalComputeParamMap((IRfDesignElement)((IRfDesignElement)design), (IRfNamedElement)this), markElabOperators, visitor.getObjectsWithPaths());
    }

    public List<HidOperatorWrapper> getPortConnections(boolean triggerError, boolean checkTypeMatching) {
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.fParamValuesHolder == null) {
            return null;
        }
        HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(ELConstants.PORT_CONNECTIONS_QUALIFIERS_ARRAY);
        dataType.fParamValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
        return visitor.getObjectsWithPaths();
    }

    @Override
    public String toString() {
        return String.valueOf(this.ruleType.toString()) + " rule " + this.ruleKind.toString() + " for: " + this.elementDescription;
    }
}

