/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfConstraintElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

public class RfConstraint
extends RfMembersHolder
implements IRfConstraintElement {
    private static final long serialVersionUID = 1L;

    public RfConstraint(String name, boolean escaped, int qualifiers) {
        super(name, escaped);
        this.addMember(new RfPredefinedFunction("constraint_mode", new DataType(""), Arrays.asList(new ArgInfo("on_off", RfProject.getSimpleDataType("bit"), null)), 1, "Control whether a constraint is active or inactive."));
        this.setQualifiers(qualifiers);
    }

    @Override
    public RfDefElement addDeclaration(RfDefElement element) {
        if (!(element instanceof RfConstraintDef)) {
            return super.addDeclaration(element);
        }
        if (this.fDefs != null && this.fDefs.size() >= this.internalMaxDefSizePerElement()) {
            return (RfDefElement)this.fDefs.get(0);
        }
        element.addNamedElement(this);
        this.fDefs = this.fDefs == null ? element : (((RfConstraintDef)element).isPrototype() && ((RfConstraintDef)this.fDefs.get(0)).isOutOfClassDefinition() ? OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (int)0, (Object)element) : OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (Object)element));
        return element;
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        List<T> result = super.getLocalMembers(clazz);
        if (clazz != RfFunction.class) {
            return result;
        }
        RfPredefinedFunction predefFunc = new RfPredefinedFunction("constraint_mode", RfProject.getSimpleDataType("int"), null, 0, "Controls whether a constraint is active or inactive. When a constraint is inactive, it is not considered by the randomize() method. All constraints are initially active.");
        predefFunc.setEnclosingScope(this);
        result.add(predefFunc);
        return result;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    protected int internalMaxDefSizePerElement() {
        return 6;
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
        if (this.isExtern() || this.isImplicitExternConstraint()) {
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (enclosingLibrary == null) {
                return;
            }
            RfNamedElement enclosingScope = this;
            while ((enclosingScope = enclosingScope.getEnclosingScope()) instanceof RfClass) {
                String name = enclosingScope.getName();
                if (name == null) {
                    return;
                }
                enclosingLibrary.addReference(name, (IRfNamedElement)this);
                this.addReferenceToIdentifierName(name);
            }
        }
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        if (localMembersKind == RfFunction.class && localMembersSelect == 3 && DVTStringUtil.regionMatches((String)"constraint_mode", (String)prefix, (int)matchType)) {
            RfPredefinedFunction element = new RfPredefinedFunction("constraint_mode", RfProject.getSimpleDataType("int"), null, 0, "Controls whether a constraint is active or inactive. When a constraint is inactive, it is not considered by the randomize() method. All constraints are initially active.");
            if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                result.put("constraint_mode()", element);
            }
        }
    }

    public void init(int qualifiers) {
        this.setQualifiers(qualifiers);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return String.valueOf(this.hasObjectStaticQualifier() ? "static " : "") + "constraint " + this.getName();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_CONSTRAINT: Duplicate constraint ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 1;
    }

    public String getSemanticErrorCodeForUnimplemented() {
        return this.isExtern() ? "UNIMPLEMENTED_EXPLICIT_EXTERNAL_CONSTRAINT: Explicit external constraint ''{0}'' is not implemented" : "EMPTY_IMPLICIT_CONSTRAINT_IMPLEMENTATION: Implicit external constraint ''{0}'' is not implemented";
    }

    public int getSemanticErrorSeverityForUnimplemented() {
        return this.isExtern() ? 1 : 2;
    }

    public String getSemanticErrorCodeForImplementationScope() {
        return RfSemanticError.NON_STANDARD_CONSTRAINT_IMPLEMENTATION_SCOPE;
    }

    public String getSemanticErrorCodeForDuplicateImpl() {
        return "DUPLICATE_CONSTRAINT_IMPL: Duplicate constraint implementation for ''{0}'', already implemented at line {1,number,#######} file {2}";
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (super.checkEquals(obj)) {
            return true;
        }
        if (!(obj instanceof RfConstraint)) {
            return false;
        }
        RfConstraint otherConstraint = (RfConstraint)obj;
        if (!this.getName().equals(otherConstraint.getName())) {
            return false;
        }
        List<RfClass> classFamily = this.computeClassFamily();
        return classFamily.contains(otherConstraint.getEnclosingScope());
    }

    public List<RfClass> computeClassFamily() {
        RfClass rfClass;
        ArrayList<RfClass> result = new ArrayList<RfClass>();
        if (!(this.getEnclosingScope() instanceof RfClass)) {
            return result;
        }
        RfClass firstParent = rfClass = (RfClass)this.getEnclosingScope();
        RfClass candidateParent = rfClass;
        while ((candidateParent = candidateParent.getParent()) != null) {
            RfConstraint candidateConstraint = candidateParent.getLocalMember(RfConstraint.class, this.getName(), false);
            if (candidateConstraint == null) continue;
            firstParent = candidateParent;
        }
        result.add(firstParent);
        this.getChildrenRecursive(result, firstParent);
        return result;
    }

    private void getChildrenRecursive(List<RfClass> result, RfClass clazz) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (result.contains(child)) continue;
            result.add(child);
            this.getChildrenRecursive(result, child);
        }
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
    }

    public boolean isObjectStatic() {
        return this.hasObjectStaticQualifier();
    }
}

