/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class RfCoverbin
extends RfNamedElement
implements IRfCoverbin {
    private static final long serialVersionUID = 1L;
    private boolean isWildcard;
    private boolean isArray;
    private short kind;
    private IHidObject arraySizeExpression;
    private ArrayList<IHidObject> binsExpressions;
    private IHidObject withExpression;
    private IHidObject iffExpression;

    public RfCoverbin(String name, boolean escaped, boolean isWildcard, boolean isArray, int kind) {
        super(name, escaped);
        this.isWildcard = isWildcard;
        this.isArray = isArray;
        this.kind = (short)kind;
    }

    public void init(boolean isWildcard, boolean isArray, int kind) {
        this.isWildcard = isWildcard;
        this.isArray = isArray;
        this.kind = (short)kind;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean isOpen() {
        return this.isArray && this.arraySizeExpression == null;
    }

    public int getKind() {
        return this.kind;
    }

    public IHidObject getArraySizeExpression() {
        return this.arraySizeExpression;
    }

    public void setArraySizeExpression(IHidObject arraySizeExpression) {
        this.arraySizeExpression = arraySizeExpression;
    }

    public ArrayList<IHidObject> getBinExpressions() {
        return this.binsExpressions;
    }

    public void setBinsExpressions(ArrayList<IHidObject> binsExpressions) {
        this.binsExpressions = binsExpressions;
    }

    public IHidObject getWithExpression() {
        return this.withExpression;
    }

    public void setWithExpression(IHidObject withExpression) {
        this.withExpression = withExpression;
    }

    public IHidObject getIffExpression() {
        return this.iffExpression;
    }

    public void setIffExpression(IHidObject iffExpression) {
        this.iffExpression = iffExpression;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.arraySizeExpression = null;
        this.binsExpressions = new ArrayList();
        this.withExpression = null;
        this.iffExpression = null;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_COVERBIN: Duplicate coverbin ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public int getArraySize(IHidEvaluator evaluator, ElementPath hierarchyPath) {
        if (!this.isArray) {
            return -2;
        }
        if (this.arraySizeExpression == null) {
            return -1;
        }
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, (ElementPath)hierarchyPath, (boolean)false, (ELManager)evaluator.getManager());
        BitVectorContext context = BitVectorContext.of((IRfNamedElement)this, (boolean)true);
        ELParamValueScope sizeValue = ELUtils.evaluate((IHidObject)this.arraySizeExpression, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian);
        return ELUtils.isUnsuccessfulEval((ELParamValueScope)sizeValue) ? -2 : sizeValue.intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkEquals(Object obj) {
        void other;
        void var3_2;
        RfCoverbin rfCoverbin;
        Object object = obj;
        return object instanceof RfCoverbin && (rfCoverbin = (RfCoverbin)object) == (RfCoverbin)var3_2 && this.getEnclosingScope().checkEquals(other.getEnclosingScope());
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.COVER_BIN);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        int arraySize = this.getArraySize(resolver, resolver.getHierarchyPath());
        return "bins " + this.printScope() + this.getName() + (this.isArray() ? "[" + (arraySize > 0 ? Integer.valueOf(arraySize) : "") + "]" : "");
    }

    public static final class RfAutomaticCoverbin
    extends RfCoverbin {
        private static final long serialVersionUID = 1L;
        public static final String NAME = "auto";

        public RfAutomaticCoverbin(RfCoverpoint enclosingScope) {
            super(NAME, false, false, true, 0);
            this.setEnclosingScope(enclosingScope);
        }

        @Override
        public boolean isAutomatic() {
            return true;
        }

        @Override
        public boolean isPredefined() {
            return true;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getArraySize(IHidEvaluator evaluator, ElementPath hierarchyPath) {
            void maxAutoBinsValue;
            void structType;
            RfStruct rfStruct;
            void type;
            IRfTypeElement iRfTypeElement;
            void hidForArraySize;
            VlogBitVector vlogBitVector;
            RfCoverpoint enclosingScope = (RfCoverpoint)this.getEnclosingScope();
            IHidObject iHidObject = enclosingScope.getExpression();
            if (!(iHidObject instanceof RfHid var4_5)) {
                return -2;
            }
            RfTypesResolver typesResolver = RfTypesResolver.create(evaluator, this, hierarchyPath, 0, true);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, (ElementPath)typesResolver.getHierarchyPath(), (boolean)false, (ELManager)typesResolver.getManager());
            IHidObject maxAutoBinsOptionExpression = enclosingScope.getMaxAutoBinsOptionExpression();
            ELParamValueScope maxAutoBinsResult = ELUtils.evaluate((IHidObject)maxAutoBinsOptionExpression, (IHidEvaluator)typesResolver, (BitVectorContext)BitVectorContext.of((IRfNamedElement)this, (boolean)true), (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)maxAutoBinsResult) || !(( instanceOfPatternExpressionValue = maxAutoBinsResult.getDVTNumber()) instanceof VlogBitVector) || (vlogBitVector = (VlogBitVector) instanceOfPatternExpressionValue) != (VlogBitVector) instanceOfPatternExpressionValue) {
                return -1;
            }
            typesResolver.setIsExpressionTypeComputation(true);
            ELParamValueScope result = ELUtils.evaluate((IHidObject)hidForArraySize, (IHidEvaluator)typesResolver, (BitVectorContext)BitVectorContext.of((IRfNamedElement)this, (boolean)true), (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)result) || !(( instanceOfPatternExpressionValue = XUtils.getValue((ELParamValueScope)result).getNamedElement()) instanceof IRfTypeElement) || (iRfTypeElement = (IRfTypeElement) instanceOfPatternExpressionValue) != (IRfTypeElement) instanceOfPatternExpressionValue) {
                return -2;
            }
            void  instanceOfPatternExpressionValue2 = type;
            return  instanceOfPatternExpressionValue2 instanceof RfStruct && (rfStruct = (RfStruct) instanceOfPatternExpressionValue2) == (RfStruct) instanceOfPatternExpressionValue2 && structType.isEnum() ? -2 : (int)Long.min(1L << type.getBitSize(), maxAutoBinsValue.intValue());
        }
    }
}

