/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;

public class RfCovercross
extends RfCoverpoint {
    private static final long serialVersionUID = 1L;

    public RfCovercross(String name, boolean escaped) {
        super(name, escaped, RfProject.getSimpleDataType("covercross"));
    }

    @Override
    protected void init() {
        DataType dataTypeVoid = RfProject.getSimpleDataType("void");
        DataType dataTypeReal = RfProject.getSimpleDataType("real");
        DataType dataTypeString = RfProject.getSimpleDataType("string");
        DataType dataTypeInt = RfProject.getSimpleDataType("int");
        RfPredefinedStruct typeOption = new RfPredefinedStruct(this, "struct/covergroup/type_option", "");
        typeOption.setAliasName("type_option");
        this.addMember(typeOption);
        this.addMember(new RfPredefinedTypeAlias("type_option", new DataType("struct/covergroup/type_option"), typeOption, "Options of covergroup type as a whole specified at covercross level"));
        typeOption.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of the covercross for computing the cumulative (or type) coverage of the saved database"));
        typeOption.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "100", "Specifies the target goal for a covercross of a covergroup type"));
        typeOption.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with the coverpoint of the covergroup type. The comment is saved in the coverage database and included in the coverage report"));
        RfPredefinedStruct option = new RfPredefinedStruct(this, "struct/covergroup/option", "");
        option.setAliasName("option");
        this.addMember(option);
        this.addMember(new RfPredefinedTypeAlias("option", new DataType("struct/covergroup/option"), option, "Options of a covergroup instance specified at coverpoint level"));
        option.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of the covercross for computing the instance coverage of the enclosing covergroup"));
        option.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "90", "Specifies the target goal for a covercross of an instance"));
        option.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with a covercross of a covergroup instance. The comment is saved in the coverage database and included in the coverage report"));
        option.addMember(new RfPredefinedField("at_least", dataTypeInt, 1, 1, "1", "Minimum number of hits for each bin. A bin with a hit count that is less than the number is not considered covered"));
        option.addMember(new RfPredefinedField("cross_num_print_missing", dataTypeInt, 1, 1, "64", "Number of missing (not covered) cross product bins that must be saved to the coverage database and printed in the coverage report"));
        option.addMember(new RfNonStandardField("cross_auto_bin_max", dataTypeInt, 1, 1, "0", "NA"));
        RfPredefinedStruct crossValTypeStruct = new RfPredefinedStruct(this, "struct/covergroup/cross_val_type", "");
        crossValTypeStruct.setAliasName("CrossValType");
        this.addMember(crossValTypeStruct);
        this.addMember(new RfPredefinedTypeAlias("CrossValType", new DataType("struct/CrossValType"), crossValTypeStruct, "CrossValType is a SystemVerilog struct consisting of one member for each coverpoint in the cross"));
        DataType crossQueueTypeDT = new DataType("CrossValType");
        crossQueueTypeDT.appendUnpackedDimension(RfProject.getSimpleDataType("$"));
        QueueType crossQueueType = new QueueType(crossQueueTypeDT, crossValTypeStruct, this);
        this.addMember(crossQueueType);
        this.addMember(new RfPredefinedTypeAlias("CrossQueueType", new DataType("CrossQueueType"), crossQueueType, "CrossQueueType is an unbounded queue of CrossValType elements"));
        ArrayList<ArgInfo> args = new ArrayList<ArgInfo>();
        DataType refDataTypeInt = new DataType("int");
        refDataTypeInt.setDirection(4);
        args.add(new ArgInfo("arg0", refDataTypeInt, null));
        args.add(new ArgInfo("arg1", refDataTypeInt, null));
        this.addMember(new RfPredefinedFunction("get_coverage", dataTypeReal, args, 0, "Calculates type coverage number (0..100)"));
        this.addMember(new RfPredefinedFunction("get_inst_coverage", dataTypeReal, args, 0, "Calculates the coverage number (0..100)"));
        this.addMember(new RfPredefinedFunction("start", dataTypeVoid, null, 0, "Starts collecting coverage information"));
        this.addMember(new RfPredefinedFunction("stop", dataTypeVoid, null, 0, "Stops collecting coverage information"));
        this.setAnonymous(this.getName().indexOf(64) > 0);
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentsWithPrefix(prefix, matchType);
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentWithPrefix(prefix, matchType);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_COVER_CROSS: Duplicate cover cross ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return super.getSemanticErrorSeverityForDuplicate();
    }

    @Override
    public boolean isNamed() {
        return !this.getName().contains("@");
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
    }

    @Override
    public String getAssociatedTypeName(IRfScopeElement scope, RfTypesResolver typesResolver, int qualifiedNameOptions, boolean useDataType, boolean keepMacros, boolean noDimensionsForArrayOfInstances) {
        return "covercross";
    }

    public boolean isCross() {
        return true;
    }

    public static class QueueType
    extends RfComputedListType {
        private static final long serialVersionUID = 2L;

        public QueueType(DataType dataType, RfPredefinedStruct baseElementType, RfCovercross covercross) {
            super(dataType, covercross, (IRfTypeElement)baseElementType, new RfComputedListType.Dimension[]{RfComputedListType.QUEUE_DIMENSION}, 0, 0);
        }

        @Override
        public String getComment() {
            return "PREDEFINED: CrossQueueType is an unbounded queue of CrossValType elements";
        }

        @Override
        public boolean isPredefined() {
            return true;
        }

        @Override
        public boolean isDirtyElement() {
            return false;
        }

        @Override
        public String getKey() {
            return "__dvt__CrossQueueType";
        }

        @Override
        protected void removeDirtyElements(Iterator<? extends RfNamedElement> it, ParserPath parserPath, RfProject project, Map<ParserPath, Collection<RfNamedElement>> createdClassFragments) {
        }
    }
}

