/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedCoverpoint;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class RfCovergroup
extends RfMembersHolder
implements IRfCovergroup,
IRfTypeElement {
    private static final long serialVersionUID = 2L;
    public static final String ANONYMOUS_PREFIX = "covergroup@";
    protected static final String TYPE_OPTION_STRUCT_NAME = "struct/covergroup/type_option";
    protected static final String OPTION_STRUCT_NAME = "struct/covergroup/option";
    protected static final String CROSS_VAL_STRUCT_NAME = "struct/covergroup/cross_val_type";
    protected static final String CROSS_QUEUE_TYPE_NAME = "CrossQueueType";
    protected static final String CROSS_QUEUE_TYPE_UNIQUE_KEY = "__dvt__CrossQueueType";
    private static final String MAX_AUTO_BINS_OPTION_NAME = "auto_bin_max";
    private static final String MAX_AUTO_BINS_OPTION_DEFAULT_VALUE = "64";
    private String eventName;
    private transient IHidObject maxAutoBinsOptionExpression;
    private transient DVTLinkedHashMap<String, RfNamedElement> membersAndPredefinedCoverpoints;

    protected static IHidObject getMaxAutoBinsOptionExpression(RfHidHolder hidHolder, RfProject rfProject) {
        final IHidObject[] maxAutoBinsOptionExpression = new IHidObject[1];
        hidHolder.visitHidObject(rfProject, (IHidVisitor)new IHidVisitor<RfHidOperator>(){

            public boolean visit(RfHidOperator hidOperator) {
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                IHidObject lhSide = hidOperator.getLHValue();
                if (!(lhSide instanceof RfHid var3_4 && RfCovergroup.MAX_AUTO_BINS_OPTION_NAME.equals(hid.getName()) && ( instanceOfPatternExpressionValue = hid.getParentHid()) instanceof RfHid && (var4_6 = (RfHid) instanceOfPatternExpressionValue) == (RfHid) instanceOfPatternExpressionValue && "option".equals(parentHid.getName()))) {
                    return true;
                }
                maxAutoBinsOptionExpression[0] = hidOperator.getFirstRHValue();
                return false;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
        return maxAutoBinsOptionExpression[0];
    }

    public RfCovergroup(String name, boolean escaped, boolean isAnonymous, List<ArgInfo> arguments) {
        super(name, escaped);
        this.setAnonymous(isAnonymous);
        DataType dataTypeVoid = RfProject.getSimpleDataType("void");
        DataType dataTypeReal = RfProject.getSimpleDataType("real");
        DataType dataTypeBit = RfProject.getSimpleDataType("bit");
        DataType dataTypeString = RfProject.getSimpleDataType("string");
        DataType dataTypeInt = RfProject.getSimpleDataType("int");
        this.addMember(new RfPredefinedFunction("new", new DataType(name), arguments, 2, "Covergroup constructor"));
        this.addMember(new RfPredefinedFunction("sample", dataTypeVoid, null, 0, "Triggers sampling on the covergroup"));
        ArrayList<ArgInfo> args = new ArrayList<ArgInfo>();
        DataType refDataTypeInt = new DataType("int");
        refDataTypeInt.setDirection(4);
        args.add(new ArgInfo("arg0", refDataTypeInt, null));
        args.add(new ArgInfo("arg1", refDataTypeInt, null));
        this.addMember(new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), args, 0, "Calculates type coverage number (0..100)", 32768));
        this.addMember(new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), args, 0, "Calculates the coverage number (0..100)"));
        args = new ArrayList();
        args.add(new ArgInfo("name", dataTypeString, null));
        this.addMember(new RfPredefinedFunction("set_inst_name", dataTypeVoid, args, 0, "Sets the instance name to the given string"));
        this.addMember(new RfPredefinedFunction("start", dataTypeVoid, null, 0, "Starts collecting coverage information"));
        this.addMember(new RfPredefinedFunction("stop", dataTypeVoid, null, 0, "Stops collecting coverage information"));
        RfPredefinedStruct typeOption = new RfPredefinedStruct(this, TYPE_OPTION_STRUCT_NAME, "");
        typeOption.setAliasName("type_option");
        this.addMember(typeOption);
        this.addMember(new RfPredefinedTypeAlias("type_option", new DataType(TYPE_OPTION_STRUCT_NAME), typeOption, "Options of covergroup type as a whole"));
        typeOption.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of this covergroup for computing the overall cumulative (or type) coverage of the saved database"));
        typeOption.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "100", "Specifies the target goal for a covergroup type"));
        typeOption.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with the covergroup type. The comment is saved in the coverage database and included in the coverage report"));
        typeOption.addMember(new RfPredefinedField("strobe", dataTypeBit, 1, 1, "0", "When true, all samples happen at the end of the time slot, like the $strobe system task"));
        typeOption.addMember(new RfNonStandardField("real_interval", dataTypeReal, 1, 1, null, "NA"));
        typeOption.addMember(new RfPredefinedField("merge_instances", dataTypeBit, 1, 1, "0", "When true, cumulative (or type) coverage is computed by merging instances together as the union of coverage of all instances. When false, type coverage is computed as the weighted average of instances"));
        RfPredefinedStruct option = new RfPredefinedStruct(this, OPTION_STRUCT_NAME, "");
        option.setAliasName("option");
        this.addMember(option);
        this.addMember(new RfPredefinedTypeAlias("option", new DataType(OPTION_STRUCT_NAME), option, "Options of a covergroup instance"));
        option.addMember(new RfPredefinedField("name", dataTypeString, 1, 1, "unique name", "Specifies a name for the covergroup instance. If not specified, a unique name for each instance is automatically generated by the tool"));
        option.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of this covergroup instance for computing the overall instance coverage of the system"));
        option.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "90", "Specifies the target goal for a covergroup instance"));
        option.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with the instance of a covergroup. The comment is saved in the coverage database and included in the coverage report"));
        option.addMember(new RfPredefinedField("at_least", dataTypeInt, 1, 1, "1", "Minimum number of hits for each bin. A bin with a hit count that is less than the number is not considered covered"));
        option.addMember(new RfPredefinedField(MAX_AUTO_BINS_OPTION_NAME, dataTypeInt, 1, 1, MAX_AUTO_BINS_OPTION_DEFAULT_VALUE, "Maximum number of automatically created bins when no bins are explicitely defined for a coverpoint"));
        option.addMember(new RfPredefinedField("cross_num_print_missing", dataTypeInt, 1, 1, "0", "Number of missing (not covered) cross product bins that must be saved to the coverage database and printed in the coverage report"));
        option.addMember(new RfPredefinedField("detect_overlap", dataTypeBit, 1, 1, "0", "When true, a warning is issued if there is an overlap between the range list (or transition list) of two bins of a coverpoint"));
        option.addMember(new RfPredefinedField("per_instance", dataTypeBit, 1, 1, "0", "Each instance contributes to the overall coverage information for the covergroup type. When true, coverage information for this covergroup instance is tracked as well"));
        option.addMember(new RfPredefinedField("get_inst_coverage", dataTypeBit, 1, 1, "0", "Only applies when the merge_instances type option is set. Enables the tracking of per instance coverage with the get_inst_coverage built-in method. When false, the value returned by get_inst_coverage shall equal the value returned by get_coverage"));
        option.addMember(new RfNonStandardField("cross_auto_bin_max", dataTypeInt, 1, 1, "0", "NA"));
    }

    public RfCovergroup(RfCovergroup other, RfNamedElement enclosingScope) {
        super(other.getName(), other.isEscaped());
        this.membersAndPredefinedCoverpoints = other.membersAndPredefinedCoverpoints;
        this.setEnclosingScope(enclosingScope);
        this.internalSetMembers((DVTLinkedHashMap<String, RfNamedElement>)other.fMembers);
        this.internalSetHidHolder(other.getHidHolder());
    }

    public void init(List<ArgInfo> arguments) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members != null) {
            members.remove((Object)"new");
        }
        this.addMember(new RfPredefinedFunction("new", new DataType(this.getName()), arguments, 2, "Covergroup constructor"));
        this.membersAndPredefinedCoverpoints = null;
    }

    public void addPredefinedCoverpoint(RfField field) {
        RfNamedElement existingMember;
        RfCoverpoint coverpoint = this.getLocalMember(RfCoverpoint.class, field.getName(), false);
        if (coverpoint != null) {
            return;
        }
        if (!(field.isVariable() || field.isArgument() || field.isField())) {
            return;
        }
        if (this.membersAndPredefinedCoverpoints == null) {
            this.membersAndPredefinedCoverpoints = new DVTLinkedHashMap(this.internalGetMembers());
        }
        if ((existingMember = (RfNamedElement)this.membersAndPredefinedCoverpoints.get((Object)field.getName())) != null) {
            RfDuplicate container = new RfDuplicate(existingMember.getName(), existingMember.isEscaped());
            container.setEnclosingScope(this);
            container.addMember(existingMember);
            container.addMember(new RfPredefinedCoverpoint(this, field));
            this.membersAndPredefinedCoverpoints.put(null, (IDVTMapElement)container);
        } else {
            this.membersAndPredefinedCoverpoints.put(null, (IDVTMapElement)new RfPredefinedCoverpoint(this, field));
        }
    }

    public RfCovergroup getOriginal() {
        return this;
    }

    @Override
    public String getKey() {
        return this.isAnonymous() ? ANONYMOUS_PREFIX + this.getName() : this.getName();
    }

    public boolean isComplete() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof IRfTypeElement) {
            return ((IRfTypeElement)enclosingScope).isComplete();
        }
        return !(enclosingScope instanceof IRfDesignElement) || enclosingScope instanceof IRfLibraryElement;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    protected void addMember(RfNamedElement element) {
        RfNamedElement existing = null;
        String name = element.getName();
        if (this.fMembers == null) {
            this.fMembers = new DVTLinkedHashMap();
        } else {
            existing = (RfNamedElement)this.fMembers.get((Object)name);
        }
        if (existing == null || existing instanceof RfPredefinedFunction && "sample".equals(name) && element instanceof RfFunction) {
            this.fMembers.put((Object)name, (IDVTMapElement)element);
        } else {
            super.addMember(element);
        }
        element.setEnclosingScope(this);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "covergroup " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    public IHidObject getMaxAutoBinsOptionExpression() {
        if (this.maxAutoBinsOptionExpression == null) {
            this.maxAutoBinsOptionExpression = RfCovergroup.getMaxAutoBinsOptionExpression(this.internalGetHidHolder(), this.getRfProject());
            if (this.maxAutoBinsOptionExpression == null) {
                this.maxAutoBinsOptionExpression = RfHidImplicit.makeImplicit(MAX_AUTO_BINS_OPTION_DEFAULT_VALUE, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
            }
        }
        return this.maxAutoBinsOptionExpression;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(boolean rawMembers) {
        return rawMembers || this.membersAndPredefinedCoverpoints == null ? this.internalGetMembers() : this.membersAndPredefinedCoverpoints;
    }

    @Override
    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        Collection<RfNamedElement> result = super.getMembers(rawMembers, unpackDuplicates);
        if (rawMembers) {
            return result;
        }
        result = new ArrayList<RfNamedElement>(result);
        RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_coverage_2");
        result.add(predefFunc);
        predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)");
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
        result.add(predefFunc);
        return result;
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        List<T> result = super.getLocalMembers(clazz);
        if (clazz != RfFunction.class) {
            return result;
        }
        if (result == null) {
            result = new ArrayList<T>(2);
        }
        RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_coverage_2");
        result.add(predefFunc);
        predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
        result.add(predefFunc);
        return result;
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
        T result = super.getLocalMember(clazz, name, rawMembers);
        if (result != null) {
            return result;
        }
        if (clazz != RfFunction.class) {
            return result;
        }
        if (name.equals("get_coverage")) {
            RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
            predefFunc.setNameForNoDuplicateList("get_coverage_2");
            predefFunc.setEnclosingScope(this);
            return (T)predefFunc;
        }
        if (name.equals("get_inst_coverage")) {
            RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)", 32768);
            predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
            predefFunc.setEnclosingScope(this);
            return (T)predefFunc;
        }
        return result;
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        if (localMembersKind == RfFunction.class && localMembersSelect == 3) {
            RfPredefinedFunction element;
            if (DVTStringUtil.regionMatches((String)"get_coverage", (String)prefix, (int)matchType)) {
                element = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)");
                element.setNameForNoDuplicateList("get_coverage_2");
                element.setEnclosingScope(this);
                if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                    result.put("get_coverage()", element);
                }
            }
            if (DVTStringUtil.regionMatches((String)"get_inst_coverage", (String)prefix, (int)matchType)) {
                element = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)");
                element.setNameForNoDuplicateList("get_inst_coverage_2");
                element.setEnclosingScope(this);
                if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                    result.put("get_inst_coverage()", element);
                }
            }
        }
    }

    @Override
    protected <T extends RfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, T> result, Class<T> localMembersKind, int localMembersSelect, boolean first, int matchType, String prefix, int local) {
        if (visited != null && visited.contains(this)) {
            return;
        }
        if (local == 1 || localMembersKind == RfCovergroup.class) {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, local);
        } else if (localMembersKind == RfField.class || localMembersKind == RfFunction.class) {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, 1);
        } else {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, local);
        }
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.maxAutoBinsOptionExpression = null;
        this.membersAndPredefinedCoverpoints = null;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_COVERGROUP: Duplicate covergroup ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVERGROUP);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.eventName = null;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement enclosingScope;
        if (previous != null && IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
            return;
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = this.getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
        }
        result.append(this.getName());
        if (previous != null) {
            result.append(previous.isObjectStatic() ? "::" : ".");
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getClass() == obj.getClass();
    }

    public IRfMethodElement xGetConstructor() {
        return this.getLocalMember(RfFunction.class, "new", true);
    }

    public IRfNamedElement xGetComputedElement(IHidEvaluator enclosingOrDescendantScope, boolean isLinterStaticAnalysisMode) {
        if (this.isComplete() || enclosingOrDescendantScope == null) {
            return this;
        }
        RfTypesResolver resolver = RfTypesResolver.create(enclosingOrDescendantScope, null, null, 0, false);
        return resolver.computeCovergroup(this, new ParametricDependency(1));
    }
}

