/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCoverbin;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

public class RfCoverpoint
extends RfField
implements IRfCoverpoint {
    private static final long serialVersionUID = 1L;
    private DVTLinkedHashMap<String, RfNamedElement> fMembers;
    private transient RfNamedElement.LinterSpecific1 fLinterSpecific;
    private RfNamedElement.NamesCache fNamesCache;
    private boolean hasAutomaticCoverbin = true;
    private transient RfHidHolder fHidHolder;
    private IHidObject expression;
    private transient IHidObject maxAutoBinsOptionExpression;

    public RfCoverpoint(String name, boolean escaped, DataType dataType) {
        super(name, escaped, dataType, 2048, 0, null);
        this.init();
    }

    protected void init() {
        DataType dataTypeVoid = RfProject.getSimpleDataType("void");
        DataType dataTypeReal = RfProject.getSimpleDataType("real");
        DataType dataTypeBit = RfProject.getSimpleDataType("bit");
        DataType dataTypeString = RfProject.getSimpleDataType("string");
        DataType dataTypeInt = RfProject.getSimpleDataType("int");
        RfPredefinedStruct typeOption = new RfPredefinedStruct(this, "struct/covergroup/type_option", "");
        typeOption.setAliasName("type_option");
        this.addMember(typeOption);
        this.addMember(new RfPredefinedTypeAlias("type_option", new DataType("struct/covergroup/type_option"), typeOption, "Options of covergroup type as a whole specified at coverpoint level"));
        typeOption.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of the coverpoint for computing the cumulative (or type) coverage of the saved database"));
        typeOption.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "100", "Specifies the target goal for a coverpoint of a covergroup type"));
        typeOption.addMember(new RfNonStandardField("real_interval", dataTypeReal, 1, 1, null, "NA"));
        typeOption.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with the coverpoint of the covergroup type. The comment is saved in the coverage database and included in the coverage report"));
        RfPredefinedStruct option = new RfPredefinedStruct(this, "struct/covergroup/option", "");
        option.setAliasName("option");
        this.addMember(option);
        this.addMember(new RfPredefinedTypeAlias("option", new DataType("struct/covergroup/option"), option, "Options of a covergroup instance specified at coverpoint level"));
        option.addMember(new RfPredefinedField("weight", dataTypeInt, 1, 1, "1", "Specifies the weight of the coverpoint for computing the instance coverage of the enclosing covergroup"));
        option.addMember(new RfPredefinedField("goal", dataTypeInt, 1, 1, "90", "Specifies the target goal for a coverpoint"));
        option.addMember(new RfPredefinedField("comment", dataTypeString, 1, 1, "\"\"", "A comment that appears with the instance of a coverpoint. The comment is saved in the coverage database and included in the coverage report"));
        option.addMember(new RfPredefinedField("at_least", dataTypeInt, 1, 1, "1", "Minimum number of hits for each bin. A bin with a hit count that is less than the number is not considered covered"));
        option.addMember(new RfPredefinedField("auto_bin_max", dataTypeInt, 1, 1, "64", "Maximum number of automatically created bins when no bins are explicitely defined for a coverpoint"));
        option.addMember(new RfPredefinedField("detect_overlap", dataTypeBit, 1, 1, "0", "When true, a warning is issued if there is an overlap between the range list (or transition list) of two bins of a coverpoint"));
        ArrayList<ArgInfo> args = new ArrayList<ArgInfo>();
        DataType refDataTypeInt = new DataType("int");
        refDataTypeInt.setDirection(4);
        args.add(new ArgInfo("arg0", refDataTypeInt, null));
        args.add(new ArgInfo("arg1", refDataTypeInt, null));
        this.addMember(new RfPredefinedFunction("get_coverage", dataTypeReal, args, 0, "Calculates type coverage number (0..100)"));
        this.addMember(new RfPredefinedFunction("get_inst_coverage", dataTypeReal, args, 0, "Calculates the coverage number (0..100)"));
        this.addMember(new RfPredefinedFunction("start", dataTypeVoid, null, 0, "Starts collecting coverage information"));
        this.addMember(new RfPredefinedFunction("stop", dataTypeVoid, null, 0, "Stops collecting coverage information"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addMember(RfNamedElement element) {
        void coverbin;
        void var3_2;
        RfCoverbin rfCoverbin;
        super.addMember(element);
        RfNamedElement rfNamedElement = element;
        this.hasAutomaticCoverbin &= !(rfNamedElement instanceof RfCoverbin) || (rfCoverbin = (RfCoverbin)rfNamedElement) != (RfCoverbin)var3_2 || !"auto".equals(coverbin.getName()) && coverbin.getKind() != 0;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.expression = null;
        this.maxAutoBinsOptionExpression = null;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        return null;
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        return null;
    }

    public IHidObject getMaxAutoBinsOptionExpression() {
        if (this.maxAutoBinsOptionExpression == null) {
            if (this.fHidHolder != null) {
                this.maxAutoBinsOptionExpression = RfCovergroup.getMaxAutoBinsOptionExpression(this.fHidHolder, this.getRfProject());
            }
            if (this.maxAutoBinsOptionExpression == null) {
                this.maxAutoBinsOptionExpression = ((RfCovergroup)this.getEnclosingScope()).getMaxAutoBinsOptionExpression();
            }
        }
        return this.maxAutoBinsOptionExpression;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentsWithPrefix(prefix, matchType);
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getArgumentWithPrefix(prefix, matchType);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_COVERPOINT: Duplicate coverpoint ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return super.getSemanticErrorSeverityForDuplicate();
    }

    public String getCoverpointExpr() {
        return this.expression != null ? HidUtils.toNiceString((IHidObject)this.expression) : null;
    }

    public IHidObject getExpression() {
        return this.expression;
    }

    public void setExpression(IHidObject expression) {
        this.expression = expression;
    }

    @Override
    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        Collection<RfNamedElement> result = super.getMembers(rawMembers, unpackDuplicates);
        if (rawMembers) {
            return result;
        }
        result = new ArrayList<RfNamedElement>(result);
        RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_coverage_2");
        result.add(predefFunc);
        predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
        result.add(predefFunc);
        return result;
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        List<Object> result = super.getLocalMembers(clazz);
        if (clazz != RfFunction.class) {
            if (this.hasAutomaticCoverbin && clazz == RfCoverpoint.class) {
                if (result == null) {
                    result = Arrays.asList(new RfCoverbin.RfAutomaticCoverbin(this));
                } else {
                    result.add(new RfCoverbin.RfAutomaticCoverbin(this));
                }
            }
            return result;
        }
        if (result == null) {
            result = new ArrayList<T>(2);
        }
        RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_coverage_2");
        result.add(predefFunc);
        predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)", 32768);
        predefFunc.setEnclosingScope(this);
        predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
        result.add(predefFunc);
        return result;
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
        T result = super.getLocalMember(clazz, name, rawMembers);
        if (result != null) {
            return result;
        }
        if (clazz != RfFunction.class) {
            return (T)(this.hasAutomaticCoverbin && clazz == RfCoverpoint.class && "auto".equals(name) ? new RfCoverbin.RfAutomaticCoverbin(this) : result);
        }
        if (name.equals("get_coverage")) {
            RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)", 32768);
            predefFunc.setNameForNoDuplicateList("get_coverage_2");
            predefFunc.setEnclosingScope(this);
            return (T)predefFunc;
        }
        if (name.equals("get_inst_coverage")) {
            RfPredefinedFunction predefFunc = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)", 32768);
            predefFunc.setNameForNoDuplicateList("get_inst_coverage_2");
            predefFunc.setEnclosingScope(this);
            return (T)predefFunc;
        }
        return result;
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        RfNamedElement element;
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        if (localMembersKind == RfCoverbin.class && this.hasAutomaticCoverbin && DVTStringUtil.regionMatches((String)"auto", (String)prefix, (int)matchType)) {
            element = new RfCoverbin.RfAutomaticCoverbin(this);
            if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                result.put("auto", element);
            }
        }
        if (localMembersKind == RfFunction.class && localMembersSelect == 3) {
            if (DVTStringUtil.regionMatches((String)"get_coverage", (String)prefix, (int)matchType)) {
                element = new RfPredefinedFunction("get_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates type coverage number (0..100)");
                ((RfPredefinedFunction)element).setNameForNoDuplicateList("get_coverage_2");
                element.setEnclosingScope(this);
                if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                    result.put("get_coverage()", element);
                }
            }
            if (DVTStringUtil.regionMatches((String)"get_inst_coverage", (String)prefix, (int)matchType)) {
                element = new RfPredefinedFunction("get_inst_coverage", RfProject.getSimpleDataType("real"), null, 0, "Calculates the coverage number (0..100)");
                ((RfPredefinedFunction)element).setNameForNoDuplicateList("get_inst_coverage_2");
                element.setEnclosingScope(this);
                if ((validator == null || validator.hasProperty(element, kind)) && (validator == null || validator.accessModifier(element, accessModifier))) {
                    result.put("get_inst_coverage()", element);
                }
            }
        }
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        RfField candidate;
        RfFunction sampleCovergroupFunction;
        RfCovergroup enclosingCovergroup;
        if (isFirst && (classes == null || classes.contains(RfField.class)) && (enclosingCovergroup = this.getEnclosingScope(RfCovergroup.class)) != null && (sampleCovergroupFunction = enclosingCovergroup.getLocalFunction("sample")) != null && (candidate = sampleCovergroupFunction.getLocalMember(RfField.class, name, true)) != null && candidate != exclude) {
            return candidate;
        }
        return super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (this.getName().equals(this.getCoverpointExpr()) && obj instanceof RfField) {
            RfNamedElement fieldScope = ((RfField)obj).getEnclosingScope();
            RfNamedElement cpointScope = this.getEnclosingScope();
            if (fieldScope != null && cpointScope != null) {
                if (fieldScope == (cpointScope = cpointScope.getEnclosingScope())) {
                    return this.getName().equals(((RfField)obj).getName());
                }
                if (fieldScope instanceof RfClass && cpointScope instanceof RfClass && ((RfClass)cpointScope).isSubClass((RfClass)fieldScope)) {
                    return this.getName().equals(((RfField)obj).getName());
                }
            }
        }
        return super.checkEquals(obj);
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
    }

    @Override
    protected final DVTLinkedHashMap<String, RfNamedElement> internalGetMembers() {
        return this.fMembers;
    }

    @Override
    protected final void internalSetMembers(DVTLinkedHashMap<String, RfNamedElement> members) {
        this.fMembers = members;
    }

    @Override
    protected final RfNamedElement.LinterSpecific1 internalGetLinterSpecific1() {
        return this.fLinterSpecific;
    }

    @Override
    protected final void internalSetLinterSpecific1(RfNamedElement.LinterSpecific1 linterSpecific) {
        this.fLinterSpecific = linterSpecific;
    }

    @Override
    protected final RfNamedElement.NamesCache internalGetNamesCache() {
        return this.fNamesCache;
    }

    @Override
    protected final void internalSetNamesCache(RfNamedElement.NamesCache namesCache) {
        this.fNamesCache = namesCache;
    }

    @Override
    protected final RfHidHolder internalGetHidHolder() {
        return this.fHidHolder;
    }

    @Override
    protected final void internalSetHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    @Override
    public String getAssociatedTypeName(IRfScopeElement scope, RfTypesResolver typesResolver, int qualifiedNameOptions, boolean useDataType, boolean keepMacros, boolean noDimensionsForArrayOfInstances) {
        return "coverpoint";
    }
}

