/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.ICommentBlockElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.HeaderCommentBlock;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IFileDocumentListener;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.utils.Utils;

public abstract class RfDefElement
implements Serializable,
IFileDocumentListener,
IRfScope,
IRfDefElement,
IDVTMapElement<RfDefElement>,
ListContainer<RfDefElement>,
IRfBreadcrumbElement {
    private static final long serialVersionUID = 3L;
    private int fStartLine;
    private int fEndLine;
    private int fStartRealOffset;
    private int fEndRealOffset;
    private int fStartVirtualOffset;
    private CommentBlock fDefComment;
    protected transient DVTLinkedHashMap<RfDefElement, RfDefElement> fChildrenDefs;
    private int fHashCode;
    private ReparseInfo fReparseInfo;
    protected transient Object fNamedElements;
    private transient Position fPosition;
    private transient RfFileDef fDefFile;
    private int fEndLabel;
    private boolean fHasNameInsideMacro;

    public int getEndLabelOffset() {
        return this.fEndLabel;
    }

    public boolean hasEndLabel() {
        return this.fEndLabel != -1;
    }

    public void setEndLabel(int endLabel) {
        this.fEndLabel = endLabel;
    }

    public RfDefElement(RfFileDef file, String name, IRfActionBlockElement.BlockQualifier blockType, LineInfo startInfo, LineInfo endInfo, CommentBlock comment, ReparseInfo reparseInfo) {
        this.fDefFile = file;
        this.fStartLine = startInfo == null ? -1 : startInfo.line;
        this.fEndLine = endInfo == null ? -1 : endInfo.line;
        this.fStartRealOffset = startInfo == null ? -1 : startInfo.realOffset;
        this.fEndRealOffset = endInfo == null ? -1 : endInfo.realOffset;
        this.fStartVirtualOffset = startInfo == null ? -1 : startInfo.virtOffset;
        this.fHasNameInsideMacro = this.fStartVirtualOffset != -1;
        this.setDefComment(comment);
        this.fReparseInfo = reparseInfo;
        this.internalComputeHashCode(name, blockType);
        this.fEndLabel = -1;
    }

    public RfDefElement(RfFileDef file, String name, LineInfo startInfo, LineInfo endInfo, CommentBlock comment, ReparseInfo reparseInfo) {
        this(file, name, null, startInfo, endInfo, comment, reparseInfo);
    }

    public RfDefElement(RfFileDef file, WrapperInfo info) {
        this(file, info.getName(), info.getBlockType(), info.getStartInfo(), info.getEndInfo(), info.getComment(), info.getReparseInfo());
    }

    public RfDefElement getKey() {
        return this;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.other";
    }

    public RfNamedElement getEnclosingScope() {
        return this.getNamedElement();
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfNamedElement scope = this.getNamedElement();
        if (scope == null) {
            return null;
        }
        return scope.getEnclosingScope(clazz);
    }

    public IRfNamedElement getEnclosingScope(Set<?> classes) {
        RfNamedElement scope = this.getNamedElement();
        if (scope == null) {
            return null;
        }
        return scope.getEnclosingScope(classes);
    }

    public void addNamedElement(RfNamedElement namedElem) {
        if (namedElem == null) {
            return;
        }
        if (this.fNamedElements == null) {
            this.fNamedElements = namedElem;
        } else if (this.fNamedElements instanceof RfNamedElement) {
            if (namedElem == this.fNamedElements) {
                return;
            }
            ArrayList<RfNamedElement> namedElements = new ArrayList<RfNamedElement>(4);
            namedElements.add((RfNamedElement)this.fNamedElements);
            namedElements.add(namedElem);
            this.fNamedElements = namedElements;
        } else {
            if (((List)this.fNamedElements).contains(namedElem)) {
                return;
            }
            ((List)this.fNamedElements).add(namedElem);
        }
    }

    public void removeNamedElement(RfNamedElement namedElem) {
        if (namedElem == null) {
            return;
        }
        if (this.fNamedElements == namedElem) {
            this.fNamedElements = null;
        } else if (!(this.fNamedElements instanceof RfNamedElement)) {
            ((ArrayList)this.fNamedElements).remove(namedElem);
        }
    }

    public RfFileDef getDefFile() {
        return this.fDefFile;
    }

    public ParserPath getParserPath() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getParserPath();
    }

    public LanguageKind getLanguageKind() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getLanguageKind();
    }

    public IResource getFileAdapter() {
        if (this.fDefFile != null) {
            return this.fDefFile.getFileAdapter();
        }
        return null;
    }

    public void setDefComment(CommentBlock comment) {
        if (comment instanceof HeaderCommentBlock) {
            ((HeaderCommentBlock)comment).setTransientReference((ICommentBlockElement)this);
        }
        this.fDefComment = comment;
    }

    public boolean isDeprecated() {
        return this.fDefComment != null && this.fDefComment.isDeprecated();
    }

    public String getDefComment() {
        return this.fDefComment == null ? "" : this.fDefComment.toString();
    }

    public String getRawDefComment() {
        return this.fDefComment == null ? "" : this.fDefComment.toRawString();
    }

    public CommentBlock getCommentBlock() {
        return this.fDefComment;
    }

    public boolean hasInlineComment() {
        return this.fDefComment == null ? false : this.fDefComment.hasInlineComment();
    }

    @Override
    public RfNamedElement getNamedElement() {
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return (RfNamedElement)((List)this.fNamedElements).get(0);
        }
        return (RfNamedElement)this.fNamedElements;
    }

    @Deprecated
    public RfNamedElement getLastNamedElement() {
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return (RfNamedElement)((List)this.fNamedElements).get(((List)this.fNamedElements).size() - 1);
        }
        return (RfNamedElement)this.fNamedElements;
    }

    public List<RfNamedElement> getNamedElements() {
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return (List)this.fNamedElements;
        }
        if (this.fNamedElements == null) {
            return null;
        }
        return Collections.singletonList((RfNamedElement)this.fNamedElements);
    }

    public int getNamedElementsSize() {
        if (this.fNamedElements instanceof List) {
            return ((List)this.fNamedElements).size();
        }
        return this.fNamedElements == null ? 0 : 1;
    }

    @Override
    public boolean connectPositionToDocument(IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        block8: {
            block7: {
                if (document != null) break block7;
                return false;
            }
            if (!this.hasStartVirtualOffset()) break block8;
            return false;
        }
        try {
            if (this.fStartRealOffset > 0 && this.fEndRealOffset >= this.fStartRealOffset && document.getLength() >= this.fEndRealOffset) {
                DVTPosition position = new DVTPosition(this.fStartRealOffset, this.fEndRealOffset - this.fStartRealOffset + 1);
                Position existingPosition = cachedPositions.get(position);
                if (existingPosition == null) {
                    this.fPosition = position;
                    reflectionPositions.add(this.fPosition);
                    cachedPositions.put(this.fPosition, this.fPosition);
                } else {
                    this.fPosition = existingPosition;
                }
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public void removePosition() {
        this.fPosition = null;
    }

    public boolean containsOffset(int offset) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        return offset == -1 || startOffset <= offset && (this.fEndRealOffset == -1 || offset <= endOffset);
    }

    public int getStartLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDefFile != null && (result = this.fPosition.getOffset()) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.getInstance().convertPositionToLine(this.fDefFile, this.fStartRealOffset);
        }
        return this.fStartLine;
    }

    public int getEndLine() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDefFile != null && (result = this.fPosition.getOffset() + this.fPosition.getLength() - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.getInstance().convertPositionToLine(this.fDefFile, this.fEndRealOffset);
        }
        return this.fEndLine;
    }

    public int getStartOffset() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDefFile != null && (result = this.fPosition.getOffset()) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.getInstance().convertPositionToLine(this.fDefFile, this.fStartRealOffset);
        }
        return this.fStartRealOffset;
    }

    public LineInfo getStartInfo() {
        return new LineInfo(this.fStartLine, this.fStartRealOffset, this.fStartVirtualOffset);
    }

    public LineInfo getEndInfo() {
        return new LineInfo(this.fEndLine, this.fStartRealOffset, this.hasStartVirtualOffset() ? 1 : -1);
    }

    public int getEndOffset() {
        int result;
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fPosition.getLength() > 0 && this.fDefFile != null && (result = this.fPosition.getOffset() + this.fPosition.getLength() - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.getInstance().convertPositionToLine(this.fDefFile, this.fEndRealOffset);
        }
        return this.fEndRealOffset;
    }

    public int getStartVirtualOffset() {
        return this.fStartVirtualOffset;
    }

    public boolean hasStartVirtualOffset() {
        return this.fStartVirtualOffset != -1;
    }

    public RfProject getRfProject() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getRfProject();
        }
        return null;
    }

    public String getName() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getName();
        }
        return null;
    }

    public void overwriteDefEnd(int endLine) {
        this.fEndRealOffset = Math.max(this.fStartRealOffset, endLine);
    }

    @Override
    public List<RfTypeAlias> getTypeAliasesWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTypeAliasesWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfTypeAlias getTypeAliasWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTypeAliasWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfScalarType> getScalarTypesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getScalarTypesWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfScalarType getScalarTypeWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getScalarTypeWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfClass> getClassesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getClassesWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfClass getClassWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getClassWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfFunction> getFunctionsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFunctionsWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfFunction getFunctionWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFunctionWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getInterfacesWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfInterface getInterfaceWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getInterfaceWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getModulesWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfModule getModuleWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getModuleWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    public RfModule getModule(String name) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getModule(name);
        }
        return null;
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getProgramsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfProgram getProgramWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getProgramWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFieldsWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfField getFieldWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFieldWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEventsWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfField getEventWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEventWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfField> getParametersWithPrefix(String prefix, int kind, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getParametersWithPrefix(prefix, kind, matchType, local);
        }
        return null;
    }

    @Override
    public RfField getParameterWithPrefix(String prefix, int kind, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getParameterWithPrefix(prefix, kind, matchType, local);
        }
        return null;
    }

    @Override
    public boolean hasParameterWithPrefix(String prefix, int kind, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.hasParameterWithPrefix(prefix, kind, matchType, local);
        }
        return false;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getThisImplicitVariable(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfSuperImplicitVariable getSuperImplicitVariable(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getSuperImplicitVariable(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getArgumentsWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getArgumentWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfStruct> getStructsUnionsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getStructsUnionsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfStruct getStructUnionWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getStructUnionWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfStruct> getEnumTypesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEnumTypesWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfStruct getEnumTypeWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEnumTypeWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfField> getEnumElementsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEnumElementsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfField getEnumElementWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEnumElementWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfFunction> getConstructorsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getConstructorsWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfFunction getConstructorWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getConstructorWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfFunction> getTasksWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTasksWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public RfFunction getTaskWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTaskWithPrefix(prefix, matchType, local, accessModifier);
        }
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getVarsWithPrefix(offset, prefix, matchType);
        }
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getVarWithPrefix(offset, prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfPrimitive> getPrimitivesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPrimitivesWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfPrimitive getPrimitiveWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPrimitiveWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfChecker> getCheckersWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCheckersWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfChecker getCheckerWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCheckerWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfCovergroup> getCovergroupsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCovergroupsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfCovergroup getCovergroupWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCovergroupWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfCoverpoint> getCoverpointsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCoverpointsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfCoverpoint getCoverpointWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getCoverpointWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfInstance> getInstancesWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getInstancesWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getInstanceWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPortsWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPortWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfActionBlock> getNamedBlocksWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getNamedBlocksWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfActionBlock getNamedBlockWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getNamedBlockWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfGenerateBlock> getGenerateBlocksWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getGenerateBlocksWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfGenerateBlock getGenerateBlockWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getGenerateBlockWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfFunctionCall> getFunctionCallsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFunctionCallsWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfAssertExpect> getAssertsExpectsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getAssertsExpectsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfAssertExpect getAssertExpectWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getAssertExpectWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfEventTrigger> getEventTriggersWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEventTriggersWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfModport> getModportsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getModportsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfModport getModportWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getModportWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfConstraint> getConstraintsWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getConstraintsWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfConstraint getConstraintWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getConstraintWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfPropertySequence> getPropertiesSequencesWithPrefix(String prefix, int kind, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPropertiesSequencesWithPrefix(prefix, kind, matchType, local);
        }
        return null;
    }

    @Override
    public RfPropertySequence getPropertySequenceWithPrefix(String prefix, int kind, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPropertySequenceWithPrefix(prefix, kind, matchType, local);
        }
        return null;
    }

    @Override
    public List<RfClockingBlock> getClockingBlocksWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getClockingBlocksWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public RfClockingBlock getClockingBlockWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getClockingBlockWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    @Override
    public List<IRfNamedElement> getOtherLangMembersWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getOtherLangMembersWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public IRfNamedElement getOtherLangMemberWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getOtherLangMemberWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfLibrary getEnclosingLibrary() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getEnclosingLibrary();
        }
        return null;
    }

    public void addChild(RfDefElement child) {
        if (this.fChildrenDefs == null) {
            this.fChildrenDefs = new DVTLinkedHashMap();
        }
        this.fChildrenDefs.put((Object)child, (IDVTMapElement)child);
    }

    public void removeChild(RfDefElement child) {
        if (this.fChildrenDefs == null) {
            return;
        }
        this.fChildrenDefs.remove((Object)child);
    }

    public Collection<RfDefElement> getChildren() {
        if (this.fChildrenDefs == null) {
            return null;
        }
        return this.fChildrenDefs.values();
    }

    public void setChildren(Collection<RfDefElement> children) {
        if (this.fChildrenDefs == null) {
            return;
        }
        this.fChildrenDefs.clear();
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            this.fChildrenDefs.put((Object)child, (IDVTMapElement)child);
        }
    }

    protected void recursiveSetDefFile(RfFileDef defFile) {
        this.fDefFile = defFile;
        Collection<RfDefElement> childrenDefs = this.getChildren();
        if (childrenDefs != null && !childrenDefs.isEmpty()) {
            for (RfDefElement childDef : childrenDefs) {
                childDef.recursiveSetDefFile(this.fDefFile);
            }
        }
    }

    protected void cleanChildren(IncrementalDeltaContainer incrementalDeltaContainer, ParserPath parserPath) {
        this.cleanLocalImportExports(incrementalDeltaContainer, parserPath);
        if (this.fChildrenDefs == null) {
            return;
        }
        for (RfDefElement defElement : this.fChildrenDefs.values()) {
            if (defElement.fChildrenDefs == this.fChildrenDefs) continue;
            if (incrementalDeltaContainer != null) {
                incrementalDeltaContainer.collectElementsInFileBeforeIncremental(defElement);
            }
            defElement.cleanChildren(incrementalDeltaContainer, parserPath);
        }
        this.fChildrenDefs.clear();
    }

    private final void cleanLocalImportExports(IncrementalDeltaContainer incrementalDeltaContainer, ParserPath parserPath) {
        List<RfNamedElement> namedElements = this.getNamedElements();
        if (namedElements == null) {
            return;
        }
        for (RfNamedElement namedElem : namedElements) {
            if (namedElem == null) continue;
            namedElem.removeDef(incrementalDeltaContainer, this);
            if (namedElem.isImplicitSignal()) {
                RfNamedElement enclosingScope = namedElem.getEnclosingScope();
                enclosingScope.removeMember(namedElem);
            }
            this.internalCleanImportInfos(namedElem.getWildcardImports(), parserPath);
            this.internalCleanImportInfos(namedElem.getWildcardExports(), parserPath);
            this.internalCleanImportInfos(namedElem.getExplicitImports(), parserPath);
            this.internalCleanImportInfos(namedElem.getExplicitExports(), parserPath);
        }
    }

    private void internalCleanImportInfos(List<? extends ImportInfo> importInfos, ParserPath parserPath) {
        if (importInfos == null || importInfos.isEmpty()) {
            return;
        }
        for (ImportInfo importInfo : importInfos) {
            if (parserPath != null && !parserPath.equals((Object)importInfo.getParserPath())) continue;
            importInfo.setDirtyCleanUpFlag(true);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfDefElement other = (RfDefElement)obj;
        if (this.fHashCode != other.fHashCode) {
            return false;
        }
        if (this.fStartRealOffset != other.fStartRealOffset) {
            return false;
        }
        if (this.fStartLine != other.fStartLine) {
            return false;
        }
        return !(this.fReparseInfo == null ? other.fReparseInfo != null : !this.fReparseInfo.equals(other.fReparseInfo));
    }

    public int hashCode() {
        return this.fHashCode;
    }

    private void internalComputeHashCode(String name, IRfActionBlockElement.BlockQualifier blockType) {
        int result = 1;
        result = 31 * result + this.getClass().getName().hashCode();
        result = 31 * result + (this.getParserPath() == null ? 0 : this.getParserPath().hashCode());
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + (blockType == null ? 0 : blockType.ordinal());
        result = 31 * result + this.getStartOffset();
        result = 31 * result + this.getStartVirtualOffset();
        result = 31 * result + this.getEndOffset();
        this.fHashCode = result = 31 * result + (this.fReparseInfo == null ? 0 : this.fReparseInfo.hashCode());
    }

    public RfDefElement findDefElement(RfDefElement elem) {
        if (this.fChildrenDefs == null || this.fChildrenDefs.isEmpty()) {
            return null;
        }
        RfDefElement result = (RfDefElement)this.fChildrenDefs.get((Object)elem);
        if (result == null || result.getClass() == elem.getClass()) {
            return result;
        }
        return null;
    }

    public ReparseInfo getReparseInfo() {
        return this.fReparseInfo;
    }

    public void setEndOffset(LineInfo endInfo) {
        this.fEndRealOffset = endInfo == null ? -1 : endInfo.realOffset;
        this.fEndLine = endInfo == null ? -1 : endInfo.line;
    }

    public boolean hasVirtualOffsets() {
        return this.hasStartVirtualOffset();
    }

    public boolean hasNameInsideMacro() {
        return this.fHasNameInsideMacro;
    }

    public boolean isInsideOtherDef(RfDefElement otherDef) {
        if (this.fDefFile == null || !this.fDefFile.equals(otherDef.getDefFile())) {
            return false;
        }
        return this.fStartRealOffset >= otherDef.fStartRealOffset && this.fEndRealOffset <= otherDef.fEndRealOffset;
    }

    public void deepClean() {
        if (this.fDefFile != null) {
            this.fDefFile.deepClean();
        }
        this.fDefComment = null;
        if (this.fChildrenDefs != null) {
            this.fChildrenDefs.clear();
        }
        this.fNamedElements = null;
        this.fPosition = null;
        this.fReparseInfo = null;
        this.fHashCode = 0;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getSignalWithPrefix(prefix, matchType);
        }
        return null;
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getSignalsWithPrefix(prefix, matchType);
        }
        return null;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getInstanceWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPackagesWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getPackageWithPrefix(prefix, matchType);
        }
        return null;
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getDesignsWithPrefix(prefix, matchType);
        }
        return null;
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getDesignWithPrefix(prefix, matchType);
        }
        return null;
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getConfigurationWithPrefix(prefix, matchType);
        }
        return null;
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTypesWithPrefix(prefix, matchType);
        }
        return null;
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getTypeWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public RfFragment getFragmentWithPrefix(String prefix, int matchType, int local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getFragmentWithPrefix(prefix, matchType, local);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (persistence.isSaveCanceled()) {
            throw new PersistenceCancelException();
        }
        out.defaultWriteObject();
        DVTLinkedHashMap saveableChildrenDefs = new DVTLinkedHashMap();
        if (this.fChildrenDefs == null) {
            out.writeObject(null);
            return;
        }
        for (RfDefElement def : this.fChildrenDefs) {
            if (!def.shouldSave()) continue;
            saveableChildrenDefs.put((Object)def, (IDVTMapElement)def);
        }
        if (saveableChildrenDefs.isEmpty()) {
            out.writeObject(null);
        } else {
            out.writeObject(saveableChildrenDefs);
        }
    }

    public boolean shouldSave() {
        if (!(this.getNamedElement() instanceof RfFunctionCall)) {
            return true;
        }
        boolean shouldSave = ((RfFunctionCall)this.getNamedElement()).hasWith();
        return shouldSave;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!(in instanceof PersistenceInputStream)) {
            return;
        }
        PersistenceBase pis = ((PersistenceInputStream)in).getPersistence();
        if (pis.isRestoreCanceled()) {
            throw new PersistenceCancelException();
        }
        pis.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readStart((Object)this);
        in.defaultReadObject();
        this.fChildrenDefs = (DVTLinkedHashMap)in.readObject();
        ((PersistenceInputStream)in).getPersistence().getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readEnd((Object)this);
    }

    public void visit(IRfDefElementVisitor visitor) throws Exception {
        visitor.preVisit(this);
        if (this.fChildrenDefs != null) {
            if (visitor instanceof IRfDefElementVisitor.IRfDefElementVisitor2) {
                RfDefElement[] defsCopy;
                RfDefElement[] rfDefElementArray = defsCopy = this.fChildrenDefs.values().toArray(new RfDefElement[this.fChildrenDefs.size()]);
                int n = defsCopy.length;
                int n2 = 0;
                while (n2 < n) {
                    RfDefElement def = rfDefElementArray[n2];
                    def.visit(this, (IRfDefElementVisitor.IRfDefElementVisitor2)visitor);
                    ++n2;
                }
            } else {
                for (RfDefElement def : this.fChildrenDefs.values()) {
                    def.visit(visitor);
                }
            }
        }
        visitor.postVisit(this);
    }

    public void visit(RfDefElement defParentElement, IRfDefElementVisitor.IRfDefElementVisitor2 visitor) throws Exception {
        visitor.preVisit(this);
        if (this.fChildrenDefs != null) {
            RfDefElement[] defsCopy;
            RfDefElement[] rfDefElementArray = defsCopy = this.fChildrenDefs.values().toArray(new RfDefElement[this.fChildrenDefs.size()]);
            int n = defsCopy.length;
            int n2 = 0;
            while (n2 < n) {
                RfDefElement def = rfDefElementArray[n2];
                def.visit(this, visitor);
                ++n2;
            }
        }
        visitor.postVisit(defParentElement, this);
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        this.getNamedElement().getElementsWithPrefix(result, prefix, matchType, local, isFirst, accessModifier, elementFilter);
    }

    public DataType getDataType(IRfNamedElement namedElement) {
        if (namedElement instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getOccurrence();
        }
        if (namedElement instanceof RfAssociatedType) {
            return ((RfAssociatedType)namedElement).getDataType();
        }
        return null;
    }

    public DataType getRawDataType(IRfNamedElement namedElement) {
        if (namedElement instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getOccurrence();
        }
        if (namedElement instanceof RfAssociatedType) {
            return ((RfAssociatedType)namedElement).getRawDataType();
        }
        return null;
    }

    public boolean isPredefinedDef() {
        return this.getNamedElement() == null || this.getNamedElement().isPredefined();
    }

    public RfDefElement internalThis() {
        return this;
    }
}

