/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTArrayList;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTListElement;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor2;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGeneratesContainer;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfDuplicate
extends RfMembersHolder {
    private static final long serialVersionUID = 1L;
    private DVTArrayList<RfNamedElement> fListMembers;

    public RfDuplicate(String name, boolean escaped) {
        super(name, escaped);
    }

    public RfDuplicate(RfDuplicate duplicate) {
        super(duplicate.getName(), duplicate.isEscaped());
        Collection<RfNamedElement> members = duplicate.getMembers(true, false);
        if (members == null) {
            return;
        }
        this.fListMembers = new DVTArrayList();
        for (RfNamedElement member : members) {
            if (member instanceof RfDuplicate) {
                this.addMember(new RfDuplicate((RfDuplicate)member));
                continue;
            }
            if (!(member instanceof RfStruct)) continue;
            this.addMember(new RfStruct((RfStruct)member, this));
        }
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return null;
    }

    @Override
    public Collection<RfNamedElement> getMembers() {
        return this.getMembers(false, false);
    }

    @Override
    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        return this.fListMembers.values();
    }

    @Override
    public Iterator<RfNamedElement> getLocalMembersIterator(boolean rawMembers) {
        if (this.fListMembers == null) {
            return Collections.emptyIterator();
        }
        return this.fListMembers.iterator();
    }

    @Override
    public DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(boolean rawMembers) {
        throw new RuntimeException("This API should not be used");
    }

    @Override
    protected void removeMember(RfNamedElement element) {
        this.fListMembers.remove((IDVTListElement)element);
    }

    @Override
    protected void addMember(RfNamedElement element) {
        if (this.fListMembers == null) {
            this.fListMembers = new DVTArrayList();
        }
        this.fListMembers.add((IDVTListElement)element);
    }

    @Override
    protected Collection<RfNamedElement> getMembers(String name, boolean rawMembers) {
        return this.getMembers();
    }

    public <T extends IRfNamedElement> T getFirstNoDefMember(Class<T> clazz) {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        ArrayList<RfGenerateBlock> generates = null;
        int i = 0;
        while (i < this.fListMembers.size()) {
            RfNamedElement member = (RfNamedElement)this.fListMembers.get(i);
            if (!(!member.hasNoDefs(false) || clazz == RfField.class && (member instanceof RfCoverpoint || member instanceof RfInstance) || clazz == RfTypeAlias.class && member instanceof RfForwardTypedef)) {
                if (clazz == RfGenerateBlock.class && member instanceof RfGenerateBlock) {
                    if (generates == null) {
                        generates = new ArrayList<RfGenerateBlock>();
                    }
                    generates.add((RfGenerateBlock)member);
                } else if (clazz.isInstance(member)) {
                    return (T)member;
                }
            }
            ++i;
        }
        if (generates != null) {
            if (generates.size() > 1) {
                return (T)new RfGeneratesContainer(this.getName(), this.isEscaped(), (List<RfGenerateBlock>)generates);
            }
            return (T)((IRfNamedElement)generates.get(0));
        }
        return null;
    }

    public <T extends IRfNamedElement> T getLastMember(Class<T> clazz) {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        ArrayList<RfGenerateBlock> generates = null;
        int i = this.fListMembers.size() - 1;
        while (i >= 0) {
            RfNamedElement member = (RfNamedElement)this.fListMembers.get(i);
            if (!(clazz == RfField.class && (member instanceof RfCoverpoint || member instanceof RfInstance) || clazz == RfTypeAlias.class && member instanceof RfForwardTypedef)) {
                if (clazz == RfGenerateBlock.class && member instanceof RfGenerateBlock) {
                    if (generates == null) {
                        generates = new ArrayList<RfGenerateBlock>();
                    }
                    generates.add(0, (RfGenerateBlock)member);
                } else if (clazz.isInstance(member)) {
                    return (T)member;
                }
            }
            --i;
        }
        if (generates != null) {
            if (generates.size() > 1) {
                return (T)new RfGeneratesContainer(this.getName(), this.isEscaped(), (List<RfGenerateBlock>)generates);
            }
            return (T)((IRfNamedElement)generates.get(0));
        }
        return null;
    }

    public <T extends IRfNamedElement> T getFirstMember(Class<T> clazz) {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.fListMembers.size()) {
            RfNamedElement member = (RfNamedElement)this.fListMembers.get(i);
            if (clazz.isInstance(member)) {
                return (T)member;
            }
            ++i;
        }
        return null;
    }

    public IRfNamedElement getFirstMember() {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        return (IRfNamedElement)this.fListMembers.get(0);
    }

    public RfNamedElement getLastMember(Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        ArrayList<RfGenerateBlock> generates = null;
        int i = this.fListMembers.size() - 1;
        while (i >= 0) {
            RfNamedElement member = (RfNamedElement)this.fListMembers.get(i);
            if (member != exclude && (classes == null || classes.contains(member.getClass())) && (classes != null && classes.contains(RfForwardTypedef.class) || !(member instanceof RfForwardTypedef))) {
                if (member instanceof RfGenerateBlock) {
                    if (generates == null) {
                        generates = new ArrayList<RfGenerateBlock>();
                    }
                    generates.add(0, (RfGenerateBlock)member);
                } else {
                    return member;
                }
            }
            --i;
        }
        if (generates != null) {
            if (generates.size() > 1) {
                return new RfGeneratesContainer(this.getName(), this.isEscaped(), (List<RfGenerateBlock>)generates);
            }
            return (RfNamedElement)generates.get(0);
        }
        return null;
    }

    public RfNamedElement getLastMember(Set<Class<? extends IRfNamedElement>> classes) {
        return this.getLastMember(classes, null);
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
        return this.getLastMember(clazz);
    }

    protected <T extends IRfNamedElement> void getLocalMembers(boolean hideDuplicates, List<T> result, Class<T> clazz) {
        if (this.fListMembers == null) {
            return;
        }
        RfNamedElement lastMember = null;
        for (RfNamedElement member : this.fListMembers.values()) {
            if (clazz == RfField.class && (member instanceof RfCoverpoint || member instanceof RfInstance) || !clazz.isInstance(member)) continue;
            if (hideDuplicates) {
                lastMember = member;
                continue;
            }
            result.add(member);
        }
        if (hideDuplicates && lastMember != null) {
            result.add(lastMember);
        }
    }

    @Override
    public boolean hasLocalMembers() {
        return this.fListMembers != null && !this.fListMembers.isEmpty();
    }

    @Override
    protected void visitNamedElements(RfProject rfProject, IRfNamedElementVisitor visitor) throws Exception {
        if (visitor instanceof IRfNamedElementVisitor2) {
            ((IRfNamedElementVisitor2)visitor).preVisit(this);
        }
        if (visitor.visit(this)) {
            this.visitNamedElement(rfProject, visitor, (Iterable<? extends RfNamedElement>)this.fListMembers);
        }
        if (visitor instanceof IRfNamedElementVisitor2) {
            ((IRfNamedElementVisitor2)visitor).postVisit(this);
        }
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        if (this.fListMembers == null || this.fListMembers.isEmpty()) {
            return null;
        }
        return this.fListMembers.values();
    }

    @Override
    public void setEnclosingScope(RfNamedElement enclosingScope) {
        super.setEnclosingScope(enclosingScope);
        if (this.fListMembers != null) {
            for (RfNamedElement element : this.fListMembers) {
                element.setEnclosingScope(enclosingScope);
            }
        }
    }

    @Override
    public void deepClean() {
        super.deepClean();
        ArrayList valuesCopy = new ArrayList(this.fListMembers.values());
        for (RfNamedElement value : valuesCopy) {
            try {
                value.deepClean();
            }
            catch (Exception exception) {}
        }
    }
}

