/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;

public class RfElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    public static final int NONE = 0;
    public static final int PUBLIC = 1;
    public static final int PRECOMPILED_DB = 2;
    public static final int VIRTUAL_INTERFACE_REF = 4;
    public static final int CONST = 8;
    public static final int COVERPOINT_ITEM = 16;
    public static final int EXTERN = 32;
    public static final int PURE = 64;
    public static final int VIRTUAL = 128;
    public static final int SHALLOW_COMPILE = 256;
    public static final int INCREMENTAL_SHALLOW_COMPILE = 512;
    public static final int DELAYED_UDP_INSTANCE = 1024;
    public static final int ARRAY_METHOD_ITEM = 2048;
    public static final int COERCE_INOUT = 4096;
    public static final int RAND = 8192;
    public static final int RANDC = 16384;
    public static final int OBJECT_STATIC = 32768;
    public static final int PROTECTED = 65536;
    public static final int LOCAL = 131072;
    public static final int OBJECT_AUTOMATIC = 262144;
    public static final int STORAGE_STATIC = 524288;
    public static final int STORAGE_AUTOMATIC = 0x100000;
    public static final int ANONYMOUS = 0x200000;
    public static final int IMPLICIT = 0x400000;
    public static final int IMPLICIT_SIGNAL = 0x800000;
    public static final int DIRECT_C = 0x1000000;
    public static final int UNIQUE = 0x2000000;
    public static final int UNIQUE0 = 0x4000000;
    public static final int PRIORITY = 0x8000000;
    public static final int NAMED_ARRAY_METHOD_ITEM = 0x10000000;
    public static final int IMPLICIT_EXTERN_CONSTRAINT = 0x20000000;
    public static final int MINUS_Y_LIBFILE_PARSED = 0x40000000;
    public static final int OUTSIDE_REFERENCES = Integer.MIN_VALUE;
    public static final byte INPUT = 1;
    public static final byte INOUT = 2;
    public static final byte OUTPUT = 3;
    public static final byte REF = 4;
    public static final byte CONST_REF = 5;
    public static final byte IMPLICIT_DIR_OFFSET = 8;
    public static final int SIGNED = 1;
    public static final int UNSIGNED = 2;
    public static final int TWO_STATE = 1;
    public static final int FOUR_STATE = 2;
    private int fQualifiers = 1;

    public boolean isExtern() {
        return (this.fQualifiers & 0x20) == 32;
    }

    public boolean isImplicitExternConstraint() {
        return (this.fQualifiers & 0x20000000) == 0x20000000;
    }

    public boolean isDirectC() {
        return (this.fQualifiers & 0x1000000) == 0x1000000;
    }

    public static byte getImplicitDirection(byte direction) {
        if (direction != 0 && direction < 8) {
            return (byte)(direction + 8);
        }
        return direction;
    }

    public static byte getDirection(byte direction) {
        if (direction < 8) {
            return direction;
        }
        return (byte)(direction - 8);
    }

    public boolean isProtected() {
        return (this.fQualifiers & 0x10000) == 65536;
    }

    public boolean isPrivate() {
        return (this.fQualifiers & 0x20000) == 131072;
    }

    public boolean isImplicit() {
        return (this.fQualifiers & 0x400000) == 0x400000;
    }

    public boolean isCoverpointItem() {
        return (this.fQualifiers & 0x10) == 16;
    }

    public boolean isArrayMethodItem() {
        return (this.fQualifiers & 0x800) == 2048;
    }

    public boolean isNamedArrayMethodItem() {
        return (this.fQualifiers & 0x10000000) == 0x10000000;
    }

    public boolean isImplicitSignal() {
        return (this.fQualifiers & 0x800000) == 0x800000;
    }

    public boolean isRand() {
        return (this.fQualifiers & 0x2000) == 8192;
    }

    public boolean isRandc() {
        return (this.fQualifiers & 0x4000) == 16384;
    }

    public boolean isStaticLikeAccessible() {
        return false;
    }

    public boolean canStaticAccess() {
        return false;
    }

    public final boolean hasObjectStaticQualifier() {
        return (this.fQualifiers & 0x8000) == 32768;
    }

    public boolean hasObjectAutomaticQualifier() {
        return (this.fQualifiers & 0x40000) == 262144;
    }

    public boolean hasStorageStaticQualifier() {
        return (this.fQualifiers & 0x80000) == 524288;
    }

    public boolean hasStorageAutomaticQualifier() {
        return (this.fQualifiers & 0x100000) == 0x100000;
    }

    public boolean hasVirtualQualifier() {
        return (this.fQualifiers & 0x80) == 128;
    }

    public boolean isAnonymous() {
        return (this.fQualifiers & 0x200000) == 0x200000;
    }

    public boolean isMinusYLibfileParsed() {
        return (this.fQualifiers & 0x40000000) == 0x40000000;
    }

    public boolean isShallowCompiled() {
        return (this.fQualifiers & 0x100) == 256;
    }

    public boolean isIncrementalShallowCompiled() {
        return (this.fQualifiers & 0x200) == 512;
    }

    public void setVirtualInterfaceRef() {
        this.fQualifiers |= 4;
    }

    public boolean hasVirtualInterfaceRef() {
        return (this.fQualifiers & 4) == 4;
    }

    public void setOutsideReferences() {
        this.fQualifiers |= Integer.MIN_VALUE;
    }

    public boolean hasOutsideReferences() {
        return (this.fQualifiers & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void setAnonymous(boolean isAnonymous) {
        if (isAnonymous) {
            this.fQualifiers |= 0x200000;
        } else if ((this.fQualifiers & 0x200000) == 0x200000) {
            this.fQualifiers -= 0x200000;
        }
    }

    public void setCoerceInout() {
        this.fQualifiers |= 0x1000;
    }

    public boolean isCoerceInout() {
        return (this.fQualifiers & 0x1000) == 4096;
    }

    public boolean isDelayedUDPInstance() {
        return (this.fQualifiers & 0x400) == 1024;
    }

    public void unsetDelayedUDPInstance() {
        if ((this.fQualifiers & 0x400) == 1024) {
            this.fQualifiers -= 1024;
        }
    }

    public boolean isVirtual() {
        return this.hasVirtualQualifier();
    }

    public boolean isPure() {
        return (this.fQualifiers & 0x40) == 64;
    }

    public boolean isConst() {
        return (this.fQualifiers & 8) == 8;
    }

    public boolean isPublic() {
        return !this.isPrivate() && !this.isProtected();
    }

    public boolean isUnique() {
        return (this.fQualifiers & 0x2000000) == 0x2000000;
    }

    public boolean isUnique0() {
        return (this.fQualifiers & 0x4000000) == 0x4000000;
    }

    public boolean isPriority() {
        return (this.fQualifiers & 0x8000000) == 0x8000000;
    }

    public int getQualifiers() {
        return this.fQualifiers;
    }

    public int getParserQualifiers() {
        return this.fQualifiers & 0xFFFFEFFF;
    }

    public void setQualifiers(int qualifiers) {
        if ((this.fQualifiers & 0x100) == 256 || (this.fQualifiers & 0x200) == 512) {
            qualifiers |= 0x200;
        }
        this.fQualifiers = qualifiers;
    }

    public Object clone() throws CloneNotSupportedException {
        Object o = super.clone();
        ((RfElement)o).fQualifiers = this.fQualifiers;
        return o;
    }
}

