/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.AutoDefineAPIWrapper;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.IndexTypeWithOffsets;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAutoDefinedConstraint;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfAutodefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfAutodefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.parser.DVTCustomToken;

public class RfEncryptedCodeAutoManager {
    private static final String EXISTS_PREDEFINED_METHOD_DYNAMIC_ARRAY = "exists";
    private static final String AUTO_DEFINED_FUNCTION_ARGUMENT_COMMENT = "Auto defined function argument";
    private static final String AUTO_DEFINED_FIELD_COMMENT = "Auto defined field";
    private static final String AUTO_DEFINED_PARAMETER_COMMENT = "Auto defined parameter";
    private static final String AUTO_DEFINED_FUNCTION_COMMENT = "Auto defined function";
    private static final String PARAM = "param";
    public static final String AUTO_DEFINED_PARAM_NAME = "params";
    public static final String AUTO_DEFINED_PARAM_VAL = "__dvt_encrypted_code_auto_macro__";
    public static final String DPI_C = "\"DPI-C\"";
    public static final String AUTO_CLOSED = "Auto-closed";
    private static final String CONSTRAINT_MODE = "constraint_mode";
    private static Map<Integer, Integer> fStartEndElementsTokenTypes = new HashMap<Integer, Integer>();
    private static Map<Integer, String> fEndElementsTokenTypes = new HashMap<Integer, String>();

    static {
        fStartEndElementsTokenTypes.put(52, 77);
        fStartEndElementsTokenTypes.put(164, 86);
        fStartEndElementsTokenTypes.put(108, 81);
        fStartEndElementsTokenTypes.put(149, 85);
        fStartEndElementsTokenTypes.put(223, 93);
        fStartEndElementsTokenTypes.put(37, 75);
        fStartEndElementsTokenTypes.put(173, 89);
        fStartEndElementsTokenTypes.put(203, 91);
        fStartEndElementsTokenTypes.put(47, 76);
        fStartEndElementsTokenTypes.put(133, 84);
        fStartEndElementsTokenTypes.put(20, 21);
        fStartEndElementsTokenTypes.put(55, 79);
        fStartEndElementsTokenTypes.put(170, 87);
        fStartEndElementsTokenTypes.put(48, 76);
        fStartEndElementsTokenTypes.put(49, 76);
        fStartEndElementsTokenTypes.put(61, 83);
        fEndElementsTokenTypes.put(77, "endclass");
        fEndElementsTokenTypes.put(86, "endpackage");
        fEndElementsTokenTypes.put(81, "endfunction");
        fEndElementsTokenTypes.put(85, "endmodule");
        fEndElementsTokenTypes.put(93, "endtask");
        fEndElementsTokenTypes.put(75, "end");
        fEndElementsTokenTypes.put(89, "endproperty");
        fEndElementsTokenTypes.put(91, "endsequence");
        fEndElementsTokenTypes.put(76, "endcase");
        fEndElementsTokenTypes.put(84, "endinterface");
        fEndElementsTokenTypes.put(21, "endchecker");
        fEndElementsTokenTypes.put(79, "endconfig");
        fEndElementsTokenTypes.put(87, "endprimitive");
        fEndElementsTokenTypes.put(83, "endgroup");
    }

    public static Map<Integer, Integer> getStartEndElementsTokenTypes() {
        return fStartEndElementsTokenTypes;
    }

    public static Map<Integer, String> getEndElementsTokenTypes() {
        return fEndElementsTokenTypes;
    }

    public static boolean isDPIToken(DVTCustomToken nextToken) {
        if (nextToken == null) {
            return false;
        }
        return DPI_C.equals(nextToken.getText()) || nextToken.getType() == 58 || nextToken.getType() == 108;
    }

    public static boolean isClassToken(DVTCustomToken nextToken) {
        if (nextToken == null) {
            return false;
        }
        return nextToken.getType() == 52;
    }

    public static boolean isFunctionOrTaskToken(DVTCustomToken nextToken) {
        if (nextToken == null) {
            return false;
        }
        return nextToken.getType() == 108 || nextToken.getType() == 223 || nextToken.getType() == 249 || nextToken.getType() == 174 || nextToken.getType() == 141 || nextToken.getType() == 213;
    }

    public static void autoDefineAPIInsideEncryptedCode(RfProject rfProject, EncryptedCodeAutoFilter filter) {
        try {
            HashSet<String> alreadyDefinedNames = new HashSet<String>();
            IProject project = rfProject.getProject();
            if (project == null) {
                return;
            }
            RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
            if (mixedLangProject == null) {
                return;
            }
            EnumSet elabControlSet = BuildConfigManager.getElaborationControl((IProject)project);
            boolean semanticShowAliasName = DVTPlugin.getDefault().getPreferenceStore().getBoolean("semantic.show.alias.name");
            ELManagerConfiguration elabLocalConfig = ELManagerConfiguration.newElabLocalConfig((IProject)project, (int)1, (byte)1, (boolean)semanticShowAliasName, (int)1, (int)1, (boolean)false, (EnumSet)elabControlSet);
            EnumSet elabDebug = BuildConfigManager.getElaborationDebug((IProject)project);
            EnumSet<ElaborationDebugZone> localDebug = elabDebug.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
            ELManager localManager = new ELManager(mixedLangProject, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, mixedLangProject.getNonElabConstantsManager(), localDebug);
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, true, null, null);
            configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, Collections.emptyList(), (ELManager)localManager));
            configInfo.setElabWidthCheckDisabled(true);
            configInfo.setElabWidthCheckFiltered(true);
            LinkedHashSet allWrappers = new LinkedHashSet();
            allWrappers.addAll(filter.getHidOperatorWrappers());
            allWrappers.addAll(filter.getHidWrappers());
            ArrayList autoDefineWrappers = new ArrayList();
            autoDefineWrappers.addAll(allWrappers);
            Collections.sort(autoDefineWrappers);
            HashSet<RfNamedElement> scopesToRevisit = new HashSet<RfNamedElement>();
            for (AutoDefineAPIWrapper autoDefineWrapper : autoDefineWrappers) {
                IRfNamedElement scopeToDefineElement;
                Object contextObject;
                Hid autoDefinedHid;
                IRfNamedElement scopeElement = autoDefineWrapper.getScope();
                if (!(scopeElement instanceof RfNamedElement) || (autoDefinedHid = autoDefineWrapper.getHid()) == null || (contextObject = autoDefineWrapper.getObject()) == null || !((scopeToDefineElement = autoDefineWrapper.getScopeToDefine()) instanceof RfNamedElement)) continue;
                RfNamedElement scopeToDefine = (RfNamedElement)scopeToDefineElement;
                if (contextObject instanceof HidOperator) {
                    RfEncryptedCodeAutoManager.autoDefineAPIInOperators(alreadyDefinedNames, configInfo, (RfNamedElement)scopeElement, autoDefinedHid, (RfHidOperator)contextObject, scopeToDefine, filter);
                } else {
                    RfEncryptedCodeAutoManager.autoDefineAPInHid(alreadyDefinedNames, configInfo, (RfNamedElement)scopeElement, autoDefinedHid, scopeToDefine, filter);
                }
                if (!(scopeElement instanceof RfNamedElement)) continue;
                scopesToRevisit.add((RfNamedElement)scopeElement);
            }
            for (AutoDefineAPIWrapper otherWrapper : autoDefineWrappers) {
                Object otherObject;
                Hid otherHid;
                IRfDefElement otherScopeDeclaration;
                IRfNamedElement otherScopeElement = otherWrapper.getScope();
                if (otherScopeElement == null || (otherScopeDeclaration = otherScopeElement.getDeclaration()) == null || (otherHid = otherWrapper.getHid()) == null || (otherObject = otherWrapper.getObject()) == null) continue;
                if (otherObject instanceof HidOperator) {
                    RfHidAccess otherOperatorAccess;
                    Hid parentHid;
                    HidOperator otherHidOperator = (HidOperator)otherObject;
                    IHidObject otherOperatorLHValue = otherHidOperator.getLHValue();
                    if (!(otherOperatorLHValue instanceof RfHidAccess) || (parentHid = (otherOperatorAccess = (RfHidAccess)otherOperatorLHValue).getParentHid()) == null || parentHid.getElement() == null) continue;
                    otherOperatorAccess.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), otherScopeElement, parentHid.getElement(), otherScopeDeclaration.getParserPath(), RfTypesResolver.create((IRfScopeElement)otherScopeElement, null, null, localManager, 6, false), null, (byte)3, false, false, true);
                    continue;
                }
                ListContainer accesses = otherHid.getAccesses();
                if (accesses == null || accesses.isEmpty()) continue;
                for (HidAccess access : accesses) {
                    RfHidAccess hidAccess;
                    Hid parentHid;
                    if (!(access instanceof RfHidAccess) || !access.isSelect() || (parentHid = (hidAccess = (RfHidAccess)access).getParentHid()) == null || parentHid.getElement() == null) continue;
                    hidAccess.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), otherScopeElement, parentHid.getElement(), otherScopeDeclaration.getParserPath(), RfTypesResolver.create((IRfScopeElement)otherScopeElement, null, null, localManager, 6, false), null, (byte)3, false, false, true);
                }
            }
            for (RfNamedElement elementToRevisit : scopesToRevisit) {
                elementToRevisit.resolveHidOperators(configInfo, true, (byte)3, null);
                elementToRevisit.resolveHids(configInfo, true, false, (byte)3, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void autoDefineAPInHid(Set<String> alreadyDefinedNames, ConfigInfo configInfo, RfNamedElement scopeElement, Hid hid, RfNamedElement scopeToDefine, EncryptedCodeAutoFilter filter) {
        ListContainer accesses;
        RfFunction member;
        boolean created = false;
        RfFunction rfFunction = member = hid.isPotentialMethodCall() && RfEncryptedCodeAutoManager.isConstructor(hid) ? scopeToDefine.getLocalMember(RfFunction.class, hid.getName(), true) : scopeToDefine.getMember(hid.getName(), null, null, true, true, true, false, false);
        if (!(member instanceof RfAssociatedType)) {
            member = RfEncryptedCodeAutoManager.createFunctionOrFieldHavingNoDataType(alreadyDefinedNames, hid, scopeToDefine);
            created = true;
        }
        hid.setElement((IRfNamedElement)member);
        if (created) {
            RfEncryptedCodeAutoManager.reportAutoDefineWarnings(configInfo.getProject(), scopeElement, hid.getName(), hid.getOccurrence().getLine(), scopeToDefine, created, member, filter);
        }
        if ((accesses = hid.getAccesses()) == null || accesses.isEmpty()) {
            return;
        }
        for (HidAccess access : accesses) {
            if (access instanceof RfHidAccessArgs && member instanceof RfFunction) {
                RfEncryptedCodeAutoManager.autoDefineFunctionArguments(alreadyDefinedNames, configInfo, scopeElement, member, (RfHidAccessArgs)access, filter);
                continue;
            }
            if (!(member instanceof RfField)) continue;
            Hid firstHid = access.getFirstHid();
            DataType dataType = ((RfField)((Object)member)).getDataType();
            if (firstHid == null || !EXISTS_PREDEFINED_METHOD_DYNAMIC_ARRAY.equals(firstHid.getName()) || dataType == null || !dataType.isArray()) continue;
            DataType newDataType = ((RfField)((Object)member)).getDataType().copy();
            newDataType.setUnpackedDimension(Arrays.asList(RfEncryptedCodeAutoManager.getDynamicArrayIndex()));
            ((RfField)((Object)member)).init(newDataType);
        }
    }

    private static IndexTypeWithOffsets getDynamicArrayIndex() {
        IndexTypeWithOffsets dynamicIndexType = new IndexTypeWithOffsets("*", 0, 3);
        dynamicIndexType.setRangeObject((IHidObject)RfHidImplicit.makeImplicit("*", 462));
        return dynamicIndexType;
    }

    private static IRfNamedElement createFunctionOrFieldHavingNoDataType(Set<String> alreadyDefinedNames, Hid hid, RfNamedElement scopeToDefine) {
        boolean isStatic;
        String name = hid.getName();
        DataType dataType = new DataType("logic");
        boolean defineParameter = hid.hasQualifier(HidQualifierCache.IS_IN_CONSTANT_EXPRESSION) || hid.hasQualifier(HidQualifierCache.IS_IN_COVERGROUP_EXPRESSION);
        int qualifiers = 1;
        boolean bl = isStatic = hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 2;
        if (isStatic && !defineParameter) {
            qualifiers |= 0x8000;
        }
        if (hid.isPotentialMethodCall()) {
            RfAutodefinedFunction member = new RfAutodefinedFunction(name, dataType, null, RfEncryptedCodeAutoManager.isConstructor(hid) ? 2 : 0, AUTO_DEFINED_FUNCTION_COMMENT, qualifiers);
            alreadyDefinedNames.add(name);
            member.setEnclosingScope(scopeToDefine);
            scopeToDefine.addMember(member);
            return member;
        }
        ListContainer accesses = hid.getAccesses();
        ArrayList<IndexType> unpacked = new ArrayList<IndexType>();
        if (accesses != null && !accesses.isEmpty()) {
            Hid accessHid;
            ListContainer hids;
            HidAccess hidAccess = (HidAccess)accesses.get(0);
            if (hidAccess.isSelect()) {
                List selects = hidAccess.getSelects();
                int i = 0;
                while (i < selects.size()) {
                    IHidObject select = (IHidObject)selects.get(i);
                    if (!(select instanceof RfHidOperator) || !((RfHidOperator)select).isRangeOrPartSelect()) {
                        unpacked.add(RfEncryptedCodeAutoManager.getQueueIndexType());
                    }
                    ++i;
                }
            } else if (hidAccess.getAccessKind() == 0 && (hids = hidAccess.getHids()) != null && !hids.isEmpty() && (accessHid = (Hid)hids.get(0)) != null && CONSTRAINT_MODE.equals(accessHid.getName())) {
                RfAutoDefinedConstraint constraint = new RfAutoDefinedConstraint(name, false, 0);
                alreadyDefinedNames.add(name);
                constraint.setEnclosingScope(scopeToDefine);
                scopeToDefine.addMember(constraint);
                return constraint;
            }
        }
        if (!unpacked.isEmpty()) {
            dataType.setUnpackedDimension(unpacked);
        }
        RfAutodefinedField member = new RfAutodefinedField(name, dataType.copy(), defineParameter ? 128 : 1, qualifiers, null, defineParameter ? AUTO_DEFINED_PARAMETER_COMMENT : AUTO_DEFINED_FIELD_COMMENT);
        alreadyDefinedNames.add(name);
        member.setEnclosingScope(scopeToDefine);
        scopeToDefine.addMember(member);
        return member;
    }

    private static boolean isConstructor(Hid hid) {
        if ("new".equals(hid.getName()) && hid.isPotentialMethodCall()) {
            return true;
        }
        IRfNamedElement element = hid.getElement();
        return element instanceof RfFunction && ((RfFunction)element).isConstructor();
    }

    public static boolean testAutoDefineCriteria(IRfNamedElement element) {
        return element == null || element instanceof RfFunction && ((RfFunction)element).isConstructor() && element.getDeclaration() == null && element.getEnclosingScope() instanceof RfClass;
    }

    private static void reportAutoDefineWarnings(IProject project, IRfNamedElement scopeElement, String hidName, int line, IRfNamedElement associatedType, boolean created, IRfNamedElement definedElement, EncryptedCodeAutoFilter filter) {
        if (project == null) {
            return;
        }
        String path = scopeElement == null || scopeElement.getFileAdapter() == null ? "N/A" : scopeElement.getDeclaration().getParserPath().path;
        String signature = definedElement.getSignature().replace("\n", " ");
        if (definedElement instanceof RfFunction) {
            signature = ((RfFunction)definedElement).getSignature(RfTypesResolver.create((IRfScopeElement)definedElement, definedElement.getRfProject(), 14), false).replace("\n", " ");
        }
        if (filter.isDebug()) {
            DVTBuildConsoleRegistry.getConsole((IProject)project).print("Encrypted code auto-api: " + (created ? "" : "(update) ") + signature + "\n\t in file " + path + " at line " + line);
        } else if (created) {
            if (definedElement instanceof RfFunction) {
                filter.incrementFunctions();
            } else if (definedElement instanceof RfField && ((RfField)definedElement).isField()) {
                filter.incrementFields();
            } else if (definedElement instanceof RfField && ((RfField)definedElement).isArgument()) {
                filter.incrementArguments();
            } else if (definedElement instanceof RfConstraint) {
                filter.incrementConstraints();
            }
        }
    }

    private static void autoDefineFunctionArguments(Set<String> alreadyDefinedNames, ConfigInfo configInfo, IRfNamedElement scopeElement, RfFunction function, RfHidAccessArgs hidAccess, EncryptedCodeAutoFilter filter) {
        List<? extends IHidObject> argumentValues = hidAccess.getArgumentValues();
        int j = 1;
        if (argumentValues != null && !argumentValues.isEmpty()) {
            for (IHidObject iHidObject : argumentValues) {
                RfHidOperator argumentValueOperator;
                IHidObject argumentValueLH;
                if (!(iHidObject instanceof RfHidOperator) || !((argumentValueLH = (argumentValueOperator = (RfHidOperator)iHidObject).getLHValue()) instanceof IHid)) continue;
                IHidObject iHidObject2 = (IHidObject)argumentValueOperator.getRHValues().get(0);
                DataType argumentDataType = null;
                IRfNamedElement argumentType = null;
                String initialVal = "";
                if (iHidObject2 instanceof RfHidAccessArgs) {
                    iHidObject2 = ((RfHidAccessArgs)iHidObject2).getParentHid();
                }
                if (iHidObject2 instanceof RfHidImplicit) {
                    String guessTypeName = ((RfHidImplicit)iHidObject2).guessTypeName(true);
                    argumentDataType = new DataType(guessTypeName);
                    initialVal = ((RfHidImplicit)iHidObject2).getName();
                } else if (iHidObject2 instanceof RfHid) {
                    IRfNamedElement element = ((RfHid)iHidObject2).getElement();
                    if (element == null && alreadyDefinedNames.contains(((RfHid)iHidObject2).getName())) {
                        IRfNamedElement parentScope = scopeElement;
                        RfHidAccess parentAccess = (RfHidAccess)((RfHid)iHidObject2).getParentAccess();
                        if (parentAccess != null) {
                            parentScope = parentAccess.getAssociatedType();
                        }
                        if (parentScope != null) {
                            ((RfHid)iHidObject2).resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), scopeElement, parentScope, null, RfTypesResolver.create((IRfScopeElement)parentScope, configInfo, 6), null, (byte)3, false, false, false);
                            element = ((RfHid)iHidObject2).getElement();
                        }
                    }
                    if (element instanceof RfAssociatedType && ((RfAssociatedType)element).getDataType() != null) {
                        argumentDataType = ((RfAssociatedType)element).getDataType().copy();
                        argumentType = ((RfAssociatedType)element).getAssociatedType();
                        initialVal = "null";
                    }
                }
                if (argumentDataType == null) {
                    argumentDataType = new DataType("[unknown]");
                }
                String name = "";
                name = PortConnectionUtils.isOrderedConnected((IHidOperator)argumentValueOperator) ? PARAM + j : MethodCallUtils.getMethodArgumentName((IHidObject)argumentValueOperator);
                if (function != null) {
                    IRfNamedElement argumentElement = function.getMember(name, null, null, true, true, true, false, false);
                    boolean created = false;
                    if (!(argumentElement instanceof RfPredefinedField)) {
                        argumentElement = new RfAutodefinedField(name, argumentDataType, 2, 1, null, AUTO_DEFINED_FUNCTION_ARGUMENT_COMMENT);
                        alreadyDefinedNames.add(name);
                        function.addMember((RfPredefinedField)argumentElement);
                        ((RfPredefinedField)argumentElement).setEnclosingScope(function);
                        created = true;
                    }
                    IRfNamedElement argumentAssociatedType = ((RfField)argumentElement).getAssociatedType();
                    boolean update = false;
                    if (argumentAssociatedType instanceof RfClass && argumentType instanceof RfClass) {
                        RfClass computeCommonAncestor;
                        RfClass currentType = (RfClass)argumentAssociatedType;
                        RfClass newType = (RfClass)argumentType;
                        if (!currentType.equals(newType) && currentType.isSubClass(newType)) {
                            ((RfField)argumentElement).init(argumentDataType);
                            update = true;
                        } else if (!newType.equals(currentType) && !newType.isSubClass(currentType) && (computeCommonAncestor = VlogRfReferencesUtils.computeCommonAncestor(currentType, newType)) != null) {
                            update = true;
                            ((RfField)argumentElement).init(new DataType(computeCommonAncestor.getName()));
                        }
                    } else {
                        update = true;
                        ((RfField)argumentElement).init(argumentDataType);
                    }
                    if (!initialVal.isEmpty()) {
                        ((RfField)argumentElement).setInitialValue(initialVal);
                    }
                    if (created || update) {
                        RfEncryptedCodeAutoManager.reportAutoDefineWarnings(configInfo.getProject(), scopeElement, name, hidAccess.getOccurrence().getLine(), function, created, argumentElement, filter);
                    }
                    SEvaluator.INSTANCE.calculateAssociation(argumentValueOperator, argumentElement, scopeElement, configInfo, scopeElement.getDeclaration().getParserPath(), null, false, configInfo.isIrunRNMTech());
                }
                ++j;
            }
        }
    }

    private static void autoDefineAPIInOperators(Set<String> alreadyDefinedNames, ConfigInfo configInfo, RfNamedElement scopeElement, Hid hid, HidOperator hidOperator, RfNamedElement scopeToDefine, EncryptedCodeAutoFilter filter) {
        IHidObject firstRHValue;
        IHidObject lhValue;
        if (hidOperator.isReturnStatement()) {
            while (scopeElement != null) {
                if (scopeElement instanceof RfFunction) {
                    RfFunction function = (RfFunction)scopeElement;
                    DataType dataType = function.getDataType();
                    IRfNamedElement resolvedType = function.getResolvedType(true);
                    RfEncryptedCodeAutoManager.autoDefineElementOnHid(alreadyDefinedNames, configInfo, hid, scopeToDefine, scopeElement, resolvedType, dataType, false, filter);
                    return;
                }
                scopeElement = scopeElement.getEnclosingScope();
            }
        } else if (hidOperator.isIfCondition()) {
            lhValue = hidOperator.getLHValue();
            if (lhValue instanceof RfHidAccessArgs) {
                lhValue = ((RfHidAccessArgs)lhValue).getParentHid();
            }
            if (hid.equals((Object)lhValue)) {
                RfEncryptedCodeAutoManager.autoDefineElementOnHid(alreadyDefinedNames, configInfo, hid, scopeToDefine, scopeElement, null, new DataType("logic"), false, filter);
                return;
            }
        } else if (hidOperator.isAssignment() && (lhValue = hidOperator.getLHValue()) instanceof RfHid && lhValue == hid && ((RfHid)lhValue).getParentAccess() != null && ((RfHid)lhValue).getParentAccess().getAssociatedType() == scopeToDefine && (firstRHValue = hidOperator.getFirstRHValue()) instanceof RfHid) {
            RfHid rhHid = (RfHid)firstRHValue;
            RfHid lhHid = (RfHid)lhValue;
            if (rhHid.getName().equals(lhHid.getName()) && rhHid.getElement() == null) {
                RfEncryptedCodeAutoManager.autoDefineElementOnHid(alreadyDefinedNames, configInfo, hid, scopeToDefine, scopeElement, null, new DataType("logic"), false, filter);
            }
        }
        IHidObject hidOperatorLHValue = hidOperator.getLHValue();
        RfEncryptedCodeAutoManager.autoDefineLeftHandSideOfOperator(alreadyDefinedNames, configInfo, scopeElement, hid, hidOperator, scopeToDefine, hidOperatorLHValue, filter);
        AssocDataTypeWrapper leftElement = RfEncryptedCodeAutoManager.getLHSideElement(scopeElement, hidOperatorLHValue);
        if (leftElement == null) {
            return;
        }
        RfEncryptedCodeAutoManager.autoDefineRightHandeSideOfOperator(alreadyDefinedNames, configInfo, scopeElement, hid, hidOperator, scopeToDefine, leftElement, filter);
    }

    private static AssocDataTypeWrapper getLHSideElement(IRfNamedElement scopeElement, IHidObject hidOperatorLHValue) {
        if (HidUtils.isHid((IHidObject)hidOperatorLHValue)) {
            IRfNamedElement element = ((RfHid)hidOperatorLHValue).getElement();
            if (element instanceof RfAssociatedType) {
                return new AssocDataTypeWrapper(((RfAssociatedType)element).getAssociatedType(), ((RfAssociatedType)element).getDataType());
            }
        } else if (HidUtils.isHidImplicit((IHidObject)hidOperatorLHValue)) {
            HidImplicit hidImplicit = (HidImplicit)hidOperatorLHValue;
            if (hidImplicit.isID()) {
                RfField resolveImplicit = STransformer.resolveImplicit(hidImplicit.getName(), scopeElement);
                return new AssocDataTypeWrapper(resolveImplicit.getAssociatedType(), resolveImplicit.getDataType());
            }
        } else if (HidUtils.isHidAccess((IHidObject)hidOperatorLHValue)) {
            RfHidAccess access = (RfHidAccess)hidOperatorLHValue;
            IRfNamedElement associatedType = access.getAssociatedType();
            IDataType dataType = access.getDataType();
            if (dataType instanceof DataType) {
                return new AssocDataTypeWrapper(associatedType, (DataType)dataType);
            }
            if (associatedType != null) {
                return new AssocDataTypeWrapper(associatedType, new DataType(associatedType.getName()));
            }
        }
        return null;
    }

    private static void autoDefineRightHandeSideOfOperator(Set<String> alreadyDefinedNames, ConfigInfo configInfo, RfNamedElement scopeElement, Hid hid, HidOperator hidOperator, RfNamedElement scopeToDefine, AssocDataTypeWrapper leftElement, EncryptedCodeAutoFilter filter) {
        ListContainer rhValues = hidOperator.getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            return;
        }
        DataType leftElementDataType = leftElement.getDataType();
        IRfNamedElement leftElementAssociatedType = leftElement.getAssociatedType();
        boolean isScalarType = leftElementAssociatedType instanceof RfPredefinedScalarType;
        for (IHidObject rhValue : rhValues) {
            if (rhValue instanceof RfHidAccess && hid.equals((Object)((RfHidAccess)rhValue).getParentHid())) {
                RfEncryptedCodeAutoManager.autoDefineElementOnOperator(alreadyDefinedNames, configInfo, hid, (RfHidAccess)rhValue, scopeToDefine, scopeElement, leftElementAssociatedType, leftElementDataType, false, isScalarType, filter);
                continue;
            }
            if (rhValue instanceof RfHid && rhValue.equals(hid)) {
                RfEncryptedCodeAutoManager.autoDefineElementOnHid(alreadyDefinedNames, configInfo, hid, scopeToDefine, scopeElement, leftElementAssociatedType, leftElementDataType, false, filter);
                continue;
            }
            if (!(rhValue instanceof RfHidOperator) || !((RfHidOperator)rhValue).isVLOGConcatenation(true)) continue;
            RfEncryptedCodeAutoManager.autoDefineRightHandeSideOfOperator(alreadyDefinedNames, configInfo, scopeElement, hid, (RfHidOperator)rhValue, scopeToDefine, leftElement, filter);
        }
    }

    private static void autoDefineElementOnHid(Set<String> alreadyDefinedNames, ConfigInfo configInfo, Hid hid, RfNamedElement scopeToDefine, RfNamedElement scopeElement, IRfNamedElement elementType, DataType originalDataType, boolean left, EncryptedCodeAutoFilter filter) {
        if (originalDataType == null) {
            return;
        }
        RfFunction funct = null;
        RfFunction member = hid.isPotentialMethodCall() && RfEncryptedCodeAutoManager.isConstructor(hid) ? scopeToDefine.getLocalMember(RfFunction.class, hid.getName(), true) : scopeToDefine.getMember(hid.getName(), null, null, true, true, false, false, false);
        boolean created = false;
        if (!(member instanceof RfAssociatedType)) {
            member = RfEncryptedCodeAutoManager.createFunctionOrFieldWithDataType(alreadyDefinedNames, hid, scopeToDefine, originalDataType.copy());
            created = true;
        }
        hid.setElement((IRfNamedElement)member);
        IRfNamedElement currentType = ((RfAssociatedType)member).getAssociatedType();
        boolean update = false;
        DataType newDataType = originalDataType.copy();
        if (elementType instanceof RfClass && currentType instanceof RfClass) {
            RfClass computeCommonAncestor;
            RfClass currentClass = (RfClass)currentType;
            RfClass newClass = (RfClass)elementType;
            if (!left && newClass.isSubClass(currentClass) || left && currentClass.isSubClass(newClass)) {
                update = true;
                ((RfAssociatedType)member).init(newDataType);
            } else if (left && !newClass.equals(currentClass) && !newClass.isSubClass(currentClass) && (computeCommonAncestor = VlogRfReferencesUtils.computeCommonAncestor(currentClass, newClass)) != null) {
                update = true;
                ((RfAssociatedType)member).init(new DataType(computeCommonAncestor.getName()));
            }
        } else {
            ((RfAssociatedType)member).init(newDataType);
            update = true;
        }
        if (created || update) {
            RfEncryptedCodeAutoManager.reportAutoDefineWarnings(configInfo.getProject(), scopeElement, hid.getName(), hid.getOccurrence().getLine(), scopeToDefine, created, member, filter);
        }
        RfFunction rfFunction = funct = member instanceof RfFunction ? member : null;
        if (funct != null && funct.isConstructor()) {
            return;
        }
        if (funct != null && hid.isPotentialMethodCall()) {
            ListContainer accesses = hid.getAccesses();
            if (accesses == null || accesses.isEmpty()) {
                return;
            }
            for (HidAccess hidAccess : accesses) {
                if (!(hidAccess instanceof RfHidAccessArgs)) continue;
                RfEncryptedCodeAutoManager.autoDefineFunctionArguments(alreadyDefinedNames, configInfo, scopeElement, funct, (RfHidAccessArgs)hidAccess, filter);
            }
        }
    }

    private static void autoDefineElementOnOperator(Set<String> alreadyDefinedNames, ConfigInfo configInfo, Hid hid, RfHidAccess args, RfNamedElement scopeToDefine, IRfNamedElement scopeElement, IRfNamedElement elementType, DataType originalDataType, boolean left, boolean isScalarType, EncryptedCodeAutoFilter filter) {
        if (originalDataType == null) {
            return;
        }
        RfFunction funct = null;
        ArrayList<IndexType> unpacked = new ArrayList<IndexType>();
        if (args.isSelect()) {
            List selects = args.getSelects();
            int i = 0;
            while (i < selects.size()) {
                IHidObject select = (IHidObject)selects.get(i);
                if (!(select instanceof RfHidOperator && ((RfHidOperator)select).isRangeOrPartSelect() && isScalarType)) {
                    unpacked.add(RfEncryptedCodeAutoManager.getQueueIndexType());
                }
                ++i;
            }
        }
        DataType newDataType = originalDataType.copy();
        if (!unpacked.isEmpty()) {
            newDataType.setUnpackedDimension(unpacked);
        }
        RfFunction member = hid.isPotentialMethodCall() && RfEncryptedCodeAutoManager.isConstructor(hid) ? scopeToDefine.getLocalMember(RfFunction.class, hid.getName(), true) : scopeToDefine.getMember(hid.getName(), null, null, true, true, true, false, false);
        boolean created = false;
        if (!(member instanceof RfAssociatedType)) {
            created = true;
            member = RfEncryptedCodeAutoManager.createFunctionOrFieldWithDataType(alreadyDefinedNames, hid, scopeToDefine, newDataType.copy());
        }
        hid.setElement((IRfNamedElement)member);
        funct = member instanceof RfFunction ? member : null;
        IRfNamedElement currentType = ((RfAssociatedType)member).getAssociatedType();
        boolean update = false;
        if (elementType instanceof RfClass && currentType instanceof RfClass) {
            RfClass computeCommonAncestor;
            RfClass newClass = (RfClass)elementType;
            RfClass currentClass = (RfClass)currentType;
            if (!newClass.equals(currentClass) && !left && newClass.isSubClass(currentClass) || left && currentClass.isSubClass(newClass)) {
                ((RfAssociatedType)member).init(newDataType);
                update = true;
            } else if (left && !newClass.equals(currentClass) && !newClass.isSubClass(currentClass) && (computeCommonAncestor = VlogRfReferencesUtils.computeCommonAncestor(currentClass, newClass)) != null) {
                update = true;
                ((RfAssociatedType)member).init(new DataType(computeCommonAncestor.getName()));
            }
        } else {
            ((RfAssociatedType)member).init(newDataType);
            update = true;
        }
        if (created || update) {
            RfEncryptedCodeAutoManager.reportAutoDefineWarnings(configInfo.getProject(), scopeElement, hid.getName(), hid.getOccurrence().getLine(), scopeToDefine, created, member, filter);
        }
        if (funct != null && args instanceof RfHidAccessArgs) {
            RfEncryptedCodeAutoManager.autoDefineFunctionArguments(alreadyDefinedNames, configInfo, scopeElement, funct, (RfHidAccessArgs)args, filter);
        }
    }

    private static IndexTypeWithOffsets getQueueIndexType() {
        IndexTypeWithOffsets indexType = new IndexTypeWithOffsets("$", 0, 3);
        indexType.setRangeObject((IHidObject)RfHidImplicit.makeImplicit("$", 533));
        return indexType;
    }

    private static void autoDefineLeftHandSideOfOperator(Set<String> alreadyDefinedNames, ConfigInfo configInfo, RfNamedElement scopeElement, Hid hid, HidOperator hidOperator, RfNamedElement scopeToDefine, IHidObject lhValue, EncryptedCodeAutoFilter filter) {
        ListContainer rhValues = hidOperator.getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            if (lhValue instanceof RfHidAccess) {
                lhValue = ((RfHidAccess)lhValue).getParentHid();
            }
            if (hid != null && hid.equals((Object)lhValue)) {
                RfEncryptedCodeAutoManager.autoDefineAPInHid(alreadyDefinedNames, configInfo, scopeElement, hid, scopeToDefine, filter);
            }
            return;
        }
        IHidObject rhValue = (IHidObject)rhValues.get(0);
        IRfNamedElement elementType = null;
        DataType dataType = null;
        boolean isScalarType = false;
        if (rhValue instanceof RfHid && ((RfHid)rhValue).getElement() instanceof RfAssociatedType) {
            elementType = ((RfAssociatedType)((RfHid)rhValue).getElement()).getAssociatedType();
            dataType = ((RfAssociatedType)((RfHid)rhValue).getElement()).getDataType();
            isScalarType = elementType instanceof RfPredefinedScalarType;
        } else if (rhValue instanceof RfHidImplicit) {
            dataType = new DataType(((RfHidImplicit)rhValue).guessTypeName(true));
            isScalarType = true;
        } else if (rhValue instanceof RfHidAccess) {
            DataType hidDataType = (DataType)((RfHidAccess)rhValue).getDataType();
            if (hidDataType != null) {
                dataType = hidDataType;
                elementType = ((RfHidAccess)rhValue).getAssociatedType();
            }
            isScalarType = elementType instanceof RfPredefinedScalarType;
        }
        if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid().equals((Object)hid)) {
            RfEncryptedCodeAutoManager.autoDefineElementOnOperator(alreadyDefinedNames, configInfo, hid, (RfHidAccess)lhValue, scopeToDefine, scopeElement, elementType, dataType, true, isScalarType, filter);
        } else if (lhValue instanceof RfHid && lhValue.equals(hid)) {
            RfEncryptedCodeAutoManager.autoDefineElementOnHid(alreadyDefinedNames, configInfo, hid, scopeToDefine, scopeElement, elementType, dataType, true, filter);
        }
    }

    private static IRfNamedElement createFunctionOrFieldWithDataType(Set<String> alreadyDefinedNames, Hid hid, RfNamedElement scopeToDefine, DataType type) {
        boolean defineParameter;
        String name = hid.getName();
        HidAccess parentAccess = hid.getParentAccess();
        int qualifiers = 1;
        boolean isStatic = parentAccess != null && parentAccess.getAccessKind() == 2;
        boolean bl = defineParameter = hid.hasQualifier(HidQualifierCache.IS_IN_CONSTANT_EXPRESSION) || hid.hasQualifier(HidQualifierCache.IS_IN_COVERGROUP_EXPRESSION);
        if (isStatic && !defineParameter) {
            qualifiers |= 0x8000;
        }
        if (hid.isPotentialMethodCall()) {
            RfAutodefinedFunction member = new RfAutodefinedFunction(name, type, null, RfEncryptedCodeAutoManager.isConstructor(hid) ? 2 : 0, AUTO_DEFINED_FUNCTION_COMMENT, qualifiers);
            alreadyDefinedNames.add(name);
            member.setEnclosingScope(scopeToDefine);
            scopeToDefine.addMember(member);
            return member;
        }
        RfAutodefinedField member = new RfAutodefinedField(name, type, defineParameter ? 128 : 1, qualifiers, null, defineParameter ? AUTO_DEFINED_PARAMETER_COMMENT : AUTO_DEFINED_FIELD_COMMENT);
        alreadyDefinedNames.add(name);
        member.setEnclosingScope(scopeToDefine);
        scopeToDefine.addMember(member);
        return member;
    }

    public static void computeAutoDefineInfoForCompleteOperator(EncryptedCodeAutoFilter encryptedCodeAutoDefine, HidOperator operator, IRfNamedElement scopeElement) {
        try {
            boolean validOperators;
            boolean bl = validOperators = operator.isAssignment() || operator.isReturnStatement() || operator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
            if (!validOperators) {
                return;
            }
            RfEncryptedCodeAutoManager.computeAutoDefineForOperator(encryptedCodeAutoDefine, operator, scopeElement);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void computeAutoDefineInfoForEqualityOperator(EncryptedCodeAutoFilter encryptedCodeAutoDefine, HidOperator operator, IRfNamedElement scopeElement) {
        try {
            if (!operator.isEquality()) {
                return;
            }
            RfEncryptedCodeAutoManager.computeAutoDefineForOperator(encryptedCodeAutoDefine, operator, scopeElement);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void computeAutoDefineForOperator(EncryptedCodeAutoFilter encryptedCodeAutoDefine, HidOperator operator, IRfNamedElement scopeElement) {
        IRfDefElement declaration = scopeElement.getDeclaration();
        if (declaration == null) {
            return;
        }
        boolean hasEncryptedCodeAutoPath = encryptedCodeAutoDefine.hasEncryptedCodeAutoPath(declaration.getParserPath());
        if (!hasEncryptedCodeAutoPath) {
            return;
        }
        RfEncryptedCodeAutoManager.computeAutoDefineForHidObject(encryptedCodeAutoDefine, operator, scopeElement, operator.getLHValue());
        ListContainer rhValues = operator.getRHValues();
        if (rhValues == null || rhValues.isEmpty()) {
            return;
        }
        for (IHidObject rhObject : rhValues) {
            RfEncryptedCodeAutoManager.computeAutoDefineForHidObject(encryptedCodeAutoDefine, operator, scopeElement, rhObject);
        }
    }

    private static void computeAutoDefineForHidObject(EncryptedCodeAutoFilter filter, HidOperator operator, IRfNamedElement scopeElement, IHidObject rhObject) {
        block7: {
            block9: {
                ListContainer rhValues;
                block8: {
                    block6: {
                        if (!(rhObject instanceof RfHidAccess)) break block6;
                        RfEncryptedCodeAutoManager.computeInfoForAccess(filter, operator, scopeElement, (RfHidAccess)rhObject);
                        break block7;
                    }
                    if (!(rhObject instanceof RfHid)) break block8;
                    RfEncryptedCodeAutoManager.computeInfoForHid(filter, operator, scopeElement, (RfHid)rhObject);
                    break block7;
                }
                if (!(operator instanceof RfHidOperator) || !((RfHidOperator)operator).isCoverpointExpression()) break block9;
                if (!(rhObject instanceof RfHidOperator)) break block7;
                IHidObject lhValue = ((RfHidOperator)rhObject).getLHValue();
                if (lhValue != null) {
                    RfEncryptedCodeAutoManager.computeAutoDefineForHidObject(filter, operator, scopeElement, lhValue);
                }
                if ((rhValues = ((RfHidOperator)rhObject).getRHValues()) == null || rhValues.isEmpty()) {
                    return;
                }
                for (IHidObject rhValue : rhValues) {
                    RfEncryptedCodeAutoManager.computeAutoDefineForHidObject(filter, operator, scopeElement, rhValue);
                }
                break block7;
            }
            if (rhObject instanceof RfHidOperator && ((RfHidOperator)rhObject).isVLOGConcatenation(true)) {
                ListContainer rhValues = ((RfHidOperator)rhObject).getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    return;
                }
                for (IHidObject rhValue : rhValues) {
                    RfEncryptedCodeAutoManager.computeAutoDefineForHidObject(filter, operator, scopeElement, rhValue);
                }
            }
        }
    }

    private static void computeInfoForHid(EncryptedCodeAutoFilter filter, HidOperator operator, IRfNamedElement scopeElement, RfHid rfHid) {
        if (!RfEncryptedCodeAutoManager.testAutoDefineCriteria(rfHid.getElement())) {
            return;
        }
        HidAccess parentAccess = rfHid.getParentAccess();
        if (parentAccess != null) {
            RfEncryptedCodeAutoManager.computeInfoForElement(filter, operator, scopeElement, rfHid, parentAccess.getAssociatedType(), true);
        } else if (scopeElement instanceof RfNamedElement) {
            RfEncryptedCodeAutoManager.computeInfoForElement(filter, operator, scopeElement, rfHid, ((RfNamedElement)scopeElement).getClosestTypeContainer(), false);
        }
    }

    private static void computeInfoForAccess(EncryptedCodeAutoFilter filter, HidOperator operator, IRfNamedElement scopeElement, RfHidAccess hidAccessArgs) {
        Hid functionHid = hidAccessArgs.getParentHid();
        if (!RfEncryptedCodeAutoManager.testAutoDefineCriteria(functionHid.getElement())) {
            return;
        }
        HidAccess parentAccess = functionHid.getParentAccess();
        if (parentAccess != null) {
            RfEncryptedCodeAutoManager.computeInfoForElement(filter, operator, scopeElement, functionHid, parentAccess.getAssociatedType(), true);
        } else if (scopeElement instanceof RfNamedElement) {
            RfEncryptedCodeAutoManager.computeInfoForElement(filter, operator, scopeElement, functionHid, ((RfNamedElement)scopeElement).getClosestTypeContainer(), false);
        }
    }

    private static void computeInfoForElement(EncryptedCodeAutoFilter filter, HidOperator operator, IRfNamedElement scopeElement, Hid select, IRfNamedElement definedScope, boolean noEnclosingScopeSearch) {
        int fileIndex;
        ParserPath parserPath;
        if (definedScope == null) {
            return;
        }
        IRfSingleLangProject singleLangProject = definedScope.getRfProject();
        if (!(singleLangProject instanceof RfProject)) {
            return;
        }
        RfProject rfProject = (RfProject)singleLangProject;
        Set<RfNamedElement> namedElementsWithEncryptedCode = rfProject.getNamedElementsWithEncryptedCode();
        if ((definedScope = RfEncryptedCodeAutoManager.computeDefinedScope(definedScope)) instanceof RfField && ((RfField)definedScope).isTypeParameter()) {
            return;
        }
        if (namedElementsWithEncryptedCode.contains(definedScope)) {
            ParserPath parserPath2 = scopeElement.getDeclaration().getParserPath();
            int fileIndex2 = rfProject.getFileIndex(parserPath2);
            filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(select, fileIndex2, scopeElement, (Object)operator, definedScope));
            return;
        }
        if (RfEncryptedCodeAutoManager.isConstructor(select)) {
            return;
        }
        if (definedScope instanceof RfClass) {
            RfClass parentClass = ((RfClass)definedScope).getParent();
            while (parentClass != null) {
                if (namedElementsWithEncryptedCode.contains(parentClass = parentClass.getGenericClass())) {
                    parserPath = scopeElement.getDeclaration().getParserPath();
                    fileIndex = rfProject.getFileIndex(parserPath);
                    filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(select, fileIndex, scopeElement, (Object)operator, (IRfNamedElement)parentClass));
                    break;
                }
                parentClass = parentClass.getParent();
            }
        }
        if (noEnclosingScopeSearch) {
            return;
        }
        IRfScopeElement definedEnclosingScope = definedScope.getEnclosingScope();
        while (definedEnclosingScope instanceof RfNamedElement) {
            if (namedElementsWithEncryptedCode.contains(definedEnclosingScope)) {
                parserPath = scopeElement.getDeclaration().getParserPath();
                fileIndex = rfProject.getFileIndex(parserPath);
                filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(select, fileIndex, scopeElement, (Object)operator, (IRfNamedElement)((RfNamedElement)definedEnclosingScope)));
                break;
            }
            definedEnclosingScope = definedEnclosingScope.getEnclosingScope();
        }
        IRfNamedElement scope = scopeElement;
        while (scope instanceof RfNamedElement) {
            List<ImportInfo> wildcardImports = ((RfNamedElement)scope).getWildcardImports();
            if (wildcardImports == null || wildcardImports.isEmpty()) {
                scope = ((RfNamedElement)scope).getEnclosingScope();
                continue;
            }
            for (ImportInfo importInfo : wildcardImports) {
                RfPackage pkg;
                IRfPackageElement pkgElement = importInfo.getPackage();
                if (!(pkgElement instanceof RfPackage) || !namedElementsWithEncryptedCode.contains(pkg = (RfPackage)pkgElement)) continue;
                int fileIndex3 = rfProject.getFileIndex(scopeElement.getDeclaration().getParserPath());
                filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(select, fileIndex3, scopeElement, (Object)operator, (IRfNamedElement)pkg));
            }
            scope = ((RfNamedElement)scope).getEnclosingScope();
        }
    }

    private static IRfNamedElement computeDefinedScope(IRfNamedElement definedScope) {
        while (definedScope instanceof RfListType) {
            definedScope = ((RfListType)definedScope).getResolvedType(true);
        }
        if (definedScope instanceof RfTypeAlias) {
            definedScope = ((RfTypeAlias)definedScope).getTranslatedType();
        }
        return definedScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean computeAutoDefineInfoForHidEngine(RfHid hid, EncryptedCodeAutoFilter filter, boolean triggerError, IRfNamedElement initialScope, IRfNamedElement parentScope, EncryptedCodeAutoFilter encryptedCodeAutoDefine) {
        try {
            IRfSingleLangProject singleLangProject;
            IRfNamedElement computeDefinedScope;
            if (initialScope == null) {
                return triggerError;
            }
            IRfDefElement initialScopeDeclaration = initialScope.getDeclaration();
            if (initialScopeDeclaration == null) {
                return triggerError;
            }
            ParserPath initialScopeParserPath = initialScopeDeclaration.getParserPath();
            if (!encryptedCodeAutoDefine.hasEncryptedCodeAutoPath(initialScopeParserPath)) {
                return triggerError;
            }
            if (!(parentScope instanceof RfNamedElement)) {
                return triggerError;
            }
            RfNamedElement closestTypeContainer = ((RfNamedElement)parentScope).getClosestTypeContainer();
            if (closestTypeContainer instanceof RfClass) {
                closestTypeContainer = ((RfClass)closestTypeContainer).getGenericClass();
            }
            if ((computeDefinedScope = RfEncryptedCodeAutoManager.computeDefinedScope(closestTypeContainer)) instanceof RfNamedElement) {
                closestTypeContainer = (RfNamedElement)computeDefinedScope;
            }
            if (!((singleLangProject = initialScope.getRfProject()) instanceof RfProject)) {
                return triggerError;
            }
            if (closestTypeContainer instanceof RfField && ((RfField)closestTypeContainer).isTypeParameter()) {
                return triggerError;
            }
            RfProject rfProject = (RfProject)singleLangProject;
            Set<RfNamedElement> namedElementsWithEncryptedCode = rfProject.getNamedElementsWithEncryptedCode();
            if (namedElementsWithEncryptedCode.contains(closestTypeContainer)) {
                ParserPath parserPath = initialScopeParserPath;
                int fileIndex = rfProject.getFileIndex(parserPath);
                filter.addHidWrapper(new AutoDefineAPIWrapper((Hid)hid, fileIndex, initialScope, (Object)closestTypeContainer, (IRfNamedElement)closestTypeContainer));
                return false;
            }
            if (RfEncryptedCodeAutoManager.isConstructor(hid)) {
                return triggerError;
            }
            if (closestTypeContainer instanceof RfClass) {
                RfClass parentClass = ((RfClass)closestTypeContainer).getParent();
                while (parentClass != null) {
                    if (namedElementsWithEncryptedCode.contains(parentClass = parentClass.getGenericClass())) {
                        int fileIndex = rfProject.getFileIndex(initialScopeParserPath);
                        filter.addHidWrapper(new AutoDefineAPIWrapper((Hid)hid, fileIndex, initialScope, (Object)parentClass, (IRfNamedElement)parentClass));
                        return false;
                    }
                    parentClass = parentClass.getParent();
                }
            }
            if (hid.getParentAccess() != null) {
                return triggerError;
            }
            RfNamedElement enclosingScope = closestTypeContainer.getEnclosingScope();
            while (enclosingScope != null) {
                if (namedElementsWithEncryptedCode.contains(enclosingScope)) {
                    ParserPath parserPath = initialScopeParserPath;
                    int fileIndex = rfProject.getFileIndex(parserPath);
                    filter.addHidWrapper(new AutoDefineAPIWrapper((Hid)hid, fileIndex, initialScope, (Object)enclosingScope, (IRfNamedElement)enclosingScope));
                    return false;
                }
                enclosingScope = enclosingScope.getEnclosingScope();
            }
            IRfNamedElement scope = initialScope;
            while (scope instanceof RfNamedElement) {
                List<ImportInfo> wildcardImports = ((RfNamedElement)scope).getWildcardImports();
                if (wildcardImports == null || wildcardImports.isEmpty()) {
                    scope = ((RfNamedElement)scope).getEnclosingScope();
                    continue;
                }
                for (ImportInfo importInfo : wildcardImports) {
                    RfPackage pkg;
                    IRfPackageElement pkgElement = importInfo.getPackage();
                    if (!(pkgElement instanceof RfPackage) || !namedElementsWithEncryptedCode.contains(pkg = (RfPackage)pkgElement)) continue;
                    ParserPath parserPath = initialScopeParserPath;
                    int fileIndex = rfProject.getFileIndex(parserPath);
                    filter.addHidWrapper(new AutoDefineAPIWrapper((Hid)hid, fileIndex, initialScope, (Object)pkg, (IRfNamedElement)pkg));
                    return false;
                }
                scope = ((RfNamedElement)scope).getEnclosingScope();
            }
            return triggerError;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return triggerError;
        }
    }

    public static void computeEncryptedCodeAutoInOperatorEngine(Hid hid, HidOperator operator, EncryptedCodeAutoFilter filter, IRfNamedElement scopeElement, ParserPath parserPath) {
        try {
            if (hid.getElement() != null) {
                return;
            }
            if (!filter.hasEncryptedCodeAutoPath(parserPath)) {
                return;
            }
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                return;
            }
            IRfNamedElement definedScope = parentAccess.getAssociatedType();
            if (definedScope == null) {
                return;
            }
            IRfSingleLangProject singleLangProject = definedScope.getRfProject();
            if (!(singleLangProject instanceof RfProject)) {
                return;
            }
            RfProject rfProject = (RfProject)singleLangProject;
            if (definedScope instanceof RfClass) {
                definedScope = ((RfClass)definedScope).getGenericClass();
            }
            if ((definedScope = RfEncryptedCodeAutoManager.computeDefinedScope(definedScope)) instanceof RfField && ((RfField)definedScope).isTypeParameter()) {
                return;
            }
            Set<RfNamedElement> namedElementsWithEncryptedCode = rfProject.getNamedElementsWithEncryptedCode();
            if (namedElementsWithEncryptedCode.contains(definedScope)) {
                int fileIndex = rfProject.getFileIndex(parserPath);
                filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(hid, fileIndex, scopeElement, (Object)operator, definedScope));
                return;
            }
            if (!(definedScope instanceof RfClass)) {
                return;
            }
            RfClass parentClass = ((RfClass)definedScope).getParent();
            while (parentClass != null) {
                if (namedElementsWithEncryptedCode.contains(parentClass = parentClass.getGenericClass())) {
                    int fileIndex = rfProject.getFileIndex(parserPath);
                    filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(hid, fileIndex, scopeElement, (Object)operator, (IRfNamedElement)parentClass));
                    break;
                }
                parentClass = parentClass.getParent();
            }
            IRfNamedElement scope = scopeElement;
            while (scope instanceof RfNamedElement) {
                List<ImportInfo> wildcardImports = ((RfNamedElement)scope).getWildcardImports();
                if (wildcardImports == null || wildcardImports.isEmpty()) {
                    scope = ((RfNamedElement)scope).getEnclosingScope();
                    continue;
                }
                for (ImportInfo importInfo : wildcardImports) {
                    RfPackage pkg;
                    IRfPackageElement pkgElement = importInfo.getPackage();
                    if (!(pkgElement instanceof RfPackage) || !namedElementsWithEncryptedCode.contains(pkg = (RfPackage)pkgElement)) continue;
                    int fileIndex = rfProject.getFileIndex(parserPath);
                    filter.addHidOperatorWrapper(new AutoDefineAPIWrapper(hid, fileIndex, scopeElement, (Object)pkg, (IRfNamedElement)pkg));
                }
                scope = ((RfNamedElement)scope).getEnclosingScope();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean shouldSkipUsageBeforeDeclarationError(IRfNamedElement element, RfProject rfProject, IRfNamedElement useScope) {
        RfPackage enclosingPackage;
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (element instanceof RfClass) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return false;
                        }
                    }
                    EncryptedCodeAutoFilter encryptedCodeAutoFilter = rfProject.getEncryptedCodeAutoFilter();
                    if (encryptedCodeAutoFilter != null && encryptedCodeAutoFilter.hasEnabledEncryptedCodeAuto()) break block7;
                    return false;
                }
                if (useScope instanceof RfNamedElement) break block8;
                return false;
            }
            enclosingPackage = ((RfNamedElement)useScope).getEnclosingPackage();
            if (enclosingPackage != null) break block9;
            return false;
        }
        return rfProject.getNamedElementsWithEncryptedCode().contains(enclosingPackage);
    }

    static class AssocDataTypeWrapper {
        IRfNamedElement associatedType;
        DataType dataType;

        public AssocDataTypeWrapper(IRfNamedElement associatedType, DataType dataType) {
            this.associatedType = associatedType;
            this.dataType = dataType;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public IRfNamedElement getAssociatedType() {
            return this.associatedType;
        }
    }
}

