/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.diagrams.netlist.model.NLPortLabelOptions;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipInformationUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataReferenceType;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNetTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.ams.RfDiscipline;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;

public class RfField
extends RfAssociatedType
implements IRfFieldElement,
Cloneable {
    private static final long serialVersionUID = 3L;
    public static final char DVT_UNDEFINED_MACRO_PREFIX_CHAR = '`';
    private static final String NA_BITS_SUFFIX = " : N/A bits";
    private static final String BIT_SUFFIX = " bit";
    private static final String BITS_SUFFIX = " bits";
    private static final String COLON = " : ";
    private static final String MULTIPLICATION_SIGN = " x ";
    private static final byte HIERARCHY_PATH_UNDETERMINED_REFERENCES = 0;
    private static final byte HIERARCHY_PATH_NO_REFERENCES = 1;
    private static final byte HIERARCHY_PATH_HAS_REFERENCES = 2;
    private short fKind = 1;
    private byte fInitialValueParametricDependencyValue;
    private byte fInitialValueWithHierarchyPathReferencesValue;
    private boolean fIsInParameterPortList;
    private String fInitialValue;
    private ParameterKind fParameterKind;
    private transient Boolean hasUserDefinedNetType;
    private Boolean isHidden;

    public RfField(String name, boolean escaped, DataType type, int kind, int qualifiers, String initialValue) {
        super(name, escaped, null);
        if (type != null) {
            this.fDataType = type.copy();
        }
        this.fKind = (short)kind;
        this.fIsInParameterPortList = false;
        this.fInitialValue = initialValue;
        this.fInitialValueParametricDependencyValue = 0;
        this.setQualifiers(qualifiers);
    }

    public RfField(String name, boolean escaped, DataType type, int kind, int qualifiers, String initialValue, boolean isInParameterPortList, ParameterKind parameterKind) {
        this(name, escaped, type, kind, qualifiers, initialValue);
        this.fParameterKind = parameterKind;
        this.fIsInParameterPortList = isInParameterPortList;
    }

    public RfField(RfField field) {
        super(field.getName(), field.isEscaped(), null);
        this.setHidHolder(field.getHidHolder());
        DataType type = field.getDataType();
        if (type != null) {
            this.fDataType = type.copy();
        }
        this.fKind = field.fKind;
        this.fParameterKind = field.fParameterKind;
        this.fIsInParameterPortList = field.fIsInParameterPortList;
        this.fInitialValue = field.fInitialValue;
        this.fInitialValueParametricDependencyValue = field.fInitialValueParametricDependencyValue;
        this.fInitialValueWithHierarchyPathReferencesValue = field.fInitialValueWithHierarchyPathReferencesValue;
        this.setQualifiers(field.getQualifiers());
    }

    public void init(DataType type, int kind, int qualifiers, String initialValue) {
        super.init(null);
        if (this.fDataType == null) {
            if (type != null) {
                this.fDataType = type.copy();
            }
        } else {
            this.fDataType.combineWithAnother(type);
        }
        this.fKind = (short)kind;
        this.fInitialValue = initialValue != null || this.hasNoDefs(true) ? initialValue : this.fInitialValue;
        this.fInitialValueParametricDependencyValue = 0;
        this.setQualifiers(this.getQualifiers() | qualifiers);
    }

    public void init(DataType dataType, int kind, int qualifiers, String initialValue, boolean isInParameterPortList, ParameterKind parameterKind) {
        this.init(dataType, kind, qualifiers, initialValue);
        this.fIsInParameterPortList = isInParameterPortList;
        this.fParameterKind = parameterKind;
        this.fIsInParameterPortList = isInParameterPortList;
    }

    private static void internalResolveLocalHidsAndOperatorsAtIncremental(RfNamedElement scope, ELWidthCheckContext widthCheckContext, ELManager elabManager) {
        IRfSingleLangProject rfProject = elabManager.getStartingVLOGProject();
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, scope.getEnclosingLibrary(), false, rfProject.getToolCompat());
        configInfo.setElabContext(widthCheckContext);
        configInfo.setElabWidthCheckDisabled(elabManager.isElabWidthCheckDisabled());
        configInfo.setElabWidthCheckFiltered(elabManager.isElabWidthCheckFiltered());
        scope.resolveLocalHids(configInfo, true);
        scope.resolveLocalHidOperators(configInfo, true);
    }

    @Override
    public void resolveHidsAndOperatorsAtIncremental(ELManager elabManager, IRfNamedElement elaboratedScope, Map<ELSpecializationWrapper, ELSpecializationWrapper> specs) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (specs == null || specs.isEmpty()) {
            RfField.internalResolveLocalHidsAndOperatorsAtIncremental(enclosingScope, ELWidthCheckContext.of((ELParamValues)ELUtils.getValidParamValues((ELParamValues)elabManager.getExternalConstants(elaboratedScope)), Collections.emptyList(), (ELManager)elabManager), elabManager);
            return;
        }
        for (ELSpecializationWrapper specWrapper : specs.keySet()) {
            RfField.internalResolveLocalHidsAndOperatorsAtIncremental(enclosingScope, specWrapper.getElabContext(elabManager), elabManager);
        }
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        DVTLinkedHashMap<String, RfNamedElement> members;
        if (incrementalDeltaContainer != null && !incrementalDeltaContainer.visitedExternalFunctionsArguments.contains(this)) {
            RfNamedElement namedElement;
            RfDefElement parentDef = def instanceof RfFieldDef ? ((RfFieldDef)def).getParentDef() : null;
            RfNamedElement rfNamedElement = namedElement = parentDef != null ? parentDef.getNamedElement() : null;
            if (incrementalDeltaContainer != null && parentDef instanceof RfFunctionDef && namedElement != null && namedElement.isExtern()) {
                if (this.isArgument() && this.getDeclarations().size() != 2) {
                    incrementalDeltaContainer.diffArgumentsExternalFunctions.add(this);
                }
                incrementalDeltaContainer.visitedExternalFunctionsArguments.add(this);
            }
        }
        super.removeDef(incrementalDeltaContainer, def);
        int qualifiers = this.getParserQualifiers();
        if (incrementalDeltaContainer != null && !(this instanceof RfCoverpoint)) {
            if (this.fDataType != null && !incrementalDeltaContainer.oldCompleteDataType.containsKey(this)) {
                incrementalDeltaContainer.oldCompleteDataType.put(this, this.fDataType.copy());
            }
            if (qualifiers != 0 && !incrementalDeltaContainer.oldCompleteFieldQualifiers.containsKey(this)) {
                incrementalDeltaContainer.oldCompleteFieldQualifiers.put(this, qualifiers);
            }
        }
        if (this.fDataType != null && def instanceof RfFieldDef && ((RfFieldDef)def).allowDataTypeSplit()) {
            this.fDataType.splitWithAnother(def.getDataType(this), def.getParserPath());
        }
        if (qualifiers != 0 && !this.isImplicitSignal()) {
            this.setQualifiers(0);
        }
        if (this.isArrayMethodItem() && (members = this.internalGetMembers()) != null) {
            members.clear();
        }
        this.hasUserDefinedNetType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInitialValueWithHierarchyPathReferences(IHidObject initialValue) {
        if (this.fInitialValueWithHierarchyPathReferencesValue > 0) {
            return this.fInitialValueWithHierarchyPathReferencesValue == 2;
        }
        RfField rfField = this;
        synchronized (rfField) {
            block10: {
                boolean hasGenerateBlockEnclosing;
                boolean hasInstanceHolderEnclosing;
                RfNamedElement enclosingScope;
                block9: {
                    if (this.fInitialValueWithHierarchyPathReferencesValue > 0) {
                        return this.fInitialValueWithHierarchyPathReferencesValue == 2;
                    }
                    enclosingScope = this.getEnclosingScope();
                    hasInstanceHolderEnclosing = enclosingScope instanceof RfInstanceHolder;
                    hasGenerateBlockEnclosing = enclosingScope instanceof RfGenerateBlock;
                    if (this.isAnyParameter() && hasInstanceHolderEnclosing | hasGenerateBlockEnclosing) break block9;
                    this.fInitialValueWithHierarchyPathReferencesValue = 1;
                    return false;
                }
                if (initialValue != null) break block10;
                if (hasInstanceHolderEnclosing) {
                    initialValue = ((RfInstanceHolder)enclosingScope).getElabConstantDefaultExpressions().get(this.getName());
                }
                if (hasGenerateBlockEnclosing) {
                    initialValue = ((RfGenerateBlock)enclosingScope).getElabConstantDefaultExpressions().get(this.getName());
                }
                if (initialValue != null) break block10;
                this.fInitialValueWithHierarchyPathReferencesValue = 1;
                return false;
            }
            boolean hasInitialValueWithHierarchyPathReferences = initialValue.hasHierarchyPathReferences();
            this.fInitialValueWithHierarchyPathReferencesValue = (byte)(hasInitialValueWithHierarchyPathReferences ? 2 : 1);
            return hasInitialValueWithHierarchyPathReferences;
        }
    }

    @Override
    public int getInducedParametricDependencyValue() {
        if (this.isEffectiveLocalParameter() || this.isEnumElement()) {
            return this.fInitialValueParametricDependencyValue;
        }
        if (this.isAnyParameter() || this.isGenvar()) {
            return this.isTypeParameter() ? 7 : 3;
        }
        return 1;
    }

    public void updateInitialValueParametricDependencyValue(int value) {
        this.fInitialValueParametricDependencyValue = (byte)(this.fInitialValueParametricDependencyValue | value);
    }

    @Override
    public boolean typeIsScalar() {
        if (this.isTypeParameter()) {
            return false;
        }
        return super.typeIsScalar();
    }

    public String getRange() {
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.getPackedDimension() == null) {
            return "";
        }
        return dataType.getPackedDimensionString();
    }

    @Override
    public String implicitSpecificTypeName() {
        return this.isAnyParameter() ? null : super.implicitSpecificTypeName();
    }

    @Override
    protected int internalMaxDefSizePerElement() {
        return 6;
    }

    @Override
    public String getNameForNoDuplicateList() {
        RfGenerateBlock enclosingGenerate = this.getEnclosingScope(RfGenerateBlock.class);
        if (enclosingGenerate != null) {
            return String.valueOf(this.getName()) + "@" + enclosingGenerate.getName() + "@" + enclosingGenerate.getExpression();
        }
        return this.getName();
    }

    @Override
    protected String implicitTypeName() {
        if (!this.isAnyParameter()) {
            return RfBitVectorScalarType.LOGIC.getName();
        }
        if (this.isTypeParameter()) {
            return null;
        }
        DataType dataType = this.getDataType();
        return dataType != null && !(dataType instanceof DataReferenceType) && dataType.fType == null && dataType.hasPackedDimension() ? RfBitVectorScalarType.LOGIC.getName() : null;
    }

    @Override
    protected String implicitNetType() {
        return null;
    }

    protected byte implicitDirection() {
        return 1;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    private byte getDirection() {
        DataType dataType = this.getDataType();
        byte direction = dataType != null ? dataType.getDirection() : (byte)0;
        return direction == 0 ? this.implicitDirection() : direction;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        return this.isEnumElement() || this.isEnumRangeElement() ? this.getEnclosingScope() : super.getAssociatedTypeNoLastLevelParams(typesResolver, parametricDependency);
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        if (this.isTypeParameter()) {
            IRfNamedElement assocType = typesResolver.computeTypeParameter(this, new ParametricDependency(1), this, true, false);
            if (this.isEffectiveLocalParameter()) {
                this.fInitialValueParametricDependencyValue = (byte)(this.fInitialValueParametricDependencyValue | this.getLastLevelDataType().getParametricDependencyValue());
            }
            return assocType;
        }
        if (this.isParameterNoDataType()) {
            IRfNamedElement assocType = typesResolver.computeTypeOfParameterNoDataType(this);
            return assocType;
        }
        return super.getAssociatedType(typesResolver);
    }

    public String getNetTypeName() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return "";
        }
        if (dataType.getNetType() != null) {
            return dataType.getNetType();
        }
        String implicitNetType = this.implicitSpecificNetType();
        return implicitNetType != null ? implicitNetType : "";
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        int qualifiedNameOptions = 771;
        String elaboratedConstantSignature = this.getElaboratedConstantSignature(resolver, qualifiedNameOptions | 4);
        if (elaboratedConstantSignature != null) {
            return elaboratedConstantSignature;
        }
        String accessKind = this.isPrivate() ? "private" : (this.isProtected() ? "protected" : "public");
        String staticAutomatic = this.isStorageStatic() ? "static" : "automatic";
        DataType dataType = this.getDataType();
        String assocTypeName = this.getAssociatedTypeName(this.getEnclosingScope(), resolver, qualifiedNameOptions, false, true, false);
        String[] assocTypeNameSplitted = RfListType.splitUnpackedDimesnions(assocTypeName);
        RfNamedElement enclosingScope = this.getEnclosingScope();
        StringBuilder signature = null;
        String initialValue = null;
        String directionString = null;
        switch (this.fKind) {
            case 1: {
                if (this.isNet()) {
                    String netType = dataType != null && dataType.getNetType() != null ? String.valueOf(dataType.getNetType()) + " " : "";
                    return String.valueOf(netType) + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1];
                }
                return "field " + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1] + (enclosingScope instanceof RfClass ? this.getExtraFlagsInfo(enclosingScope, accessKind, staticAutomatic) : "");
            }
            case 2048: {
                return String.valueOf(this instanceof RfCovercross ? "covercross " : "coverpoint ") + this.printScope() + this.getName();
            }
            case 2: {
                directionString = this.getDirectionString();
                return "argument " + (directionString.isEmpty() ? "" : String.valueOf(directionString) + " ") + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1] + this.getExtraFlagsInfo(enclosingScope, null, staticAutomatic);
            }
            case 4: {
                return "variable " + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1] + this.getExtraFlagsInfo(enclosingScope, null, staticAutomatic);
            }
            case 512: {
                return "genvar " + assocTypeName + " " + this.printScope() + this.getName();
            }
            case 1024: {
                return "branch  " + this.printScope() + this.getName();
            }
            case 8: {
                initialValue = this.computeEnumInitialValue();
                return "enum " + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1] + (initialValue == null ? "" : " (value = " + initialValue + ")");
            }
            case 16: {
                return "enum " + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1];
            }
            case 32: {
                return "covergroup " + this.printScope() + this.getName();
            }
            case 64: {
                return "instance " + assocTypeNameSplitted[0] + " " + this.printScope() + this.getName() + assocTypeNameSplitted[1];
            }
            case 128: {
                signature = new StringBuilder();
                signature.append(this.fParameterKind != null ? this.fParameterKind.toString() : "parameter").append(' ');
                if (dataType != null && dataType.fType != null) {
                    signature.append(assocTypeNameSplitted[0]).append(' ');
                    signature.append(String.valueOf(this.printScope()) + this.getName()).append(assocTypeNameSplitted[1]);
                } else {
                    signature.append(String.valueOf(this.printScope()) + this.getName());
                }
                initialValue = this.getInitialValue(false);
                if (initialValue != null) {
                    signature.append(" = ").append(initialValue);
                }
                return signature.toString();
            }
            case 256: {
                signature = new StringBuilder();
                signature.append(this.fParameterKind != null ? this.fParameterKind.toString() : "parameter").append(" type ");
                signature.append(String.valueOf(this.printScope()) + this.getName());
                if (!assocTypeName.isEmpty()) {
                    signature.append(" = ").append(assocTypeName);
                }
                return signature.toString();
            }
        }
        return null;
    }

    private String getElaboratedConstantSignature(RfTypesResolver resolver, int qualifiedNameOptions) {
        if (!ELUtils.isVLOGConstant((IRfNamedElement)this)) {
            return null;
        }
        String completeName = String.valueOf(this.printScope()) + this.getName();
        resolver = RfTypesResolver.create(resolver);
        resolver.update(this, null, false, false);
        IELParamValue elabConstantValue = resolver.getValueDirectly(this.getName());
        if (ELUtils.isUnsuccessfulEval((IELParamValue)elabConstantValue)) {
            return null;
        }
        StringBuilder signature = new StringBuilder();
        signature.append(this.fParameterKind != null ? this.fParameterKind.toString() : (this.isEnumElement() ? "enum" : "parameter")).append(' ');
        String actualValue = null;
        if (this.isTypeParameter()) {
            signature.append("type ").append(completeName);
            actualValue = elabConstantValue.getNamedElement().getQualifiedName((IRfScopeElement)resolver.getNamedElement(), resolver.getHierarchyPath(), qualifiedNameOptions);
        } else if (this.isParameterNoDataType()) {
            signature.append(completeName);
            actualValue = elabConstantValue.toNiceString(BitVectorContext.of((DVTNumber)BitVectorContext.NO_CONTEXT, (IRfNamedElement)this), IRfNamedElement.QualifiedNameOptions.contains((int)512, (int)qualifiedNameOptions) ? PrefConst.getParamRadix() : 10, IRfNamedElement.QualifiedNameOptions.contains((int)256, (int)qualifiedNameOptions), false);
        } else {
            BitVectorContext paramContext = ELUtils.makeEvaluatorContext((IHidEvaluator)RfTypesResolver.create(resolver), (IRfNamedElement)this, (ElementPath)resolver.getHierarchyPath(), (ELManager)resolver.getManager());
            if (paramContext != null && paramContext.getContextType() != null) {
                String[] assocTypeName = RfListType.splitUnpackedDimesnions(paramContext.getContextType().getQualifiedName((IRfScopeElement)resolver.getNamedElement(), resolver.getHierarchyPath(), qualifiedNameOptions));
                signature.append(assocTypeName[0]).append(' ');
                signature.append(completeName).append(assocTypeName[1]);
            } else {
                signature.append(this.getParamBaseType(elabConstantValue));
                signature.append(this.getParamPackedDimension(elabConstantValue)).append(' ');
                signature.append(completeName).append(this.getParamUnpackedDimension(elabConstantValue));
            }
            actualValue = elabConstantValue.toNiceString(paramContext, IRfNamedElement.QualifiedNameOptions.contains((int)512, (int)qualifiedNameOptions) ? PrefConst.getParamRadix() : 10, IRfNamedElement.QualifiedNameOptions.contains((int)256, (int)qualifiedNameOptions), false);
        }
        DVTTooltipInformationUtils.getInstance().appendParamActualValue(signature, actualValue, " = ");
        DVTTooltipInformationUtils.getInstance().appendParamDefaultValue(signature, this.getInitialValue(true));
        return signature.toString();
    }

    private String getExtraFlagsInfo(RfNamedElement enclosingScope, String accessKind, String staticAutomatic) {
        if (staticAutomatic == null && accessKind == null) {
            return "";
        }
        if (enclosingScope instanceof RfFunction && ((RfFunction)enclosingScope).isLet()) {
            return "";
        }
        if (enclosingScope instanceof RfClass) {
            return "\n[" + (accessKind == null ? "" : String.valueOf(accessKind) + ", ") + (staticAutomatic == null ? "" : staticAutomatic) + "]";
        }
        if (enclosingScope instanceof RfPropertySequence) {
            return "";
        }
        if (staticAutomatic == null) {
            return "";
        }
        return "\n[" + staticAutomatic + "]";
    }

    private int initialValueAsInt(int defaultValue) {
        if (this.fInitialValue == null || this.fInitialValue.isEmpty()) {
            return defaultValue;
        }
        return DVTStringUtil.parseInt((String)this.fInitialValue, (int)-1);
    }

    private String computeEnumInitialValue() {
        if (this.isEnumRangeElement()) {
            return null;
        }
        if (this.fInitialValue != null && !this.fInitialValue.isEmpty()) {
            return this.fInitialValue;
        }
        List<RfField> fields = this.getEnclosingScope().getFields();
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        int value = -1;
        int i = 0;
        while (i < fields.size()) {
            RfField field = fields.get(i);
            if (field == this) break;
            if (field.isEnumRangeElement()) {
                return null;
            }
            if ((value = field.initialValueAsInt(value + 1)) == -1) {
                return null;
            }
            ++i;
        }
        return Integer.toString(value + 1);
    }

    @Override
    public RfDefElement addDeclaration(RfDefElement element) {
        if (!(element instanceof RfFieldDef)) {
            return super.addDeclaration(element);
        }
        if (this.fDefs != null && this.fDefs.size() >= this.internalMaxDefSizePerElement()) {
            return (RfDefElement)this.fDefs.get(0);
        }
        element.addNamedElement(this);
        if (this.fDefs == null) {
            this.fDefs = element;
            return element;
        }
        RfDefElement firstDefParent = ((RfFieldDef)this.fDefs.get(0)).getParentDef();
        RfDefElement newDefParent = ((RfFieldDef)element).getParentDef();
        this.fDefs = newDefParent instanceof RfFunctionDef && ((RfFunctionDef)newDefParent).isPrototype() && firstDefParent instanceof RfFunctionDef && !((RfFunctionDef)firstDefParent).isPrototype() ? OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (int)0, (Object)element) : OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (Object)element);
        return element;
    }

    private String getParamBaseType(IELParamValue value) {
        if (!(value instanceof ELParamValues.ParamValueNumber)) {
            return "";
        }
        DVTNumber dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber();
        while (dvtNumber instanceof DVTUnpackedArray) {
            dvtNumber = ((DVTUnpackedArray)dvtNumber).decreaseDimension();
        }
        if (dvtNumber instanceof VlogRealNumber) {
            return "real";
        }
        if (dvtNumber instanceof VlogShortrealNumber) {
            return "shortreal";
        }
        if (!(dvtNumber instanceof VlogBitVector)) {
            return "";
        }
        return ((VlogBitVector)dvtNumber).is4State() ? "logic" : "bit";
    }

    private String getParamUnpackedDimension(IELParamValue value) {
        if (!(value instanceof ELParamValues.ParamValueNumber)) {
            return "";
        }
        DVTNumber dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber();
        if (!(dvtNumber instanceof DVTUnpackedArray)) {
            return "";
        }
        StringBuilder unPackedDimension = new StringBuilder();
        while (dvtNumber instanceof DVTUnpackedArray) {
            int left = ((DVTUnpackedArray)dvtNumber).getLeft();
            int right = ((DVTUnpackedArray)dvtNumber).getRight();
            unPackedDimension.append("[").append(left).append(":").append(right).append("]");
            dvtNumber = ((DVTUnpackedArray)dvtNumber).decreaseDimension();
        }
        if (!(dvtNumber instanceof VlogBitVector)) {
            return "";
        }
        return unPackedDimension.toString();
    }

    public String getParamPackedDimension(IELParamValue value) {
        if (!(value instanceof ELParamValues.ParamValueNumber)) {
            return "";
        }
        DVTNumber dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber();
        while (dvtNumber instanceof DVTUnpackedArray) {
            dvtNumber = ((DVTUnpackedArray)dvtNumber).decreaseDimension();
        }
        if (!(dvtNumber instanceof VlogBitVector)) {
            return "";
        }
        int[] arrayDimensions = ((VlogBitVector)dvtNumber).getArrayDimensions();
        int noOfDimensions = arrayDimensions.length;
        StringBuilder packedDimension = new StringBuilder();
        int i = 0;
        while (i < noOfDimensions) {
            int left = arrayDimensions[i];
            int right = arrayDimensions[i + 1];
            if (left != right) {
                packedDimension.append("[").append(left).append(":").append(right).append("]");
            }
            i += 2;
        }
        return packedDimension.toString();
    }

    public boolean isOptionalArgument() {
        return false;
    }

    public boolean isBuffer() {
        return false;
    }

    public boolean isLinkage() {
        return false;
    }

    public boolean isInput() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        return dataType.getDirection() == 1;
    }

    public boolean isOutput() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        return dataType.getDirection() == 3;
    }

    public boolean isInout() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        return dataType.getDirection() == 2;
    }

    public boolean isRef() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        byte direction = dataType.getDirection();
        return direction == 4 | direction == 5;
    }

    public boolean isConstRef() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        return dataType.getDirection() == 5;
    }

    public boolean hasImplicitDirection() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return true;
        }
        return dataType.hasImplicitDirection();
    }

    @Override
    public boolean hasProperty(int kind) {
        return (this.fKind & kind) != 0;
    }

    public boolean isArgument() {
        return this.fKind == 2;
    }

    public boolean isSignal() {
        String kindName = this.getKindName();
        if ("net".equals(kindName)) {
            return true;
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        String type = dataType.getType();
        if (type == null) {
            return false;
        }
        return type.startsWith("reg");
    }

    public boolean isLetArgument() {
        if (this.fKind != 2) {
            return false;
        }
        RfNamedElement scope = this.getEnclosingScope();
        return scope instanceof RfFunction && ((RfFunction)scope).isLet();
    }

    public boolean isGenvar() {
        return this.fKind == 512;
    }

    public boolean isVariable() {
        return this.fKind == 4;
    }

    public boolean isField() {
        return this.fKind == 1;
    }

    public boolean isInstance() {
        return this.fKind == 64;
    }

    public boolean isParameter() {
        return this.fKind == 128;
    }

    public boolean isTypeParameter() {
        return this.fKind == 256;
    }

    public boolean isCoverpoint() {
        return this.fKind == 2048;
    }

    public boolean isEnumElement() {
        return this.fKind == 8;
    }

    public boolean isEnumRangeElement() {
        return this.fKind == 16;
    }

    public boolean isEnumRangeGeneratedElement() {
        return this.fKind == 8 && this.getDataType() != null && this.getDataType().getEnumRange() != null;
    }

    public boolean isElabConstant() {
        return (this.fKind & 0x188) != 0;
    }

    public boolean isPhysicalUnit() {
        return false;
    }

    public boolean isEvent() {
        DataType dataType = this.getRawDataType();
        if (dataType == null) {
            return false;
        }
        return "event".equals(dataType.fType);
    }

    public boolean isNet() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        if (dataType.fNetType != null) {
            return !"var".equals(dataType.fNetType);
        }
        return this.hasUserDefinedNetType(true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFromEmbeddedCovergroupDef() {
        void declaration;
        void var2_1;
        RfFieldDef rfFieldDef;
        RfDefElement rfDefElement = this.getDeclaration();
        return rfDefElement instanceof RfFieldDef && (rfFieldDef = (RfFieldDef)rfDefElement) == (RfFieldDef)var2_1 && declaration.getParentDef() instanceof RfCovergroupDef;
    }

    public boolean hasUserDefinedNetType(boolean includeAms) {
        if (this.hasUserDefinedNetType != null) {
            return this.hasUserDefinedNetType;
        }
        RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)this, this.getRfProject(), 8);
        IRfNamedElement type = this.getAssociatedTypeNoLastLevelParams(typesResolver);
        if (type instanceof IRfListType) {
            type = type instanceof RfListType ? ((RfListType)type).getAssociatedBaseTypeNoLastLevelParams(typesResolver, false) : ((IRfListType)type).getAssociatedBaseType();
        }
        this.hasUserDefinedNetType = type instanceof RfNetTypeAlias || includeAms && type instanceof RfDiscipline;
        return this.hasUserDefinedNetType;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return this.isAnyParameter() || this.isEnumElement() || this.isGenvar();
    }

    @Override
    public boolean canStaticAccess() {
        return this.isTypeParameter();
    }

    public int getFieldKind() {
        return this.fKind;
    }

    public int getInterfaceKind() {
        return 0;
    }

    public String getInitialValue(boolean forceComputeEnumValue) {
        if (!forceComputeEnumValue || !this.isEnumElement()) {
            return this.fInitialValue;
        }
        DataType dataType = this.getRawDataType();
        if (dataType == null) {
            return this.fInitialValue;
        }
        return this.computeEnumInitialValue();
    }

    public boolean isNamed() {
        return this.getName().length() != 0;
    }

    public boolean isInParameterPortList() {
        return this.fIsInParameterPortList;
    }

    public ParameterKind getParameterKind() {
        return this.fParameterKind;
    }

    public boolean isRegularParameter() {
        return this.fParameterKind == ParameterKind.PARAMETER;
    }

    public boolean isLocalParameter() {
        return this.fParameterKind == ParameterKind.LOCALPARAM;
    }

    public boolean isEffectiveLocalParameter() {
        if (this.isLocalParameter()) {
            return true;
        }
        if (!this.isAnyParameter()) {
            return false;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        return !this.isInParameterPortList() && (!(enclosingScope instanceof RfInstanceHolder) || enclosingScope instanceof RfInstanceHolder && !((RfInstanceHolder)enclosingScope).hasMissingParameterPortList());
    }

    public boolean isSpecParam() {
        return this.fParameterKind == ParameterKind.SPECPARAM;
    }

    public boolean isAliasParam() {
        return this.fParameterKind == ParameterKind.ALIASPARAM;
    }

    public boolean isDynamicParam() {
        return this.fParameterKind == ParameterKind.DYNAMICPARAM;
    }

    public boolean isParameterNoDataType() {
        if (!this.isParameter()) {
            return false;
        }
        DataType dataType = this.getDataType();
        return dataType == null || !(dataType instanceof DataReferenceType) && dataType.fType == null && !dataType.hasPackedDimension();
    }

    public boolean hasInterconnectNettype() {
        DataType dataType = this.getDataType();
        return dataType != null && "interconnect".equals(dataType.fNetType);
    }

    public boolean isVirtualInterface() {
        if (this.getDataType() == null) {
            return false;
        }
        return this.getDataType().isVirtualInterface();
    }

    public boolean isForLoopParameter() {
        return this.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)this.getEnclosingScope()).isForOrForeach();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        if (this.isEvent()) {
            return "DUPLICATE_EVENT: Duplicate event ''{0}'', already declared\n    at line {1,number,#######} in {2}";
        }
        switch (this.fKind) {
            case 4: {
                return "DUPLICATE_VARIABLE: Duplicate variable ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
            case 2: {
                return "DUPLICATE_ARGUMENT: Duplicate argument ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
            case 128: 
            case 256: {
                return "DUPLICATE_PARAMETER: Duplicate parameter ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
            case 8: {
                return "DUPLICATE_ENUM_LITERAL: Duplicate enumeration literal ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_FIELD: Duplicate field ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    public String getDirectionString() {
        if (this.isLetArgument()) {
            return "";
        }
        byte direction = this.getDirection();
        if (direction == 2) {
            return "inout";
        }
        if (direction == 1) {
            return "input";
        }
        if (direction == 3) {
            return "output";
        }
        if (direction == 4) {
            return "ref";
        }
        if (direction == 5) {
            return "const ref";
        }
        return "";
    }

    @Override
    public Image getImage() {
        if (this.isEnumElement()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
        }
        if (this.isNet()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_WIRE);
        }
        if (this.isEvent()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
        }
        if (this.isArgument()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
        }
        if (this.isVariable()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
        }
        if (this.isGenvar()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
        }
        if (this.isTypeParameter()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_PARAM);
        }
        if (this.isLocalParameter()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LOCAL_PARAM);
        }
        if (this.isParameter()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PARAM);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    public SearchMatchKindsWrapper computeEqualsForField(RfTypesResolver thisResolver, Object obj, RfTypesResolver objResolver) {
        TypeCompatibilityMatchKind baseComputeEquals = this.baseComputeEquals(obj);
        if (baseComputeEquals == TypeCompatibilityMatchKind.STRICT_MATCH) {
            return SearchMatchKindsWrapper.getStrictMatch();
        }
        if (obj instanceof RfField && this.equals(obj)) {
            RfField objField = (RfField)obj;
            RfNamedElement enclosingScopeObj = objField.getEnclosingScope();
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (enclosingScopeObj instanceof RfFunction && enclosingScope instanceof RfFunction && this.isArgument() && objField.isArgument()) {
                enclosingScope = enclosingScope.getEnclosingScope();
                enclosingScopeObj = enclosingScopeObj.getEnclosingScope();
            }
            return VlogRfReferencesUtils.getTypeCompatibilityMatchKind(enclosingScopeObj, objResolver, enclosingScope, thisResolver);
        }
        return super.checkEquals(obj) ? SearchMatchKindsWrapper.getStrictMatch() : new SearchMatchKindsWrapper(TypeCompatibilityMatchKind.NO_MATCH);
    }

    private TypeCompatibilityMatchKind baseComputeEquals(Object obj) {
        RfNamedElement fieldScope;
        IRfNamedElement objEnclosing;
        RfNamedElement enclosing;
        if (obj instanceof RfModportPort && (enclosing = this.getEnclosingScope()) == (objEnclosing = ((RfModportPort)obj).getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN)) && this.getName() != null && this.getName().equals(((RfModportPort)obj).getName())) {
            return TypeCompatibilityMatchKind.STRICT_MATCH;
        }
        if (obj instanceof RfCoverpoint && this.getName().equals(((RfCoverpoint)obj).getName()) && this.getName().equals(((RfCoverpoint)obj).getCoverpointExpr())) {
            fieldScope = this.getEnclosingScope();
            RfNamedElement cpointScope = ((RfCoverpoint)obj).getEnclosingScope();
            if (fieldScope != null && cpointScope != null) {
                if (fieldScope == (cpointScope = cpointScope.getEnclosingScope())) {
                    return this.getName().equals(((RfField)obj).getName()) ? TypeCompatibilityMatchKind.STRICT_MATCH : TypeCompatibilityMatchKind.NO_MATCH;
                }
                if (fieldScope instanceof RfClass && cpointScope instanceof RfClass && ((RfClass)cpointScope).isSubClass((RfClass)fieldScope)) {
                    return this.getName().equals(((RfField)obj).getName()) ? TypeCompatibilityMatchKind.STRICT_MATCH : TypeCompatibilityMatchKind.NO_MATCH;
                }
            }
        }
        if (obj instanceof RfField) {
            fieldScope = this.getEnclosingScope();
            RfNamedElement objScope = ((RfField)obj).getEnclosingScope();
            if (fieldScope instanceof RfModport && objScope instanceof RfInterface) {
                if (fieldScope.getEnclosingScope() == objScope && this.getName().equals(((RfField)obj).getName())) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            } else if (fieldScope instanceof RfInterface && objScope instanceof RfModport) {
                if (objScope.getEnclosingScope() == fieldScope && this.getName().equals(((RfField)obj).getName())) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            } else if (fieldScope instanceof RfModport && objScope instanceof RfModport) {
                RfNamedElement interfaceScope = objScope.getEnclosingScope();
                if (interfaceScope == fieldScope.getEnclosingScope() && this.getName().equals(((RfField)obj).getName()) && interfaceScope.getLocalMember(RfField.class, this.getName(), false) != null) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            } else if (this.isEnumRangeGeneratedElement() && ((RfField)obj).isEnumRangeElement()) {
                if (this.getParentDeclarationNamedElement() == obj) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            } else if (this.isEnumRangeElement() && ((RfField)obj).isEnumRangeGeneratedElement()) {
                if (((RfField)obj).getParentDeclarationNamedElement() == this) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            } else if (this.isEnumRangeGeneratedElement() && ((RfField)obj).isEnumRangeGeneratedElement()) {
                RfNamedElement parentDefNamedElement = this.getParentDeclarationNamedElement();
                RfNamedElement objParentDefNamedElement = ((RfField)obj).getParentDeclarationNamedElement();
                if (parentDefNamedElement != null && parentDefNamedElement == objParentDefNamedElement) {
                    return TypeCompatibilityMatchKind.STRICT_MATCH;
                }
            }
        }
        return TypeCompatibilityMatchKind.NO_MATCH;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.computeEqualsForField(RfTypesResolver.create((IRfScopeElement)this.getEnclosingScope(), this.getRfProject(), 8), obj, RfTypesResolver.create((IRfScopeElement)((IRfNamedElement)obj), ((IRfNamedElement)obj).getRfProject(), 8)).isMatch();
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fParameterKind = null;
        this.fIsInParameterPortList = false;
        this.fInitialValue = null;
        this.hasUserDefinedNetType = null;
    }

    @Override
    public int getMemberSelect() {
        if (this.getEnclosingScope() instanceof RfStruct) {
            return 9;
        }
        if (this.isParameter()) {
            return 5;
        }
        if (this.isEnumElement()) {
            return 8;
        }
        return 0;
    }

    @Override
    public String getComment() {
        String result = super.getComment();
        if (this.isArgument() && (result == null || result.isEmpty())) {
            result = "";
            RfNamedElement enclosingScope = this.getEnclosingScope();
            String enclosingScopeComment = enclosingScope != null ? enclosingScope.getComment() : null;
            result = DVTUtilsCommon.INSTANCE.getAtParamComment(this.getName(), enclosingScopeComment);
        }
        return result;
    }

    public IRfFieldElement clone(String cloneName) {
        RfField clone = new RfField(this);
        clone.setName(cloneName, clone.isEscaped());
        clone.setEnclosingScope(this.getEnclosingScope());
        return clone;
    }

    protected void setInitialValue(String initialValue) {
        this.fInitialValue = initialValue;
    }

    public boolean isStorageStatic() {
        if (this.hasStorageStaticQualifier()) {
            return true;
        }
        if (this.hasStorageAutomaticQualifier()) {
            return false;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        if (enclosing instanceof RfClass && this.hasObjectStaticQualifier()) {
            return true;
        }
        if (enclosing instanceof RfClass || enclosing instanceof RfFragment || enclosing instanceof RfStruct) {
            return false;
        }
        if (enclosing instanceof RfActionBlock && ((RfActionBlock)enclosing).isForOrForeach()) {
            return false;
        }
        if (enclosing instanceof RfPropertySequence) {
            return false;
        }
        if (this.isVariable() || this.isArgument()) {
            return RfField.hasImplicitStorageStatic(enclosing);
        }
        return true;
    }

    public boolean isObjectStatic() {
        return this.isAnyParameter() || this.isEnumElement() || this.isEnumRangeElement() || this.isGenvar() || this.isStorageStatic();
    }

    @Override
    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        RfNamedElement enclosingScope;
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return this.isParameter() ? BitVectorContext.ofPackedUpdate((IRfNamedElement)this, (boolean)false, (int)0) : null;
        }
        if (this.isParameterNoDataType()) {
            return BitVectorContext.ofPackedUpdate((IRfNamedElement)this, (boolean)false, (int)dataType.fSign);
        }
        if (this.isTypeParameter()) {
            return new RfAssociatedTypeWrapper(this).getDataTypeBitVectorContext(evaluator, false, hierarchyPath, manager);
        }
        if (this.isArgument() && (enclosingScope = this.getEnclosingScope()) instanceof RfFunction && ((RfFunction)enclosingScope).isLet()) {
            return BitVectorContext.of((IRfNamedElement)this, (boolean)false);
        }
        return super.getDataTypeBitVectorContext(evaluator, false, hierarchyPath, manager);
    }

    public RfNamedElement getParentDeclarationNamedElement() {
        RfDefElement parentDef = ((RfFieldDef)this.getDeclaration()).getParentDef();
        return parentDef != null ? parentDef.getNamedElement() : null;
    }

    public Hid xMakeHid(HidOccurrence occurrence) {
        return RfHid.create(this.getName(), null, this, occurrence, null);
    }

    public HidOperator xMakeInitDeclarationOperator(IHidObject initialValue, HidOperatorOccurrence occurrence) {
        return new RfHidOperator.XInitialDeclarationOperator(this, initialValue, occurrence);
    }

    public HidOperator xGetSupplyOperator(final IELParamValue supplyValue) {
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.from((IRfDefElement)this.getDeclaration());
        RfHidOperator operator = RfHidOperator.create(498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, this.getMacroZone());
        operator.setLHValue((IHidObject)RfHid.create(this.getName(), null, this, (HidOccurrence)occurrence, this.getMacroZone()));
        operator.setRHValues((ListContainer)new HidImplicit(supplyValue.toString(), IHidImplicitConstants.ImplicitType.QUA_NUMBER.id){
            private static final long serialVersionUID = 1L;

            public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
                return ELParamValueScope.of((IELParamValue)supplyValue);
            }

            public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                return ELParamValueScope.of((IELParamValue)supplyValue);
            }
        });
        return operator;
    }

    @Override
    public IRfNamedElement xGetAssociatedType(IHidEvaluator occurenceScope) {
        IRfNamedElement result = super.xGetAssociatedType(occurenceScope);
        if (result != null) {
            return result;
        }
        if (this.isParameterNoDataType()) {
            return RfBitVectorScalarType.LOGIC;
        }
        return null;
    }

    public IRfNamedElement getParentEnumType() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        return enclosingScope instanceof RfStruct ? enclosingScope : null;
    }

    public boolean isMacroDefinedTypeNameField() {
        if (!this.isConst()) {
            return false;
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        String type = dataType.getType();
        if (!"string".equals(type)) {
            return false;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return false;
        }
        return declaration.hasVirtualOffsets();
    }

    public String getLabelForDiagram(ElementPath instancePath, NLPortLabelOptions portLabelOptions) {
        StringBuilder nameForDiagram = new StringBuilder(super.getNameForDiagram());
        if (portLabelOptions == null) {
            return nameForDiagram.toString();
        }
        if (portLabelOptions.hasFlag(NLPortLabelOptions.NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_WIDTH)) {
            IRfNamedElement associatedType = this.getAssociatedType(RfTypesResolver.create(this, instancePath, this.getRfProject().getNonELManager(), 0));
            nameForDiagram.append(this.computePortWidthLabel(associatedType));
        }
        return nameForDiagram.toString();
    }

    private String computePortWidthLabel(IRfNamedElement associatedType) {
        IRfNamedElement iRfNamedElement = associatedType;
        if (iRfNamedElement instanceof IRfTypeAliasElement && (var2_3 = (IRfTypeAliasElement)iRfNamedElement) == (IRfTypeAliasElement)var3_2) {
            associatedType = typeAlias.getTranslatedType();
        }
        if (!(( instanceOfPatternExpressionValue = associatedType) instanceof IRfTypeElement) || (var4_5 = (IRfTypeElement) instanceOfPatternExpressionValue) != (IRfTypeElement) instanceOfPatternExpressionValue) {
            return NA_BITS_SUFFIX;
        }
        if (!(associatedType instanceof RfComputedListType var6_7)) {
            int bitSize = typeElement.getBitSize();
            if (bitSize < 0) {
                return NA_BITS_SUFFIX;
            }
            return COLON + Integer.toString(bitSize) + (bitSize == 1 ? BIT_SUFFIX : BITS_SUFFIX);
        }
        String bitSizeLabelSuffix = NA_BITS_SUFFIX;
        int bitSize = computedList.getBitSize();
        if (bitSize < 0) {
            return NA_BITS_SUFFIX;
        }
        int unpackedSize = computedList.getUnpackedSize();
        int packedBitSize = bitSize / unpackedSize;
        boolean hasUnpackedDimension = computedList.getNofUnpackedDimensions() > 0 || unpackedSize > 1;
        boolean bl = hasPackedDimension = computedList.getNofPackedDimensions() > 0 || packedBitSize > 1;
        bitSizeLabelSuffix = hasUnpackedDimension && hasPackedDimension ? COLON + unpackedSize + MULTIPLICATION_SIGN + packedBitSize + BITS_SUFFIX : (hasUnpackedDimension ? COLON + unpackedSize + (unpackedSize == 1 ? BIT_SUFFIX : BITS_SUFFIX) : COLON + packedBitSize + (packedBitSize == 1 ? BIT_SUFFIX : BITS_SUFFIX));
        return bitSizeLabelSuffix;
    }

    public String getQualifiedNameForDiagram(ElementPath instancePath) {
        IRfNamedElement associatedType = this.getAssociatedType(RfTypesResolver.create(this, instancePath, this.getRfProject().getNonELManager(), 0));
        if (associatedType == null) {
            return null;
        }
        return associatedType.getQualifiedName((IRfScopeElement)this.getEnclosingScope(), instancePath, 7);
    }

    public void setHidden(boolean value) {
        this.isHidden = value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public static enum ParameterKind {
        PARAMETER,
        DYNAMICPARAM,
        LOCALPARAM,
        SPECPARAM,
        ALIASPARAM;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum TypeCompatibilityMatchKind {
        NO_MATCH,
        NON_TYPE_COMPATIBLE_MATCH,
        STRICT_MATCH;

    }
}

