/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.OptimizedHashMap;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class RfFieldDef
extends RfDefElement {
    private static final long serialVersionUID = 1L;
    private boolean fHasType;
    private boolean fHasDirection;
    private RfDefElement fParentDef;
    private boolean fIsImplicit;
    private transient Map<IRfNamedElement, DataType> fDataType = new OptimizedHashMap();

    public RfFieldDef(RfFileDef file, WrapperInfo info, boolean isImplicit) {
        super(file, info);
        this.fIsImplicit = isImplicit;
    }

    public RfFieldDef(RfFileDef file, String name, LineInfo startInfo, LineInfo endInfo, CommentBlock comment, ReparseInfo reparseInfo) {
        super(file, name, startInfo, endInfo, comment, reparseInfo);
    }

    public void addDataType(IRfNamedElement namedElement, DataType dataType) {
        if (this.fDataType == null) {
            this.fDataType = new OptimizedHashMap();
        }
        if (dataType != null && this.fDataType.isEmpty()) {
            this.fHasType = dataType.getType() != null;
            this.fHasDirection = dataType.getRawDirection() != 0;
        }
        this.fDataType.put(namedElement, dataType);
    }

    public void updateDataType(Map<IRfNamedElement, DataType> updater) {
        this.fDataType = new OptimizedHashMap();
        if (updater != null) {
            this.fDataType.putAll(updater);
        }
    }

    public void putAllDataTypes(Map<IRfNamedElement, DataType> dataType) {
        if (this.fDataType == null) {
            this.fDataType = new OptimizedHashMap();
        }
        if (dataType != null) {
            this.fDataType.putAll(dataType);
        }
    }

    public String getInfo() {
        return this.getName();
    }

    public boolean isImplicit() {
        return this.fIsImplicit;
    }

    public boolean hasDirection() {
        return this.fHasDirection;
    }

    public boolean hasType() {
        return this.fHasType;
    }

    @Override
    public DataType getDataType(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        if (this.fDataType == null || this.fDataType.isEmpty()) {
            return super.getDataType(namedElement);
        }
        if (namedElement instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getOccurrence();
        }
        return this.fDataType.get(namedElement);
    }

    @Override
    public DataType getRawDataType(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        if (this.fDataType == null || this.fDataType.isEmpty()) {
            return super.getRawDataType(namedElement);
        }
        if (namedElement instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getOccurrence();
        }
        return this.fDataType.get(namedElement);
    }

    public Map<IRfNamedElement, DataType> getAllDataTypes() {
        return this.fDataType;
    }

    public boolean allowDataTypeSplit() {
        RfNamedElement function;
        if (this.fDataType == null || this.fDataType.isEmpty()) {
            return false;
        }
        if (this.fParentDef instanceof RfFunctionDef && (function = this.fParentDef.getNamedElement()).isExtern()) {
            return ((RfFunctionDef)this.fParentDef).isPrototype();
        }
        return true;
    }

    public RfDefElement getParentDef() {
        return this.fParentDef;
    }

    public void setParentDef(RfDefElement parentDef) {
        this.fParentDef = parentDef;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        if (this.fDataType == null) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (!(persistence instanceof Persistence)) {
            return;
        }
        if (((PersistenceOutputStream)out).getPersistenceModeWrapper().persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
            ((Persistence)persistence).fieldDefWritten(this, this.fDataType);
            return;
        }
        String precompiledLibName = ((PersistenceOutputStream)out).getPersistenceModeWrapper().libraryName;
        if (precompiledLibName == null) {
            ((Persistence)persistence).fieldDefWritten(this, this.fDataType);
            return;
        }
        HashMap<IRfNamedElement, DataType> toWriteDataType = new HashMap<IRfNamedElement, DataType>();
        for (Map.Entry<IRfNamedElement, DataType> namedElementDataType : this.fDataType.entrySet()) {
            IRfLibraryElement enclosingLibrary = namedElementDataType.getKey().getEnclosingLibrary();
            if (enclosingLibrary == null || !precompiledLibName.equals(enclosingLibrary.getName())) continue;
            toWriteDataType.put(namedElementDataType.getKey(), namedElementDataType.getValue());
        }
        ((Persistence)persistence).fieldDefWritten(this, toWriteDataType);
    }

    @Override
    public void removeNamedElement(RfNamedElement namedElem) {
        super.removeNamedElement(namedElem);
        this.fDataType.remove(namedElem);
    }
}

