/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.CharBufferCacher;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.TimeConsumingStatement;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.utils.CAFieldAndScope;
import ro.amiq.vlogdt.utils.CAMatchingArgumentComparator;
import ro.amiq.vlogdt.utils.Utils;

public class RfFunction
extends RfAssociatedType
implements IRfMethodElement,
Cloneable {
    private static final long serialVersionUID = 3L;
    public static final byte FUNCTION = 0;
    public static final byte TASK = 1;
    public static final byte CONSTRUCTOR = 2;
    public static final byte LET = 3;
    public static final byte PRODUCTION = 4;
    public static final byte CALLBACK = 5;
    public static final byte NO_DPI = 0;
    public static final byte DPI_C = 1;
    public static final byte DPI = 2;
    public static final byte IMPORT = 4;
    public static final byte EXPORT = 8;
    public static final String OPTIONAL_ARG_VALUE = "[optional]";
    public static final String HIERARCHY_SEPARATOR = "::";
    public static final Set<String> ASSERT_CONTROL_SYSTEM_TASKS = new HashSet<String>();
    public static final Set<String> HIERARCHICAL_IDENTIFIER_ARGUMENT_SYSTEM_TASKS;
    public static final Set<String> DPI_FUNCTION_ALLOWED_RETURN_TYPES;
    public static final String WAIT_FOR_NBA_SYSTEM_FUNCTION_NAME = "$dvt_wait_for_nba";
    private byte fKind;
    private byte fDPIKind;
    private RfNamedElement.ImportsExports fImportsExports;
    private DVTLinkedHashMap<String, RfNamedElement> fMembers;
    private String fCIdentifier;
    private RfNamedElement.NamesCache fNamesCache;
    private transient RfHidHolder fHidHolder;
    private transient RfNamedElement.LinterSpecific1 fLinterSpecific1;
    private transient LinterSpecific2 fLinterSpecific2;
    private MethodSignatureUseCase fSignatureUseCase = MethodSignatureUseCase.DEFAULT;

    static {
        ASSERT_CONTROL_SYSTEM_TASKS.add("$asserton");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertkill");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertpasson");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertfailon");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertnonvacuouson");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertoff");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertcontrol");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertpassoff");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertfailoff");
        ASSERT_CONTROL_SYSTEM_TASKS.add("$assertvacuousoff");
        HIERARCHICAL_IDENTIFIER_ARGUMENT_SYSTEM_TASKS = new HashSet<String>();
        HIERARCHICAL_IDENTIFIER_ARGUMENT_SYSTEM_TASKS.add("$dumpvars");
        HIERARCHICAL_IDENTIFIER_ARGUMENT_SYSTEM_TASKS.add("$dumpports");
        HIERARCHICAL_IDENTIFIER_ARGUMENT_SYSTEM_TASKS.add("$printtimescale");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES = new HashSet<String>();
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("void");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("byte");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("shortint");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("int");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("longint");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("real");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("shortreal");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("chandle");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("string");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("bit");
        DPI_FUNCTION_ALLOWED_RETURN_TYPES.add("logic");
    }

    public MethodSignatureUseCase getSignatureUseCase() {
        return this.fSignatureUseCase;
    }

    public void setSignatureUseCase(MethodSignatureUseCase dSignatureUseCase) {
        this.fSignatureUseCase = dSignatureUseCase;
    }

    public RfFunction(String name, boolean escaped, DataType type, MacroCallInfo macroCallInfo, int kind, int qualifiers, List<TimeConsumingStatement> timeConsumingStatements, String cIdentifier) {
        super(name, escaped, type);
        this.fKind = (byte)kind;
        this.fCIdentifier = cIdentifier;
        this.setQualifiers(qualifiers);
        if (macroCallInfo != null || timeConsumingStatements != null || cIdentifier != null) {
            this.fLinterSpecific2 = new LinterSpecific2();
            this.fLinterSpecific2.fMacroCallInfo = macroCallInfo;
            this.fLinterSpecific2.fTimeConsumingStatements = timeConsumingStatements;
        }
        this.initResultImplicitVariable();
    }

    public void init(DataType type, MacroCallInfo macroCallInfo, int kind, int qualifiers, List<TimeConsumingStatement> timeConsumingStatements, String cIdentifier) {
        super.init(type);
        this.fKind = (byte)kind;
        this.fCIdentifier = cIdentifier != null ? cIdentifier : this.fCIdentifier;
        this.setQualifiers(qualifiers);
        if (macroCallInfo != null || timeConsumingStatements != null || cIdentifier != null) {
            if (this.fLinterSpecific2 == null) {
                this.fLinterSpecific2 = new LinterSpecific2();
            }
            this.fLinterSpecific2.fMacroCallInfo = macroCallInfo;
            this.fLinterSpecific2.fTimeConsumingStatements = timeConsumingStatements;
        }
        this.initResultImplicitVariable();
    }

    protected void initResultImplicitVariable() {
        if (this.getName() == null || this.isVoid() || this.isConstructor() || this.isLet()) {
            return;
        }
        RfResultImplicitVariable existing = this.getLocalMember(RfResultImplicitVariable.class, this.getName(), true);
        if (existing != null) {
            this.removeMember(existing);
        }
        RfResultImplicitVariable implicitVariable = new RfResultImplicitVariable(this);
        this.addMember(implicitVariable);
    }

    @Override
    protected int internalMaxDefSizePerElement() {
        return 6;
    }

    @Override
    public synchronized void internalSetTransientAssociatedType(IRfNamedElement associatedType) {
        super.internalSetTransientAssociatedType(associatedType);
        RfResultImplicitVariable resultImplicitVariable = this.getLocalMember(RfResultImplicitVariable.class, this.getName(), true);
        if (resultImplicitVariable != null) {
            resultImplicitVariable.internalSetTransientAssociatedType(associatedType);
        }
    }

    @Override
    public RfDefElement addDeclaration(RfDefElement element) {
        if (!(element instanceof RfFunctionDef)) {
            return super.addDeclaration(element);
        }
        if (this.fDefs != null && this.fDefs.size() >= this.internalMaxDefSizePerElement()) {
            return (RfDefElement)this.fDefs.get(0);
        }
        element.addNamedElement(this);
        this.fDefs = this.fDefs == null ? element : (((RfFunctionDef)element).isPrototype() && !((RfFunctionDef)this.fDefs.get(0)).isPrototype() ? OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (int)0, (Object)element) : OptimizedUtils.listContainerAdd((ListContainer)this.fDefs, (Object)element));
        this.fDPIKind = (this.fDPIKind & 4) != 0 ? ((RfFunctionDef)element).getDPIKind() : (byte)(this.fDPIKind | ((RfFunctionDef)element).getDPIKind());
        return element;
    }

    @Override
    public boolean hasLocalMembers() {
        return super.hasLocalMembers() || !this.isVoid();
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        RfNamedElement parentClass;
        super.removeDef(incrementalDeltaContainer, def);
        if (this.hasNoDefs(false) && (parentClass = this.getEnclosingScope()) instanceof RfClass) {
            Set<String> virtualFuncNames;
            if (this.isPure()) {
                Set<String> pureFuncNames = parentClass.getPureFuncNames();
                if (pureFuncNames != null) {
                    pureFuncNames.remove(this.getName());
                }
            } else if (this.hasVirtualQualifier() && (virtualFuncNames = parentClass.getVirtualFuncNames()) != null) {
                virtualFuncNames.remove(this.getName());
            }
        }
        if (def instanceof RfFunctionDef) {
            this.fDPIKind = (byte)(this.fDPIKind & ~((RfFunctionDef)def).getDPIKind());
        }
    }

    @Override
    public void setQualifiers(int qualifiers) {
        super.setQualifiers(qualifiers);
        RfClass clazz = this.getEnclosingScope(RfClass.class);
        if (clazz == null) {
            return;
        }
        Set<String> pureFuncNames = clazz.getPureFuncNames();
        Set<String> virtualFuncNames = clazz.getVirtualFuncNames();
        if (this.isPure()) {
            if (pureFuncNames == null) {
                clazz.setPureFuncNames(new HashSet<String>(Arrays.asList(this.getName())));
            } else if (!pureFuncNames.contains(this.getName())) {
                pureFuncNames.add(this.getName());
            }
        } else if (this.hasVirtualQualifier()) {
            if (virtualFuncNames == null) {
                clazz.setVirtualFuncNames(new HashSet<String>(Arrays.asList(this.getName())));
            } else if (!virtualFuncNames.contains(this.getName())) {
                virtualFuncNames.add(this.getName());
            }
        } else {
            if (pureFuncNames != null && pureFuncNames.contains(this.getName())) {
                pureFuncNames.remove(this.getName());
            }
            if (virtualFuncNames != null && virtualFuncNames.contains(this.getName())) {
                virtualFuncNames.remove(this.getName());
            }
        }
    }

    @Override
    public RfNamedElement semanticGetActionBlockOrField(String name) {
        RfNamedElement candidate;
        RfNamedElement genericElement = this;
        if (this.isMemberOfSpecializedElement() && (candidate = this.getElementInGenericScope()) instanceof RfFunction) {
            genericElement = candidate;
        }
        return RfNamedElement.semanticGetActionBlockOrField(genericElement, name);
    }

    @Override
    public String getAssociatedTypeName(IRfScopeElement scope, RfTypesResolver typesResolver, int qualifiedNameOptions, boolean useDataType, boolean keepMacros, boolean noDimensionsForArrayOfInstances) {
        try {
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (this.isConstructor() && enclosingScope instanceof RfCovergroup) {
                String string = enclosingScope.getName();
                return string;
            }
            if (this.isTask()) {
                return "";
            }
            String string = super.getAssociatedTypeName(scope, typesResolver, qualifiedNameOptions, useDataType, keepMacros, noDimensionsForArrayOfInstances);
            return string;
        }
        finally {
            if (keepMacros) {
                CharBufferCacher.getInstance().clearCache();
            }
        }
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.action";
    }

    @Override
    public final String getSignature(RfTypesResolver resolver) {
        return this.getSignature(resolver, true);
    }

    public String getSignature(RfTypesResolver resolver, boolean addExtraFlags) {
        String storage;
        String virtual;
        RfNamedElement enclosingScope = this.getEnclosingScope();
        String extern = this.isExtern() ? "extern " : "";
        String string = virtual = this.isVirtual() ? "virtual" : "non-virtual";
        String accessKind = this.isPrivate() ? "private" : (this.isProtected() ? "protected" : "public");
        String string2 = storage = RfFunction.hasImplicitStorageStatic(this) ? "static storage" : "automatic storage";
        String staticAutomatic = enclosingScope instanceof RfClass ? (this.hasObjectStaticQualifier() ? "static" : "automatic") : (this.hasObjectAutomaticQualifier() ? "automatic" : "static");
        String arguments = this.printArguments(resolver, true, null, false, true, this.getSignatureUseCase(), false);
        String result = null;
        String extraFlags = null;
        switch (this.fKind) {
            case 0: {
                extraFlags = this.getExtraFlagsInfo(enclosingScope, accessKind, virtual, staticAutomatic, storage);
                int qualifiedNameOptions = 771;
                result = String.valueOf(extern) + (this.isVirtual() ? "virtual " : "") + "function " + this.getAssociatedTypeName(this.getEnclosingScope(), resolver, qualifiedNameOptions, false, false, false) + " " + this.printScope() + this.getName() + "\n" + "(" + arguments + ")";
                break;
            }
            case 1: {
                extraFlags = this.getExtraFlagsInfo(enclosingScope, accessKind, virtual, staticAutomatic, storage);
                result = String.valueOf(extern) + (this.isVirtual() ? "virtual " : "") + "task " + this.printScope() + this.getName() + "\n" + "(" + arguments + ")";
                break;
            }
            case 2: {
                extraFlags = this.getExtraFlagsInfo(enclosingScope, accessKind, virtual, staticAutomatic, storage);
                result = "constructor " + this.printScope() + this.getName() + "\n" + "(" + arguments + ")";
                break;
            }
            case 3: {
                result = "let " + this.printScope() + this.getName() + "\n" + "(" + arguments + ")";
                break;
            }
            case 4: {
                result = "production " + this.printScope() + this.getName() + "\n" + "(" + arguments + ")";
                break;
            }
        }
        if (addExtraFlags && result != null && extraFlags != null) {
            result = String.valueOf(result) + extraFlags;
        }
        this.setSignatureUseCase(MethodSignatureUseCase.DEFAULT);
        return result;
    }

    public List<IRfFieldElement> getArguments() {
        if (this.fMembers == null) {
            return Collections.emptyList();
        }
        ArrayList<IRfFieldElement> arguments = new ArrayList<IRfFieldElement>();
        for (RfNamedElement member : this.fMembers) {
            if (!(member instanceof IRfFieldElement) || !((IRfFieldElement)member).isArgument()) continue;
            arguments.add((IRfFieldElement)member);
        }
        return arguments;
    }

    private String getExtraFlagsInfo(RfNamedElement enclosingScope, String accessKind, String virtual, String staticAutomatic, String storage) {
        if (enclosingScope instanceof RfClass) {
            return "\n[" + accessKind + ", " + virtual + ", " + staticAutomatic + ", " + storage + "]";
        }
        return "\n[" + storage + "]";
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return this.isConstructor();
    }

    @Override
    public boolean isVirtual() {
        if (this.hasVirtualQualifier()) {
            return true;
        }
        return this.isParentVirtual();
    }

    public boolean isParentVirtual() {
        return this.getParentVirtual(false) != null;
    }

    public RfFunction getParentVirtual(boolean rootVirtualFunction) {
        if (this.isConstructor()) {
            return null;
        }
        String functionName = this.getName();
        RfNamedElement parentClass = this.getEnclosingScope();
        RfFunction result = null;
        RfNamedElement currentClass = parentClass;
        while (currentClass != null && currentClass instanceof RfClass) {
            RfFunction candidate;
            RfClass parent = ((RfClass)currentClass).getParent();
            if (parent != null && (candidate = parent.getLocalMember(RfFunction.class, functionName, true)) != null && candidate.hasVirtualQualifier()) {
                result = candidate;
                if (!rootVirtualFunction) {
                    return result;
                }
            }
            currentClass = parent;
        }
        while (parentClass != null && parentClass instanceof RfClass) {
            List<RfClass> implementedClasses = ((RfClass)parentClass).getParentInterfaces();
            if (implementedClasses != null) {
                for (RfClass implementedClass : implementedClasses) {
                    RfFunction candidate = implementedClass.getLocalMember(RfFunction.class, functionName, true);
                    if (candidate == null || !candidate.hasVirtualQualifier()) continue;
                    result = candidate;
                    if (rootVirtualFunction) continue;
                    return result;
                }
            }
            parentClass = ((RfClass)parentClass).getParent();
        }
        return result;
    }

    @Override
    public CommentBlock getCommentBlock() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            RfDefElement implementation = this.getImplementation();
            if (implementation == null || implementation == declaration) {
                return declaration.getCommentBlock();
            }
            CommentBlock comment1 = declaration.getCommentBlock();
            CommentBlock comment2 = implementation.getCommentBlock();
            if (comment1 == null) {
                return comment2;
            }
            if (comment2 == null) {
                return comment1;
            }
            String inlineComment = this.concatenateCommentStrings(comment1.getInlineComment(), comment2.getInlineComment());
            String aboveComment = this.concatenateCommentStrings(comment1.getAboveComment(), comment2.getAboveComment());
            return new CommentBlock(inlineComment, aboveComment, comment1.getAboveCommentStartLine(), comment1.isProtected() | comment2.isProtected());
        }
        return null;
    }

    public CommentBlock getRawCommentBlock() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            RfDefElement implementation = this.getImplementation();
            if (implementation == null || implementation == declaration) {
                return declaration.getCommentBlock();
            }
            CommentBlock comment1 = declaration.getCommentBlock();
            CommentBlock comment2 = implementation.getCommentBlock();
            if (comment1 == null) {
                return comment2;
            }
            if (comment2 == null) {
                return comment1;
            }
            String inlineComment = this.concatenateCommentStringsForTooltip(comment1.getRawUntrimmedInlineComment(), comment2.getRawUntrimmedInlineComment(), "\n\n");
            String aboveComment = this.concatenateCommentStringsForTooltip(comment1.getRawUntrimmedAboveComment(), comment2.getRawUntrimmedAboveComment(), "\n\n");
            return new CommentBlock(inlineComment, aboveComment, comment1.getAboveCommentStartLine(), comment1.isProtected() | comment2.isProtected());
        }
        return null;
    }

    @Override
    public String getComment() {
        CommentBlock comment = this.getCommentBlock();
        if (comment != null) {
            return comment.toString();
        }
        return "";
    }

    @Override
    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        CommentBlock declarationCommentBlock = this.getRawCommentBlock();
        if (declarationCommentBlock == null) {
            return "";
        }
        return declarationCommentBlock.toRawUntrimmedString(inlineAboveDelimiter);
    }

    private String concatenateCommentStrings(String comment1, String comment2) {
        if (comment2 == null || comment2.isEmpty()) {
            return comment1;
        }
        if (comment1 == null || comment1.isEmpty()) {
            return String.valueOf(Character.toUpperCase(comment2.charAt(0))) + comment2.substring(1);
        }
        return String.valueOf(comment1) + (comment1.endsWith(".") ? " " : ". ") + Character.toUpperCase(comment2.charAt(0)) + comment2.substring(1);
    }

    private String concatenateCommentStringsForTooltip(String comment1, String comment2, String delimiter) {
        if (comment2 == null || comment2.isEmpty()) {
            return comment1;
        }
        if (comment1 == null || comment1.isEmpty()) {
            return String.valueOf(Character.toUpperCase(comment2.charAt(0))) + comment2.substring(1);
        }
        return String.valueOf(comment1) + (comment1.isEmpty() ? "" : delimiter) + comment2;
    }

    @Override
    public RfDefElement getImplementation() {
        if (this.isExtern() || this.isExportDPI()) {
            Collection allDefs = this.getDeclarations();
            if (allDefs == null || allDefs.size() < 2) {
                return null;
            }
            Iterator iterator = allDefs.iterator();
            iterator.next();
            return (RfDefElement)iterator.next();
        }
        return this.getDeclaration();
    }

    public boolean hasImplementation() {
        if (this.isExportDPI()) {
            Collection declarations = this.getDeclarations();
            return declarations != null && declarations.size() > 1;
        }
        return this.getImplementation() != null;
    }

    public RfDefElement getPrototype() {
        if (this.isExtern()) {
            Collection allDefs = this.getDeclarations();
            if (allDefs == null || allDefs.isEmpty()) {
                return null;
            }
            for (RfDefElement declaration : allDefs) {
                if (!(declaration instanceof RfFunctionDef) || !((RfFunctionDef)declaration).isPrototype()) continue;
                return declaration;
            }
        }
        return null;
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
        if (this.isExtern()) {
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (enclosingLibrary == null) {
                return;
            }
            RfNamedElement enclosingScope = this;
            while ((enclosingScope = enclosingScope.getEnclosingScope()) instanceof RfClass) {
                String name = enclosingScope.getName();
                if (name == null) continue;
                enclosingLibrary.addReference(name, (IRfNamedElement)this);
                this.addReferenceToIdentifierName(name);
            }
        }
        if (this.isConstructor()) {
            return;
        }
        super.checkAssociatedType(configInfo, element, translateTypeAlias, ignoreDirty, triggerError);
    }

    @Override
    protected void checkAssociatedTypeMember(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, RfNamedElement member) throws BuildCancelException {
        if (triggerError && this.isFunction()) {
            boolean isTimeConsuming = false;
            if (member instanceof RfActionBlock) {
                isTimeConsuming = ((RfActionBlock)member).isForkJoin() || ((RfActionBlock)member).isForkJoinAny();
            } else if (member instanceof RfAssertExpect) {
                isTimeConsuming = ((RfAssertExpect)member).isExpect();
            } else if (member instanceof RfWait) {
                isTimeConsuming = true;
            }
            RfDefElement memberDecl = member.getDeclaration();
            if (isTimeConsuming && memberDecl != null) {
                RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
                rfProject.addSemanticError(1, "ILLEGAL_FUNCTION_TIME_CONSUMING_ACTION: Time consuming statement cannot be used in functions", member.getLibPkgScope(), memberDecl.getStartOffset(), memberDecl.getEndOffset(), null, memberDecl.getStartLine(), memberDecl.getParserPath(), null, null);
            }
        }
        super.checkAssociatedTypeMember(configInfo, triggerError, ignoreDirty, member);
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        RfFunction parentVirtual;
        super.resolveHids(configInfo, triggerError, ignoreDirty, semanticEnabled, skipMemberClasses);
        LibraryPackageScope libraryPackageScope = this.getLibPkgScope();
        this.checkCheckerInstances(configInfo, libraryPackageScope);
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return;
        }
        RfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return;
        }
        ParserPath parserPath = defFile.getParserPath();
        final RfProject project = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        if (triggerError && !this.hasVirtualQualifier() && (parentVirtual = this.getParentVirtual(false)) != null) {
            RfClass enclosingClass;
            RfNamedElement functionScope;
            if (this.hasObjectStaticQualifier()) {
                project.addSemanticError(1, "INVALID_STATIC_OVERRIDE: Virtual method ''{0}'' cannot be overridden by static method", libraryPackageScope, this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, declaration.getStartLine(), parserPath, this.getName());
            }
            if (!this.isPure() && parentVirtual.isPure() && (functionScope = parentVirtual.getEnclosingScope()) instanceof RfClass && (enclosingClass = (RfClass)functionScope).isInterfaceClass()) {
                project.addSemanticError(1, "OVERRIDE_VIRTUAL_METHOD: Implementation of interface class method ''{0}'' must have ''virtual'' qualifier", libraryPackageScope, this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, declaration.getStartLine(), parserPath, this.getName());
            }
        }
        if (triggerError && (this.isImportDPI() || this.isExportDPI())) {
            IRfNamedElement resolvedType = this.getResolvedType(true);
            if (resolvedType instanceof RfTypeAlias) {
                resolvedType = ((RfTypeAlias)resolvedType).getTranslatedType();
            }
            boolean isDPICAllowedReturnType = this.isDPICAllowedReturnType(resolvedType);
            if (resolvedType != null && !isDPICAllowedReturnType) {
                String assocTypeName = resolvedType instanceof RfField && ((RfField)resolvedType).isTypeParameter() ? resolvedType.getName() : this.getAssociatedTypeName();
                project.addSemanticError(2, "DPI_FUNCTION_RETURN_TYPE: Return type ''{0}'' of DPI function ''{1}'' not allowed", libraryPackageScope, this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, declaration.getStartLine(), parserPath, assocTypeName, this.getName());
            }
        }
        if (triggerError && this.isFunction()) {
            this.visitHidObject(null, new IHidVisitor<IHidObject>(){
                ParserPath parserPath;
                int forkJoinNoneScopeCount;

                public void setParserPath(ParserPath parserPath) {
                    this.parserPath = parserPath;
                }

                public void setScope(IRfNamedElement scope) {
                    this.forkJoinNoneScopeCount += scope instanceof RfActionBlock && ((RfActionBlock)scope).isForkJoinNone() ? 1 : 0;
                }

                public void endScope(IRfNamedElement scope) {
                    this.forkJoinNoneScopeCount -= this.forkJoinNoneScopeCount > 0 && scope instanceof RfActionBlock && ((RfActionBlock)scope).isForkJoinNone() ? 1 : 0;
                }

                public boolean visit(IHidObject hidObject) {
                    HidOccurrence occurrence;
                    RfHidAccessArgs access;
                    IRfNamedElement target;
                    if (this.forkJoinNoneScopeCount > 0) {
                        return false;
                    }
                    if (hidObject instanceof RfHidOperator) {
                        HidOperatorOccurrence occurrence2;
                        RfHidOperator operator = (RfHidOperator)hidObject;
                        if ((operator.isPound() || operator.isPoundPound() || operator.isEventControl()) && !operator.hasQualifier(HidQualifierCache.IS_CONTROLLED_NON_BLOCKING_ASSIGN_QUALIFIER) && (occurrence2 = operator.getOccurrence()) != null) {
                            int line = HidUtils.getLine((HidOccurrence)occurrence2);
                            int offsetStart = HidUtils.getStartOffset((HidOccurrence)occurrence2);
                            int offsetEnd = HidUtils.getEndOffset((IHidObject)operator, (int)offsetStart, (HidOccurrence)occurrence2);
                            project.addSemanticError(1, "ILLEGAL_FUNCTION_TIME_CONSUMING_ACTION: Time consuming statement cannot be used in functions", RfFunction.this.getLibPkgScope(), offsetStart, offsetEnd, null, line, this.parserPath, null, null);
                        }
                    } else if (hidObject instanceof RfHidAccessArgs && (target = (access = (RfHidAccessArgs)hidObject).getParentHid().getElement()) instanceof RfFunction && ((RfFunction)target).isTask() && !((RfFunction)target).isPredefined() && !target.getName().startsWith("$") && (occurrence = access.getOccurrence()) != null) {
                        int line = HidUtils.getLine((HidOccurrence)occurrence);
                        int offsetStart = HidUtils.getStartOffset((HidOccurrence)occurrence);
                        int offsetEnd = HidUtils.getEndOffset((IHidObject)access, (int)offsetStart, (HidOccurrence)occurrence);
                        project.addSemanticError(1, "ILLEGAL_FUNCTION_TIME_CONSUMING_ACTION: Time consuming statement cannot be used in functions", RfFunction.this.getLibPkgScope(), offsetStart, offsetEnd, null, line, this.parserPath, null, null);
                    }
                    return true;
                }

                public Class<IHidObject> getType() {
                    return IHidObject.class;
                }
            });
        }
    }

    @Override
    protected void resolveHidOperators(ConfigInfo configInfo, boolean triggerError, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        if (configInfo != null && RfXvmFactory.isXVMFieldAutomationFunction(this)) {
            configInfo.setIsInXVMFieldAutomation(true);
        }
        try {
            super.resolveHidOperators(configInfo, triggerError, semanticEnabled, skipMemberClasses);
        }
        finally {
            if (configInfo != null) {
                configInfo.setIsInXVMFieldAutomation(false);
            }
        }
    }

    private boolean isDPICAllowedReturnType(IRfNamedElement resolvedType) {
        if (resolvedType instanceof RfStruct && ((RfStruct)resolvedType).isEnum()) {
            return true;
        }
        if (!(resolvedType instanceof RfPredefinedScalarType)) {
            return false;
        }
        if (resolvedType instanceof RfBitVectorScalarType) {
            resolvedType = ((RfBitVectorScalarType)resolvedType).getScalarWithDefaultSign();
        }
        return DPI_FUNCTION_ALLOWED_RETURN_TYPES.contains(resolvedType.getName());
    }

    public byte getFunctionKind() {
        return this.fKind;
    }

    public void setFunctionKind(byte kind) {
        this.fKind = kind;
    }

    public boolean isFunction() {
        return this.fKind == 0;
    }

    public boolean isConstructor() {
        return this.fKind == 2;
    }

    public boolean isTask() {
        return this.fKind == 1;
    }

    public boolean isLet() {
        return this.fKind == 3;
    }

    public boolean isProduction() {
        return this.fKind == 4;
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        if (this.isTask() || this.isLet()) {
            return null;
        }
        if (this.isConstructor()) {
            RfNamedElement enclosingScope = this.getEnclosingScope();
            RfNamedElement specializedEnclosingScope = enclosingScope instanceof IRfListType ? enclosingScope : typesResolver.getSpecializedElementScope(enclosingScope);
            typesResolver.update(specializedEnclosingScope, this, false, false);
            return specializedEnclosingScope;
        }
        return super.getAssociatedType(typesResolver);
    }

    @Override
    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        if (this.isTask()) {
            return null;
        }
        if (this.isLet()) {
            return BitVectorContext.of((IRfNamedElement)this, (boolean)true);
        }
        return super.getDataTypeBitVectorContext(evaluator, returnTypeParameterDefault, hierarchyPath, manager);
    }

    public String printArgument(RfField arg, IRfNamedElement cursorScope, RfTypesResolver resolver, boolean hasType, boolean asTemplateVariable, boolean keepInitialValue, boolean keepMacros, boolean qualifyType, boolean useDataType) {
        boolean hasInitialValue = hasType && keepInitialValue && arg.getInitialValue(false) != null;
        boolean hasDirectionString = hasType && !this.isLet() && !arg.hasImplicitDirection();
        boolean isOptional = hasInitialValue && OPTIONAL_ARG_VALUE.equals(arg.getInitialValue(false));
        StringBuilder result = new StringBuilder();
        String[] assocTypeName = RfListType.splitUnpackedDimesnions(RfFunction.getTemplateQuotedName(asTemplateVariable, useDataType ? arg.getDataType().getTypeNameWithParamAssignments(arg.getFile().getParserPath(), true, true) : arg.getAssociatedTypeName((IRfScopeElement)cursorScope, resolver, (qualifyType ? 1 : 0) | 0x20, false, keepMacros, false)));
        if (hasDirectionString) {
            result.append(arg.getDirectionString()).append(' ');
        }
        if (!(!hasType || assocTypeName[0].isEmpty() || this.isLet() && RfPredefinedScalarType.UNTYPED.getName().equals(assocTypeName[0]))) {
            IRfNamedElement associatedType;
            String prefix = "";
            if (useDataType && (associatedType = arg.getAssociatedType(8)) instanceof RfField && ((RfField)associatedType).isTypeParameter() && !this.getEnclosingScope().equals(cursorScope)) {
                prefix = String.valueOf(this.getEnclosingScope().getName()) + HIERARCHY_SEPARATOR;
            }
            result.append(prefix).append(assocTypeName[0]).append(' ');
        }
        if (asTemplateVariable) {
            result.append("${" + RfFunction.getEscName(arg) + "}");
        } else {
            result.append(RfFunction.getEscName(arg)).append(hasType ? assocTypeName[1] : "");
        }
        if (isOptional) {
            return "[" + result.toString() + "]";
        }
        result.append(hasInitialValue ? " = " + arg.getInitialValue(false) : "");
        return result.toString();
    }

    private Set<CAFieldAndScope> getScopeArgsVarsAndFields(IRfScope funcCallScope, int cursorOffset) {
        List<RfField> arguments;
        RfNamedElement funcScope;
        if (funcCallScope == null) {
            return Collections.emptySet();
        }
        HashSet<CAFieldAndScope> scopeArgsVarsAndFields = new HashSet<CAFieldAndScope>();
        List<RfField> localVariables = funcCallScope.getVarsWithPrefix(cursorOffset, "", 2);
        if (localVariables != null && !localVariables.isEmpty()) {
            for (RfField localVariable : localVariables) {
                scopeArgsVarsAndFields.add(new CAFieldAndScope(localVariable, CAFieldAndScope.ScopeKind.VARIABLE));
            }
        }
        RfNamedElement rfNamedElement = funcScope = funcCallScope instanceof RfDefElement ? ((RfDefElement)funcCallScope).getNamedElement() : null;
        if ((funcScope instanceof RfFunction || funcScope instanceof RfActionBlock) && (arguments = funcCallScope.getArgumentsWithPrefix("", 2)) != null && !arguments.isEmpty()) {
            for (RfField argument : arguments) {
                scopeArgsVarsAndFields.add(new CAFieldAndScope(argument, CAFieldAndScope.ScopeKind.ARGUMENT));
            }
        }
        IRfScopeElement enclosingFuncCallScope = funcCallScope.getEnclosingScope();
        while (enclosingFuncCallScope instanceof RfActionBlock || enclosingFuncCallScope instanceof RfFunction) {
            enclosingFuncCallScope = enclosingFuncCallScope.getEnclosingScope();
        }
        if (enclosingFuncCallScope instanceof RfNamedElement) {
            List<RfField> classInheritedFields;
            List<RfField> fields = ((RfNamedElement)enclosingFuncCallScope).getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields != null && !fields.isEmpty()) {
                for (RfField field : fields) {
                    scopeArgsVarsAndFields.add(new CAFieldAndScope(field, CAFieldAndScope.ScopeKind.FIELD));
                }
            }
            if ((classInheritedFields = ((RfNamedElement)enclosingFuncCallScope).getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED)) != null && !classInheritedFields.isEmpty()) {
                for (RfField inheritedField : classInheritedFields) {
                    CAFieldAndScope inheritedCAField = new CAFieldAndScope(inheritedField, CAFieldAndScope.ScopeKind.INHERITED_FIELD);
                    if (scopeArgsVarsAndFields.contains(inheritedCAField)) continue;
                    scopeArgsVarsAndFields.add(inheritedCAField);
                }
            }
        }
        return scopeArgsVarsAndFields;
    }

    private List<CAFieldAndScope> getTypeCompatibleArgsFromList(RfField argumentToMatch, Set<CAFieldAndScope> scopeArgsVarsAndFields) {
        if (argumentToMatch == null || scopeArgsVarsAndFields == null || scopeArgsVarsAndFields.isEmpty()) {
            return Collections.emptyList();
        }
        DataType argDataType = argumentToMatch.getDataType();
        if (argDataType == null || argDataType.getType() == null || argDataType.getType().isEmpty()) {
            return Collections.emptyList();
        }
        IRfNamedElement argAssocType = argumentToMatch.getAssociatedTypeNoLastLevelParams(RfTypesResolver.create((IRfScopeElement)argumentToMatch, argumentToMatch.getRfProject(), 0));
        ArrayList<CAFieldAndScope> typeCompatibleArgs = new ArrayList<CAFieldAndScope>();
        for (CAFieldAndScope candidate : scopeArgsVarsAndFields) {
            RfField candidateField = candidate.getField();
            IRfNamedElement candidateAssocType = candidateField.getAssociatedTypeNoLastLevelParams(RfTypesResolver.create((IRfScopeElement)candidateField, candidateField.getRfProject(), 0));
            if (candidateAssocType == null || argAssocType == null || argAssocType instanceof RfPredefinedScalarType) {
                DataType candidateFieldDataType = candidateField.getDataType();
                if (candidateFieldDataType == null || candidateFieldDataType.getType() == null || candidateFieldDataType.getType().isEmpty() || !candidateFieldDataType.equalsIgnoringDirection(argDataType)) continue;
                typeCompatibleArgs.add(candidate);
                continue;
            }
            if (!RfFunction.assocTypesCompatible(argAssocType, candidateAssocType)) continue;
            typeCompatibleArgs.add(candidate);
        }
        return typeCompatibleArgs;
    }

    private RfField findMatchingArgument(RfField argumentToMatch, Set<CAFieldAndScope> scopeArgsVarsAndFields) {
        if (scopeArgsVarsAndFields == null || scopeArgsVarsAndFields.isEmpty()) {
            return argumentToMatch;
        }
        List<CAFieldAndScope> typeCompatibleArgs = this.getTypeCompatibleArgsFromList(argumentToMatch, scopeArgsVarsAndFields);
        if (typeCompatibleArgs == null || typeCompatibleArgs.isEmpty()) {
            return argumentToMatch;
        }
        Collections.sort(typeCompatibleArgs, new CAMatchingArgumentComparator(argumentToMatch.getName()));
        CAFieldAndScope firstMatchedArg = typeCompatibleArgs.get(0);
        if (firstMatchedArg == null) {
            return argumentToMatch;
        }
        if (firstMatchedArg.getField() != null) {
            argumentToMatch = firstMatchedArg.getField();
        }
        return argumentToMatch;
    }

    public String printArguments(RfTypesResolver resolver, boolean hasType, IRfScope funcCallScope, boolean asTemplateVariables, boolean keepInitialValues, MethodSignatureUseCase useCase, boolean typeCompatibleArgument) {
        return this.printArguments(resolver, null, -1, hasType, funcCallScope, asTemplateVariables, keepInitialValues, useCase, typeCompatibleArgument, false, true);
    }

    public String printArguments(RfTypesResolver resolver, RfNamedElement cursorScope, boolean hasType, IRfScope funcCallScope, boolean asTemplateVariables, boolean keepInitialValues, MethodSignatureUseCase useCase, boolean typeCompatibleArgument, boolean qualifyType) {
        return this.printArguments(resolver, cursorScope, -1, hasType, funcCallScope, asTemplateVariables, keepInitialValues, useCase, typeCompatibleArgument, qualifyType, true);
    }

    public String printArguments(RfTypesResolver resolver, int cursorOffset, boolean hasType, IRfScope funcCallScope, boolean asTemplateVariables, boolean keepInitialValues, MethodSignatureUseCase useCase, boolean typeCompatibleArgument, boolean insertOptionalArguments) {
        return this.printArguments(resolver, null, cursorOffset, hasType, funcCallScope, asTemplateVariables, keepInitialValues, useCase, typeCompatibleArgument, false, insertOptionalArguments);
    }

    public String printArguments(RfTypesResolver resolver, boolean hasType, IRfScope funcCallScope, boolean insertOptionalArguments, boolean asTemplateVariables, boolean keepInitialValues, MethodSignatureUseCase useCase, boolean typeCompatibleArgument) {
        return this.printArguments(resolver, null, -1, hasType, funcCallScope, asTemplateVariables, keepInitialValues, useCase, typeCompatibleArgument, false, insertOptionalArguments);
    }

    public String printArguments(RfTypesResolver resolver, RfNamedElement cursorScope, int cursorOffset, boolean hasType, IRfScope funcCallScope, boolean asTemplateVariables, boolean keepInitialValues, MethodSignatureUseCase useCase, boolean typeCompatibleArgument, boolean qualifyType, boolean insertOptionalArguments) {
        boolean insertNamedArguments = Utils.isContentAssistInsertNamedArguments();
        StringBuilder result = new StringBuilder();
        List<RfField> arguments = this.getOnlyDeclarationArguments();
        if (arguments == null || arguments.isEmpty()) {
            return result.toString();
        }
        boolean keepMacros = EnumSet.of(MethodSignatureUseCase.METHOD_OVERRIDE_CODE_GENERATION, MethodSignatureUseCase.EXTERN_METHOD_CODE_GENERATION).contains((Object)useCase);
        HashSet<CAFieldAndScope> scopeArgsVarsAndFields = typeCompatibleArgument ? this.getScopeArgsVarsAndFields(funcCallScope, cursorOffset) : new HashSet();
        Iterator<RfField> argIt = arguments.iterator();
        try {
            while (argIt.hasNext()) {
                boolean addCommaForNamedArguments;
                RfField arg = argIt.next();
                RfField matchedArg = null;
                boolean isPredefinedContentAssistMethod = RfListType.ARRAY_PREDEFINED_METHODS.contains(this.getName()) && this instanceof RfPredefinedFunction;
                switch (useCase) {
                    case METHOD_OVERRIDE_CODE_GENERATION: {
                        result.append(this.printArgument(arg, cursorScope, resolver, true, asTemplateVariables, true, keepMacros, qualifyType, true));
                        break;
                    }
                    case EXTERN_METHOD_CODE_GENERATION: {
                        result.append(this.printArgument(arg, cursorScope, resolver, true, asTemplateVariables, true, keepMacros, qualifyType, true));
                        break;
                    }
                    case CONTENT_ASSIST_PROPOSAL: {
                        boolean hasInitialValue;
                        boolean bl = hasInitialValue = hasType && keepInitialValues && arg.getInitialValue(false) != null;
                        if (hasInitialValue && !insertOptionalArguments) break;
                        matchedArg = typeCompatibleArgument && (!isPredefinedContentAssistMethod || !arg.isPredefined()) ? this.findMatchingArgument(arg, scopeArgsVarsAndFields) : arg;
                        result.append(this.printArgument(matchedArg, cursorScope, resolver, true, asTemplateVariables, keepInitialValues, keepMacros, qualifyType, false));
                        break;
                    }
                    case METHOD_CALL: {
                        boolean hasInitialValue;
                        boolean bl = hasInitialValue = arg.getInitialValue(false) != null;
                        if (hasInitialValue && !insertOptionalArguments) break;
                        matchedArg = typeCompatibleArgument && (!isPredefinedContentAssistMethod || !arg.isPredefined()) ? this.findMatchingArgument(arg, scopeArgsVarsAndFields) : arg;
                        result.append(this.printArgument(matchedArg, cursorScope, resolver, false, asTemplateVariables, false, keepMacros, qualifyType, false));
                        break;
                    }
                    case TOOLTIP_TEXT: {
                        result.append(this.printArgument(arg, cursorScope, resolver, true, asTemplateVariables, keepInitialValues, keepMacros, qualifyType, false));
                        break;
                    }
                    case QUICKFIX_TEXT: {
                        break;
                    }
                    case DEFAULT: {
                        result.append(this.printArgument(arg, cursorScope, resolver, true, asTemplateVariables, false, keepMacros, qualifyType, false));
                        break;
                    }
                }
                boolean bl = addCommaForNamedArguments = insertNamedArguments && (arg.getInitialValue(false) == null || insertOptionalArguments);
                if (!argIt.hasNext() || insertNamedArguments && !addCommaForNamedArguments) continue;
                result.append(", ");
            }
        }
        finally {
            CharBufferCacher.getInstance().clearCache();
        }
        return result.toString();
    }

    public List<RfField> getOnlyDeclarationArguments() {
        List<RfField> arguments = this.getArgumentsWithPrefix("", 2);
        Collection declarations = this.getDeclarations();
        if (declarations == null || declarations.isEmpty()) {
            return arguments;
        }
        RfDefElement functionDecl = null;
        for (RfDefElement declaration : declarations) {
            if (declaration instanceof RfFunctionDef && ((RfFunctionDef)declaration).isExportDPI()) continue;
            functionDecl = declaration;
            break;
        }
        if (functionDecl == null) {
            return arguments;
        }
        ArrayList<RfField> result = new ArrayList<RfField>();
        for (RfField argument : arguments) {
            RfDefElement argumentDecl = argument.getDeclaration();
            if (argumentDecl != null) {
                if (((RfFieldDef)argumentDecl).getParentDef() != functionDecl) continue;
                result.add(argument);
                continue;
            }
            result.add(argument);
        }
        return result;
    }

    public static boolean assocTypesCompatible(IRfNamedElement assocType, IRfNamedElement varAssocType) {
        if (varAssocType instanceof RfSpecializedClass) {
            varAssocType = ((RfSpecializedClass)varAssocType).getGenericClass();
        }
        if (assocType instanceof RfSpecializedClass) {
            assocType = ((RfSpecializedClass)assocType).getGenericClass();
        }
        if (assocType instanceof RfListType && varAssocType instanceof RfListType) {
            DataType assocTypeDT = ((RfListType)assocType).getDataType();
            DataType varAssocTypeDT = ((RfListType)varAssocType).getDataType();
            if (assocTypeDT != null && assocTypeDT.equalsIgnoringDirection(varAssocTypeDT)) {
                return true;
            }
        }
        if (varAssocType == assocType && varAssocType != null) {
            return true;
        }
        if (varAssocType instanceof RfClass && assocType instanceof RfClass) {
            return ((RfClass)varAssocType).isSubClass((RfClass)assocType);
        }
        return false;
    }

    public static String getFunctionKindName(byte kind) {
        switch (kind) {
            case 0: {
                return "function";
            }
            case 1: {
                return "task";
            }
            case 2: {
                return "constructor";
            }
            case 3: {
                return "let";
            }
            case 4: {
                return "production";
            }
        }
        return "undefined";
    }

    @Deprecated
    private String printArgType(RfTypesResolver resolver, boolean keepMacros, RfNamedElement functionScope, RfField argument) {
        IRfNamedElement associatedType = argument.getAssociatedType(RfTypesResolver.create(resolver));
        String assocTypeName = argument.getAssociatedTypeName(functionScope, resolver, false, keepMacros);
        String scopeRelativeTo = "";
        if (associatedType != null && !VlogFunctionSignatureUtils.isScalarType(associatedType)) {
            scopeRelativeTo = RfBatchUtils.getScopeRelativeTo(functionScope, associatedType, false);
        }
        if (scopeRelativeTo != null && !scopeRelativeTo.isEmpty()) {
            assocTypeName = String.valueOf(scopeRelativeTo) + HIERARCHY_SEPARATOR + assocTypeName;
        }
        return assocTypeName;
    }

    @Override
    public boolean typeIsScalar() {
        if (!super.typeIsScalar()) {
            return false;
        }
        List<RfField> localFields = this.getLocalMembers(RfField.class);
        if (localFields != null) {
            for (RfField field : localFields) {
                if (field.typeIsScalar()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return super.getModulesWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        List<RfField> vars = super.getVarsWithPrefix(offset, prefix, matchType);
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfAbstractBlock) {
            vars.addAll(enclosingScope.getVarsWithPrefix(offset, prefix, matchType));
        }
        return vars;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        RfField variable = super.getVarWithPrefix(offset, prefix, matchType);
        if (variable != null) {
            return variable;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfAbstractBlock) {
            return enclosingScope.getVarWithPrefix(offset, prefix, matchType);
        }
        return null;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getThisImplicitVariable(prefix, matchType);
    }

    @Override
    public RfSuperImplicitVariable getSuperImplicitVariable(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getSuperImplicitVariable(prefix, matchType);
    }

    @Override
    public String getCustomName() {
        String customName = super.getCustomName();
        if (customName == null) {
            return null;
        }
        return customName + this.fKind;
    }

    public MacroCallInfo getMacroCallInfo() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) instanceof RfFunction) {
            return ((RfFunction)genericElement).getMacroCallInfo();
        }
        if (this.fLinterSpecific2 == null) {
            return null;
        }
        return this.fLinterSpecific2.fMacroCallInfo;
    }

    public int getStatementNo() {
        if (this.fLinterSpecific2 == null) {
            return 0;
        }
        return this.fLinterSpecific2.fStatementNo;
    }

    public void setStatementNo(int statementNo) {
        if (this.fLinterSpecific2 == null) {
            this.fLinterSpecific2 = new LinterSpecific2();
        }
        this.fLinterSpecific2.fStatementNo = statementNo;
    }

    public void setMacroCallInfo(MacroCallInfo macroCallInfo) {
        if (this.fLinterSpecific2 == null) {
            this.fLinterSpecific2 = new LinterSpecific2();
        }
        this.fLinterSpecific2.fMacroCallInfo = macroCallInfo;
    }

    public void addTimeConsumingStatements(List<TimeConsumingStatement> timeConsumingStatements) {
        if (this.fLinterSpecific2 == null) {
            this.fLinterSpecific2 = new LinterSpecific2();
        }
        this.fLinterSpecific2.fTimeConsumingStatements = timeConsumingStatements;
    }

    public List<TimeConsumingStatement> getTimeConsumingStatements() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) instanceof RfFunction) {
            return ((RfFunction)genericElement).getTimeConsumingStatements();
        }
        if (this.fLinterSpecific2 == null) {
            return null;
        }
        return this.fLinterSpecific2.fTimeConsumingStatements;
    }

    public boolean isImportDPI() {
        return (this.fDPIKind & 4) != 0 || this.isDirectC();
    }

    public boolean isExportDPI() {
        return (this.fDPIKind & 8) != 0;
    }

    public String getImportDPIKind() {
        if ((this.fDPIKind & 4) == 0) {
            return null;
        }
        if ((this.fDPIKind & 1) != 0) {
            return "DPI-C";
        }
        if ((this.fDPIKind & 2) != 0) {
            return "DPI";
        }
        return null;
    }

    public String getExportDPIKind() {
        if ((this.fDPIKind & 8) == 0) {
            return null;
        }
        if ((this.fDPIKind & 1) != 0) {
            return "DPI-C";
        }
        if ((this.fDPIKind & 2) != 0) {
            return "DPI";
        }
        return null;
    }

    public boolean isDPI() {
        return this.isImportDPI() || this.isExportDPI();
    }

    public String getCIdentifier() {
        return this.fCIdentifier;
    }

    public String getCMethodName() {
        if (this.fCIdentifier != null && this.fCIdentifier.length() != 0) {
            return this.fCIdentifier;
        }
        return this.getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        switch (this.fKind) {
            case 2: {
                return "DUPLICATE_CONSTRUCTOR: Duplicate constructor ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
            case 1: {
                return "DUPLICATE_TASK: Duplicate task ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
            case 4: {
                return "DUPLICATE_PRODUCTION: Duplicate production ''{0}'', already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_FUNCTION: Duplicate function ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public String getSemanticErrorCodeForDuplicateImpl() {
        switch (this.fKind) {
            case 1: {
                return "DUPLICATE_TASK_IMPL: Duplicate task implementation for ''{0}'', already implemented at line {1,number,#######} file {2}";
            }
        }
        return "DUPLICATE_FUNCTION_IMPL: Duplicate function implementation for ''{0}'', already implemented at line {1,number,#######} file {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        switch (this.fKind) {
            case 4: {
                return 1;
            }
        }
        return 2;
    }

    public String getSemanticErrorCodeForUnimplemented() {
        switch (this.fKind) {
            case 1: {
                return "MISSING_TASK_IMPLEMENTATION: ''{0}'' extern task is not implemented";
            }
        }
        return "MISSING_FUNCTION_IMPLEMENTATION: ''{0}'' extern function is not implemented";
    }

    public String getSemanticErrorCodeForImplementationScope() {
        switch (this.fKind) {
            case 1: {
                return RfSemanticError.NON_STANDARD_TASK_IMPLEMENTATION_SCOPE;
            }
        }
        return RfSemanticError.NON_STANDARD_FUNCTION_IMPLEMENTATION_SCOPE;
    }

    public String getSemanticErrorCodeForNotExtern() {
        switch (this.fKind) {
            case 1: {
                return "EXTERN_TASK_UNDECLARED: Outer class task ''{0}'' was not declared extern inside class ''{1}''";
            }
        }
        return "EXTERN_FUNCTION_UNDECLARED: Outer class function ''{0}'' was not declared extern inside class ''{1}''";
    }

    public String getSemanticErrorCodeForImplExportDPI() {
        switch (this.fKind) {
            case 1: {
                return "EXPORT_DPI_TASK_IMPL: Export DPI task ''{0}'' was not implemented";
            }
        }
        return "EXPORT_DPI_FUNCTION_IMPL: Export DPI function ''{0}'' was not implemented";
    }

    public SearchMatchKindsWrapper computeEquals(RfTypesResolver thisResolver, Object obj, RfTypesResolver objResolver, LinkedHashSet<RfClass> classFamilyParam) {
        if (obj instanceof RfFunction) {
            RfFunction otherFunction = (RfFunction)obj;
            if (!this.getName().equals(otherFunction.getName())) {
                return SearchMatchKindsWrapper.getNoMatch();
            }
            RfField.TypeCompatibilityMatchKind typeCompatibilityKind = this.getTypeCompatibleKind(thisResolver, otherFunction, objResolver);
            if (super.checkEquals(obj)) {
                return new SearchMatchKindsWrapper(FunctionCallKind.STRICT, typeCompatibilityKind);
            }
            if (otherFunction.isTask() && !this.isTask() || !otherFunction.isTask() && this.isTask()) {
                return new SearchMatchKindsWrapper(FunctionCallKind.NO_MATCH, typeCompatibilityKind);
            }
            if (!otherFunction.isVirtual() || !this.isVirtual()) {
                return new SearchMatchKindsWrapper(FunctionCallKind.NO_MATCH, typeCompatibilityKind);
            }
            LinkedHashSet<RfClass> classFamily = classFamilyParam == null || classFamilyParam.isEmpty() ? this.computeClassFamily() : classFamilyParam;
            RfNamedElement otherFunctionEnclosingScope = otherFunction.getEnclosingScope();
            if (otherFunctionEnclosingScope instanceof RfClass) {
                otherFunctionEnclosingScope = ((RfClass)otherFunctionEnclosingScope).getGenericClass();
            }
            if (classFamily.contains(otherFunctionEnclosingScope)) {
                RfNamedElement currScope = otherFunctionEnclosingScope;
                RfNamedElement rfScope = this.getEnclosingScope();
                if (!(currScope instanceof RfClass) || !(rfScope instanceof RfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.NO_MATCH, typeCompatibilityKind);
                }
                RfClass currClass = (RfClass)currScope;
                RfClass rfClass = (RfClass)rfScope;
                if (currClass.equals(rfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.STRICT, typeCompatibilityKind);
                }
                if (rfClass.isChildOfClassOrInterface(currClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.CHILDREN, typeCompatibilityKind);
                }
                if (currClass.isChildOfClassOrInterface(rfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.OVERRIDDEN, typeCompatibilityKind);
                }
                return new SearchMatchKindsWrapper(FunctionCallKind.FULL, typeCompatibilityKind);
            }
        } else if (obj instanceof RfResultImplicitVariable) {
            RfResultImplicitVariable variable = (RfResultImplicitVariable)obj;
            if (!this.getName().equals(variable.getName())) {
                return SearchMatchKindsWrapper.getNoMatch();
            }
            RfNamedElement enclosing = variable.getEnclosingScope();
            if (enclosing == this) {
                return new SearchMatchKindsWrapper(FunctionCallKind.STRICT);
            }
            if (!enclosing.isVirtual() || !this.isVirtual()) {
                return new SearchMatchKindsWrapper(FunctionCallKind.NO_MATCH);
            }
            LinkedHashSet<RfClass> classFamily = this.computeClassFamily();
            if (enclosing instanceof RfFunction && classFamily.contains(enclosing.getEnclosingScope())) {
                RfNamedElement currScope = enclosing.getEnclosingScope();
                RfNamedElement rfScope = this.getEnclosingScope();
                if (!(currScope instanceof RfClass) || !(rfScope instanceof RfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.NO_MATCH);
                }
                RfClass currClass = (RfClass)currScope;
                RfClass rfClass = (RfClass)rfScope;
                if (currClass.equals(rfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.STRICT);
                }
                if (rfClass.isChildOfClassOrInterface(currClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.CHILDREN);
                }
                if (currClass.isChildOfClassOrInterface(rfClass)) {
                    return new SearchMatchKindsWrapper(FunctionCallKind.OVERRIDDEN);
                }
                return new SearchMatchKindsWrapper(FunctionCallKind.FULL);
            }
        }
        return SearchMatchKindsWrapper.getNoMatch();
    }

    private RfField.TypeCompatibilityMatchKind getTypeCompatibleKind(RfTypesResolver thisResolver, RfFunction otherFunction, RfTypesResolver objResolver) {
        RfNamedElement enclosingScopeObj = otherFunction.getEnclosingScope();
        RfNamedElement enclosingScope = this.getEnclosingScope();
        return VlogRfReferencesUtils.getTypeCompatibilityMatchKind(enclosingScopeObj, objResolver, enclosingScope, thisResolver).getTypeCompatibleKind();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkEquals(Object obj) {
        void var3_2;
        IRfNamedElement iRfNamedElement;
        Object object = obj;
        if (object instanceof IRfNamedElement && (iRfNamedElement = (IRfNamedElement)object) == (IRfNamedElement)var3_2) {
            void namedElement;
            return this.computeEquals(RfTypesResolver.create((IRfScopeElement)this.getEnclosingScope(), this.getRfProject(), 8), obj, RfTypesResolver.create((IRfScopeElement)namedElement, namedElement.getRfProject(), 8), null).isMatch();
        }
        return false;
    }

    public LinkedHashSet<RfClass> computeClassFamily() {
        RfClass rfClass;
        LinkedHashSet<RfClass> result = new LinkedHashSet<RfClass>();
        RfNamedElement enclosing = this.getEnclosingScope();
        if (!(enclosing instanceof RfClass)) {
            return result;
        }
        RfClass firstParent = rfClass = ((RfClass)enclosing).getGenericClass();
        RfClass candidateParent = rfClass;
        Set<RfClass> visited = Collections.newSetFromMap(new IdentityHashMap());
        while ((candidateParent = candidateParent.getParent()) != null) {
            RfClass genericClass = candidateParent.getGenericClass();
            if (visited.contains(genericClass)) break;
            visited.add(genericClass);
            RfFunction candidateFunction = null;
            candidateFunction = this.isTask() ? candidateParent.getLocalTask(this.getName()) : candidateParent.getLocalFunction(this.getName());
            if (candidateFunction == null) continue;
            firstParent = candidateParent;
        }
        visited.clear();
        result.add(firstParent.getGenericClass());
        this.getParentInterfacesRecursive(visited, result, firstParent);
        this.getChildrenRecursive(visited, result, firstParent);
        return result;
    }

    private void getParentInterfacesRecursive(Set<RfClass> visited, LinkedHashSet<RfClass> result, RfClass clazz) {
        RfClass parent2;
        List<RfClass> parents = clazz.getParentInterfaces();
        if (parents == null || parents.isEmpty()) {
            return;
        }
        for (RfClass parent2 : parents) {
            RfClass genericClass = parent2.getGenericClass();
            if (visited.contains(genericClass)) continue;
            visited.add(genericClass);
            RfFunction candidateFunction = null;
            candidateFunction = this.isTask() ? genericClass.getLocalTask(this.getName()) : genericClass.getLocalFunction(this.getName());
            if (candidateFunction != null) {
                result.add(genericClass);
            }
            this.getParentInterfacesRecursive(visited, result, parent2);
            if (candidateFunction == null) continue;
            this.getChildrenRecursive(visited, result, genericClass);
        }
        parent2 = clazz.getParent();
        while (parent2 != null) {
            RfClass genericClass = parent2.getGenericClass();
            if (visited.contains(genericClass)) {
                return;
            }
            visited.add(genericClass);
            RfFunction candidateFunction = null;
            candidateFunction = this.isTask() ? genericClass.getLocalTask(this.getName()) : genericClass.getLocalFunction(this.getName());
            if (candidateFunction != null) {
                result.add(genericClass);
            }
            this.getParentInterfacesRecursive(visited, result, genericClass);
            if (candidateFunction == null) continue;
            this.getChildrenRecursive(visited, result, genericClass);
        }
    }

    private void getChildrenRecursive(Set<RfClass> visited, LinkedHashSet<RfClass> result, RfClass clazz) {
        if (clazz instanceof IRfSpecializedTypeElement) {
            return;
        }
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            RfClass genericClass = child.getGenericClass();
            if (visited.contains(genericClass)) continue;
            visited.add(genericClass);
            RfFunction candidateFunction = null;
            candidateFunction = this.isTask() ? genericClass.getLocalTask(this.getName()) : genericClass.getLocalFunction(this.getName());
            if (candidateFunction != null) {
                result.add(genericClass);
            }
            if (candidateFunction != null) {
                this.getParentInterfacesRecursive(visited, result, genericClass);
            }
            this.getChildrenRecursive(visited, result, genericClass);
        }
    }

    @Override
    public Image getImage() {
        if (this.isTask()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
        }
        if (this.isConstructor()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRUCTOR);
        }
        if (this.isLet()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LET);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fDPIKind = 0;
        this.fCIdentifier = null;
        if (this.fLinterSpecific1 != null) {
            if (this.fLinterSpecific1.fEventTriggers != null) {
                this.fLinterSpecific1.fEventTriggers.deepClean();
            }
            this.fLinterSpecific1.fEventTriggers = null;
            if (this.fLinterSpecific1.fFunctionCalls != null) {
                this.fLinterSpecific1.fFunctionCalls.clear();
            }
            this.fLinterSpecific1.fFunctionCalls = null;
        }
        this.fLinterSpecific1 = null;
        if (this.fLinterSpecific2 != null) {
            if (this.fLinterSpecific2.fTimeConsumingStatements != null) {
                this.fLinterSpecific2.fTimeConsumingStatements.clear();
            }
            this.fLinterSpecific2.fTimeConsumingStatements = null;
            if (this.fLinterSpecific2.fMacroCallInfo != null) {
                this.fLinterSpecific2.fMacroCallInfo.clear();
            }
            this.fLinterSpecific2.fMacroCallInfo = null;
        }
        this.fLinterSpecific2 = null;
    }

    @Override
    public int getMemberSelect() {
        if (this.isTask()) {
            return 4;
        }
        return 3;
    }

    @Override
    protected final RfNamedElement.ImportsExports internalGetImportsExports() {
        return this.fImportsExports;
    }

    @Override
    protected final void internalSetImportsExports(RfNamedElement.ImportsExports importsExports) {
        this.fImportsExports = importsExports;
    }

    @Override
    protected final DVTLinkedHashMap<String, RfNamedElement> internalGetMembers() {
        return this.fMembers;
    }

    @Override
    protected final void internalSetMembers(DVTLinkedHashMap<String, RfNamedElement> members) {
        this.fMembers = members;
    }

    @Override
    protected final RfNamedElement.LinterSpecific1 internalGetLinterSpecific1() {
        return this.fLinterSpecific1;
    }

    @Override
    protected final void internalSetLinterSpecific1(RfNamedElement.LinterSpecific1 linterSpecific) {
        this.fLinterSpecific1 = linterSpecific;
    }

    @Override
    protected final RfNamedElement.NamesCache internalGetNamesCache() {
        return this.fNamesCache;
    }

    @Override
    protected final void internalSetNamesCache(RfNamedElement.NamesCache namesCache) {
        this.fNamesCache = namesCache;
    }

    @Override
    protected final RfHidHolder internalGetHidHolder() {
        return this.fHidHolder;
    }

    @Override
    protected final void internalSetHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    @Override
    public String getFullNameLabel(RfTypesResolver resolver) {
        return String.valueOf(super.getFullNameLabel(resolver)) + "()";
    }

    public boolean isObjectStatic() {
        if (this.hasObjectStaticQualifier()) {
            return true;
        }
        if (this.hasObjectAutomaticQualifier()) {
            return false;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        return !(enclosing instanceof RfListType) && !(enclosing instanceof RfClass) && !(enclosing instanceof RfFragment) && !(enclosing instanceof RfStruct);
    }

    public void resolveHidsForElaboration(byte semanticEnabled) {
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, rfProject.getToolCompat());
        super.resolveHids(configInfo, false, false, semanticEnabled, null);
    }

    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        RfNamedElement candidate;
        if (this.isMemberOfSpecializedElement() && (candidate = this.getElementInGenericScope()) instanceof RfFunction) {
            return candidate.visitHidObject(rfProject, visitor);
        }
        return super.visitHidObject(rfProject, visitor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        RfNamedElement enclosing = this.getEnclosingScope();
        while (enclosing != null && !(enclosing instanceof RfProject)) {
            result = 31 * result + RfElementPath.segmentHashCode(enclosing.getCustomClass(), (String)enclosing.getCustomName());
            enclosing = enclosing.getEnclosingScope();
        }
        result = 31 * result + Objects.hash(this.fKind, this.fDPIKind);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfFunction other = (RfFunction)obj;
        return this.fKind == other.fKind && Objects.equals(this.fDPIKind, other.fDPIKind);
    }

    @Override
    public void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        super.xCollectMemberNames(result, isAddPredefined);
        if (this.isVoid() || this.isConstructor()) {
            return;
        }
        result.add(DVTStringUtil.intern((String)this.getName()));
    }

    public IRfDefElement xGetDeclaration() {
        return this.getImplementation();
    }

    public boolean xMissingConstructorImpl() {
        Collection allDefs = this.getDeclarations();
        return this.isExtern() && (allDefs == null || allDefs.size() < 2);
    }

    public static enum FunctionCallKind {
        NO_MATCH,
        FULL,
        OVERRIDDEN,
        CHILDREN,
        STRICT;

    }

    private static final class LinterSpecific2 {
        private transient MacroCallInfo fMacroCallInfo;
        private transient int fStatementNo;
        private transient List<TimeConsumingStatement> fTimeConsumingStatements;

        private LinterSpecific2() {
        }
    }
}

