/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.NamedElementAndString;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class RfFunctionCall
extends RfMembersHolder {
    private static final long serialVersionUID = 1L;
    public static final int NON_STATEMENT = 0;
    public static final int STATEMENT = 1;
    public static final int STATEMENT_CAST_TO_VOID = 2;
    public static final Set<Class<? extends IRfNamedElement>> MEMBERS_FIELDS = new HashSet<Class<? extends IRfNamedElement>>();
    private List<String> fArgumentValues;
    private IHidObject fLValue;
    private short fKind;
    private boolean fHasParentheses;
    private boolean fIsDynamicArrayNew;
    private String fSelect;
    private boolean fWith;
    private transient boolean fIsEvaluating;
    private transient RfWNamedElementAndScope fCachedWNamedElementAndScope;
    private transient NamedElementAndString fCachedLValueNamedElementAndString;
    private boolean fIsShallowCopy;

    static {
        MEMBERS_FIELDS.add(RfField.class);
    }

    public RfFunctionCall(IHidObject lValue, String functionName, boolean escaped, List<ArgInfo> argumentValues, int kind, boolean hasParens, boolean isDynamicArrayNew, String select, boolean with) {
        super(functionName, escaped);
        this.fLValue = lValue;
        this.fArgumentValues = this.toLOFString(argumentValues);
        this.fKind = (short)kind;
        this.fHasParentheses = hasParens;
        this.fIsDynamicArrayNew = isDynamicArrayNew;
        this.fSelect = select;
        this.fWith = with;
    }

    private List<String> toLOFString(List<ArgInfo> argumentValues) {
        if (argumentValues == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(argumentValues.size());
        for (ArgInfo argumentValue : argumentValues) {
            result.add(argumentValue.getName());
        }
        return result;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return this.getName();
    }

    public IRfNamedElementAndScope getWNamedElementAndScope() {
        if (this.fCachedWNamedElementAndScope == null && !this.fIsEvaluating) {
            this.fIsEvaluating = true;
            try {
                RfDefElement enclosingDef;
                String stringExpr = null;
                boolean hid = true;
                if ("new".equals(this.getName())) {
                    hid = false;
                    stringExpr = this.getLValue() != null ? String.valueOf(this.getLValue()) + " = " + this.getName() : this.getName();
                } else {
                    stringExpr = this.getName();
                }
                RfFileDef fileDef = this.getFile();
                RfDefElement declaration = this.getDeclaration();
                if (fileDef != null && declaration != null && (enclosingDef = this.getEnclosingDef(declaration)) != null) {
                    this.fCachedWNamedElementAndScope = LintUtils.getWNamedElementAndScope(this.getRfProject(), enclosingDef, declaration.getStartOffset(), stringExpr, hid);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.fIsEvaluating = false;
        }
        return this.fCachedWNamedElementAndScope;
    }

    private RfDefElement getEnclosingDef(RfDefElement declaration) {
        RfNamedElement declarationNamedElement = declaration.getNamedElement();
        if (declarationNamedElement == null) {
            return null;
        }
        RfNamedElement enclosingNamedElement = declarationNamedElement.getEnclosingScope();
        if (enclosingNamedElement == null) {
            return null;
        }
        if (enclosingNamedElement instanceof RfLibrary) {
            return declaration.getDefFile();
        }
        for (RfDefElement def : enclosingNamedElement.getDeclarations()) {
            if (def == null || def.getDefFile() != declaration.getDefFile() || def.getStartOffset() > declaration.getStartOffset() || def.getEndOffset() < declaration.getEndOffset()) continue;
            return def;
        }
        return null;
    }

    public RfNamedElement getCalledElement() {
        this.getWNamedElementAndScope();
        if (this.fCachedWNamedElementAndScope != null) {
            return this.fCachedWNamedElementAndScope.getNamedElement();
        }
        return null;
    }

    public RfNamedElement getCalledFromScope() {
        this.getWNamedElementAndScope();
        if (this.fCachedWNamedElementAndScope != null) {
            return this.fCachedWNamedElementAndScope.getCalledFromScope();
        }
        return null;
    }

    public RfFunction getFunction() {
        RfNamedElement value = this.getCalledElement();
        if (value instanceof RfResultImplicitVariable && this.hasParentheses()) {
            return (RfFunction)value.getEnclosingScope();
        }
        if (value instanceof RfFunction) {
            return (RfFunction)value;
        }
        return null;
    }

    public String getFunctionName() {
        RfFunction function = this.getFunction();
        if (function != null) {
            return function.getName();
        }
        return null;
    }

    public RfField getField() {
        RfField fieldCandidate;
        RfNamedElement value = this.getCalledElement();
        if (value instanceof RfField && (fieldCandidate = (RfField)value).isField()) {
            return fieldCandidate;
        }
        return null;
    }

    public RfNamedElement getLeftValue() {
        this.getLeftValueElementAndSelect();
        if (this.fCachedLValueNamedElementAndString != null && this.fCachedLValueNamedElementAndString.getNameElement() instanceof RfNamedElement) {
            return (RfNamedElement)this.fCachedLValueNamedElementAndString.getNameElement();
        }
        return null;
    }

    public NamedElementAndString getLeftValueElementAndSelect() {
        if (this.fCachedLValueNamedElementAndString == null) {
            String[] nameAndSelect = NamedElementAndString.getNameAndSelect(this.getLValue());
            String lValueName = nameAndSelect[0];
            String lValueSelect = nameAndSelect[1];
            if (lValueSelect == null) {
                lValueSelect = this.fSelect;
            } else if (this.fSelect != null) {
                lValueSelect = String.valueOf(lValueSelect) + this.fSelect;
            }
            this.fCachedLValueNamedElementAndString = new NamedElementAndString(null, lValueSelect);
            RfWNamedElementAndScope wNamedElementAndScope = LintUtils.getWNamedElementAndScope(this.getRfProject(), this.getEnclosingScope(), this.getStartOffset(), lValueName, true);
            if (wNamedElementAndScope != null) {
                this.fCachedLValueNamedElementAndString.fNameElement = wNamedElementAndScope.getNamedElement();
            }
        }
        return this.fCachedLValueNamedElementAndString;
    }

    public String getArgumentValue(int index) {
        if (this.fArgumentValues == null || this.fArgumentValues.size() <= index) {
            return null;
        }
        return this.fArgumentValues.get(index);
    }

    public List<String> getArguments() {
        return this.fArgumentValues;
    }

    public String getLValue() {
        return HidUtils.toNiceString((IHidObject)this.fLValue);
    }

    public IHidObject getLeftHid() {
        return this.fLValue;
    }

    public boolean isStatement() {
        return this.fKind == 1 || this.fKind == 2;
    }

    public boolean isStatementCastToVoid() {
        return this.fKind == 2;
    }

    public RfFunction getFunctionContainer() {
        RfNamedElement scope = this.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfFunction) {
                return (RfFunction)scope;
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    }

    public boolean hasParentheses() {
        return this.fHasParentheses;
    }

    public boolean isInsideAnotherFunctionCall(RfFunctionCall another) {
        RfDefElement declaration1 = this.getDeclaration();
        RfDefElement declaration2 = another.getDeclaration();
        return declaration1.getStartOffset() >= declaration2.getStartOffset() && declaration1.getEndOffset() <= declaration2.getEndOffset();
    }

    public boolean isDynamicArrayNew() {
        return this.fIsDynamicArrayNew;
    }

    public String getSelect() {
        return this.fSelect;
    }

    public boolean hasWith() {
        return this.fWith;
    }

    public void setWith(boolean with) {
        this.fWith = with;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.fArgumentValues != null) {
            this.fArgumentValues.clear();
        }
        this.fArgumentValues = null;
        this.fLValue = null;
        this.fSelect = null;
        this.fCachedWNamedElementAndScope = null;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        return this.getEnclosingScope().addIdentifier(hidRequest, access);
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        this.getEnclosingScope().updateHolder(updater);
    }

    @Override
    public boolean removeIdentifier(String name) {
        return this.getEnclosingScope().removeIdentifier(name);
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return this.getEnclosingScope().getVarsWithPrefix(offset, prefix, matchType);
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return this.getEnclosingScope().getVarWithPrefix(offset, prefix, matchType);
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getArgumentsWithPrefix(prefix, matchType);
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getArgumentWithPrefix(prefix, matchType);
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return this.getEnclosingScope().getThisImplicitVariable(prefix, matchType);
    }

    @Override
    public RfSuperImplicitVariable getSuperImplicitVariable(String prefix, int matchType) {
        return this.getEnclosingScope().getSuperImplicitVariable(prefix, matchType);
    }

    @Override
    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getSignalWithPrefix(prefix, matchType);
    }

    @Override
    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getInstanceWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getFieldsWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfField getFieldWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getFieldWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfStruct> getStructsUnionsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getStructsUnionsWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfTypeAlias> getTypeAliasesWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getTypeAliasesWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfTypeAlias getTypeAliasWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getTypeAliasWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getInterfacesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfInterface getInterfaceWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getInterfaceWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getModulesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfModule getModuleWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getModuleWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getProgramsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfProgram getProgramWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getProgramWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfClass> getClassesWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getClassesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfClass getClassWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getClassWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfFunction> getFunctionsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getFunctionsWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfFunction getFunctionWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getFunctionWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfFunction> getConstructorsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getConstructorsWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfFunction getConstructorWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getConstructorWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfFunction> getTasksWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getTasksWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfFunction getTaskWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getTaskWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfCoverpoint> getCoverpointsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCoverpointsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfCoverpoint getCoverpointWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCoverpointWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getEventsWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public RfField getEventWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return this.getEnclosingScope().getEventWithPrefix(prefix, matchType, local, accessModifier);
    }

    @Override
    public List<RfField> getParametersWithPrefix(String prefix, int kind, int matchType, int local) {
        return this.getEnclosingScope().getParametersWithPrefix(prefix, kind, matchType, local);
    }

    @Override
    public RfField getParameterWithPrefix(String prefix, int kind, int matchType, int local) {
        return this.getEnclosingScope().getParameterWithPrefix(prefix, kind, matchType, local);
    }

    @Override
    public List<IRfNamedElement> getOtherLangMembersWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getOtherLangMembersWithPrefix(prefix, matchType);
    }

    @Override
    public IRfNamedElement getOtherLangMemberWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getOtherLangMemberWithPrefix(prefix, matchType);
    }

    @Override
    public RfStruct getStructUnionWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getStructUnionWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfStruct> getEnumTypesWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getEnumTypesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfStruct getEnumTypeWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getEnumTypeWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfField> getEnumElementsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getEnumElementsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfField getEnumElementWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getEnumElementWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPackagesWithPrefix(prefix, matchType);
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPackageWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfPrimitive> getPrimitivesWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPrimitivesWithPrefix(prefix, matchType);
    }

    @Override
    public RfPrimitive getPrimitiveWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPrimitiveWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfChecker> getCheckersWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCheckersWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfChecker getCheckerWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCheckerWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfCovergroup> getCovergroupsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCovergroupsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfCovergroup getCovergroupWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getCovergroupWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfInstance> getInstancesWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getInstancesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getInstanceWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPortsWithPrefix(prefix, matchType);
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getPortWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfActionBlock> getNamedBlocksWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getNamedBlocksWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfActionBlock getNamedBlockWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getNamedBlockWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfGenerateBlock> getGenerateBlocksWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getGenerateBlocksWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfGenerateBlock getGenerateBlockWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getGenerateBlockWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfAssertExpect> getAssertsExpectsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getAssertsExpectsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfAssertExpect getAssertExpectWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getAssertExpectWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfEventTrigger> getEventTriggersWithPrefix(String prefix, int matchType) {
        return this.getEnclosingScope().getEventTriggersWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfModport> getModportsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getModportsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfModport getModportWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getModportWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfConstraint> getConstraintsWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getConstraintsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfConstraint getConstraintWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getConstraintWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfPropertySequence> getPropertiesSequencesWithPrefix(String prefix, int kind, int matchType, int local) {
        return this.getEnclosingScope().getPropertiesSequencesWithPrefix(prefix, kind, matchType, local);
    }

    @Override
    public RfPropertySequence getPropertySequenceWithPrefix(String prefix, int kind, int matchType, int local) {
        return this.getEnclosingScope().getPropertySequenceWithPrefix(prefix, kind, matchType, local);
    }

    @Override
    public List<RfClockingBlock> getClockingBlocksWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getClockingBlocksWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfClockingBlock getClockingBlockWithPrefix(String prefix, int matchType, int local) {
        return this.getEnclosingScope().getClockingBlockWithPrefix(prefix, matchType, local);
    }

    public void setShallowCopy(boolean shallowCopy) {
        this.fIsShallowCopy = shallowCopy;
    }

    public boolean isShallowCopy() {
        return this.fIsShallowCopy;
    }
}

