/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.OptimizedHashMap;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;

public class RfFunctionDef
extends RfDefElement {
    private static final long serialVersionUID = 1L;
    private boolean fPrototype;
    private boolean fOutOfClassScope;
    private boolean fOutOfClassDefinition;
    private boolean fANSIStyle;
    private List<ArgInfo> fArgumentInfos;
    private LineInfo defaultLineInfo;
    private byte fDPIKind;
    private byte fKind;
    private transient Map<IRfNamedElement, DataType> fTypeInfo = new OptimizedHashMap();

    public RfFunctionDef(RfFileDef file, WrapperInfo info, boolean outOfClassScope, byte kind, byte dpiKind) {
        super(file, info);
        this.fOutOfClassScope = outOfClassScope;
        this.fDPIKind = dpiKind;
        this.fKind = kind;
    }

    public void addDataType(RfNamedElement namedElement, WrapperInfo info) {
        if (this.fTypeInfo == null) {
            this.fTypeInfo = new OptimizedHashMap();
        }
        if (this.fTypeInfo.isEmpty()) {
            this.fArgumentInfos = info.getArgumentInfos();
        }
        this.fTypeInfo.put(namedElement, info.getDataType());
    }

    public void updateDataType(Map<RfNamedElement, DataType> updater) {
        this.fTypeInfo = new OptimizedHashMap();
        if (updater != null) {
            this.fTypeInfo.putAll(updater);
        }
    }

    public void putAllTypeInfos(Map<IRfNamedElement, DataType> typeInfos) {
        if (this.fTypeInfo == null) {
            this.fTypeInfo = new OptimizedHashMap();
        }
        if (typeInfos != null) {
            this.fTypeInfo.putAll(typeInfos);
        }
    }

    public DataType getTypeInfo(RfNamedElement namedElement) {
        if (this.fTypeInfo == null) {
            return null;
        }
        if (namedElement instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getOccurrence();
        }
        return this.fTypeInfo.get(namedElement);
    }

    public Map<IRfNamedElement, DataType> getAllTypeInfos() {
        return this.fTypeInfo;
    }

    public DataType getTypeInfoOrImplicit(String implicitType, RfNamedElement namedElement) {
        DataType typeInfo = this.getTypeInfo(namedElement);
        return typeInfo != null && typeInfo.fType != null ? typeInfo : new DataType(implicitType);
    }

    public void setArgumentInfos(List<ArgInfo> argumentInfos) {
        this.fArgumentInfos = argumentInfos;
    }

    public List<ArgInfo> getArgumentInfos() {
        return this.fArgumentInfos;
    }

    public String getInfo() {
        return null;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.action";
    }

    public void setPrototype(boolean prototype) {
        this.fPrototype = prototype;
    }

    public boolean isPrototype() {
        return this.fPrototype;
    }

    public boolean isOutOfClassScope() {
        return this.fOutOfClassScope;
    }

    public void setOutOfClassDefinition(boolean isOutOfClassDefinition) {
        this.fOutOfClassDefinition = isOutOfClassDefinition;
    }

    public boolean isOutOfClassDefinition() {
        return this.fOutOfClassDefinition;
    }

    public byte getFunctionKind() {
        return this.fKind;
    }

    public byte getDPIKind() {
        return this.fDPIKind;
    }

    public boolean isExportDPI() {
        return (this.fDPIKind & 8) == 8;
    }

    public String getExportDPIKind() {
        if ((this.fDPIKind & 8) == 0) {
            return null;
        }
        if ((this.fDPIKind & 1) != 0) {
            return "DPI-C";
        }
        if ((this.fDPIKind & 2) != 0) {
            return "DPI";
        }
        return null;
    }

    public void setANSIStyle(boolean isANSIStyle) {
        this.fANSIStyle = isANSIStyle;
    }

    public boolean isANSIStyle() {
        return this.fANSIStyle;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        if (this.fTypeInfo == null) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (!(persistence instanceof Persistence)) {
            return;
        }
        if (((PersistenceOutputStream)out).getPersistenceModeWrapper().persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
            ((Persistence)persistence).functionDefWritten(this, this.fTypeInfo);
            return;
        }
        String precompiledLibName = ((PersistenceOutputStream)out).getPersistenceModeWrapper().libraryName;
        if (precompiledLibName == null) {
            ((Persistence)persistence).functionDefWritten(this, this.fTypeInfo);
            return;
        }
        HashMap<IRfNamedElement, DataType> toWriteDataType = new HashMap<IRfNamedElement, DataType>();
        for (Map.Entry<IRfNamedElement, DataType> namedElementDataType : this.fTypeInfo.entrySet()) {
            IRfLibraryElement enclosingLibrary = namedElementDataType.getKey().getEnclosingLibrary();
            if (enclosingLibrary == null || !precompiledLibName.equals(enclosingLibrary.getName())) continue;
            toWriteDataType.put(namedElementDataType.getKey(), namedElementDataType.getValue());
        }
        ((Persistence)persistence).functionDefWritten(this, toWriteDataType);
    }

    @Override
    public void removeNamedElement(RfNamedElement namedElem) {
        super.removeNamedElement(namedElem);
        this.fTypeInfo.remove(namedElem);
    }

    public void setDefaultLineInfo(LineInfo defaultLineInfo) {
        this.defaultLineInfo = defaultLineInfo;
    }

    public LineInfo getDefaultLineInfo() {
        return this.defaultLineInfo;
    }
}

