/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfGeneratesContainer
extends RfGenerateBlock {
    private static final long serialVersionUID = 1L;
    @NotNull
    private transient List<RfGenerateBlock> listMembers;

    public RfGeneratesContainer(String name, boolean escaped, List<RfGenerateBlock> generates) {
        super(name, escaped, 0L, null, false, 0, true);
        this.listMembers = generates;
        RfGenerateBlock firstMember = this.listMembers.get(0);
        if (firstMember != null) {
            this.setEnclosingScope(firstMember.getEnclosingScope());
        }
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "generate blocks " + this.getName();
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        for (RfGenerateBlock member : this.listMembers) {
            IRfNamedElement result = member.semanticGetLocalMember(name, hid, parserPath, null, visited, enumNameProposals, isFirst, isLast, recursiveCall);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        for (RfGenerateBlock member : this.listMembers) {
            IRfNamedElement result = member.getMember(name, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        for (RfGenerateBlock member : this.listMembers) {
            if (!member.hasNoDefs(rawDefs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RfDefElement getDeclaration() {
        RfGenerateBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getDeclaration();
        }
        return null;
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        for (RfGenerateBlock member : this.listMembers) {
            if (member.hasNoDefs(false)) continue;
            result.addAll(member.getDeclarations());
        }
        return result;
    }

    @Override
    protected RfNamedElement[] internalGetLocalMembersKind(Set<IRfNamedElement> visited, Class<? extends IRfNamedElement> localMembersKind, int localMemebersSelect, String prefix, int matchType) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfGenerateBlock member : this.listMembers) {
            RfNamedElement[] tempResult = member.internalGetLocalMembersKind(visited, localMembersKind, localMemebersSelect, prefix, matchType);
            if (tempResult == null) continue;
            result.addAll(Arrays.asList(tempResult));
        }
        return result.toArray(new RfNamedElement[result.size()]);
    }

    public <T extends IRfNamedElement> T getLastMember(Class<T> clazz) {
        int i = this.listMembers.size() - 1;
        while (i >= 0) {
            RfNamedElement member = this.listMembers.get(i);
            if ((clazz != RfField.class || !(member instanceof RfCoverpoint) && !(member instanceof RfInstance)) && clazz.isInstance(member)) {
                return (T)member;
            }
            --i;
        }
        return null;
    }

    public RfGenerateBlock getFirstMember() {
        return this.listMembers.get(0);
    }

    @Override
    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        ArrayList<? extends IRfBlockElement> result = new ArrayList<IRfBlockElement>();
        for (RfGenerateBlock member : this.listMembers) {
            Collection<? extends IRfBlockElement> localGenerates = member.getLocalGenerateBlocks();
            if (localGenerates == null || localGenerates.isEmpty()) continue;
            result.addAll(localGenerates);
        }
        return result;
    }

    @Override
    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        ArrayList<? extends IRfActionBlockElement> result = new ArrayList<IRfActionBlockElement>();
        for (RfGenerateBlock member : this.listMembers) {
            Collection<? extends IRfActionBlockElement> localActionBlocks = member.getLocalActionBlocks();
            if (localActionBlocks == null || localActionBlocks.isEmpty()) continue;
            result.addAll(localActionBlocks);
        }
        return result;
    }

    @Override
    public String getCustomName() {
        return this.getName();
    }

    @Override
    public String elementPathName() {
        return this.getName();
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        if (classes != null && !classes.contains(RfGenerateBlock.class)) {
            return null;
        }
        for (RfGenerateBlock member : this.listMembers) {
            if (!member.elementPathName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public static String getSimpleName(String fullName) {
        int index = fullName.indexOf("@g:");
        return index > 0 ? fullName.substring(0, index) : fullName;
    }

    @Override
    @NotNull
    public Collection<RfNamedElement> getMembers() {
        return new ArrayList<RfNamedElement>(this.listMembers);
    }

    @Override
    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfGenerateBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingScope(clazz);
        }
        return null;
    }

    @Override
    public String getEnclosingScopeName(Class<?> ... classes) {
        RfGenerateBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingScopeName(classes);
        }
        return null;
    }

    @Override
    public RfLibrary getEnclosingLibrary() {
        RfGenerateBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingLibrary();
        }
        return null;
    }

    @Override
    public LibraryPackageScope getLibPkgScope() {
        RfGenerateBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getLibPkgScope();
        }
        return null;
    }

    @Override
    public int getInducedParametricDependencyValue() {
        return 15;
    }
}

