/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELCore;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELBindElementPath;
import ro.amiq.dvt.elaboration.model.ELDimension;
import ro.amiq.dvt.elaboration.model.ELLiblist;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.BaseConfigInfo;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.GenericValueUtils;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedGate;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class RfInstance
extends RfField
implements IRfInstanceElement {
    private static final long serialVersionUID = 2L;
    private static final String INSTANCE_TARGET_SCOPE_TAG = "@ts:";
    private transient RfHidHolder fHidHolder;

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.cleanPreElabTransientType();
    }

    public void cleanPreElabTransientType() {
        this.resetResolvedType();
    }

    public static RfInstance create(String name, boolean escaped, DataType dataType, int qualifiers, String targetScope, List<IHidObject> targetInstances) {
        if (targetScope == null && targetInstances == null) {
            return new RfInstance(name, escaped, dataType, qualifiers);
        }
        return new RfBindInstance(name, escaped, dataType, qualifiers, targetScope, targetInstances);
    }

    public static RfInstance create(RfInstance instance) {
        if (instance instanceof RfBindInstance) {
            return new RfBindInstance((RfBindInstance)instance);
        }
        return new RfInstance(instance);
    }

    private RfInstance(String name, boolean escaped, DataType type, int qualifiers) {
        super(name, escaped, type, 64, qualifiers, null);
    }

    private RfInstance(RfInstance instance) {
        this(instance.getName(), instance.isEscaped(), instance.getDataType(), instance.getQualifiers());
    }

    public void init(DataType type, String targetScope, List<IHidObject> targetInstances) {
        super.init(type, 64, 0, null);
    }

    public IRfDesignElement getInstantiatedDesign() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        IRfDesignElement candidate = this.getDesignWithPrefix(dataType.fType, 1);
        return candidate;
    }

    @Override
    public synchronized void internalSetTransientAssociatedType(IRfNamedElement associatedType) {
        if (associatedType == null || associatedType instanceof RfInstanceList) {
            return;
        }
        IRfNamedElement resolvedType = this.internalGetTransientAssociatedType();
        if (resolvedType != null) {
            return;
        }
        this.setDependencies(associatedType, null);
        super.internalSetTransientAssociatedType(associatedType);
    }

    public List<TargetInstance> getTargetInstances() {
        return null;
    }

    public IRfNamedElement getCachedBindResult() {
        return null;
    }

    @Override
    public String getKey() {
        return super.getKey();
    }

    public void addTargetIdentifiers(IHidHolder updater) {
        this.updateHolder(updater);
    }

    @Override
    public String getAssociatedTypeName(IRfScopeElement scope, RfTypesResolver typesResolver, int qualifiedNameOptions, boolean useDataType, boolean keepMacros, boolean noDimensionsForArrayOfInstances) {
        RfFileDef file;
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return "";
        }
        if (noDimensionsForArrayOfInstances) {
            return dataType.fType;
        }
        ParserPath path = null;
        if (keepMacros && (file = this.getFile()) != null) {
            path = file.getParserPath();
        }
        return dataType.getTypeName(this.implicitSpecificTypeName(), null, path, false, keepMacros, true);
    }

    @Override
    protected RfNamedElement[] internalGetLocalMembersKind(Set<IRfNamedElement> visited, Class<? extends IRfNamedElement> localMembersKind, int localMemebersSelect, String prefix, int matchType) {
        if (localMembersKind != RfGenerateBlock.class && localMembersKind != RfInstance.class && localMembersKind != RfBindInstance.class) {
            return super.internalGetLocalMembersKind(visited, localMembersKind, localMemebersSelect, prefix, matchType);
        }
        IRfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfListType) {
            assocType = ((RfListType)assocType).getAssociatedType();
        }
        if (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getTranslatedType();
        }
        if (assocType == null || !(assocType instanceof RfParamsHolder)) {
            return null;
        }
        return ((RfParamsHolder)assocType).internalGetLocalMembersKind(visited, localMembersKind, localMemebersSelect, prefix, matchType);
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
        if (clazz != RfGenerateBlock.class && clazz != RfInstance.class && clazz != RfBindInstance.class) {
            return super.getLocalMember(clazz, name, rawMembers);
        }
        IRfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfListType) {
            assocType = ((RfListType)assocType).getAssociatedType();
        }
        if (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getTranslatedType();
        }
        if (assocType == null || !(assocType instanceof RfParamsHolder)) {
            return null;
        }
        return ((RfParamsHolder)assocType).getLocalMember(clazz, name, rawMembers);
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        if (clazz != RfGenerateBlock.class && clazz != RfInstance.class && clazz != RfBindInstance.class) {
            return super.getLocalMembers(clazz);
        }
        IRfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfListType) {
            assocType = ((RfListType)assocType).getAssociatedType();
        }
        if (assocType instanceof RfTypeAlias) {
            assocType = ((RfTypeAlias)assocType).getTranslatedType();
        }
        if (assocType == null || !(assocType instanceof RfParamsHolder)) {
            return null;
        }
        return ((RfParamsHolder)assocType).getLocalMembers(clazz);
    }

    private Supplier<ELSpecialization.InterfacePortInstance> computeInterfacePortConnection(IRfPortElement interfacePort, ListContainer<IHidObject> rhValues, ELWidthCheckContext context) {
        if (interfacePort == null || rhValues == null || rhValues.isEmpty() || context == null) {
            return null;
        }
        IHidObject signalHidObject = (IHidObject)rhValues.get(0);
        if (!HidUtils.isHid((IHidObject)signalHidObject)) {
            return null;
        }
        final Hid signalHid = (Hid)signalHidObject;
        final ELManager manager = context.getManager();
        final ElementPath instanceHierarchyPath = context.getFirstPath(true);
        final ElementPath contextHierarchyPath = ElementPath.upperPathOf((ElementPath)instanceHierarchyPath);
        return new Supplier<ELSpecialization.InterfacePortInstance>(){
            private ELSpecialization.InterfacePortInstance fCachedInstance;

            @Override
            public ELSpecialization.InterfacePortInstance get() {
                if (this.fCachedInstance != null) {
                    return this.fCachedInstance;
                }
                IRfNamedElement element = signalHid.getElement();
                if (element instanceof RfPort) {
                    ELInstance portSourceInstance = null;
                    if (signalHid.getParentAccess() != null) {
                        ElementPath relativeHierarchyPath = ElementPath.upperPathOf((ElementPath)ElementPath.from((String)HidUtils.toStringBuilder((IHidObject)signalHid, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false).toString(), (String)"."));
                        portSourceInstance = ELUtils.resolvePathToInstance((ElementPath)contextHierarchyPath, (ElementPath)relativeHierarchyPath, (ELManager)manager, (boolean)true);
                    } else {
                        ElementPath portSourcePath = ELUtils.upperPathOfIgnoreGenerates((ElementPath)instanceHierarchyPath, (IELMemory)manager.getMemory());
                        portSourceInstance = manager.safeMemInstanceFor(portSourcePath);
                    }
                    if (portSourceInstance == null) {
                        return null;
                    }
                    this.fCachedInstance = portSourceInstance.getInterfacePortInstance(element.getName());
                    return this.fCachedInstance;
                }
                if (element instanceof RfInstance || element instanceof RfModport) {
                    ELInstance portInstance = null;
                    ElementPath relativeHierarchyPath = ElementPath.from((String)HidUtils.toStringBuilder((IHidObject)signalHid, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false).toString(), (String)".");
                    if (element instanceof RfModport) {
                        relativeHierarchyPath = ElementPath.upperPathOf((ElementPath)relativeHierarchyPath);
                    }
                    if ((portInstance = ELUtils.resolvePathToInstance((ElementPath)contextHierarchyPath, (ElementPath)relativeHierarchyPath, (ELManager)manager, (boolean)true)) == null) {
                        return null;
                    }
                    this.fCachedInstance = new ELSpecialization.InterfacePortInstance(portInstance, element instanceof RfModport ? element.getName() : null);
                    return this.fCachedInstance;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeInterfacePortConnections(List<HidOperatorWrapper> portConnections, IRfDesignElement instanceType, ELWidthCheckContext context, ELInstance instance) {
        List<IRfPortElement> portsNoAliasesList;
        List portList;
        if (DesignUtils.getDesignKind((Object)instanceType) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            instanceType = ((IRfEntityComplement)instanceType).getEntity();
        }
        if (instanceType == null || instanceType.hasNoDefs(true)) {
            return;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (portConnections == null) {
            portConnections = Collections.emptyList();
        }
        if ((portList = instanceType.getLocalPorts()) == null) {
            portList = Collections.emptyList();
        }
        if ((portsNoAliasesList = instanceType.getLocalPortsNoAliases()) == null) {
            portsNoAliasesList = Collections.emptyList();
        }
        boolean isVHDLCaseInsensitive = LanguageKind.VHDL == instanceType.getLanguageKind();
        IRfNamedElement closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        LinkedHashMap<String, IRfPortElement> portsNoAliasesMap = new LinkedHashMap<String, IRfPortElement>(OptimizedUtils.noRehashSize((int)portsNoAliasesList.size()));
        for (IRfPortElement port : portsNoAliasesList) {
            String key = port.getName();
            if (isVHDLCaseInsensitive) {
                key = key.toLowerCase();
            }
            portsNoAliasesMap.put(key, port);
            closestTypeContainer.addReferenceToIdentifierName(key);
        }
        int index = -1;
        HidOperator dotStarConnection = null;
        LinkedHashSet remaining = new LinkedHashSet(portsNoAliasesMap.keySet());
        for (HidOperatorWrapper hidOperatorWrapper : portConnections) {
            HidOperator portConnection;
            ++index;
            HidOperator hidOperator = portConnection = (HidOperator)hidOperatorWrapper.hidObject;
            synchronized (hidOperator) {
                String portName;
                IRfPortElement portElement;
                if (context != null) {
                    IHidObject actualPart = AssociationUtils.getActualPartRaw((IHidObject)portConnection, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
                    ElementPath hierarchyPath = context.getFirstPath(false);
                    RfNamedElement originElement = this instanceof RfBindInstance ? this : this.getEnclosingScope();
                    IHidEvaluator evaluator = context.getEvaluatorForPortConnections(false);
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.PORT_CONNECTION, (IRfNamedElement)originElement, (ElementPath)hierarchyPath, (boolean)false, (ELManager)evaluator.getManager());
                    Predicate<IHidObject> result = partHidObject -> {
                        evaluator.resolveHidInContext(partHidObject, guardian, false);
                        return true;
                    };
                    HidUtils.flattenToObjects(result, (IHidObject)actualPart, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
                if (PortConnectionUtils.isDotStarConnected((IHidOperator)portConnection)) {
                    dotStarConnection = portConnection;
                    continue;
                }
                if (PortConnectionUtils.isOrdered((IHidOperator)portConnection)) {
                    if (index >= portsNoAliasesList.size()) {
                        continue;
                    }
                    portElement = portsNoAliasesList.get(index);
                    portName = portElement.getName();
                    if (portName == null || portName.isEmpty()) {
                        continue;
                    }
                } else {
                    portName = PortConnectionUtils.getPortName((IHidOperator)portConnection);
                    portElement = (IRfPortElement)portsNoAliasesMap.get(portName);
                    if (portElement == null) {
                        continue;
                    }
                }
                if (isVHDLCaseInsensitive) {
                    portName = portName.toLowerCase();
                }
                remaining.remove(portName);
                if (!portElement.isInterfacePort()) {
                    continue;
                }
                Supplier<ELSpecialization.InterfacePortInstance> actualInterfaceSupplier = this.computeInterfacePortConnection(portElement, (ListContainer<IHidObject>)portConnection.getRHValues(), context);
                if (actualInterfaceSupplier != null) {
                    instance.addInterfacePortInstance(portElement.getName(), actualInterfaceSupplier);
                }
            }
        }
        if (dotStarConnection != null) {
            HidOperatorOccurrence hidOperatorOccurrence = dotStarConnection.getOccurrence();
            for (String portName : remaining) {
                IRfNamedElement connectedElement;
                IRfPortElement portElement = (IRfPortElement)portsNoAliasesMap.get(portName);
                if (portElement == null || !portElement.isInterfacePort() || (connectedElement = this.findIsDeclaredSignal(portName)) == null) continue;
                List<HidOperator> associations = STransformer.INSTANCE.transformImplicitNamedConnection(null, (IRfNamedElement)portElement, connectedElement, hidOperatorOccurrence);
                for (HidOperator association : associations) {
                    Supplier<ELSpecialization.InterfacePortInstance> actualInterfaceSupplier = this.computeInterfacePortConnection(portElement, (ListContainer<IHidObject>)association.getRHValues(), context);
                    if (actualInterfaceSupplier == null) continue;
                    instance.addInterfacePortInstance(portElement.getName(), actualInterfaceSupplier);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPortConnections(List<HidOperatorWrapper> portConnections, IRfDesignElement instanceType, ELWidthCheckContext context, boolean triggerError, boolean isIrunRNMTech, boolean elabWidthCheckDisabled, boolean elabWidthCheckFiltered, BaseConfigInfo configInfoRaw) {
        int nofPorts;
        List<IRfPortElement> portsNoAliasesList;
        List portList;
        if (DesignUtils.getDesignKind((Object)instanceType) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            instanceType = ((IRfEntityComplement)instanceType).getEntity();
        }
        if (instanceType == null || instanceType.hasNoDefs(true) || configInfoRaw == null) {
            return;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (portConnections == null) {
            portConnections = Collections.emptyList();
        }
        if ((portList = instanceType.getLocalPorts()) == null) {
            portList = Collections.emptyList();
        }
        if ((portsNoAliasesList = instanceType.getLocalPortsNoAliases()) == null) {
            portsNoAliasesList = Collections.emptyList();
        }
        IRfNamedElement closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        boolean isVHDLCaseInsensitive = LanguageKind.VHDL == instanceType.getLanguageKind();
        LinkedHashMap<String, IRfPortElement> portsNoAliasesMap = new LinkedHashMap<String, IRfPortElement>(OptimizedUtils.noRehashSize((int)portsNoAliasesList.size()));
        for (IRfPortElement port : portsNoAliasesList) {
            String key = port.getName();
            if (isVHDLCaseInsensitive) {
                key = key.toLowerCase();
            }
            portsNoAliasesMap.put(key, port);
            closestTypeContainer.addReferenceToIdentifierName(key);
        }
        HidOperator dotStarConnection = null;
        int index = -1;
        int nofOrdered = 0;
        LinkedHashSet<String> remaining = new LinkedHashSet<String>(portsNoAliasesMap.keySet());
        boolean isCheckerInstance = instanceType instanceof RfChecker;
        boolean isUDPInstance = instanceType instanceof RfPrimitive;
        ConfigInfo configInfo = new ConfigInfo(configInfoRaw);
        configInfo.setElabContext(context);
        configInfo.setElabWidthCheckDisabled(elabWidthCheckDisabled);
        configInfo.setElabWidthCheckFiltered(elabWidthCheckFiltered);
        for (HidOperatorWrapper hidOperatorWrapper : portConnections) {
            HidOperator portConnection;
            ++index;
            HidOperator hidOperator = portConnection = (HidOperator)hidOperatorWrapper.hidObject;
            synchronized (hidOperator) {
                portConnection.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
                if (PortConnectionUtils.isDotStarConnected((IHidOperator)portConnection)) {
                    dotStarConnection = portConnection;
                    if (isUDPInstance) {
                        this.addUDPPortConnectionError(portConnection, ".*", this.getName(), true, rfProject, triggerError);
                    }
                    continue;
                }
                if (context != null) {
                    IHidObject actualPart = AssociationUtils.getActualPartRaw((IHidObject)portConnection, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
                    ElementPath hierarchyPath = context.getFirstPath(false);
                    RfNamedElement originElement = this instanceof RfBindInstance ? this : this.getEnclosingScope();
                    IHidEvaluator evaluator = context.getEvaluatorForPortConnections(false);
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.PORT_CONNECTION, (IRfNamedElement)originElement, (ElementPath)hierarchyPath, (boolean)false, (ELManager)evaluator.getManager());
                    Predicate<IHidObject> result = partHidObject -> {
                        evaluator.resolveHidInContext(partHidObject, guardian, false);
                        return true;
                    };
                    HidUtils.flattenToObjects(result, (IHidObject)actualPart, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
                if (PortConnectionUtils.isOrdered((IHidOperator)portConnection)) {
                    ++nofOrdered;
                    if (index >= portsNoAliasesList.size()) {
                        continue;
                    }
                    IRfPortElement portElement = portsNoAliasesList.get(index);
                    String portName = portElement.getName();
                    if (portName == null || portName.isEmpty()) {
                        continue;
                    }
                    if (isVHDLCaseInsensitive) {
                        portName = portName.toLowerCase();
                    }
                    remaining.remove(portName);
                    SEvaluator.INSTANCE.calculateAssociation(portConnection, (IRfNamedElement)portElement, this, configInfo, hidOperatorWrapper.path, null, triggerError, isIrunRNMTech);
                    if (portElement.isInput() && PortConnectionUtils.isUnconnected((IHidOperator)portConnection)) {
                        this.addUndrivenInputPortWarning(portConnection, portElement, hidOperatorWrapper.path, false, rfProject, triggerError);
                    }
                } else {
                    IHid portHid;
                    boolean notFound;
                    String portName = PortConnectionUtils.getPortName((IHidOperator)portConnection);
                    if (portName == null || portName.isEmpty()) {
                        continue;
                    }
                    if (isUDPInstance) {
                        this.addUDPPortConnectionError(portConnection, portName, this.getName(), false, rfProject, triggerError);
                    }
                    if (isVHDLCaseInsensitive) {
                        portName = portName.toLowerCase();
                    }
                    IRfPortElement port = (IRfPortElement)portsNoAliasesMap.get(portName);
                    boolean hasError = false;
                    if (port == null) {
                        hasError = true;
                        closestTypeContainer.addReferenceToIdentifierName(portName);
                        if (triggerError) {
                            int offsetStart = PortConnectionUtils.getOffset((IHidOperator)portConnection);
                            int offsetEnd = offsetStart + portName.length();
                            int line = PortConnectionUtils.getLine((IHidOperator)portConnection);
                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", portName);
                            attributes.put("QUICKFIX_KIND", 35);
                            attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
                            List possiblePorts = portList.size() != portsNoAliasesList.size() ? instanceType.getPortsWithPrefix(portName, 2) : null;
                            String nonExistingErrorMessage = possiblePorts != null && !possiblePorts.isEmpty() ? "NOT_IN_LIST_OF_PORTS: ''{0}'' not in the list of ''{1}'' ports" : "NON_EXISTING_PORT: Non existing port ''{0}'' of module ''{1}''";
                            rfProject.addSemanticError(1, nonExistingErrorMessage, this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, hidOperatorWrapper.path, portName, instanceType.getName());
                        }
                    }
                    if (!(notFound = remaining.remove(portName)) && !hasError && triggerError) {
                        int offsetStart = PortConnectionUtils.getOffset((IHidOperator)portConnection);
                        int offsetEnd = offsetStart + portName.length();
                        int line = PortConnectionUtils.getLine((IHidOperator)portConnection);
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", portName);
                        attributes.put("QUICKFIX_KIND", 43);
                        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
                        rfProject.addSemanticError(1, "MULTIPLE_PORT_CONNECTIONS: Multiple connections to port ''{0}''", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, hidOperatorWrapper.path, portName);
                    }
                    IRfNamedElement connectedSignal = null;
                    boolean implicitNamedConnected = PortConnectionUtils.isImplicitNamedConnected((IHidOperator)portConnection);
                    if (implicitNamedConnected && !isCheckerInstance) {
                        portHid = PortConnectionUtils.getPortHid((IHidOperator)portConnection);
                        connectedSignal = this.findIsDeclaredSignal(portHid.getName());
                        if (triggerError && connectedSignal == null) {
                            int offsetStart = PortConnectionUtils.getOffset((IHidOperator)portConnection);
                            int offsetEnd = offsetStart + portName.length();
                            int line = PortConnectionUtils.getLine((IHidOperator)portConnection);
                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", portHid.getName());
                            attributes.put("QUICKFIX_KIND", 18);
                            rfProject.addSemanticError(1, "IMPLICIT_PORT_CONNECTION: Cannot infer implicit connection for port(s) ''{0}''", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, hidOperatorWrapper.path, portHid.getName());
                        }
                    }
                    if (port != null && !hasError) {
                        if (!implicitNamedConnected) {
                            SEvaluator.INSTANCE.calculateAssociation(portConnection, (IRfNamedElement)port, this, configInfo, hidOperatorWrapper.path, null, triggerError, isIrunRNMTech);
                        } else {
                            SEvaluator.INSTANCE.calculateImplicitNamedAssociation(portConnection, port, connectedSignal, this, portConnection.getOccurrence(), configInfo, hidOperatorWrapper.path, triggerError, isIrunRNMTech);
                        }
                        if (port.isInput() && PortConnectionUtils.isUnconnected((IHidOperator)portConnection)) {
                            this.addUndrivenInputPortWarning(portConnection, port, hidOperatorWrapper.path, true, rfProject, triggerError);
                        }
                    } else {
                        portHid = PortConnectionUtils.getPortHid((IHidOperator)portConnection);
                        IRfNamedElement element = portHid.getElement();
                        if (element != null && element.hasNoDefs(false)) {
                            ((Hid)portHid).setElement(null);
                        }
                    }
                }
            }
        }
        if (dotStarConnection != null && !remaining.isEmpty()) {
            this.checkDotStarConnection(dotStarConnection, portsNoAliasesMap, configInfo, remaining, triggerError, isIrunRNMTech);
            return;
        }
        int n = portConnections.size();
        if (n < (nofPorts = portsNoAliasesList.size()) || !remaining.isEmpty()) {
            if (!triggerError) {
                return;
            }
            int nofInputs = 0;
            int nofOutputs = 0;
            int nofInouts = 0;
            int nofRefs = 0;
            int nofInterfaces = 0;
            StringJoiner inputNames = new StringJoiner(", ");
            StringJoiner outputNames = new StringJoiner(", ");
            StringJoiner inoutNames = new StringJoiner(", ");
            StringJoiner refNames = new StringJoiner(", ");
            StringJoiner interfaceNames = new StringJoiner(", ");
            for (String next : remaining) {
                IRfPortElement nextPort = (IRfPortElement)portsNoAliasesMap.get(next);
                if (nextPort == null) continue;
                if (nextPort.isInput()) {
                    if (nofInputs > 4) continue;
                    inputNames.add(nofInputs++ == 4 ? "..." : next);
                    continue;
                }
                if (nextPort.isOutput()) {
                    if (nofOutputs > 4) continue;
                    outputNames.add(nofOutputs++ == 4 ? "..." : next);
                    continue;
                }
                if (nextPort.isInout()) {
                    if (nofInouts > 4) continue;
                    inoutNames.add(nofInouts++ == 4 ? "..." : next);
                    continue;
                }
                if (nextPort.isRef()) {
                    if (nofRefs > 4) continue;
                    refNames.add(nofRefs++ == 4 ? "..." : next);
                    continue;
                }
                if (nextPort.isInterfacePort()) {
                    if (nofInterfaces > 4) continue;
                    interfaceNames.add(nofInterfaces++ == 4 ? "..." : next);
                    continue;
                }
                if (nofInouts > 4) continue;
                inoutNames.add(nofInouts++ == 4 ? "..." : next);
            }
            if (nofInputs == 0 && nofOutputs == 0 && nofInouts == 0 && nofRefs == 0 && nofInterfaces == 0) {
                return;
            }
            int offsetStart = this.getStartOffset();
            int offsetEnd = offsetStart + (instanceType.getName() != null ? instanceType.getName().length() : 1);
            int line = this.getLine();
            this.addMissingPortConnectionError(inputNames, "input", nofPorts, offsetStart, offsetEnd, line, rfProject, instanceType);
            this.addMissingPortConnectionError(outputNames, "output", nofPorts, offsetStart, offsetEnd, line, rfProject, instanceType);
            this.addMissingPortConnectionError(inoutNames, "inout", nofPorts, offsetStart, offsetEnd, line, rfProject, instanceType);
            this.addMissingPortConnectionError(refNames, "ref", nofPorts, offsetStart, offsetEnd, line, rfProject, instanceType);
            this.addMissingPortConnectionError(interfaceNames, "interface", nofPorts, offsetStart, offsetEnd, line, rfProject, instanceType);
            return;
        }
        if (nofOrdered == n) {
            this.checkExcessOrderedPortConnections(portConnections, portsNoAliasesMap, rfProject, triggerError);
        }
    }

    public List<IHidOperator> xGetPortConnections(IRfDesignElement instanceType) {
        List<HidOperator> transformAssociation;
        List portsNoAliasesList;
        ArrayList portList = null;
        boolean isPredefinedGate = instanceType instanceof RfPredefinedGate;
        if (isPredefinedGate) {
            Set portListSet = DesignUtils.getDummyPorts((IRfInstanceElement)this);
            if (portListSet == null || portListSet.isEmpty()) {
                return Collections.emptyList();
            }
            portList = new ArrayList(portListSet);
        } else {
            portList = instanceType.getLocalPorts();
            if (portList == null || portList.isEmpty()) {
                return Collections.emptyList();
            }
        }
        List portConnections = HidOperatorVisitorWithPaths.getHidOperators((IRfNamedElement)this, (HidOperatorQualifier[])ELConstants.PORT_CONNECTIONS_QUALIFIERS_ARRAY, (boolean)true);
        if (portConnections == null || portConnections.isEmpty()) {
            return Collections.emptyList();
        }
        List list = portsNoAliasesList = isPredefinedGate ? portList : instanceType.getLocalPortsNoAliases();
        if (portsNoAliasesList == null || portsNoAliasesList.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isVHDLCaseInsensitive = LanguageKind.VHDL == instanceType.getLanguageKind();
        LinkedHashMap<String, IRfPortElement> portsNoAliasesMap = new LinkedHashMap<String, IRfPortElement>(OptimizedUtils.noRehashSize((int)portsNoAliasesList.size()));
        for (IRfPortElement port : portsNoAliasesList) {
            String key = port.getName();
            if (isVHDLCaseInsensitive) {
                key = key.toLowerCase();
            }
            portsNoAliasesMap.put(key, port);
        }
        HidOperator dotStarConnection = null;
        int index = -1;
        LinkedHashSet remaining = new LinkedHashSet(portsNoAliasesMap.keySet());
        boolean isCheckerInstance = DesignUtils.getDesignKind((Object)instanceType) == IRfNamedElement.ElementKind.VLOG_CHECKER;
        ArrayList<IHidOperator> result = new ArrayList<IHidOperator>(portConnections.size());
        for (HidOperatorWrapper portConnectionWrapper : portConnections) {
            List<HidOperator> transformAssociation2;
            IRfPortElement port;
            ++index;
            HidOperator portConnection = (HidOperator)portConnectionWrapper.hidObject;
            if (PortConnectionUtils.isDotStarConnected((IHidOperator)portConnection)) {
                dotStarConnection = portConnection;
                continue;
            }
            if (PortConnectionUtils.isOrdered((IHidOperator)portConnection)) {
                IRfPortElement portElement;
                String portName;
                if (index >= portsNoAliasesList.size() || (portName = (portElement = (IRfPortElement)portsNoAliasesList.get(index)).getName()) == null || portName.isEmpty()) continue;
                if (isVHDLCaseInsensitive) {
                    portName = portName.toLowerCase();
                }
                remaining.remove(portName);
                transformAssociation = STransformer.INSTANCE.transformAssociation(portConnection, (IRfNamedElement)portElement, this);
                result.addAll(transformAssociation);
                continue;
            }
            String portName = PortConnectionUtils.getPortName((IHidOperator)portConnection);
            if (portName == null || portName.isEmpty()) continue;
            if (isVHDLCaseInsensitive) {
                portName = portName.toLowerCase();
            }
            if ((port = (IRfPortElement)portsNoAliasesMap.get(portName)) == null) continue;
            remaining.remove(portName);
            IRfNamedElement connectedSignal = null;
            boolean implicitNamedConnected = PortConnectionUtils.isImplicitNamedConnected((IHidOperator)portConnection);
            if (implicitNamedConnected && !isCheckerInstance) {
                IHid portHid = PortConnectionUtils.getPortHid((IHidOperator)portConnection);
                connectedSignal = this.findIsDeclaredSignal(portHid.getName());
            }
            if (!implicitNamedConnected) {
                transformAssociation2 = STransformer.INSTANCE.transformAssociation(portConnection, (IRfNamedElement)port, this);
                result.addAll(transformAssociation2);
                continue;
            }
            transformAssociation2 = STransformer.INSTANCE.transformImplicitNamedConnection(portConnection, (IRfNamedElement)port, connectedSignal, portConnection.getOccurrence());
            result.addAll(transformAssociation2);
        }
        if (dotStarConnection != null && dotStarConnection.getOccurrence() != null && !remaining.isEmpty()) {
            HidOperatorOccurrence operatorOccurrence = dotStarConnection.getOccurrence();
            for (String remainingPortName : remaining) {
                IRfPortElement port = (IRfPortElement)portsNoAliasesMap.get(remainingPortName);
                IRfNamedElement connectedElement = this.findIsDeclaredSignal(remainingPortName);
                if (connectedElement == null) continue;
                transformAssociation = STransformer.INSTANCE.transformImplicitNamedConnection(null, (IRfNamedElement)port, connectedElement, operatorOccurrence);
                result.addAll(transformAssociation);
            }
        }
        return result;
    }

    private void addUndrivenInputPortWarning(HidOperator portConnection, IRfPortElement portElement, ParserPath path, boolean isNamed, IRfSingleLangProject rfProject, boolean triggerError) {
        if (!triggerError) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_KIND", 46);
        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
        String name = portElement.getName();
        int offsetStart = PortConnectionUtils.getOffset((IHidOperator)portConnection);
        int offsetEnd = offsetStart + (isNamed ? name.length() : 1);
        int line = PortConnectionUtils.getLine((IHidOperator)portConnection);
        rfProject.addSemanticError(2, "UNDRIVEN_INPUT_PORT: Input port ''{0}'' is not driven", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, path, new Object[]{name});
    }

    private void addMissingPortConnectionError(StringJoiner st, String portType, int nofPorts, int offsetStart, int offsetEnd, int line, IRfSingleLangProject rfProject, IRfDesignElement instanceType) {
        if (st.length() == 0) {
            return;
        }
        RfFileDef file = this.getFile();
        ParserPath path = file != null ? file.getParserPath() : null;
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_ELEMENT_NAME", Integer.toString(nofPorts));
        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
        attributes.put("QUICKFIX_KIND", 38);
        rfProject.addSemanticError(2, "MISSING_PORT_CONNECTION: Instance ''{0}'' of {1} ''{2}'' is missing port connection to {4} ''{3}''", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, path, new Object[]{this.getName(), DesignUtils.getDesignKindInstanceText((IRfScopeElement)instanceType), instanceType.getName(), st.toString(), portType});
    }

    private void checkExcessOrderedPortConnections(List<HidOperatorWrapper> portConnections, Map<String, IRfPortElement> ports, IRfSingleLangProject rfProject, boolean triggerError) {
        if (!triggerError) {
            return;
        }
        int nofPorts = 0;
        for (IRfPortElement port : ports.values()) {
            Collection declarations = port.getDeclarations();
            if (declarations == null) continue;
            if (!(port instanceof RfNamedElement)) {
                nofPorts += declarations.size();
                continue;
            }
            for (IRfDefElement declaration : declarations) {
                if (!(declaration instanceof RfPortDef) || !((RfPortDef)declaration).isInListOfPorts()) continue;
                ++nofPorts;
            }
        }
        int nofPortConnections = portConnections.size();
        if (nofPortConnections > nofPorts) {
            RfFileDef file = this.getFile();
            ParserPath path = file != null ? file.getParserPath() : null;
            DataType dataType = this.getDataType();
            if (dataType == null) {
                return;
            }
            int offsetStart = dataType.getOffset();
            int offsetEnd = offsetStart + (dataType.getType() != null ? dataType.getType().length() : 1);
            int line = this.getLine();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", Integer.toString(nofPorts));
            attributes.put("QUICKFIX_KIND", 17);
            rfProject.addSemanticError(1, "NOF_PORT_CONNECTIONS: Expected {0} port connections, found {1}", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, path, new Object[]{nofPorts, nofPortConnections});
        }
    }

    private void checkDotStarConnection(HidOperator dotStarConnection, Map<String, IRfPortElement> portsAllMap, ConfigInfo configInfo, Set<String> remaining, boolean triggerError, boolean isIrunRNMTech) {
        StringJoiner st;
        int i;
        HidOperatorOccurrence operatorOccurrence = dotStarConnection.getOccurrence();
        if (operatorOccurrence == null) {
            return;
        }
        RfFileDef file = this.getFile();
        ParserPath path = file != null ? file.getParserPath() : null;
        Iterator<String> it = remaining.iterator();
        boolean hasEmptyUnconnected = false;
        while (it.hasNext()) {
            String remainingPortName = it.next();
            IRfPortElement port = portsAllMap.get(remainingPortName);
            IRfNamedElement connectedElement = this.findIsDeclaredSignal(remainingPortName);
            if (connectedElement != null) {
                SEvaluator.INSTANCE.calculateImplicitNamedAssociation(null, port, connectedElement, this, operatorOccurrence, configInfo, path, triggerError, isIrunRNMTech);
                it.remove();
                continue;
            }
            if (hasEmptyUnconnected) continue;
            boolean bl = hasEmptyUnconnected = port instanceof RfPort && ((RfPort)port).isEmptyPort();
        }
        if (!triggerError || remaining.isEmpty()) {
            return;
        }
        int offsetStart = operatorOccurrence.getOffset();
        int offsetEnd = offsetStart + 2;
        int line = operatorOccurrence.getLine();
        if (hasEmptyUnconnected) {
            i = 0;
            st = new StringJoiner(", ");
            it = remaining.iterator();
            while (it.hasNext()) {
                String remainingPortName = it.next();
                IRfPortElement port = portsAllMap.get(remainingPortName);
                if (!(port instanceof RfPort) || !((RfPort)port).isEmptyPort()) continue;
                it.remove();
                if (i++ < 4) {
                    st.add(remainingPortName);
                    continue;
                }
                if (i != 4) continue;
                st.add("...");
            }
            RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
            rfProject.addSemanticError(2, RfSemanticError.NON_STANDARD_EMPTY_PORT_IMPLICIT_CONNECTION, this.getLibPkgScope(), offsetStart, offsetEnd, null, line, path, st.toString());
        }
        if (remaining.isEmpty()) {
            return;
        }
        i = 0;
        it = remaining.iterator();
        st = new StringJoiner(", ");
        while (it.hasNext() && i++ < 4) {
            st.add(it.next());
        }
        if (it.hasNext()) {
            st.add("...");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_ELEMENT_NAME", "");
        attributes.put("QUICKFIX_KIND", 18);
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.addSemanticError(1, "IMPLICIT_PORT_CONNECTION: Cannot infer implicit connection for port(s) ''{0}''", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, path, st.toString());
    }

    private void addUDPPortConnectionError(HidOperator portConnection, String portName, String instanceName, boolean isDotStar, IRfSingleLangProject rfProject, boolean triggerError) {
        if (!triggerError) {
            return;
        }
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
        attributes.put("QUICKFIX_KIND", 65);
        RfFileDef file = this.getFile();
        ParserPath path = file != null ? file.getParserPath() : null;
        int offsetStart = PortConnectionUtils.getOffset((IHidOperator)portConnection);
        int offsetEnd = offsetStart + portName.length();
        int line = PortConnectionUtils.getLine((IHidOperator)portConnection);
        rfProject.addSemanticError(1, isDotStar ? "UDP_PORT_CONNECTION: Dot star connection not allowed for UDP instance ''{0}''" : "UDP_PORT_CONNECTION: Named port connection to ''{1}'' not allowed for UDP instance ''{0}''", this.getLibPkgScope(), offsetStart, offsetEnd, attributes, line, path, new Object[]{instanceName, portName});
    }

    private IRfNamedElement findIsDeclaredSignal(String name) {
        IRfNamedElement instanceScope;
        if (name == null) {
            return null;
        }
        Object object = instanceScope = this.isInstanceToBind() ? this.getBindInstanceScope() : this.getEnclosingScope();
        if (instanceScope == null || instanceScope == this) {
            return null;
        }
        IRfNamedElement result = null;
        if (instanceScope instanceof RfNamedElement) {
            result = ((RfNamedElement)instanceScope).getMember(name, RfInstanceHolder.IMPLICIT_SIGNALS, null, true, true, false, false, false);
        } else {
            IRfDesignElement architecture;
            result = instanceScope.getSignalWithPrefix(name, 1);
            if (result != null) {
                return result;
            }
            result = instanceScope.getInstanceWithPrefix(name, 1);
            if (result != null) {
                return result;
            }
            if (instanceScope instanceof IRfDesignElement && (architecture = ((IRfDesignElement)instanceScope).getArchitecture()) != null) {
                result = architecture.getSignalWithPrefix(name, 1);
            }
        }
        if (!this.isInstanceToBind()) {
            return result;
        }
        return this.findIsDeclaredBoundInstance(result, name, instanceScope);
    }

    private IRfNamedElement findIsDeclaredBoundInstance(IRfNamedElement result, String name, IRfNamedElement instanceScope) {
        if (!this.isInstanceToBind() || instanceScope == null) {
            return null;
        }
        if (result instanceof IRfFieldElement || result instanceof IRfMethodElement || result instanceof IRfInstanceElement || result instanceof RfModport) {
            return result;
        }
        RfLibrary library = this.getEnclosingLibrary();
        List<RfInstance> bindInstances = library.getBindInstances(name, null);
        if (bindInstances != null) {
            String targetScope = this.getTargetScope();
            List<TargetInstance> targetInstances = this.getTargetInstances();
            String scopeName = instanceScope.getName();
            for (RfInstance bindInstance : bindInstances) {
                if (bindInstance == this) continue;
                for (TargetInstance targetInstance : targetInstances) {
                    if (!bindInstance.isTargetInstance(true, null, targetInstance.targetNoSelect, targetInstance.targetNoSelect.lastSegment())) continue;
                    return bindInstance;
                }
                if (bindInstance.isTargetInstance(false, targetScope, null, null)) {
                    return bindInstance;
                }
                if (!bindInstance.isTargetInstance(false, scopeName, null, null)) continue;
                return bindInstance;
            }
        }
        return result;
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        if (DesignUtils.isUnelaboratedBindInstance((IRfInstanceElement)this)) {
            return;
        }
        IRfNamedElement bindScope = this.getBindInstanceScope();
        if (bindScope instanceof RfInstanceHolder && !((RfInstanceHolder)bindScope).getSemanticEnable()) {
            return;
        }
        super.resolveHids(configInfo, triggerError, ignoreDirty, semanticEnabled, skipMemberClasses);
    }

    @Override
    protected void resolveHidOperators(ConfigInfo configInfo, boolean triggerError, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        if (DesignUtils.isUnelaboratedBindInstance((IRfInstanceElement)this)) {
            return;
        }
        IRfNamedElement bindScope = this.getBindInstanceScope();
        if (bindScope instanceof RfInstanceHolder && !((RfInstanceHolder)bindScope).getSemanticEnable()) {
            return;
        }
        super.resolveHidOperators(configInfo, triggerError, semanticEnabled, skipMemberClasses);
    }

    public Map<String, HidOperatorWrapper> getParameterOverrides(IRfDesignElement design, Map<String, IRfNamedElement> designParamMap, boolean markElabOperators, ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> overridesCache) {
        if (design == null || design instanceof RfPrimitive) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.fParamValuesHolder == null) {
            return null;
        }
        Map localResolvedMap = overridesCache.computeIfAbsent(this.getEnclosingScope(), key -> new ConcurrentHashMap());
        List overrides = localResolvedMap.computeIfAbsent(this, key -> {
            HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY);
            dataType.fParamValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
            return visitor.getObjectsWithPaths();
        });
        return RfInstance.internalGetParameterOverrides(design, designParamMap, markElabOperators, overrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkParameterOverrides(Map<String, HidOperatorWrapper> parameterOverrides, Map<String, IRfNamedElement> portListParameters, Map<String, IRfNamedElement> instanceConstants, IRfDesignElement binding, ELWidthCheckContext context, boolean triggerError, boolean isIrunRNMTech, boolean elabWidthCheckDisabled, boolean elabWidthCheckFiltered, BaseConfigInfo configInfoRaw) {
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.fParamValuesHolder == null || parameterOverrides == null || binding == null || configInfoRaw == null || binding instanceof RfPrimitive) {
            return;
        }
        RfProject rfProject = this.getRfProject();
        if (portListParameters == null) {
            portListParameters = new OptimizedLinkedHashMap();
        }
        int nofParameters = portListParameters.size();
        ConfigInfo configInfo = new ConfigInfo(configInfoRaw);
        configInfo.setElabContext(context);
        configInfo.setElabWidthCheckDisabled(elabWidthCheckDisabled);
        configInfo.setElabWidthCheckFiltered(elabWidthCheckFiltered);
        IRfNamedElement closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        LibraryPackageScope libPackageScope = null;
        boolean hasNamedConnections = false;
        int index = -1;
        for (Map.Entry<String, HidOperatorWrapper> entry : parameterOverrides.entrySet()) {
            HidOperator paramValue;
            ++index;
            String paramName = entry.getKey();
            closestTypeContainer.addReferenceToIdentifierName(paramName);
            HidOperatorWrapper wrapper = entry.getValue();
            HidOperator hidOperator = paramValue = (HidOperator)wrapper.hidObject;
            synchronized (hidOperator) {
                paramValue.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
                if (context != null) {
                    IHidObject actualPart = AssociationUtils.getActualPartRaw((IHidObject)paramValue, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
                    ElementPath hierarchyPath = context.getFirstPath(false);
                    RfNamedElement originElement = this instanceof RfBindInstance ? this : this.getEnclosingScope();
                    IHidEvaluator evaluator = context.getEvaluatorForPortConnections(false);
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.PARAM_OVERRIDE, (IRfNamedElement)originElement, (ElementPath)hierarchyPath, (boolean)false, (ELManager)evaluator.getManager());
                    Predicate<IHidObject> result = partHidObject -> {
                        evaluator.resolveHidInContext(partHidObject, guardian, false);
                        return true;
                    };
                    HidUtils.flattenToObjects(result, (IHidObject)actualPart, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
                ParserPath parserPath = wrapper.path;
                IRfNamedElement parameter = (IRfNamedElement)portListParameters.get(paramName);
                if (GenericValueUtils.isOrderedConnected((IHidOperator)paramValue)) {
                    if (index >= nofParameters) {
                        break;
                    }
                    SEvaluator.INSTANCE.calculateAssociation(paramValue, parameter, this, new ConfigInfo(configInfo), parserPath, null, triggerError, isIrunRNMTech);
                } else if (GenericValueUtils.isOrderedUnconnected((IHidOperator)paramValue)) {
                    String initialValue;
                    if (index >= nofParameters) {
                        break;
                    }
                    String string = initialValue = parameter instanceof IRfFieldElement ? ((IRfFieldElement)parameter).getInitialValue(false) : null;
                    if ((initialValue == null || initialValue.isEmpty()) && triggerError) {
                        if (libPackageScope == null) {
                            libPackageScope = this.getLibPkgScope();
                        }
                        int paramLine = GenericValueUtils.getLine((IHidOperator)paramValue);
                        int paramStartOffset = GenericValueUtils.getOffset((IHidOperator)paramValue);
                        int paramEndOffset = paramStartOffset + 1;
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", paramName);
                        attributes.put("QUICKFIX_KIND", 41);
                        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
                        rfProject.addSemanticError(1, "MISSING_PARAMETER_OVERRIDE: Expected override or default value for parameter ''{0}''", libPackageScope, paramStartOffset, paramEndOffset, attributes, paramLine, parserPath, paramName, binding.getName());
                    }
                } else {
                    hasNamedConnections = true;
                    if (paramName.startsWith("<")) {
                        paramName = paramName.substring(1, paramName.length() - 1);
                    }
                    if (parameter == null) {
                        int paramEndOffset;
                        String genericName = GenericValueUtils.getGenericName((IHidOperator)paramValue);
                        String parameterName = genericName != null && !genericName.isEmpty() ? genericName : paramName;
                        IRfNamedElement candidate = instanceConstants.get(paramName);
                        if (ELUtils.isVLOGParam((IRfNamedElement)candidate)) {
                            if (triggerError) {
                                if (libPackageScope == null) {
                                    libPackageScope = this.getLibPkgScope();
                                }
                                int paramLine = GenericValueUtils.getLine((IHidOperator)paramValue);
                                int paramStartOffset = GenericValueUtils.getOffset((IHidOperator)paramValue);
                                paramEndOffset = paramStartOffset + parameterName.length();
                                String message = ((IRfFieldElement)candidate).isLocalParameter() ? "NON_OVERRIDABLE_PARAMETER: Localparam ''{0}'' cannot be overridden" : "NON_OVERRIDABLE_PARAMETER: Parameter ''{0}'' cannot be overridden (is outside parameter port list)";
                                rfProject.addSemanticError(2, message, libPackageScope, paramStartOffset, paramEndOffset, null, paramLine, parserPath, parameterName, binding.getName());
                            }
                            SEvaluator.INSTANCE.calculateAssociation(paramValue, candidate, this, new ConfigInfo(configInfo), parserPath, null, triggerError, isIrunRNMTech);
                            continue;
                        }
                        if (triggerError) {
                            if (libPackageScope == null) {
                                libPackageScope = this.getLibPkgScope();
                            }
                            int paramLine = GenericValueUtils.getLine((IHidOperator)paramValue);
                            int paramStartOffset = GenericValueUtils.getOffset((IHidOperator)paramValue);
                            paramEndOffset = paramStartOffset + parameterName.length();
                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", parameterName);
                            attributes.put("QUICKFIX_KIND", 32);
                            attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
                            rfProject.addSemanticError(1, "NON_EXISTING_PARAMETER: Non existing parameter ''{0}'' of type ''{1}''", libPackageScope, paramStartOffset, paramEndOffset, attributes, paramLine, parserPath, parameterName, binding.getName());
                        }
                    } else {
                        SEvaluator.INSTANCE.calculateAssociation(paramValue, parameter, this, new ConfigInfo(configInfo), parserPath, null, triggerError, isIrunRNMTech);
                    }
                }
            }
        }
        if (triggerError && !hasNamedConnections && index == nofParameters) {
            if (libPackageScope == null) {
                libPackageScope = this.getLibPkgScope();
            }
            int startOffset = dataType.getOffset();
            int offsetEnd = startOffset + (binding.getName() != null ? binding.getName().length() : 1);
            int startLine = dataType.getLine();
            RfFileDef fileDef = this.getFile();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", Integer.toString(nofParameters));
            attributes.put("QUICKFIX_KIND", 42);
            attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)this).toString());
            rfProject.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_NOF_PARAM_OVERRIDES, libPackageScope, startOffset, offsetEnd, attributes, startLine, fileDef != null ? fileDef.getParserPath() : null, nofParameters, parameterOverrides.size());
        }
    }

    public synchronized void adjustDelayedUDPInstance(IRfNamedElement binding) {
        if (!this.isDelayedUDPInstance()) {
            return;
        }
        if (binding instanceof RfPrimitive) {
            DataType dataType = this.getDataType();
            if (dataType == null || dataType.fParamValuesHolder == null) {
                return;
            }
            dataType.fParamValuesHolder.cleanHidObjectsKind(hidObject -> hidObject instanceof HidOperator && ((HidOperator)hidObject).hasQualifier(HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER));
        } else {
            RfHidHolder hidHolder = this.getHidHolder();
            if (hidHolder == null) {
                return;
            }
            hidHolder.cleanHidObjectsKind(hidObject -> hidObject instanceof RfHidOperator && ((HidOperator)hidObject).hasQualifier(HidQualifierCache.IS_DELAY_CONTROL_QUALIFIER));
            this.unsetDelayedUDPInstance();
        }
    }

    public IRfNamedElement getSpecializedDesign(ElementPath instancePath) {
        return this.getGenericDesign(instancePath);
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        return this.getGenericDesign(typesResolver.getHierarchyPath());
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        typesResolver.update(this, null, false, false);
        IRfNamedElement binding = typesResolver.getNamedElement();
        return binding != null ? binding : this.getGenericDesign(null);
    }

    private String debugFullName() {
        RfNamedElement enclosingScope;
        StringBuilder sb = new StringBuilder();
        RfLibrary enlosingLibrary = this.getEnclosingLibrary();
        if (enlosingLibrary != null) {
            sb.append(enlosingLibrary.getName()).append(".");
        }
        if ((enclosingScope = this.getEnclosingScope()) != null) {
            sb.append(enclosingScope.getName()).append(".");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    protected IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (visited.contains(this)) {
            return null;
        }
        if (this.isInstanceToBind() && hid != null && !hid.hasOccurrence(HidQualifierCache.BIND_TARGET_QUALIFIER)) {
            IRfNamedElement instanceScope = this.getBindInstanceScope();
            if (instanceScope != this && instanceScope != null) {
                IRfNamedElement result = instanceScope.semanticGetMember(name, hid, parserPath, initialScope, null, isFirst, isLast, recursiveCall);
                IRfNamedElement boundInstance = this.findIsDeclaredBoundInstance(result, name, instanceScope);
                return boundInstance;
            }
            return null;
        }
        return super.semanticGetMember(name, hid, parserPath, initialScope, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        if (this.isInstanceToBind()) {
            super.updateHolder(updater);
            return;
        }
        if (!(updater instanceof HidHolder)) {
            return;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return;
        }
        final RfProject rfProject = enclosingScope.getRfProject();
        if (rfProject == null) {
            return;
        }
        RfHidHolder upperScopeHidHolder = enclosingScope.getOrCreateHidHolder();
        upperScopeHidHolder.addIdentifiers(updater);
        if (upperScopeHidHolder.isHidObjectsEmpty()) {
            enclosingScope.setHidHolder(null);
        }
        final RfHidHolder instanceHolder = this.getOrCreateHidHolder();
        final String[] defaultNettype = new String[1];
        final CommentBlock[] comment = new CommentBlock[1];
        final DataType[] implicitType = new DataType[1];
        final IRfDesignElement designScope = enclosingScope instanceof RfInstanceHolder && !(enclosingScope instanceof RfChecker) || enclosingScope instanceof RfGenerateBlock ? (IRfDesignElement)enclosingScope : null;
        final RfDefElement scopeDeclaration = designScope instanceof RfNamedElement ? ((RfNamedElement)designScope).getDeclaration() : null;
        updater.visitHidObject(null, (IHidVisitor)new IHidVisitor<HidOperator>(){
            private ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(HidOperator operator) {
                if (designScope instanceof RfNamedElement && operator.hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER)) {
                    if (defaultNettype[0] == null) {
                        defaultNettype[0] = designScope.getDefaultNetType((IRfNamedElement)designScope);
                    }
                    if (comment[0] == null) {
                        comment[0] = RfInstanceHolder.getImplicitComment(defaultNettype[0]);
                    }
                    if (implicitType[0] == null) {
                        implicitType[0] = RfInstanceHolder.getImplicitDataType(defaultNettype[0]);
                    }
                    int offset = operator.getOccurrence().getOffset();
                    int line = operator.getOccurrence().getLine();
                    RfInstance.this.declareImplicitsForPortConnection(operator, (RfNamedElement)designScope, scopeDeclaration, this.parserPath, rfProject, defaultNettype[0], comment[0], implicitType[0], offset, line);
                }
                instanceHolder.addOpi(operator, this.parserPath);
                return true;
            }

            public boolean enterMethodArguments() {
                return false;
            }

            public Class<HidOperator> getType() {
                return HidOperator.class;
            }
        });
        if (instanceHolder.isHidObjectsEmpty()) {
            this.setHidHolder(null);
        }
    }

    private void declareImplicitsForPortConnection(HidOperator operator, RfNamedElement designScope, RfDefElement scopeDeclaration, ParserPath parserPath, RfProject rfProject, String defaultNettype, CommentBlock comment, DataType implicitType, int offset, int line) {
        if (designScope == null) {
            return;
        }
        IHidObject rhSide = PortConnectionUtils.getSignal((IHidOperator)operator);
        if (rhSide instanceof RfHidOperator && ((RfHidOperator)rhSide).isTickCast()) {
            rhSide = ((RfHidOperator)rhSide).getFirstRHValue();
        }
        for (IHid signalHid : HidUtils.flattenToHids((IHidObject)rhSide, (Set)HidFlatteningOption.IMPLICIT_SIGNAL_FLATTEN)) {
            RfInstanceHolder.internalAddImplicitSignal(signalHid, operator, designScope, scopeDeclaration, rfProject, parserPath, offset, line, defaultNettype, implicitType, comment);
        }
    }

    private final IRfNamedElement internalGetAssociatedType() {
        IRfNamedElement assocType = this.internalGetTransientAssociatedType();
        if (assocType != null) {
            return assocType;
        }
        if (assocType == null) {
            assocType = this.getPredefinedGate();
        }
        if (assocType == null) {
            RfProject rfProject = this.getRfProject();
            if (rfProject == null) {
                return null;
            }
            Collection<RfLibrary> libraries = rfProject.getLibraries();
            if (libraries != null && !libraries.isEmpty()) {
                ELLiblist commonLiblist = ELLiblist.of(new ArrayList<RfLibrary>(libraries), (boolean)false);
                BindingRuleWrapper resolved = ELCore.getInstanceType((IRfInstanceElement)this, (String)this.getDataType().getTypeName(null, null), null, (ELLiblist)commonLiblist, null, (IRfLibraryElement)this.getEnclosingLibrary(), (boolean)false);
                if (resolved != null) {
                    assocType = resolved.design;
                }
            }
        }
        if (assocType == null) {
            assocType = ELConstants.UNRESOLVED_INSTANCE_TYPE;
        }
        return assocType;
    }

    public void setDependencies(IRfNamedElement design, IRfConfigurationRule elabRule) {
        RfNamedElement closestTypeContainer = (RfNamedElement)this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        if (design == ELConstants.UNRESOLVED_INSTANCE_TYPE && elabRule != null && elabRule.getRuleKind() == IRfConfigurationRule.ConfigKind.USE && elabRule.list() != null && !elabRule.list().isEmpty()) {
            String name = ((Identifier)elabRule.list().get(0)).getName();
            closestTypeContainer.addReference(name);
            closestTypeContainer.addReferenceToIdentifierName(name);
        } else if (design == ELConstants.UNRESOLVED_INSTANCE_TYPE) {
            DataType dataType = this.getDataType();
            if (dataType != null) {
                closestTypeContainer.addReference(dataType.getType());
                closestTypeContainer.addReferenceToIdentifierName(dataType.getType());
            }
        } else if (design != null) {
            String designName = design.getName();
            if (design instanceof IRfEntityComplement && ((IRfEntityComplement)design).getEntity() != null) {
                designName = ((IRfEntityComplement)design).getEntity().getName();
            }
            closestTypeContainer.addReference(designName);
            closestTypeContainer.addReferenceToIdentifierName(designName);
            String assocTypeName = this.getDataType().getTypeName(null, null);
            if (assocTypeName != null && !assocTypeName.equals(designName)) {
                closestTypeContainer.addReference(assocTypeName);
                closestTypeContainer.addReferenceToIdentifierName(assocTypeName);
            }
        } else {
            String assocTypeName = this.getDataType().getTypeName(null, null);
            if (assocTypeName != null) {
                closestTypeContainer.addReference(assocTypeName);
                closestTypeContainer.addReferenceToIdentifierName(assocTypeName);
            }
        }
    }

    public void setParentScope(IRfNamedElement design) {
        if (design instanceof RfInstanceHolder) {
            ((RfInstanceHolder)design).addParent(this);
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_INSTANCE: Duplicate instance ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public IRfNamedElement getGenericDesign(ElementPath instancePath) {
        if (instancePath != null && !instancePath.isEmpty()) {
            RfProject rfProject = this.getRfProject();
            if (rfProject == null) {
                return null;
            }
            ELManager elManager = rfProject.getELManager();
            if (elManager == null) {
                return null;
            }
            ELInstance instance = elManager.safeMemInstanceFor(instancePath);
            if (instance == null) {
                return null;
            }
            IRfNamedElement resolved = instance.getBinding(false);
            if (resolved instanceof ErrorDesignElement.SubInstanceCopyDesignElement) {
                ELInstance inst = elManager.safeMemInstanceFor(((ErrorDesignElement.SubInstanceCopyDesignElement)resolved).getOriginalPath());
                resolved = inst != null ? inst.getBinding(false) : resolved;
            }
            return (resolved = DesignUtils.toGenericDesignElement((IRfNamedElement)resolved)) == ELConstants.UNRESOLVED_INSTANCE_TYPE ? null : resolved;
        }
        DataType dataType = this.getDataType();
        if (dataType != null && dataType.isArray()) {
            DataType newDT = new DataType(dataType.fType, dataType.fNetType, dataType.fDiscipline, dataType.fPackageScope, dataType.fInnerClassesInfo, dataType.fOrderedParamAssignments, dataType.fNamedParamAssignments, dataType.fSign, dataType.fPackedDimension, dataType.fUnpackedDimension, dataType.fParamValuesHolder);
            RfInstanceList listType = new RfInstanceList(dataType.getTypeName("logic", null), newDT);
            listType.setEnclosingScope(this.getEnclosingScope());
            return listType;
        }
        IRfNamedElement resolved = this.internalGetAssociatedType();
        this.internalSetTransientAssociatedType(resolved);
        return resolved == ELConstants.UNRESOLVED_INSTANCE_TYPE ? null : resolved;
    }

    public BindingRuleWrapper elaborateBinding(String instanceTypeName, ElementPath instancePath, List<IRfLibraryElement> libList, boolean isRuleLiblist, List<IRfLibraryElement> configDefaultLiblist, IRfLibraryElement parentCellLibrary, boolean ignoreCase) {
        int currentMatchType = !ignoreCase ? 1 : 9;
        boolean configHasDefinedLiblist = configDefaultLiblist != null && !configDefaultLiblist.isEmpty();
        IRfDesignElement candidate = null;
        boolean searchParentCell = true;
        for (IRfLibraryElement library : libList) {
            boolean noLibListWithParentPriority;
            if (library == null) continue;
            boolean bl = noLibListWithParentPriority = !configHasDefinedLiblist || candidate == null;
            if (noLibListWithParentPriority && parentCellLibrary != null && (library == parentCellLibrary || library.getLowerCaseName().equals(parentCellLibrary.getLowerCaseName()))) {
                IRfDesignElement localCandidate;
                if (library == parentCellLibrary) {
                    localCandidate = this.getInstantiatedDesign();
                    if (localCandidate != null) {
                        candidate = localCandidate;
                    }
                } else if (candidate == null && (localCandidate = library.getDesignWithPrefix(instanceTypeName, currentMatchType)) != null) {
                    candidate = localCandidate;
                }
                searchParentCell = false;
                continue;
            }
            if (candidate != null) continue;
            candidate = library.getDesignWithPrefix(instanceTypeName, currentMatchType);
        }
        if (candidate == null && searchParentCell && parentCellLibrary != null && (candidate = parentCellLibrary.getDesignWithPrefix(instanceTypeName, currentMatchType)) != null) {
            return BindingRuleWrapper.fromDesign((IRfNamedElement)candidate);
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (candidate == null && isRuleLiblist && configHasDefinedLiblist && configDefaultLiblist != null && rfProject.getToolCompat() == IBuildConfigParserConstants.ToolCompat.IUS_IRUN) {
            for (IRfLibraryElement library : configDefaultLiblist) {
                if (library == parentCellLibrary || (candidate = library.getDesignWithPrefix(instanceTypeName, currentMatchType)) == null) continue;
                return BindingRuleWrapper.fromDesign((IRfNamedElement)candidate);
            }
        }
        if (candidate != null) {
            return BindingRuleWrapper.fromDesign((IRfNamedElement)candidate);
        }
        candidate = rfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)rfProject, instanceTypeName, 9);
        if (candidate instanceof IRfDesignElement) {
            return BindingRuleWrapper.fromDesign((IRfNamedElement)candidate);
        }
        return null;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getDesignWithPrefix(prefix, matchType);
    }

    @Override
    public Image getImage() {
        return DesignUtils.getDesignImage((IRfNamedElement)this.getGenericDesign(null));
    }

    public boolean isArray() {
        DataType dataType = this.getDataType();
        return dataType != null && dataType.isArray();
    }

    public List<ELDimension> elaborateArrayRange(ELParamValues values, ELManager manager) {
        DataType dataType = this.getDataType();
        if (dataType == null || !dataType.isArray()) {
            return null;
        }
        List<IndexType> unpackedDimensions = dataType.getUnpackedDimension();
        if (unpackedDimensions == null || unpackedDimensions.isEmpty()) {
            return null;
        }
        ArrayList<ELDimension> result = new ArrayList<ELDimension>(unpackedDimensions.size());
        ELParamValuesHidEvaluator evaluator = values.getHidEvaluator(manager);
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.GENERATE_BLOCK, (IRfNamedElement)this, null, (boolean)false, (ELManager)manager);
        BitVectorContext integerContext = BitVectorContext.of((DVTNumber)VlogBitVector.ZERO, (IRfNamedElement)this);
        for (IndexType dim : unpackedDimensions) {
            IHidObject rangeObject = dim.getRangeObject();
            if (HidUtils.isOperator((IHidObject)rangeObject) && ((HidOperator)rangeObject).isRangeOrPartSelect()) {
                IHidObject lhObject = ((HidOperator)rangeObject).getLHValue();
                IELParamValue lhResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)lhObject, (IHidEvaluator)evaluator, (BitVectorContext)integerContext, (IHidEvaluationGuardian)guardian));
                if (!(lhResult instanceof ELParamValues.ParamValueNumber)) {
                    return null;
                }
                ListContainer rhObjects = ((HidOperator)rangeObject).getRHValues();
                if (rhObjects.size() != 1) {
                    return null;
                }
                IELParamValue rhResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhObjects.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)integerContext, (IHidEvaluationGuardian)guardian));
                if (!(rhResult instanceof ELParamValues.ParamValueNumber)) {
                    return null;
                }
                result.add(ELDimension.of((int)lhResult.intValue(), (int)rhResult.intValue()));
                continue;
            }
            if (rangeObject != null) {
                IELParamValue oneResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)rangeObject, (IHidEvaluator)evaluator, (BitVectorContext)integerContext, (IHidEvaluationGuardian)guardian));
                if (!(oneResult instanceof ELParamValues.ParamValueNumber)) {
                    return null;
                }
                result.add(ELDimension.of((int)oneResult.intValue()));
                continue;
            }
            return null;
        }
        return result;
    }

    public IRfPredefinedGate getPredefinedGate() {
        DataType dataType = this.getDataType();
        return dataType != null ? (IRfPredefinedGate)RfPredefinedGate.PREDEFINED_GATES.get(dataType.getType()) : null;
    }

    @Override
    public String getCustomName() {
        return this.getName();
    }

    @Override
    public String elementPathName() {
        return this.getCustomName();
    }

    public static String getSimpleName(String fullName) {
        int index = fullName.indexOf(INSTANCE_TARGET_SCOPE_TAG);
        return index > 0 ? fullName.substring(0, index) : fullName;
    }

    public boolean hasOrderedConnections() {
        List portConnectionsOperators = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this);
        if (portConnectionsOperators == null || portConnectionsOperators.isEmpty()) {
            return false;
        }
        for (IHidOperator operator : portConnectionsOperators) {
            if (!PortConnectionUtils.isOrderedConnected((IHidOperator)operator) && !PortConnectionUtils.isOrderedUnconnected((IHidOperator)operator)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDotStarConnection() {
        return this.hasDotStarConnection(false);
    }

    public boolean hasDotStarConnection(boolean checkImplicitConnection) {
        List portConnectionsOperators = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this);
        if (portConnectionsOperators == null || portConnectionsOperators.isEmpty()) {
            return false;
        }
        for (IHidOperator operator : portConnectionsOperators) {
            if (PortConnectionUtils.isDotStarConnected((IHidOperator)operator)) {
                return true;
            }
            if (!checkImplicitConnection || !PortConnectionUtils.isImplicitNamedConnected((IHidOperator)operator)) continue;
            return true;
        }
        return false;
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VLOG_INSTANCE;
    }

    @Override
    protected final RfHidHolder internalGetHidHolder() {
        return this.fHidHolder;
    }

    @Override
    protected final void internalSetHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        RfNamedElement enclosing = this.getEnclosingScope();
        while (enclosing != null && !(enclosing instanceof RfProject)) {
            result = 31 * result + RfElementPath.segmentHashCode(enclosing.getCustomClass(), (String)enclosing.getCustomName());
            enclosing = enclosing.getEnclosingScope();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int getInducedParametricDependencyValue() {
        return 15;
    }

    public static class RfBindInstance
    extends RfInstance {
        private static final long serialVersionUID = 1L;
        private String fTargetScope;
        private List<TargetInstance> fTargetInstances;
        private transient Set<String> fTargetInstanceLastSegmentNameSet;
        private transient IRfNamedElement fCachedBindResult;
        private transient List<ELBindElementPath> fPreElaborations;

        private RfBindInstance(String name, boolean escaped, DataType type, int qualifiers, String targetScope, List<IHidObject> targetInstances) {
            super(name, escaped, type, qualifiers);
            this.fTargetScope = DVTStringUtil.intern((String)targetScope);
            if (targetInstances != null && !targetInstances.isEmpty()) {
                this.fTargetInstances = new ArrayList<TargetInstance>(targetInstances.size());
                this.fTargetInstanceLastSegmentNameSet = new HashSet<String>(targetInstances.size());
                for (IHidObject targetInstanceHid : targetInstances) {
                    TargetInstance targetInstance = TargetInstance.of(targetInstanceHid);
                    if (targetInstance == null) continue;
                    this.fTargetInstances.add(targetInstance);
                    this.fTargetInstanceLastSegmentNameSet.add(DVTStringUtil.intern((String)targetInstance.getLastSegmentName()));
                }
            }
        }

        private RfBindInstance(RfBindInstance instance) {
            this(instance.getName(), instance.isEscaped(), instance.getDataType(), instance.getQualifiers(), instance.getTargetScope(), null);
            this.fTargetInstances = instance.fTargetInstances;
            this.fTargetInstanceLastSegmentNameSet = instance.fTargetInstanceLastSegmentNameSet;
        }

        @Override
        public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
            this.fTargetInstanceLastSegmentNameSet = null;
            this.fCachedBindResult = null;
            this.fPreElaborations = null;
            super.removeDef(incrementalDeltaContainer, def);
        }

        @Override
        public void init(DataType type, String targetScope, List<IHidObject> targetInstances) {
            super.init(type, 64, 0, null);
            this.fTargetScope = DVTStringUtil.intern((String)targetScope);
            this.fCachedBindResult = null;
            this.fTargetInstances = null;
            this.fTargetInstanceLastSegmentNameSet = null;
            if (targetInstances != null && !targetInstances.isEmpty()) {
                if (this.fTargetInstances == null) {
                    this.fTargetInstances = new ArrayList<TargetInstance>(targetInstances.size());
                    this.fTargetInstanceLastSegmentNameSet = new HashSet<String>(targetInstances.size());
                }
                for (IHidObject targetInstanceHid : targetInstances) {
                    TargetInstance targetInstance = TargetInstance.of(targetInstanceHid);
                    if (targetInstance == null) continue;
                    this.fTargetInstances.add(targetInstance);
                    this.fTargetInstanceLastSegmentNameSet.add(DVTStringUtil.intern((String)targetInstance.getLastSegmentName()));
                }
            }
        }

        @Override
        public void deepClean() {
            super.deepClean();
            if (this.fTargetInstances != null) {
                this.fTargetInstances.clear();
            }
            this.fTargetInstances = null;
            this.fTargetScope = null;
            this.fCachedBindResult = null;
            this.fPreElaborations = null;
        }

        public boolean isInstanceToBind() {
            return this.fTargetScope != null || this.fTargetInstances != null;
        }

        public String getTargetScope() {
            return this.fTargetScope;
        }

        public boolean isPotentialInstanceHolderBind() {
            return this.fTargetInstances == null && this.fTargetScope != null || this.fTargetScope == null && this.fTargetInstances != null && this.fTargetInstances.size() == 1 && this.fTargetInstances.get((int)0).targetNoSelect.length() == 1;
        }

        @Override
        public List<TargetInstance> getTargetInstances() {
            return this.fTargetInstances;
        }

        @Override
        public IRfNamedElement getCachedBindResult() {
            return this.fCachedBindResult;
        }

        @Override
        public String getCustomName() {
            return super.getCustomName() + RfInstance.INSTANCE_TARGET_SCOPE_TAG + (this.fTargetScope != null ? this.fTargetScope : "") + (this.fTargetInstances != null ? this.fTargetInstances : "");
        }

        public IRfNamedElement getBindInstanceScope() {
            if (!this.isInstanceToBind()) {
                return null;
            }
            if (this.fCachedBindResult == null || this.fCachedBindResult.hasNoDefs(true)) {
                this.fCachedBindResult = null;
                return null;
            }
            return this.fCachedBindResult;
        }

        public void setBindInstanceScope(IRfNamedElement bindScope) {
            this.fCachedBindResult = bindScope;
        }

        public List<ELBindElementPath> preElaborateBindTargetPaths() {
            if (this.fPreElaborations != null) {
                return this.fPreElaborations;
            }
            this.fPreElaborations = new ArrayList<ELBindElementPath>(2);
            if (this.fTargetInstances == null || this.fTargetInstances.isEmpty()) {
                if (this.fTargetScope != null) {
                    this.fPreElaborations.add(ELBindElementPath.of(null, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME));
                }
                return this.fPreElaborations;
            }
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (enclosingScope == null) {
                return this.fPreElaborations;
            }
            boolean isLibraryBind = enclosingScope instanceof IRfLibraryElement;
            for (TargetInstance targetInstanceObject : this.fTargetInstances) {
                IHidObject hidObject = targetInstanceObject.hidObject;
                int targetPathLength = targetInstanceObject.getTargetNoSelect().length();
                if (!isLibraryBind && !targetInstanceObject.isRootAbsolute() && targetPathLength >= 1) {
                    String firstSegment = targetInstanceObject.targetNoSelect.getSegment(0);
                    if (enclosingScope.getLocalMember(RfInstance.class, firstSegment, true) != null || enclosingScope.getLocalMember(RfGenerateBlock.class, firstSegment, true) != null) {
                        this.fPreElaborations.add(ELBindElementPath.of((IHidObject)hidObject, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_RELATIVE_PATH));
                        continue;
                    }
                    IRfNamedElement visibleMember = enclosingScope.semanticGetMember(firstSegment, null, null, enclosingScope, enclosingScope, true, false, true);
                    if (visibleMember instanceof RfInstance) {
                        if (this.fTargetScope == null) {
                            this.fTargetScope = ((RfInstance)visibleMember).getAssociatedTypeName();
                        }
                        this.fPreElaborations.add(ELBindElementPath.of((IHidObject)hidObject, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME_AND_INSTANCE_NAME));
                        continue;
                    }
                }
                if (this.fTargetScope == null && this.fTargetInstances.size() == 1 && targetPathLength == 1) {
                    this.fPreElaborations.add(ELBindElementPath.of((IHidObject)hidObject, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME));
                    continue;
                }
                if (this.fTargetScope != null && targetPathLength == 1) {
                    this.fPreElaborations.add(ELBindElementPath.of((IHidObject)hidObject, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_TYPE_NAME_AND_INSTANCE_NAME));
                    continue;
                }
                this.fPreElaborations.add(ELBindElementPath.of((IHidObject)hidObject, (ELBindElementPath.ELBindElementPathKind)ELBindElementPath.ELBindElementPathKind.BY_ABSOLUTE_PATH));
            }
            return this.fPreElaborations;
        }

        public void resolveBindLocalHids() {
            RfProject rfProject = this.getRfProject();
            if (rfProject == null) {
                return;
            }
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, false, rfProject.getToolCompat());
            configInfo.setResolveOnlyBindTargets(true);
            this.resolveLocalHids(configInfo, false);
            configInfo = new ConfigInfo(false, rfProject, null, false, rfProject.getToolCompat());
            configInfo.setResolveOnlyBindLocalHids(true);
            this.resolveLocalHids(configInfo, true);
            DataType dataType = this.getDataType();
            if (dataType == null) {
                return;
            }
            RfHidHolder parameterHidHolder = dataType.getParamValuesHolder();
            if (parameterHidHolder == null) {
                return;
            }
            IRfNamedElement bindScope = this.getBindInstanceScope();
            if (bindScope == null) {
                return;
            }
            RfHidVisitor visitor = new RfHidVisitor(){

                public boolean visit(RfHid hid) {
                    hid.setSecondaryScope(null);
                    return true;
                }
            };
            parameterHidHolder.visitHidObject(null, visitor);
            configInfo.setCheckUsageBeforeDeclaration(false);
            parameterHidHolder.resolveHids(configInfo, true, this, (byte)3);
            configInfo.setCheckUsageBeforeDeclaration(true);
        }

        public boolean isTargetInstance(boolean resolveToInstance, String typeName, ElementPath instancePath, String instancePathLastSegment) {
            if (this.fTargetScope == null && (this.fTargetInstances == null || this.fTargetInstances.isEmpty())) {
                return false;
            }
            if (resolveToInstance) {
                if (instancePath == null || instancePath.isEmpty()) {
                    return false;
                }
                if (instancePathLastSegment != null && this.fTargetInstanceLastSegmentNameSet != null && !this.fTargetInstanceLastSegmentNameSet.contains(instancePathLastSegment)) {
                    return false;
                }
                for (TargetInstance targetInstance : this.fTargetInstances) {
                    int length2;
                    int length1 = targetInstance.targetNoSelect.length();
                    if (length1 > (length2 = instancePath.length()) || !instancePath.endsWith(targetInstance.targetNoSelect)) continue;
                    return length1 != 1 || this.getEnclosingScope().getLocalMember(RfInstance.class, targetInstance.targetNoSelect.getSegment(0), true) != null;
                }
            } else {
                if (typeName == null) {
                    return false;
                }
                if (this.fTargetInstanceLastSegmentNameSet != null && !this.fTargetInstanceLastSegmentNameSet.contains(typeName)) {
                    return false;
                }
                if (this.fTargetScope == null ? this.fTargetInstances.size() == 1 && ElementPath.join(null, (String)typeName).equals((Object)this.fTargetInstances.get((int)0).targetNoSelect) : this.fTargetInstances.isEmpty() && this.fTargetScope.equals(typeName)) {
                    return true;
                }
            }
            return false;
        }

        public Set<String> getTargetInstanceLastSegmentNameSet() {
            if (this.fTargetInstanceLastSegmentNameSet == null && this.fTargetInstances != null) {
                this.fTargetInstanceLastSegmentNameSet = new HashSet<String>(this.fTargetInstances.size());
                for (TargetInstance targetInstance : this.fTargetInstances) {
                    this.fTargetInstanceLastSegmentNameSet.add(targetInstance.getLastSegmentName());
                }
            }
            return this.fTargetInstanceLastSegmentNameSet;
        }
    }

    public class RfInstanceList
    extends RfListType
    implements IRfDesignElement {
        private static final long serialVersionUID = 1L;

        public RfInstanceList(String name, DataType dataType) {
            super(name, dataType, RfInstance.this);
        }

        @Override
        public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
            T candidate = super.getLocalMember(clazz, name, rawMembers);
            if (candidate != null || clazz != RfPort.class && clazz != RfModport.class) {
                return candidate;
            }
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof RfNamedElement)) {
                return null;
            }
            return ((RfNamedElement)assocType).getLocalMember(clazz, name, rawMembers);
        }

        @Override
        public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
            IRfNamedElement candidate = super.getLocalMember((Set)classes, name, exclude);
            if (candidate != null || classes == null || !classes.contains(RfPort.class) && !classes.contains(RfModport.class)) {
                return candidate;
            }
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof RfNamedElement)) {
                return null;
            }
            candidate = ((RfNamedElement)assocType).getLocalMember((Set)classes, name, exclude);
            if (candidate instanceof RfField || candidate instanceof RfModport) {
                return candidate;
            }
            return null;
        }

        @Override
        public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
            List<T> candidates1 = super.getLocalMembers(clazz);
            if (clazz != RfPort.class && clazz != RfModport.class) {
                return candidates1;
            }
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof RfNamedElement)) {
                return null;
            }
            List<T> candidates2 = ((RfNamedElement)assocType).getLocalMembers(clazz);
            if (candidates1 == null) {
                return candidates2;
            }
            if (candidates2 == null) {
                return candidates1;
            }
            candidates1.addAll(candidates2);
            return candidates1;
        }

        @Override
        public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
            IRfNamedElement candidate = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
            if (candidate != null || classes == null || !classes.contains(RfPort.class) && !classes.contains(RfModport.class)) {
                return candidate;
            }
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof RfNamedElement)) {
                return null;
            }
            candidate = assocType.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
            if (candidate instanceof RfField || candidate instanceof RfModport) {
                return candidate;
            }
            return null;
        }

        @Override
        public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
            super.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
            IRfNamedElement assocType = this.getAssociatedType();
            if (assocType == null) {
                return;
            }
            assocType.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
        }

        @Override
        public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
            IRfNamedElement assocType = this.getAssociatedType();
            if (assocType == null) {
                return null;
            }
            return assocType.getTooltipSignature(scope, hierarchyPath, hid, useCharLimit);
        }

        @Override
        public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
            DataType dataType = this.getDataType();
            if (dataType == null) {
                return null;
            }
            DataType listDT = new DataType(dataType.fType, dataType.fNetType, dataType.fDiscipline, dataType.fPackageScope, dataType.fInnerClassesInfo, dataType.fOrderedParamAssignments, dataType.fNamedParamAssignments, dataType.fSign, dataType.fPackedDimension, dataType.fUnpackedDimension, dataType.fParamValuesHolder);
            listDT.setIsVerilog(dataType.isVerilog());
            listDT.setLine(dataType.getLine());
            listDT.setOffset(dataType.getOffset());
            listDT.setIsInsideMacro(dataType.isInsideMacro());
            if (listDT.hasUnpackedDimension()) {
                listDT.decreaseUnpackedDimension();
            }
            if (listDT.isArray()) {
                RfInstanceList listType = new RfInstanceList(dataType.getTypeName("logic", null), listDT);
                listType.setEnclosingScope(this.getEnclosingScope());
                return listType;
            }
            IRfNamedElement resolved = RfInstance.this.internalGetAssociatedType();
            this.internalSetTransientAssociatedType(resolved);
            if (resolved == ELConstants.UNRESOLVED_INSTANCE_TYPE) {
                return null;
            }
            return resolved;
        }

        public IRfNamedElement.ElementKind getKind() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return IRfNamedElement.ElementKind.VLOG_INSTANCE_LIST;
            }
            return ((IRfDesignElement)assocType).getKind();
        }

        public List<? extends IRfNamedElement> getLocalParameters() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return assocType.getLocalParameters();
        }

        public List<? extends IRfNamedElement> getPortListParameters() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return assocType.getPortListParameters();
        }

        public List<? extends IRfNamedElement> getLocalElabConstants() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return assocType.getLocalElabConstants();
        }

        public Collection<? extends IRfFieldElement> getLocalSignals() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getLocalSignals();
        }

        public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getParameterWithPrefix(prefix, matchType);
        }

        public Collection<? extends IRfInstanceElement> getLocalInstances() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getLocalInstances();
        }

        public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getLocalInstancesWithPrefix(prefix, matchType);
        }

        public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getLocalGenerateBlocks();
        }

        @Override
        public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return assocType.getInstanceWithPrefix(prefix, matchType);
        }

        public IRfBlockElement getBlockWithPrefix(String prefix, int matchType) {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getBlockWithPrefix(prefix, matchType);
        }

        public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof RfNamedElement)) {
                return null;
            }
            return ((RfNamedElement)assocType).getLocalMembers(RfActionBlock.class);
        }

        @Deprecated
        public IRfDesignElement getResolvedElement() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getResolvedElement();
        }

        public List<? extends IRfPortElement> getLocalPorts() {
            IRfNamedElement assocType = this.getAssociatedType();
            if (!(assocType instanceof IRfDesignElement)) {
                return null;
            }
            return ((IRfDesignElement)assocType).getLocalPorts();
        }

        public boolean xIsNonStaticValueHolder() {
            return false;
        }
    }

    public static class TargetInstance
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final String lastSegmentName;
        private final boolean isRootAbsolute;
        private final ElementPath targetNoSelect;
        private final IHidObject hidObject;

        private TargetInstance(String lastSegmentName, boolean isRootAbsolute, ElementPath targetNoSelect, IHidObject hidObject) {
            this.lastSegmentName = lastSegmentName;
            this.isRootAbsolute = isRootAbsolute;
            this.targetNoSelect = targetNoSelect;
            this.hidObject = hidObject;
        }

        public static TargetInstance of(IHidObject targetInstance) {
            Hid lastHid;
            if (targetInstance == null) {
                return null;
            }
            switch (targetInstance.getHidKind()) {
                case ACCESS: {
                    HidAccess hidAccess = ((HidAccess)targetInstance).upwardsCopy(false);
                    lastHid = hidAccess.getParentHid();
                    targetInstance = hidAccess;
                    break;
                }
                case HID: {
                    lastHid = ((Hid)targetInstance).upwardsCopy(false);
                    targetInstance = lastHid;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (lastHid == null) {
                return null;
            }
            String lastSegmentName = lastHid.getName();
            boolean isRootAbsolute = "$root".equals(lastHid.getAncestorHid().getName());
            if (isRootAbsolute) {
                lastHid.removeAncestorHid();
            }
            ElementPath targetNoSelect = ElementPath.join((ElementPath)lastHid.getHierarchicalPath(), (String)lastSegmentName);
            return new TargetInstance(lastSegmentName, isRootAbsolute, targetNoSelect, targetInstance);
        }

        public String getLastSegmentName() {
            return this.lastSegmentName;
        }

        public ElementPath getTargetNoSelect() {
            return this.targetNoSelect;
        }

        public String toString() {
            return HidUtils.toNiceString((IHidObject)this.hidObject);
        }

        public boolean isRootAbsolute() {
            return this.isRootAbsolute;
        }
    }
}

