/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RTLChecksUtil;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.linter.rules.ILintingInstanceHolderCallback;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedVirtualInterface;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfInterface
extends RfInstanceHolder
implements IRfInterface {
    private static final long serialVersionUID = 2L;
    private HidImplicit[] localTimescale;
    private transient Map<String, IHidObject> cachedElabConstantDefaultExpressions;

    public RfInterface(String name, boolean escaped, String defaultNetType, HidImplicit[] timescale) {
        super(name, escaped, defaultNetType, timescale);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "interface " + this.printScope() + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    public void setLocalTimeunit(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[0] = value;
    }

    public void setLocalTimeprecision(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[1] = value;
    }

    public boolean hasDirectiveTimeunit() {
        return this.localTimescale != null && this.localTimescale[0] != null;
    }

    public boolean hasDirectiveTimeprecision() {
        return this.localTimescale != null && this.localTimescale[1] != null;
    }

    @Override
    public HidImplicit getLocalTimeunit() {
        HidImplicit enclosingTimeunit;
        HidImplicit ownTimeunit;
        HidImplicit hidImplicit = ownTimeunit = this.localTimescale != null ? this.localTimescale[0] : null;
        if (ownTimeunit != null) {
            return ownTimeunit;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfInstanceHolder && !(enclosingScope instanceof RfLibrary) && (enclosingTimeunit = enclosingScope.getLocalTimeunit()) != null) {
            return enclosingTimeunit;
        }
        return null;
    }

    @Override
    public HidImplicit getLocalTimeprecision() {
        HidImplicit enclosingTimeprecision;
        HidImplicit ownTimeprecision;
        HidImplicit hidImplicit = ownTimeprecision = this.localTimescale != null ? this.localTimescale[1] : null;
        if (ownTimeprecision != null) {
            return ownTimeprecision;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfInstanceHolder && !(enclosingScope instanceof RfLibrary) && (enclosingTimeprecision = enclosingScope.getLocalTimeprecision()) != null) {
            return enclosingTimeprecision;
        }
        return null;
    }

    @Override
    protected void cacheElements() {
        super.cacheElements();
        List<RfField> constants = this.getLocalElabConstants();
        if (constants != null && !constants.isEmpty()) {
            Set<String> parameterNames = this.getParamNames();
            Map<String, RfNamedElement> enumValueNames = this.getEnumNames();
            List<? extends HidOperatorWrapper> assignWrappers = this.getSortedAssignsToComputeConstants(false);
            if (assignWrappers != null) {
                this.cachedElabConstantDefaultExpressions = new HashMap<String, IHidObject>(constants.size());
                for (HidOperatorWrapper hidOperatorWrapper : assignWrappers) {
                    HidOperator operator = (HidOperator)hidOperatorWrapper.hidObject;
                    String name = ((IHid)operator.getLHValue()).getName();
                    if ((parameterNames == null || !parameterNames.contains(name)) && (enumValueNames == null || !enumValueNames.containsKey(name))) continue;
                    this.cachedElabConstantDefaultExpressions.put(name, operator.getFirstRHValue());
                }
            } else {
                this.cachedElabConstantDefaultExpressions = Collections.emptyMap();
            }
        } else {
            this.cachedElabConstantDefaultExpressions = Collections.emptyMap();
        }
    }

    @Override
    @NotNull
    public Map<String, IHidObject> getElabConstantDefaultExpressions() {
        return this.cachedElabConstantDefaultExpressions;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.localTimescale = null;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfModportElement getModportWithPrefix(String prefix, int matchType) {
        return this.getModportWithPrefix(prefix, matchType, 1);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_INTERFACE: Duplicate interface ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VLOG_INTERFACE;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE);
    }

    public boolean xIsNullableXValueHolder() {
        return true;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement specializedElementScope = typesResolver.getSpecializedElementScope(this);
        if (specializedElementScope instanceof RfSpecializedVirtualInterface && this.equals(((RfSpecializedVirtualInterface)specializedElementScope).getGenericElement())) {
            ((RfSpecializedVirtualInterface)specializedElementScope).getQualifiedName(result, typesResolver, specializedElementScope, options, previous);
        } else {
            super.getQualifiedName(result, typesResolver, scope, options, previous);
        }
    }

    @Override
    protected void checkUnused(RfProject rfProject, boolean isPrecompiledLoad) throws BuildCancelException {
        this.checkUnused(rfProject, isPrecompiledLoad, null);
    }

    @Override
    public void checkUnused(RfProject rfProject, boolean isPrecompiledLoad, ILintingInstanceHolderCallback lintingRule) throws BuildCancelException {
        if (!this.getSemanticEnable()) {
            return;
        }
        if (this.isShallowCompiled()) {
            return;
        }
        if (this.isPrecompiledDB() && isPrecompiledLoad) {
            return;
        }
        rfProject.checkBuildCanceled();
        LibraryPackageScope libPkgScope = this.getLibPkgScope();
        try {
            IdentityHashMap<IRfNamedElement, RfInstanceHolder.UnusedCheck> referencesMap = new IdentityHashMap<IRfNamedElement, RfInstanceHolder.UnusedCheck>();
            List<RfField> fields = this.getLocalMembers(RfField.class);
            List<RfPort> ports = this.getLocalMembers(RfPort.class);
            RTLChecksUtil checksUtils = new RTLChecksUtil();
            Set<IRfNamedElement> dependencies = this.getAllDepencies(rfProject, ports, fields);
            if (fields != null && !fields.isEmpty() || ports != null && !ports.isEmpty()) {
                if (dependencies != null && !dependencies.isEmpty()) {
                    this.visitHidObjectWithDependencies(rfProject, new RfInstanceHolder.SignalReadWriteVisitor(rfProject, referencesMap, libPkgScope, checksUtils, null), dependencies);
                } else {
                    this.visitHidObject(rfProject, new RfInstanceHolder.SignalReadWriteVisitor(rfProject, referencesMap, libPkgScope, checksUtils, null));
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void xComputeCoerceInout() {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfNamedElement member : members.values()) {
            List<RfModportPort> cbPorts;
            if (!(member instanceof RfClockingBlock) || (cbPorts = member.getLocalMembers(RfModportPort.class)) == null || cbPorts.isEmpty()) continue;
            for (RfModportPort cbPort : cbPorts) {
                RfPort port;
                RfNamedElement field = (RfNamedElement)members.get((Object)cbPort.getName());
                if (!(field instanceof RfPort) || (port = (RfPort)field).isInout() || port.isInput() && cbPort.isInput() || port.isOutput() && cbPort.isOutput()) continue;
                port.setCoerceInout();
            }
        }
    }

    @Override
    public boolean xIsStaticValueHolder(XValueHolderFactory factory) {
        return factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode();
    }
}

