/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.ams.RfConnectRules;
import ro.amiq.vlogdt.model.reflection.ams.RfDiscipline;
import ro.amiq.vlogdt.model.reflection.ams.RfNature;
import ro.amiq.vlogdt.model.reflection.ams.RfNatureAttr;
import ro.amiq.vlogdt.model.reflection.ams.RfParamset;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public enum RfKind implements IRfKind
{
    CONFIGURATION("configuration"),
    INTERFACE("interface"),
    MODULE("module"),
    PRIMITIVE("primitive"),
    PROGRAM("program"),
    CHECKER("checker"),
    PACKAGE("package"),
    CLASS("class"),
    STRUCT("struct"),
    ENUM("enum"),
    UNION("union"),
    TYPEDEF("typedef"),
    DISCIPLINE("discipline"),
    NATURE("nature"),
    NATUREATTR("nature attribute"),
    PARAMSET("paramset"),
    LIBRARY("library"),
    GENERATE_BLOCK("generate block"),
    INSTANCE("instance"),
    CONNECT_RULES("connect rules"),
    TYPE_PARAMETER("type parameter"),
    ALIAS_PARAMETER("aliasparam"),
    DYNAMIC_PARAMETER("dynamicparam"),
    SPEC_PARAMETER("specparam"),
    LOCAL_PARAMETER("localparam"),
    PARAMETER("parameter"),
    MODPORT("modport"),
    CLOCKING_BLOCK("clocking block"),
    INTERFACE_PORT("interface port"),
    MODPORT_PORT("modport port"),
    INPUT_PORT("input port"),
    OUTPUT_PORT("output port"),
    INOUT_PORT("inout port"),
    REF_PORT("ref port"),
    PORT("port"),
    GENVAR("genvar"),
    COVERGROUP("covergroup"),
    COVERPOINT("coverpoint"),
    COVERCROSS("covercross"),
    CONSTRAINT("constraint"),
    CONSTRUCTOR("constructor"),
    FUNCTION("function"),
    TASK("task"),
    ASSERT("assert"),
    ASSUME("assume"),
    EXPECT("expect"),
    COVER("cover"),
    RESTRICT("restrict"),
    PROPERTY("property"),
    SEQUENCE("sequence"),
    NET("net"),
    EVENT("event"),
    FIELD("field"),
    VARIABLE("variable"),
    ARGUMENT("argument"),
    ENUM_ITEM("enum item"),
    MACRO("macro"),
    SCALAR_TYPE("scalar type"),
    FRAGMENT("fragment"),
    EVENT_TRIGGER("event trigger"),
    FUNCTION_CALL("function call"),
    ACTION_BLOCK("block"),
    UNKNOWN("");

    private String fName;

    private RfKind(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public static RfKind of(IRfNamedElement e) {
        if ((e = DesignUtils.toGenericDesignElement((IRfNamedElement)e)) instanceof RfField) {
            RfField fieldElement = (RfField)e;
            if (fieldElement instanceof RfPort) {
                RfPort portElement = (RfPort)e;
                if (portElement.isInput()) {
                    return INPUT_PORT;
                }
                if (portElement.isOutput()) {
                    return OUTPUT_PORT;
                }
                if (portElement.isInout()) {
                    return INOUT_PORT;
                }
                if (portElement.isRef()) {
                    return REF_PORT;
                }
                if (portElement.isInterfacePort()) {
                    return INTERFACE_PORT;
                }
                if (portElement.isModportPort()) {
                    return MODPORT_PORT;
                }
                return PORT;
            }
            if (fieldElement.isVariable()) {
                return VARIABLE;
            }
            if (fieldElement.isNet()) {
                return NET;
            }
            if (fieldElement instanceof RfInstance) {
                return INSTANCE;
            }
            if (fieldElement.isLocalParameter()) {
                return LOCAL_PARAMETER;
            }
            if (fieldElement.isSpecParam()) {
                return SPEC_PARAMETER;
            }
            if (fieldElement.isAliasParam()) {
                return ALIAS_PARAMETER;
            }
            if (fieldElement.isDynamicParam()) {
                return DYNAMIC_PARAMETER;
            }
            if (fieldElement.isTypeParameter()) {
                return TYPE_PARAMETER;
            }
            if (fieldElement.isParameter()) {
                return PARAMETER;
            }
            if (fieldElement.isArgument()) {
                return ARGUMENT;
            }
            if (fieldElement.isGenvar()) {
                return GENVAR;
            }
            if (fieldElement.isEvent()) {
                return EVENT;
            }
            if (fieldElement.isEnumElement() || fieldElement.isEnumRangeElement()) {
                return ENUM_ITEM;
            }
            if (fieldElement instanceof RfCoverpoint) {
                return COVERPOINT;
            }
            if (fieldElement instanceof RfCovercross) {
                return COVERCROSS;
            }
            return FIELD;
        }
        if (e instanceof RfFunction) {
            if (((RfFunction)e).isConstructor()) {
                return CONSTRUCTOR;
            }
            if (((RfFunction)e).isTask()) {
                return TASK;
            }
            return FUNCTION;
        }
        if (e instanceof RfTypeAlias) {
            return TYPEDEF;
        }
        if (e instanceof RfClass) {
            return CLASS;
        }
        if (e instanceof RfStruct) {
            RfStruct structElement = (RfStruct)e;
            if (structElement.isUnion()) {
                return UNION;
            }
            if (structElement.isEnum()) {
                return ENUM;
            }
            return STRUCT;
        }
        if (e instanceof RfModule) {
            return MODULE;
        }
        if (e instanceof RfInterface) {
            return INTERFACE;
        }
        if (e instanceof RfModport) {
            return MODPORT;
        }
        if (e instanceof RfClockingBlock) {
            return CLOCKING_BLOCK;
        }
        if (e instanceof RfCovergroup) {
            return COVERGROUP;
        }
        if (e instanceof RfConstraint) {
            return CONSTRAINT;
        }
        if (e instanceof RfAssertExpect) {
            RfAssertExpect assertElement = (RfAssertExpect)e;
            if (assertElement.isAssert()) {
                return ASSERT;
            }
            if (assertElement.isAssume()) {
                return ASSUME;
            }
            if (assertElement.isExpect()) {
                return EXPECT;
            }
            if (assertElement.isCover()) {
                return COVER;
            }
            if (assertElement.isRestrict()) {
                return RESTRICT;
            }
        }
        if (e instanceof RfPackage) {
            return PACKAGE;
        }
        if (e instanceof RfGenerateBlock) {
            return GENERATE_BLOCK;
        }
        if (e instanceof RfPrimitive) {
            return PRIMITIVE;
        }
        if (e instanceof RfProgram) {
            return PROGRAM;
        }
        if (e instanceof RfChecker) {
            return CHECKER;
        }
        if (e instanceof RfConfiguration) {
            return CONFIGURATION;
        }
        if (e instanceof RfConnectRules) {
            return CONNECT_RULES;
        }
        if (e instanceof RfDiscipline) {
            return DISCIPLINE;
        }
        if (e instanceof RfEventTrigger) {
            return EVENT_TRIGGER;
        }
        if (e instanceof RfFragment) {
            return FRAGMENT;
        }
        if (e instanceof RfFunctionCall) {
            return FUNCTION_CALL;
        }
        if (e instanceof RfNature) {
            return NATURE;
        }
        if (e instanceof RfNatureAttr) {
            return NATUREATTR;
        }
        if (e instanceof RfParamset) {
            return PARAMSET;
        }
        if (e instanceof RfScalarType) {
            return SCALAR_TYPE;
        }
        if (e instanceof VlogMacroInfo) {
            return MACRO;
        }
        if (e instanceof RfPropertySequence) {
            if (((RfPropertySequence)e).isProperty()) {
                return PROPERTY;
            }
            return SEQUENCE;
        }
        if (e instanceof RfLibrary) {
            return LIBRARY;
        }
        if (e instanceof RfActionBlock) {
            return ACTION_BLOCK;
        }
        return UNKNOWN;
    }
}

