/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedPackage;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public class RfLibrary
extends RfInstanceHolder
implements IRfLibraryElement {
    private static final long serialVersionUID = 3L;
    private String lowerCaseName;
    private Map<String, List<RfInstance>> binds;
    private Set<String> vunitNames;
    private HidImplicit[] localTimescale;
    private transient Map<String, Set<IRfNamedElement>> typeReferences;
    private transient long cacheTimestamp;
    private transient Map<IRfNamedElement, List<IRfInstanceElement>> cachedBinds;
    private transient Set<RfLibrary> pkgSearchLibraries;
    public static final Set<Class<? extends IRfScopeElement>> ELABCONSTANTS_SKIPPED_MEMBERS = new LinkedHashSet<Class<? extends IRfScopeElement>>();
    public static final Set<Class<? extends IRfScopeElement>> ELAB_SKIPPED_MEMBERS;

    static {
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfChecker.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfInterface.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfModule.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfProgram.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfGenerateBlock.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfPrimitive.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfPackage.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfPredefinedPackage.class);
        ELAB_SKIPPED_MEMBERS = new LinkedHashSet<Class<? extends IRfScopeElement>>();
        ELAB_SKIPPED_MEMBERS.add(RfChecker.class);
        ELAB_SKIPPED_MEMBERS.add(RfInterface.class);
        ELAB_SKIPPED_MEMBERS.add(RfModule.class);
        ELAB_SKIPPED_MEMBERS.add(RfProgram.class);
        ELAB_SKIPPED_MEMBERS.add(RfGenerateBlock.class);
        ELAB_SKIPPED_MEMBERS.add(RfPrimitive.class);
        ELAB_SKIPPED_MEMBERS.add(RfPackage.class);
        ELAB_SKIPPED_MEMBERS.add(RfPredefinedPackage.class);
    }

    public RfLibrary(String name, boolean escaped) {
        super(name, escaped, "wire", null);
        this.lowerCaseName = name != null ? DVTStringUtil.intern((String)name.toLowerCase()) : null;
    }

    @Override
    public boolean isPredefined() {
        return "<native>".equals(this.getName()) || "<std>".equals(this.getName());
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "library " + this.getName();
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
    }

    @Override
    public String getDefaultNetType(IRfNamedElement element) {
        RfNamedElement enclosing = this.getEnclosingScope();
        if (enclosing != null && element != null) {
            return enclosing.getDefaultNetType(element);
        }
        return "wire";
    }

    @Override
    public HidImplicit[] getTimescale(IRfNamedElement element) {
        RfNamedElement enclosing = this.getEnclosingScope();
        if (enclosing != null && element != null) {
            return enclosing.getTimescale(element);
        }
        return RfInstanceHolder.DEFAULT_TIMESCALE;
    }

    public boolean isNonTopFilesLibrary() {
        return "non-top-files".equals(this.getName());
    }

    public boolean isDefaultLibrary() {
        return "work".equals(this.getName());
    }

    @Override
    public void setVunitNames(Set<String> vunitNames) {
        this.vunitNames = vunitNames;
    }

    @Override
    public Set<String> getVunitNames() {
        return this.vunitNames;
    }

    public void setLocalTimeunit(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[0] = value;
    }

    public void setLocalTimeprecision(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[1] = value;
    }

    @Override
    public HidImplicit getLocalTimeunit() {
        return this.localTimescale != null ? this.localTimescale[0] : null;
    }

    @Override
    public HidImplicit getLocalTimeprecision() {
        return this.localTimescale != null ? this.localTimescale[1] : null;
    }

    @Override
    public HidImplicit[] getEffectiveTimescale() {
        HidImplicit working = this.getLocalTimeunit();
        HidImplicit timeunit = working != null ? working : DEFAULT_TIMESCALE[0];
        working = this.getLocalTimeprecision();
        HidImplicit timeprecision = working != null ? working : DEFAULT_TIMESCALE[1];
        return new HidImplicit[]{timeunit, timeprecision};
    }

    @Override
    public void setName(String name, boolean escaped) {
        super.setName(name, escaped);
        this.lowerCaseName = name != null ? DVTStringUtil.intern((String)name.toLowerCase()) : null;
    }

    @Override
    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    @Override
    public void elaborateImportedPackages(ELManager manager) {
        if (manager.getSemanticEnableRaw() != 3) {
            return;
        }
        NullProtectedList<ImportInfo> importDeclarations = this.getAllImportDeclarations();
        if (importDeclarations == null || importDeclarations.isEmpty()) {
            return;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (ImportInfo importDeclaration : importDeclarations) {
            IRfPackageElement pkg = importDeclaration.getPackage();
            if (pkg == null || visited.contains(pkg)) continue;
            visited.add(pkg);
            pkg.elaborateConstants(manager);
        }
    }

    @Override
    public void elaborateConstants(ELManager manager) {
        if (manager == null) {
            return;
        }
        if (manager.isPermanentAfterElaboration()) {
            return;
        }
        if (manager.isControlNoParamEval()) {
            return;
        }
        this.fElabConstantsLock.lock();
        try {
            if (manager.getExternalConstants((IRfNamedElement)this) != null) {
                return;
            }
            LinkedHashMap<IRfNamedElement, ELParamValues> working = new LinkedHashMap<IRfNamedElement, ELParamValues>();
            working.put(this, ELParamValues.create((boolean)true));
            manager.addExternalConstants((IRfNamedElement)this, (ELParamValues)working.get(this));
            this.computeConstants(manager, working);
            for (Map.Entry entry : working.entrySet()) {
                manager.addExternalConstants((IRfNamedElement)entry.getKey(), ELUtils.getValidParamValues((ELParamValues)((ELParamValues)entry.getValue())));
            }
            byte semanticEnableRaw = manager.getSemanticEnableRaw();
            if (manager.isPermanentElaboration() && semanticEnableRaw == 3) {
                this.setSemanticEnable(semanticEnableRaw);
                this.elaborateImportedPackages(manager);
                IRfSingleLangProject rfProject = manager.getStartingVLOGProject();
                ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, rfProject.getToolCompat());
                configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELUtils.getValidParamValues((ELParamValues)manager.getExternalConstants((IRfNamedElement)this)), Collections.emptyList(), (ELManager)manager));
                configInfo.setElabWidthCheckDisabled(manager.isElabWidthCheckDisabled());
                configInfo.setElabWidthCheckFiltered(manager.isElabWidthCheckFiltered());
                this.resolveHids(configInfo, true, true, semanticEnableRaw, ELABCONSTANTS_SKIPPED_MEMBERS);
                this.resolveHidOperators(configInfo, true, semanticEnableRaw, ELABCONSTANTS_SKIPPED_MEMBERS);
                this.elaborateInnerClassParentsRecursive(this, manager);
            }
        }
        finally {
            this.fElabConstantsLock.unlock();
        }
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        super.resolveHidsUnsafe(configInfo, triggerError, ignoreDirty, semanticEnabled, skipMemberClasses);
    }

    @Override
    protected void resolveHidOperators(ConfigInfo configInfo, boolean triggerError, byte semanticEnabled, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        super.resolveHidOperatorsUnsafe(configInfo, triggerError, semanticEnabled, skipMemberClasses);
    }

    protected void addPackage(RfPackage pack) {
        this.addMember(pack);
    }

    protected void addPrimitive(RfPrimitive primitive) {
        this.addMember(primitive);
    }

    protected void addBindInstance(RfInstance bindInstance, RfNamedElement scope) {
        if (this.binds == null) {
            this.binds = new LinkedHashMap<String, List<RfInstance>>();
        }
        bindInstance.setEnclosingScope(scope);
        List instances = this.binds.computeIfAbsent(bindInstance.getName(), key -> new ArrayList(2));
        instances.add(bindInstance);
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        boolean equals;
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        NullProtectedList<RfPackage> result = new NullProtectedList<RfPackage>();
        Set<RfLibrary> libraries = this.getPkgSearchLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                library.internalGetPackagesWithPrefix(result, prefix, matchType);
            }
            return result;
        }
        this.internalGetPackagesWithPrefix(result, prefix, matchType);
        boolean bl = equals = (matchType & 1) != 0;
        if (equals && !result.isEmpty()) {
            return result;
        }
        for (RfLibrary library : rfProject.getLibraries()) {
            if (library == this) continue;
            library.internalGetPackagesWithPrefix(result, prefix, matchType);
        }
        return result;
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        RfPackage result = null;
        Set<RfLibrary> libraries = this.getPkgSearchLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                result = library.internalGetPackageWithPrefix(prefix, matchType);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        result = this.internalGetPackageWithPrefix(prefix, matchType);
        if (result != null) {
            return result;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        for (RfLibrary library : rfProject.getLibraries()) {
            if (library == this || (result = library.internalGetPackageWithPrefix(prefix, matchType)) == null) continue;
            return result;
        }
        return null;
    }

    protected void internalGetPackagesWithPrefix(Collection<RfPackage> result, String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            RfPackage element = this.getLocalMember(RfPackage.class, prefix, false);
            result.add(element);
            return;
        }
        List<RfPackage> packages = this.getLocalMembers(RfPackage.class);
        if (packages != null) {
            for (RfPackage element : packages) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
            }
        }
    }

    protected RfPackage internalGetPackageWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            return this.getLocalMember(RfPackage.class, prefix, false);
        }
        List<RfPackage> packages = this.getLocalMembers(RfPackage.class);
        if (packages != null) {
            for (RfPackage element : packages) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public List<RfPrimitive> getPrimitivesWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        NullProtectedList<RfPrimitive> result = new NullProtectedList<RfPrimitive>();
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            RfPrimitive element = this.getLocalMember(RfPrimitive.class, prefix, false);
            result.add(element);
            return result;
        }
        List<RfPrimitive> primitives = this.getLocalMembers(RfPrimitive.class);
        if (primitives != null) {
            for (RfPrimitive element : primitives) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public RfPrimitive getPrimitiveWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            return this.getLocalMember(RfPrimitive.class, prefix, false);
        }
        List<RfPrimitive> primitives = this.getLocalMembers(RfPrimitive.class);
        if (primitives != null) {
            for (RfPrimitive element : primitives) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public RfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            return this.getLocalMember(RfConfiguration.class, prefix, false);
        }
        List<RfConfiguration> configurations = this.getLocalMembers(RfConfiguration.class);
        if (configurations != null) {
            for (RfConfiguration element : configurations) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                return element;
            }
        }
        return null;
    }

    public List<RfConfiguration> getConfigurationsWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        NullProtectedList<RfConfiguration> result = new NullProtectedList<RfConfiguration>();
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            RfConfiguration element = this.getLocalMember(RfConfiguration.class, prefix, false);
            result.add(element);
            return result;
        }
        List<RfConfiguration> configurations = this.getLocalMembers(RfConfiguration.class);
        if (configurations != null) {
            for (RfConfiguration element : configurations) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public Map<String, List<RfInstance>> getRawBindsForPersistence() {
        return this.binds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IRfNamedElement, List<IRfInstanceElement>> getAllBindInstances(long useCacheTimestamp) {
        if (useCacheTimestamp > 0L && useCacheTimestamp == this.cacheTimestamp) {
            return this.cachedBinds;
        }
        this.cachedBinds = null;
        this.cacheTimestamp = useCacheTimestamp;
        if (this.binds == null) {
            return null;
        }
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            Collection<List<RfInstance>> instanceLists;
            block10: {
                instanceLists = this.binds.values();
                if (instanceLists != null && !instanceLists.isEmpty()) break block10;
                return null;
            }
            IdentityHashMap<IRfNamedElement, List> result = null;
            Iterator<List<RfInstance>> instancesIterator = instanceLists.iterator();
            while (instancesIterator.hasNext()) {
                List<RfInstance> instances = instancesIterator.next();
                Iterator<RfInstance> instanceIterator = instances.iterator();
                while (instanceIterator.hasNext()) {
                    RfInstance instance = instanceIterator.next();
                    if (instance.hasNoDefs(false)) {
                        instanceIterator.remove();
                        continue;
                    }
                    if (result == null) {
                        result = new IdentityHashMap<IRfNamedElement, List>();
                    }
                    List listOfBinds = result.computeIfAbsent(instance.getEnclosingScope(), key -> new ArrayList());
                    listOfBinds.add(instance);
                }
                if (!instances.isEmpty()) continue;
                instancesIterator.remove();
            }
            this.cachedBinds = result;
            this.cacheTimestamp = useCacheTimestamp;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IRfNamedElement, List<IRfInstanceElement>> collectAllBindInstances(long useCacheTimestamp) {
        if (useCacheTimestamp > 0L && useCacheTimestamp == this.cacheTimestamp) {
            return this.cachedBinds;
        }
        this.cachedBinds = null;
        this.cacheTimestamp = useCacheTimestamp;
        if (this.binds == null) {
            return null;
        }
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            Collection<List<RfInstance>> instanceLists;
            block10: {
                instanceLists = this.binds.values();
                if (instanceLists != null && !instanceLists.isEmpty()) break block10;
                return null;
            }
            LinkedHashMap<IRfNamedElement, List> result = null;
            Iterator<List<RfInstance>> instancesIterator = instanceLists.iterator();
            while (instancesIterator.hasNext()) {
                List<RfInstance> instances = instancesIterator.next();
                Iterator<RfInstance> instanceIterator = instances.iterator();
                while (instanceIterator.hasNext()) {
                    RfInstance instance = instanceIterator.next();
                    if (instance.hasNoDefs(false)) {
                        instanceIterator.remove();
                        continue;
                    }
                    if (result == null) {
                        result = new LinkedHashMap<IRfNamedElement, List>();
                    }
                    List listOfBinds = result.computeIfAbsent(instance.getEnclosingScope(), key -> new ArrayList());
                    listOfBinds.add(instance);
                }
                if (!instances.isEmpty()) continue;
                instancesIterator.remove();
            }
            this.cachedBinds = result;
            this.cacheTimestamp = useCacheTimestamp;
            return result;
        }
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindEnclosingScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        RfInstance bind;
        if (classes != null && (classes.contains(RfInstance.RfBindInstance.class) || classes.contains(RfInstance.class)) && (bind = this.elementPathBindInstance(name, bindEnclosingScope)) != null) {
            return bind;
        }
        return super.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, null, classes, exclude, parserPath, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RfInstance elementPathBindInstance(String elementPathName, IRfNamedElement bindEnclosingScope) {
        if (this.binds == null) {
            return null;
        }
        String simpleName = RfInstance.getSimpleName(elementPathName);
        bindEnclosingScope = bindEnclosingScope != null ? bindEnclosingScope : this;
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            Collection instances = this.binds.get(simpleName);
            if (instances != null) {
                for (RfInstance bindCandidate : instances) {
                    RfNamedElement enclosingBindScope = bindCandidate.getEnclosingScope();
                    if (!elementPathName.equals(bindCandidate.getCustomName()) || !bindEnclosingScope.equals(enclosingBindScope)) continue;
                    return bindCandidate;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasBindInstances(String name) {
        if (this.binds == null) {
            return false;
        }
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            RfInstance instance;
            Collection instances = this.binds.get(name);
            if (instances == null || instances.isEmpty()) {
                return false;
            }
            Iterator instanceIterator = instances.iterator();
            do {
                if (instanceIterator.hasNext()) continue;
                return false;
            } while ((instance = (RfInstance)instanceIterator.next()).hasNoDefs(false));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanBindInstances(String name) {
        if (this.binds == null) {
            return;
        }
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            Collection instances = this.binds.get(name);
            if (instances == null || instances.isEmpty()) {
                return;
            }
            Iterator instanceIterator = instances.iterator();
            while (instanceIterator.hasNext()) {
                RfInstance instance = (RfInstance)instanceIterator.next();
                if (!instance.hasNoDefs(false)) continue;
                instanceIterator.remove();
            }
            if (instances.isEmpty()) {
                this.binds.remove(name);
            }
        }
    }

    public List<RfInstance> getBindInstances(String name, RfNamedElement scope) {
        return this.getBindInstances(name, scope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfInstance> getBindInstances(String name, RfNamedElement scope, boolean doClean) {
        if (this.binds == null) {
            return null;
        }
        Map<String, List<RfInstance>> map = this.binds;
        synchronized (map) {
            Collection instances;
            block9: {
                instances = this.binds.get(name);
                if (instances != null && !instances.isEmpty()) break block9;
                return null;
            }
            ArrayList<RfInstance> result = null;
            Iterator instanceIterator = instances.iterator();
            while (instanceIterator.hasNext()) {
                RfInstance instance = (RfInstance)instanceIterator.next();
                if (doClean && instance.hasNoDefs(false)) {
                    instanceIterator.remove();
                    continue;
                }
                if (scope != null && scope != instance.getEnclosingScope()) continue;
                if (result == null) {
                    result = new ArrayList<RfInstance>();
                }
                result.add(instance);
            }
            if (instances.isEmpty()) {
                this.binds.remove(name);
            }
            return result;
        }
    }

    public List<? extends IRfInstanceElement> getBindInstances(IRfNamedElement scope, long useCacheTimestamp) {
        Map<IRfNamedElement, List<IRfInstanceElement>> binds = this.getAllBindInstances(useCacheTimestamp);
        if (binds == null) {
            return null;
        }
        return binds.get(scope);
    }

    public IRfInstanceElement getBindInstance(String name, IRfNamedElement instanceOrBlock, ElementPath searchInstancePath) {
        List<RfInstance> bindInstances = this.getBindInstances(name, null);
        if (bindInstances == null) {
            return null;
        }
        IRfNamedElement parentType = null;
        if (instanceOrBlock instanceof RfInstance) {
            parentType = ((RfInstance)instanceOrBlock).getAssociatedType();
        } else if (instanceOrBlock instanceof IRfDesignElement || instanceOrBlock instanceof RfGenerateBlock) {
            parentType = instanceOrBlock;
        }
        if (parentType == null) {
            return null;
        }
        for (RfInstance instance : bindInstances) {
            if (instance.isTargetInstance(true, null, searchInstancePath, null)) {
                return instance;
            }
            if (!instance.isTargetInstance(false, parentType.getName(), null, null)) continue;
            return instance;
        }
        return null;
    }

    public RfInstance getClosestBindInstance(String name, RfNamedElement scope) {
        List<RfInstance> instances = this.getBindInstances(name, scope);
        if (instances != null && !instances.isEmpty()) {
            return instances.get(0);
        }
        RfNamedElement enclosingScope = scope.getEnclosingScope();
        if (enclosingScope != null) {
            return this.getClosestBindInstance(name, enclosingScope);
        }
        return null;
    }

    public List<RfPackage> getAllPackages(boolean createNonePkg) {
        NullProtectedList<RfPackage> result = new NullProtectedList<RfPackage>();
        result.addAll(this.getLocalMembers(RfPackage.class));
        if (!createNonePkg) {
            return result;
        }
        RfPackage pkg = new RfPackage("[none]", false);
        pkg.fMembers = this.fMembers;
        if (pkg.fMembers == null || pkg.fMembers.isEmpty()) {
            return result;
        }
        result.add(pkg);
        return result;
    }

    public List<IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        NullProtectedList<IRfDesignElement> result = new NullProtectedList<IRfDesignElement>();
        result.addAll(this.getModulesWithPrefix(prefix, matchType, 1));
        result.addAll(this.getProgramsWithPrefix(prefix, matchType, 1));
        result.addAll(this.getInterfacesWithPrefix(prefix, matchType, 1));
        result.addAll(this.getCheckersWithPrefix(prefix, matchType, 1));
        return result;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (strictEquals) {
            return (IRfDesignElement)this.getLocalMember(DVTRfUtils.MEMBERS_DESIGN, prefix, (IRfNamedElement)null);
        }
        RfNamedElement candidate = this.getModuleWithPrefix(prefix, matchType, 1);
        if (candidate == null) {
            candidate = this.getInterfaceWithPrefix(prefix, matchType, 1);
        }
        if (candidate == null) {
            candidate = this.getProgramWithPrefix(prefix, matchType, 1);
        }
        if (candidate == null) {
            candidate = this.getCheckerWithPrefix(prefix, matchType, 1);
        }
        if (candidate == null) {
            candidate = this.getPrimitiveWithPrefix(prefix, matchType);
        }
        return candidate;
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        boolean equals;
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfTypeAlias.class, 1, RfProject.fTypeAliasValidator, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
        boolean bl = equals = (matchType & 1) != 0;
        if ((first || equals) && !result.isEmpty()) {
            return;
        }
        visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfPackage.class, -1, null, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
        if ((first || equals) && !result.isEmpty()) {
            return;
        }
        visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfModule.class, -1, null, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
        if ((first || equals) && !result.isEmpty()) {
            return;
        }
        visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfProgram.class, -1, null, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
        if ((first || equals) && !result.isEmpty()) {
            return;
        }
        visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfInterface.class, -1, null, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
        if ((first || equals) && !result.isEmpty()) {
            return;
        }
        visited = Collections.newSetFromMap(new IdentityHashMap());
        this.internalGetMembersWithPrefix(visited, result, RfChecker.class, -1, null, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC, true);
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY);
    }

    public void copyLibraryContent(RfLibrary otherLibrary) {
        Collection<RfNamedElement> otherMembers = otherLibrary.getMembers();
        if (otherMembers != null) {
            for (RfNamedElement otherMember : otherMembers) {
                if (otherMember instanceof RfDuplicate) {
                    for (RfNamedElement each : ((RfDuplicate)otherMember).getMembers()) {
                        this.addMember(each);
                    }
                    continue;
                }
                if (this.isAlreadyDefinedPrecompiled(otherMember)) continue;
                this.addMember(otherMember);
            }
        }
        this.fNamesCache = null;
        if (otherLibrary.binds != null) {
            if (this.binds == null) {
                this.binds = new HashMap<String, List<RfInstance>>();
            }
            this.binds.putAll(otherLibrary.binds);
        }
        if (otherLibrary.pkgSearchLibraries != null) {
            if (this.pkgSearchLibraries == null) {
                this.pkgSearchLibraries = new HashSet<RfLibrary>();
            }
            this.pkgSearchLibraries.addAll(otherLibrary.pkgSearchLibraries);
        }
        if (otherLibrary.vunitNames != null) {
            if (this.vunitNames == null) {
                this.vunitNames = new HashSet<String>();
            }
            this.vunitNames.addAll(otherLibrary.vunitNames);
        }
    }

    private boolean isAlreadyDefinedPrecompiled(RfNamedElement element) {
        if (element == null) {
            return false;
        }
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null || members.isEmpty()) {
            return false;
        }
        for (RfNamedElement foundNamedElement : members) {
            RfFileDef elementFile = element.getFile();
            if (elementFile == null || !foundNamedElement.equals(element) || !elementFile.equals(foundNamedElement.getFile())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.binds != null) {
            for (List<RfInstance> instanceList : this.binds.values()) {
                for (RfInstance instance : instanceList) {
                    instance.deepClean();
                }
            }
            this.binds.clear();
            this.binds = null;
        }
        if (this.pkgSearchLibraries != null) {
            this.pkgSearchLibraries.clear();
        }
        this.pkgSearchLibraries = null;
        if (this.vunitNames != null) {
            this.vunitNames.clear();
        }
        this.vunitNames = null;
        if (this.typeReferences != null) {
            this.typeReferences.clear();
        }
        this.typeReferences = null;
        if (this.cachedBinds != null) {
            this.cachedBinds.clear();
        }
        this.cachedBinds = null;
        this.lowerCaseName = null;
    }

    public RfConfiguration getLocalConfiguration(String name) {
        return this.getLocalMember(RfConfiguration.class, name, false);
    }

    public void addConfiguration(RfConfiguration configuration) {
        this.addMember(configuration);
    }

    public IELParamValue getLocalElabConstantValue(String name) {
        ELManager elabManager = this.getRfProject().getELManager();
        if (elabManager == null) {
            return null;
        }
        ELParamValues externalConstants = elabManager.getExternalConstants((IRfNamedElement)this);
        return externalConstants != null ? externalConstants.getValue(name) : null;
    }

    public Map<String, IELParamValue> getLocalElabConstantValues() {
        ELParamValues externalConstants = this.getRfProject().getELManager().getExternalConstants((IRfNamedElement)this);
        return externalConstants != null ? externalConstants.getEntries() : null;
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        IRfNamedElement parentType;
        if (visited != null && visited.contains(this)) {
            return null;
        }
        IRfNamedElement result = super.semanticGetLocalMember(name, hid, parserPath, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
        if (result != null || hid == null) {
            return result;
        }
        IHid parentHid = hid.getParentHid();
        if (parentHid == null) {
            return null;
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof IRfInstanceElement || parentElement instanceof RfInstanceHolder || parentElement instanceof RfGenerateBlock)) {
            return null;
        }
        IRfNamedElement iRfNamedElement = parentType = parentElement instanceof RfInstanceHolder || parentElement instanceof RfGenerateBlock ? parentElement : ((IRfAssociatedTypeElement)parentElement).getAssociatedType();
        if (parentType == null) {
            return null;
        }
        return this.semanticGetBoundInstance(name, hid, parentHid, parentType, null);
    }

    public IRfNamedElement semanticGetBoundInstance(String name, IHid hid, IHid parentHid, IRfNamedElement parentType, RfNamedElement parentScope) {
        if (hid == null || parentHid == null || parentType == null) {
            return null;
        }
        List<RfInstance> bindInstances = this.getBindInstances(name, null);
        if (bindInstances != null) {
            ElementPath hidPath = hid.getHierarchicalPath();
            for (RfInstance instance : bindInstances) {
                if (instance.isTargetInstance(true, null, hidPath, parentHid.getName())) {
                    return instance;
                }
                if (instance.isTargetInstance(false, parentType.getName(), null, null)) {
                    return instance;
                }
                if (parentScope == null || parentScope instanceof IRfLibraryElement || !parentScope.equals(instance.getBindInstanceScope())) continue;
                return instance;
            }
        }
        return null;
    }

    @Override
    public <T extends IRfNamedElement> void getMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.getMembers(result, clazz, prefix, enumPrefixProposals, matchType, local, isFirst, accessModifier, elementFilter);
        if (local <= 2) {
            return;
        }
        if (elementFilter.resultMaxSize() == result.size()) {
            throw new MaxSizeReachedException();
        }
        RfProject rfProject = this.getEnclosingScope(RfProject.class);
        if (rfProject == null) {
            return;
        }
        Collection<RfLibrary> libraries = rfProject.getLibraries();
        if (libraries == null) {
            return;
        }
        for (RfLibrary library : libraries) {
            library.getMembers(result, clazz, prefix, enumPrefixProposals, matchType, 1, isFirst, accessModifier, elementFilter);
        }
    }

    @Override
    protected <T extends RfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, T> result, Class<T> localMembersKind, int localMembersSelect, boolean first, int matchType, String prefix, int local) {
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, local);
        if (local <= 2) {
            return;
        }
        RfProject rfProject = this.getEnclosingScope(RfProject.class);
        if (rfProject == null) {
            return;
        }
        Collection<RfLibrary> libraries = rfProject.getLibraries();
        if (libraries == null) {
            return;
        }
        for (RfLibrary library : libraries) {
            library.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, 1);
            if (!first || result.isEmpty()) continue;
            return;
        }
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        if (local <= 1) {
            return;
        }
        RfProject rfProject = this.getEnclosingScope(RfProject.class);
        if (rfProject == null) {
            return;
        }
        Collection<RfLibrary> libraries = rfProject.getLibraries();
        if (libraries == null) {
            return;
        }
        for (RfLibrary library : libraries) {
            library.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
            if (!first || result.isEmpty()) continue;
            return;
        }
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        Set<RfLibrary> pkgLibraries;
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
        if (isFirst && result instanceof IRfPackageElement && !(result instanceof RfPredefinedPackage) && classes != null && classes.contains(RfPackage.class) && (pkgLibraries = this.getPkgSearchLibraries()) != null && !pkgLibraries.isEmpty()) {
            IRfLibraryElement resultLibrary = result.getEnclosingLibrary();
            for (RfLibrary library : pkgLibraries) {
                if (resultLibrary != library || result == exclude) continue;
                return result;
            }
            return null;
        }
        if (result != null && result != exclude) {
            return result;
        }
        return null;
    }

    @Override
    public void visitNamedElements(RfProject rfProject, IRfNamedElementVisitor visitor) throws Exception {
        super.visitNamedElements(rfProject, visitor);
        if (this.binds == null || this.binds.isEmpty()) {
            return;
        }
        for (List<RfInstance> binds : this.binds.values()) {
            for (RfInstance bind : binds) {
                if (bind == null || bind.hasNoDefs(false)) continue;
                bind.visitNamedElements(rfProject, visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String typeName, IRfNamedElement referencedIn) {
        if (typeName == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        if (referencedIn instanceof IRfSpecializedTypeElement) {
            referencedIn = ((IRfSpecializedTypeElement)referencedIn).getGenericElement();
        }
        RfLibrary rfLibrary = this;
        synchronized (rfLibrary) {
            OptimizedIdentityHashSet types;
            if (this.typeReferences == null) {
                this.typeReferences = new HashMap<String, Set<IRfNamedElement>>();
            }
            if ((types = this.typeReferences.get(typeName)) == null) {
                types = new OptimizedIdentityHashSet();
                this.typeReferences.put(typeName, (Set<IRfNamedElement>)types);
            }
            types.add((IRfNamedElement)referencedIn);
        }
    }

    public void addReferenceInClosestContainer(String typeName, IRfNamedElement referencedIn) {
        IRfScopeElement scope;
        if (referencedIn != null && (scope = referencedIn.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) instanceof IRfNamedElement) {
            referencedIn = (IRfNamedElement)scope;
        }
        this.addReference(typeName, referencedIn);
    }

    public void addReference(DataType dataType, IRfNamedElement referencedIn) {
        List<DataType> orderedParamAssignments;
        List<DataType> innerClassInfo;
        String typeName;
        String packageOrClassName;
        if (dataType == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        DataType packageScope = dataType.getPackageScope();
        if (packageScope != null && (packageOrClassName = packageScope.getType()) != null) {
            referencedIn.addReferenceToIdentifierName(packageOrClassName);
            this.addReference(packageOrClassName, referencedIn);
        }
        if ((typeName = dataType.getType()) != null) {
            int dotPosition;
            int n = dotPosition = typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/") ? -1 : typeName.indexOf(46);
            if (dotPosition != -1 && dotPosition + 1 < typeName.length()) {
                String interfaceName = typeName.substring(0, dotPosition);
                referencedIn.addReferenceToIdentifierName(interfaceName);
                this.addReference(interfaceName, referencedIn);
                String modportName = typeName.substring(dotPosition + 1);
                referencedIn.addReferenceToIdentifierName(modportName);
                this.addReference(modportName, referencedIn);
            } else {
                referencedIn.addReferenceToIdentifierName(typeName);
                this.addReference(typeName, referencedIn);
            }
        }
        if ((innerClassInfo = dataType.getInnerClassesInfo()) != null && !innerClassInfo.isEmpty()) {
            for (DataType innerClass : innerClassInfo) {
                String innerClassName = innerClass.getType();
                if (innerClassName == null) continue;
                referencedIn.addReferenceToIdentifierName(innerClassName);
                this.addReference(innerClassName, referencedIn);
            }
        }
        if ((orderedParamAssignments = dataType.getOrderedParamAssignments()) != null && !orderedParamAssignments.isEmpty()) {
            for (DataType orderedParamAssignment : orderedParamAssignments) {
                String orderedParamName = orderedParamAssignment.getType();
                if (orderedParamName == null) continue;
                referencedIn.addReferenceToIdentifierName(orderedParamName);
                this.addReference(orderedParamName, referencedIn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IRfNamedElement> getReferences(String typeName) {
        if (this.typeReferences == null) {
            return null;
        }
        RfLibrary rfLibrary = this;
        synchronized (rfLibrary) {
            Set<IRfNamedElement> references;
            block6: {
                references = this.typeReferences.get(typeName);
                if (references != null && !references.isEmpty()) break block6;
                return null;
            }
            Iterator<IRfNamedElement> iterator = references.iterator();
            while (iterator.hasNext()) {
                IRfNamedElement reference = iterator.next();
                if (reference instanceof RfLibrary || !reference.hasNoDefs(false)) continue;
                iterator.remove();
            }
            return new ArrayList<IRfNamedElement>(references);
        }
    }

    @NotNull
    public Set<RfLibrary> getPkgSearchLibraries() {
        if (this.pkgSearchLibraries == null) {
            Collection<RfLibrary> libraries;
            RfProject rfProject = this.getRfProject();
            if (rfProject == null) {
                return Collections.emptySet();
            }
            this.pkgSearchLibraries = Collections.emptySet();
            String thisName = this.getName();
            Set libraryNameList = BuildConfigManager.getPkgSearchLibraries((IProject)rfProject.getProject(), (String)thisName);
            if (libraryNameList.isEmpty()) {
                libraryNameList = BuildConfigManager.getLibListLibraries((IProject)rfProject.getProject(), (String)thisName);
            }
            if (libraryNameList.isEmpty() && IBuildConfigParserConstants.IUS_TOOLS.contains(rfProject.getToolCompat()) && "work".equals(thisName)) {
                libraryNameList = BuildConfigManager.getPkgSearchLibraries((IProject)rfProject.getProject(), (String)"worklib");
            }
            if (libraryNameList != null && !libraryNameList.isEmpty() && (libraries = rfProject.getLibrariesByNames(libraryNameList)) != null && !libraries.isEmpty()) {
                this.pkgSearchLibraries = new LinkedHashSet<RfLibrary>();
                this.pkgSearchLibraries.addAll(libraries);
            }
            if (!this.pkgSearchLibraries.isEmpty()) {
                this.pkgSearchLibraries.add(rfProject.getLocalLibrary("<std>"));
            }
        }
        return this.pkgSearchLibraries;
    }

    public void cleanElaborationInfoFromDesigns() {
        this.accept(this.getRfProject(), namedElement -> {
            if (namedElement instanceof IRfDesignElement) {
                RfMixedLangProject.recursiveCleanElaborationInfoFromDesign((IRfDesignElement)((IRfDesignElement)namedElement));
            } else if (namedElement instanceof IRfPackageElement) {
                RfMixedLangProject.cleanElaborationInfoFromPackages((IRfPackageElement)((IRfPackageElement)namedElement));
            }
            return true;
        });
    }

    @Override
    protected final void checkAssociatedTypes(ConfigInfo configInfo, Collection<? extends RfNamedElement> members, boolean triggerError, boolean ignoreDirty) throws BuildCancelException {
        if (members == null) {
            return;
        }
        if (configInfo.incremental && this.hasChangedImports()) {
            ignoreDirty = true;
        }
        for (RfNamedElement rfNamedElement : members) {
            if (configInfo.incremental && (rfNamedElement instanceof RfPackage ? ((RfPackage)rfNamedElement).getSemanticEnableRaw() != 0 : ELAB_SKIPPED_MEMBERS.contains(rfNamedElement.getClass()))) continue;
            this.checkAssociatedTypeMember(configInfo, triggerError, ignoreDirty, rfNamedElement);
        }
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        if (this.isPredefined()) {
            return;
        }
        if (previous != null) {
            if (IRfNamedElement.QualifiedNameOptions.contains((int)2, (int)options)) {
                return;
            }
            if (IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
                return;
            }
        }
        result.append(this.getName());
        result.append(previous == null ? "" : ".");
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VLOG_LIBRARY;
    }

    @Override
    protected void checkUnused(RfProject rfProject, boolean isPrecompiledLoad) throws BuildCancelException {
        rfProject.checkBuildCanceled();
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        Collection<? extends IRfNamedElement> members = super.xGetLocalMembers();
        ArrayList<Object> result = new ArrayList<Object>(members == null ? 0 : members.size() + 1);
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            if (members != null) {
                result.addAll(members);
            }
            return result;
        }
        result.add((IRfNamedElement)rfProject.getLibraryWithPrefix("<std>", 1).getLocalMembers(true).get((Object)"std"));
        if (members != null) {
            result.addAll(members);
        }
        String thisLibraryName = this.getCustomName();
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        if (mixedLangProject != null && mixedLangProject.isMixed()) {
            List<IRfPackageElement> otherLangPackages = rfProject.getOtherLangPackagesWithPrefix("", 2);
            if (otherLangPackages == null || otherLangPackages.isEmpty()) {
                return result;
            }
            for (IRfPackageElement otherLangPackage : otherLangPackages) {
                IRfLibraryElement enclosingLibrary = otherLangPackage.getEnclosingLibrary();
                if (enclosingLibrary == null || !thisLibraryName.equals(enclosingLibrary.getCustomName())) continue;
                result.add(otherLangPackage);
            }
        }
        return result;
    }

    public ELParamValues xGetLocalElabConstantValues() {
        return this.getRfProject().getELManager().getExternalConstants((IRfNamedElement)this);
    }

    public List<? extends IRfPackageElement> getLocalPackages() {
        return this.getLocalMembers(RfPackage.class);
    }

    class SemanticWorker
    implements Runnable {
        private RfPackage rfPackage;
        private boolean triggerError;
        private boolean hidsNotOperators;
        private ConfigInfo configInfo;

        public SemanticWorker(ConfigInfo configInfo, boolean triggerError, RfPackage packg, boolean hidsNotOperators) {
            this.configInfo = configInfo;
            this.rfPackage = packg;
            this.triggerError = triggerError;
            this.hidsNotOperators = hidsNotOperators;
        }

        @Override
        public void run() {
            try {
                if (this.hidsNotOperators) {
                    if (this.rfPackage != null) {
                        this.rfPackage.resolveHids(this.configInfo, this.triggerError, false, (byte)3, ELAB_SKIPPED_MEMBERS);
                    } else {
                        RfLibrary.super.resolveHids(this.configInfo, this.triggerError, false, (byte)3, ELAB_SKIPPED_MEMBERS);
                    }
                } else if (this.rfPackage != null) {
                    this.rfPackage.resolveHidOperators(this.configInfo, this.triggerError, (byte)3, ELAB_SKIPPED_MEMBERS);
                } else {
                    RfLibrary.super.resolveHidOperators(this.configInfo, this.triggerError, (byte)3, ELAB_SKIPPED_MEMBERS);
                }
            }
            catch (BuildCancelException buildCancelException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

