/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfNonStandardFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

public class RfListType
extends RfAssociatedType
implements IRfListType {
    private static final long serialVersionUID = 2L;
    protected static final byte FIXED_KIND = 1;
    protected static final byte DYNAMIC_KIND = 2;
    protected static final byte QUEUE_KIND = 3;
    protected static final byte ASSOCIATIVE_KIND = 4;
    private static final IndexType LOCATOR_INDEX_TYPE = new IndexType("$");
    public static final String UNPACKED_DIMENSIONS_DELIM = " #";
    public static final String XOR = "xor";
    public static final String OR = "or";
    public static final String AND = "and";
    public static final String PRODUCT = "product";
    public static final String SUM = "sum";
    public static final String SHUFFLE = "shuffle";
    public static final String RSORT = "rsort";
    public static final String SORT = "sort";
    public static final String REVERSE = "reverse";
    public static final String UNIQUE_INDEX = "unique_index";
    public static final String UNIQUE = "unique";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String FIND_LAST_INDEX = "find_last_index";
    public static final String FIND_LAST = "find_last";
    public static final String FIND_FIRST_INDEX = "find_first_index";
    public static final String FIND_FIRST = "find_first";
    public static final String FIND_INDEX = "find_index";
    public static final String FIND = "find";
    public static final String DELETE = "delete";
    public static final String SIZE = "size";
    public static final String NEW = "new";
    public static final String EMPTY = "empty";
    public static final String PUSH_BACK = "push_back";
    public static final String PUSH_FRONT = "push_front";
    public static final String POP_BACK = "pop_back";
    public static final String POP_FRONT = "pop_front";
    public static final String INSERT = "insert";
    public static final String PICK = "pick";
    public static final String PREV = "prev";
    public static final String NEXT = "next";
    public static final String LAST = "last";
    public static final String FIRST = "first";
    public static final String EXISTS = "exists";
    public static final String NUM = "num";
    public static final Set<String> ARRAY_REDUCTION_METHODS = new LinkedHashSet<String>();
    public static final Set<String> ARRAY_PREDEFINED_METHODS = new LinkedHashSet<String>();
    public static final Set<String> DYNAMIC_ARRAY_PREDEFINED_METHODS = new LinkedHashSet<String>();
    public static final Set<String> QUEUE_PREDEFINED_METHODS = new LinkedHashSet<String>();
    public static final Set<String> ASSOCIATIVE_ARRAY_PREDEFINED_METHODS = new LinkedHashSet<String>();
    private final RfNamedElement occurrence;
    protected byte kind;

    static {
        LOCATOR_INDEX_TYPE.setRangeObject((IHidObject)RfHidImplicit.makeImplicit("$", 533));
        ARRAY_REDUCTION_METHODS.add(SUM);
        ARRAY_REDUCTION_METHODS.add(PRODUCT);
        ARRAY_REDUCTION_METHODS.add(AND);
        ARRAY_REDUCTION_METHODS.add(OR);
        ARRAY_REDUCTION_METHODS.add(XOR);
        ARRAY_PREDEFINED_METHODS.addAll(ARRAY_REDUCTION_METHODS);
        ARRAY_PREDEFINED_METHODS.add(FIND);
        ARRAY_PREDEFINED_METHODS.add(FIND_INDEX);
        ARRAY_PREDEFINED_METHODS.add(FIND_FIRST);
        ARRAY_PREDEFINED_METHODS.add(FIND_FIRST_INDEX);
        ARRAY_PREDEFINED_METHODS.add(FIND_LAST);
        ARRAY_PREDEFINED_METHODS.add(FIND_LAST_INDEX);
        ARRAY_PREDEFINED_METHODS.add(MIN);
        ARRAY_PREDEFINED_METHODS.add(MAX);
        ARRAY_PREDEFINED_METHODS.add(UNIQUE);
        ARRAY_PREDEFINED_METHODS.add(UNIQUE_INDEX);
        ARRAY_PREDEFINED_METHODS.add(REVERSE);
        ARRAY_PREDEFINED_METHODS.add(SORT);
        ARRAY_PREDEFINED_METHODS.add(RSORT);
        ARRAY_PREDEFINED_METHODS.add(SHUFFLE);
        DYNAMIC_ARRAY_PREDEFINED_METHODS.addAll(ARRAY_PREDEFINED_METHODS);
        DYNAMIC_ARRAY_PREDEFINED_METHODS.add(NEW);
        DYNAMIC_ARRAY_PREDEFINED_METHODS.add(SIZE);
        DYNAMIC_ARRAY_PREDEFINED_METHODS.add(DELETE);
        QUEUE_PREDEFINED_METHODS.addAll(ARRAY_PREDEFINED_METHODS);
        QUEUE_PREDEFINED_METHODS.add(SIZE);
        QUEUE_PREDEFINED_METHODS.add(INSERT);
        QUEUE_PREDEFINED_METHODS.add(DELETE);
        QUEUE_PREDEFINED_METHODS.add(POP_FRONT);
        QUEUE_PREDEFINED_METHODS.add(POP_BACK);
        QUEUE_PREDEFINED_METHODS.add(PUSH_FRONT);
        QUEUE_PREDEFINED_METHODS.add(PUSH_BACK);
        QUEUE_PREDEFINED_METHODS.add(EMPTY);
        QUEUE_PREDEFINED_METHODS.add(PICK);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.addAll(ARRAY_PREDEFINED_METHODS);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(NUM);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(SIZE);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(DELETE);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(EXISTS);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(FIRST);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(LAST);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(NEXT);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(PREV);
        ASSOCIATIVE_ARRAY_PREDEFINED_METHODS.add(EMPTY);
    }

    public static boolean isFixedArray(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isFixedArray();
    }

    public static boolean isDynamicArray(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isDynamicArray();
    }

    public static boolean isQueue(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isQueue();
    }

    public static boolean isBoundQueue(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isBoundQueue();
    }

    public static boolean isAssociativeArray(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isAssociativeArray();
    }

    public static boolean isNotFixedArray(IRfScopeElement candidate) {
        return candidate instanceof RfListType && ((RfListType)candidate).isNotFixedArray();
    }

    public static String[] splitUnpackedDimesnions(String typeName) {
        int idx = 0;
        while (idx < typeName.length()) {
            if (typeName.charAt(idx) == UNPACKED_DIMENSIONS_DELIM.charAt(0)) {
                int splitIdx = idx + 1;
                if (splitIdx == typeName.length()) break;
                if (typeName.charAt(splitIdx) == UNPACKED_DIMENSIONS_DELIM.charAt(1)) {
                    if (++splitIdx == typeName.length()) break;
                    if (typeName.charAt(splitIdx) == '[') {
                        return new String[]{typeName.substring(0, splitIdx - 2), typeName.substring(splitIdx, typeName.length())};
                    }
                }
            }
            ++idx;
        }
        return new String[]{typeName, ""};
    }

    private static DataType copyForList(DataType dataType, RfNamedElement occurence) {
        DataType listDataType = dataType.copy();
        listDataType.setPackedDimension(null);
        listDataType.appendPackedDimension(dataType.getPackedDimension());
        listDataType.setUnpackedDimension(null);
        listDataType.appendUnpackedDimension(dataType.getUnpackedDimension());
        listDataType.fDirection = 0;
        if (listDataType.fType == null && (!listDataType.fIsVerilog || listDataType.fDiscipline == null) && occurence instanceof RfAssociatedType) {
            listDataType.fType = ((RfAssociatedType)occurence).implicitTypeName();
        }
        return listDataType;
    }

    public RfListType(RfAssociatedType occurrence) {
        this(null, occurrence.getDataType(), occurrence instanceof RfPredefinedFunction && occurrence.getEnclosingScope() instanceof RfListType ? ((RfListType)occurrence.getEnclosingScope()).getOccurrence() : occurrence);
    }

    public RfListType(String name, DataType dataType, RfNamedElement occurrence) {
        super(DVTStringUtil.intern((String)(name == null ? "@" : name)), false, RfListType.copyForList(dataType, occurrence));
        this.occurrence = occurrence;
        if (occurrence != null) {
            this.setEnclosingScope(occurrence.getRfProject());
        }
        this.kind = this.internalGetListKind();
    }

    protected RfListType(DataType dataType, RfNamedElement occurrence) {
        super(DVTStringUtil.intern((String)"@"), false, RfListType.copyForList(dataType, occurrence));
        this.occurrence = occurrence;
        if (occurrence != null) {
            this.setEnclosingScope(occurrence.getRfProject());
        }
    }

    protected byte internalGetListKind() {
        if (super.isDynamicArray()) {
            return 2;
        }
        if (super.isQueue()) {
            return 3;
        }
        if (super.isAssociativeArray()) {
            return 4;
        }
        return 1;
    }

    public int getNofPackedDimensions() {
        DataType dataType = this.getDataType();
        if (dataType.getPackedDimension() == null) {
            return 0;
        }
        return dataType.getPackedDimension().size();
    }

    public int getNofUnpackedDimensions() {
        DataType dataType = this.getDataType();
        if (dataType.getUnpackedDimension() == null) {
            return 0;
        }
        return dataType.getUnpackedDimension().size();
    }

    public int getNofDimensions() {
        int nofDimensions = 0;
        DataType dataType = this.getDataType();
        if (dataType.getPackedDimension() != null) {
            nofDimensions += dataType.getPackedDimension().size();
        }
        if (dataType.getUnpackedDimension() != null) {
            nofDimensions += dataType.getUnpackedDimension().size();
        }
        return nofDimensions;
    }

    @Override
    public String getName() {
        return this.getQualifiedName();
    }

    public RfNamedElement getOccurrence() {
        return this.occurrence;
    }

    @Override
    public RfDefElement getDeclaration() {
        if (this.occurrence != null && !this.occurrence.isDirtyElement()) {
            return this.occurrence.getDeclaration();
        }
        return super.getDeclaration();
    }

    @Override
    public final String getSignature(RfTypesResolver resolver) {
        return "type " + this.getName();
    }

    @Override
    public void setDataType(DataType listDT) {
        this.init(listDT);
        String fullTypeName = listDT.getTypeName(this.implicitTypeName(), this.implicitNetType());
        this.setName(fullTypeName, this.isEscaped());
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfTypeAlias> getTypeAliasesWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfScalarType> getScalarTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfScalarType getScalarTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfClass> getClassesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return super.getFieldsWithPrefix(prefix, matchType, 1, accessModifier);
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfStruct> getStructsUnionsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getStructUnionWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfStruct> getEnumTypesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getEnumTypeWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getEnumElementsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(boolean hideDuplicates, Class<T> clazz) {
        if (RfFunction.class.isAssignableFrom(clazz)) {
            ArrayList<RfPredefinedFunction> result = new ArrayList<RfPredefinedFunction>();
            for (String methodName : this.getPredefinedMethodNames()) {
                result.add(this.getPredefinedMethod(methodName));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    @Override
    public DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(boolean rawMembers) {
        if (rawMembers) {
            return null;
        }
        DVTLinkedHashMap result = new DVTLinkedHashMap();
        for (String methodName : this.getPredefinedMethodNames()) {
            result.put(null, (IDVTMapElement)this.getPredefinedMethod(methodName));
        }
        return result;
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers, boolean incremental) {
        if (RfFunction.class.isAssignableFrom(clazz)) {
            return (T)this.getPredefinedMethod(name);
        }
        return null;
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        if (classes == null || classes.contains(RfFunction.class) || classes.contains(RfPredefinedFunction.class)) {
            return this.getPredefinedMethod(name);
        }
        return null;
    }

    public DataType getIndexTypeRaw() {
        if (!this.isAssociativeArray()) {
            return new DataType("int");
        }
        DataType dataType = this.getDataType();
        return (DataType)dataType.getFirstAssocArrayIndexType();
    }

    public DataType getIndexTypeRaw(int dimensionIdx) {
        RfListType listType = this;
        while (dimensionIdx > 0) {
            IRfNamedElement assocType = listType.getAssociatedType();
            if (assocType instanceof RfTypeAlias) {
                assocType = ((RfTypeAlias)assocType).getTranslatedType();
            }
            if (!(assocType instanceof RfListType)) {
                return null;
            }
            listType = (RfListType)assocType;
            --dimensionIdx;
        }
        return dimensionIdx == 0 ? listType.getIndexTypeRaw() : null;
    }

    public IRfNamedElement getIndexType() {
        DataType indexType = this.getIndexTypeRaw();
        if (indexType == null) {
            return null;
        }
        IHidObject rangeObject = indexType.getRangeObject();
        if (rangeObject == null) {
            return null;
        }
        switch (rangeObject.getHidKind()) {
            case HID: {
                return ((Hid)rangeObject).getElement();
            }
            case IMPLICIT: {
                String predefinedTypeName = ((HidImplicit)rangeObject).getName();
                RfScalarType result = RfProject.PREDEFINED_GLOBAL.getScalarTypeWithPrefix(predefinedTypeName, 1);
                return result instanceof RfBitVectorScalarType ? ((RfBitVectorScalarType)result).getScalarWithSign(indexType.getSign()) : result;
            }
        }
        return null;
    }

    public IRfNamedElement getIndexType(int dimensionIdx) {
        RfListType listType = this;
        while (dimensionIdx > 0) {
            IRfNamedElement assocType = listType.getAssociatedType();
            if (assocType instanceof RfTypeAlias) {
                assocType = ((RfTypeAlias)assocType).getTranslatedType();
            }
            if (!(assocType instanceof RfListType)) {
                return null;
            }
            listType = (RfListType)assocType;
            --dimensionIdx;
        }
        return dimensionIdx == 0 ? listType.getIndexType() : null;
    }

    private Set<String> getPredefinedMethodNames() {
        switch (this.kind) {
            case 2: {
                return DYNAMIC_ARRAY_PREDEFINED_METHODS;
            }
            case 3: {
                return QUEUE_PREDEFINED_METHODS;
            }
            case 4: {
                return ASSOCIATIVE_ARRAY_PREDEFINED_METHODS;
            }
        }
        return ARRAY_PREDEFINED_METHODS;
    }

    protected RfPredefinedFunction getPredefinedMethod(String name) {
        DataType elementDataType = this.getDataType();
        if (elementDataType == null || !elementDataType.hasUnpackedDimension()) {
            return null;
        }
        elementDataType = elementDataType.copy();
        elementDataType.decreaseUnpackedDimension();
        IRfNamedElement elementType = null;
        if (this instanceof RfComputedListType) {
            elementType = this.getAssociatedType();
        }
        IndexType indexDataType = this.getDataType().getFirstIndexType();
        RfPredefinedFunction predefined = null;
        List<ArgInfo> argsInfo = OptimizedUtils.listAdd(null, (Object)new ArgInfo("iterator", elementDataType.copy(), "[optional]", null));
        ((ArgInfo)argsInfo.get(0)).setTransientAssociatedType(elementType);
        DataType locatorIndexMethodDataType = indexDataType instanceof DataType ? ((DataType)indexDataType).copy() : new DataType("int");
        DataType locatorMethodDataType = elementDataType.copy();
        locatorIndexMethodDataType.increaseUnpackedDimension(LOCATOR_INDEX_TYPE);
        locatorMethodDataType.increaseUnpackedDimension(LOCATOR_INDEX_TYPE);
        RfListType locatorIndexMethodType = null;
        RfListType locatorMethodType = null;
        if (this instanceof RfComputedListType) {
            RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)elementType, elementType.getRfProject(), 0);
            locatorMethodType = typesResolver.computeListType(elementType, this, locatorMethodDataType);
            RfComputedListType.Dimension lastDimension = ((RfComputedListType)this).getLastDimension();
            locatorIndexMethodType = typesResolver.computeListType((IRfNamedElement)(lastDimension instanceof RfComputedListType.TypeDimension ? ((RfComputedListType.TypeDimension)lastDimension).type : RfBitVectorScalarType.INT), this, locatorIndexMethodDataType);
        }
        if (FIND.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns all the elements satisfying the given expression");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (FIND_INDEX.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorIndexMethodDataType, argsInfo, 0, "returns indexes of all the elements satisfying the given expression");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorIndexMethodType);
            return predefined;
        }
        if (FIND_FIRST.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns the first element satisfying the given expression");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (FIND_FIRST_INDEX.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorIndexMethodDataType, argsInfo, 0, "returns the index of the first element satisfying the given expression");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorIndexMethodType);
            return predefined;
        }
        if (FIND_LAST.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns the last element satisfying the given expression");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (FIND_LAST_INDEX.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorIndexMethodDataType, argsInfo, 0, "returns the index of the last element satisfying the given expression");
            predefined.internalSetTransientAssociatedType(locatorIndexMethodType);
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (MIN.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns the element with the minimum value or whose expression evaluates to a minimum");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (MAX.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns the element with the maximum value or whose expression evaluates to a maximum");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (UNIQUE.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorMethodDataType, argsInfo, 0, "returns all the elements with unique value or whose expression is unique");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorMethodType);
            return predefined;
        }
        if (UNIQUE_INDEX.equals(name)) {
            predefined = new RfPredefinedFunction(name, locatorIndexMethodDataType, argsInfo, 0, "returns the indexes of all the elements with unique value or whose expression is unique");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(locatorIndexMethodType);
            return predefined;
        }
        DataType voidType = RfProject.getSimpleDataType("void");
        if (REVERSE.equals(name)) {
            predefined = new RfPredefinedFunction(name, voidType, null, 0, "reverses all the elements of the array (packed or unpacked)");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (SORT.equals(name)) {
            predefined = new RfPredefinedFunction(name, voidType, argsInfo, 0, "sorts the unpacked array in ascending order, optionally using the expression in the with clause");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (RSORT.equals(name)) {
            predefined = new RfPredefinedFunction(name, voidType, argsInfo, 0, "sorts the unpacked array in descending order, optionally using the expression in the with clause");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (SHUFFLE.equals(name)) {
            predefined = new RfPredefinedFunction(name, voidType, null, 0, "randomizes the order of the elements in the array");
            predefined.setEnclosingScope(this);
            return predefined;
        }
        if (SUM.equals(name)) {
            predefined = new RfPredefinedFunction(name, elementDataType, argsInfo, 0, "returns the sum of all the array elements, or, if a with clause is specified, returns the sum of the values yielded by evaluating of the expression for each array element");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(elementType);
            return predefined;
        }
        if (PRODUCT.equals(name)) {
            predefined = new RfPredefinedFunction(name, elementDataType, argsInfo, 0, "returns the product of all the array elements, or, if a with clause is specified, returns the product of the values yielded by evaluating of the expression for each array element");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(elementType);
            return predefined;
        }
        if (AND.equals(name)) {
            predefined = new RfPredefinedFunction(name, elementDataType, argsInfo, 0, "returns the bitwise AND (&) of all the array elements, or, if a with clause is specified, returns the bitwise AND of the values yielded by evaluating of the expression for each array element");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(elementType);
            return predefined;
        }
        if (OR.equals(name)) {
            predefined = new RfPredefinedFunction(name, elementDataType, argsInfo, 0, "returns the bitwise OR (|) of all the array elements, or, if a with clause is specified, returns the bitwise OR of the values yielded by evaluating of the expression for each array element");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(elementType);
            return predefined;
        }
        if (XOR.equals(name)) {
            predefined = new RfPredefinedFunction(name, elementDataType, argsInfo, 0, "returns the logical XOR (^) of all the array elements, or, if a with clause is specified, returns the logical XOR of the values yielded by evaluating of the expression for each array element");
            predefined.setEnclosingScope(this);
            predefined.internalSetTransientAssociatedType(elementType);
            return predefined;
        }
        if (this.isDynamicArray()) {
            if (SIZE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), null, 0, "returns the current size of the dynamic array or 0 if the array has not been created");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (DELETE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), null, 0, "empties the array, resulting in a zero-sized array");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            DataType dataType = this.getDataType();
            List args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("item", dataType.copy(), "[optional]", null));
            if (NEW.equals(name)) {
                predefined = new RfPredefinedFunction(name, dataType.copy(), args, 2, "sets the size of a dynamic array and initializes its elements");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            return predefined;
        }
        if (this.isQueue()) {
            if (SIZE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), null, 0, "returns the number of items in the queue");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            argsInfo = new ArrayList<ArgInfo>(2);
            argsInfo.add(new ArgInfo("index", RfProject.getSimpleDataType("int"), null));
            argsInfo.add(new ArgInfo("item", elementDataType.copy(), null));
            ((ArgInfo)argsInfo.get(1)).setTransientAssociatedType(elementType);
            if (INSERT.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), argsInfo, 0, "inserts the given item at the specified index position");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            argsInfo = OptimizedUtils.listAdd(null, (Object)new ArgInfo("index", new DataType("int"), "[optional]", null));
            if (DELETE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), argsInfo, 0, "deletes the item at the specified index position. If the index is not specified, then the delete() method deletes all the elements in the queue, leaving the queue empty.");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (POP_FRONT.equals(name)) {
                predefined = new RfPredefinedFunction(name, elementDataType, null, 0, "removes and returns the first element of the queue");
                predefined.setEnclosingScope(this);
                predefined.internalSetTransientAssociatedType(elementType);
                return predefined;
            }
            if (POP_BACK.equals(name)) {
                predefined = new RfPredefinedFunction(name, elementDataType, null, 0, "removes and returns the last element of the queue");
                predefined.setEnclosingScope(this);
                predefined.internalSetTransientAssociatedType(elementType);
                return predefined;
            }
            argsInfo = OptimizedUtils.listAdd(null, (Object)new ArgInfo("item", elementDataType, null));
            argsInfo.get(0).setTransientAssociatedType(elementType);
            if (PUSH_FRONT.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), argsInfo, 0, "inserts the given element at the front of the queue");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (PUSH_BACK.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), argsInfo, 0, "inserts the given element at the end of the queue");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (EMPTY.equals(name)) {
                predefined = new RfNonStandardFunction(name, RfProject.getSimpleDataType("bool"), null, 0, "returns true if the list has no elements");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (PICK.equals(name)) {
                predefined = new RfNonStandardFunction(name, elementDataType, null, 0, "retrieves, but does not remove, the head of this queue, or returns null if this queue is empty");
                predefined.setEnclosingScope(this);
                predefined.internalSetTransientAssociatedType(elementType);
                return predefined;
            }
            return predefined;
        }
        if (this.isAssociativeArray()) {
            RfComputedListType.Dimension lastDimension;
            if (NUM.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), null, 0, "returns the number of entries in the associative array");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (SIZE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), null, 0, "returns the number of entries in the associative array");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (EMPTY.equals(name)) {
                predefined = new RfNonStandardFunction(name, RfProject.getSimpleDataType("bool"), null, 0, "returns true if the list has no elements");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            IRfTypeElement indexType = null;
            if (this instanceof RfComputedListType && (lastDimension = ((RfComputedListType)this).getLastDimension()) instanceof RfComputedListType.TypeDimension) {
                indexType = ((RfComputedListType.TypeDimension)lastDimension).type;
            }
            List argsInfo2 = OptimizedUtils.listAdd(null, (Object)new ArgInfo("index", indexDataType instanceof DataType ? ((DataType)indexDataType).copy() : new DataType(indexDataType.getType()), "[optional]", null));
            ((ArgInfo)argsInfo2.get(0)).setTransientAssociatedType((IRfNamedElement)indexType);
            if (DELETE.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("void"), argsInfo2, 0, "empties the array, resulting in a zero-sized array. If the index is specified, then the delete() method removes the entry at the specified index. If the entry to be deleted does not exist, the method issues no warning.");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (EXISTS.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), argsInfo2, 0, "checks whether an element exists at the specified index within the array. It returns 1 if the element exists, otherwise it returns 0.");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            DataType refIndexType = indexDataType instanceof DataType ? ((DataType)indexDataType).copy() : new DataType(indexDataType.getType());
            refIndexType.setDirection(4);
            argsInfo2 = OptimizedUtils.listAdd(null, (Object)new ArgInfo("index", refIndexType, null, null));
            ((ArgInfo)argsInfo2.get(0)).setTransientAssociatedType((IRfNamedElement)indexType);
            if (FIRST.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), argsInfo2, 0, "assigns to the given index variable the value of the first(smallest) index in the associative array. It returns 0 if the array is empty;  otherwise, it returns 1.");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (LAST.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), argsInfo2, 0, "assigns to the given index variable the value of the last(largest) index in the associative array. It returns 0 if the array is empty;  otherwise, it returns 1.");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (NEXT.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), argsInfo2, 0, "finds the entry whose index is greater than the given index. If there is a next entry, the index variable is assigned the index of the next entry, and the function returns 1. Otherwise, the index is unchanged, and the function returns 0");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            if (PREV.equals(name)) {
                predefined = new RfPredefinedFunction(name, RfProject.getSimpleDataType("int"), argsInfo2, 0, "finds the entry whose index is smaller than the given index. If there is a previous entry, the index variable is assigned the index of the previous entry, and the function returns 1. Otherwise, the index is unchanged, and the function returns 0");
                predefined.setEnclosingScope(this);
                return predefined;
            }
            return predefined;
        }
        return null;
    }

    @Override
    public boolean hasLocalMembers() {
        return true;
    }

    public boolean isPacked() {
        DataType dataType = this.getDataType();
        return dataType.getUnpackedDimension() == null && dataType.getPackedDimension() != null;
    }

    public boolean isFixedArray() {
        return this.kind == 1;
    }

    @Override
    public boolean isDynamicArray() {
        return this.kind == 2;
    }

    @Override
    public boolean isQueue() {
        return this.kind == 3;
    }

    @Override
    public boolean isAssociativeArray() {
        return this.kind == 4;
    }

    @Override
    public boolean isNotFixedArray() {
        return this.kind > 1;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        result.append(this.getDataType().getTypeName(this.implicitTypeName(), this.implicitNetType(), null, false, false, true));
        result.append(previous == null ? "" : ".");
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.occurrence);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfListType other = (RfListType)obj;
        return this.kind == other.kind;
    }

    @Override
    public String toString() {
        return this.getQualifiedName(5);
    }

    public boolean isBitStream() {
        if (this.isPackedBitStream()) {
            return true;
        }
        IRfNamedElement associatedType = this.getAssociatedType();
        return associatedType != null && associatedType.isBitStream();
    }

    public boolean isPackedBitStream() {
        return this.isPacked();
    }

    public boolean isComplete() {
        return false;
    }

    @Override
    public IRfNamedElement getAssociatedBaseType(RfTypesResolver typesResolver) {
        DataType dataType = this.getDataType();
        DataType baseDataType = dataType.copy();
        if (dataType.hasPackedDimension()) {
            baseDataType.setSign(0);
        }
        baseDataType.setPackedDimension(null);
        baseDataType.setUnpackedDimension(null);
        RfAssociatedTypeWrapper baseTypeWrapper = this.occurrence instanceof RfAssociatedType ? new RfAssociatedTypeWrapper((RfAssociatedType)this.occurrence, baseDataType) : new RfAssociatedTypeWrapper(baseDataType, this.occurrence);
        IRfNamedElement associatedBaseType = baseTypeWrapper.getAssociatedType(typesResolver);
        dataType.fInnerClassesInfo = baseDataType.fInnerClassesInfo;
        dataType.fParametricDependencyValue = (byte)(dataType.fParametricDependencyValue | baseDataType.fParametricDependencyValue);
        return associatedBaseType;
    }

    public final IRfNamedElement getAssociatedBaseTypeNoLastLevelParams(RfTypesResolver typesResolver, boolean returnDummyInfoType) {
        DataType dataType = this.getDataType();
        DataType baseDataType = dataType.copy();
        if (dataType.hasPackedDimension()) {
            baseDataType.setSign(0);
        }
        baseDataType.setPackedDimension(null);
        baseDataType.setUnpackedDimension(null);
        IRfNamedElement associatedBaseType = new RfAssociatedTypeWrapper(baseDataType, this.occurrence.getEnclosingScope()).getAssociatedTypeNoLastLevelParams(typesResolver);
        dataType.fInnerClassesInfo = baseDataType.fInnerClassesInfo;
        dataType.fParametricDependencyValue = (byte)(dataType.fParametricDependencyValue | baseDataType.fParametricDependencyValue);
        return associatedBaseType;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        DataType dataType = this.getDataType().copy();
        boolean hasOnePackedDimension = false;
        if (dataType.hasUnpackedDimension()) {
            dataType.decreaseUnpackedDimension();
        } else if (dataType.hasPackedDimension()) {
            if (dataType.getPackedDimension().size() == 1) {
                hasOnePackedDimension = true;
            }
            dataType.decreasePackedDimension();
        }
        if (dataType.isArray()) {
            return new RfListType(null, dataType, this.occurrence);
        }
        if (hasOnePackedDimension) {
            dataType.setSign(0);
        }
        return new RfAssociatedTypeWrapper(dataType, this.occurrence).getAssociatedTypeNoLastLevelParams(typesResolver, parametricDependency);
    }

    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        return BitVectorContext.of(null, (IRfNamedElement)this, null);
    }

    @Override
    public final BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        return this.getBitVectorContext(evaluator, ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, (ElementPath)hierarchyPath, (boolean)false, (ELManager)manager), this.occurrence);
    }

    public String xGetListSignature() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        return DVTStringUtil.appendString((Object[])new Object[]{dataType.toString(), dataType.getUnpackedDimensionString()});
    }

    @Override
    public boolean xIsClass(boolean resolveTypeAlias) {
        return false;
    }

    @Override
    public boolean xShouldBeSpecializedClass(boolean resolveTypeAlias) {
        return false;
    }

    public boolean xIsDynamicArray() {
        return this.isDynamicArray();
    }

    public boolean xIsQueue() {
        return this.isQueue();
    }

    public boolean xIsAssociativeArray() {
        return this.isAssociativeArray();
    }

    public IHidObject xGetRangeObject() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        List<IndexType> unpacked = dataType.getUnpackedDimension();
        if (unpacked == null || unpacked.isEmpty()) {
            return null;
        }
        return unpacked.get(0).getRangeObject();
    }

    public IDataType xGetAssociativeArrayIndexType() {
        return this.getIndexTypeRaw();
    }

    public IRfMethodElement xGetConstructor() {
        return this.isDynamicArray() ? this.getPredefinedMethod(NEW) : null;
    }

    public BitVectorContext xGetIndexBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        DataType indexType = this.getIndexTypeRaw();
        return indexType == null ? null : indexType.getBitVectorContext(evaluator, guardian, origin);
    }

    public RfField xGetItemField(final IRfNamedElement associatedType) {
        DataType dataType = this.getDataType();
        DataType itemDataType = dataType.copy();
        if (itemDataType.hasUnpackedDimension()) {
            itemDataType.decreaseUnpackedDimension();
        } else if (itemDataType.hasPackedDimension()) {
            itemDataType.decreasePackedDimension();
        }
        RfPredefinedField itemField = new RfPredefinedField("<item>", itemDataType, 0, 0, null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public IRfNamedElement xGetAssociatedType(IHidEvaluator occurenceScope) {
                return associatedType;
            }
        };
        return itemField;
    }
}

