/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTMixedLangBuildListener;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.vlogdt.model.IVlogBuildListener;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.model.VlogFileInfo;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.VlogModule;
import ro.amiq.vlogdt.model.indexer.IdentifierIndexer;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class RfManager
implements IVlogBuildListener,
IDVTMixedLangBuildListener {
    private static volatile RfManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RfManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new RfManager();
            }
        }
        return fInstance;
    }

    public final RfProject getRfProject(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", true);
    }

    public final RfMixedLangProject getMixedProject(IProject project) {
        return RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
    }

    public final RfProject getRfProjectWithoutRestore(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", false);
    }

    public final void fullBuild(DVTFileInfo dvtFileInfo) {
    }

    public final void incrementalBuild(DVTFileInfo dvtFileInfo) {
        VlogFileInfo info = VlogModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.incrementalBuild(info);
    }

    @Deprecated
    public final void postIncrementalBuild(DVTFileInfo dvtFileInfo) {
        VlogFileInfo info = VlogModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postIncrementalBuild(info);
    }

    public final void clean(IDVTProject iDVTProject) {
        IVlogProject vlogProject = VlogModelManager.getInstance().getIEProject(iDVTProject);
        if (vlogProject == null) {
            return;
        }
        IProject project = vlogProject.getProject();
        if (project == null) {
            return;
        }
        IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, vlogProject.getProject()).clean();
        RfProject rfProject = this.getRfProjectWithoutRestore(vlogProject.getProject());
        if (rfProject == null) {
            return;
        }
        rfProject.clean();
        this.getPersistence(project).setDirty();
        try {
            if (MemUtils.COLLECT_STATS) {
                MemUtils.forceGC();
            }
        }
        catch (Exception exception) {}
    }

    public Persistence getPersistence(IProject project) {
        return (Persistence)RfMixedLangManager.getInstance().getPersistence(project, "ro.amiq.vlogdt.VlogNature");
    }

    public final void remove(IDVTFile iDVTFile) {
        IVlogModule vlogProject = VlogModelManager.getInstance().getIEModule(iDVTFile);
        if (vlogProject == null || vlogProject.getFile() == null) {
            return;
        }
        IProject project = vlogProject.getFile().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.getPersistence(project).setDirty();
        rfProject.remove(vlogProject);
        BuildEventManager.getInstance().notifyIncrementalBuild(project, null, null);
    }

    public final void postFullBuild(IDVTProject dvtProject, boolean success) {
        IVlogProject vlogProject = VlogModelManager.getInstance().getIEProject(dvtProject);
        if (!success) {
            this.clean(vlogProject);
            return;
        }
        IProject project = dvtProject.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        rfProject.postFullBuild(true);
    }

    public final void activeTestChangedNotification(IProject project) {
        if (project != null) {
            RfProject rfProject = this.getRfProject(project);
            rfProject.activeTestChangedNotification();
            BuildEventManager.getInstance().notifyIncrementalBuild(project, null, ViewsUtils.ALL_VIEWS);
        }
    }

    public final void clean(IDVTFile dvtFile) {
        VlogModule vlogFile = (VlogModule)VlogModelManager.getInstance().getIEModule(dvtFile);
        if (vlogFile.getResource() == null) {
            return;
        }
        IProject project = vlogFile.getResource().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.getPersistence(project).setDirty();
        ParserPath parserPath = vlogFile.getParserPath();
        rfProject.cleanIncremental(parserPath);
    }

    public void postMixedLangFullBuildPreElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuildPreElab(BuildConfigManager.getFullCompileChecks((IProject)project), true);
    }

    public void postMixedLangFullBuildPostElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuildPostElab(BuildConfigManager.getFullCompileChecks((IProject)project), true);
    }

    public void postIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postIncrementalBuild(changedFiles.get(LanguageKind.VLOG));
    }

    public final void postMixedLangIncrementalBuildPreElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuildPreElab(changedFiles.get(LanguageKind.VLOG), updateViewIds);
    }

    public final void postMixedLangIncrementalBuildPostElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuildPostElab(changedFiles.get(LanguageKind.VLOG), updateViewIds);
    }

    public final void postBuildConfigIncrementalBuild(IProject project) {
    }

    public final void performExtendedChecks(IProject project, ChecksKindWrapper checksKindWrapper) {
    }
}

