/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

public abstract class RfMembersHolder
extends RfNamedElement
implements IRfConstantsHolder {
    private static final long serialVersionUID = 1L;
    protected DVTLinkedHashMap<String, RfNamedElement> fMembers;
    protected RfNamedElement.NamesCache fNamesCache;
    protected RfNamedElement.ImportsExports fImportsExports;
    protected final ReentrantLock fElabConstantsLock = new ReentrantLock(false);
    protected transient RfNamedElement.LinterSpecific1 fLinterSpecific;
    private transient RfHidHolder fHidHolder;

    protected RfMembersHolder(String name, boolean escaped) {
        super(name, escaped);
    }

    @Override
    protected final RfNamedElement.ImportsExports internalGetImportsExports() {
        return this.fImportsExports;
    }

    @Override
    protected final void internalSetImportsExports(RfNamedElement.ImportsExports importsExports) {
        this.fImportsExports = importsExports;
    }

    @Override
    protected DVTLinkedHashMap<String, RfNamedElement> internalGetMembers() {
        return this.fMembers;
    }

    @Override
    protected void internalSetMembers(DVTLinkedHashMap<String, RfNamedElement> members) {
        this.fMembers = members;
    }

    @Override
    protected final RfNamedElement.LinterSpecific1 internalGetLinterSpecific1() {
        return this.fLinterSpecific;
    }

    @Override
    protected final void internalSetLinterSpecific1(RfNamedElement.LinterSpecific1 linterSpecific) {
        this.fLinterSpecific = linterSpecific;
    }

    @Override
    protected final RfNamedElement.NamesCache internalGetNamesCache() {
        return this.fNamesCache;
    }

    @Override
    protected final void internalSetNamesCache(RfNamedElement.NamesCache namesCache) {
        this.fNamesCache = namesCache;
    }

    @Override
    protected final RfHidHolder internalGetHidHolder() {
        return this.fHidHolder;
    }

    @Override
    protected final void internalSetHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    @Override
    public RfDefElement getDeclaration() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclaration();
        }
        return super.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclarations();
        }
        return super.getDeclarations();
    }

    @Override
    public RfDefElement getImplementation() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getImplementation();
        }
        return super.getImplementation();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement genericElement;
        if (!rawDefs && this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.hasNoDefs(rawDefs);
        }
        return super.hasNoDefs(rawDefs);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.fLinterSpecific != null) {
            this.fLinterSpecific.deepClean();
        }
        this.fLinterSpecific = null;
        this.fNamesCache = null;
    }

    protected boolean isBitStream(Set<IRfNamedElement> visited) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.internalGetMembers();
        if (visited.contains(this) || members == null) {
            return false;
        }
        for (RfNamedElement member : members) {
            if (!(member instanceof RfField)) continue;
            IRfNamedElement associatedType = ((RfField)member).getAssociatedType();
            if (associatedType instanceof RfStruct || associatedType instanceof RfClass) {
                visited.add(this);
                if (!((RfMembersHolder)associatedType).isBitStream(visited)) {
                    return false;
                }
                visited.remove(this);
                continue;
            }
            if (associatedType != null && associatedType.isBitStream()) continue;
            return false;
        }
        return true;
    }

    public void elaborateConstants(ELManager manager) {
        if (manager == null) {
            return;
        }
        if (manager.isControlNoParamEval()) {
            return;
        }
        this.fElabConstantsLock.lock();
        try {
            if (manager.getExternalConstants((IRfNamedElement)this) != null) {
                return;
            }
            LinkedHashMap<IRfNamedElement, ELParamValues> working = new LinkedHashMap<IRfNamedElement, ELParamValues>();
            working.put(this, ELParamValues.create((boolean)true));
            manager.addExternalConstants((IRfNamedElement)this, (ELParamValues)working.get(this));
            this.computeConstants(manager, working);
            for (Map.Entry entry : working.entrySet()) {
                manager.addExternalConstants((IRfNamedElement)entry.getKey(), ELUtils.getValidParamValues((ELParamValues)((ELParamValues)entry.getValue())));
            }
        }
        finally {
            this.fElabConstantsLock.unlock();
        }
    }
}

