/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModportFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LFilters;

public class RfModport
extends RfMembersHolder
implements IRfModportElement,
IELDesign {
    private static final long serialVersionUID = 1L;
    protected Set<String> fClockingNames;

    public RfModport(String name, boolean escaped) {
        super(name, escaped);
    }

    public void init(Set<String> clockingNames) {
        this.fClockingNames = clockingNames;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "modport " + this.getName();
    }

    @Override
    protected <T extends RfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, T> result, Class<T> localMembersKind, int localMembersSelect, boolean first, int matchType, String prefix, int local) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (localMembersKind == RfClockingBlock.class) {
            boolean strictEquals;
            boolean bl = strictEquals = matchType == 1;
            if (strictEquals) {
                if (this.hasClocking(prefix)) {
                    enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, 1);
                }
            } else {
                enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, 1);
                if (result != null && !result.isEmpty()) {
                    Iterator<T> it = result.values().iterator();
                    while (it.hasNext()) {
                        IRfNamedElement candidate = (IRfNamedElement)it.next();
                        if (this.hasClocking(candidate.getName())) continue;
                        it.remove();
                    }
                }
            }
        } else if (localMembersKind == RfClockingBlock.class) {
            enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, local);
        } else {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, first, matchType, prefix, local);
        }
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (localMembersKind == RfField.class && localMembersSelect == 0 && local <= 2 && validator != RfProject.fVariableValidator) {
            boolean strictEquals;
            boolean bl = strictEquals = matchType == 1;
            if (strictEquals) {
                if (localMembersKind == RfField.class && (kind == 256 || kind == 128) || this.hasLocalPort(prefix)) {
                    enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                }
            } else {
                enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, 1, accessModifier, imported);
                if (result != null && !result.isEmpty()) {
                    Iterator<Z> it = result.values().iterator();
                    while (it.hasNext()) {
                        IRfNamedElement candidate = (IRfNamedElement)it.next();
                        if (((RfField)candidate).isParameter() || ((RfField)candidate).isTypeParameter() || this.hasLocalPort(candidate.getName())) continue;
                        it.remove();
                    }
                }
            }
        } else if (localMembersKind == RfField.class && localMembersSelect == 0 && (local >= 3 || validator == RfProject.fVariableValidator)) {
            enclosingScope.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        } else {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        }
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        Collection<RfNamedElement> members = this.getMembers(false, false);
        if (members != null) {
            for (RfNamedElement element : members) {
                RfNamedElement designUnitElement;
                if (element instanceof RfDuplicate) {
                    element.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
                    continue;
                }
                if (element instanceof RfModportFunction && (designUnitElement = ((RfModportFunction)element).getDesignUnitElement(prefix)) != null) {
                    element = designUnitElement;
                }
                if (element == null || !elementFilter.validElement((IRfNamedElement)element) || prefix != null && !DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
                if (elementFilter.resultMaxSize() != result.size()) continue;
                throw new MaxSizeReachedException();
            }
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        IRfElementFilter composedFilter = R2LFilters.or(R2LFilters.clockingBlockHasClocking(true, this), R2LFilters.fieldIsParameter(true), R2LFilters.fieldIsTypeParameter(true));
        IRfElementFilter elementFilter2 = R2LFilters.and(elementFilter, composedFilter);
        enclosingScope.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter2);
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String prefix, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumPrefix, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (visited != null && visited.contains(this)) {
            return null;
        }
        IRfNamedElement result = super.semanticGetLocalMember(prefix, hid, parserPath, prevScope, visited, enumPrefix, isFirst, isLast, recursiveCall);
        if (result == null) {
            result = this.getLocalMember(RfModportFunction.class, ".*", true);
        }
        if (result instanceof RfModportFunction) {
            RfNamedElement designUnitElement = ((RfModportFunction)result).getDesignUnitElement(prefix);
            if (designUnitElement != null) {
                return designUnitElement;
            }
            if (".*".equals(result.getName())) {
                return null;
            }
        }
        return result;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
        if (result == null) {
            result = this.getLocalMember(RfModportFunction.class, ".*", true);
        }
        if (result instanceof RfModportFunction) {
            RfNamedElement designUnitElement = ((RfModportFunction)result).getDesignUnitElement(name);
            if (designUnitElement != null && designUnitElement != exclude) {
                return designUnitElement;
            }
            if (".*".equals(result.getName())) {
                return null;
            }
        }
        if (result != null && result != exclude) {
            return result;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        result = enclosingScope.getLocalMember((Set)classes, name, exclude);
        if (result instanceof RfClockingBlock && !this.hasClocking(name)) {
            return null;
        }
        if (result instanceof RfField && !((RfField)result).isTypeParameter() && !((RfField)result).isParameter() && !this.hasLocalPort(name)) {
            return null;
        }
        if (result != null && result != exclude) {
            return result;
        }
        return null;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODPORT);
    }

    public boolean hasLocalPort(String portName) {
        RfPort localPort = this.getLocalMember(RfPort.class, portName, false);
        return localPort != null;
    }

    public boolean hasClocking(String clockingName) {
        if (this.fClockingNames == null) {
            return false;
        }
        return this.fClockingNames.contains(clockingName);
    }

    public IRfDesignElement getParentInterface() {
        return (IRfDesignElement)this.getEnclosingScope();
    }

    @Override
    public RfDefElement getDeclaration() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclaration();
        }
        return super.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclarations();
        }
        return super.getDeclarations();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement genericElement;
        if (!rawDefs && this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.hasNoDefs(rawDefs);
        }
        return super.hasNoDefs(rawDefs);
    }

    @Override
    public boolean hasLocalMembers() {
        boolean result = super.hasLocalMembers();
        if (result) {
            return true;
        }
        return !this.fClockingNames.isEmpty();
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.fClockingNames != null) {
            this.fClockingNames.clear();
        }
        this.fClockingNames = null;
    }

    public IRfInstanceElement xGetInstance() {
        RfInstance instance = RfInstance.create(this.getName(), false, new DataType(this.getName()), 0, null, null);
        instance.internalSetTransientAssociatedType(this);
        return instance;
    }
}

