/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.TimeConsumingStatement;

public class RfModportFunction
extends RfFunction {
    private static final long serialVersionUID = 1L;

    public RfModportFunction(String name, boolean escaped, DataType type, MacroCallInfo macroCallInfo, int kind, int qualifiers, List<TimeConsumingStatement> timeConsumingStatements, String cIdentifier) {
        super(name, escaped, type, macroCallInfo, kind, qualifiers, timeConsumingStatements, cIdentifier);
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        RfNamedElement interfaceElement = this.getDesignUnitElement(null);
        if (interfaceElement instanceof RfAssociatedType) {
            return ((RfAssociatedType)interfaceElement).getAssociatedType(typesResolver);
        }
        return null;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        return this.getAssociatedType();
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.checkBuildCanceled();
        if (!ignoreDirty && !element.internalIsDirtyAssociatedType()) {
            IRfNamedElement associatedType = element.internalGetTransientAssociatedType();
            if (!configInfo.incremental || !rfProject.isInChangedImportScope(associatedType)) {
                return;
            }
        }
        element.internalSetTransientAssociatedType(null);
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return;
        }
        RfNamedElement enclosingDesignElement = this.getDesignUnitElement(null);
        if (enclosingDesignElement instanceof RfField) {
            int line = declaration.getStartLine();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + this.getName().length();
            rfProject.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_MODPORT_IMPORT_EXPORT_FIELD, this.getLibPkgScope(), startOffset, endOffset, null, line, parserPath, this.getName());
        }
    }

    public RfNamedElement getDesignUnitElement(String elementName) {
        String name = this.getName();
        if (".*".equals(name)) {
            name = elementName;
        }
        if (name == null) {
            return null;
        }
        IRfNamedElement enclosingDesignUnit = this.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        if (enclosingDesignUnit == null || !(enclosingDesignUnit instanceof RfNamedElement)) {
            return null;
        }
        RfNamedElement result = ((RfNamedElement)enclosingDesignUnit).getLocalMember(RfFunction.class, name, false);
        if (result != null) {
            return result;
        }
        List<RfField> arguments = this.getArgumentsWithPrefix("", 2);
        if (arguments == null || arguments.isEmpty()) {
            result = ((RfNamedElement)enclosingDesignUnit).getLocalMember(RfField.class, name, false);
        }
        return result;
    }

    @Override
    public String getSignature(RfTypesResolver resolver, boolean addExtraFlags) {
        RfNamedElement designUnitElement = this.getDesignUnitElement(null);
        return designUnitElement != null ? designUnitElement.getSignature(resolver) : super.getSignature(resolver, true);
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        IRfNamedElement enclosingDesignUnit = this.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        return enclosingDesignUnit != null && enclosingDesignUnit == ((RfNamedElement)obj).getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN) && this.getName() != null && this.getName().equals(((RfNamedElement)obj).getName());
    }

    @Override
    public Image getImage() {
        RfNamedElement designUnitElement = this.getDesignUnitElement(null);
        if (designUnitElement != null) {
            return designUnitElement.getImage();
        }
        return super.getImage();
    }
}

