/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

public class RfModportPort
extends RfPort {
    private static final long serialVersionUID = 1L;
    private IHidObject hierarchicalExpr;

    public RfModportPort(String name, boolean escaped, DataType dataType, int kind, IHidObject hierarchicalExpr) {
        super(name, escaped, dataType, kind, null);
        this.hierarchicalExpr = hierarchicalExpr;
    }

    public RfModportPort(RfModportPort port) {
        this(port.getName(), port.isEscaped(), port.getDataType(), (int)port.getPortKind(), port.getHierarchicalExpr());
    }

    public IHidObject getHierarchicalExpr() {
        return this.hierarchicalExpr;
    }

    public void setHierarchicalExpr(IHidObject hierarchicalExpr) {
        this.hierarchicalExpr = hierarchicalExpr;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.hierarchicalExpr = null;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.hierarchicalExpr = null;
    }

    @Override
    public DataType getDataType() {
        RfField interfacePort = this.getDesignUnitPort();
        if (interfacePort == null || interfacePort == this || interfacePort.getDataType() == null) {
            return super.getDataType();
        }
        DataType dataType = interfacePort.getDataType().copy();
        DataType dataType1 = super.getDataType();
        dataType.setDirection(dataType1.getRawDirection());
        this.setDataType(dataType);
        return dataType;
    }

    @Override
    public boolean isNet() {
        if (this.getEnclosingScope() instanceof RfClockingBlock) {
            return false;
        }
        RfField interfacePort = this.getDesignUnitPort();
        return interfacePort != null && interfacePort.isNet();
    }

    @Override
    public IRfNamedElement.NetType xGetNetType() {
        if (this.getEnclosingScope() instanceof RfClockingBlock) {
            return IRfNamedElement.NetType.NONE;
        }
        RfField interfacePort = this.getDesignUnitPort();
        return interfacePort != null ? interfacePort.xGetNetType() : IRfNamedElement.NetType.NONE;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        RfField interfacePort = this.getDesignUnitPort();
        if (interfacePort == null || interfacePort == this) {
            return null;
        }
        return interfacePort.getAssociatedTypeNoLastLevelParams(typesResolver, parametricDependency);
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        RfField interfacePort = this.getDesignUnitPort();
        if (interfacePort == null || interfacePort == this) {
            return null;
        }
        return interfacePort.getAssociatedType(typesResolver);
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
        RfDefElement declaration;
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vlogdt.VlogNature");
        rfProject.checkBuildCanceled();
        if (element.internalIsDirtyAssociatedType()) {
            IRfNamedElement associatedType = element.internalGetTransientAssociatedType();
            if (!configInfo.incremental || !rfProject.isInChangedImportScope(associatedType)) {
                return;
            }
            element.internalSetTransientAssociatedType(null);
        }
        if ((declaration = element.getDeclaration()) == null) {
            return;
        }
        RfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return;
        }
        ParserPath parserPath = defFile.getParserPath();
        RfNamedElement enclosingDesignUnit = this.getEnclosingDesignUnit();
        if (!(enclosingDesignUnit instanceof RfInstanceHolder)) {
            return;
        }
        String enclosingName = enclosingDesignUnit.getName();
        String name = this.getName();
        RfField interfacePort = this.getDesignUnitPort();
        if (!(interfacePort != null || this.isModportClockingNewPort() || this.hierarchicalExpr != null && ((RfInstanceHolder)enclosingDesignUnit).getSemanticEnableRaw() != 3)) {
            int line = declaration.getStartLine();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + name.length();
            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
            attributes.put("QUICKFIX_ELEMENT_NAME", name);
            attributes.put("QUICKFIX_KIND", 1);
            rfProject.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, name, enclosingName);
        }
    }

    public RfNamedElement getEnclosingDesignUnit() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfClockingBlock) {
            return (RfNamedElement)this.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        }
        if (enclosingScope instanceof RfModport) {
            return this.getEnclosingScope(RfInterface.class);
        }
        return null;
    }

    public RfField getDesignUnitPort() {
        Hid hierarchicalExprHid = XUtils.getParentHid((IHidObject)this.hierarchicalExpr);
        if (hierarchicalExprHid != null) {
            IRfNamedElement element = hierarchicalExprHid.getElement();
            if (element == null) {
                ConfigInfo configInfo = new ConfigInfo(false, this.getRfProject(), null, true, null);
                RfHid ancestorHid = (RfHid)hierarchicalExprHid.getAncestorHid();
                RfDefElement declaration = this.getDeclaration();
                ancestorHid.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), this.getEnclosingScope(), this.getEnclosingScope(), declaration != null ? declaration.getParserPath() : null, RfTypesResolver.create((IRfScopeElement)this, configInfo.getRfProject(LanguageKind.VLOG.NATURE_ID), 0), null, (byte)3, false, false, false);
                element = hierarchicalExprHid.getElement();
            }
            return element instanceof RfField ? (RfField)element : null;
        }
        RfNamedElement enclosingDesignUnit = this.getEnclosingDesignUnit();
        if (enclosingDesignUnit == null) {
            return null;
        }
        return enclosingDesignUnit.getLocalMember(RfField.class, this.getName(), false);
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.isModportClockingNewPort()) {
            return false;
        }
        if (obj instanceof RfModportPort && ((RfModportPort)obj).isModportClockingNewPort()) {
            return false;
        }
        IRfNamedElement enclosingDesignUnit = this.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
        return obj instanceof RfField && enclosingDesignUnit != null && enclosingDesignUnit == ((RfNamedElement)obj).getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN) && this.getName() != null && this.getName().equals(((RfNamedElement)obj).getName());
    }

    @Override
    public MaskType xGetInitMaskType() {
        return MaskType.Z;
    }
}

