/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfNamespaceElement
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    public static final String $ROOT = "$root";
    public static final String $UNIT = "$unit";
    private RfLibrary library;

    public RfNamespaceElement(String name, boolean escaped, RfLibrary library) {
        super(name, escaped);
        this.library = library;
        this.setEnclosingScope(library);
    }

    public RfNamespaceElement(String name, RfLibrary library) {
        this(name, false, library);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return this.getName();
    }

    @Override
    public String getComment() {
        if ($ROOT.equals(this.getName())) {
            return "The name is used to unambiguously refer to a top-level instance or to an instance path starting from\nthe root of the instantiation tree. $root is the root of the instantiation tree.";
        }
        if ($UNIT.equals(this.getName())) {
            return "The name is used to explicitly access the identifiers in the compilation-unit scope.";
        }
        return "";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ);
    }

    @Override
    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        if (this.library == null) {
            return;
        }
        RfProject rfProject = this.library.getRfProject();
        if (rfProject == null) {
            return;
        }
        if ($ROOT.equals(this.getName())) {
            RfConfiguration.getTopModulesWithPrefix(result, prefix, matchType, elementFilter, rfProject);
        }
        if ($UNIT.equals(this.getName())) {
            this.library.getElementsWithPrefix(result, prefix, matchType, local, isFirst, accessModifier, elementFilter);
        }
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (this.library == null) {
            return null;
        }
        RfProject rfProject = this.library.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if ($ROOT.equals(this.getName())) {
            return RfConfiguration.getTopModule(name, rfProject);
        }
        if ($UNIT.equals(this.getName())) {
            return this.library.semanticGetLocalMember(name, hid, parserPath, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
        }
        return null;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (this.library == null) {
            return null;
        }
        RfProject rfProject = this.library.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if ($ROOT.equals(this.getName()) && (classes == null || classes.contains(RfModule.class) || classes.contains(RfProgram.class))) {
            return RfConfiguration.getTopModule(name, rfProject);
        }
        if ($UNIT.equals(this.getName())) {
            return this.library.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, false);
        }
        return null;
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean rawMembers) {
        if (this.library == null) {
            return null;
        }
        RfProject rfProject = this.library.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if ($ROOT.equals(this.getName()) && (clazz == null || clazz == RfModule.class || clazz == RfProgram.class)) {
            return (T)RfConfiguration.getTopModule(name, rfProject);
        }
        if ($UNIT.equals(this.getName())) {
            return this.library.getLocalMember(clazz, name, rawMembers);
        }
        return null;
    }

    public RfLibrary getLibrary() {
        return this.library;
    }
}

