/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.text.MessageFormat;

public enum RfNonStandardProblem {
    ASSERTION_IN_CUNIT_SCOPE("Deferred immediate assertion not allowed in compilation-unit scope", "assert #0 (0 == 0);"),
    EXTERN_DECLARATION_IN_CUNIT_SCOPE("Extern function not allowed in compilation-unit scope", "extern int foo();"),
    FATAL_SYSTEM_TASK_FIRST_ARGUMENT("Expecting 0, 1 or 2 as first argument to ''$fatal'' system task", "$fatal(4, \"Sorry\");"),
    BEGIN_END_OUTSIDE_GENERATE("'begin/end' generate block not allowed", ""),
    CONFIGURATION_RULE("Unexpected configuration rule", ""),
    MISSING_CONFIGURATION_RULE_SEMI("Expecting ';' after configuration rule", "instance top.sub.u1 liblist gateLib"),
    TIMEUNIT_IN_CLASS_SCOPE("''{0}'' declaration not allowed in class scope", "class foo;\n\ttimeunit 100ps;\n\ttimeprecision 10fs;\nendclass"),
    FUNCTION_PROTOTYPE("Expecting 'function' keyword in prototype declaration", "extern void foo();"),
    PURE_QUALIFIER_POSITION("'pure' qualifier not allowed before ''{0}'' qualifier", "protected pure local virtual function void wrong_order();"),
    CONSTRUCTOR_LIFETIME("'automatic' lifetime for class constructor not allowed", "class foo;\n\nfunction automatic new();\nendfunction\n\nendclass"),
    CLASS_VARIABLE_LIFETIME("''automatic'' lifetime for class variable ''{0}'' not allowed", "class foo;\n\tautomatic int bar;\nendclass"),
    CONSTRAINT_DEFAULT_QUALIFIER("'default' qualifier for constraint not allowed", "default constraint a_cons {\n\tx == 0;\n\ty <= 0;\n}"),
    HARD_SOLVE_BEFORE("'hard' qualifier not allowed", "constraint c_cons {\n\tx == 0;\n\ty <= 0;\n\tsolve x before y hard;\n}"),
    SOFT_AFTER_EXPRESSION("'soft' must be placed before the expression", "constraint c_cons {\n\tx dist {0, 1} soft; \n}"),
    SOFT_BEFORE_SOFT("'soft' not allowed before 'soft'", "constraint c_cons {\n\tsoft soft x;\n}"),
    SOFT_BEFORE_UNIQUE("'soft' not allowed before 'unique'", "constraint c_cons {\n\tsoft unique {}\n}"),
    SOFT_BEFORE_IF("'soft' not allowed before 'if'", "constraint c_cons {\n\tsoft if (condition) {}\n}"),
    SOFT_BEFORE_FOREACH("'soft' not allowed before 'foreach'", "constraint c_cons {\n\tsoft foreach (array[i]) {}\n}"),
    SOFT_BEFORE_DISABLE("'soft' not allowed before 'disable'", "constraint c_cons {\n\tsoft disable soft x;\n}"),
    PARENTHESES_DIST_EXPRESSION("Enclosing parentheses not allowed for dist expression", "constraint c_cons {\n\t(x dist {0,1});\n\t(foreach (array[i]) { });\n\t(x -> 2);\n}"),
    SPACE_DIST_WEIGHT("Unexpected space between : and {0} in dist weight", "rand int x; \nconstraint c_cons {\n\tx dist {0 : = 3};\n}"),
    DYNAMICPARAM("Unexpected keyword 'dynamicparam'", "dynamicparam p = 3;"),
    CONST_AFTER_STATIC("'const' qualifier not allowed after 'static'", "static const int x = 0;"),
    LIFETIME_QUALIFIER_BEFORE_VAR("''{0}'' qualifier not allowed before ''var''", "automatic var int x = 0;"),
    TYPEDEF_COVERGROUP("Typedef of covergroup not allowed", "typedef covergroup cg;"),
    TYPEDEF_DATATYPE("Explicit data type required (implicit 'logic' is assumed)", "typedef [3:0] new_type;"),
    IMPLICIT_DATA_TYPE_IN_DECLARATION("Expecting net type (e.g. wire) or 'var' keyword before implicit data type", "[3:0] var_or_net;"),
    PACKED_DIMENSION_INTEGER_TYPE("Unexpected packed dimension for integer type", "function integer[3:0] foo();\nendfunction"),
    PACKED_STRUCT_WITH_SIGNING("Expecting 'packed' before signing", "typedef struct signed {\n\tint x;\n\tint y;\n} packed_with_sign;"),
    TYPEOF_SYSTEM_FUNCTION("'$typeof' system function not allowed", "bit[3:0] field;\ntypedef $typeof(field) new_type;"),
    PACKAGE_SCOPE_IN_ENUM_BASE_TYPE("Package scope before enum base type not allowed", "package package_name;\n  typedef int id;\nendpackage\ntypedef enum package_name::id {R,G,B} new_enum;"),
    ENUM_IMPLICIT_DATATYPE("Explicit data type required (implicit ''{0}'' is assumed)", "typedef enum [1:0] {R,G,B} new_enum;"),
    DELAY_VALUE_EXPRESSION("Expecting parentheses around bit-select and part-select", "always ... #del[0] ok = 1;"),
    PARAMETER_DYNAMIC_ARRAY("Fixed size required for parameter dimension", "parameter logic flag1[] = '{2};\nlocalparam logic flag2[] = '{2};"),
    CONST_EXPR_PACKED_DIMENSION("Expecting constant range instead of constant expression for packed dimension", "enum bit[1] { A, B } foo;"),
    QUALIFIER_BEFORE_METHOD("''{0}'' qualifier not allowed before method keyword", "static function foo(); ... endfunction"),
    CLASS_SCOPE_END_LABEL("Class scope ''{0}'::' before end label not allowed", "... endfunction : class_scope::func_name"),
    HIERARCHICAL_INTERFACE_IDENTIFIER("Hierarchical interface identifier ''{0}'.'{1}'' not allowed", "task id1.id2.id3();"),
    PROTOTYPE_RETURN_DATA_TYPE("Expecting return data type or void for function prototype", "extern function doCheck();"),
    DPI_DECLARATION_STRING("Expecting \"DPI\" or \"DPI-C\"", "import \"DPI_C\" init_1 = function void moo();"),
    EMPTY_ARGUMENTS_LIST("Empty arguments list '()' not allowed when arguments are declared inside function/task body", "function void foo();\n\toutput integer x;\nendfunction"),
    DYNAMIC_ARRAY_INITIALIZATION("Unexpected 'new' initialization for dynamic array", "task foo(input int a[] = new[1]);\nendtask"),
    CLASS_INSTANCE_INITIALIZATION("Unexpected 'new' initialization for class instance", "function void foo(cls i = new());\nendfunction"),
    MODPORT_PORTS_DECLARATION("Unexpected empty modport ports declaration", "modport mp_name();"),
    MODPORT_PORT_DIRECTION("Explicit direction required for port ''{0}''", "modport mp_name(x, input y);"),
    MODPORT_HIERARCHICAL_PORT("Hierarchical identifier not allowed in modport port declaration", "modport master (output sb.gnt);"),
    MODPORT_IMPORT_EXPORT("Unexpected .* used in modport import/export declaration", "modport master (import sb.*);"),
    REPETITION_IN_SEQUENCE("Goto repeat '[->' and non-consecutive repeat '[=' operators not allowed", ""),
    COVERPOINT_IFF_EXPRESSION("Expecting parentheses around coverpoint 'iff' expression", "coverpoint a iff test;"),
    BINS_IFF_EXPRESSION("Expecting parentheses around bins 'iff' expression", "bins a = { [0:63],65 } iff ana;"),
    COVERCROSS_IFF_EXPRESSION("Expecting parentheses around covercross 'iff' expression", ""),
    BINS_SELECTION_IFF_EXPRESSION("Expecting parentheses around bins selection 'iff' expression", ""),
    WILDCARD_BINS_SELECTION("'wildcard' not allowed for bins selection", "covergroup cov @(posedge clk);\n  aXb : cross a, b { wildcard bins i_zero = binsof(a) intersect { 0 }; }\nendgroup"),
    HIERARCHICAL_ACCESS_IN_BINS_EXPRESSION("Cover point hierarchical identifier not allowed in bins expression", "binsof(x.cover_point_id.bin_id);"),
    SELECT_IN_BINS_EXPRESSION("Select not allowed in bins expression", "binsof(cover_point_id.bin_id[3]);"),
    COVERPOINT_EXPRESSION_TYPE("Coverpoint expression should be of an integral data type", ""),
    COVERGROUP_EXPRESSION("Expecting constant expression or non-ref covergroup argument, found ''{0}''", "int field;\ncovergroup cg() with function sample(int unsigned foo);\n    coverpoint foo {\n        ignore_bins ignore = foo with (field > 2);\n    }\nendgroup"),
    CONCATENATION_MULTIPLIER("Expecting constant expression as concatenation multiplier, found ''{0}''", "int field = 8;\nlogic[7:0] x = { field {1'b1}}"),
    PULL_GATE_INSTANCE("Multiple terminals to a pull gate instance not allowed", "pullup p (t1, t2, t3);"),
    IMPLICIT_INSTANCE_NAME("Implicit name not allowed for instance of ''{0}''", "module top(input i, output o);\n  m1(.i(i), .o(o));\nendmodule"),
    PARENTHESES_GATE_TERMINAL("Enclosing parentheses around gate terminal not allowed", "tranif0 ti0 (x, (y), z);"),
    PARAMETER_OVERRIDE("Expecting parentheses around parameter override", "module m #(P1=1)();\nendmodule\nmodule top();\n  m # 3 u_m();\nendmodule"),
    EMPTY_ORDERED_PARAMETER_OVERRIDE("Empty parameter override in ordered list not allowed", "xmm_atomic_gen #(transaction, ,\"Atomic Gen\") msg_rx_gen;"),
    MULTIPLE_DOT_STAR_CONNECTIONS("Dot start port connection '.*' cannot appear more than once in the port list", "m u_m(.*, .*);"),
    INITIAL_BLOCK_SCOPE("Unexpected initial block construct", "package p1;\n\tinitial begin end;\nendpackage"),
    FINAL_BLOCK_SCOPE("Unexpected final block construct", "package p1;\n\tfinal begin end;\nendpackage"),
    SELECT_IN_EVENT_CONTROL("Select in event control not allowed", "@u_m3_1.a[1];"),
    EVENT_TRIGGER("'class_name::' not allowed in event trigger construct", "'->' a_class::a;"),
    DISABLE_STATEMENT("'class_name::' not allowed in disable statement", "disable a_class::a;"),
    EMPTY_CASE_STATEMENT("Empty case statement not allowed", "case (x)\nendcase"),
    EMPTY_ASSIGNMENT_PATTERN("Empty assignment pattern '{} not allowed", "x = '{};"),
    MISSING_FOR_LOOP_INITIALIZATION("'for' loop variable initialization required", "Note: Not applicable in IEEE 1800-2012 standard syntax or newer.\nfor ( ; i < 10; i++) ..."),
    MISSING_FOR_LOOP_CONDITION("'for' loop conditional expression required", "Note: Not applicable in IEEE 1800-2012 standard syntax or newer.\nfor (i = 0; ; i++) ..."),
    MISSING_FOR_LOOP_STEP("'for' loop step required", "Note: Not applicable in IEEE 1800-2012 standard syntax or newer.\nfor (i = 0; i < 10; ) ..."),
    FOREACH_LOOP_CONDITION(ProblemKind.NON_STANDARD, "Multidimensional array select not allowed in foreach loop condition", "Note: Strict only check. See +dvt_strict_non_standard_checks build directive on how to activate it.\nforeach (array[val][i]) ...", true),
    FOR_LOOP_INITIALIZATION("Expecting assignment in 'for' loop variable initialization", "for (++i;i<10; i++) begin end"),
    SELECT_IN_WEIGHT("Select in weight specification not allowed", "randsequence() ... first : add := array[0]; endsequence"),
    PARALLEL_PATH_DESCRIPTION("List of inputs in parallel path description not allowed", "(in1,in2 => q[1]) = 1;"),
    RANGE_IN_MULTIPLE_CONCATENATION("Range in multiple concatenation not allowed", "x = {0:3{1}};"),
    ASSIGNMENT_PATTERN("Expecting assignment pattern '{...} instead of concatenation", "x = {a : '0, b : '1};"),
    ASSIGNMENT_PATTERN_CONTEXT("Assignment pattern not allowed outside assignment-like context (could not determine data type)", "if (struct_signal == '{ a, b }) ..."),
    ASSIGNMENT_PATTERN_STRING_CONTEXT("Assignment pattern not allowed in ''string'' context", ""),
    SCALAR_ASSIGNMENT_PATTERN("Variable of 1-bit scalar type ''{0}'' not allowed as target of assignment pattern", "bit x = '{ '0 };"),
    TARGET_UNPACKED_ARRAY_CONCATENATION("Unpacked array concatenation not allowed as target expression", ".out({ a, b })"),
    STREAM_CONCATENATION_TYPE("Packed dimension on stream concatenation type not allowed", "result = { >> bit [7:0] { variable_name } };"),
    RANDOMIZE_ARGUMENT("Range selection of randomize argument ''{0}'' not allowed", "std::randomize(rand_var[7:0]) with {...};"),
    INSIDE_OPERATOR("'inside' operator in constant expression not allowed", "int y[a inside {b, c} ? 10 : 2];"),
    INSIDE_OPERATOR_RANGE("Expecting curly braces {} around 'inside' operator range", "if ( a inside x ) ..."),
    TYPE_CASTING("Expecting tick before type casting expression", "int(some_var)"),
    NULL_CONSTANT_EXPRESSION("Expecting constant expression instead of 'null'", "class my_class #(parameter string x = null"),
    TIME_VALUE("Unexpected white space between number and time value", "timeunit 10 ps;"),
    HIERARCHICAL_CLASS_ACCESS("Class scope resolution access '::' not allowed", "\ta.b.c::enum_value"),
    HIERARCHICAL_ROOT_ACCESS("Unexpected '$root' name before package or class scope access", "$root.my_pkg::my_signal"),
    COMMA_AFTER_ATTRIBUTE_INSTANCE("Attribute instance followed by ';' not allowed", "(* full_case, parallel_case; *)"),
    CONST_ATTRIBUTE_INSTANCE("'const' for attribute instance not allowed", "(* const int full_case=1, parallel_case *)"),
    ATTRIBUTE_INSTANCE_DATA_TYPE("Attribute instance data type not allowed", "(* integer library_binding = 1, something = 1 *)"),
    SELECT_IN_ATTRIBUTE_INSTANCE("Select in attribute instance not allowed", "(* cds_net_set[0:2] = {\"a\", \"b\", \"c\"} *)"),
    TYPEOF_SYSTEM_TASK("Unexpected '$typeof' system task", "$typeof(a) b;"),
    KEYWORD_AS_IDENTIFIER("Reserved keyword ''{0}'' not allowed as identifier", "instance, restrict, checker, table, cell, config, design"),
    MULTIPLE_BINS("Specification of multiple bins dimension not allowed", "wildcard bins trans 2 = ({1'bx} => {1'bx});"),
    ASSERTION_STATEMENT_ATTRIBUTE_INSTANCE("Expecting attribute instance after block identifier ''{0}'' for procedural assertion statement", "(* cover_attribute *) block_identifier : cover property ..."),
    SYSTEM_FUNCTION_ARGUMENTS("Maximum number of arguments for ''{0}'' system function is {1}", "$typename(x, 39);"),
    PARENTHESES_PATTERN("Enclosing parentheses around pattern not allowed", "matches (tagged VAL .c)"),
    AMSCONFIG("Unexpected ':amsconfig' in config use clause", ""),
    CONST_RAND_QUALIFIERS_ORDER("Unexpected use of 'const' followed by 'rand'/'randc' (use 'rand'/'randc' followed by 'const' instead)", ""),
    WILDCARD_EQUALITY_OPERATOR("Expecting wildcard operator '==?' instead of '=?='", ""),
    WILDCARD_INEQUALITY_OPERATOR("Expecting wildcard operator '!=?' instead of '!?='", ""),
    STRING_CONTINUATION("Expecting '\\' to continue the string on the next line", "string str = \"string is splitted\n\non multiple lines\";"),
    STRING_CONTINUATION_WS("White-space not allowed after '\\' line continuation", "string str = \"string is splitted \\[white-space]\n\\[white-space]\non multiple lines\";"),
    COMPILER_GUARD("Expecting identifier after `ifdef, `ifndef, `elsif instead of '`'{0}''", ""),
    USELIB_DIRECTIVE("Unexpected Verilog-XL directive `uselib, use -y, -v, and +libext command line flags instead", ""),
    LIBRARY_PATH("Quotes for library path specification not allowed", "library rtlLib \"top.v\";"),
    MACRO_TEXT("Macro text string must terminate with `\" instead of \"", "$sformat(errStr, `\"ID``_``SUFFIX SIGNAL is %b\",SIGNAL);"),
    MACRO_MULTILINE_DELIMITER("Unexpected whitespace character(s) after macro multiline delimiter", "`define my_macro int i; \\ \nint j;"),
    EXPONENT_FORMAT_TIME_VALUE("Unexpected exponent format for time value", "#(1.0e9ns)"),
    DOT_STAR_CONNECTION("Unexpected whitespace character(s) between '.' and '*'", ". *, .port(0)"),
    API(ProblemKind.NON_STANDARD, "Unexpected method/field ''{0}''", "Note: Strict only check for some API. See +dvt_strict_non_standard_checks build directive on how to activate all.", true),
    MACRO(ProblemKind.NON_STANDARD, "Unexpected macro: `{0}", "", true),
    NOF_PARAMETER_OVERRIDES(ProblemKind.UNSPECIFIED_STANDARD, "Expected {0} parameter overrides, found {1}", "module mod;endmodule ... mod#(2) field;", false),
    FUNCTION_IMPLEMENTATION_SCOPE("Function implementation of ''{0}'' must be in the same scope as class ''{1}''", ""),
    TASK_IMPLEMENTATION_SCOPE("Task implementation of ''{0}'' must be in the same scope as class ''{1}''", ""),
    CONSTRAINT_IMPLEMENTATION_SCOPE("Constraint implementation ''{0}'' must be in the same scope as class ''{1}''", ""),
    MODPORT_IMPORT_EXPORT_PORT("Expecting method name instead of interface signal name ''{0}''", "class foo;\nendclass\ninterface bar(input clk);\n  foo field;\n  modport mp1(export field);\nendinterface"),
    SELECT_METHOD_CALL("Select not allowed after ''{0}()'' method call", "m4.foo()[0]"),
    EVENT_CONTROL_EXPRESSION("Expecting singular data type for event control expression instead of type ''{1}''", "initial begin\n\t@(cif_enable) $display(\"list_of_arguments\");\nend"),
    METHOD_OVERRIDE_ARGUMENT_NAME("Argument name ''{2}'' of method ''{0}'' does not match ''{5}'' of override ''{3}''", "class foo1;\n\tvirtual function bar(int base_name);\n\tendfunction\nendclass\nclass foo2 extends foo1;\n\tvirtual function bar(int child_name);\n\tendfunction\nendclass"),
    FUNCTION_IMPLEMENTATION_RETURN_TYPE("Return type ''{0}'' of function ''{1}'' must be the same as prototype return type (non-standard use of type alias)", "typedef bit my_type;\nclass foo;\n\textern function bit boo();\nendclass\nfunction my_type foo::boo();\nendfunction"),
    FUNCTION_IMPLEMENTATION_INTERNAL_RETURN_TYPE("Internal return type ''{0}'' for the implementation of extern method ''{1}'' requires scope resolution", "function cls_internal_type cls::foo(); ..."),
    METHOD_IMPLEMENTATION_ARGUMENT_TYPE("Argument type ''{0}'' of method ''{1}'' must be the same as prototype argument type (non-standard use of type alias)", "typedef bit my_type;\nclass foo;\n\textern function bit boo(bit arg);\n\textern function bit goo(bit arg);\nendclass\nfunction bit foo::boo(my_type arg);\nendfunction"),
    VOID_CAST_OF_VOID_FUNCTION("Void cast of void function ''{0}'' not allowed", "void'(void_return_function())"),
    LOGICAL_NEGATION("Operand of type ''{1}'' not allowed with logical negation ''{0}'' (use == null instead)", "if (!class_obj) ..."),
    BINARY_LOGICAL_OPERATOR("Operand of type ''{1}'' not allowed with binary logical operator ''{0}'' (use != null instead)", "if (class_obj && class_obj.field == 0) ..."),
    DYNAMIC_ARRAY_NULL_OPERATION("''{0}'' operator is undefined for dynamic array ''{1}'' and ''null''", "if (array == null) ..."),
    NUMERIC_NULL_OPERATION("''{0}'' operator is undefined for numeric type ''{1}'' and ''null''", "if (sig == null) ..."),
    NUMERIC_NULL_OPERATION_IN_ASSOCIATION("Illegal ''null'' {0} for numeric type ''{1}''", "'{ null : 0 }"),
    STRING_OPERATION("Explicit ''string'' cast required for {0} of type ''{1}''", "string a; int b; if (a == b) ..."),
    ENUM_ASSIGNMENT("Explicit cast required when assigning ''{0}'' to variable ''{1}'' of enum type ''{2}''", "enum_type a; a+=1;"),
    ENUM_ASSIGNMENT_ASSOCIATION("Explicit cast required when assigning ''{0}'' {1} to enum type ''{2}''", "enum_type array[enum_type]; array = '{ 1 : 1 };"),
    ENUM_COMPARISON("Explicit cast required when comparing ''{0}'' to variable ''{1}'' of enum type ''{2}''", "enum_type a; if (a < 1) ..."),
    ENUM_RETURN("Explicit cast to enum type ''{1}'' required when returning ''{0}''", "function enum_type foo(); return 1; endfunction"),
    DIFFERENT_ENUMS_ASSIGNMENT("Explicit cast required when assigning to enum type {0} from enum type {1}", "enum_type a; a = other_enum_literal;"),
    DIFFERENT_ENUMS_COMPARISON("Explicit cast required when comparing enum type {0} to enum type {1}", "enum_type a; if (a < other_enum_literal) ..."),
    EVENT_CONTROL("The following events must be of a singular data type:{0}", "always @(a or b) begin\n\tc = a[0] & b;\nend"),
    IMPORT_TYPE_WITHOUT_EXPORT("Package ''{0}'' must export type ''{1}''", "import pkg::not_exported_type;"),
    TYPE_SPECIALIZATION("Type ''{0}'' is already a specialization of ''{1}''", "typedef cls#(.T(int)) type_alias; type_alias#(.T(int)) field;"),
    REPEAT_CONDITION_UNPACKED_ARRAY("Unpacked array ''{0}'' not allowed as repeat condition", "int array[2]; repeat (array) ..."),
    REPEAT_CONDITION_STRING("String variable ''{0}'' not allowed as repeat condition", "string str; repeat (str) ..."),
    REPEAT_CONDITION_UNPACKED_STRUCT("Unpacked struct/union ''{0}'' not allowed as repeat condition", "struct { int x; } val; repeat (val) ..."),
    INTERFACE_NAME_SELF_REFERENCE("Interface type name ''{0}'' not allowed as self reference", "virtual interface_name var = interface_name;"),
    INVALID_VIRTUAL_INTERFACE("Interface ''{0}'' containing interface ports cannot be used as a virtual interface", "interface intf(interface port)"),
    INVALID_RAND_MODE_CALL("''rand_mode'' call not allowed for non-random variable ''{0}''", "int x;\nfunction foo();\n\tx.rand_mode(0);\nendfunction"),
    PORT_DEFAULT_VALUE("{0,choice,0#Output|1#Inout|2#Ref} port ''{1}'' cannot have a default value", ""),
    EMPTY_QUEUE_STRING_ASSIGNMENT("Empty queue not allowed for assignment to ''string'' variable ''{0}''", ""),
    EMPTY_QUEUE_STRING_RETURN("Empty queue not allowed for ''string'' return type", ""),
    EMPTY_PORT_IMPLICIT_CONNECTION("Implicit connection is not allowed for empty port(s) ''{0}''", ""),
    ANSI_ARGUMENT_REDECLARATION("Redeclaration of ANSI argument ''{0}'' is not allowed", "function foo(input ansi_arg);\n    logic ansi_arg;\nendfunction"),
    ANSI_PORT_REDECLARATION("Redeclaration of ANSI port ''{0}'' is not allowed", "module foo(input ansi_port);\n    logic ansi_port;\nendmodule"),
    REDUNDANT_NON_ANSI_PORT_DIRECTION("Declaration of port ''{0}'' has redundant {1,choice,0#input|1#output|2#inout} direction", "module foo(arg);\n    input arg;\n    input wire arg;\nendmodule");

    private ProblemKind kind = ProblemKind.NON_STANDARD;
    private String message;
    private String example;
    private boolean isStrict;

    private RfNonStandardProblem(String message, String example) {
        this(ProblemKind.NON_STANDARD, message, example, false);
    }

    private RfNonStandardProblem(ProblemKind kind, String message, String example, boolean isStrict) {
        this.kind = kind;
        this.message = message;
        this.example = example;
        this.isStrict = isStrict;
    }

    public String getMessage(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return this.message;
        }
        return MessageFormat.format(this.message, arguments);
    }

    public String getExample() {
        return this.example;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public String getID() {
        return this.kind.getKindID();
    }

    private static enum ProblemKind {
        NON_STANDARD("NON_STANDARD_"),
        UNSPECIFIED_STANDARD("UNSPECIFIED_STANDARD_");

        private String kindID;

        private ProblemKind(String id) {
            this.kindID = id;
        }

        public String getKindID() {
            return this.kindID;
        }
    }
}

