/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorScopeWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LFilters;

public class RfPackage
extends RfParamsHolder
implements IRfPackageElement {
    private static final long serialVersionUID = 1L;
    private Set<String> vunitNames;
    private HidImplicit[] localTimescale;
    private transient byte semanticEnable;

    public RfPackage(String name, boolean escaped) {
        super(name, escaped);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "package " + this.getName();
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public boolean canStaticAccess() {
        return true;
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (appendThis) {
            result.append(this.getName()).append("::");
        }
    }

    public byte getSemanticEnableRaw() {
        return this.semanticEnable;
    }

    public void setSemanticEnable(byte enable) {
        if (enable > this.semanticEnable) {
            this.semanticEnable = enable;
        }
    }

    @Override
    public void setVunitNames(Set<String> vunitNames) {
        this.vunitNames = vunitNames;
    }

    @Override
    public Set<String> getVunitNames() {
        return this.vunitNames;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    public IELParamValue getLocalElabConstantValue(String name) {
        ELManager elabManager = this.getRfProject().getELManager();
        if (elabManager == null) {
            return null;
        }
        ELParamValues externalConstants = elabManager.getExternalConstants((IRfNamedElement)this);
        return externalConstants != null ? externalConstants.getValue(name) : null;
    }

    public Map<String, IELParamValue> getLocalElabConstantValues() {
        ELParamValues externalConstants = this.getRfProject().getELManager().getExternalConstants((IRfNamedElement)this);
        return externalConstants != null ? externalConstants.getEntries() : null;
    }

    public void setLocalTimeunit(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[0] = value;
    }

    public void setLocalTimeprecision(HidImplicit value) {
        if (this.localTimescale == null) {
            this.localTimescale = new HidImplicit[2];
        }
        this.localTimescale[1] = value;
    }

    public boolean hasDirectiveTimeunit() {
        return this.localTimescale != null && this.localTimescale[0] != null;
    }

    public boolean hasDirectiveTimeprecision() {
        return this.localTimescale != null && this.localTimescale[1] != null;
    }

    @Override
    public HidImplicit getLocalTimeunit() {
        return this.localTimescale != null ? this.localTimescale[0] : null;
    }

    @Override
    public HidImplicit getLocalTimeprecision() {
        return this.localTimescale != null ? this.localTimescale[1] : null;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.localTimescale = null;
    }

    public static Set<IRfNamedElement> internalGetAllImportedPackagesRecursive(Collection<IRfNamedElement> startingList) {
        if (startingList == null || startingList.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
        result.addAll(startingList);
        LinkedList<IRfNamedElement> work = new LinkedList<IRfNamedElement>();
        work.addAll(startingList);
        while (!work.isEmpty()) {
            IRfNamedElement currentPackage = (IRfNamedElement)work.poll();
            Set importedPackages = currentPackage.elabGetAllImportedPackages();
            if (importedPackages == null || importedPackages.isEmpty()) continue;
            for (IRfNamedElement importedPackage : importedPackages) {
                if (result.contains(importedPackage)) continue;
                result.add(importedPackage);
                work.add(importedPackage);
            }
        }
        return result;
    }

    public void elaborateImportedPackages(ELManager manager) {
        if (manager.getSemanticEnableRaw() != 3) {
            return;
        }
        Set<IRfNamedElement> importedPackages = RfPackage.internalGetAllImportedPackagesRecursive(this.getAllImportDeclarations().stream().map(imp -> imp.getPackage()).collect(Collectors.toList()));
        if (importedPackages == null || importedPackages.isEmpty()) {
            return;
        }
        for (IRfNamedElement importedPackage : importedPackages) {
            if (!(importedPackage instanceof IRfConstantsHolder)) continue;
            ((IRfConstantsHolder)importedPackage).elaborateConstants(manager);
        }
    }

    @Override
    public void elaborateConstants(ELManager manager) {
        if (this.isPredefined()) {
            return;
        }
        if (manager.isPermanentAfterElaboration()) {
            return;
        }
        if (manager.isPermanentElaboration() && this.getSemanticEnableRaw() != 0) {
            return;
        }
        if (manager.isControlNoParamEval()) {
            return;
        }
        this.fElabConstantsLock.lock();
        try {
            if (manager.getExternalConstants((IRfNamedElement)this) != null) {
                return;
            }
            LinkedHashMap<IRfNamedElement, ELParamValues> working = new LinkedHashMap<IRfNamedElement, ELParamValues>();
            working.put(this, ELParamValues.create((boolean)true));
            manager.addExternalConstants((IRfNamedElement)this, (ELParamValues)working.get(this));
            this.computeConstants(manager, working);
            for (Map.Entry entry : working.entrySet()) {
                manager.addExternalConstants((IRfNamedElement)entry.getKey(), ELUtils.getValidParamValues((ELParamValues)((ELParamValues)entry.getValue())));
            }
            byte semanticEnableRaw = manager.getSemanticEnableRaw();
            if (manager.isPermanentElaboration() && semanticEnableRaw == 3) {
                this.setSemanticEnable(semanticEnableRaw);
                this.elaborateImportedPackages(manager);
                IRfSingleLangProject rfProject = manager.getStartingVLOGProject();
                ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, rfProject.getToolCompat());
                configInfo.setElabWidthCheckDisabled(manager.isElabWidthCheckDisabled());
                configInfo.setElabWidthCheckFiltered(manager.isElabWidthCheckFiltered());
                configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELUtils.getValidParamValues((ELParamValues)manager.getExternalConstants((IRfNamedElement)this)), null, (ELManager)manager));
                this.resolveHids(configInfo, true, true, semanticEnableRaw, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                this.resolveHidOperators(configInfo, true, semanticEnableRaw, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                this.elaborateInnerClassParentsRecursive(this, manager);
            }
        }
        finally {
            this.fElabConstantsLock.unlock();
        }
    }

    public void cleanElaborationInfo() {
        this.semanticEnable = 0;
    }

    @Override
    protected void computeConstants(ELManager manager, Map<IRfNamedElement, ELParamValues> workingPerScopes) {
        ELParamValuesHidEvaluator evaluator = workingPerScopes.get(this).getHidEvaluator(manager);
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, (IRfNamedElement)this, null, (boolean)false, (ELManager)manager);
        List<? extends HidOperatorWrapper> initialAssigns = this.getSortedAssignsToComputeConstants(true);
        if (initialAssigns == null || initialAssigns.isEmpty()) {
            return;
        }
        if (evaluator.isInterpreter()) {
            guardian.callbackStartInitVars(true);
        }
        boolean markElabOperators = manager.markElabHidObjects();
        for (HidOperatorWrapper hidOperatorWrapper : initialAssigns) {
            IHidObject valueHidObject;
            String paramName;
            ELParamValues working;
            IRfNamedElement candidate;
            IHidObject lhValue;
            IRfNamedElement innerScope;
            HidOperator operator = (HidOperator)hidOperatorWrapper.hidObject;
            if (markElabOperators) {
                operator.addQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER);
            }
            if ((innerScope = ((HidOperatorScopeWrapper)hidOperatorWrapper).scope) instanceof RfStruct) {
                innerScope = (IRfNamedElement)innerScope.getEnclosingScope(RfPackage.class);
            }
            if (innerScope == null || !((lhValue = operator.getLHValue()) instanceof IHid) || !((candidate = innerScope.semanticGetMember(((IHid)lhValue).getName(), null, null, (IRfNamedElement)this, (IRfNamedElement)this, true, true, false)) instanceof IRfFieldElement)) continue;
            IRfFieldElement candidateField = (IRfFieldElement)candidate;
            if (!evaluator.isInterpreter() && !ELUtils.isVLOGConstant((IRfNamedElement)candidateField) || (working = workingPerScopes.computeIfAbsent(innerScope, scope -> ELParamValues.create((boolean)true))).containsKey(paramName = candidateField.getElabName(true)) || (valueHidObject = operator.getFirstRHValue()) == null) continue;
            BitVectorContext context = candidateField.isTypeParameter() ? BitVectorContext.of((IRfNamedElement)candidateField, (boolean)true) : ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)candidateField, null, (ELManager)manager);
            IELParamValue finalValue = null;
            XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, (IHidEvaluator)evaluator, context, guardian, (ListContainer)valueHidObject, hidOperatorWrapper.path, "init static var of " + evaluator.toString(), true);
            XThread xThread = guardian.getActiveThread();
            try {
                guardian.startEvalScope((XEvalScope)xEvalScope);
                guardian.callbackStartStatement(xThread, (IHidObject)operator);
                finalValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)valueHidObject, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            }
            finally {
                guardian.callbackEndStatement(xThread, (IHidObject)operator);
                guardian.endEvalScope((XEvalScope)xEvalScope);
            }
            if (finalValue == null) {
                IRfDefElement declaration;
                finalValue = IELParamValue.UNDEFINED_VALUE;
                if (!evaluator.isInterpreter() && (declaration = candidateField.getDeclaration()) != null) {
                    String pattern = ELUtils.isVLOGEnumName((IRfNamedElement)candidateField) ? "UNRESOLVED_ENUM_NAME_VALUE: Cannot determine value of enum name ''{1}'' from expression: {2}" : "UNRESOLVED_PARAMETER_VALUE: Cannot determine {0} value of parameter ''{1}'' from expression: {2}";
                    int startOffset = declaration.getStartOffset();
                    int endOffset = startOffset + paramName.length();
                    int line = declaration.getStartLine();
                    manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, pattern, (IRfNamedElement)candidateField, declaration, startOffset, endOffset, line, null, null, new Object[]{"default", paramName, HidUtils.toNiceString((IHidObject)valueHidObject)});
                }
            }
            working.put(paramName, finalValue);
        }
        if (evaluator.isInterpreter()) {
            guardian.callbackEndInitVars(true);
        }
    }

    public IRfNamedElement getImportedSymbol(String symbolName) {
        RfNamedElement element = this.getPackageWithPrefix(symbolName, 1);
        if (element != null) {
            return element;
        }
        element = this.getMember(symbolName, null, null, false, true, true, false, false);
        if (element != null) {
            return element;
        }
        element = this.getMember(symbolName, null, null, true, true, true, false, false);
        if (element != null) {
            element = RfAssociatedType.RfUnresolvedTypeInfo.of(element, false, false);
        }
        return element;
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        IRfElementFilter composedFilter = R2LFilters.or(R2LFilters.isTypeAlias(true), R2LFilters.fieldIsParameter(true), R2LFilters.fieldIsTypeParameter(true));
        HashSet<IRfNamedElement> result2 = new HashSet<IRfNamedElement>();
        this.getElementsWithPrefix(result2, prefix, matchType, 3, first, IRfNamedElement.AccessModifier.SHOW_PUBLIC, composedFilter);
        for (IRfNamedElement candidate : result2) {
            result.put(candidate.getName(), candidate);
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PACKAGE: Duplicate package ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public IRfPackageElement getPackage() {
        return this;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        RfNamedElement enclosingScope;
        if (previous != null) {
            if (IRfNamedElement.QualifiedNameOptions.contains((int)16, (int)options)) {
                return;
            }
            if (IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
                return;
            }
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = this.getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
        }
        result.append(this.getName());
        if (previous != null) {
            result.append("::");
        }
    }

    public ELParamValues xGetLocalElabConstantValues() {
        return this.getRfProject().getELManager().getExternalConstants((IRfNamedElement)this);
    }
}

