/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public abstract class RfParamsHolder
extends RfMembersHolder {
    private static final long serialVersionUID = 1L;

    protected RfParamsHolder(String name, boolean escaped) {
        super(name, escaped);
    }

    public int getPortListParametersCount() {
        return this.getPortListParameters().size();
    }

    public final boolean hasPortListParameters() {
        return this.getPortListParametersCount() > 0;
    }

    public boolean hasPortListTypeParameters() {
        Set<String> typeParamNames = this.getTypeParamNames();
        if (typeParamNames == null || typeParamNames.isEmpty()) {
            return false;
        }
        for (String typeParamName : typeParamNames) {
            RfField element = this.getLocalMember(RfField.class, typeParamName, true);
            if (element == null || !element.isTypeParameter() || !element.isInParameterPortList()) continue;
            return true;
        }
        return false;
    }

    protected void getCompleteNamesForPortListParams(StringBuilder result, ELParamValues localElabConstantValues, RfTypesResolver typesResolver, IRfScopeElement scope, int options) {
        if (localElabConstantValues == null || localElabConstantValues.isEmpty()) {
            return;
        }
        List portListParameters = this.getPortListParameters();
        if (portListParameters.isEmpty()) {
            return;
        }
        int portListParametersCount = portListParameters.size();
        boolean useCharLimit = IRfNamedElement.QualifiedNameOptions.contains((int)256, (int)options);
        boolean useLowerCaseMaskType = IRfNamedElement.QualifiedNameOptions.contains((int)128, (int)options);
        result.append("#(");
        for (IRfNamedElement portListParameter : portListParameters) {
            --portListParametersCount;
            String parameterName = portListParameter.getName();
            IELParamValue parameterValue = localElabConstantValues.getValueDirectly(parameterName);
            if (parameterValue == null) {
                result.append(portListParametersCount != 0 ? ", " : Character.valueOf(')'));
                continue;
            }
            if (parameterValue instanceof ELParamValues.ParamValueType) {
                IRfNamedElement parameterTypeValue = ((ELParamValues.ParamValueType)parameterValue).getNamedElement();
                if (parameterTypeValue instanceof RfComputedStruct && ((RfComputedStruct)parameterTypeValue).isDefinedInParameterPortList()) {
                    ((RfComputedStruct)parameterTypeValue).getOriginal().getQualifiedName(result, typesResolver, scope, IRfNamedElement.QualifiedNameOptions.remove((int)1, (int)options), null);
                } else if (parameterTypeValue instanceof RfNamedElement) {
                    ((RfNamedElement)parameterTypeValue).getQualifiedName(result, typesResolver, scope, options, null);
                } else {
                    result.append(parameterTypeValue.getQualifiedName(scope, typesResolver.getHierarchyPath(), options));
                }
            } else {
                result.append(parameterValue.toNiceString(null, -1, useCharLimit, useLowerCaseMaskType));
            }
            result.append(portListParametersCount != 0 ? ", " : Character.valueOf(')'));
        }
    }
}

