/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.BaseConfigInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IndexInfo;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.vlogdt.model.reflection.DataSelectType;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public class RfPort
extends RfField
implements IRfPortElement {
    private static final long serialVersionUID = 1L;
    private byte fPortKind;
    private Set<RfPort> fAliasChildren;
    private Set<RfPort> fAliasParents;
    private VlogMacroZone fNonAnsiMacroZone;
    public static final int NET_OR_VAR_PORT = 0;
    public static final int INTERFACE_PORT = 1;
    public static final int EXPLICIT_MPCB_PORT = 2;
    public static final int NON_ANSI_PORT_IDENTIFIER = 3;

    public RfPort(String name, boolean escaped, DataType type, int portKind, String initialValue) {
        super(name, escaped, type, 1, 1, initialValue);
        this.fPortKind = (byte)portKind;
    }

    public RfPort(RfPort port) {
        super(port);
        this.fPortKind = port.fPortKind;
        this.fAliasChildren = port.fAliasChildren == null ? null : new LinkedHashSet<RfPort>(port.fAliasChildren);
        this.fAliasParents = port.fAliasParents == null ? null : new LinkedHashSet<RfPort>(port.fAliasParents);
    }

    public void init(DataType dataType, int kind, int portKind, int qualifiers, String initialValue) {
        super.init(dataType, kind, qualifiers, initialValue);
        if (this.fPortKind != 3) {
            this.fPortKind = (byte)portKind;
        }
    }

    @Override
    protected int internalMaxDefSizePerElement() {
        return 4;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        if (this.hasNoDefs(false)) {
            super.init(new DataType(), 1, 1, null);
        }
        if (this.fAliasParents != null) {
            this.fAliasParents.clear();
        }
        this.fAliasParents = null;
        if (this.fAliasChildren != null) {
            this.fAliasChildren.clear();
        }
        this.fAliasChildren = null;
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 1;
    }

    @Override
    public void setMacroZone(VlogMacroZone macroZone) {
        if (this.getMacroZone() != null) {
            return;
        }
        super.setMacroZone(macroZone);
    }

    public void setMacroZone(VlogMacroZone macroZone, boolean isNonAnsi) {
        if (isNonAnsi) {
            this.fNonAnsiMacroZone = macroZone;
            return;
        }
        this.setMacroZone(macroZone);
    }

    @Override
    public DataType getDataType() {
        DataType dataType = super.getDataType();
        if (dataType instanceof DataSelectType && (dataType = ((DataSelectType)dataType).getPortDataType(this)) != null) {
            this.fCachedActualDataType = dataType;
        }
        return this.fCachedActualDataType;
    }

    public int getDeclarationIndex(boolean includeNonAnsi) {
        if (includeNonAnsi && this.fNonAnsiMacroZone != null) {
            return this.fNonAnsiMacroZone.getIndex();
        }
        return this.getDeclarationIndex();
    }

    @Override
    public boolean isNet() {
        if (this.isRef()) {
            return false;
        }
        DataType dataType = this.getDataType();
        if (dataType != null && dataType.fNetType != null) {
            return !"var".equals(dataType.fNetType);
        }
        if (this.isOutput() && dataType != null && dataType.fType != null) {
            return this.hasUserDefinedNetType(true);
        }
        return true;
    }

    public boolean isInterfacePort() {
        return this.getPortKind() == 1;
    }

    public boolean isGenericInterfacePort() {
        if (this.getPortKind() != 1) {
            return false;
        }
        IRfNamedElement associatedType = this.getAssociatedType();
        return associatedType instanceof RfPredefinedClass && "interface".equals(associatedType.getName());
    }

    public boolean isModportClockingNewPort() {
        return this.getPortKind() == 2;
    }

    @Override
    public boolean isInout() {
        DataType dataType = this.getDataType();
        byte direction = dataType.getDirection();
        return direction == 2 | direction == 0 & !this.isInterfacePort();
    }

    public boolean isModportPort() {
        int dotPosition;
        if (this.getPortKind() != 1) {
            return false;
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        String typeName = dataType.fType;
        if (typeName == null) {
            return false;
        }
        int n = dotPosition = typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/") ? -1 : typeName.indexOf(".");
        return dotPosition != -1 && dotPosition + 1 < typeName.length();
    }

    public boolean isGenericModportPort() {
        return this.isGenericInterfacePort() && this.isModportPort();
    }

    public String getGenericModportName() {
        String modportName;
        int dotPosition;
        if (!this.isGenericModportPort()) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        String typeName = dataType.fType;
        if (typeName == null) {
            return null;
        }
        int n = dotPosition = typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/") ? -1 : typeName.indexOf(".");
        if (dotPosition != -1 && dotPosition + 1 < typeName.length() && (modportName = typeName.substring(dotPosition + 1)).indexOf(".") == -1) {
            return modportName;
        }
        return null;
    }

    @Override
    protected String implicitTypeName() {
        return "logic";
    }

    @Override
    public String implicitSpecificTypeName() {
        DataType dataType = this.getDataType();
        return dataType == null || dataType.isVerilog() ? null : "logic";
    }

    @Override
    public String implicitNetType() {
        return this.implicitSpecificNetType();
    }

    @Override
    public String implicitSpecificNetType() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfChecker) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (this.isRef() || this.isOutput() && dataType != null && dataType.fType != null) {
            return dataType == null || dataType.isVerilog() ? null : "var";
        }
        return this.getDefaultNetType(this);
    }

    @Override
    protected byte implicitDirection() {
        return 2;
    }

    @Override
    public void checkParamValues(IRfNamedElement paramElementType, BaseConfigInfo configInfo) {
        if (!this.isInterfacePort()) {
            super.checkParamValues(paramElementType, configInfo);
        }
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        IRfNamedElement associatedType = super.getAssociatedType(typesResolver);
        if (dataType.hasPackedDimension() || dataType.hasUnpackedDimension() || !this.isInterfacePort()) {
            return associatedType;
        }
        typesResolver.update(this, null, false, false);
        return associatedType;
    }

    @Override
    public String getSignature(RfTypesResolver typeResolver) {
        StringBuilder result = new StringBuilder();
        result.append("port").append(' ');
        result.append(this.getDirectionString()).append(' ');
        result.append(this.getDataType().getNetType() != null ? String.valueOf(this.getDataType().getNetType()) + " " : (this.implicitNetType() != null ? String.valueOf(this.implicitNetType()) + " " : ""));
        if (this.isInterfacePort()) {
            result.append(String.valueOf(this.printScope()) + this.getName());
        } else {
            int qualifiedNameOptions = 771;
            String[] assocTypeName = RfListType.splitUnpackedDimesnions(this.getAssociatedTypeName(this.getEnclosingScope(), typeResolver, qualifiedNameOptions, false, true, false));
            result.append(assocTypeName[0]).append(' ');
            result.append(String.valueOf(this.printScope()) + this.getName());
            result.append(assocTypeName[1]);
        }
        return result.toString();
    }

    @Override
    public Image getImage() {
        if (this.isModportPort()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODPORT);
        }
        if (this.isInterfacePort()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_PORT);
        }
        if (this.isInput()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INPUT_PORT);
        }
        if (this.isOutput()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_OUTPUT_PORT);
        }
        if (this.isInout()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
        }
        if (this.isRef()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_REF);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    @Override
    public String getDirectionString() {
        if (this.isInterfacePort()) {
            return "interface";
        }
        return super.getDirectionString();
    }

    @Override
    public boolean isLinkage() {
        return false;
    }

    @Override
    public boolean isBuffer() {
        return false;
    }

    public boolean isUnderAlias() {
        return this.fAliasParents != null && !this.fAliasParents.isEmpty();
    }

    public boolean isInListOfPorts() {
        RfDefElement decl = this.getDeclaration();
        return decl instanceof RfPortDef && ((RfPortDef)decl).isInListOfPorts();
    }

    public boolean isEmptyPort() {
        IHidObject rhValue;
        DataType rawDataType = this.getRawDataType();
        if (!(rawDataType instanceof DataSelectType)) {
            return false;
        }
        IHidObject portExpression = ((DataSelectType)rawDataType).getPortExpression();
        IHidObject iHidObject = rhValue = portExpression instanceof HidOperator ? ((HidOperator)portExpression).getFirstRHValue() : portExpression;
        return rhValue instanceof HidImplicit && ((HidImplicit)rhValue).isEmptyType();
    }

    public byte getPortKind() {
        if (this.fAliasChildren != null && !this.fAliasChildren.isEmpty()) {
            return this.fAliasChildren.iterator().next().fPortKind;
        }
        return this.fPortKind;
    }

    protected final byte getBasePortKind() {
        return this.fPortKind;
    }

    public void addPortAlias(RfPort aliasPort) {
        if (aliasPort == null || aliasPort == this) {
            return;
        }
        if (this.fAliasParents == null) {
            this.fAliasParents = new LinkedHashSet<RfPort>();
        }
        this.fAliasParents.add(aliasPort);
        if (aliasPort.fAliasChildren == null) {
            aliasPort.fAliasChildren = new LinkedHashSet<RfPort>();
        }
        aliasPort.fAliasChildren.add(this);
    }

    public Set<RfPort> getAliasChildren() {
        return this.fAliasChildren;
    }

    public Set<RfPort> getAliasParents() {
        return this.fAliasParents;
    }

    @Override
    public int getInducedParametricDependencyValue() {
        return this.isInterfacePort() ? 15 : super.getInducedParametricDependencyValue();
    }

    public String getContextInformationSignature() {
        if (this.isInterfacePort()) {
            return DVTStringUtil.appendString((Object[])new Object[]{this.getDirectionString(), " ", this.getName(), this.getUnpackedDimension()});
        }
        return DVTStringUtil.appendString((Object[])new Object[]{this.getDirectionString(), " ", this.getDataType().getNetType() != null ? String.valueOf(this.getDataType().getNetType()) + " " : (this.implicitNetType() != null ? String.valueOf(this.implicitNetType()) + " " : ""), this.getAssociatedTypeName(), " ", this.getName(), this.getUnpackedDimension()});
    }

    public IHidObject getDataTypePortExpression() {
        IHidObject hidObject;
        DataType dataType = this.getRawDataType();
        if (dataType instanceof DataSelectType && (hidObject = ((DataSelectType)dataType).getPortExpression()) instanceof IHidOperator && ((IHidOperator)hidObject).isVLOGConcatenation(true)) {
            return hidObject;
        }
        return null;
    }

    @Override
    public MaskType xGetInitMaskType() {
        String name;
        if (this.isOutput() && this.getEnclosingScope() instanceof IRfInstanceElement && ("pullup".equals(name = ((IRfInstanceElement)this.getEnclosingScope()).getAssociatedTypeName()) || "pulldown".equals(name))) {
            return MaskType.Z;
        }
        if (this.isInout() || this.isInput()) {
            return MaskType.Z;
        }
        return super.xGetInitMaskType();
    }

    @Override
    public IndexInfo getIndexInfo() {
        Collection declarations = this.getDeclarations();
        int offset = -1;
        if (declarations != null && declarations.size() > 1) {
            int index = 0;
            for (IRfDefElement declaration : declarations) {
                if (index == declarations.size() - 1) {
                    offset = declaration.getStartOffset();
                }
                ++index;
            }
        }
        return new IndexInfo(this.getDeclarationIndex(true), this.getInvocNumber(), offset);
    }

    @Override
    public IRfNamedElement.NetType xGetNetType() {
        String netType;
        if (this.isRef()) {
            return IRfNamedElement.NetType.NONE;
        }
        DataType dataType = this.getDataType();
        String string = netType = dataType != null ? dataType.getNetType() : null;
        if (netType != null) {
            return IRfNamedElement.NetType.from((String)netType);
        }
        if (this.isInput() || this.isInout()) {
            return IRfNamedElement.NetType.from((String)this.getDefaultNetType(this));
        }
        if (this.isOutput() && (dataType == null || dataType.getType() == null)) {
            return IRfNamedElement.NetType.from((String)this.getDefaultNetType(this));
        }
        return IRfNamedElement.NetType.NONE;
    }
}

