/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class RfPrimitive
extends RfNamedElement
implements IRfDesignElement,
IELDesign {
    private static final long serialVersionUID = 2L;
    private DVTLinkedHashMap<String, RfNamedElement> fMembers;
    private RfHidHolder fHidHolder;
    private String fDefaultNetType;
    private HidImplicit[] timescale;
    private RfNamedElement.NamesCache fNamesCache;
    private transient List<RfPort> cachedPorts;
    private transient Map<String, RfField> prevFields;

    public RfPrimitive(String name, boolean escaped, String defaultNetType, HidImplicit[] timescale) {
        super(name, escaped);
        this.fDefaultNetType = defaultNetType;
        this.timescale = timescale;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return false;
    }

    @Override
    public String getDefaultNetType(IRfNamedElement element) {
        if (this.fDefaultNetType != null) {
            return this.fDefaultNetType;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        this.fDefaultNetType = enclosing != null ? enclosing.getDefaultNetType(this) : "wire";
        return this.fDefaultNetType;
    }

    @Override
    public HidImplicit[] getTimescale(IRfNamedElement element) {
        if (this.timescale != null) {
            return this.timescale;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        this.timescale = enclosing != null ? enclosing.getTimescale(this) : RfInstanceHolder.DEFAULT_TIMESCALE;
        return this.timescale;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        if (this.hasNoDefs(false)) {
            this.fDefaultNetType = null;
        }
        this.cachedPorts = null;
        this.prevFields = null;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "primitive " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    @Override
    protected final RfNamedElement.NamesCache internalGetNamesCache() {
        return this.fNamesCache;
    }

    @Override
    protected final void internalSetNamesCache(RfNamedElement.NamesCache namesCache) {
        this.fNamesCache = namesCache;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
        return null;
    }

    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        return this.getLocalMembers(RfActionBlock.class);
    }

    public Collection<? extends IRfFieldElement> getLocalSignals() {
        return null;
    }

    public Collection<? extends IRfInstanceElement> getLocalInstances() {
        return null;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PRIMITIVE: Duplicate primitive ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof IRfDesignElement && ((IRfDesignElement)obj).getResolvedElement() == this;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PRIMITIVE);
    }

    @Override
    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        return null;
    }

    public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfBlockElement getBlockWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VLOG_PRIMITIVE;
    }

    public List<RfPort> getLocalPorts() {
        if (this.cachedPorts == null) {
            this.cachedPorts = this.getLocalMembers(RfPort.class);
            if (this.cachedPorts == null || this.cachedPorts.isEmpty()) {
                this.cachedPorts = Collections.emptyList();
            }
        }
        return this.cachedPorts;
    }

    public List<? extends IRfNamedElement> getLocalParameters() {
        return null;
    }

    public List<? extends IRfNamedElement> getPortListParameters() {
        return null;
    }

    public List<? extends IRfNamedElement> getLocalElabConstants() {
        return null;
    }

    @Override
    protected final DVTLinkedHashMap<String, RfNamedElement> internalGetMembers() {
        return this.fMembers;
    }

    @Override
    protected final void internalSetMembers(DVTLinkedHashMap<String, RfNamedElement> members) {
        this.fMembers = members;
    }

    @Override
    protected final RfHidHolder internalGetHidHolder() {
        return this.fHidHolder;
    }

    @Override
    protected final void internalSetHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    public Collection<HidOperator> computeTableOperator(HidOperator driveStrength, HidOperator delayControl) {
        this.prevFields = null;
        RfHidHolder ownHidHolder = this.getHidHolder();
        if (ownHidHolder == null) {
            return null;
        }
        List<RfPort> ports = this.getLocalPorts();
        if (ports == null || ports.isEmpty()) {
            return null;
        }
        ArrayList<Hid> portHids = new ArrayList<Hid>(ports.size());
        HashMap<String, Hid> portHidMap = new HashMap<String, Hid>();
        for (IRfNamedElement iRfNamedElement : ports) {
            Hid portHid = STransformer.BUILDERS.buildHid(iRfNamedElement.getName(), iRfNamedElement, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (portHid == null) {
                return null;
            }
            portHids.add(portHid);
            portHidMap.put(String.valueOf(iRfNamedElement.getName()) + "___prev$", portHid);
        }
        HidEvalHidObjectUDPVisitor hidEvalHidObjectUDPVisitor = new HidEvalHidObjectUDPVisitor(portHids, driveStrength, delayControl);
        ownHidHolder.visitHidObject(null, hidEvalHidObjectUDPVisitor);
        HidOperator firstIfStatement = hidEvalHidObjectUDPVisitor.getFirstIfStatement();
        if (this.prevFields == null || this.prevFields.isEmpty()) {
            return Collections.singletonList(firstIfStatement);
        }
        ArrayList<HidOperator> result = new ArrayList<HidOperator>(this.prevFields.size() + 1);
        result.add(firstIfStatement);
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.DUMMY_OCCURRENCE;
        for (RfField field : this.prevFields.values()) {
            Hid prevFieldHid = STransformer.BUILDERS.buildHid(field.getName(), (IRfNamedElement)field, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (prevFieldHid == null) {
                return null;
            }
            Hid portHid = (Hid)portHidMap.get(field.getName());
            HidOperator assign = STransformer.BUILDERS.buildOperator((IHidObject)prevFieldHid, Collections.singletonList(portHid), 488, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "<=", occurrence, HidQualifierCache.IS_NONBLOCKING_ASSIGN_QUALIFIER);
            if (assign == null) {
                return null;
            }
            result.add(assign);
        }
        return result;
    }

    private static HidOperator convertDefaultUDPEntry(boolean isSequential, List<Hid> portHids, HidOperator driveStrength, HidOperator delayControl) {
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.DUMMY_OCCURRENCE;
        if (isSequential) {
            Hid nextStateHid = portHids.get(0);
            HidOperator elseAssign = STransformer.BUILDERS.buildOperator((IHidObject)nextStateHid, Collections.singletonList(RfHidImplicit.X_BIT), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER);
            if (delayControl != null) {
                elseAssign = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(delayControl, elseAssign, occurrence);
            }
            if (driveStrength != null) {
                elseAssign = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(driveStrength, elseAssign, occurrence);
            }
            return elseAssign;
        }
        Hid outputPortHid = portHids.get(0);
        HidOperator elseAssign = STransformer.BUILDERS.buildOperator((IHidObject)outputPortHid, Collections.singletonList(RfHidImplicit.X_BIT), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER);
        if (delayControl != null) {
            elseAssign = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(delayControl, elseAssign, occurrence);
        }
        if (driveStrength != null) {
            elseAssign = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(driveStrength, elseAssign, occurrence);
        }
        return elseAssign;
    }

    private static HidOperator convertCombinationalUDPEntry(HidOperator operator, List<Hid> portHids, HidOperator driveStrength, HidOperator delayControl, ParserPath parserPath) {
        ListContainer values = operator.getRHValues();
        if (values == null || values.size() != portHids.size()) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 1");
        }
        int size = values.size();
        HidOperator andCondition = null;
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.DUMMY_OCCURRENCE;
        int i = size - 1;
        while (i > 0) {
            Hid portHid = portHids.get(size - i);
            IHidObject value = (IHidObject)values.get(i);
            if (!(value instanceof IRfHidImplicitLayer) || !((IRfHidImplicitLayer)value).isUDPAnyValueSymbol()) {
                HidOperator condition = RfPrimitive.convertTablePosition(portHid, value, occurrence);
                if (condition == null) {
                    throw new UnsupportedOperationException("Internal primitive evaluation exception 2");
                }
                if (andCondition == null) {
                    andCondition = condition;
                } else if ((andCondition = STransformer.BUILDERS.buildOperator((IHidObject)andCondition, Collections.singletonList(condition), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L)) == null) {
                    throw new UnsupportedOperationException("Internal primitive evaluation exception 3");
                }
            }
            --i;
        }
        Hid outputPortHid = portHids.get(0);
        IHid outputSymbol = RfPrimitive.internalConvertOutputValue((IHidObject)values.get(0), null);
        HidOperator assign = STransformer.BUILDERS.buildOperator((IHidObject)outputPortHid, Collections.singletonList(outputSymbol), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER);
        if (delayControl != null) {
            assign = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(delayControl, assign, occurrence);
        }
        if (driveStrength != null) {
            assign = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(driveStrength, assign, occurrence);
        }
        if (assign == null) {
            return null;
        }
        return HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, parserPath, -1, -1, -1, null, true, new IHidObject[]{andCondition, assign});
    }

    private static HidOperator convertSequentialUDPEntry(HidOperator operator, List<Hid> portHids, HidOperator driveStrength, HidOperator delayControl, ParserPath parserPath) {
        HidOperator currentStateCondition;
        ListContainer values = operator.getRHValues();
        if (values == null || values.size() - 1 != portHids.size()) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 4");
        }
        int size = values.size() - 1;
        HidOperator andCondition = null;
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.DUMMY_OCCURRENCE;
        int i = size - 1;
        while (i > 0) {
            Hid portHid = portHids.get(size - i);
            IHidObject value = (IHidObject)values.get(i + 1);
            if (!(value instanceof IRfHidImplicitLayer) || !((IRfHidImplicitLayer)value).isUDPAnyValueSymbol()) {
                HidOperator condition = RfPrimitive.convertTablePosition(portHid, value, occurrence);
                if (condition == null) {
                    throw new UnsupportedOperationException("Internal primitive evaluation exception 5");
                }
                if (andCondition == null) {
                    andCondition = condition;
                } else if ((andCondition = STransformer.BUILDERS.buildOperator((IHidObject)andCondition, Collections.singletonList(condition), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L)) == null) {
                    throw new UnsupportedOperationException("Internal primitive evaluation exception 6");
                }
            }
            --i;
        }
        Hid outputPortHid = portHids.get(0);
        IHidObject currentState = (IHidObject)values.get(1);
        if (!(currentState instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)currentState).isUDPAnyValueSymbol() || (andCondition = STransformer.BUILDERS.buildOperator(andCondition, Collections.singletonList(currentStateCondition = RfPrimitive.convertTablePosition(outputPortHid, currentState, occurrence)), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L)) != null)) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 7");
        }
        IHid nextState = RfPrimitive.internalConvertOutputValue((IHidObject)values.get(0), outputPortHid);
        if (nextState instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)nextState).isUDPNextStateNoChangeSymbol()) {
            nextState = outputPortHid;
        }
        HidOperator assign = STransformer.BUILDERS.buildOperator((IHidObject)outputPortHid, Collections.singletonList(nextState), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", occurrence, HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER);
        if (delayControl != null) {
            assign = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(delayControl, assign, occurrence);
        }
        if (driveStrength != null) {
            assign = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(driveStrength, assign, occurrence);
        }
        if (assign == null) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 8");
        }
        return HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, parserPath, -1, -1, -1, null, true, new IHidObject[]{andCondition, assign});
    }

    private static HidOperator convertTablePosition(Hid portHid, IHidObject value, HidOperatorOccurrence occurrence) {
        if (value instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)value).isUDPLevelSymbol()) {
            return RfPrimitive.internalConvertLevelSymbol(((IRfHidImplicitLayer)value).getName().charAt(0), (IHidObject)portHid, occurrence);
        }
        if (value instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)value).isUDPEdgeSymbol()) {
            return RfPrimitive.internalConvertEdgeSymbol(((IRfHidImplicitLayer)value).getName().charAt(0), portHid, occurrence);
        }
        if (value instanceof IRfHidOperatorLayer && ((IRfHidOperatorLayer)value).isSequentialUDPEdgeIndicator()) {
            return RfPrimitive.internalConvertEdgeIndicator((IRfHidOperatorLayer)value, portHid, occurrence);
        }
        throw new UnsupportedOperationException("Internal primitive evaluation exception 9");
    }

    private static IHid internalConvertOutputValue(IHidObject value, Hid outputPortHid) {
        char ch = ((IRfHidImplicitLayer)value).getName().charAt(0);
        switch (ch) {
            case 'X': 
            case 'x': {
                return RfHidImplicit.X_BIT;
            }
            case '0': {
                return RfHidImplicit.ZERO_BIT;
            }
            case '1': {
                return RfHidImplicit.ONE_BIT;
            }
            case '-': {
                return outputPortHid;
            }
        }
        return null;
    }

    private static RfHid internalCreatePrevField(RfPort port) {
        RfDefElement portDeclaration;
        RfPrimitive primitive = (RfPrimitive)port.getEnclosingScope();
        if (primitive == null) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 10");
        }
        if (primitive.prevFields == null) {
            primitive.prevFields = new LinkedHashMap<String, RfField>();
        }
        if ((portDeclaration = port.getDeclaration()) == null) {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 11");
        }
        String name = String.valueOf(port.getName()) + "___prev$";
        RfField field = primitive.prevFields.get(name);
        if (field == null) {
            field = new RfField(name, false, new DataType("reg"), 1, 0, null);
            RfFieldDef declaration = new RfFieldDef(portDeclaration.getDefFile(), name, portDeclaration.getStartInfo(), portDeclaration.getEndInfo(), null, null);
            field.addDeclaration(declaration);
            primitive.prevFields.put(name, field);
        }
        return (RfHid)STransformer.BUILDERS.buildHid(name, (IRfNamedElement)field, HidOccurrence.DUMMY_OCCURRENCE, 0L);
    }

    private static HidOperator internalConvertLevelSymbol(char ch, IHidObject portSide, HidOperatorOccurrence occurrence) {
        HidOperator lhSide = null;
        HidOperator rhSide = null;
        switch (ch) {
            case 'B': 
            case 'b': {
                lhSide = STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
            }
            case '?': {
                lhSide = STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                HidOperator orCondition = STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)orCondition, Collections.singletonList(rhSide), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
            }
            case 'X': 
            case 'x': {
                return STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
            }
            case '0': {
                return STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
            }
            case '1': {
                return STransformer.BUILDERS.buildOperator(portSide, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
            }
        }
        return null;
    }

    private static HidOperator internalConvertEdgeSymbol(char ch, Hid portHid, HidOperatorOccurrence occurrence) {
        RfHid prevPortHid = RfPrimitive.internalCreatePrevField((RfPort)portHid.getElement());
        HidOperator lhSide = null;
        HidOperator rhSide = null;
        HidOperator orCondition = null;
        HidOperator temp = null;
        switch (ch) {
            case 'R': 
            case 'r': {
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
            }
            case 'F': 
            case 'f': {
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
            }
            case 'P': 
            case 'p': {
                orCondition = RfPrimitive.internalConvertEdgeSymbol('r', portHid, occurrence);
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                temp = STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
                orCondition = STransformer.BUILDERS.buildOperator((IHidObject)orCondition, Collections.singletonList(temp), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                temp = STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)orCondition, Collections.singletonList(temp), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
            }
            case 'N': 
            case 'n': {
                orCondition = RfPrimitive.internalConvertEdgeSymbol('f', portHid, occurrence);
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.ONE_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                temp = STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
                orCondition = STransformer.BUILDERS.buildOperator((IHidObject)orCondition, Collections.singletonList(temp), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
                lhSide = STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(RfHidImplicit.X_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                rhSide = STransformer.BUILDERS.buildOperator((IHidObject)portHid, Collections.singletonList(RfHidImplicit.ZERO_BIT), 484, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "===", occurrence, 0L);
                temp = STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
                return STransformer.BUILDERS.buildOperator((IHidObject)orCondition, Collections.singletonList(temp), 481, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "||", occurrence, 0L);
            }
            case '*': {
                return STransformer.BUILDERS.buildOperator((IHidObject)prevPortHid, Collections.singletonList(portHid), 485, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "!==", occurrence, 0L);
            }
        }
        return null;
    }

    private static HidOperator internalConvertEdgeIndicator(IRfHidOperatorLayer edgeIndicator, Hid portHid, HidOperatorOccurrence occurrence) {
        char prevCh = '\u0000';
        char ch = '\u0000';
        if (edgeIndicator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
            lhValue = edgeIndicator.getLHValue();
            IHidObject rhValue = edgeIndicator.getFirstRHValue();
            if (lhValue instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)lhValue).isUDPLevelSymbol() && rhValue instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)rhValue).isUDPLevelSymbol()) {
                prevCh = ((IRfHidImplicitLayer)lhValue).getName().charAt(0);
                ch = ((IRfHidImplicitLayer)rhValue).getName().charAt(0);
            }
        } else {
            String bothValues;
            lhValue = edgeIndicator.getLHValue();
            if (lhValue instanceof IRfHidImplicitLayer && (bothValues = ((IRfHidImplicitLayer)lhValue).getName()).length() == 2) {
                prevCh = bothValues.charAt(0);
                ch = bothValues.charAt(1);
            }
        }
        if (prevCh == '\u0000' || ch == '\u0000') {
            throw new UnsupportedOperationException("Internal primitive evaluation exception 12");
        }
        HidOperator andCondition = RfPrimitive.internalConvertEdgeSymbol('*', portHid, occurrence);
        if (prevCh == '?' && ch == '?') {
            return andCondition;
        }
        HidOperator rhSide = RfPrimitive.internalConvertLevelSymbol(ch, (IHidObject)portHid, occurrence);
        if (prevCh == '?') {
            andCondition = STransformer.BUILDERS.buildOperator((IHidObject)andCondition, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
            return andCondition;
        }
        RfHid prevPortHid = RfPrimitive.internalCreatePrevField((RfPort)portHid.getElement());
        HidOperator lhSide = RfPrimitive.internalConvertLevelSymbol(prevCh, (IHidObject)prevPortHid, occurrence);
        if (ch == '?') {
            andCondition = STransformer.BUILDERS.buildOperator((IHidObject)andCondition, Collections.singletonList(lhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
            return andCondition;
        }
        return STransformer.BUILDERS.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 480, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "&&", occurrence, 0L);
    }

    private HidOperator computeInitialOperator() {
        RfHidHolder ownHidHolder = this.getHidHolder();
        if (ownHidHolder == null) {
            return null;
        }
        final HidOperator[] result = new HidOperator[1];
        ownHidHolder.visitHidObject(null, (IHidVisitor)new HidOperatorVisitor(new HidOperatorQualifier[0]){

            public boolean visit(HidOperator operator) {
                if (!operator.isComplete()) {
                    return true;
                }
                if (operator.isAssignment()) {
                    result[0] = operator;
                }
                return true;
            }
        });
        return result[0];
    }

    public boolean xIsPrimitive() {
        return true;
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        Collection<? extends IRfNamedElement> localMembers = super.xGetLocalMembers();
        if (this.prevFields == null || this.prevFields.isEmpty()) {
            return localMembers;
        }
        ArrayList<? extends IRfNamedElement> result = new ArrayList<IRfNamedElement>(localMembers.size() + this.prevFields.size());
        result.addAll(localMembers);
        for (RfField field : this.prevFields.values()) {
            result.add(field);
        }
        return result;
    }

    public List<IRfActionBlockElement> xGetExecBlocks(HidOperator driveStrength, HidOperator delayControl, XInstValueHolder instanceValueHolder, boolean initialBlocksOnly) {
        Collection<HidOperator> operators;
        RfActionBlockDef blockDef;
        String blockName;
        if (initialBlocksOnly) {
            return null;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return null;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return null;
        }
        ArrayList<IRfActionBlockElement> blocks = new ArrayList<IRfActionBlockElement>(2);
        HidOperator initialOperator = this.computeInitialOperator();
        if (initialOperator != null) {
            HidOperatorOccurrence occurrence = initialOperator.getOccurrence();
            blockName = "@" + parserPath + '@' + occurrence.getOffset();
            LineInfo startInfo = new LineInfo(declaration.getStartLine(), declaration.getStartOffset(), declaration.getStartVirtualOffset());
            RfNamedActionBlock block = new RfNamedActionBlock(blockName, false, IRfActionBlockElement.BlockQualifier.INITIAL.value(), this, null, 0, false);
            blockDef = new RfActionBlockDef(declaration.getDefFile(), blockName, startInfo, startInfo, null, null);
            block.addDeclaration(blockDef);
            block.getOrCreateHidHolder();
            blocks.add(block);
            block.addOperator(IHidHolderConstants.OperatorRequest.of((HidOperator)initialOperator, (ParserPath)parserPath, (HidOperatorOccurrence)occurrence));
        }
        if ((operators = this.computeTableOperator(driveStrength, delayControl)) != null && !operators.isEmpty()) {
            blockName = "@" + parserPath + '@' + declaration.getStartOffset();
            RfNamedActionBlock block = new RfNamedActionBlock(blockName, false, IRfActionBlockElement.BlockQualifier.ALWAYS.value(), this, null, 0, true);
            LineInfo startInfo = new LineInfo(declaration.getStartLine() + 1, declaration.getStartOffset() + 1, declaration.getStartVirtualOffset());
            blockDef = new RfActionBlockDef(declaration.getDefFile(), blockName, startInfo, startInfo, null, null);
            block.addDeclaration(blockDef);
            block.getOrCreateHidHolder();
            blocks.add(block);
            HidOperator controlEvent = this.computeEventControlOperator();
            if (controlEvent != null) {
                block.addOperator(IHidHolderConstants.OperatorRequest.of((HidOperator)controlEvent, (ParserPath)parserPath, (HidOperatorOccurrence)controlEvent.getOccurrence()));
            }
            for (HidOperator operator : operators) {
                block.addOperator(IHidHolderConstants.OperatorRequest.of((HidOperator)operator, (ParserPath)parserPath, (HidOperatorOccurrence)operator.getOccurrence()));
            }
        }
        return blocks;
    }

    private HidOperator computeEventControlOperator() {
        IHidObject lhValue;
        List<RfPort> ports = this.getLocalPorts();
        if (ports == null || ports.isEmpty()) {
            return null;
        }
        ArrayList<Hid> portHids = new ArrayList<Hid>(ports.size());
        int i = 1;
        while (i < ports.size()) {
            IRfNamedElement port = ports.get(i);
            Hid portHid = STransformer.BUILDERS.buildHid(port.getName(), port, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (portHid == null) {
                return null;
            }
            portHids.add(portHid);
            ++i;
        }
        HidOperatorOccurrence occurrence = HidOperatorOccurrence.DUMMY_OCCURRENCE;
        Object object = lhValue = portHids.size() == 1 ? (IHidObject)portHids.iterator().next() : STransformer.makeStandInOperator((IHidObject)STransformer.makeStandInImplicit(",", IHidImplicitConstants.ImplicitType.VARIADIC_LIMIT.id), portHids, 459, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, ",", occurrence, 0L);
        if (lhValue == null) {
            return null;
        }
        RfHidOperator edgeOperator = STransformer.makeStandInOperator(lhValue, Collections.emptyList(), 496, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "@", occurrence, HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER);
        return edgeOperator;
    }

    public void setTimescale(HidImplicit[] timescale) {
        this.timescale = timescale;
    }

    private static class HidEvalHidObjectUDPVisitor
    implements IHidVisitor<RfHidOperator> {
        private List<Hid> portHids;
        private HidOperator prevIfStatement;
        private HidOperator firstIfStatement;
        private boolean isSequential;
        private ParserPath parserPath;
        private boolean hasDefaultBranch;
        private HidOperator driveStrength;
        private HidOperator delayControl;

        public HidEvalHidObjectUDPVisitor(List<Hid> portHids, HidOperator driveStrength, HidOperator delayControl) {
            this.portHids = portHids;
            this.driveStrength = driveStrength;
            this.delayControl = delayControl;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            if (!operator.isComplete()) {
                return true;
            }
            if (operator.isAssignment()) {
                return true;
            }
            HidOperator prog = null;
            if (operator.isCombinationalUDPEntry()) {
                prog = RfPrimitive.convertCombinationalUDPEntry(operator, this.portHids, this.driveStrength, this.delayControl, this.parserPath);
            } else if (operator.isSequentialUDPEntry()) {
                prog = RfPrimitive.convertSequentialUDPEntry(operator, this.portHids, this.driveStrength, this.delayControl, this.parserPath);
                this.isSequential = true;
            } else {
                throw new UnsupportedOperationException();
            }
            if (prog == null) {
                return true;
            }
            if (this.prevIfStatement == null) {
                this.prevIfStatement = prog;
                this.firstIfStatement = prog;
            } else {
                this.prevIfStatement.addRHValue((IHidObject)prog, false);
                this.prevIfStatement = prog;
            }
            return true;
        }

        public HidOperator getFirstIfStatement() {
            if (this.firstIfStatement == null) {
                return null;
            }
            if (!this.hasDefaultBranch) {
                this.hasDefaultBranch = true;
                HidOperator prog = RfPrimitive.convertDefaultUDPEntry(this.isSequential, this.portHids, this.driveStrength, this.delayControl);
                this.prevIfStatement.addRHValue((IHidObject)prog, false);
            }
            return this.firstIfStatement;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

