/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import antlr.RecognitionException;
import antlr.Token;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigUtils;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoDefineByNameFilter;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalChecksKind;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.UnelaboratedChecksKind;
import ro.amiq.dvt.buildconfig.VerissimoChecksKind;
import ro.amiq.dvt.buildconfig.VerissimoCompilationChecks;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.IELProject;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.ElementFromCursorDetectionException;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceUtils;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.DVTPackageConfiguration;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMixedNamedElementVisitorProxy;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.IndexInfo;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.precompiled.PrecompiledAutoDebugUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.precompiled.PrecompiledDbStats;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.editor.DVTConnectPositionToDocumentProvider;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorAttributes;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.builders.VlogBuildContributor;
import ro.amiq.vlogdt.interpreter.XSimVlogCHS;
import ro.amiq.vlogdt.interpreter.factory.chs.XVlogCHSValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.uvm.XVlogUVMValueHolderFactory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilder;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.utils.LintExprFactory;
import ro.amiq.vlogdt.model.IVlogModel;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogFileInfo;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.floatingwidgets.VlogFNotificationProvider;
import ro.amiq.vlogdt.model.persistence.Persistence;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataExpressionType;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.DefNamedElementPair;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.IRfFileListener;
import ro.amiq.vlogdt.model.reflection.IRfMacroVisitor;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.IRfSwitchLibraryListener;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.LightToken;
import ro.amiq.vlogdt.model.reflection.LightTokenList;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssertExpectDef;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfClockingBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConfigurationDef;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfCoverbin;
import ro.amiq.vlogdt.model.reflection.RfCoverbinDef;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovercrossDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfCoverpointDef;
import ro.amiq.vlogdt.model.reflection.RfCuname;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfEncryptedCodeAutoManager;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfEventTriggerDef;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFragmentDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfFunctionCallDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateHolderDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportDef;
import ro.amiq.vlogdt.model.reflection.RfModportFunction;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNetTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfPrimitiveDef;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfPropertySequenceDef;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfSemanticError;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypeAliasDef;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfVerilog;
import ro.amiq.vlogdt.model.reflection.RfVunit;
import ro.amiq.vlogdt.model.reflection.RfVunitDef;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.RfWaitDef;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;
import ro.amiq.vlogdt.model.reflection.ams.NatureParent;
import ro.amiq.vlogdt.model.reflection.ams.RfConnectRules;
import ro.amiq.vlogdt.model.reflection.ams.RfConnectRulesDef;
import ro.amiq.vlogdt.model.reflection.ams.RfDiscipline;
import ro.amiq.vlogdt.model.reflection.ams.RfDisciplineDef;
import ro.amiq.vlogdt.model.reflection.ams.RfNature;
import ro.amiq.vlogdt.model.reflection.ams.RfNatureAttr;
import ro.amiq.vlogdt.model.reflection.ams.RfNatureAttrDef;
import ro.amiq.vlogdt.model.reflection.ams.RfNatureDef;
import ro.amiq.vlogdt.model.reflection.ams.RfParamset;
import ro.amiq.vlogdt.model.reflection.ams.RfParamsetDef;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedPackage;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.DVTCustomToken;
import ro.amiq.vlogdt.parser.EncryptedCodeLineInfo;
import ro.amiq.vlogdt.parser.EncryptedPragmaInfo;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.TimeConsumingStatement;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogProblem;
import ro.amiq.vlogdt.parser.VlogUtil;
import ro.amiq.vlogdt.precompiled.VlogPrecompiledDBUtils;
import ro.amiq.vlogdt.r2lparser.R2LFilters;
import ro.amiq.vlogdt.r2lparser.R2LUtils;
import ro.amiq.vlogdt.r2lparser.strategies.VlogR2LCache;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.persistenttask.TaskInfoWrapper;
import ro.amiq.vlogdt.ui.syntaxerrors.SyntaxErrorsManager;
import ro.amiq.vlogdt.utils.SourceFileToBuildFileMapping;
import ro.amiq.vlogdt.utils.Utils;

public class RfProject
extends RfNamedElement
implements IRfSingleLangProject,
IELProject {
    private static final long serialVersionUID = 21135L;
    private static final String TEMP_LIBRARY_NAME = "non-top-files";
    private static final Map<String, DataType> SIMPLE_TYPES = new HashMap<String, DataType>();
    protected static IElementValidator fParameterValidator;
    protected static IElementValidator fClassValidator;
    protected static IElementValidator fTypeAliasValidator;
    protected static IElementValidator fFunctionValidator;
    protected static IElementValidator fTaskValidator;
    protected static IElementValidator fFieldValidator;
    protected static IElementValidator fEventValidator;
    protected static IElementValidator fConstructorValidator;
    protected static IElementValidator fEnumElementValidator;
    protected static IElementValidator fVariableValidator;
    protected static IElementValidator fArgumentValidator;
    private transient IBuildConfigParserConstants.UsageBeforeDeclarationScope orderAnalysisScope;
    private static transient AtomicInteger fCount1;
    private static transient AtomicInteger fCount2;
    private static transient AtomicInteger fCount4;
    private static transient AtomicInteger fCount5;
    private transient Set<RfNamedElement> fNamedElementsWithEncryptedDefSet;
    private transient EncryptedCodeAutoFilter fEncryptedCodeAutoFilter;
    private transient ChangedFilesManager fChangedFilesManager;
    public static final String PREDEFINED_STD_PACKAGE_NAME = "std";
    public static final String PREDEFINED_STD_LIBRARY_NAME = "<std>";
    public static final String PREDEFINED_NATIVE_LIBRARY_NAME = "<native>";
    private RfProjectContent fRfProjectContent = new RfProjectContent();
    public static transient RfVerilog PREDEFINED_GLOBAL;
    private transient IProject fProject;
    private transient boolean fIncrementalBuild;
    private transient String fDefaultLibraryName;
    private transient RfFileDef fCurrentFileDef;
    private transient VlogMacroZone fCurrentMacroZone;
    private transient String fCurrentLibraryName;
    private transient String fCurrentPackageName;
    private transient String fBuildConfig;
    private transient RfMixedLangProject fMixedLangProjectParent;
    private transient BuildScope fBuildScope;
    private transient IncrementalDeltaContainer fIncrementalDeltaContainer;
    private transient Map<ParserPath, DVTEditor> fParserPathToEditorMap;
    private transient long fLastFullBuildStartTime;
    private transient long fLastFullBuildDuration;
    private transient long fLastFullBuildStartMemory;
    private transient long fLastFullBuildMemoryAllocation;
    private transient Map<ParserPath, Set<VlogProblem>> fSyntacticErrorsMap;
    private transient Map<ParserPath, Set<VlogProblem>> fSyntacticWarningsMap;
    private transient long fTime;
    private transient boolean fBuildPending;
    private transient RfCompiledFiles fRfCompiledFiles = new RfCompiledFiles();
    private transient Deque<RfNamedElement> fDuplicatesScopeStack;
    private transient Deque<IHidHolder> fOverridedHidHolder = new ArrayDeque<IHidHolder>();
    private transient FullChecksAndLibs fFullCompileChecks;
    private transient boolean fPackageConstantsDisabled;
    private transient boolean fIrunRNMTech;
    private transient boolean fStrictNonStandardChecks;
    private transient UnelaboratedChecksKind fUnelaboratedCompileChecks;
    private transient boolean fElabSkipLongExpressions;
    private transient Set<ElaborationExpressionControl> fElabExpressionControl;
    private transient Set<String> fElabExpressionOperatorControl;
    private transient boolean fElabMethodEvalDisabled;
    private transient RfGUIUtils fGUIUtils;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient int fNofBuildCanceledQueries;
    private transient boolean fCachedBuildCanceled;
    private transient RfXvmFactory fXvmFactory;
    private transient RfProjectState fProjectState = RfProjectState.NEW;
    private transient IRfSwitchLibraryListener fSwitchLibraryListener;
    private transient Object fSemanticErrorsLock = new Object();
    private transient IRfSingleLangProject.SemanticErrorsCategory fSemanticErrorCategory;
    private transient SemanticErrorsTable fSemanticErrors;
    private transient Object fSvtbIssueLockObject = new Object();
    private transient Job fComputeXvmFactory;
    private transient boolean fIsLibraryOverridenFromPreprocessor;
    private transient int fMaxNofSemanticProblemsPerFile;
    private transient Map<ParserPath, List<IRfFileListener>> fParserPathToListenerMap;
    public static final Set<Class<? extends IRfNamedElement>> CLASS_CONTAINERS;
    private transient Map<String, HashSet<String>> fLintTrackMacrosByNamesPerScope;
    private transient Set<String> fLintTrackMacrosByDeprecatedComments;
    private transient LintExprFactory fLintExprFactory;
    private transient boolean fLintStoreTokens;
    private transient boolean fLintIncrementalBuildStarted;
    private transient boolean fLintIncrementalBuild;
    private transient Map<ParserPath, LightTokenList> fLintTokensTableMap;
    private transient boolean fLintingEnabled;
    private transient IntSet fLintTrackP2LInfo;
    private transient Map<ParserPath, Set<String>> fLintTrackMacroCallNames;
    private transient IIdleListener fIdleListener;
    private transient DVTPFModel fPowerFormatModel;
    protected transient OVMProject ovmProject;

    static {
        fCount1 = new AtomicInteger(0);
        fCount2 = new AtomicInteger(0);
        fCount4 = new AtomicInteger(0);
        fCount5 = new AtomicInteger(0);
        fParameterValidator = new IElementValidator(){

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return element.hasProperty(kind);
            }

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                return true;
            }
        };
        fClassValidator = new IElementValidator(){

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                return true;
            }
        };
        fTypeAliasValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                return accessModifier != IRfNamedElement.AccessModifier.SHOW_PUBLIC || !element.isProtected();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fFunctionValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (((RfFunction)element).isConstructor() || ((RfFunction)element).isTask()) {
                    return false;
                }
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                return accessModifier != IRfNamedElement.AccessModifier.SHOW_PUBLIC || !element.isProtected();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fTaskValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (!((RfFunction)element).isTask()) {
                    return false;
                }
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                return accessModifier != IRfNamedElement.AccessModifier.SHOW_PUBLIC || !element.isProtected();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fFieldValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                if (accessModifier == IRfNamedElement.AccessModifier.SHOW_PUBLIC && element.isProtected()) {
                    return false;
                }
                if (!((RfField)element).isField()) {
                    return false;
                }
                return !((RfField)element).isEvent();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fVariableValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                RfField field = (RfField)element;
                return field.isVariable() || field.isGenvar();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fArgumentValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                return ((RfField)element).isArgument();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fEventValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                if (accessModifier == IRfNamedElement.AccessModifier.SHOW_PUBLIC && element.isProtected()) {
                    return false;
                }
                if (!((RfField)element).isField()) {
                    return false;
                }
                return ((RfField)element).isEvent();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fConstructorValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                if (accessModifier != IRfNamedElement.AccessModifier.SHOW_PRIVATE && element.isPrivate()) {
                    return false;
                }
                if (accessModifier == IRfNamedElement.AccessModifier.SHOW_PUBLIC && element.isProtected()) {
                    return false;
                }
                return ((RfFunction)element).isConstructor();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        fEnumElementValidator = new IElementValidator(){

            @Override
            public boolean accessModifier(RfNamedElement element, IRfNamedElement.AccessModifier accessModifier) {
                RfField field = (RfField)element;
                if (field.isEvent() || field.isParameter() || field.isTypeParameter() || field.isArgument()) {
                    return false;
                }
                return field.isEnumElement();
            }

            @Override
            public boolean hasProperty(RfNamedElement element, int kind) {
                return true;
            }
        };
        PREDEFINED_GLOBAL = new RfVerilog();
        PREDEFINED_GLOBAL.init();
        CLASS_CONTAINERS = new HashSet<Class<? extends IRfNamedElement>>();
        CLASS_CONTAINERS.add(RfLibrary.class);
        CLASS_CONTAINERS.add(RfPackage.class);
        CLASS_CONTAINERS.add(RfCuname.class);
        CLASS_CONTAINERS.add(RfClass.class);
        CLASS_CONTAINERS.add(RfModule.class);
        CLASS_CONTAINERS.add(RfInterface.class);
        CLASS_CONTAINERS.add(RfProgram.class);
        CLASS_CONTAINERS.add(RfGenerateBlock.class);
    }

    private int getMaxSemanticIssuesPerFile() {
        return ro.amiq.vlogdt.test.TestHelper.isTestMode() && ro.amiq.vlogdt.test.TestHelper.isUsingMaxIntSemanticIssuesPerFile() ? Integer.MAX_VALUE : this.fMaxNofSemanticProblemsPerFile;
    }

    public static DataType getSimpleDataType(String typeName) {
        DataType type = SIMPLE_TYPES.get(typeName);
        if (type != null) {
            return type;
        }
        type = new DataType(typeName);
        SIMPLE_TYPES.put(typeName, type);
        return type;
    }

    public static RfNamedElement getSimpleType(DataType dataType) {
        block28: {
            String firstPackedDimensionText;
            String typeName;
            block26: {
                if (dataType == null || dataType.hasUnpackedDimension()) {
                    return null;
                }
                typeName = dataType.getType();
                if (typeName == null && (dataType.getNetType() != null || dataType.hasPackedDimension())) {
                    typeName = "logic";
                }
                if (typeName == null) {
                    return null;
                }
                List<IndexType> packedDimensions = dataType.getPackedDimension();
                if (packedDimensions == null || packedDimensions.isEmpty()) {
                    RfScalarType scalarType = PREDEFINED_GLOBAL.getScalarTypeWithPrefix(typeName, 1);
                    if (scalarType != null) {
                        return scalarType instanceof RfBitVectorScalarType ? ((RfBitVectorScalarType)scalarType).getScalarWithSign(dataType.getSign()) : scalarType;
                    }
                    return null;
                }
                if (packedDimensions.size() != 1) {
                    return null;
                }
                firstPackedDimensionText = packedDimensions.get((int)0).fType;
                if (!"bit".equals(typeName)) break block26;
                switch (firstPackedDimensionText) {
                    case "31:0": {
                        return RfBitVectorScalarType.INT_UNSIGNED.getScalarWithSign(dataType.getSign()).getSimpleBitVectorType();
                    }
                    case "63:0": {
                        return RfBitVectorScalarType.LONGINT_UNSIGNED.getScalarWithSign(dataType.getSign()).getSimpleBitVectorType();
                    }
                }
                return null;
            }
            if (!"logic".equals(typeName)) break block28;
            switch (firstPackedDimensionText) {
                case "31:0": {
                    return RfBitVectorScalarType.INTEGER_UNSIGNED.getScalarWithSign(dataType.getSign()).getSimpleBitVectorType();
                }
                case "63:0": {
                    return RfBitVectorScalarType.TIME.getScalarWithSign(dataType.getSign()).getSimpleBitVectorType();
                }
            }
            return null;
        }
        return null;
    }

    public IRfProjectContent getRfProjectContent() {
        return this.fRfProjectContent;
    }

    public void setRfProjectContent(IRfProjectContent rfProjectContent) {
        VlogFileInstance topInstance;
        this.fRfProjectContent = (RfProjectContent)rfProjectContent;
        if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
            for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
                fileDef.setRfProject(this);
            }
        }
        if (this.fRfProjectContent.fPreprocessingTable != null && (topInstance = this.fRfProjectContent.fPreprocessingTable.getTopFileInstance()) != null) {
            topInstance.setRfProject(this);
            NullProtectedList<VlogMacroInfo> macros = new NullProtectedList<VlogMacroInfo>();
            topInstance.getAllDefines(macros);
            for (VlogMacroInfo macro : macros) {
                macro.setEnclosingScope(this);
            }
        }
    }

    public void restoreInvocationsInfo(IRfProjectContent rfProjectContent, RfCompiledFiles compilesFiles, Map<String, BCFileInstance> buildConfigFiles) {
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        if (preprocessing == null) {
            return;
        }
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        if (topInstance == null) {
            return;
        }
        List<VlogFileInstance> recursiveFileInstances = this.getRecursiveFileInstances(topInstance.getIncludedInstances());
        if (recursiveFileInstances == null) {
            return;
        }
        for (VlogFileInstance fileInstance : recursiveFileInstances) {
            BuildConfigUtils.sendIndexToBCFiles((int)fileInstance.getIndex(), (LanguageKind)LanguageKind.VLOG, (int)fileInstance.getInvocNumber(), buildConfigFiles);
        }
    }

    public RfCompiledFiles getRfCompiledFiles() {
        this.fRfCompiledFiles.fCompiledFiles = new HashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return this.fRfCompiledFiles;
    }

    public void setRfCompiledFiles(RfCompiledFiles rfCompiledFiles) {
        this.fRfCompiledFiles = rfCompiledFiles;
    }

    public void setLastFullBuildStartTime() {
        this.fLastFullBuildStartTime = System.currentTimeMillis();
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        this.fNofBuildCanceledQueries = 0;
        this.fCachedBuildCanceled = false;
    }

    public void setScopeForNewIncludedFile(VlogFileInstance fileInstance, boolean newIncludedFile) {
        this.getFileDefinition(fileInstance);
        if (!newIncludedFile) {
            return;
        }
        try {
            VlogBuildContributor.createResource(this.fProject, fileInstance.getParserPath(), fileInstance.getLanguageSyntax(), fileInstance.getIndex());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isCompiled(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null || this.fRfProjectContent.fParserPath2FileDefMap.isEmpty()) {
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                return this.fRfCompiledFiles.fCompiledFiles.contains(parserPath.toCanonical());
            }
            return false;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.containsKey(parserPath.toCanonical());
    }

    public boolean updateParserPath(ParserPath oldParserPath, ParserPath newParserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return false;
        }
        RfFileDef fileDef = this.fRfProjectContent.fParserPath2FileDefMap.get(oldParserPath.toCanonical());
        if (fileDef == null) {
            return false;
        }
        RfFileDef copyFileDef = new RfFileDef(fileDef);
        copyFileDef.setParserPath(newParserPath);
        copyFileDef.setFileName(Path.fromOSString((String)newParserPath.getCanonicalPath()).lastSegment());
        this.fRfProjectContent.fParserPath2FileDefMap.put((ParserPath)newParserPath.toCanonical(), copyFileDef);
        return true;
    }

    private boolean isBuildCanceled() {
        if (FIncrementalNotificationTracker.INSTANCE.isUpdating(this.fProject)) {
            return FIncrementalNotificationFixer.INSTANCE.isCanceled();
        }
        if (this.fGUIUtils != null && this.fGUIUtils.isCancelChecking()) {
            FIncrementalNotificationTracker.INSTANCE.confirmTransientSemanticDirtyCandidate(this.getProject());
            return true;
        }
        FIncrementalNotificationTracker.INSTANCE.resetTransientSemanticDirtyCandidates(this.getProject());
        if (this.fBuildProgressMonitor == null) {
            return false;
        }
        return this.fBuildProgressMonitor.isCanceled();
    }

    public void checkBuildCanceled() throws BuildCancelException {
        this.checkBuildCanceled(false);
    }

    public void checkBuildCanceled(boolean force) throws BuildCancelException {
        if (force || this.fNofBuildCanceledQueries % 5000 == 0) {
            this.fCachedBuildCanceled = this.isBuildCanceled();
        }
        ++this.fNofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.hasLintingTimedOut()) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.fCachedBuildCanceled) {
            DVTLogger.INSTANCE.logDebug("### VLOG SEMANTIC CANCELED BY USER ###");
            throw new BuildCancelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfXvmFactory getXvmFactory() {
        this.fComputeXvmFactory = new Job("Compute XVM Factory"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (RfProject.this.fXvmFactory != null && !RfProject.this.fXvmFactory.isInit()) {
                        RfProject.this.fXvmFactory.init();
                    }
                    if (RfProject.this.fXvmFactory == null || !RfProject.this.fXvmFactory.isInit()) {
                        this.notifyConsumersCancel();
                        return Status.CANCEL_STATUS;
                    }
                    this.notifyConsumers();
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    return Status.CANCEL_STATUS;
                }
            }

            private void notifyConsumers() {
                ListenerList xvmFactoryInitListeners = DVTMixedLangModelManager.getInstance().getXvmFactoryInitListeners();
                Object[] objectArray = xvmFactoryInitListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object consumer = objectArray[n2];
                    ((IXvmFactoryInitListener)consumer).postXvmReadyUpdate();
                    ++n2;
                }
            }

            private void notifyConsumersCancel() {
                ListenerList xvmFactoryInitListeners = DVTMixedLangModelManager.getInstance().getXvmFactoryInitListeners();
                Object[] objectArray = xvmFactoryInitListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object consumer = objectArray[n2];
                    ((IXvmFactoryInitListener)consumer).notifyCancel();
                    ++n2;
                }
            }
        };
        if (this.fXvmFactory != null) {
            return this.fXvmFactory;
        }
        RfProject rfProject = this;
        synchronized (rfProject) {
            if (this.fXvmFactory != null) {
                return this.fXvmFactory;
            }
            this.fXvmFactory = new RfXvmFactory(this);
        }
        if (this.fComputeXvmFactory.getState() != 4) {
            this.fComputeXvmFactory.schedule();
        }
        return this.fXvmFactory;
    }

    public RfXvmFactory getRawXvmFactory() {
        return this.fXvmFactory;
    }

    public boolean isXVMFactoryInitDone() {
        return this.fXvmFactory != null && this.fXvmFactory.isInitDone();
    }

    public void initXvmFactory() {
        this.getXvmFactory();
    }

    public long getLastFullBuildDuration() {
        return this.fLastFullBuildDuration;
    }

    private void updateDuration() {
        long tmp = System.currentTimeMillis();
        this.fLastFullBuildDuration = (tmp - this.fLastFullBuildStartTime) / 1000L;
    }

    public void setLastFullBuildStartMemory() {
        this.fLastFullBuildStartMemory = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
    }

    public long getLastFullBuildMemoryAllocation() {
        return Math.round((float)this.fLastFullBuildMemoryAllocation / 1048576.0f);
    }

    private void updateMemoryAllocation() {
        long tmp = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
        this.fLastFullBuildMemoryAllocation = tmp - this.fLastFullBuildStartMemory;
    }

    public RfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        super("", false);
        this.fProject = project;
        this.fIncrementalBuild = false;
        this.fIncrementalDeltaContainer = null;
        this.fDefaultLibraryName = "work";
        this.fGUIUtils = new RfGUIUtils();
        this.fRfProjectContent.fParserPath2FileDefMap = new LinkedHashMap<ParserPath, RfFileDef>();
        this.fRfProjectContent.fFileToLibraryWildcardMapping = new LinkedHashMap<String, String>();
        this.fRfProjectContent.fFileToLibraryExplicitMapping = new LinkedHashMap<String, String>();
        this.fRfProjectContent.fLibraries = new DVTLinkedHashMap();
        this.fRfProjectContent.fToolCompat = IBuildConfigParserConstants.ToolCompat.DVT;
        IncrementalElaborationKind defaultIncrementalElaborationKind = TestHelper.isTestMode() ? IncrementalElaborationKind.FULL : IncrementalElaborationKind.ADAPTIVE;
        this.setElaborationEnabled(defaultIncrementalElaborationKind);
        this.fSemanticErrors = new SemanticErrorsTable();
        this.fSemanticErrorsLock = new Object();
        this.fRfProjectContent.fSourceFileToBuildFileMapping = new SourceFileToBuildFileMapping();
        this.fRfProjectContent.fPreprocessingTable = new VlogPreprocessingInfo(this);
        this.fSvtbIssueLockObject = new Object();
        this.fBuildScope = new BuildScope();
        this.setMixedLangProjectParent(rfMixedLangProject);
        this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        this.initPredefinedStdPackageLibrary();
    }

    private void initPredefinedStdPackageLibrary() {
        RfPredefinedPackage predefinedStdPackage = new RfPredefinedPackage(PREDEFINED_STD_PACKAGE_NAME, "The standard built-in package");
        ArrayList<ArgInfo> args = new ArrayList(2);
        RfPredefinedClass semaphoreClass = new RfPredefinedClass("semaphore", null, null, "A semaphore is a syncronization mechanism. Conceptually a semaphore is a bucket. When a semaphore is created, a bucket that contains a number of keys is created. Processes using semaphores must first procure a key from the bucket before they can continue to execute. If a specific process requires a key, only a fixed number of occurences of that process can be in progress simultaneously. All others must wait until a sufficient number of keys is returned to the bucket. Semaphores are typically used for mutual exclusion, access control to shared resources and synchronization");
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("keyCount", new DataType("int"), "0", null));
        semaphoreClass.addMember(new RfPredefinedFunction("new", RfProject.getSimpleDataType("semaphore"), args, 2, "Create a semaphore with a specified number of keys"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("keyCount", new DataType("int"), "1", null));
        semaphoreClass.addMember(new RfPredefinedFunction("put", RfProject.getSimpleDataType("void"), args, 0, "Return one or more keys into the bucket"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("keyCount", new DataType("int"), "1", null));
        semaphoreClass.addMember(new RfPredefinedFunction("get", RfProject.getSimpleDataType(""), args, 1, "Obtain one or more keys from the bucket"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("keyCount", new DataType("int"), "1", null));
        semaphoreClass.addMember(new RfPredefinedFunction("try_get", RfProject.getSimpleDataType("int"), args, 0, "Try to obtain one or more keys without blocking"));
        RfPredefinedClass mailboxClass = new RfPredefinedClass("mailbox", null, null, "A mailbox is a communication mechanism that allows messages to be exchanged between processes. Data can be sent to a mailbox by one process and retrieved by another. Mailboxes are created as having either a bounded or unbounded queue size. A bounded mailbox becomes full when it contains the bounded number of messages. A process that attempts to place a message into a full mailbox shall be suspended until enough room becomes available in the mailbox queue. Unbounded mailboxes never suspend a thread in a send operation");
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("bound", new DataType("int"), "0", null));
        mailboxClass.addMember(new RfPredefinedFunction("new", RfProject.getSimpleDataType(""), args, 2, "Creates a mailbox. It returns the mailbox handle, or null if the mailbox cannot be created. If the bound argument is zero then the mailbox is unbounded (the default) and a put() operation shall never block. If bound is non-zero, it represents the size of the mailbox queue"));
        mailboxClass.addMember(new RfPredefinedFunction("num", RfProject.getSimpleDataType("int"), null, 0, "Retrieve the number of messages in the mailbox"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", new DataType("T"), null));
        mailboxClass.addMember(new RfPredefinedFunction("put", RfProject.getSimpleDataType(""), args, 1, "Place a message in the mailbox"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", new DataType("T"), null));
        mailboxClass.addMember(new RfPredefinedFunction("try_put", RfProject.getSimpleDataType("int"), args, 0, "Try to place a message in the mailbox without blocking"));
        DataType refDataType = new DataType("T");
        refDataType.setDirection(4);
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", refDataType, null));
        mailboxClass.addMember(new RfPredefinedFunction("get", RfProject.getSimpleDataType(""), args, 1, "Retrieve a message from the mailbox, removing it from the mailbox queue. If the mailbox is empty then the current process blocks until a message is placed in the mailbox"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", refDataType, null));
        mailboxClass.addMember(new RfPredefinedFunction("try_get", RfProject.getSimpleDataType("int"), args, 0, "Try to retrieve a message from the mailbox without blocking"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", refDataType, null));
        mailboxClass.addMember(new RfPredefinedFunction("peek", RfProject.getSimpleDataType(""), args, 1, "Copy a message from a mailbox without removing the message from the mailbox queue. If the mailbox is empty then the current process blocks until a message is placed in the mailbox"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("message", refDataType, null));
        mailboxClass.addMember(new RfPredefinedFunction("try_peek", RfProject.getSimpleDataType("int"), args, 0, "Try to copy a message from the mailbox without blocking"));
        mailboxClass.addMember(new RfPredefinedField("T", RfProject.getSimpleDataType("int"), 256, 0, "", ""));
        args = Collections.emptyList();
        RfPredefinedClass processClass = new RfPredefinedClass("process", null, null, "A built-in class that allows one process to access and control another process once it has started");
        processClass.addMember(new RfPredefinedFunction("self", RfProject.getSimpleDataType("process"), args, 0, "Returns a handle to the current process", 32768));
        processClass.addMember(new RfPredefinedFunction("status", RfProject.getSimpleDataType("state"), args, 0, "Returns the process status"));
        processClass.addMember(new RfPredefinedFunction("kill", RfProject.getSimpleDataType("void"), args, 0, "Terminates the given process and all its sub-processes"));
        processClass.addMember(new RfPredefinedFunction("await", RfProject.getSimpleDataType(""), args, 1, "Allows one process to wait for the completion of another process"));
        processClass.addMember(new RfPredefinedFunction("suspend", RfProject.getSimpleDataType("void"), args, 0, "Allows one process to suspend either its own execution or that of another process"));
        processClass.addMember(new RfPredefinedFunction("resume", RfProject.getSimpleDataType(""), args, 1, "Restarts a previously suspended process"));
        RfPredefinedStruct stateEnum = new RfPredefinedStruct(processClass, "enum/process/state", "Process state");
        ParserPath parserPath = new ParserPath("<predefined>");
        RfHidHolder hidHolder = new RfHidHolder(stateEnum);
        stateEnum.setHidHolder(hidHolder);
        this.createEnumItem(stateEnum, "FINISHED", "Process terminated normally", hidHolder, 0, parserPath);
        this.createEnumItem(stateEnum, "RUNNING", "Process is currently running(not in a blocking statement)", hidHolder, 1, parserPath);
        this.createEnumItem(stateEnum, "WAITING", "Process is waiting in a blocking statement", hidHolder, 2, parserPath);
        this.createEnumItem(stateEnum, "SUSPENDED", "Process is stopped awaiting a resume", hidHolder, 3, parserPath);
        this.createEnumItem(stateEnum, "KILLED", "Process was forcibly killed (via kill or disable)", hidHolder, 4, parserPath);
        processClass.addMember(stateEnum);
        RfPredefinedTypeAlias stateType = new RfPredefinedTypeAlias("state", RfProject.getSimpleDataType("enum/process/state"), stateEnum, "Process state");
        processClass.addMember(stateType);
        RfPredefinedClass weakReferenceClass = new RfPredefinedClass("weak_reference", null, null, "A built-in class that allows access to an object without preventing it from being garbage collected");
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("referent", refDataType, null));
        weakReferenceClass.addMember(new RfPredefinedFunction("new", RfProject.getSimpleDataType(""), args, 2, "Create a new weak reference"));
        args = Collections.emptyList();
        weakReferenceClass.addMember(new RfPredefinedFunction("get", refDataType, args, 0, "Get the referent object. Returns null if the referent object has been garbage collected"));
        weakReferenceClass.addMember(new RfPredefinedFunction("clear", RfProject.getSimpleDataType("void"), args, 0, "Clear the weak reference. Subsequent calls to get() on this weak reference shall return null"));
        args = OptimizedUtils.listAdd(null, (Object)new ArgInfo("obj", refDataType, null));
        weakReferenceClass.addMember(new RfPredefinedFunction("get_id", RfProject.getSimpleDataType("longint"), args, 0, "Get a unique non-zero identifier of the referent object. Returns 0 if the referent object is null", 32768));
        weakReferenceClass.addMember(new RfPredefinedField("T", RfProject.getSimpleDataType("int"), 256, 0, "", "The type of the accessed object. Must be a class type"));
        RfPredefinedFunction randomizeFun = new RfPredefinedFunction("randomize", RfProject.getSimpleDataType("int"), Collections.emptyList(), true, 0, "Randomizes data in the current scope. The syntax is: randomize(variable_identifier {, variable_identifier}) [ with constraint_block ]; ");
        predefinedStdPackage.addMember(semaphoreClass);
        predefinedStdPackage.addMember(mailboxClass);
        predefinedStdPackage.addMember(processClass);
        predefinedStdPackage.addMember(weakReferenceClass);
        predefinedStdPackage.addMember(randomizeFun);
        RfLibrary predefinedStdLibrary = new RfLibrary(PREDEFINED_STD_LIBRARY_NAME, false);
        predefinedStdLibrary.addMember(predefinedStdPackage);
        predefinedStdLibrary.setEnclosingScope(this);
        this.fRfProjectContent.fLibraries.put((Object)PREDEFINED_STD_LIBRARY_NAME, (IDVTMapElement)predefinedStdLibrary);
    }

    private void createEnumItem(RfPredefinedStruct stateEnum, String name, String comment, RfHidHolder hidHolder, int value, ParserPath parserPath) {
        RfPredefinedField element = new RfPredefinedField(name, RfProject.getSimpleDataType("int"), 8, value, "", comment);
        stateEnum.addMember(element);
        IHidBuilders hidBuilders = this.getHidBuilders();
        HidImplicit lhSide = hidBuilders.buildImplicit(name, IHidImplicitConstants.ImplicitType.ID.id);
        HidImplicit rhSide = hidBuilders.buildImplicit(Integer.toString(value), 282);
        HidOperator operator = hidBuilders.buildOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", new HidOperatorOccurrence(-1, -1, -1, HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER, null), HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER);
        hidHolder.addOpi(operator, parserPath);
    }

    public Set<ParserPath> getCompiledFilesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        HashSet<ParserPath> result = new HashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return result;
    }

    public Set<IResource> getCompiledFileResourcesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        Collection<RfFileDef> fileDefs = this.fRfProjectContent.fParserPath2FileDefMap.values();
        if (fileDefs == null || fileDefs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IResource> result = new HashSet<IResource>();
        for (RfFileDef fileDef : fileDefs) {
            IResource adapter = fileDef.getFileAdapter();
            if (adapter == null) continue;
            result.add(adapter);
        }
        return result;
    }

    public Set<ParserPath> getRawCompiledFilesSet() {
        if (this.fRfCompiledFiles == null) {
            return null;
        }
        return this.fRfCompiledFiles.fCompiledFiles;
    }

    public boolean hasSomethingToCompile() {
        return this.fRfProjectContent.fParserPath2FileDefMap != null && !this.fRfProjectContent.fParserPath2FileDefMap.keySet().isEmpty();
    }

    public void setMixedLangProjectParent(RfMixedLangProject rfMixedLangProjectParent) {
        this.fMixedLangProjectParent = rfMixedLangProjectParent;
    }

    public ELManager getELManager() {
        return this.fMixedLangProjectParent.getELManager();
    }

    public ELManager getNonELManager() {
        return this.fMixedLangProjectParent.getNonELManager();
    }

    private void setDisabledChecks(boolean isLintingEnabled) {
        this.fFullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
        this.fPackageConstantsDisabled = BuildConfigManager.isUnelaboratedDisabledPackageConstants((IProject)this.fProject);
        this.fIrunRNMTech = BuildConfigManager.isIrunRNMTech((IProject)this.fProject);
        this.fStrictNonStandardChecks = isLintingEnabled || BuildConfigManager.isStrictNonStandardChecks((IProject)this.fProject);
        this.fUnelaboratedCompileChecks = BuildConfigManager.getUnelaboratedCompileChecksKind((IProject)this.fProject);
        this.fElabSkipLongExpressions = BuildConfigManager.isElaborationSkipLongExpressions((IProject)this.fProject);
        this.fElabExpressionControl = BuildConfigManager.getElaborationExpressionControl((IProject)this.fProject);
        this.fElabExpressionOperatorControl = BuildConfigManager.getElaborationExpressionOperatorControl((IProject)this.fProject);
        this.fElabMethodEvalDisabled = BuildConfigManager.isElabDisabledMethodEvaluation((IProject)this.fProject);
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
        IncrementalElaborationKind incrementalElaborationKind = BuildConfigManager.getIncrementalElaborationKind((IProject)this.fProject);
        this.setElaborationEnabled(incrementalElaborationKind);
    }

    public void init(IProject project, IDVTRfManager rfManager, boolean shouldRunSemanticChecks) {
        this.fProject = project;
        this.fOverridedHidHolder = new ArrayDeque<IHidHolder>();
        this.fGUIUtils = new RfGUIUtils();
        this.fDefaultLibraryName = "work";
        this.fIncrementalBuild = false;
        this.fIncrementalDeltaContainer = null;
        this.fSemanticErrorsLock = new Object();
        this.fSemanticErrors = new SemanticErrorsTable();
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        if (this.fRfProjectContent.fFileToLibraryWildcardMapping == null) {
            this.fRfProjectContent.fFileToLibraryWildcardMapping = new LinkedHashMap<String, String>();
        }
        if (this.fRfProjectContent.fFileToLibraryExplicitMapping == null) {
            this.fRfProjectContent.fFileToLibraryExplicitMapping = new LinkedHashMap<String, String>();
        }
        if (this.fRfProjectContent.fLibraries == null) {
            this.fRfProjectContent.fLibraries = new DVTLinkedHashMap();
        }
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            this.fRfProjectContent.fParserPath2FileDefMap = new HashMap<ParserPath, RfFileDef>();
        }
        if (this.fRfProjectContent.fPreprocessingTable == null) {
            this.fRfProjectContent.fPreprocessingTable = new VlogPreprocessingInfo(this);
        }
        if (this.fRfProjectContent.fSourceFileToBuildFileMapping == null) {
            this.fRfProjectContent.fSourceFileToBuildFileMapping = new SourceFileToBuildFileMapping();
        }
        this.fSvtbIssueLockObject = new Object();
        this.setDisabledChecks(this.fLintingEnabled);
        this.fBuildScope = new BuildScope();
        this.fMixedLangProjectParent.cleanElaborationManagers();
        Utils.getInstance().cleanSemanticMarkers(this.fProject);
        if (shouldRunSemanticChecks) {
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
            this.resolveImports(false, true, false, true);
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS;
            this.resolveClassParents(this);
        }
        this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        this.lintInit();
    }

    public void restoreMixedLangProjectPreElab(IProgressMonitor monitor) {
        try {
            this.setUserDefinedSystemTasks();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
            this.resolveImports(true, false, true, false);
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void restoreMixedLangProjectPostElab(IProgressMonitor monitor) {
        try {
            this.checkBuildCanceled(true);
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(this.fLintingEnabled);
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            this.updateSyntaxErrors();
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS, IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS}, false, false);
            if (fullChecksKind != FullChecksKind.OFF) {
                Collection<RfLibrary> libraries = this.getLibraries();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                this.checkForDuplicates(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                this.checkUnused(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, true, disableRTLChecks);
            }
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS;
            this.checkEnryptedPragmas();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
            this.checkCustomPragmas(this.fRfCompiledFiles.fCompiledFiles);
            Utils.refreshMarkers(this);
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, false, false);
            if (this.fXvmFactory != null) {
                this.fXvmFactory.deepClean();
                this.fXvmFactory = null;
            }
            this.accept((RfNamedElement namedElement) -> {
                if (namedElement.isPredefined()) {
                    return false;
                }
                if (namedElement instanceof RfDuplicate) {
                    return true;
                }
                if (namedElement instanceof RfClass) {
                    ((RfClass)namedElement).getDefaultSpecialization(null);
                }
                return true;
            });
            if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                for (Map.Entry<ParserPath, DVTEditor> entry : this.fParserPathToEditorMap.entrySet()) {
                    Utils.getInstance().updateEditors(this.getFileDefUsingParserPath(entry.getKey()), entry.getValue());
                }
            }
            this.updateBreadcrumbs();
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeMixedLangProject() {
        IProject project = this.fProject;
        VlogModelManager.getInstance().saveUnfinishedJobs(project);
        this.clean();
        this.fProjectState = RfProjectState.NEW;
        VlogModelManager.getInstance().cbClean(project);
    }

    public void setSyntacticErrorsMap(Map<ParserPath, Set<VlogProblem>> errorsMap) {
        this.fSyntacticErrorsMap = errorsMap;
    }

    public Map<ParserPath, Set<VlogProblem>> getSyntacticErrorsMap() {
        return this.fSyntacticErrorsMap;
    }

    public void setSyntacticWarningsMap(Map<ParserPath, Set<VlogProblem>> warningsMap) {
        this.fSyntacticWarningsMap = warningsMap;
    }

    public Map<ParserPath, Set<VlogProblem>> getSyntacticWarningsMap() {
        return this.fSyntacticWarningsMap;
    }

    public List<VlogProblem> getNonStandardSyntacticIssues() {
        ArrayList<VlogProblem> result = new ArrayList<VlogProblem>();
        List<VlogProblem> issues = this.getNonStandardSyntacticIssues(this.fSyntacticErrorsMap);
        if (issues != null) {
            result.addAll(issues);
        }
        if ((issues = this.getNonStandardSyntacticIssues(this.fSyntacticWarningsMap)) != null) {
            result.addAll(issues);
        }
        return result;
    }

    public Collection<RfSemanticError> getNonStandardSemanticIssues() {
        ArrayList<RfSemanticError> result = new ArrayList<RfSemanticError>();
        IRfSingleLangProject.SemanticErrorsCategory[] semanticErrorsCategoryArray = IRfSingleLangProject.SemanticErrorsCategory.values();
        int n = semanticErrorsCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRfSingleLangProject.SemanticErrorsCategory category = semanticErrorsCategoryArray[n2];
            Collection<RfSemanticError> issues = this.getNonStandardSemanticIssues(this.fSemanticErrors.get(category));
            if (issues != null) {
                result.addAll(issues);
            }
            ++n2;
        }
        return result;
    }

    private Collection<RfSemanticError> getNonStandardSemanticIssues(Map<String, SemanticErrorsTable.ErrorsAndWarnings> errorsAndWarningsPerCategory) {
        if (errorsAndWarningsPerCategory == null || errorsAndWarningsPerCategory.isEmpty()) {
            return null;
        }
        ArrayList<RfSemanticError> result = new ArrayList<RfSemanticError>();
        for (SemanticErrorsTable.ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
            if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
            for (Set set : errorsAndWarnings.errorsMap.values()) {
                if (set == null || set.isEmpty()) continue;
                for (RfSemanticError error : set) {
                    if (!error.getMessage(false).startsWith("NON_STANDARD_")) continue;
                    result.add(error);
                }
            }
            for (Set set : errorsAndWarnings.warningsMap.values()) {
                if (set == null || set.isEmpty()) continue;
                for (RfSemanticError error : set) {
                    if (!error.getMessage(false).startsWith("NON_STANDARD_")) continue;
                    result.add(error);
                }
            }
        }
        return result;
    }

    private List<VlogProblem> getNonStandardSyntacticIssues(Map<ParserPath, Set<VlogProblem>> issuesMap) {
        if (issuesMap == null) {
            return null;
        }
        ArrayList<VlogProblem> result = new ArrayList<VlogProblem>();
        for (Set<VlogProblem> issues : issuesMap.values()) {
            for (VlogProblem issue : issues) {
                if (!issue.getMessage(false).startsWith("NON_STANDARD_")) continue;
                result.add(issue);
            }
        }
        return result;
    }

    public void clean() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount5.set(0);
        }
        this.orderAnalysisScope = null;
        this.fBuildPending = true;
        this.fOverridedHidHolder = new ArrayDeque<IHidHolder>();
        this.fIncrementalBuild = false;
        this.fIncrementalDeltaContainer = null;
        this.fEncryptedCodeAutoFilter = null;
        if (this.fChangedFilesManager != null) {
            this.fChangedFilesManager.clear();
        }
        this.fChangedFilesManager = null;
        if (this.fNamedElementsWithEncryptedDefSet != null) {
            this.fNamedElementsWithEncryptedDefSet.clear();
        }
        this.fNamedElementsWithEncryptedDefSet = null;
        this.setSwitchLibraryListener(null);
        this.cfgDefaultLibraryDecl("work");
        this.fCurrentFileDef = null;
        this.deepClean();
        if (this.fXvmFactory != null) {
            this.fXvmFactory.deepClean();
            this.fXvmFactory = null;
        }
        this.fBuildScope.clean();
        this.fSyntacticErrorsMap = null;
        this.fSyntacticWarningsMap = null;
        this.setDisabledChecks(this.fLintingEnabled);
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
        this.cleanSemanticErrors();
        this.lintClean();
        if (this.fPowerFormatModel != null) {
            this.fPowerFormatModel.clear();
            this.fPowerFormatModel = null;
        }
        PREDEFINED_GLOBAL.cleanUserDefinedSystemMethods();
        this.fRfProjectContent.fInvocationIndicesByPath = new HashMap<ParserPath, Set<Integer>>();
        if (this.fRfProjectContent.fModulesNamesByLibrary != null) {
            for (Map.Entry<String, TreeMap<String, TreeSet<String>>> entry : this.fRfProjectContent.fModulesNamesByLibrary.entrySet()) {
                Map modulesByFile = entry.getValue();
                modulesByFile.values().clear();
                modulesByFile.clear();
            }
            this.fRfProjectContent.fModulesNamesByLibrary.clear();
        }
        this.fRfProjectContent.fModulesNamesByLibrary = null;
        this.fMixedLangProjectParent.cleanElaborationManagers();
        ReparseInfo.ReparseElement.clearCache();
        PrecompiledDBUtils.clearPrecompiledFilesCache((IProject)this.getProject());
        PrecompiledDBUtils.clearPrecompiledSrcMapCache((IProject)this.getProject());
    }

    public void resetSemanticScopeStack() {
        while (!this.fBuildScope.isEmpty()) {
            this.fBuildScope.popSemanticScope();
        }
    }

    public void pushScope(RfDefElement elemDef, RfNamedElement namedElem) {
        this.pushScope(elemDef, namedElem, false);
    }

    public void pushScope(RfDefElement elemDef, RfNamedElement namedElem, boolean isGeneratesNewScope) {
        this.fBuildScope.pushSemanticScope(namedElem);
        if (isGeneratesNewScope) {
            this.fBuildScope.pushGenerateConstructIndex();
        }
        RfDefElement addedElem = elemDef;
        if (!this.fCurrentFileDef.stackContains(elemDef)) {
            addedElem = this.fCurrentFileDef.addChildDef(elemDef);
        }
        this.fCurrentFileDef.pushPhysicalScope(addedElem);
    }

    private void popScope(RfDefElement elemDef, RfNamedElement namedElem) {
        if (this.getCountDuplicateScopes() > 0) {
            this.decreaseDuplicateScope(namedElem);
        }
        this.fCurrentFileDef = elemDef.getDefFile();
        RfProject.popScope(this.fCurrentFileDef, this.fBuildScope, namedElem);
    }

    private void popScope(IDVTFileInstance fileInstance, RfNamedElement namedElem) {
        this.popScope(fileInstance, namedElem, false);
    }

    private void popScope(IDVTFileInstance fileInstance, RfNamedElement namedElem, boolean isGeneratesNewScope) {
        if (this.getCountDuplicateScopes() > 0) {
            this.decreaseDuplicateScope(namedElem);
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        if (isGeneratesNewScope) {
            this.fBuildScope.popGenerateConstructIndex();
        }
        RfProject.popScope(this.fCurrentFileDef, this.fBuildScope, namedElem);
    }

    private static void popScope(RfFileDef currentFileDef, BuildScope buildScope, RfNamedElement namedElem) {
        RfNamedElement candidate = buildScope.peekSemanticScope();
        if (candidate == namedElem) {
            buildScope.popSemanticScope();
            currentFileDef.popPhysicalScope();
        } else if (buildScope.fSemanticScopes.contains(namedElem)) {
            do {
                candidate = buildScope.popSemanticScope();
                currentFileDef.popPhysicalScope();
            } while (candidate != namedElem && !currentFileDef.physicalScopeIsEmpty() && !buildScope.isEmpty());
        }
    }

    public void remove(IVlogModule vlogFile) {
        ParserPath parserPath = vlogFile.getParserPath();
        this.removeFile(parserPath);
    }

    private void cleanSemanticErrors() {
        this.fSemanticErrors = new SemanticErrorsTable();
        Utils.getInstance().cleanSemanticMarkers(this.fProject);
    }

    public RfProjectContent precompiledDbLoad(Invocation invocation, PrecompiledDbStats stats, String subFolder) throws PersistenceBase.PrecompiledDbLoadFailException {
        String precompiledDbPath;
        this.checkBuildCanceled(true);
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fProject);
        BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper = null;
        persistenceModeWrapper = precompiledDbMode.isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD}) && !BuildConfigManager.isPrecompiledDbLoadInvocation((Invocation)invocation) ? BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbLoad((Invocation)invocation, (String)invocation.getPrecompiledLibName()) : BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbLoad((Invocation)invocation, (String)subFolder);
        stats.dbLocation = precompiledDbPath = BuildConfigManager.getModelPersistenceLocation((IProject)this.fProject, (String)"", (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)persistenceModeWrapper);
        this.consolePrint(DVTStringUtil.appendString((Object[])new Object[]{"Loading precompiled database ", precompiledDbPath, " ..."}), false);
        long time = System.currentTimeMillis();
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        persistence.preRestore(this, persistenceModeWrapper);
        persistence.restore(this, this.fBuildProgressMonitor, null, persistenceModeWrapper);
        PropertiesManager.addSessionProperty((IResource)BuildConfigManager.getActiveBuildConfigIFile((IProject)this.fProject), (String)PropertyTypes.QN_IMPORTED_FILE, (String)"ro.amiq.dvt.ui.editor.BuildConfigEditor");
        stats.persistenceTime = System.currentTimeMillis() - time;
        return (RfProjectContent)this.getRfProjectContent();
    }

    public void precompiledDbSave(boolean reportToConsole) {
        ActiveBuildConfig activeBuildConfig = BuildConfigManager.getActiveBuildConfig((IProject)this.fProject);
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbSaveMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fProject);
        long startTime = System.currentTimeMillis();
        AtomicBoolean librariesWriting = new AtomicBoolean(true);
        try {
            try {
                if (precompiledDbSaveMode == BuildConfigManagerCommon.PrecompileGlobalMode.MANUAL_SAVE) {
                    String location = BuildConfigManager.getPrecompiledDbSaveLocation((IProject)this.fProject);
                    if (reportToConsole) {
                        this.consolePrint("Precompiled database save in " + location, false);
                    }
                    VlogPrecompiledDBUtils.savePrecompiledManualLibrary(this, persistence, activeBuildConfig, new PrecompiledDbStats(location));
                    if (reportToConsole) {
                        this.consolePrint("Precompiled database save after [" + (System.currentTimeMillis() - startTime) + " ms]", false);
                    }
                } else if (precompiledDbSaveMode.isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE})) {
                    PersistenceUtils.reportSavingProject((IProject)this.fProject, (AtomicBoolean)librariesWriting);
                    String precompiledDbLocation = BuildConfigManager.getModelPersistenceLocation((IProject)this.fProject, (String)"", (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave());
                    PrecompiledAutoDebugUtils.INSTANCE.setEnabled(BuildConfigManager.isPrecompiledDbDebugMode((IProject)this.fProject).booleanValue());
                    PrecompiledAutoDebugUtils.INSTANCE.initDebugging(precompiledDbLocation);
                    Set<String> excludedLibraries = VlogPrecompiledDBUtils.checkWhichLibrariesAreExcludedByPathFullBuild(this);
                    for (RfLibrary library : this.getLibraries()) {
                        String libName = library.getName();
                        long libSaveStartTime = System.currentTimeMillis();
                        if (libName.equals(PREDEFINED_STD_LIBRARY_NAME)) continue;
                        if (!librariesWriting.get()) {
                            throw new BuildCancelException();
                        }
                        java.nio.file.Path libraryLocation = Paths.get(precompiledDbLocation, libName);
                        Files.createDirectories(libraryLocation, new FileAttribute[0]);
                        PrecompiledDbStats stats = new PrecompiledDbStats();
                        stats.dbLocation = libraryLocation.toString();
                        if (reportToConsole) {
                            if (precompiledDbSaveMode == BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE) {
                                this.consolePrint("Auto precompiled database save in " + libraryLocation.toString(), false);
                            } else if (precompiledDbSaveMode == BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE) {
                                this.consolePrint("Precompiled database save for " + libName, false);
                            }
                        }
                        if (excludedLibraries.contains(libName)) {
                            VlogPrecompiledDBUtils.savePrecompiledAutoLibraryExcludedByPath(libName, this);
                        } else if (precompiledDbSaveMode == BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE) {
                            VlogPrecompiledDBUtils.savePrecompiledAutoLibrary(libName, this, persistence, activeBuildConfig, stats);
                        } else if (precompiledDbSaveMode == BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE) {
                            VlogPrecompiledDBUtils.savePrecompiledLibrary(libName, this, persistence, activeBuildConfig, VlogPrecompiledDBUtils.CopyType.FILTER, 1, true, true, stats);
                        }
                        persistence.setDirty();
                        stats.totalLibTime = System.currentTimeMillis() - libSaveStartTime;
                        if (!reportToConsole) continue;
                        this.consolePrint("Precompiled database save after [" + stats.totalLibTime + " ms]. CopyReflection time was [" + stats.copyReflectionTime + " ms]", false);
                    }
                    if (!BuildConfigManagerCommon.saveBuildConfig((ActiveBuildConfig)BuildConfigManagerCommon.getBuildConfig((IProject)this.fProject), (Path)((Path)Path.fromPortableString((String)precompiledDbLocation)))) {
                        DVTLogger.INSTANCE.logError("Error: Failed to serialize Build Config for precompile auto.");
                    }
                    if (reportToConsole) {
                        this.consolePrint("Total precompiled database save time [" + (System.currentTimeMillis() - startTime) + " ms]", false);
                    }
                }
                if (reportToConsole) {
                    PersistenceUtils.reportSavedProject();
                }
            }
            catch (BuildCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                librariesWriting.set(false);
                PrecompiledAutoDebugUtils.INSTANCE.setEnabled(false);
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            }
        }
        finally {
            librariesWriting.set(false);
            PrecompiledAutoDebugUtils.INSTANCE.setEnabled(false);
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
        }
    }

    public void postFullBuild(boolean reportToConsole) {
        try {
            if (reportToConsole) {
                this.consolePrint("Performing post full build actions ...", false);
            }
            this.fCurrentFileDef = null;
            this.fGUIUtils.resetTimer();
            int nofCheck = 1;
            String reportPrefix = "Performing post full build step ";
            this.checkBuildCanceled();
            this.computeAutoConfiguredParserPaths();
            EncryptedCodeAutoFilter encryptedCodeAutoDefineFilter = this.getEncryptedCodeAutoFilter();
            if (encryptedCodeAutoDefineFilter != null) {
                encryptedCodeAutoDefineFilter.clear();
            }
            if (encryptedCodeAutoDefineFilter != null && encryptedCodeAutoDefineFilter.hasEnabledEncryptedCodeAuto()) {
                this.computeNamedElementsWithEncryptedDefBuildPhase();
            }
            this.fTime = System.currentTimeMillis();
            this.removeAllCommentsTables();
            this.setScopeForRemainingInstances();
            if (reportToConsole) {
                this.consolePrint(String.valueOf(reportPrefix) + nofCheck++ + " (SRI) [" + (System.currentTimeMillis() - this.fTime) + " ms] ...", true);
            }
            this.fTime = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
            this.fSemanticErrors.clearFiles(this.fSemanticErrorCategory, this, null);
            this.resolveImports(false, true, false, false);
            if (reportToConsole) {
                this.consolePrint(String.valueOf(reportPrefix) + nofCheck++ + " (RI) [" + (System.currentTimeMillis() - this.fTime) + " ms] ...", true);
            }
            this.fTime = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS;
            this.fSemanticErrors.clearFiles(this.fSemanticErrorCategory, this, null);
            this.resolveClassParents(this);
            if (reportToConsole) {
                this.consolePrint(String.valueOf(reportPrefix) + nofCheck++ + " (RCP) [" + (System.currentTimeMillis() - this.fTime) + " ms] ...", true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void consolePrint(String message, boolean isReport) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message, isReport ? DVTBuildConsoleCommon.MessageSink.REPORT : DVTBuildConsoleCommon.MessageSink.CONSOLE);
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
    }

    @Deprecated
    protected boolean isSemanticErrorCheck() {
        return true;
    }

    @Deprecated
    protected boolean isSemanticWarningCheck() {
        return true;
    }

    private void setScopeForRemainingInstances() {
        try {
            VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
            VlogFileInstance topInstance = preprocessing.getTopFileInstance();
            List<VlogFileInstance> allInstances = this.getRecursiveFileInstances(topInstance.getIncludedInstances());
            if (allInstances == null) {
                return;
            }
            allInstances.add(0, topInstance);
            for (VlogFileInstance fileInstance : allInstances) {
                RfDefElement includeScopeDef;
                RfFileDef includeFileDef;
                VlogFileInstance includeInstance;
                VlogIncludingScope includeScope;
                ParserPath parserPath = fileInstance.getParserPath();
                if (parserPath == null) continue;
                RfFileDef fileDefinition = this.getFileDefUsingParserPath(parserPath);
                if (fileDefinition == null) {
                    fileDefinition = new RfFileDef(fileInstance.getShortFileName(), fileInstance.getIndex(), parserPath, fileInstance.getUndeclaredElements() != null, this);
                    this.fRfProjectContent.fParserPath2FileDefMap.put((ParserPath)parserPath.toCanonical(), fileDefinition);
                }
                if (fileInstance.getSemanticScope() != null || (includeScope = fileInstance.getIncludingScope()) == null || (includeInstance = includeScope.getIncludingInstance()) == null || (includeFileDef = this.getFileDefUsingParserPath(parserPath = includeInstance.getParserPath())) == null || (includeScopeDef = includeFileDef.getScope(includeScope.getIncludingOffset(), false, null)) == null) continue;
                RfNamedElement scope = includeScopeDef.getNamedElement();
                parserPath = fileInstance.getParserPath();
                if (scope == null) {
                    scope = this.getOrCreateLibrary(this.getLibraryNameForFile(fileInstance));
                    fileInstance.setSemanticScope(scope);
                    fileDefinition.addNamedElement(scope);
                    continue;
                }
                if (scope instanceof RfProject && includeInstance.getSemanticScope() != null) {
                    scope = includeInstance.getSemanticScope();
                    fileInstance.setSemanticScope(scope);
                    fileDefinition.addNamedElement(scope);
                    continue;
                }
                fileInstance.setSemanticScope(scope);
                fileDefinition.addNamedElement(scope);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<VlogFileInstance> getRecursiveFileInstances(List<VlogFileInstance> topFilesInstances) {
        if (topFilesInstances == null) {
            return null;
        }
        NullProtectedList<VlogFileInstance> result = new NullProtectedList<VlogFileInstance>();
        result.addAll(topFilesInstances);
        for (VlogFileInstance instance : topFilesInstances) {
            result.addAll(this.getRecursiveFileInstances(instance.getIncludedInstances()));
        }
        return result;
    }

    public IncrementalDeltaContainer getIncrementalDeltaContainer() {
        return this.fIncrementalDeltaContainer;
    }

    public void cleanIncrementalDeltaContainer() {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fIncrementalDeltaContainer.clear();
        this.fIncrementalDeltaContainer = null;
    }

    public void collectIncrementalChangedPackages(Map<LanguageKind, List<IRfPackageElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectChangedPackages(collected.get(LanguageKind.VLOG));
    }

    public void collectIncrementalChangedNonDesignElements(Map<LanguageKind, Set<IRfNamedElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectChangedNonDesignElements(collected.get(LanguageKind.VLOG));
    }

    public void collectIncrementalDeltaInstances(Map<LanguageKind, List<IRfInstanceElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectDeltaInstances(collected.get(LanguageKind.VLOG));
    }

    public void collectIncrementalDeltaDesigns(Map<LanguageKind, List<IRfDesignElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectDeltaDesigns(collected.get(LanguageKind.VLOG));
    }

    public void collectIncrementalDeltaBlocks(Map<LanguageKind, List<IRfDesignElement>> collected) {
    }

    public boolean hasIncrementalStructuralDesignChanges() {
        return this.fIncrementalDeltaContainer != null && this.fIncrementalDeltaContainer.hasStructuralDesignChanges();
    }

    public boolean hasIncrementalRemovedDescriptions() {
        return this.fIncrementalDeltaContainer != null && this.fIncrementalDeltaContainer.hasRemovedDescriptions();
    }

    public void cleanIncremental(ParserPath parserPath) {
        try {
            this.orderAnalysisScope = null;
            this.fBuildPending = true;
            if (this.fIncrementalDeltaContainer == null) {
                this.fIncrementalDeltaContainer = new IncrementalDeltaContainer();
            }
            this.fIncrementalDeltaContainer.addChangedParserPath(parserPath, false);
            this.cleanFile(parserPath, this.fIncrementalDeltaContainer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void incrementalBuild(VlogFileInfo info) {
        try {
            this.fIncrementalBuild = true;
            if (this.fIncrementalDeltaContainer == null) {
                this.fIncrementalDeltaContainer = new IncrementalDeltaContainer();
            }
            ParserPath parserPath = info.getParserPath();
            this.fIncrementalDeltaContainer.addChangedParserPath(parserPath, false);
            IDVTFileInstance fileInstance = info.getFileInstance();
            if (fileInstance != null) {
                if (!this.isCompiled(parserPath)) {
                    this.createNonTopLibrary(parserPath);
                }
                this.fCurrentFileDef = this.getFileDefinition((VlogFileInstance)fileInstance, true);
                this.fCurrentLibraryName = this.getName(this.fCurrentFileDef.getEnclosingLibrary());
                RfNamedElement semanticScope = ((VlogFileInstance)fileInstance).getSemanticScope();
                this.fCurrentPackageName = this.getName(semanticScope == null ? null : semanticScope.getEnclosingPackage());
                if (this.fBuildScope != null && (semanticScope instanceof RfInstanceHolder || semanticScope instanceof RfGenerateBlock)) {
                    this.fBuildScope.pushGenerateConstructIndex();
                }
                this.removeInstanceCommentsTable((VlogFileInstance)fileInstance);
                ((VlogFileInstance)fileInstance).setIsIncrementalCompiled();
                if (PrecompiledDBUtils.isAutoPrecompiledFile((IProject)this.fProject, (ParserPath)parserPath)) {
                    PrecompiledDBUtils.removeFromPrecompiledFilesCache((IProject)this.fProject, (String)parserPath.path);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    private void createNonTopLibrary(ParserPath parserPath) {
        if (this.fRfProjectContent.fFileToLibraryExplicitMapping == null) {
            this.fRfProjectContent.fFileToLibraryExplicitMapping = new LinkedHashMap<String, String>();
        }
        this.fRfProjectContent.fFileToLibraryExplicitMapping.put(parserPath.path, TEMP_LIBRARY_NAME);
        this.startLibrary(TEMP_LIBRARY_NAME, false);
    }

    public String getName(RfNamedElement element) {
        if (element == null) {
            return null;
        }
        return element.getName();
    }

    public void postMixedLangFullBuildPreElab(FullChecksAndLibs fullCompileChecks, boolean reportToConsole) {
        try {
            long time = 0L;
            this.checkBuildCanceled(true);
            if (BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fProject)) {
                return;
            }
            this.setUserDefinedSystemTasks();
            DVTThreadDumpCollectorAttributes profilingAttributes = BuildConfigManager.getProfilingAttributes((IProject)this.getProject());
            if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RI)) {
                DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RI), (String)"Start (VLOG - RI) build stage...");
            }
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
            this.resolveImports(true, false, true, false);
            if (reportToConsole) {
                this.consolePrint("Performing mixed post full build step (VLOG - RI) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
            }
            if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RI)) {
                DVTThreadDumpCollector.pause((String)"Finish (VLOG - RI) build stage...");
            }
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangFullBuildPostElab(FullChecksAndLibs fullCompileChecks, final boolean reportToConsole) {
        try {
            try {
                boolean precompiledDbSaveMode = BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fProject);
                long time = 0L;
                this.checkBuildCanceled(true);
                if (!precompiledDbSaveMode) {
                    FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(this.fLintingEnabled);
                    Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
                    DVTThreadDumpCollectorAttributes profilingAttributes = BuildConfigManager.getProfilingAttributes((IProject)this.getProject());
                    Collection<RfLibrary> libraries = this.getLibraries();
                    this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS, IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS}, true, reportToConsole);
                    if (fullChecksKind != FullChecksKind.OFF) {
                        EncryptedCodeAutoFilter encryptedCodeAutoDefineFilter;
                        boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
                        if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RD)) {
                            DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RD), (String)"Start (VLOG - RD) build stage...");
                        }
                        time = System.currentTimeMillis();
                        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                        this.checkForDuplicates(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                        if (reportToConsole) {
                            this.consolePrint("Performing mixed post full build step (VLOG - RD) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                        }
                        if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_RD)) {
                            DVTThreadDumpCollector.pause((String)"Finish (VLOG - RD) build stage...");
                        }
                        if ((encryptedCodeAutoDefineFilter = this.getEncryptedCodeAutoFilter()) != null && encryptedCodeAutoDefineFilter.hasEnabledEncryptedCodeAuto()) {
                            RfEncryptedCodeAutoManager.autoDefineAPIInsideEncryptedCode(this, encryptedCodeAutoDefineFilter);
                        }
                        if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_US)) {
                            DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_US), (String)"Start (VLOG - US) build stage...");
                        }
                        time = System.currentTimeMillis();
                        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                        this.checkUnused(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, true, disableRTLChecks);
                        if (reportToConsole) {
                            this.consolePrint("Performing mixed post full build step (VLOG - US) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                        }
                        if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_US)) {
                            DVTThreadDumpCollector.pause((String)"Finish (VLOG - US) build stage...");
                        }
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_EP)) {
                        DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_EP), (String)"Start (VLOG - EP) build stage...");
                    }
                    time = System.currentTimeMillis();
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS;
                    boolean shouldReportTime = this.checkEnryptedPragmas();
                    if (reportToConsole & shouldReportTime) {
                        this.consolePrint("Performing mixed post full build step (VLOG - EP) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_EP)) {
                        DVTThreadDumpCollector.pause((String)"Finish (VLOG - EP) build stage...");
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_CP)) {
                        DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_CP), (String)"Start (VLOG - CP) build stage...");
                    }
                    time = System.currentTimeMillis();
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
                    shouldReportTime = this.checkCustomPragmas(this.getRfCompiledFiles().fCompiledFiles);
                    if (shouldReportTime & reportToConsole) {
                        this.consolePrint("Performing mixed post full build step (VLOG - CP) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VLOG_CP)) {
                        DVTThreadDumpCollector.pause((String)"Finish (VLOG - CP) build stage...");
                    }
                    this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, true, reportToConsole);
                }
                if (this.fBuildProgressMonitor == null || !this.fBuildProgressMonitor.isCanceled()) {
                    FNotificationFactory.INSTANCE.createPrecompiledFloatingNotification(this.getProject());
                    if (precompiledDbSaveMode) {
                        IBuildDoneListener listener = new IBuildDoneListener(){

                            public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                                DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this);
                                if (SplitInvocationUtils.shouldGenerateSplitBuildConfiguration((IProject)RfProject.this.fProject)) {
                                    return;
                                }
                                RfProject.this.precompiledDbSave(reportToConsole);
                                if (BuildConfigManager.needsPrecompiledLoadAutoTrigger((IProject)RfProject.this.fProject)) {
                                    PrecompiledDBUtils.setWasBuildTriggeredAutomatically((boolean)true);
                                    RfProject.this.consolePrint("\n----------------------------------------------------------------------------\n", false);
                                    Utils.getInstance().runOnDisplayThread(() -> DVTBuildUtils.buildWithProgressDialog((IProject)RfProject.this.fProject));
                                }
                            }
                        };
                        DVTMixedLangModelManager.getInstance().addBuildDoneListener(listener);
                    } else {
                        PrecompiledDBUtils.setWasBuildTriggeredAutomatically((boolean)false);
                        Utils.getInstance().saveRFDM(this, false, true, false);
                    }
                }
                this.printEncryptedCodeSummary();
                this.accept((RfNamedElement namedElement) -> {
                    if (namedElement.isPredefined()) {
                        return false;
                    }
                    if (namedElement instanceof RfDuplicate) {
                        return true;
                    }
                    if (namedElement instanceof RfClass) {
                        ((RfClass)namedElement).getDefaultSpecialization(null);
                    }
                    return true;
                });
                PreprocUtils.getInstance().printPreprocSummary(this.fProject);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    for (Map.Entry<ParserPath, DVTEditor> entry : this.fParserPathToEditorMap.entrySet()) {
                        Utils.getInstance().updateEditors(this.getFileDefUsingParserPath(entry.getKey()), entry.getValue());
                    }
                }
                VlogR2LCache.getInstance().removePathEntries(this.fRfCompiledFiles.fCompiledFiles);
                this.updateBreadcrumbs();
            }
            catch (BuildCancelException buildCancelException) {
                this.fBuildPending = false;
                if (this.fXvmFactory != null) {
                    this.fXvmFactory.deepClean();
                    this.fXvmFactory = null;
                }
                Utils.getInstance().connectActiveOpenEditor(this);
                DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fBuildPending = false;
                if (this.fXvmFactory != null) {
                    this.fXvmFactory.deepClean();
                    this.fXvmFactory = null;
                }
                Utils.getInstance().connectActiveOpenEditor(this);
                DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
        }
        finally {
            this.fBuildPending = false;
            if (this.fXvmFactory != null) {
                this.fXvmFactory.deepClean();
                this.fXvmFactory = null;
            }
            Utils.getInstance().connectActiveOpenEditor(this);
            DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
            this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        }
    }

    private void printEncryptedCodeSummary() {
        EncryptedCodeAutoFilter encryptedCodeAutoApiFilter = BuildConfigManager.getEncryptedCodeAutoDefineFilter((IProject)this.fProject);
        EncryptedCodeAutoDefineByNameFilter encryptedCodeAutoMacro = BuildConfigManager.getEncryptedCodeAutoDefineByNameFilter((IProject)this.fProject);
        EncryptedCodeAutoFilter encryptedCodeAutoCloseFilter = BuildConfigManager.getEncryptedCodeAutoCloseFilter((IProject)this.fProject);
        if (!(encryptedCodeAutoApiFilter.hasEnabledEncryptedCodeAuto() || encryptedCodeAutoCloseFilter.hasEnabledEncryptedCodeAuto() || encryptedCodeAutoMacro.hasEnabledEncryptedCodeAuto())) {
            return;
        }
        if (encryptedCodeAutoApiFilter.isDebug()) {
            return;
        }
        IVlogModel vlogModel = VlogModelManager.getInstance().getVlogModel();
        if (vlogModel == null) {
            return;
        }
        long nOfEncryptedFiles = 0L;
        Set<IResource> compiledFiles = this.getCompiledFileResourcesSet();
        if (compiledFiles == null || compiledFiles.isEmpty()) {
            return;
        }
        for (IResource file : compiledFiles) {
            IVlogModule vlogModule;
            if (!(file instanceof IFile) || (vlogModule = vlogModel.getOrCreateVlogModule((IFile)file)) == null || !vlogModule.isEncrypted()) continue;
            ++nOfEncryptedFiles;
        }
        if (nOfEncryptedFiles == 0L) {
            return;
        }
        IProject project = this.getProject();
        DVTBuildConsoleRegistry.getConsole((IProject)project).printSection("Encrypted code summary", DVTBuildConsoleCommon.MessageSink.REPORT);
        StringBuilder encryptedInfo = new StringBuilder();
        encryptedInfo.append("Number of encrypted files: " + nOfEncryptedFiles + "\n");
        if (encryptedCodeAutoCloseFilter.hasEnabledEncryptedCodeAuto()) {
            encryptedInfo.append("Auto-closed scopes: " + encryptedCodeAutoCloseFilter.getNOfClosedScopes() + "\n");
        }
        if (encryptedCodeAutoMacro.hasEnabledEncryptedCodeAuto()) {
            encryptedInfo.append("Auto-defined macros: " + encryptedCodeAutoMacro.getNofDefinedMacros() + "\n");
        }
        if (encryptedCodeAutoApiFilter.hasEnabledEncryptedCodeAuto()) {
            encryptedInfo.append("Auto-defined fields: " + encryptedCodeAutoApiFilter.getNofFields() + "\n");
            encryptedInfo.append("Auto-defined functions: " + encryptedCodeAutoApiFilter.getNofFunctions() + "\n");
            encryptedInfo.append("Auto-defined arguments: " + encryptedCodeAutoApiFilter.getNofArguments() + "\n");
            encryptedInfo.append("Auto-defined constraints: " + encryptedCodeAutoApiFilter.getNofConstraints());
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(encryptedInfo.toString(), DVTBuildConsoleCommon.MessageSink.REPORT);
    }

    private void notifyIncrementalDeltaListeners() {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        RfMixedLangProject mixedLangProjectParent = this.getMixedLangProjectParent();
        this.fIncrementalDeltaContainer.notifyListeners(mixedLangProjectParent);
    }

    private void updateFNotificationTracker(Set<FileCompileInfo> changedFiles, FNotificationDirtyReason dirtyReason) {
        if (changedFiles == null) {
            return;
        }
        ELManager manager = this.getELManager();
        boolean dirtyElab = dirtyReason == FNotificationDirtyReason.ELABORATION && manager != null && manager.hasDirtyMemory();
        for (FileCompileInfo changedFile : changedFiles) {
            if (changedFile == null || !dirtyElab && dirtyReason != FNotificationDirtyReason.UNEXPECTED_EXCEPTION) continue;
            FIncrementalNotificationTracker.INSTANCE.addDirtyResource(this.fProject, (FNotificationDirtyResource)new FIncrementalDirtyFile(changedFile.getFile(), dirtyReason, (DVTFNotificationProvider)VlogFNotificationProvider.getInstance()));
        }
    }

    public void postIncrementalBuild(VlogFileInfo info) {
        try {
            this.fIncrementalBuild = true;
            this.fGUIUtils.resetTimer();
            ParserPath parserPath = info.getParserPath();
            this.fIncrementalDeltaContainer.addChangedParserPath(parserPath, false);
            String debugPrefix = "DEBUG VLOG: ";
            long time = 0L;
            time = System.currentTimeMillis();
            this.fIncrementalDeltaContainer.removeDirtyElements(parserPath, this);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Remove Dirty Elements [" + (System.currentTimeMillis() - time) + " ms]");
            if (this.fIncrementalDeltaContainer.currentFileScopes != null && !this.fIncrementalDeltaContainer.currentFileScopes.isEmpty()) {
                for (RfNamedElement currentFileEnclosingScope : this.fIncrementalDeltaContainer.currentFileScopes) {
                    Collection defs = currentFileEnclosingScope.getDeclarations();
                    if (defs == null || defs.isEmpty()) continue;
                    for (RfDefElement def : defs) {
                        this.resolveLocalImplicitGenerateBlocksInElement(def, currentFileEnclosingScope);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postIncrementalBuild(Set<FileCompileInfo> changedFiles) {
        try {
            if (changedFiles == null || changedFiles.isEmpty() || this.fIncrementalDeltaContainer == null) {
                return;
            }
            if (BuildConfigManager.isPrintDebugDeltaInfo((IProject)this.fProject)) {
                DVTLogger.INSTANCE.logInfo(this.fIncrementalDeltaContainer.toString());
            }
            String debugPrefix = "DEBUG VLOG: ";
            long time = 0L;
            Utils.getInstance().cleanSemanticMarkers(this.fProject);
            if (ro.amiq.vlogdt.test.TestHelper.isTestMode()) {
                ro.amiq.vlogdt.test.TestHelper.fIncrementalDeltaContainer = new IncrementalDeltaContainer(this.fIncrementalDeltaContainer);
            }
            Set<ParserPath> parserPaths = this.fIncrementalDeltaContainer.getParserPaths();
            this.lintCleanOVMProject(parserPaths);
            if (this.fIncrementalDeltaContainer.deltaSpecializedClasses != null) {
                for (RfClass deltaSpecializedClass : this.fIncrementalDeltaContainer.deltaSpecializedClasses) {
                    deltaSpecializedClass.cleanSpecializations();
                }
            }
            this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS, this, parserPaths);
            this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS, this.fIncrementalDeltaContainer.delta);
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS;
            this.resolveImports(this.fIncrementalDeltaContainer, this, true, true, true);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Resolve Imports [" + (System.currentTimeMillis() - time) + " ms]");
            this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS, this, parserPaths);
            this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS, this.fIncrementalDeltaContainer.delta);
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS;
            this.resolveClassParents(this, this.fIncrementalDeltaContainer);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Resolve Class Parents [" + (System.currentTimeMillis() - time) + " ms]");
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_IMPORTS, IRfSingleLangProject.SemanticErrorsCategory.CLASS_PARENTS}, false, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangIncrementalBuildPreElab(Set<FileCompileInfo> changedFiles, Set<String> updateViewIds) {
        try {
            this.fIncrementalBuild = true;
            if (this.fIncrementalDeltaContainer == null) {
                updateViewIds.addAll(ViewsUtils.ALL_VIEWS);
            } else if (this.fIncrementalDeltaContainer.updateViewsIds != null && updateViewIds != null) {
                updateViewIds.addAll(this.fIncrementalDeltaContainer.updateViewsIds);
            }
            this.notifyIncrementalDeltaListeners();
            if (!this.fBuildPending) {
                Utils.getInstance().cleanSemanticMarkers(this.fProject);
                this.lintCleanOVMProject();
                this.updatedSemanticErrors(IRfSingleLangProject.SemanticErrorsCategory.values(), false, false);
                return;
            }
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangIncrementalBuildPostElab(Set<FileCompileInfo> changedFiles, Set<String> updateViewIds) {
        block24: {
            this.checkBuildCanceled(true);
            this.fIncrementalBuild = true;
            if (changedFiles != null && !changedFiles.isEmpty() && this.fIncrementalDeltaContainer != null) break block24;
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)this.fProject);
            if (verissimoChecks != null && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
                VerissimoAfterCompilationLauncher.getInstance().calculateAndSetModifiedFiles(this.fIncrementalDeltaContainer);
            }
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.getParserPaths());
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
            return;
        }
        try {
            Set<ParserPath> changedParserPathsForHighlight;
            String debugPrefix = "DEBUG VLOG: ";
            long time = 0L;
            Set<ParserPath> changedParserPaths = this.resource2parser(changedFiles);
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(this.isLintingEnabled());
            IncrementalChecksKind incrementalChecksKind = BuildConfigManager.getIncrementalCompileChecks((IProject)this.fProject, (boolean)this.isLintingEnabled());
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
            if (fullChecksKind != FullChecksKind.OFF && incrementalChecksKind != IncrementalChecksKind.OFF) {
                Set<ParserPath> parserPaths = this.fIncrementalDeltaContainer.getParserPaths();
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, this, parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                this.checkForDuplicates(this.fIncrementalDeltaContainer, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check Duplicates [" + (System.currentTimeMillis() - time) + " ms]");
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, this, parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                this.checkUnused(this.fIncrementalDeltaContainer, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, true, disableRTLChecks);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check unused signals [" + (System.currentTimeMillis() - time) + " ms]");
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS, this, parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS;
                this.checkEnryptedPragmas();
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check encrypt pragmas [" + (System.currentTimeMillis() - time) + " ms]");
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS, this, parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
                boolean shouldReportTime = this.checkCustomPragmas(changedParserPaths);
                if (shouldReportTime) {
                    DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check custom pragmas [" + (System.currentTimeMillis() - time) + " ms]");
                }
            } else {
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES);
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS);
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS);
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS);
            }
            if (this.fXvmFactory != null) {
                this.fXvmFactory.deepClean();
                this.fXvmFactory = null;
            }
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.ENCRYPT_PRAGMAS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, false, false);
            if (this.fBuildPending) {
                Utils.getInstance().saveRFDM(this, true, true, false);
            }
            if ((changedParserPathsForHighlight = this.getFilesForIncrementalHighlight()) != null && !changedParserPathsForHighlight.isEmpty() && this.fParserPathToEditorMap != null) {
                for (ParserPath parserPath : changedParserPathsForHighlight) {
                    this.reconnectPositions(parserPath, changedParserPaths == null || !changedParserPaths.contains(parserPath));
                    Utils.getInstance().updateEditors(this.getFileDefUsingParserPath(parserPath), this.fParserPathToEditorMap.get(parserPath));
                    this.reconnectPVlogPositions(parserPath);
                }
            }
            this.updateBreadcrumbs();
            this.updateFNotificationTracker(changedFiles, FNotificationDirtyReason.ELABORATION);
            VlogPrecompiledDBUtils.incrementalUpdateDatabasesExcludedByPath(this, this.fIncrementalDeltaContainer.getParserPaths());
        }
        catch (BuildCancelException buildCancelException) {
            VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)this.fProject);
            if (verissimoChecks != null && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
                VerissimoAfterCompilationLauncher.getInstance().calculateAndSetModifiedFiles(this.fIncrementalDeltaContainer);
            }
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.getParserPaths());
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
        }
        catch (Exception e) {
            try {
                this.updateFNotificationTracker(changedFiles, FNotificationDirtyReason.UNEXPECTED_EXCEPTION);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Throwable throwable) {
                VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)this.fProject);
                if (verissimoChecks != null && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
                    VerissimoAfterCompilationLauncher.getInstance().calculateAndSetModifiedFiles(this.fIncrementalDeltaContainer);
                }
                Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.getParserPaths());
                }
                this.fIncrementalBuild = false;
                this.fBuildPending = false;
                throw throwable;
            }
            VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)this.fProject);
            if (verissimoChecks != null && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
                VerissimoAfterCompilationLauncher.getInstance().calculateAndSetModifiedFiles(this.fIncrementalDeltaContainer);
            }
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.getParserPaths());
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
        }
        VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)this.fProject);
        if (verissimoChecks != null && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
            VerissimoAfterCompilationLauncher.getInstance().calculateAndSetModifiedFiles(this.fIncrementalDeltaContainer);
        }
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
        if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
            this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.getParserPaths());
        }
        this.fIncrementalBuild = false;
        this.fBuildPending = false;
    }

    private void reconnectPVlogPositions(ParserPath parserPath) {
        PreprocConstCommon.PreprocFileType fileType = PreprocUtils.getInstance().getPreprocFileType(this.getProject(), parserPath);
        if (fileType == null) {
            return;
        }
        String mappedFilePath = fileType.getMappedFilePath(this.fProject, parserPath.path);
        if (mappedFilePath == null) {
            return;
        }
        this.reconnectPositions(new ParserPath(mappedFilePath), true);
    }

    public void preElaborationSetup(boolean cleanMarkers, boolean isFullBuild) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ELABORATION;
        if (!cleanMarkers) {
            return;
        }
        if (!isFullBuild && this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, this, isFullBuild ? null : this.fIncrementalDeltaContainer.getParserPaths());
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, isFullBuild ? null : this.fIncrementalDeltaContainer.delta);
        this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, this, isFullBuild ? null : this.fIncrementalDeltaContainer.getParserPaths());
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, isFullBuild ? null : this.fIncrementalDeltaContainer.delta);
    }

    public void preElaborationIncrementalSetup(Map<ParserPath, Set<IRfNamedElement>> elaboratedElementsMap) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ELABORATION;
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, elaboratedElementsMap);
    }

    public void preUnelaborationSetup(boolean cleanMarkers, boolean isFullBuild, Map<ParserPath, Set<IRfNamedElement>> unelaboratedElementsMap) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS;
        if (!cleanMarkers) {
            return;
        }
        if (!isFullBuild && this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, unelaboratedElementsMap);
    }

    public void updateElaborationMarkers(boolean updateStatistics, boolean reportToConsole) {
        this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS}, updateStatistics, reportToConsole);
    }

    private void updateBreadcrumbs() {
        Job updateJob = new Job("Updating Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                List visibleEditors = ro.amiq.dvt.ui.Utils.computeVisibleEditors();
                for (IEditorPart editor : visibleEditors) {
                    if (!(editor instanceof DVTEditor)) continue;
                    Utils.getInstance().startUpdateBreadcrumbs((DVTEditor)editor);
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public Set<ParserPath> getFilesForIncrementalHighlight() {
        if (this.fIncrementalDeltaContainer == null) {
            return Collections.emptySet();
        }
        return this.fIncrementalDeltaContainer.getDeltaFilesParserPath(false).stream().map(deltaFileWrapper -> deltaFileWrapper.getParserPath()).collect(Collectors.toSet());
    }

    private void reconnectPositions(ParserPath parserPath, boolean connectOnlyVisualPositions) {
        if (this.fParserPathToEditorMap != null) {
            DVTEditor editor = this.fParserPathToEditorMap.get(parserPath);
            this.connectFileToDocument(parserPath, editor, connectOnlyVisualPositions, new HashMap<Position, Position>());
        }
    }

    private void updatedSemanticErrors(IRfSingleLangProject.SemanticErrorsCategory[] categories, boolean updateStatistics, boolean reportToConsole) {
        try {
            if (this.isSemanticErrorCheck() || this.isSemanticWarningCheck()) {
                ArrayList<RfSemanticError> semanticProblems = new ArrayList<RfSemanticError>();
                IRfSingleLangProject.SemanticErrorsCategory[] semanticErrorsCategoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    IRfSingleLangProject.SemanticErrorsCategory category = semanticErrorsCategoryArray[n2];
                    Map<String, SemanticErrorsTable.ErrorsAndWarnings> errorsAndWarningsPerCategory = this.fSemanticErrors.get(category);
                    for (SemanticErrorsTable.ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                        if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
                        for (Set set : errorsAndWarnings.errorsMap.values()) {
                            if (set == null || set.isEmpty()) continue;
                            semanticProblems.addAll(set);
                        }
                        for (Set set : errorsAndWarnings.warningsMap.values()) {
                            if (set == null || set.isEmpty()) continue;
                            semanticProblems.addAll(set);
                        }
                    }
                    ++n2;
                }
                Utils.getInstance().triggerSemanticMarkers(this, semanticProblems, reportToConsole);
            } else {
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
                DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            }
            if (updateStatistics) {
                this.updateDuration();
                this.updateMemoryAllocation();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateSyntaxErrors() {
        for (IResource file : this.getCompiledFileResourcesSet()) {
            if (!(file instanceof IFile)) continue;
            SyntaxErrorsManager.getInstance().updateProblemsUI((IFile)file, 1);
        }
    }

    public void activeTestChangedNotification() {
    }

    public void removeFile(ParserPath parserPath) {
        if (parserPath == null) {
            return;
        }
        RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath.toCanonical());
        if (file == null) {
            return;
        }
        file.cleanUpFile(null);
    }

    public void cleanFile(ParserPath parserPath, IncrementalDeltaContainer incrementalDeltaContainer) {
        if (parserPath != null) {
            this.lintPreIncremental(parserPath);
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            if (DVTLogger.INSTANCE.isDebugMode()) {
                fCount5.set(0);
            }
            fileDef.cleanUpFile(incrementalDeltaContainer);
        }
    }

    public void setIncrementalChangedImports(boolean incrementalChangedImports, String packageName, RfNamedElement scope) {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        List<RfNamedElement> importScopes = this.fIncrementalDeltaContainer.changedImportPackageNames.get(packageName);
        if (importScopes == null) {
            importScopes = new ArrayList<RfNamedElement>();
            this.fIncrementalDeltaContainer.changedImportPackageNames.put(packageName, importScopes);
        }
        importScopes.add(scope);
        this.fIncrementalDeltaContainer.changedImports |= incrementalChangedImports;
    }

    public boolean isInChangedImportScope(IRfNamedElement candidate) {
        RfPackage packageScope;
        if (this.fIncrementalDeltaContainer == null) {
            return false;
        }
        if (this.fIncrementalDeltaContainer.changedImportPackageNames.isEmpty()) {
            return false;
        }
        if (candidate == null || candidate instanceof RfAssociatedType.RfUnresolvedTypeInfo) {
            return false;
        }
        if (!(candidate instanceof RfNamedElement)) {
            return false;
        }
        if (candidate instanceof RfSpecializedClass) {
            candidate = ((RfSpecializedClass)candidate).getGenericClass();
        }
        if ((packageScope = (RfPackage)candidate.getEnclosingScope(RfPackage.class)) == null) {
            return false;
        }
        String packageName = packageScope.getName();
        return this.fIncrementalDeltaContainer.changedImportPackageNames.containsKey(packageName);
    }

    public void startWildcardImport(String packageName, int line, int offset, IDVTFileInstance fileInstance, boolean isImport, VlogMacroZone macroZone) {
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        this.fCurrentMacroZone = macroZone;
        if (this.getCountDuplicateScopes() > 0) {
            return;
        }
        RfNamedElement importScope = this.getDesignElementScope();
        boolean found = false;
        List<ImportInfo> wildcardImportExports = isImport ? importScope.getWildcardImports() : importScope.getWildcardExports();
        int invocNumber = ((VlogFileInstance)fileInstance).getInvocNumber();
        if (wildcardImportExports != null && !wildcardImportExports.isEmpty()) {
            for (ImportInfo importInfo : wildcardImportExports) {
                if (invocNumber != importInfo.getInvocNumber() || !importInfo.getPackageName().equals(packageName) || !importInfo.getParserPath().equals((Object)fileInstance.getParserPath()) || importInfo.getLine() != line || !this.fIncrementalBuild && macroZone != null && !macroZone.equals(importInfo.getMacroZone())) continue;
                found = true;
                importInfo.setDirtyCleanUpFlag(false);
                importInfo.setOffset(offset);
                importInfo.setLine(line);
                importInfo.setMacroZone(this.fCurrentMacroZone);
                break;
            }
        }
        if (!found) {
            ImportInfo importInfo;
            importInfo = new ImportInfo(packageName, line, offset, invocNumber, fileInstance.getParserPath());
            importInfo.setMacroZone(this.fCurrentMacroZone);
            if (isImport) {
                importScope.addWildcardImport(importInfo, this);
            } else {
                importScope.addWildcardExport(importInfo);
            }
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedImports = true;
                this.fIncrementalDeltaContainer.addedImportInfos.add(importInfo);
                this.setIncrementalChangedImports(true, packageName, importScope);
            }
        }
    }

    public void startExplicitImport(String packageName, String elementName, int line, int offset, IDVTFileInstance fileInstance, boolean isImport, VlogMacroZone macroZone) {
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        this.fCurrentMacroZone = macroZone;
        if (this.getCountDuplicateScopes() > 0) {
            return;
        }
        RfNamedElement importScope = this.getDesignElementScope();
        boolean found = false;
        List<ExplicitImportInfo> explicitImportExports = isImport ? importScope.getExplicitImports() : importScope.getExplicitExports();
        int invocNumber = ((VlogFileInstance)fileInstance).getInvocNumber();
        if (explicitImportExports != null && !explicitImportExports.isEmpty()) {
            for (ExplicitImportInfo importInfo : explicitImportExports) {
                if (invocNumber != importInfo.getInvocNumber() || !importInfo.getPackageName().equals(packageName) || !importInfo.getElementName().equals(elementName) || !importInfo.getParserPath().equals((Object)fileInstance.getParserPath()) || importInfo.getLine() != line || !this.fIncrementalBuild && macroZone != null && !macroZone.equals(importInfo.getMacroZone())) continue;
                found = true;
                importInfo.setDirtyCleanUpFlag(false);
                importInfo.setOffset(offset);
                importInfo.setLine(line);
                importInfo.setMacroZone(this.fCurrentMacroZone);
                break;
            }
        }
        if (!found) {
            ExplicitImportInfo importInfo;
            importInfo = new ExplicitImportInfo(packageName, elementName, false, line, offset, invocNumber, fileInstance.getParserPath());
            importInfo.setMacroZone(this.fCurrentMacroZone);
            if (isImport) {
                importScope.addExplicitImport(importInfo, this);
            } else {
                importScope.addExplicitExport(importInfo);
            }
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.addedImportInfos.add(importInfo);
                this.setIncrementalChangedImports(true, packageName, importScope);
            }
        }
    }

    private RfFileDef getFileDefinition(IDVTFileInstance fileInstance) {
        return this.getFileDefinition((VlogFileInstance)fileInstance, false);
    }

    public void getFileDefinitionNoSemanticScope(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        RfFileDef fileDefinition = this.getFileDefUsingParserPath(parserPath);
        RfNamedElement fileSemanticScope = fileInstance.getSemanticScope();
        if (fileDefinition == null) {
            fileDefinition = new RfFileDef(fileInstance.getShortFileName(), fileInstance.getIndex(), parserPath, fileInstance.getUndeclaredElements() != null, this);
            this.fRfProjectContent.fParserPath2FileDefMap.put((ParserPath)parserPath.toCanonical(), fileDefinition);
            this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
            RfNamedElement semanticScope = this.fBuildScope.getScope();
            fileInstance.setSemanticScope(semanticScope);
        } else if (fileSemanticScope == null) {
            this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
            RfNamedElement semanticScope = this.fBuildScope.getScope();
            fileInstance.setSemanticScope(semanticScope);
        }
    }

    private RfFileDef getFileDefinition(VlogFileInstance fileInstance, boolean incremental) {
        RfNamedElement semanticScope;
        ParserPath parserPath = fileInstance.getParserPath();
        RfFileDef fileDefinition = this.getFileDefUsingParserPath(parserPath);
        RfNamedElement fileSemanticScope = fileInstance.getSemanticScope();
        if (fileDefinition == null) {
            fileDefinition = new RfFileDef(fileInstance.getShortFileName(), fileInstance.getIndex(), parserPath, fileInstance.getUndeclaredElements() != null, this);
            this.fRfProjectContent.fParserPath2FileDefMap.put((ParserPath)parserPath.toCanonical(), fileDefinition);
            this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
            semanticScope = this.fBuildScope.getScope();
            fileInstance.setSemanticScope(semanticScope);
            fileDefinition.addNamedElement(semanticScope);
        } else if (!incremental && fileSemanticScope == null) {
            this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
            semanticScope = this.fBuildScope.getScope();
            fileInstance.setSemanticScope(semanticScope);
            fileDefinition.addNamedElement(semanticScope);
        }
        if (incremental) {
            this.fBuildScope.clean();
            this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
            if (fileSemanticScope != null) {
                if (!(fileSemanticScope instanceof RfProject)) {
                    this.fBuildScope.setScope(fileSemanticScope);
                } else {
                    semanticScope = this.fBuildScope.getScope();
                    fileInstance.setSemanticScope(semanticScope);
                    fileDefinition.addNamedElement(semanticScope);
                }
            } else {
                semanticScope = this.fBuildScope.getScope();
                fileInstance.setSemanticScope(semanticScope);
                fileDefinition.addNamedElement(semanticScope);
            }
        }
        return fileDefinition;
    }

    public RfLibrary getOrCreateLibrary(String rawLibraryName) {
        if (rawLibraryName == null) {
            return null;
        }
        String libraryName = DVTStringUtil.unescapeIdentifier((String)rawLibraryName, (boolean)false);
        boolean isEscaped = libraryName != null && rawLibraryName.length() != libraryName.length();
        RfLibrary library = this.getLocalLibrary(libraryName);
        if (library == null) {
            libraryName = this.adjustLibraryName(libraryName);
            library = new RfLibrary(libraryName, isEscaped);
            library.setEnclosingScope(this);
            RfLibrary stdLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)PREDEFINED_STD_LIBRARY_NAME);
            if (stdLibrary != null) {
                ImportInfo predefinedStdPackageImplicitImport = new ImportInfo(PREDEFINED_STD_PACKAGE_NAME, -1, -1, -1, null);
                predefinedStdPackageImplicitImport.setPackage(stdLibrary.getLocalMember(RfPredefinedPackage.class, PREDEFINED_STD_PACKAGE_NAME, true));
                library.addWildcardImport(predefinedStdPackageImplicitImport, this);
            }
            this.fRfProjectContent.fLibraries.put((Object)libraryName, (IDVTMapElement)library);
        }
        return library;
    }

    public RfLibrary getLocalLibrary(String name) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)this.adjustLibraryName(name));
    }

    private String adjustLibraryName(String libraryName) {
        return IBuildConfigParserConstants.IUS_TOOLS.contains(this.getToolCompat()) && "worklib".equals(libraryName) ? "work" : libraryName;
    }

    private String adjustLibraryNameIgnoreCase(String libraryName) {
        return IBuildConfigParserConstants.IUS_TOOLS.contains(this.getToolCompat()) && "worklib".equalsIgnoreCase(libraryName) ? "work" : libraryName;
    }

    public void startLibrary(String libraryName, boolean fromPreprocessor) {
        if (libraryName == null) {
            return;
        }
        libraryName = this.adjustLibraryName(libraryName);
        RfLibrary currentLibrary = this.fBuildScope.getCurrentLibrary();
        if (currentLibrary != null && (this.fIsLibraryOverridenFromPreprocessor && !fromPreprocessor || libraryName.equals(currentLibrary.getName()))) {
            return;
        }
        this.fIsLibraryOverridenFromPreprocessor |= fromPreprocessor;
        RfLibrary library = this.getOrCreateLibrary(libraryName);
        this.fBuildScope.setCurrentLibrary(library);
        this.fCurrentLibraryName = libraryName;
        if (this.fSwitchLibraryListener != null) {
            this.fSwitchLibraryListener.switchLibrary(library);
        }
    }

    public void resetLibraryFromPreprocessor(VlogFileInstance fileInstance) {
        this.fIsLibraryOverridenFromPreprocessor = false;
        this.startLibrary(this.getLibraryNameForFile(fileInstance), false);
    }

    public void setSwitchLibraryListener(IRfSwitchLibraryListener rfSwitchLibraryListener) {
        this.fSwitchLibraryListener = rfSwitchLibraryListener;
    }

    public DefNamedElementPair startClass(WrapperInfo info, int qualifiers, boolean isInterface) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfClass clazz = enclosing.getLocalMember(RfClass.class, name, false, this.fIncrementalBuild);
        RfDefElement classDef = new RfClassDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(classDef);
        if (foundElem != null) {
            classDef = foundElem;
            if (this.isAlreadyDefined(clazz, foundElem)) {
                this.increaseDuplicateScope(clazz);
                this.pushScope(classDef, clazz);
                return new DefNamedElementPair(classDef, clazz);
            }
        }
        clazz = clazz == null || !clazz.hasNoDefs(false) ? null : clazz;
        List<RfNamedElement> externImplementationCandidates = null;
        RfFragment fragment = enclosing.getFragmentWithPrefix(name, 1, 3);
        if (fragment != null) {
            RfNamedElement enclosingScope;
            externImplementationCandidates = fragment.getExternImplementationCandidates();
            Collection fragmentDefs = fragment.getDeclarations();
            if (fragmentDefs != null) {
                for (RfDefElement fragmentDef : fragmentDefs) {
                    fragment.removeDef(null, fragmentDef);
                    fragmentDef.getDefFile().removeChildDef(fragmentDef);
                }
            }
            if ((enclosingScope = fragment.getEnclosingScope()) != null && enclosingScope.internalGetMembers() != null) {
                enclosingScope.internalGetMembers().remove((Object)name);
            }
        }
        if (clazz != null) {
            clazz.init(info.getMacroCalls(), qualifiers, isInterface);
        } else {
            clazz = new RfClass(name, isEscaped, info.getMacroCalls(), qualifiers, isInterface);
            enclosing.addMember(clazz);
        }
        classDef = clazz.addDeclaration(classDef);
        clazz.setMacroZone(this.fCurrentMacroZone);
        if (externImplementationCandidates != null && !externImplementationCandidates.isEmpty()) {
            for (RfNamedElement candidate : externImplementationCandidates) {
                if (candidate.hasNoDefs(true)) continue;
                clazz.addMember(candidate);
            }
        }
        this.pushScope(classDef, clazz);
        return new DefNamedElementPair(classDef, clazz);
    }

    public void endClass(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, MacroCallInfo macroCalls, DataType extendedType, List<DataType> implementedTypes, List<IHidObject> arguments, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfClass rfClass = (RfClass)defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, (RfNamedElement)rfClass);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        rfClass.setMacroCallInfo(macroCalls);
        rfClass.setParentTypes(extendedType, implementedTypes, arguments, this.fIncrementalDeltaContainer);
        this.popScope(fileInstance, (RfNamedElement)rfClass);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
    }

    public void startCuname(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfLibrary currentLibrary = this.fBuildScope.getCurrentLibrary();
        RfPackage packg = currentLibrary.getLocalMember(RfPackage.class, info.getName(), false, this.fIncrementalBuild);
        RfDefElement packgDef = new RfPackageDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(packgDef);
        if (foundElem != null) {
            packgDef = foundElem;
            if (this.isAlreadyDefined(packg, foundElem)) {
                this.increaseDuplicateScope(packg);
                this.pushScope(packgDef, packg);
                return;
            }
        }
        if (packg == null) {
            String cuname = info.getName();
            packg = new RfCuname(cuname);
            currentLibrary.addPackage(packg);
            this.startWildcardImport(cuname, info.getStartLine(), info.getStartRealOffset(), info.getFileInstance(), true, this.fCurrentMacroZone);
        }
        packgDef = packg.addDeclaration(packgDef);
        this.pushScope(packgDef, packg);
    }

    public void endCuname(WrapperInfo info) {
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing instanceof RfCuname && enclosing.getName().equals(info.getName())) {
            this.popScope(info.getFileInstance(), null);
        }
    }

    public DefNamedElementPair startPackage(WrapperInfo info, int qualifiers) {
        String name;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfLibrary currentLibrary = this.fBuildScope.getCurrentLibrary();
        this.fCurrentPackageName = name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfPackage packg = currentLibrary.getLocalMember(RfPackage.class, name, false, this.fIncrementalBuild);
        RfDefElement packgDef = new RfPackageDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(packgDef);
        if (foundElem != null) {
            packgDef = foundElem;
            if (this.isAlreadyDefined(packg, foundElem)) {
                this.increaseDuplicateScope(packg);
                this.pushScope(packgDef, packg);
                return new DefNamedElementPair(packgDef, packg);
            }
        }
        RfPackage rfPackage = packg = packg == null || !packg.hasNoDefs(false) ? null : packg;
        if (packg == null) {
            packg = new RfPackage(name, info.isEscaped());
            currentLibrary.addPackage(packg);
        }
        packg.setQualifiers(qualifiers);
        packg.setMacroZone(this.fCurrentMacroZone);
        packgDef = packg.addDeclaration(packgDef);
        this.pushScope(packgDef, packg);
        return new DefNamedElementPair(packgDef, packg);
    }

    public void endPackage(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement);
            return;
        }
        this.fCurrentPackageName = null;
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, namedElement);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
    }

    public DefNamedElementPair startPrimitive(WrapperInfo info, String defaultNetType, HidImplicit[] timescale) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfLibrary currentLibrary = this.fBuildScope.getCurrentLibrary();
        RfPrimitive primitive = currentLibrary.getLocalMember(RfPrimitive.class, info.getName(), false, this.fIncrementalBuild);
        RfDefElement primitiveDef = new RfPrimitiveDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(primitiveDef);
        if (foundElem != null) {
            primitiveDef = foundElem;
            if (this.isAlreadyDefined(primitive, foundElem)) {
                this.increaseDuplicateScope(primitive);
                this.pushScope(primitiveDef, primitive);
                return new DefNamedElementPair(primitiveDef, primitive);
            }
        }
        RfPrimitive rfPrimitive = primitive = primitive == null || !primitive.hasNoDefs(false) ? null : primitive;
        if (primitive == null) {
            primitive = new RfPrimitive(info.getName(), info.isEscaped(), defaultNetType, timescale);
            currentLibrary.addPrimitive(primitive);
        } else {
            primitive.setTimescale(timescale);
        }
        primitive.setMacroZone(this.fCurrentMacroZone);
        primitiveDef = primitive.addDeclaration(primitiveDef);
        primitiveDef.setDefComment(info.getComment());
        this.pushScope(primitiveDef, primitive);
        return new DefNamedElementPair(primitiveDef, primitive);
    }

    public void endPrimitive(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement primitive = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, primitive);
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, primitive);
    }

    private final RfNamedElement getDesignElementScope() {
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing instanceof RfCuname) {
            enclosing = enclosing.getEnclosingScope();
        }
        return enclosing;
    }

    public DefNamedElementPair startModule(WrapperInfo info, int qualifiers, String defaultNetType, HidImplicit[] timescale) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.getDesignElementScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfModule module = enclosing.getLocalMember(RfModule.class, name, false, this.fIncrementalBuild);
        RfDefElement moduleDef = new RfModuleDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(moduleDef);
        if (foundElem != null) {
            moduleDef = foundElem;
            if (this.isAlreadyDefined(module, foundElem)) {
                this.increaseDuplicateScope(module);
                this.pushScope(moduleDef, module, true);
                return new DefNamedElementPair(moduleDef, module);
            }
        }
        RfModule rfModule = module = module == null || !module.hasNoDefs(false) ? null : module;
        if (module == null) {
            module = new RfModule(name, info.isEscaped(), defaultNetType, timescale);
            enclosing.addMember(module);
        } else {
            module.setTimescale(timescale);
            this.checkIfExistImplicitIncludedGenerateBlocks(module, moduleDef);
        }
        module.setMisingParameterPortList(true);
        module.setQualifiers(qualifiers);
        module.setMacroZone(this.fCurrentMacroZone);
        moduleDef = module.addDeclaration(moduleDef);
        this.pushScope(moduleDef, module, true);
        return new DefNamedElementPair(moduleDef, module);
    }

    public void endModule(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, int endLabel, VlogUtil util, IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean extern) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement module = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, module, true);
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, module, true);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
        this.resolveLocalImplicitGenerateBlocksInElement(def, module);
        this.checkNonAnsiPorts(module, util, languageSyntax, extern);
    }

    private void checkNonAnsiPorts(RfNamedElement enclosing, final VlogUtil util, final IBuildConfigParserConstants.LanguageSyntax syntax, boolean extern) {
        if (!(enclosing instanceof RfInstanceHolder)) {
            return;
        }
        if (extern) {
            return;
        }
        final RfInstanceHolder module = (RfInstanceHolder)enclosing;
        if (!module.isNonAnsi()) {
            return;
        }
        List<RfPort> localPorts = module.getLocalMembers(RfPort.class);
        if (localPorts == null || localPorts.isEmpty()) {
            return;
        }
        final HashSet signals = new HashSet();
        final HashSet visitedPortIdentifiers = new HashSet();
        IHidVisitor<RfHidOperator> visitor = new IHidVisitor<RfHidOperator>(){
            private ParserPath parserPath;

            public boolean visit(RfHidOperator operator) {
                if (!operator.hasQualifier(HidQualifierCache.IS_PORT_EXPRESSION_QUALIFIER)) {
                    return true;
                }
                IHidObject lhHid = operator.getLHValue();
                if (!HidUtils.isHidImplicit((IHidObject)lhHid)) {
                    return true;
                }
                String portIdentifier = ((RfHidImplicit)lhHid).getName();
                if (visitedPortIdentifiers.contains(portIdentifier)) {
                    util.reportError("*** Warning: ", this.parserPath.path, syntax, operator.getLine(), operator.getOpenBoundary(), portIdentifier.length(), "Duplicate port '" + portIdentifier + "' in non-ANSI module", RfProject.this.getFileIndex(this.parserPath), (ReparseInfo)operator.getReparseInfo());
                }
                visitedPortIdentifiers.add(portIdentifier);
                IRfPortElement port = module.getPortWithPrefix(portIdentifier, 1);
                if (port == null) {
                    return true;
                }
                Set portExpressionHids = operator.getRHHids(HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                if (portExpressionHids == null || portExpressionHids.isEmpty()) {
                    return true;
                }
                for (IHid portReferenceHid : portExpressionHids) {
                    if (!HidUtils.isHid((IHidObject)portReferenceHid)) continue;
                    String portReference = ((Hid)portReferenceHid).getName();
                    signals.add(portReference);
                    HidOccurrence occurrence = portReferenceHid.getOccurrence();
                    RfField signal = module.getLocalMember(RfField.class, portReference, true);
                    if (signal instanceof RfPort) {
                        Collection declarations = signal.getDeclarations();
                        if (declarations != null) {
                            boolean isDeclared = false;
                            for (IRfDefElement declaration : declarations) {
                                if (!(declaration instanceof RfPortDef) || ((RfPortDef)declaration).isInListOfPorts()) continue;
                                isDeclared = true;
                            }
                            if (!isDeclared) {
                                util.reportError("*** Error: ", this.parserPath.path, syntax, occurrence.getLine(), occurrence.getOffset(), signal.getName().length(), "Port '" + signal.getName() + "' has no data type specified", RfProject.this.getFileIndex(this.parserPath), (ReparseInfo)operator.getReparseInfo());
                            }
                        }
                        if (signal == port || port.isNonANSIImplicitPort()) continue;
                        ((RfPort)signal).addPortAlias((RfPort)port);
                        continue;
                    }
                    if (signal == null) continue;
                    util.reportError("*** Error: ", this.parserPath.path, syntax, occurrence.getLine(), occurrence.getOffset(), signal.getName().length(), "Signal reference '" + signal.getName() + "' not allowed in port list", RfProject.this.getFileIndex(this.parserPath), (ReparseInfo)operator.getReparseInfo());
                }
                return true;
            }

            public void setParserPath(ParserPath parsetPath) {
                this.parserPath = parsetPath;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        };
        module.visitHidObject(null, visitor);
        for (RfPort localPort : localPorts) {
            VlogMacroZone macroZone;
            ParserPath parserPath;
            String localPortName = localPort.getName();
            if (signals.contains(localPortName)) continue;
            Collection declarations = localPort.getDeclarations();
            IRfDefElement outOfPortListDeclaration = null;
            for (IRfDefElement declaration : declarations) {
                if (!(declaration instanceof RfPortDef) || ((RfPortDef)declaration).isInListOfPorts()) continue;
                outOfPortListDeclaration = declaration;
            }
            if (outOfPortListDeclaration == null || (parserPath = outOfPortListDeclaration.getParserPath()) == null || (macroZone = localPort.getMacroZone()) == null) continue;
            util.reportError("*** Error: ", parserPath.path, syntax, outOfPortListDeclaration.getStartLine(), outOfPortListDeclaration.getStartOffset(), localPortName.length(), "Port '" + localPortName + "' not specified in list of ports", macroZone.getIndex(), null);
        }
    }

    public DefNamedElementPair startInterface(WrapperInfo info, int qualifiers, String defaultNetType, HidImplicit[] timescale) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.getDesignElementScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfInterface interfac = enclosing.getLocalMember(RfInterface.class, name, false, this.fIncrementalBuild);
        RfDefElement interfacDef = new RfInterfaceDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(interfacDef);
        if (foundElem != null) {
            interfacDef = foundElem;
            if (this.isAlreadyDefined(interfac, foundElem)) {
                this.increaseDuplicateScope(interfac);
                this.pushScope(interfacDef, interfac, true);
                return new DefNamedElementPair(interfacDef, interfac);
            }
        }
        RfInterface rfInterface = interfac = interfac == null || !interfac.hasNoDefs(false) ? null : interfac;
        if (interfac == null) {
            interfac = new RfInterface(name, info.isEscaped(), defaultNetType, timescale);
            enclosing.addMember(interfac);
        } else {
            interfac.setTimescale(timescale);
            this.checkIfExistImplicitIncludedGenerateBlocks(interfac, interfacDef);
        }
        interfac.setMisingParameterPortList(true);
        interfac.setQualifiers(qualifiers);
        interfac.setMacroZone(this.fCurrentMacroZone);
        interfacDef = interfac.addDeclaration(interfacDef);
        this.pushScope(interfacDef, interfac, true);
        return new DefNamedElementPair(interfacDef, interfac);
    }

    public void endInterface(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, int endLabel, VlogUtil util, IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean extern) {
        List<RfModport> modports;
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement interfaceElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, interfaceElement, true);
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        def.setDefComment(comment);
        this.popScope(fileInstance, interfaceElement, true);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
        if ((modports = interfaceElement.getLocalMembers(RfModport.class)) != null && !modports.isEmpty()) {
            for (RfModport modport : modports) {
                List<RfFunction> modportFunctions = modport.getLocalMembers(RfFunction.class);
                if (modportFunctions == null) continue;
                for (RfFunction modportFunction : modportFunctions) {
                    RfFunction interfaceFunction = interfaceElement.getLocalMember(RfFunction.class, modportFunction.getName(), false, this.fIncrementalBuild);
                    if (interfaceFunction == null) continue;
                    modportFunction.setFunctionKind(interfaceFunction.getFunctionKind());
                }
            }
        }
        this.resolveLocalImplicitGenerateBlocksInElement(def, interfaceElement);
        this.checkNonAnsiPorts(interfaceElement, util, languageSyntax, extern);
    }

    public DefNamedElementPair startProgram(WrapperInfo info, int qualifiers, String defaultNetType, HidImplicit[] timescale) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.getDesignElementScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfProgram program = enclosing.getLocalMember(RfProgram.class, name, false, this.fIncrementalBuild);
        RfDefElement programDef = new RfProgramDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(programDef);
        if (foundElem != null) {
            programDef = foundElem;
            if (this.isAlreadyDefined(program, foundElem)) {
                this.increaseDuplicateScope(program);
                this.pushScope(programDef, program, true);
                return new DefNamedElementPair(programDef, program);
            }
        }
        RfProgram rfProgram = program = program == null || !program.hasNoDefs(false) ? null : program;
        if (program == null) {
            program = new RfProgram(name, info.isEscaped(), defaultNetType, timescale);
            enclosing.addMember(program);
        } else {
            program.setTimescale(timescale);
            this.checkIfExistImplicitIncludedGenerateBlocks(program, programDef);
        }
        program.setMisingParameterPortList(true);
        program.setQualifiers(qualifiers);
        program.setMacroZone(this.fCurrentMacroZone);
        programDef = program.addDeclaration(programDef);
        this.pushScope(programDef, program, true);
        return new DefNamedElementPair(programDef, program);
    }

    public void endProgram(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, int endLabel, VlogUtil util, IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean extern) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement program = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, program, true);
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        def.setDefComment(comment);
        this.popScope(fileInstance, program, true);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
        this.resolveLocalImplicitGenerateBlocksInElement(def, program);
        this.checkNonAnsiPorts(program, util, languageSyntax, extern);
    }

    public DefNamedElementPair startChecker(WrapperInfo info, int qualifiers, String defaultNetType) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfChecker checker = enclosing.getLocalMember(RfChecker.class, name, false, this.fIncrementalBuild);
        RfDefElement checkerDef = new RfCheckerDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(checkerDef);
        if (foundElem != null) {
            checkerDef = foundElem;
            if (this.isAlreadyDefined(checker, foundElem)) {
                this.increaseDuplicateScope(checker);
                this.pushScope(checkerDef, checker, true);
                return new DefNamedElementPair(checkerDef, checker);
            }
        }
        RfChecker rfChecker = checker = checker == null || !checker.hasNoDefs(false) ? null : checker;
        if (checker == null) {
            checker = new RfChecker(name, info.isEscaped(), defaultNetType);
            enclosing.addMember(checker);
        } else {
            this.checkIfExistImplicitIncludedGenerateBlocks(checker, checkerDef);
        }
        checker.setQualifiers(qualifiers);
        checker.setMacroZone(this.fCurrentMacroZone);
        checkerDef = checker.addDeclaration(checkerDef);
        this.pushScope(checkerDef, checker, true);
        return new DefNamedElementPair(checkerDef, checker);
    }

    public void endChecker(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement checker = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, checker, true);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, checker, true);
        this.resolveLocalImplicitGenerateBlocksInElement(def, checker);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DefNamedElementPair startFunction(WrapperInfo info, int kind, boolean prototype, int qualifiers, List<TimeConsumingStatement> timeConsumingStatements, String dpiKindName, boolean isExportDPI, String cIdentifier) throws RecognitionException {
        block22: {
            functionName = info.getName();
            if (functionName == null) {
                return null;
            }
            isEscaped = info.isEscaped();
            dpiKindName = DVTStringUtil.intern((String)dpiKindName);
            cIdentifier = DVTStringUtil.intern((String)cIdentifier);
            this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
            this.fCurrentMacroZone = info.getMacroZone();
            if (isEscaped) {
                v0 = new String[1];
                v1 = v0;
                v0[0] = functionName;
            } else {
                v1 = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)functionName);
            }
            qualifiedName = v1;
            enclosing = enclosingScope = this.fBuildScope.getScope();
            if (qualifiedName.length < 2) break block22;
            functionName = qualifiedName[qualifiedName.length - 1];
            i = 0;
            while (i < qualifiedName.length - 1) {
                block24: {
                    block25: {
                        block23: {
                            if (i != 0 || qualifiedName.length <= 2 || (candidate /* !! */  = enclosing.getPackageWithPrefix(qualifiedName[i], 1)) == null) break block23;
                            enclosing = candidate /* !! */ ;
                            break block24;
                        }
                        candidate /* !! */  = enclosing.getClassWithPrefix(qualifiedName[i], 1, 3);
                        if (candidate /* !! */  == null && (typeAlias = enclosingScope.getTypeAliasWithPrefix(qualifiedName[i], 1, 3, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null && (translatedType = typeAlias.getTranslatedType()) instanceof RfClass) {
                            candidate /* !! */  = (RfClass)translatedType;
                        }
                        if (candidate /* !! */  != null) break block25;
                        fragment = enclosingScope.getLocalMember(RfFragment.class, qualifiedName[i], false, this.fIncrementalBuild);
                        fragmentDef /* !! */  = new RfFragmentDef(this.fCurrentFileDef, info.getStartInfo(), info.getEndInfo());
                        foundElem = this.fCurrentFileDef.findDefElement(fragmentDef /* !! */ );
                        if (foundElem == null) ** GOTO lbl-1000
                        fragmentDef /* !! */  = foundElem;
                        if (this.isAlreadyDefined(fragment, foundElem)) {
                            this.fCurrentFileDef.addChildDef(fragmentDef /* !! */ );
                            enclosing = fragment;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (fragment == null) {
                                fragment = new RfFragment(qualifiedName[i], isEscaped);
                                enclosing.addMember(fragment);
                            }
                            fragmentDef /* !! */  = fragment.addDeclaration(fragmentDef /* !! */ );
                            this.fCurrentFileDef.addChildDef(fragmentDef /* !! */ );
                            enclosing = fragment;
                        }
                        break block24;
                    }
                    enclosing = candidate /* !! */ ;
                }
                ++i;
            }
        }
        dpiKind = 0;
        if (dpiKindName != null && dpiKindName.length() > 1) {
            dpiKind = (byte)(dpiKind | (dpiKindName.charAt(dpiKindName.length() - 1) == 'C' ? 1 : 2));
            dpiKind = (byte)(dpiKind | (isExportDPI != false ? 8 : 4));
        }
        function = enclosing.getLocalMember(RfFunction.class, functionName, false, this.fIncrementalBuild);
        functionDef = new RfFunctionDef(this.fCurrentFileDef, info, qualifiedName.length > 2, (byte)kind, dpiKind);
        foundElem = this.fCurrentFileDef.findDefElement(functionDef);
        if (foundElem != null) {
            functionDef = foundElem;
            if (this.isAlreadyDefined(function, foundElem)) {
                this.increaseDuplicateScope(function);
                this.pushScope(functionDef, function);
                return new DefNamedElementPair(functionDef, function);
            }
        }
        if (function instanceof RfModportFunction && enclosing instanceof RfModport && ".*".equals(functionName) && (declaration = function.getDeclaration()) != null) {
            this.pushScope(declaration, function);
            return new DefNamedElementPair(declaration, function);
        }
        if (enclosing instanceof RfCovergroup && function instanceof RfPredefinedFunction && "sample".equals(functionName)) {
            function = null;
        }
        dataType = 2 == kind && (enclosing instanceof RfClass != false || enclosing instanceof RfCovergroup != false) ? new DataType(enclosing.getName()) : info.getDataType();
        externDeclaration = enclosing != enclosingScope && (enclosing instanceof RfClass != false || enclosing instanceof RfFragment != false);
        macroCalls = info.getMacroCalls();
        if (!this.isLintingEnabled()) {
            macroCalls = null;
            timeConsumingStatements = null;
        }
        if (function != null) {
            if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(function.getDataType())) {
                this.fIncrementalDeltaContainer.changedDataTypeElements.add(function);
            }
            if (!externDeclaration) {
                function.init(isExportDPI != false ? function.getDataType() : dataType, macroCalls, kind, qualifiers, timeConsumingStatements, cIdentifier);
            }
            if (enclosing instanceof RfClass && function instanceof RfPredefinedFunction && enclosing.getLocalMember(RfPredefinedFunction.class, functionName, true) == null) {
                enclosing.addMember(function);
            }
        } else {
            function = enclosing instanceof RfModport != false ? new RfModportFunction(functionName, isEscaped, dataType, macroCalls, kind, qualifiers, timeConsumingStatements, cIdentifier) : new RfFunction(functionName, isEscaped, dataType, macroCalls, kind, qualifiers, timeConsumingStatements, cIdentifier);
            enclosing.addMember(function);
        }
        if (enclosing instanceof RfClass && (qualifiers & 128) == 128 && ("pre_randomize".equals(functionName) || "post_randomize".equals(functionName))) {
            throw new RecognitionException("The '" + functionName + "()' built-in function cannot be declared virtual", info.getFileInstance().getParserPath().path, info.getStartLine(), 0, info.getStartInfo().realOffset, functionName.length());
        }
        if (enclosing instanceof RfClass && (qualifiers & 256) == 256) {
            enclosing.setQualifiers(enclosing.getQualifiers() | 256);
        }
        functionDef.setOutOfClassDefinition(externDeclaration);
        ((RfFunctionDef)functionDef).setPrototype(externDeclaration == false & prototype);
        addedFunctionDef = function.addDeclaration(functionDef);
        if (addedFunctionDef != functionDef && addedFunctionDef instanceof RfFunctionDef) {
            functionDef = addedFunctionDef;
            ((RfFunctionDef)functionDef).setOutOfClassDefinition(externDeclaration);
            ((RfFunctionDef)functionDef).setPrototype(externDeclaration == false & prototype);
        }
        function.setMacroZone(this.fCurrentMacroZone);
        this.pushScope(functionDef, function);
        ((RfFunctionDef)functionDef).addDataType(function, info);
        return new DefNamedElementPair(functionDef, function);
    }

    public void endFunction(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, MacroCallInfo macroCalls, int statementNo, List<TimeConsumingStatement> timeConsumingStatements, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement function = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, function);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        if (this.isLintingEnabled()) {
            ((RfFunction)function).setMacroCallInfo(macroCalls);
            ((RfFunction)function).setStatementNo(statementNo);
            ((RfFunction)function).addTimeConsumingStatements(timeConsumingStatements);
        }
        this.popScope(fileInstance, function);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
    }

    public RfTypeAlias startType(WrapperInfo info, int qualifiers, boolean isNettype, String resolutionFunction) {
        RfStruct candidate;
        String aliasedTypeName;
        RfDefElement typeDef;
        RfDefElement foundElem;
        boolean isTypedefClass;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        DataType dataType = info.getDataType();
        boolean bl = isTypedefClass = dataType != null && "[defined later]".equals(dataType.fType);
        if (this.fIncrementalDeltaContainer != null && !(enclosing instanceof RfActionBlock)) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        if ((foundElem = this.fCurrentFileDef.findDefElement(typeDef = new RfTypeAliasDef(this.fCurrentFileDef, info))) != null) {
            typeDef = foundElem;
            List<RfTypeAlias> typeAliases = enclosing.getLocalMembers(RfTypeAlias.class);
            if (typeAliases != null) {
                for (RfTypeAlias rfTypeAlias : typeAliases) {
                    if (!this.isAlreadyDefined(rfTypeAlias, foundElem)) continue;
                    this.fCurrentFileDef.addChildDef(typeDef);
                    return rfTypeAlias;
                }
            }
        }
        Class clazz = isTypedefClass ? RfForwardTypedef.class : RfTypeAlias.class;
        RfTypeAlias type = enclosing.getLocalMember(clazz, name, false, this.fIncrementalBuild);
        RfTypeAlias rfTypeAlias = type = type == null || !type.hasNoDefs(true) ? null : type;
        if (type != null) {
            if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(type.getDataType())) {
                this.fIncrementalDeltaContainer.changedDataTypeElements.add(type);
            }
            if (isNettype && type instanceof RfNetTypeAlias) {
                ((RfNetTypeAlias)type).init(dataType, resolutionFunction, qualifiers);
            } else {
                type.init(dataType, qualifiers);
            }
        } else {
            type = isTypedefClass ? new RfForwardTypedef(name, isEscaped, dataType) : (isNettype ? new RfNetTypeAlias(name, isEscaped, dataType, resolutionFunction, 1) : new RfTypeAlias(name, isEscaped, dataType, qualifiers));
            enclosing.addMember(type);
        }
        if (!isTypedefClass && dataType != null && (aliasedTypeName = dataType.getType()) != null && (candidate = enclosing.getLocalMember(RfStruct.class, aliasedTypeName, false, this.fIncrementalBuild)) != null) {
            candidate.setAliasName(name);
        }
        type.setMacroZone(this.fCurrentMacroZone);
        typeDef = type.addDeclaration(typeDef);
        this.fCurrentFileDef.addChildDef(typeDef);
        return type;
    }

    public RfField startField(WrapperInfo info, int kind, RfDefElement parentDef) {
        return this.startField(info, kind, 0, null, false, null, parentDef);
    }

    public RfField startField(WrapperInfo info, IHidObject arrayHidObject, int qualifiers) {
        return this.startField(info, 4, qualifiers | 0x400000, arrayHidObject, false, null, null);
    }

    private boolean isVerilogSyntax(WrapperInfo info) {
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = info.getFileInstance().getLanguageSyntax();
        return languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23;
    }

    private boolean isAmsSyntax(WrapperInfo info) {
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = info.getFileInstance().getLanguageSyntax();
        boolean hasAMSSupport = info.getFileInstance().getAMSSupport();
        boolean hasWrealSupport = info.getFileInstance().getWrealSupport();
        return hasAMSSupport || hasWrealSupport || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS;
    }

    public RfField startField(WrapperInfo info, int kind, int qualifiers, IHidObject arrayHidObject, boolean isInParameterPortList, RfField.ParameterKind parameterKind, RfDefElement parentDef) {
        return this.startField(info, kind, qualifiers, arrayHidObject, 0, isInParameterPortList, parameterKind, parentDef);
    }

    public RfField startField(WrapperInfo info, int kind, int qualifiers, IHidObject arrayHidObject, int index, boolean isInParameterPortList, RfField.ParameterKind parameterKind, RfDefElement parentDef) {
        int allDefsSize;
        DefNamedElementPair startPort;
        DefNamedElementPair startPort2;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        DataType dataType = info.getDataType();
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        if (this.fIncrementalDeltaContainer != null && kind == 256) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        if (enclosing instanceof RfInstanceHolder && ((RfInstanceHolder)enclosing).isNonAnsi() && ((RfInstanceHolder)enclosing).hasNonAnsiPortName(name) && (startPort2 = this.startPort(info, 0, false, null)).getNamedElement() instanceof RfPort) {
            return (RfPort)startPort2.getNamedElement();
        }
        RfField field = enclosing.getLocalMember(RfField.class, name, true, false);
        if (field instanceof RfInstance) {
            field = null;
        }
        if (field instanceof RfPort && !field.hasNoDefs(true) && (startPort = this.startPort(info, ((RfPort)field).getPortKind(), false, null)).getNamedElement() instanceof RfPort) {
            return (RfPort)startPort.getNamedElement();
        }
        RfDefElement fieldDef = new RfFieldDef(this.fCurrentFileDef, info, (qualifiers & 0x400000) != 0);
        DataType defDataType = info.getDataType();
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(fieldDef);
        if (foundElem != null) {
            fieldDef = foundElem;
            if (field != null && this.isAlreadyDefined(field, foundElem)) {
                this.fCurrentFileDef.addChildDef(fieldDef);
                return field;
            }
        }
        if (arrayHidObject != null) {
            try {
                dataType = new DataExpressionType(dataType);
                ((DataExpressionType)dataType).setExpression(arrayHidObject, index);
                defDataType = dataType;
            }
            catch (Exception exception) {}
        }
        if (parentDef instanceof RfFunctionDef || parentDef instanceof RfCovergroupDef || dataType != null && dataType.getEnumRange() != null) {
            ((RfFieldDef)fieldDef).setParentDef(parentDef);
        }
        boolean swapExistingElement = field != null && (kind == 2 || kind == 256 || kind == 128);
        RfField existingElement = field;
        int n = allDefsSize = field == null ? 0 : field.getDeclarations().size();
        if (field != null && field.isImplicitSignal()) {
            field = null;
        } else if (field instanceof RfPort) {
            field = allDefsSize > 2 ? null : field;
        } else if (field != null) {
            boolean isAmsSyntax = this.isAmsSyntax(info);
            DataType fieldDataType = field.getDataType();
            if (kind == 128 && allDefsSize > 0) {
                field = null;
            } else if (kind == 256 && allDefsSize > 0) {
                field = null;
            } else if (kind == 2 && enclosing instanceof RfFunction && enclosing.isExtern()) {
                if (allDefsSize > 1) {
                    field = null;
                }
            } else if (fieldDataType != null && dataType != null && fieldDataType.getDirection() != 0 && dataType.getDirection() != 0 && allDefsSize > (isAmsSyntax ? 1 : 0)) {
                field = null;
            } else if (isAmsSyntax) {
                if (allDefsSize > 2) {
                    field = null;
                } else if (dataType != null && fieldDataType != null) {
                    if (fieldDataType.fDiscipline != null && dataType.fDiscipline != null) {
                        field = null;
                    } else if ((fieldDataType.fNetType != null || fieldDataType.fType != null) && dataType.fType != null) {
                        field = null;
                    }
                }
            } else if (this.isVerilogSyntax(info)) {
                if (allDefsSize > 1) {
                    field = null;
                } else if (dataType != null && fieldDataType != null && fieldDataType.fType != null && dataType.fType != null) {
                    field = null;
                }
            } else if (allDefsSize > 1) {
                field = null;
            } else if (dataType != null && fieldDataType != null && (fieldDataType.fType != null && dataType.fType != null || fieldDataType.fNetType != null && dataType.fNetType != null)) {
                field = null;
            }
        }
        if (field == null && existingElement != null && swapExistingElement) {
            enclosing.swapElement(existingElement);
        }
        if ((enclosing instanceof RfFunction || enclosing instanceof RfActionBlock) && (kind == 1 || kind == 4)) {
            int n2 = kind = field == null || field.hasNoDefs(true) ? 4 : field.getFieldKind();
        }
        if (field != null) {
            boolean isImplementationOfExternFunctionArgument;
            if ((kind == 2 || kind == 256 || kind == 128 || kind == 8 || enclosing instanceof RfStruct) && field.hasNoDefs(true)) {
                enclosing.swapElement(field);
            }
            String prevInitialValue = field.getInitialValue(false);
            String initialValue = info.getInitialValue();
            if ((kind == 2 || kind == 256 || kind == 128) && this.fIncrementalDeltaContainer != null && (initialValue != null && !initialValue.equals(prevInitialValue) || initialValue == null && prevInitialValue != null)) {
                this.fIncrementalDeltaContainer.removeElement(field.getEnclosingScope());
            }
            boolean bl = isImplementationOfExternFunctionArgument = (kind & 2) != 0 && enclosing instanceof RfFunction && enclosing.isExtern() && allDefsSize > 0 && !((RfFunctionDef)parentDef).isPrototype();
            if (isImplementationOfExternFunctionArgument) {
                dataType = null;
            }
            field.init(dataType, kind, qualifiers, initialValue, isInParameterPortList, parameterKind);
        } else {
            if (existingElement != null && existingElement.isEnumRangeElement() && kind == 16) {
                ((RfFieldDef)fieldDef).addDataType(existingElement, defDataType);
                return existingElement;
            }
            field = (qualifiers & 0x800) != 0 || (qualifiers & 0x10) != 0 ? new RfPredefinedField(name, dataType, kind, qualifiers, info.getInitialValue(), info.getComment().getRawAboveComment()) : new RfField(name, isEscaped, dataType, kind, qualifiers, info.getInitialValue(), isInParameterPortList, parameterKind);
            enclosing.addMember(field);
        }
        field.setQualifiers(qualifiers);
        fieldDef = field.addDeclaration(fieldDef);
        field.setMacroZone(this.fCurrentMacroZone);
        this.fCurrentFileDef.addChildDef(fieldDef);
        ((RfFieldDef)fieldDef).addDataType(field, defDataType);
        return field;
    }

    public void startNet(WrapperInfo info) {
        int allDefsSize;
        RfDefElement fieldDef;
        RfDefElement foundElem;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        DataType dataType = info.getDataType();
        if (enclosing instanceof RfInstanceHolder && ((RfInstanceHolder)enclosing).isNonAnsi() && ((RfInstanceHolder)enclosing).hasNonAnsiPortName(info.getName())) {
            this.startPort(info, 0, false, null);
            return;
        }
        RfField field = enclosing.getLocalMember(RfField.class, info.getName(), false, false);
        if (field instanceof RfPort) {
            if (!field.hasNoDefs(true)) {
                DataType portDataType = field.getDataType();
                if (enclosing instanceof RfInstanceHolder && !((RfInstanceHolder)enclosing).isNonAnsi() && portDataType != null && (portDataType.getType() != null || portDataType.getNetType() != null)) {
                    field = null;
                } else {
                    this.startPort(info, ((RfPort)field).getPortKind(), false, null);
                    return;
                }
            }
            field = null;
        }
        if ((foundElem = this.fCurrentFileDef.findDefElement(fieldDef = new RfFieldDef(this.fCurrentFileDef, info, false))) != null) {
            fieldDef = foundElem;
            if (this.isAlreadyDefined(field, foundElem)) {
                this.fCurrentFileDef.addChildDef(fieldDef);
                return;
            }
        }
        int n = allDefsSize = field == null ? 0 : field.getDeclarations().size();
        if (field != null && field.isImplicitSignal()) {
            field = null;
        } else if (field instanceof RfPort) {
            field = allDefsSize > 2 ? null : field;
        } else if (field != null) {
            DataType fieldDataType = field.getDataType();
            if (dataType != null && dataType.getDirection() != 0 && fieldDataType != null && fieldDataType.getDirection() != 0) {
                field = null;
            } else if (this.isAmsSyntax(info)) {
                if (allDefsSize > 1) {
                    field = null;
                } else if (dataType != null && fieldDataType != null) {
                    if (fieldDataType.fDiscipline != null && dataType.fDiscipline != null) {
                        field = null;
                    }
                    if ((fieldDataType.fNetType != null || fieldDataType.fType != null) && dataType.fNetType != null) {
                        field = null;
                    }
                }
            } else if (this.isVerilogSyntax(info)) {
                if (allDefsSize > 0) {
                    field = null;
                } else if (fieldDataType != null && dataType != null) {
                    if (fieldDataType.fNetType != null && dataType.fNetType != null) {
                        field = null;
                    } else if (fieldDataType.fType != null && dataType.fType != null) {
                        field = null;
                    }
                }
            } else if (allDefsSize > 0) {
                field = null;
            } else if (dataType != null && fieldDataType != null && (fieldDataType.fNetType != null && dataType.fNetType != null || fieldDataType.fType != null && dataType.fType != null)) {
                field = null;
            }
        }
        if (field != null) {
            boolean update = false;
            if (field.isDirtyElement() && field.getEnclosingScope() == enclosing) {
                update = true;
            }
            field.init(dataType, 1, 1, info.getInitialValue());
            if (!update && field instanceof RfPort) {
                return;
            }
        } else {
            field = new RfField(info.getName(), info.isEscaped(), dataType, 1, 1, info.getInitialValue());
            enclosing.addMember(field);
        }
        field.setMacroZone(this.fCurrentMacroZone);
        fieldDef = field.addDeclaration(fieldDef);
        ((RfFieldDef)fieldDef).addDataType(field, info.getDataType());
        this.fCurrentFileDef.addChildDef(fieldDef);
    }

    public DefNamedElementPair startPort(WrapperInfo info, int portKind, boolean isInListOfPorts, RfDefElement parentFunctionDef) {
        return this.startPort(info, portKind, isInListOfPorts, false, parentFunctionDef);
    }

    public DefNamedElementPair startPort(WrapperInfo info, int portKind, boolean isInListOfPorts, boolean isInterface, RfDefElement parentFunctionDef) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        DataType dataType = info.getDataType();
        if (enclosing instanceof RfFunction) {
            this.startField(info, 2, 0, null, false, null, parentFunctionDef);
            return null;
        }
        if (!isInListOfPorts && portKind == 1 && enclosing instanceof RfInstanceHolder && ((RfInstanceHolder)enclosing).isNonAnsi() && !((RfInstanceHolder)enclosing).hasNonAnsiPortName(info.getName())) {
            this.startField(info, 1, 0, null, false, null, null);
            return null;
        }
        RfField portOrField = enclosing.getLocalMember(RfField.class, info.getName(), false, false);
        RfDefElement portDef = new RfPortDef(this.fCurrentFileDef, info, isInListOfPorts, false);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(portDef);
        if (foundElem != null) {
            portDef = foundElem;
            if (portOrField != null && this.isAlreadyDefined(portOrField, foundElem)) {
                this.fCurrentFileDef.addChildDef(portDef);
                return new DefNamedElementPair(portDef, portOrField);
            }
        }
        if (!isInterface && portKind == 1) {
            if (dataType.hasPackedDimension()) {
                portKind = 0;
                info.setPortKind(portKind);
            } else {
                DataType dataTypeWithoutUnpackedDimensions = dataType.copy();
                dataTypeWithoutUnpackedDimensions.setUnpackedDimension(null);
                RfAssociatedTypeWrapper potentialInterface = new RfAssociatedTypeWrapper(dataTypeWithoutUnpackedDimensions, enclosing);
                IRfNamedElement resolvedType = potentialInterface.getAssociatedTypeNoLastLevelParams();
                if (resolvedType == null || resolvedType instanceof RfInterface || resolvedType instanceof RfModport) {
                    dataType.setDirection(0);
                } else {
                    portKind = 0;
                    info.setPortKind(portKind);
                }
            }
        }
        if (portOrField != null && portOrField.isImplicitSignal()) {
            portOrField = null;
        }
        int existingDefsSize = portOrField == null ? 0 : portOrField.getDeclarations().size();
        boolean existingIsInListOfPorts = portOrField instanceof RfPort && !portOrField.hasNoDefs(true) && ((RfPortDef)portOrField.getDeclaration()).isInListOfPorts();
        byte existingPortKind = portOrField instanceof RfPort ? ((RfPort)portOrField).getBasePortKind() : (byte)0;
        boolean isNonAnsi = false;
        if (!(isInListOfPorts || portOrField != null && existingPortKind != 3)) {
            portKind = existingPortKind;
        } else if (portOrField instanceof RfPort) {
            if (isInListOfPorts) {
                if (existingIsInListOfPorts) {
                    if (!((RfPort)portOrField).isUnderAlias() || portOrField.hasNoDefs(true)) {
                        portDef = portOrField.addDeclaration(portDef);
                        this.fCurrentFileDef.addChildDef(portDef);
                    }
                    return new DefNamedElementPair(portDef, portOrField);
                }
            } else {
                boolean isAmsSyntax = this.isAmsSyntax(info);
                DataType portDataType = portOrField.getDataType();
                byte dataTypeDirection = 0;
                byte portDataTypeDirection = 0;
                boolean bl = isNonAnsi = !isAmsSyntax && enclosing instanceof RfInstanceHolder && ((RfInstanceHolder)enclosing).isNonAnsi() && existingIsInListOfPorts && portDataType.isEmpty() && !dataType.isEmpty();
                if (dataType != null && (dataTypeDirection = dataType.getDirection()) != 0 && portDataType != null && (portDataTypeDirection = portDataType.getDirection()) != 0 && dataTypeDirection != portDataTypeDirection) {
                    portOrField = null;
                } else if (isAmsSyntax) {
                    if (existingDefsSize > 2 + (existingIsInListOfPorts ? 1 : 0)) {
                        portOrField = null;
                    } else if (portDataType != null && dataType != null) {
                        if (portDataType.fDiscipline != null && dataType.fDiscipline != null) {
                            portOrField = null;
                        } else if (portDataType.fType != null && dataType.fType != null) {
                            portOrField = null;
                        } else if (portDataType.fNetType != null && dataType != null && dataType.fNetType != null) {
                            portOrField = null;
                        }
                    }
                } else if (this.isVerilogSyntax(info)) {
                    if (existingDefsSize > 1 + (existingIsInListOfPorts ? 1 : 0)) {
                        portOrField = null;
                    } else if (portDataType != null && dataType != null) {
                        if (portDataType.fType != null && dataType.fType != null) {
                            portOrField = null;
                        } else if (portDataType.fNetType != null && dataType != null && dataType.fNetType != null) {
                            portOrField = null;
                        }
                    }
                } else if (existingDefsSize > 1 + (existingIsInListOfPorts ? 1 : 0)) {
                    portOrField = null;
                } else if (dataType != null && portDataType != null && (portDataType.fType != null && dataType.fType != null || portDataType.fNetType != null && dataType.fNetType != null)) {
                    portOrField = null;
                }
                if (existingDefsSize > 0 && portOrField != null && portDataType != null && dataTypeDirection == portDataTypeDirection && portDataType.equals(dataType)) {
                    portOrField = null;
                }
            }
        } else {
            portOrField = null;
        }
        if (portOrField instanceof RfPort) {
            ((RfPort)portOrField).init(dataType, 1, portKind, 1, info.getInitialValue());
            if (existingDefsSize == 0) {
                enclosing.swapElement(portOrField);
            }
            if (portOrField instanceof RfModportPort) {
                ((RfModportPort)portOrField).setHierarchicalExpr(info.getHidObject());
            }
        } else {
            portOrField = enclosing instanceof RfModport || enclosing instanceof RfClockingBlock ? new RfModportPort(info.getName(), info.isEscaped(), dataType, portKind, info.getHidObject()) : new RfPort(info.getName(), info.isEscaped(), dataType, portKind, info.getInitialValue());
            enclosing.addMember(portOrField);
        }
        ((RfPort)portOrField).setMacroZone(this.fCurrentMacroZone, isNonAnsi);
        portDef = portOrField.addDeclaration(portDef);
        this.fCurrentFileDef.addChildDef(portDef);
        ((RfFieldDef)portDef).addDataType(portOrField, info.getDataType());
        return new DefNamedElementPair(portDef, portOrField);
    }

    public void setTimeUnit(HidImplicit value) {
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing instanceof RfModule) {
            ((RfModule)enclosing).setLocalTimeunit(value);
        } else if (enclosing instanceof RfInterface) {
            ((RfInterface)enclosing).setLocalTimeunit(value);
        } else if (enclosing instanceof RfProgram) {
            ((RfProgram)enclosing).setLocalTimeunit(value);
        } else if (enclosing instanceof RfPackage) {
            ((RfPackage)enclosing).setLocalTimeunit(value);
        } else if (enclosing instanceof RfLibrary) {
            ((RfLibrary)enclosing).setLocalTimeunit(value);
        }
    }

    public void setTimePrecision(HidImplicit value) {
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing instanceof RfModule) {
            ((RfModule)enclosing).setLocalTimeprecision(value);
        } else if (enclosing instanceof RfInterface) {
            ((RfInterface)enclosing).setLocalTimeprecision(value);
        } else if (enclosing instanceof RfProgram) {
            ((RfProgram)enclosing).setLocalTimeprecision(value);
        } else if (enclosing instanceof RfPackage) {
            ((RfPackage)enclosing).setLocalTimeprecision(value);
        } else if (enclosing instanceof RfLibrary) {
            ((RfLibrary)enclosing).setLocalTimeprecision(value);
        }
    }

    public DefNamedElementPair startCoverpoint(WrapperInfo info, String varName, IHidObject coverpointExpr) {
        boolean isAnonymous;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing == null || !(enclosing instanceof RfCovergroup)) {
            return null;
        }
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        boolean bl = isAnonymous = name != null && name.length() == 0 && varName != null;
        if (isAnonymous) {
            name = DVTStringUtil.unescapeIdentifier((String)varName, (boolean)true);
            isEscaped = name != null && varName != null && varName.length() > name.length();
        }
        RfCoverpoint coverpoint = ((RfCovergroup)enclosing).getLocalMember(RfCoverpoint.class, name, false);
        RfDefElement coverpointDef = new RfCoverpointDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(coverpointDef);
        if (foundElem != null) {
            coverpointDef = foundElem;
            if (this.isAlreadyDefined(coverpoint, foundElem)) {
                this.increaseDuplicateScope(coverpoint);
                this.pushScope(coverpointDef, coverpoint);
                return new DefNamedElementPair(coverpointDef, coverpoint);
            }
        }
        coverpoint = coverpoint == null || !coverpoint.hasNoDefs(true) ? null : coverpoint;
        DataType dataType = info.getDataType();
        if (coverpoint == null) {
            coverpoint = new RfCoverpoint(name, isEscaped, dataType);
            ((RfCovergroup)enclosing).addMember(coverpoint);
        } else {
            coverpoint.init(dataType);
        }
        coverpoint.setAnonymous(isAnonymous);
        coverpoint.setMacroZone(this.fCurrentMacroZone);
        coverpoint.setExpression(coverpointExpr);
        coverpoint.setQualifiers(coverpoint.getQualifiers() | 0x8000);
        coverpointDef = coverpoint.addDeclaration(coverpointDef);
        this.pushScope(coverpointDef, coverpoint);
        ((RfFieldDef)coverpointDef).addDataType(coverpoint, dataType);
        return new DefNamedElementPair(coverpointDef, coverpoint);
    }

    public void endCoverpoint(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        this.popScope(fileInstance, namedElement);
    }

    public DefNamedElementPair startCovercross(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing == null || !(enclosing instanceof RfCovergroup)) {
            return null;
        }
        RfCoverpoint covercross = ((RfCovergroup)enclosing).getLocalMember(RfCoverpoint.class, info.getName(), false);
        RfDefElement covercrossDef = new RfCovercrossDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(covercrossDef);
        if (foundElem != null) {
            covercrossDef = foundElem;
            if (this.isAlreadyDefined(covercross, foundElem)) {
                this.increaseDuplicateScope(covercross);
                this.pushScope(covercrossDef, covercross);
                return new DefNamedElementPair(covercrossDef, covercross);
            }
        }
        covercross = covercross == null || !covercross.hasNoDefs(true) ? null : covercross;
        DataType dataType = info.getDataType();
        if (covercross == null) {
            covercross = new RfCovercross(info.getName(), info.isEscaped());
            ((RfCovergroup)enclosing).addMember(covercross);
        } else {
            covercross.init(dataType);
        }
        covercross.setMacroZone(this.fCurrentMacroZone);
        covercrossDef = covercross.addDeclaration(covercrossDef);
        this.pushScope(covercrossDef, covercross);
        ((RfFieldDef)covercrossDef).addDataType(covercross, dataType);
        return new DefNamedElementPair(covercrossDef, covercross);
    }

    public void endCovercross(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, IHidObject crossItems, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        if (namedElement instanceof RfCoverpoint) {
            ((RfCoverpoint)namedElement).setExpression(crossItems);
        }
        this.popScope(fileInstance, namedElement);
    }

    public RfCoverbin startCoverbin(WrapperInfo info, boolean isWildcard, boolean isArray, int kind, IHidObject arraySizeExpression, ArrayList<IHidObject> binsExpressions, IHidObject withExpression, IHidObject iffExpression) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing == null || !(enclosing instanceof RfCoverpoint)) {
            return null;
        }
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        RfCoverbin coverbin = ((RfCoverpoint)enclosing).getLocalMember(RfCoverbin.class, name, false);
        RfDefElement coverbinDef = new RfCoverbinDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(coverbinDef);
        if (foundElem != null) {
            coverbinDef = foundElem;
            if (coverbin != null && this.isAlreadyDefined(coverbin, foundElem)) {
                this.fCurrentFileDef.addChildDef(coverbinDef);
                return coverbin;
            }
        }
        RfCoverbin rfCoverbin = coverbin = coverbin == null || !coverbin.hasNoDefs(true) ? null : coverbin;
        if (coverbin == null) {
            coverbin = new RfCoverbin(name, isEscaped, isWildcard, isArray, kind);
            enclosing.addMember(coverbin);
        } else {
            coverbin.init(isWildcard, isArray, kind);
        }
        coverbin.setArraySizeExpression(arraySizeExpression);
        coverbin.setBinsExpressions(binsExpressions);
        coverbin.setWithExpression(withExpression);
        coverbin.setIffExpression(iffExpression);
        coverbin.setMacroZone(this.fCurrentMacroZone);
        coverbin.setQualifiers(coverbin.getQualifiers() | 0x8000);
        coverbinDef = coverbin.addDeclaration(coverbinDef);
        this.fCurrentFileDef.addChildDef(coverbinDef);
        return coverbin;
    }

    public DefNamedElementPair startModport(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        RfModport modport = enclosing.getLocalMember(RfModport.class, info.getName(), false, this.fIncrementalBuild);
        RfDefElement modportDef = new RfModportDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(modportDef);
        if (foundElem != null) {
            modportDef = foundElem;
            if (this.isAlreadyDefined(modport, foundElem)) {
                this.increaseDuplicateScope(modport);
                this.pushScope(modportDef, modport);
                return new DefNamedElementPair(modportDef, modport);
            }
        }
        RfModport rfModport = modport = modport == null || !modport.hasNoDefs(true) ? null : modport;
        if (modport == null) {
            modport = new RfModport(info.getName(), info.isEscaped());
            enclosing.addMember(modport);
        }
        modport.setMacroZone(this.fCurrentMacroZone);
        modportDef = modport.addDeclaration(modportDef);
        this.pushScope(modportDef, modport);
        return new DefNamedElementPair(modportDef, modport);
    }

    public void endModport(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, Set<String> clockingNames) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement modport = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, modport);
            return;
        }
        def.setEndOffset(endInfo);
        ((RfModport)modport).init(clockingNames);
        this.popScope(fileInstance, modport);
    }

    public DefNamedElementPair startStructUnion(WrapperInfo info, boolean packed, boolean soft, int sign) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfStruct structUnion = enclosing.getLocalMember(RfStruct.class, name, false, this.fIncrementalBuild);
        RfDefElement structUnionDef = new RfStructDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(structUnionDef);
        if (foundElem != null) {
            structUnionDef = foundElem;
            if (this.isAlreadyDefined(structUnion, foundElem)) {
                this.increaseDuplicateScope(structUnion);
                this.pushScope(structUnionDef, structUnion);
                return new DefNamedElementPair(structUnionDef, structUnion);
            }
        }
        RfStruct rfStruct = structUnion = structUnion == null || !structUnion.hasNoDefs(true) ? null : structUnion;
        if (structUnion != null) {
            structUnion.initStructUnion(packed, sign);
        } else {
            structUnion = new RfStruct(name, enclosing, sign, packed, info.isEscaped());
            enclosing.addMember(structUnion);
        }
        structUnionDef = structUnion.addDeclaration(structUnionDef);
        structUnion.setMacroZone(this.fCurrentMacroZone);
        this.pushScope(structUnionDef, structUnion);
        return new DefNamedElementPair(structUnionDef, structUnion);
    }

    public void endStructUnion(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement);
            return;
        }
        def.setEndOffset(endInfo);
        this.popScope(fileInstance, namedElement);
    }

    public DefNamedElementPair startEnum(WrapperInfo info, DataType enumDataType) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfStruct rfEnum = enclosing.getLocalMember(RfStruct.class, name, false, this.fIncrementalBuild);
        RfDefElement enumDef = new RfStructDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(enumDef);
        if (foundElem != null) {
            enumDef = foundElem;
            if (this.isAlreadyDefined(rfEnum, foundElem)) {
                this.increaseDuplicateScope(rfEnum);
                this.pushScope(enumDef, rfEnum);
                return new DefNamedElementPair(enumDef, rfEnum);
            }
        }
        RfStruct rfStruct = rfEnum = rfEnum == null || !rfEnum.hasNoDefs(true) ? null : rfEnum;
        if (rfEnum == null) {
            rfEnum = new RfStruct(name, enclosing, 2, false, info.isEscaped());
            enclosing.addMember(rfEnum);
        }
        enumDef = rfEnum.addDeclaration(enumDef);
        rfEnum.setMacroZone(this.fCurrentMacroZone);
        rfEnum.initEnum(enumDataType);
        this.pushScope(enumDef, rfEnum);
        return new DefNamedElementPair(enumDef, rfEnum);
    }

    public void endEnum(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        this.popScope(fileInstance, namedElement);
    }

    public DefNamedElementPair startActionBlock(WrapperInfo info, String expression, boolean isAllSensitivityList) {
        return this.startActionBlock(info, expression, 0, isAllSensitivityList);
    }

    public DefNamedElementPair startActionBlock(WrapperInfo info) {
        return this.startActionBlock(info, null, 0, false);
    }

    public DefNamedElementPair startActionBlock(WrapperInfo info, String expression, int uniquePriority, boolean isAllSensitivityList) {
        RfDefElement blockDef;
        RfDefElement foundElem;
        RfActionBlock block;
        boolean isNotDuplicateScope;
        boolean isAnonymous;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        LineInfo startInfo = info.getStartInfo();
        String actionBlockName = info.getName();
        boolean isEscaped = info.isEscaped();
        boolean bl = isAnonymous = actionBlockName == null || actionBlockName.isEmpty();
        if (isAnonymous) {
            actionBlockName = "@" + info.getParserPath() + '@' + startInfo;
            isEscaped = false;
        }
        long blockQualifiers = info.getBlockType() != null ? info.getBlockType().value() : 0L;
        String oldActionBlockName = actionBlockName;
        boolean isOldActionBlockName = false;
        boolean bl2 = isNotDuplicateScope = this.getCountDuplicateScopes() == 0;
        if (this.fIncrementalDeltaContainer != null && isNotDuplicateScope && this.fIncrementalDeltaContainer.anonymousNewToOldNameMap.get(actionBlockName) != null) {
            oldActionBlockName = this.fIncrementalDeltaContainer.anonymousNewToOldNameMap.get(actionBlockName);
            isOldActionBlockName = true;
        }
        if (oldActionBlockName == null) {
            oldActionBlockName = actionBlockName;
        }
        if ((block = enclosing.getLocalMember(RfActionBlock.class, oldActionBlockName, false, this.fIncrementalBuild)) != null && isOldActionBlockName) {
            enclosing.removeMember(block);
            block.setName(actionBlockName, false);
            enclosing.addMember(block);
        }
        if ((foundElem = this.fCurrentFileDef.findDefElement(blockDef = new RfActionBlockDef(this.fCurrentFileDef, info))) != null) {
            blockDef = foundElem;
            if (this.isAlreadyDefined(block, foundElem)) {
                this.increaseDuplicateScope(block);
                this.pushScope(blockDef, block);
                return new DefNamedElementPair(blockDef, block);
            }
        }
        RfActionBlock rfActionBlock = block = block == null || !block.hasNoDefs(true) ? null : block;
        if (block == null) {
            block = isAnonymous ? new RfActionBlock(actionBlockName, isEscaped, blockQualifiers, enclosing, expression, uniquePriority, isAllSensitivityList) : new RfNamedActionBlock(actionBlockName, isEscaped, blockQualifiers, enclosing, expression, uniquePriority, isAllSensitivityList);
            enclosing.addMember(block);
        } else {
            block.init(blockQualifiers, expression, uniquePriority, isAllSensitivityList);
        }
        blockDef = block.addDeclaration(blockDef);
        block.setMacroZone(this.fCurrentMacroZone);
        this.pushScope(blockDef, block);
        return new DefNamedElementPair(blockDef, block);
    }

    public void endActionBlock(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, int endLabel) {
        this.endActionBlock(fileInstance, defNamedElementPair, endInfo, null, 0, null, endLabel);
    }

    public void endActionBlock(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, IRfActionBlockElement.BlockQualifier blockType, int nofStatements, String expression, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement actionBlock = defNamedElementPair.getNamedElement();
        if (!(actionBlock instanceof RfActionBlock) || defNamedElementPair.getNamedBeginForkReplacement() != null) {
            return;
        }
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, actionBlock);
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        if (blockType != null) {
            ((RfActionBlock)actionBlock).addBlockQualifier(blockType.value());
        }
        if (nofStatements != 0) {
            ((RfActionBlock)actionBlock).setNofStatements(nofStatements);
        }
        if (expression != null && !expression.isEmpty()) {
            ((RfActionBlock)actionBlock).setExpression(expression);
        }
        if (fileInstance == null) {
            return;
        }
        this.popScope(fileInstance, actionBlock);
    }

    public DefNamedElementPair startBeginForkActionBlock(WrapperInfo info, DefNamedElementPair inlineBlockDefNamedPair) {
        if (inlineBlockDefNamedPair == null || inlineBlockDefNamedPair.getDefElement() == null) {
            return this.startActionBlock(info, null, 0, false);
        }
        if (info.getName() == null || info.getName().isEmpty() || info.getLabelInfo() == null) {
            return inlineBlockDefNamedPair;
        }
        RfActionBlock inlineBlockElement = (RfActionBlock)inlineBlockDefNamedPair.getNamedElement();
        RfActionBlockDef inlineBlockDef = (RfActionBlockDef)inlineBlockDefNamedPair.getDefElement();
        RfProject.popScope(this.fCurrentFileDef, this.fBuildScope, inlineBlockElement);
        LineInfo startLineInfo = info.getStartInfo();
        startLineInfo.realOffset = info.getLabelInfo().realOffset;
        startLineInfo.line = info.getLabelInfo().line;
        startLineInfo.virtOffset = info.getLabelInfo().virtOffset;
        DefNamedElementPair newBlockDefNamedPair = this.startActionBlock(info, null, 0, false);
        if (newBlockDefNamedPair != null) {
            RfActionBlock newBlockElement = (RfActionBlock)newBlockDefNamedPair.getNamedElement();
            if (this.getCountDuplicateScopes() == 0) {
                newBlockElement.copyFrom(inlineBlockElement);
                newBlockDefNamedPair.setDefElementComment(inlineBlockDef.getCommentBlock());
            }
            inlineBlockElement.clean(inlineBlockDef);
            inlineBlockDefNamedPair.setNamedBeginForkReplacement(newBlockDefNamedPair);
        }
        return newBlockDefNamedPair;
    }

    public void endBeginForkActionBlock(IDVTFileInstance fileInstance, LineInfo endInfo, DefNamedElementPair defNamedElementPair, DefNamedElementPair inlineBlockDefNamedPair, IRfActionBlockElement.BlockQualifier blockType, int nofStatements, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        def.setEndLabel(endLabel);
        if (inlineBlockDefNamedPair == null) {
            this.endActionBlock(fileInstance, defNamedElementPair, endInfo, blockType, nofStatements, null, endLabel);
            return;
        }
        RfDefElement inlineBlockDef = inlineBlockDefNamedPair.getDefElement();
        if (inlineBlockDef == null || def != inlineBlockDef) {
            this.endActionBlock(fileInstance, defNamedElementPair, endInfo, blockType, nofStatements, null, endLabel);
        } else if (def == inlineBlockDef) {
            RfNamedElement actionBlock = defNamedElementPair.getNamedElement();
            if (!(actionBlock instanceof RfActionBlock)) {
                return;
            }
            if (blockType != null) {
                ((RfActionBlock)actionBlock).addBlockQualifier(blockType.value());
            }
            if (nofStatements != 0) {
                ((RfActionBlock)actionBlock).setNofStatements(nofStatements);
            }
        }
    }

    public DefNamedElementPair startCovergroup(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        boolean isEmbeddedDef = enclosing instanceof RfClass;
        String name = info.getName();
        String key = String.valueOf(isEmbeddedDef ? "covergroup@" : "") + name;
        RfCovergroup covergroup = enclosing.getLocalMember(RfCovergroup.class, key, false, this.fIncrementalBuild);
        RfDefElement covergroupDef = new RfCovergroupDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(covergroupDef);
        if (foundElem != null) {
            covergroupDef = foundElem;
            if (this.isAlreadyDefined(covergroup, foundElem)) {
                this.increaseDuplicateScope(covergroup);
                this.pushScope(covergroupDef, covergroup);
                return new DefNamedElementPair(covergroupDef, covergroup);
            }
        }
        RfCovergroup rfCovergroup = covergroup = covergroup == null || !covergroup.hasNoDefs(true) ? null : covergroup;
        if (covergroup == null) {
            covergroup = new RfCovergroup(name, info.isEscaped(), isEmbeddedDef, info.getArgumentInfos());
            enclosing.addMember(covergroup);
        } else {
            covergroup.init(info.getArgumentInfos());
        }
        if (isEmbeddedDef) {
            this.startField(new WrapperInfo(info.getName(), info.getFileInstance(), info.getMacroZone(), info.getStartInfo(), info.getStartInfo(), info.getComment(), new DataType(key)), 1, 0, null, false, null, covergroupDef);
        }
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(key);
        }
        covergroup.setMacroZone(this.fCurrentMacroZone);
        covergroupDef = covergroup.addDeclaration(covergroupDef);
        this.pushScope(covergroupDef, covergroup);
        List<ArgInfo> arguments = info.getArgumentInfos();
        if (arguments == null || arguments.isEmpty()) {
            return new DefNamedElementPair(covergroupDef, covergroup);
        }
        DataType prevDataType = null;
        for (ArgInfo argInfo : arguments) {
            DataType currDataType = argInfo.getDataType();
            if (currDataType != null) {
                currDataType.updateImplicit(prevDataType);
            }
            this.startField(new WrapperInfo(argInfo.getName(), info.getFileInstance(), info.getMacroZone(), null, argInfo.getStartInfo(), argInfo.getStartInfo(), null, argInfo.getInitialValue(), currDataType), 2, 0, null, false, null, null);
            prevDataType = currDataType;
        }
        return new DefNamedElementPair(covergroupDef, covergroup);
    }

    public void endCovergroup(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, String eventName, LineInfo endInfo, CommentBlock comment, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement lastNamedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, lastNamedElement);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        def.setEndLabel(endLabel);
        ((RfCovergroup)lastNamedElement).setEventName(eventName);
        this.popScope(fileInstance, lastNamedElement);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
    }

    public RfInstance startInstance(WrapperInfo info, int qualifiers) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.getDesignElementScope();
        String instanceKey = info.getName();
        RfInstance instance = null;
        RfDefElement instanceDef = new RfInstanceDef(this.fCurrentFileDef, info, false);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(instanceDef);
        boolean needBindUpdate = false;
        RfLibrary currentLibrary = this.fBuildScope.getCurrentLibrary();
        if (info.getTargetScope() != null || info.getTargetInstances() != null) {
            List<RfInstance> instances = currentLibrary.getBindInstances(info.getName(), enclosing, false);
            if (instances != null) {
                instanceKey = instanceKey + "[" + info.getTargetScope() + ":" + info.getTargetInstances() + "]";
                for (RfInstance bindInstance : instances) {
                    String bindInstanceKey = bindInstance.getName() + "[" + bindInstance.getTargetScope() + ":" + bindInstance.getTargetInstances() + "]";
                    if (instanceKey.equals(bindInstanceKey)) {
                        instance = bindInstance;
                    } else {
                        if (!info.getName().equals(bindInstance.getName())) continue;
                        if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && info.getTargetScope() != null && !info.getTargetScope().equals(bindInstance.getTargetScope()) || info.getTargetInstances() != null && !info.getTargetInstances().equals(bindInstance.getTargetInstances())) {
                            needBindUpdate = true;
                        }
                    }
                    break;
                }
            }
        } else {
            instance = enclosing.getLocalMember(RfInstance.class, instanceKey, false, this.fIncrementalBuild);
        }
        if (foundElem != null) {
            instanceDef = foundElem;
            if (instance != null && this.isAlreadyDefined(instance, foundElem)) {
                this.fCurrentFileDef.addChildDef(instanceDef);
                return instance;
            }
        }
        RfInstance rfInstance = instance = instance == null || !instance.hasNoDefs(true) ? null : instance;
        if (instance != null) {
            DataType newDataType = info.getDataType();
            instance.init(newDataType, info.getTargetScope(), info.getTargetInstances());
        } else {
            if (info.getTargetScope() != null || info.getTargetInstances() != null) {
                currentLibrary.cleanBindInstances(info.getName());
            }
            if ((instance = RfInstance.create(info.getName(), info.isEscaped(), info.getDataType(), 0, info.getTargetScope(), info.getTargetInstances())).isInstanceToBind()) {
                if (this.fIncrementalDeltaContainer != null && needBindUpdate) {
                    this.fIncrementalDeltaContainer.changedDataTypeElements.add(instance);
                }
                currentLibrary.addBindInstance(instance, enclosing);
            } else {
                enclosing.addMember(instance);
            }
        }
        instance.setMacroZone(this.fCurrentMacroZone);
        instance.setQualifiers(qualifiers);
        instanceDef = instance.addDeclaration(instanceDef);
        this.fCurrentFileDef.addChildDef(instanceDef);
        ((RfFieldDef)instanceDef).addDataType(instance, info.getDataType());
        return instance;
    }

    public DefNamedElementPair startGenerateBlock(WrapperInfo info, String expression, boolean isOptionalBranch) {
        RfGenerateBlock block;
        String generateBlockName;
        List<RfNamedElement> namedElements;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        boolean isEscaped = info.isEscaped();
        long blockQualifier = info.getBlockType() != null ? info.getBlockType().value() : 0L;
        RfNamedElement enclosing = this.fBuildScope.getScope();
        RfDefElement enclosingDef = enclosing.getDeclaration();
        RfGenerateHolderDef holderDef = enclosingDef instanceof RfGenerateHolderDef ? (RfGenerateHolderDef)enclosingDef : null;
        RfDefElement blockDef = new RfGenerateBlockDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(blockDef);
        if (foundElem != null && (namedElements = (blockDef = foundElem).getNamedElements()) != null && !namedElements.isEmpty()) {
            for (RfNamedElement potentialBlock : namedElements) {
                if (!(potentialBlock instanceof RfGenerateBlock) || potentialBlock.getEnclosingScope() != enclosing) continue;
                this.increaseDuplicateScope(potentialBlock);
                this.pushScope(blockDef, potentialBlock, true);
                return new DefNamedElementPair(blockDef, potentialBlock);
            }
        }
        boolean isAnonymous = info.getName() == null;
        String blockUniqueName = RfGenerateBlock.generateUniqueName(info.getParserPath(), info.getStartLine(), info.getStartRealOffset(), info.getStartVirtualOffset());
        if (isAnonymous) {
            generateBlockName = blockUniqueName;
            RfDefElement enclosingDeclaration = enclosing.getDeclaration();
            if (enclosingDeclaration instanceof RfGenerateHolderDef) {
                ((RfGenerateHolderDef)enclosingDeclaration).setHasImplicitGenerateBlocks(true);
            }
        } else {
            generateBlockName = info.getName();
        }
        int generateConstructIndex = -1;
        if (!this.fIncrementalBuild || holderDef == null || !holderDef.hasImplicitIncludedGenerateBlocks()) {
            int n = generateConstructIndex = isOptionalBranch ? this.fBuildScope.getGenerateConstructIndex() : this.fBuildScope.incrementAndGetGenerateConstructIndex();
            if (generateConstructIndex == -1) {
                generateConstructIndex = RfProject.fallbackGetGenerateConstructIndex(enclosing, isOptionalBranch);
            }
        }
        RfGenerateBlock rfGenerateBlock = block = this.fIncrementalBuild ? enclosing.getLocalMember(RfGenerateBlock.class, blockUniqueName, false, true) : null;
        if (block == null) {
            block = new RfGenerateBlock(generateBlockName, isEscaped, blockQualifier, expression, isOptionalBranch, generateConstructIndex, isAnonymous);
        } else {
            enclosing.removeMember(block);
            block.init(generateBlockName, isEscaped, blockQualifier, expression, isOptionalBranch, generateConstructIndex, isAnonymous);
            this.checkIfExistImplicitIncludedGenerateBlocks(block, blockDef);
        }
        enclosing.addMember(block);
        block.setMacroZone(this.fCurrentMacroZone);
        blockDef = block.addDeclaration(blockDef);
        this.pushScope(blockDef, block, true);
        return new DefNamedElementPair(blockDef, block);
    }

    private static int fallbackGetGenerateConstructIndex(RfNamedElement enclosing, boolean isOptionalBranch) {
        int index = 0;
        List<RfGenerateBlock> generateBlocks = enclosing.getLocalMembers(RfGenerateBlock.class);
        if (generateBlocks != null && !generateBlocks.isEmpty()) {
            for (RfGenerateBlock generateBlock : generateBlocks) {
                if (generateBlock.getDeclaration() == null || generateBlock.isOptionalBranch()) continue;
                ++index;
            }
        }
        return index += isOptionalBranch ? 0 : 1;
    }

    public void endGenerateBlock(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, IRfActionBlockElement.BlockQualifier blockQualifier, String expression, int endLabel) {
        if (defNamedElementPair == null || fileInstance == null) {
            return;
        }
        RfNamedElement namedElement = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, namedElement, true);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        def.setDefComment(comment);
        if (namedElement instanceof RfGenerateBlock) {
            if (expression != null && !expression.isEmpty()) {
                ((RfGenerateBlock)namedElement).setExpression(expression);
            }
            if (blockQualifier != null) {
                ((RfGenerateBlock)namedElement).addBlockQualifier(blockQualifier.value());
            }
        }
        this.popScope(fileInstance, namedElement, true);
        this.resolveLocalImplicitGenerateBlocksInElement(def, namedElement);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DefNamedElementPair startConstraint(WrapperInfo info, int qualifiers, boolean prototype) {
        block14: {
            constraintName = info.getName();
            if (constraintName == null) {
                return null;
            }
            this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
            this.fCurrentMacroZone = info.getMacroZone();
            isEscaped = info.isEscaped();
            if (isEscaped) {
                v0 = new String[1];
                v1 = v0;
                v0[0] = constraintName;
            } else {
                v1 = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)constraintName);
            }
            qualifiedName = v1;
            enclosing = enclosingScope = this.fBuildScope.getScope();
            if (qualifiedName.length < 2) break block14;
            constraintName = qualifiedName[qualifiedName.length - 1];
            i = 0;
            while (i < qualifiedName.length - 1) {
                block16: {
                    block17: {
                        block15: {
                            if (i != 0 || qualifiedName.length <= 2 || (candidate /* !! */  = enclosing.getPackageWithPrefix(qualifiedName[i], 1)) == null) break block15;
                            enclosing = candidate /* !! */ ;
                            break block16;
                        }
                        candidate /* !! */  = enclosing.getClassWithPrefix(qualifiedName[i], 1, 3);
                        if (candidate /* !! */  == null && (typeAlias = enclosingScope.getTypeAliasWithPrefix(qualifiedName[i], 1, 3, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null && (translatedType = typeAlias.getTranslatedType()) instanceof RfClass) {
                            candidate /* !! */  = (RfClass)translatedType;
                        }
                        if (candidate /* !! */  != null) break block17;
                        fragment = enclosingScope.getLocalMember(RfFragment.class, qualifiedName[i], false, this.fIncrementalBuild);
                        fragmentDef /* !! */  = new RfFragmentDef(this.fCurrentFileDef, info.getStartInfo(), info.getEndInfo());
                        foundElem = this.fCurrentFileDef.findDefElement(fragmentDef /* !! */ );
                        if (foundElem == null) ** GOTO lbl-1000
                        fragmentDef /* !! */  = foundElem;
                        if (this.isAlreadyDefined(fragment, foundElem)) {
                            this.fCurrentFileDef.addChildDef(fragmentDef /* !! */ );
                            enclosing = fragment;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (fragment == null) {
                                fragment = new RfFragment(qualifiedName[i], isEscaped);
                                enclosing.addMember(fragment);
                            }
                            fragmentDef /* !! */  = fragment.addDeclaration(fragmentDef /* !! */ );
                            this.fCurrentFileDef.addChildDef(fragmentDef /* !! */ );
                            enclosing = fragment;
                        }
                        break block16;
                    }
                    enclosing = candidate /* !! */ ;
                }
                ++i;
            }
        }
        constraint = enclosing.getLocalMember(RfConstraint.class, constraintName, false, this.fIncrementalBuild);
        constraintDef = new RfConstraintDef(this.fCurrentFileDef, info, qualifiedName.length > 2);
        foundElem = this.fCurrentFileDef.findDefElement(constraintDef);
        if (foundElem != null) {
            constraintDef = foundElem;
            if (this.isAlreadyDefined(constraint, foundElem)) {
                this.increaseDuplicateScope(constraint);
                this.pushScope(constraintDef, constraint);
                return new DefNamedElementPair(constraintDef, constraint);
            }
        }
        v2 = externDeclaration = enclosing != enclosingScope && (enclosing instanceof RfClass != false || enclosing instanceof RfFragment != false);
        if (constraint != null) {
            if (!externDeclaration) {
                constraint.init(qualifiers);
            }
        } else {
            constraint = new RfConstraint(constraintName, isEscaped, qualifiers);
            enclosing.addMember(constraint);
        }
        constraintDef.setOutOfClassDefinition(externDeclaration);
        ((RfConstraintDef)constraintDef).setPrototype(externDeclaration == false & prototype);
        addedConstraintDef = constraint.addDeclaration(constraintDef);
        if (addedConstraintDef != constraintDef && addedConstraintDef instanceof RfConstraintDef) {
            constraintDef = addedConstraintDef;
            ((RfConstraintDef)constraintDef).setOutOfClassDefinition(externDeclaration);
            ((RfConstraintDef)constraintDef).setPrototype(externDeclaration == false & prototype);
        }
        constraint.setMacroZone(this.fCurrentMacroZone);
        this.pushScope(constraintDef, constraint);
        return new DefNamedElementPair(constraintDef, constraint);
    }

    public void endConstraint(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement constraint = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, constraint);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        this.popScope(fileInstance, constraint);
    }

    public DefNamedElementPair startPropertySequence(WrapperInfo info, int kind) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        RfPropertySequence propSeq = enclosing.getLocalMember(RfPropertySequence.class, info.getName(), false, this.fIncrementalBuild);
        RfDefElement propSeqDef = new RfPropertySequenceDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(propSeqDef);
        if (foundElem != null) {
            propSeqDef = foundElem;
            if (this.isAlreadyDefined(propSeq, foundElem)) {
                this.increaseDuplicateScope(propSeq);
                this.pushScope(propSeqDef, propSeq);
                return new DefNamedElementPair(propSeqDef, propSeq);
            }
        }
        RfPropertySequence rfPropertySequence = propSeq = propSeq == null || !propSeq.hasNoDefs(true) ? null : propSeq;
        if (propSeq == null) {
            propSeq = new RfPropertySequence(info.getName(), info.isEscaped(), kind);
            enclosing.addMember(propSeq);
        }
        propSeq.setMacroZone(this.fCurrentMacroZone);
        propSeqDef = propSeq.addDeclaration(propSeqDef);
        this.pushScope(propSeqDef, propSeq);
        List<ArgInfo> arguments = info.getArgumentInfos();
        if (arguments == null || arguments.isEmpty()) {
            return new DefNamedElementPair(propSeqDef, propSeq);
        }
        DataType prevDataType = null;
        for (ArgInfo argInfo : arguments) {
            DataType currDataType = argInfo.getDataType();
            if (currDataType != null) {
                currDataType.updateImplicit(prevDataType);
            }
            this.startField(new WrapperInfo(argInfo.getName(), info.getFileInstance(), info.getMacroZone(), argInfo.getStartInfo(), argInfo.getStartInfo(), null, currDataType), 2, 0, null, false, null, null);
            prevDataType = currDataType;
        }
        return new DefNamedElementPair(propSeqDef, propSeq);
    }

    public void endPropertySequence(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement property = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, property);
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, property);
    }

    public DefNamedElementPair startClockingBlock(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        boolean isEscaped = info.isEscaped();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfClockingBlock clockingBlk = enclosing.getLocalMember(RfClockingBlock.class, name, false, this.fIncrementalBuild);
        RfDefElement clockingBlkDef = new RfClockingBlockDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(clockingBlkDef);
        if (foundElem != null) {
            clockingBlkDef = foundElem;
            if (this.isAlreadyDefined(clockingBlk, foundElem)) {
                this.increaseDuplicateScope(clockingBlk);
                this.pushScope(clockingBlkDef, clockingBlk);
                return new DefNamedElementPair(clockingBlkDef, clockingBlk);
            }
        }
        RfClockingBlock rfClockingBlock = clockingBlk = clockingBlk == null || !clockingBlk.hasNoDefs(true) ? null : clockingBlk;
        if (clockingBlk == null) {
            clockingBlk = new RfClockingBlock(name, isEscaped, null);
            enclosing.addMember(clockingBlk);
        }
        clockingBlk.setMacroZone(this.fCurrentMacroZone);
        clockingBlkDef = clockingBlk.addDeclaration(clockingBlkDef);
        this.pushScope(clockingBlkDef, clockingBlk);
        return new DefNamedElementPair(clockingBlkDef, clockingBlk);
    }

    public void endClocking(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, Set<String> signals, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement clocking = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, clocking);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setEndLabel(endLabel);
        ((RfClockingBlock)clocking).init(signals);
        this.popScope(fileInstance, clocking);
    }

    public DefNamedElementPair startFunctionCall(WrapperInfo info, int kind, boolean hasParentheses, boolean isDynamicArrayNew, String select, boolean with) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        select = DVTStringUtil.intern((String)select);
        RfFunctionCall functionCall = new RfFunctionCall(info.getLValue(), info.getName(), info.isEscaped(), info.getArgumentValues(), kind, hasParentheses, isDynamicArrayNew, select, with);
        this.fBuildScope.getScope().addFunctionCall(functionCall);
        RfDefElement functionCallDef = new RfFunctionCallDef(this.fCurrentFileDef, info);
        functionCallDef = functionCall.addDeclaration(functionCallDef);
        this.fCurrentFileDef.addChildDef(functionCallDef);
        if (functionCall.hasWith()) {
            this.pushScope(functionCallDef, functionCall);
        }
        functionCall.setMacroZone(this.fCurrentMacroZone);
        return new DefNamedElementPair(functionCallDef, functionCall);
    }

    public void endFunctionCall(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfFunctionCall functionCall = (RfFunctionCall)defNamedElementPair.getNamedElement();
        this.popScope(fileInstance, (RfNamedElement)functionCall);
    }

    public DefNamedElementPair startAssertExpect(WrapperInfo info, int kind, IRfAssertExpectElement.AssertKind assertKind) {
        boolean isAnonymous;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String assertExpectName = info.getName();
        boolean isEscaped = info.isEscaped();
        boolean bl = isAnonymous = assertExpectName == null || assertExpectName.isEmpty();
        if (isAnonymous) {
            assertExpectName = "@" + info.getParserPath() + '@' + info.getStartInfo();
        }
        RfAssertExpect assertExpect = enclosing.getLocalMember(RfAssertExpect.class, assertExpectName, false, this.fIncrementalBuild);
        RfDefElement assertExpectDef = new RfAssertExpectDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(assertExpectDef);
        if (foundElem != null) {
            assertExpectDef = foundElem;
            if (this.isAlreadyDefined(assertExpect, foundElem)) {
                this.increaseDuplicateScope(assertExpect);
                this.pushScope(assertExpectDef, assertExpect);
                return new DefNamedElementPair(assertExpectDef, assertExpect);
            }
        }
        RfAssertExpect rfAssertExpect = assertExpect = assertExpect == null || !assertExpect.hasNoDefs(true) ? null : assertExpect;
        if (assertExpect == null) {
            assertExpect = new RfAssertExpect(assertExpectName, isEscaped, kind, assertKind, info.getMacroCalls());
            enclosing.addMember(assertExpect);
        } else {
            assertExpect.init(kind, assertKind, info.getMacroCalls());
        }
        assertExpect.setMacroZone(this.fCurrentMacroZone);
        assertExpect.setAnonymous(isAnonymous);
        assertExpectDef = assertExpect.addDeclaration(assertExpectDef);
        this.pushScope(assertExpectDef, assertExpect);
        return new DefNamedElementPair(assertExpectDef, assertExpect);
    }

    public void endAssertExpect(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, String disableIff, IHidObject expression, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement assertExpect = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, assertExpect);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        if (assertExpect instanceof RfAssertExpect) {
            ((RfAssertExpect)assertExpect).setDisabledIffText(disableIff);
            ((RfAssertExpect)assertExpect).setExpression(expression);
        }
        this.popScope(fileInstance, assertExpect);
    }

    public DefNamedElementPair startWait(WrapperInfo info, int kind) {
        boolean isAnonymous;
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String waitName = info.getName();
        boolean isEscaped = info.isEscaped();
        boolean bl = isAnonymous = waitName == null || waitName.isEmpty();
        if (isAnonymous) {
            waitName = "@" + info.getParserPath() + '@' + info.getStartInfo();
        }
        RfWait wait = enclosing.getLocalMember(RfWait.class, waitName, false, this.fIncrementalBuild);
        RfDefElement waitDef = new RfWaitDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(waitDef);
        if (foundElem != null) {
            waitDef = foundElem;
            if (this.isAlreadyDefined(wait, foundElem)) {
                this.increaseDuplicateScope(wait);
                this.pushScope(waitDef, wait);
                return new DefNamedElementPair(waitDef, wait);
            }
        }
        RfWait rfWait = wait = wait == null || !wait.hasNoDefs(true) ? null : wait;
        if (wait == null) {
            wait = new RfWait(waitName, isEscaped, kind, info.getMacroCalls());
            enclosing.addMember(wait);
        } else {
            wait.init(kind, info.getMacroCalls());
        }
        wait.setMacroZone(this.fCurrentMacroZone);
        wait.setAnonymous(isAnonymous);
        waitDef = wait.addDeclaration(waitDef);
        this.pushScope(waitDef, wait);
        return new DefNamedElementPair(waitDef, wait);
    }

    public void endWait(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, IHidObject expression, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement wait = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, wait);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        if (wait instanceof RfWait) {
            ((RfWait)wait).setExpression(expression);
        }
        this.popScope(fileInstance, wait);
    }

    public void startEventTrigger(WrapperInfo info) {
        if (this.fLintingEnabled) {
            this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
            this.fCurrentMacroZone = info.getMacroZone();
            RfEventTrigger eventTrigger = new RfEventTrigger(info.getName(), info.isEscaped());
            this.fBuildScope.getScope().addEventTrigger(eventTrigger);
            RfDefElement eventTriggerDef = new RfEventTriggerDef(this.fCurrentFileDef, info);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(eventTriggerDef);
            if (foundElem != null) {
                eventTriggerDef = foundElem;
            }
            eventTrigger.setMacroZone(this.fCurrentMacroZone);
            eventTriggerDef = eventTrigger.addDeclaration(eventTriggerDef);
            this.fCurrentFileDef.addChildDef(eventTriggerDef);
        }
    }

    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        NullProtectedList<RfLibrary> result = new NullProtectedList<RfLibrary>();
        if (this.fRfProjectContent.fLibraries != null) {
            if (matchType == 1) {
                prefix = this.adjustLibraryName(prefix);
            }
            if (matchType == 9) {
                prefix = this.adjustLibraryNameIgnoreCase(prefix);
            }
            if (matchType == 1) {
                RfLibrary element = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)prefix);
                if (element != null) {
                    result.add(element);
                }
                return result;
            }
            for (RfLibrary element : this.fRfProjectContent.fLibraries.values()) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        if (this.fRfProjectContent.fLibraries != null) {
            if (matchType == 1) {
                prefix = this.adjustLibraryName(prefix);
            }
            if (matchType == 9) {
                prefix = this.adjustLibraryNameIgnoreCase(prefix);
            }
            if (matchType == 1) {
                return (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)prefix);
            }
            for (RfLibrary element : this.fRfProjectContent.fLibraries.values()) {
                if (!DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        return Collections.emptyList();
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getOtherLangPackageWithPrefix(String prefix, int matchType) {
        return this.fMixedLangProjectParent.getPackageWithPrefix((IRfSingleLangProject)this, prefix, matchType);
    }

    public List<IRfPackageElement> getOtherLangPackagesWithPrefix(String prefix, int matchType) {
        return this.fMixedLangProjectParent.getPackagesWithPrefix((IRfSingleLangProject)this, prefix, matchType);
    }

    @Override
    public List<RfScalarType> getScalarTypesWithPrefix(String prefix, int matchType) {
        return PREDEFINED_GLOBAL.getScalarTypesWithPrefix(prefix, matchType);
    }

    @Override
    public RfScalarType getScalarTypeWithPrefix(String prefix, int matchType) {
        return PREDEFINED_GLOBAL.getScalarTypeWithPrefix(prefix, matchType);
    }

    public static RfScalarType getScalarType(String name) {
        return PREDEFINED_GLOBAL.getScalarTypeWithPrefix(name, 1);
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (visited != null && visited.contains(this)) {
            return null;
        }
        RfNamedElement candidate = PREDEFINED_GLOBAL.getLocalMember(name, null, isFirst, isLast);
        if (candidate != null) {
            return candidate;
        }
        candidate = super.semanticGetLocalMember(name, hid, parserPath, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
        if (candidate != null) {
            return candidate;
        }
        Set<RfLibrary> pkgLibraries = prevScope instanceof RfLibrary ? ((RfLibrary)prevScope).getPkgSearchLibraries() : Collections.emptySet();
        for (RfLibrary library : pkgLibraries) {
            if (visited != null && visited.contains(library) || (candidate = library.getLocalMember(RfPackage.class, name, false, false)) == null) continue;
            return candidate;
        }
        boolean exclusivePkgLibraries = !pkgLibraries.isEmpty();
        for (RfLibrary library : this.getLibraries()) {
            if (visited != null) {
                if (visited.contains(library)) continue;
                visited.add(this);
            }
            if ((candidate = library.getLocalMember(RfPackage.class, name, false, false)) instanceof RfPackage && !(candidate instanceof RfPredefinedPackage) && exclusivePkgLibraries) continue;
            if (candidate != null) {
                return candidate;
            }
            candidate = library.semanticGetLocalMember(name, hid, null, null, visited, enumNameProposals, isFirst, isLast, false);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, isOnlyType, skipParents);
        if (result != null && result != exclude) {
            return result;
        }
        boolean isOnlyVlogSearch = this.isOnlyVlogSearch(classes);
        if (classes != null && isOnlyVlogSearch) {
            return result;
        }
        result = this.fMixedLangProjectParent.getVisibleMemberInScope((IRfSingleLangProject)this, visited, classes, name, isFirst, isLast, isOnlyType, exclude);
        if (result != null && result != exclude) {
            return result;
        }
        return null;
    }

    private boolean isOnlyVlogSearch(Set<Class<? extends IRfNamedElement>> classes) {
        if (classes == null) {
            return true;
        }
        for (Class<? extends IRfNamedElement> clazz : classes) {
            if (RfNamedElement.class.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IRfNamedElement getDesignElement(String name) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        IRfNamedElement result = super.semanticGetLocalMember(name, null, null, null, visited, null, false, false, false);
        return result;
    }

    @Override
    public <T extends IRfNamedElement> void getMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries) {
                if (!elementFilter.validElement((IRfNamedElement)library) || prefix != null && !DVTStringUtil.regionMatches((String)library.getName(), (String)prefix, (int)matchType)) continue;
                result.add(library);
                if (elementFilter.resultMaxSize() != result.size()) continue;
                throw new MaxSizeReachedException();
            }
        }
        PREDEFINED_GLOBAL.getLocalMembers(result, clazz, prefix, matchType, local, accessModifier, elementFilter);
        if (this.fMixedLangProjectParent != null) {
            this.fMixedLangProjectParent.getMembers((IRfSingleLangProject)this, result, clazz, prefix, enumPrefixProposals, matchType, local, isFirst, accessModifier, elementFilter);
        }
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        boolean equals = (matchType & 1) != 0;
        boolean strictEquals = matchType == 1;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        if ((equals || first) && size > 0 || limit100 && size >= 100) {
            return;
        }
        if (strictEquals) {
            RfNamedElement candidate;
            if (localMembersKind == RfClass.class && (candidate = PREDEFINED_GLOBAL.getClassWithPrefix(prefix, matchType, local)) != null) {
                if (validator != null && !validator.hasProperty(candidate, kind)) {
                    return;
                }
                if (validator != null && !validator.accessModifier(candidate, accessModifier)) {
                    return;
                }
                result.put(candidate.getName(), candidate);
                return;
            }
            if (localMembersKind == RfFunction.class && localMembersSelect == 3 && (candidate = PREDEFINED_GLOBAL.getFunctionWithPrefix(prefix, matchType, local, accessModifier)) != null) {
                if (validator != null && !validator.hasProperty(candidate, kind)) {
                    return;
                }
                if (validator != null && !validator.accessModifier(candidate, accessModifier)) {
                    return;
                }
                result.put(candidate.getName(), candidate);
                return;
            }
            if (localMembersKind == RfFunction.class && localMembersSelect == 4 && (candidate = PREDEFINED_GLOBAL.getTaskWithPrefix(prefix, matchType, local, accessModifier)) != null) {
                if (validator != null && !validator.hasProperty(candidate, kind)) {
                    return;
                }
                if (validator != null && !validator.accessModifier(candidate, accessModifier)) {
                    return;
                }
                result.put(candidate.getName(), candidate);
                return;
            }
        } else {
            List<RfNamedElement> candidates;
            if (localMembersKind == RfClass.class && (candidates = PREDEFINED_GLOBAL.getClassesWithPrefix(prefix, matchType, local)) != null) {
                for (RfNamedElement element : candidates) {
                    if (validator != null && !validator.hasProperty(element, kind) || validator != null && !validator.accessModifier(element, accessModifier) || result.containsKey(element.getKey())) continue;
                    result.put(element.getName(), element);
                }
            }
            if (localMembersKind == RfFunction.class && localMembersSelect == 3 && (candidates = PREDEFINED_GLOBAL.getFunctionsWithPrefix(prefix, matchType, local, accessModifier)) != null) {
                for (RfNamedElement element : candidates) {
                    if (validator != null && !validator.hasProperty(element, kind) || validator != null && !validator.accessModifier(element, accessModifier) || result.containsKey(element.getKey())) continue;
                    result.put(element.getName(), element);
                }
            }
            if (localMembersKind == RfFunction.class && localMembersSelect == 4 && (candidates = PREDEFINED_GLOBAL.getTasksWithPrefix(prefix, matchType, local, accessModifier)) != null) {
                for (RfNamedElement element : candidates) {
                    if (validator != null && !validator.hasProperty(element, kind) || validator != null && !validator.accessModifier(element, accessModifier) || result.containsKey(element.getKey())) continue;
                    result.put(element.getName(), element);
                }
            }
        }
    }

    @Override
    protected IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, IRfNamedElement prevScope, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents, IndexInfo indexInfo) {
        RfNamedElement result;
        if (this.fRfProjectContent.fLibraries != null) {
            RfNamedElement rfNamedElement = result = classes == null || classes.contains(RfLibrary.class) ? (RfNamedElement)this.fRfProjectContent.fLibraries.get((Object)this.adjustLibraryName(name)) : null;
            if (result != null) {
                return result;
            }
            Set<RfLibrary> pkgLibraries = prevScope instanceof RfLibrary && classes != null && classes.contains(RfPackage.class) ? ((RfLibrary)prevScope).getPkgSearchLibraries() : Collections.emptySet();
            for (RfLibrary library : pkgLibraries) {
                if (visited.contains(library) || (result = (RfNamedElement)library.getLocalMember(RfPackage.class, name, false, false)) == null) continue;
                return result;
            }
            boolean exclusivePkgLibraries = !pkgLibraries.isEmpty();
            for (RfLibrary library : this.getLibraries()) {
                if (visited.contains(library)) continue;
                visited.add(library);
                result = library.getLocalMember((Set)classes, name, exclude);
                if (result instanceof RfPackage && !(result instanceof RfPredefinedPackage) && exclusivePkgLibraries || result == null) continue;
                return result;
            }
        }
        if ((result = PREDEFINED_GLOBAL.getLocalMember(name, classes, true, true)) != null && (classes == null || classes.contains(result.getClass()))) {
            return result;
        }
        return this.getVisibleMemberInScope(name, classes, exclude, visited, enumNameProposals, isFirst, isLast, false, skipParents);
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        RfNamedElement result;
        RfNamedElement rfNamedElement = result = (classes == null || classes.contains(RfLibrary.class)) && this.fRfProjectContent.fLibraries != null ? (RfNamedElement)this.fRfProjectContent.fLibraries.get((Object)this.adjustLibraryName(name)) : null;
        if (result != null) {
            return result;
        }
        result = PREDEFINED_GLOBAL.getLocalMember(name, null, true, true);
        if (result != null && (classes == null || classes.contains(result.getClass()))) {
            return result;
        }
        return null;
    }

    @Override
    public <T extends IRfNamedElement> T getFirstLocalMember(Class<T> clazz, String name) {
        DVTLinkedHashMap<String, RfLibrary> members = this.fRfProjectContent.fLibraries;
        if (members == null) {
            return null;
        }
        RfNamedElement candidate = (RfNamedElement)members.get((Object)this.adjustLibraryName(name));
        if (candidate instanceof RfDuplicate) {
            if (clazz == RfDuplicate.class) {
                return (T)candidate;
            }
            return ((RfDuplicate)candidate).getFirstMember(clazz);
        }
        if (clazz == RfField.class && candidate instanceof RfCoverpoint) {
            return null;
        }
        if (candidate == null || !clazz.isInstance(candidate)) {
            return null;
        }
        return (T)candidate;
    }

    @Override
    protected RfNamedElement[] internalGetLocalMembersKind(Set<IRfNamedElement> visited, Class<? extends IRfNamedElement> localMembersKind, int localMemebersSelect, String prefix, int matchType) {
        boolean strictEquals;
        boolean bl = strictEquals = matchType == 1;
        if (localMembersKind == RfLibrary.class) {
            if (this.fRfProjectContent.fLibraries == null) {
                return null;
            }
            if (strictEquals) {
                RfNamedElement[] rfNamedElementArray;
                RfLibrary result = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)this.adjustLibraryName(prefix));
                if (result == null) {
                    rfNamedElementArray = null;
                } else {
                    RfNamedElement[] rfNamedElementArray2 = new RfNamedElement[1];
                    rfNamedElementArray = rfNamedElementArray2;
                    rfNamedElementArray2[0] = result;
                }
                return rfNamedElementArray;
            }
            Collection values = this.fRfProjectContent.fLibraries.values();
            return values.toArray(new RfNamedElement[values.size()]);
        }
        return super.internalGetLocalMembersKind(visited, localMembersKind, localMemebersSelect, prefix, matchType);
    }

    public List<RfNamedElement> getLocalTypes(RfNamedElement element, boolean includePredefined, boolean sortByType, boolean hideDuplicates) {
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        if (element instanceof RfCovergroup) {
            return elements;
        }
        int index0 = 0;
        int index1 = 0;
        if (element instanceof RfProject) {
            if (includePredefined) {
                elements.addAll(this.fRfProjectContent.fLibraries.values());
            } else {
                Collection libraries = this.fRfProjectContent.fLibraries.values();
                elements.ensureCapacity(libraries.size() - 1);
                for (RfLibrary library : libraries) {
                    if (library.isPredefined()) continue;
                    elements.add(library);
                }
            }
        } else if (element instanceof RfLibrary) {
            elements.addAll(((RfLibrary)element).getLocalMembers(hideDuplicates, RfPackage.class));
            index1 = elements.size();
            elements.addAll(((RfLibrary)element).getLocalMembers(hideDuplicates, RfPrimitive.class));
        }
        int index2 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfTypeAlias.class));
        int index3 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfClass.class));
        int index4 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfModule.class));
        int index5 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfProgram.class));
        int index6 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfInterface.class));
        int index7 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfChecker.class));
        int index8 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfCovergroup.class));
        int index9 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfGenerateBlock.class));
        int index10 = elements.size();
        if (element instanceof RfProject && includePredefined) {
            elements.addAll(PREDEFINED_GLOBAL.getAllScalars());
            index9 = elements.size();
            elements.addAll(PREDEFINED_GLOBAL.getAllClasses());
        }
        int index11 = elements.size();
        if (element instanceof RfLibrary) {
            elements.addAll(((RfLibrary)element).getLocalMembers(hideDuplicates, RfConfiguration.class));
        }
        int index12 = elements.size();
        RfNamedElement[] result = elements.toArray(new RfNamedElement[elements.size()]);
        RfNamedElementComparator comparator = new RfNamedElementComparator();
        if (sortByType) {
            Arrays.sort(result, index0, index1, comparator);
            Arrays.sort(result, index1, index2, comparator);
            Arrays.sort(result, index2, index3, comparator);
            Arrays.sort(result, index3, index4, comparator);
            Arrays.sort(result, index4, index5, comparator);
            Arrays.sort(result, index5, index6, comparator);
            Arrays.sort(result, index6, index7, comparator);
            Arrays.sort(result, index7, index8, comparator);
            Arrays.sort(result, index8, index9, comparator);
            Arrays.sort(result, index9, index10, comparator);
            Arrays.sort(result, index10, index11, comparator);
            Arrays.sort(result, index11, index12, comparator);
        } else {
            Arrays.sort(result, comparator);
        }
        return Arrays.asList(result);
    }

    public RfFileDef getFile(IResource file) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        ParserPath parserPath = this.resource2parser(file);
        if (parserPath == null) {
            return null;
        }
        return this.getFile(parserPath);
    }

    public RfFileDef getFile(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        if (parserPath == null) {
            return null;
        }
        return this.getFileDefUsingParserPath(parserPath);
    }

    public void addListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            ParserPath parserPath;
            if (this.fParserPathToListenerMap == null) {
                this.fParserPathToListenerMap = new HashMap<ParserPath, List<IRfFileListener>>();
            }
            if ((parserPath = this.resource2parser(resource)) == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                listeners = new ArrayList<IRfFileListener>();
                this.fParserPathToListenerMap.put(parserPath, listeners);
            }
            listeners.add(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeListenerUsingResourcePath(IFile resource, IRfFileListener listener) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            ParserPath parserPath = this.resource2parser((IResource)resource);
            if (parserPath == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyParsingEndUsingParserPath(Set<ParserPath> incrementalParserPaths) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            for (ParserPath incrementalParserPath : incrementalParserPaths) {
                List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(incrementalParserPath);
                if (listeners == null) {
                    return;
                }
                for (IRfFileListener listener : listeners) {
                    listener.notifyFileReparse(this.getFileDefUsingParserPath(incrementalParserPath));
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void connectFileToDocument(ParserPath parserPath, DVTEditor editor, boolean connectOnlyVisualPositions, Map<Position, Position> cachedPositions) {
        try {
            long time = System.currentTimeMillis();
            if (parserPath == null || editor == null) {
                return;
            }
            boolean isEditorVisible = editor.isVisible();
            if (!isEditorVisible && connectOnlyVisualPositions) {
                return;
            }
            if (this.fParserPathToEditorMap == null) {
                this.fParserPathToEditorMap = new HashMap<ParserPath, DVTEditor>();
            }
            this.fParserPathToEditorMap.put(parserPath, editor);
            RfFileDef file = this.getFileDefUsingParserPath(parserPath);
            if (file == null) {
                if (isEditorVisible) {
                    this.connectPVlogCodePositions(parserPath, editor);
                }
                return;
            }
            IDocument document = editor.getDocument();
            boolean shouldAddFolding = document != null ? document.getNumberOfLines() < Utils.getInstance().getCodeFoldingNofLines() : false;
            DVTConnectPositionToDocumentProvider connectProvider = new DVTConnectPositionToDocumentProvider(cachedPositions, connectOnlyVisualPositions, shouldAddFolding, editor);
            file.connectPositionToDocument(connectProvider, isEditorVisible);
            if (isEditorVisible && DVTFileUtils.getInstance().shouldIncrementalBuild(document, null, this.getProject())) {
                DVTEditor.addOverrideIndications((Map)connectProvider.getOverrideAnnotationProvider().getAdditions(), (DVTEditor)editor);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            if (!connectOnlyVisualPositions) {
                this.connectMacrosForFilenameToDocument(parserPath, document, cachedPositions, connectProvider.getReflectionPositions());
            }
            if (isEditorVisible && document != null && shouldAddFolding) {
                DVTEditor.addSemanticFolding((Set)connectProvider.getSemanticFoldingProvider().getSemanticFoldingPositions(), (DVTEditor)editor);
            }
            if (!connectOnlyVisualPositions && document != null) {
                DVTDocumentUtils.addDocumentPositions((IDocument)document, (String)"REFLECTION", (Collection)connectProvider.getReflectionPositions());
            }
            CustomPragmaUtils.notifyListeners((IProject)this.fProject);
            DVTLogger.INSTANCE.logDebug("DEBUG VLOG: Connect File to Document [" + (System.currentTimeMillis() - time) + " ms] - " + parserPath.path);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectPVlogCodePositions(ParserPath parserPath, DVTEditor editor) {
        PreprocConstCommon.PreprocFileType preprocFileType = PreprocUtils.getInstance().getPreprocFileType(this.getProject(), parserPath);
        if (preprocFileType == PreprocConstCommon.PreprocFileType.G_FILE) {
            Utils.getInstance().connectGeneratedCodePositions(editor.getDocument(), parserPath, this.getProject());
        }
        if (preprocFileType == PreprocConstCommon.PreprocFileType.P_FILE) {
            Utils.getInstance().connectPreprocCodePositions(editor.getDocument(), parserPath);
        }
    }

    public void disconnectFileFromDocument(ParserPath parserPath) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                if (this.fParserPathToEditorMap != null) {
                    this.fParserPathToEditorMap.remove(parserPath);
                }
                return;
            }
            this.disconectMacrosForFilenameToDocument(parserPath);
            fileDef.disconnectPositionFromDocument();
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            this.internalRemoveNonTopFile(parserPath, fileDef.getFileAdapter(), true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void quickFixRemoveNonTopFile(ParserPath parserPath) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            this.internalRemoveNonTopFile(parserPath, fileDef.getFileAdapter(), false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateSyntaxErrors(ParserPath parserPath, Set<VlogProblem> errors, Set<VlogProblem> warnings, Set<TaskInfoWrapper> tasks) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            ArrayList<VlogProblem> errors2 = errors == null ? Collections.emptyList() : new ArrayList<VlogProblem>(errors);
            ArrayList<VlogProblem> warnings2 = warnings == null ? Collections.emptyList() : new ArrayList<VlogProblem>(warnings);
            ArrayList<TaskInfoWrapper> tasks2 = tasks == null ? Collections.emptyList() : new ArrayList<TaskInfoWrapper>(tasks);
            SyntaxErrorsManager.getInstance().reparsed(0, 2, fileDef.getFileAdapter(), errors2, warnings2, tasks2);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalRemoveNonTopFile(ParserPath parserPath, IResource file, boolean updateViews) {
        try {
            VlogPreprocessingInfo preprocessing;
            if (this.fRfProjectContent.fFileToLibraryExplicitMapping == null) {
                return;
            }
            String libraryName = this.fRfProjectContent.fFileToLibraryExplicitMapping.get(parserPath.path);
            if (!TEMP_LIBRARY_NAME.equals(libraryName)) {
                return;
            }
            VlogQuickViewersUtil.getInstance().removeWaitEditorJob((IFile)file);
            RfLibrary nonTopFilesEnclosingLibrary = this.getLocalLibrary(TEMP_LIBRARY_NAME);
            if (nonTopFilesEnclosingLibrary == null) {
                return;
            }
            this.cleanFile(parserPath, null);
            LinkedHashMap<ParserPath, Collection<RfNamedElement>> createdClassFragments = new LinkedHashMap<ParserPath, Collection<RfNamedElement>>();
            nonTopFilesEnclosingLibrary.removeDirtyElements(parserPath, this, createdClassFragments);
            IRfSingleLangProject.SemanticErrorsCategory[] categories = IRfSingleLangProject.SemanticErrorsCategory.values();
            IRfSingleLangProject.SemanticErrorsCategory[] semanticErrorsCategoryArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                IRfSingleLangProject.SemanticErrorsCategory category = semanticErrorsCategoryArray[n2];
                this.fSemanticErrors.clearFiles(category, this, Collections.singletonList(parserPath));
                ++n2;
            }
            Utils.refreshMarkers(this);
            this.lintCleanOVMProject();
            Utils.getInstance().cleanSemanticMarkers(this.fProject);
            this.updatedSemanticErrors(categories, false, false);
            List emptyList = Collections.emptyList();
            SyntaxErrorsManager.getInstance().reparsed(0, 2, file, emptyList, emptyList, emptyList);
            if (this.fRfProjectContent.fFileToLibraryExplicitMapping != null) {
                this.fRfProjectContent.fFileToLibraryExplicitMapping.remove(parserPath.path);
            }
            if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
                this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath.toCanonical());
            }
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath.toCanonical());
            }
            if ((preprocessing = this.getPreprocessingTable()) != null) {
                preprocessing.clear(parserPath);
                VlogFileInstance topFileInstance = preprocessing.getTopFileInstance();
                List<VlogFileInstance> fileInstances = topFileInstance.getFileInstances(parserPath);
                if (fileInstances != null && !fileInstances.isEmpty()) {
                    for (VlogFileInstance fileInstance : fileInstances) {
                        if (fileInstance.getSemanticScope() != nonTopFilesEnclosingLibrary) continue;
                        topFileInstance.removeIncludedFile(fileInstance);
                        fileInstance.setSemanticScope(null);
                    }
                }
            }
            if (updateViews) {
                DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, this.fProject, ViewsUtils.ALL_BUT_DH_VIEWS);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public DVTEditor getEditor(ParserPath parserPath) {
        if (this.fParserPathToEditorMap == null) {
            return null;
        }
        return this.fParserPathToEditorMap.get(parserPath);
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        return "project";
    }

    public void connectMacrosForFilenameToDocument(ParserPath parserPath, IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        List<VlogMacroInfo> macros = this.getAllMacros(parserPath);
        for (VlogMacroInfo macro : macros) {
            if (!macro.getFileInstance().getParserPath().equals((Object)parserPath)) continue;
            macro.connectPositionToDocument(document, cachedPositions, reflectionPositions);
        }
    }

    public void disconectMacrosForFilenameToDocument(ParserPath parserPath) {
        List<VlogMacroInfo> macros = this.getAllMacros(parserPath);
        for (VlogMacroInfo macro : macros) {
            ParserPath fileInstanceParserPath;
            VlogFileInstance fileInstance = macro.getFileInstance();
            if (fileInstance == null || (fileInstanceParserPath = fileInstance.getParserPath()) == null || !fileInstanceParserPath.equals((Object)parserPath)) continue;
            macro.removePosition();
        }
    }

    public boolean visitMacros(IRfMacroVisitor visitor) {
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        return topInstance.visitMacros(visitor);
    }

    public List<VlogMacroInfo> getAllMacros() {
        NullProtectedList<VlogMacroInfo> result = new NullProtectedList<VlogMacroInfo>();
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        topInstance.getAllDefines(result);
        return result;
    }

    public List<VlogMacroInfo> getAllMacros(ParserPath parserPath) {
        NullProtectedList<VlogMacroInfo> result = new NullProtectedList<VlogMacroInfo>();
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        List<VlogFileInstance> instances = topInstance.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return result;
        }
        for (VlogFileInstance instance : instances) {
            instance.getDefinesInFile(result);
        }
        return result;
    }

    public VlogMacroInfo getMacroBeforeLineInFile(String macroName, ParserPath parserPath, int line) {
        if (parserPath == null) {
            List<RfNamedElement> macros = this.getMacrosWithPrefix(macroName, 1);
            if (macros != null && !macros.isEmpty()) {
                return (VlogMacroInfo)macros.get(0);
            }
            return null;
        }
        return this.getMacroBeforeLineInFile(macroName, this.getFile(parserPath), line);
    }

    public VlogMacroInfo getMacroBeforeLineInFile(String macroName, RfFileDef rfFileDef, int line) {
        if (rfFileDef == null) {
            return null;
        }
        ParserPath parserPath = rfFileDef.getParserPath();
        if (parserPath == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        VlogFileInstance firstFileInstance = this.getFirstFileInstance(parserPath, topInstance);
        if (firstFileInstance == null) {
            return null;
        }
        return firstFileInstance.getMacroBeforeLine(macroName, line);
    }

    public void visitMacrosBeforeLineInFile(ParserPath parserPath, int line, IRfMacroVisitor visitor) {
        this.visitMacrosBeforeLineInFile(this.getFile(parserPath), line, visitor);
    }

    public void visitMacrosBeforeLineInFile(RfFileDef rfFileDef, int line, IRfMacroVisitor visitor) {
        if (rfFileDef == null) {
            this.visitMacros(visitor);
            return;
        }
        ParserPath parserPath = rfFileDef.getParserPath();
        if (parserPath == null) {
            return;
        }
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        VlogFileInstance firstFileInstance = this.getFirstFileInstance(parserPath, topInstance);
        if (firstFileInstance == null) {
            return;
        }
        firstFileInstance.visitMacrosBeforeLine(line, visitor);
    }

    private VlogFileInstance getFirstFileInstance(ParserPath parserPath, VlogFileInstance searchFileInstance) {
        if (parserPath.equals((Object)searchFileInstance.getParserPath())) {
            return searchFileInstance;
        }
        List<VlogFileInstance> instanceList = searchFileInstance.getIncludedInstances();
        if (instanceList == null) {
            return null;
        }
        for (VlogFileInstance instance : instanceList) {
            VlogFileInstance searchResult = this.getFirstFileInstance(parserPath, instance);
            if (searchResult == null) continue;
            return searchResult;
        }
        return null;
    }

    public List<RfNamedElement> getMacrosWithPrefix(String prefix, int matchType) {
        return this.getMacrosWithPrefix(prefix, matchType, null, -1);
    }

    public List<RfNamedElement> getMacrosWithPrefix(final String prefix, final int matchType, RfFileDef rfFileDef, int line) {
        final ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        final boolean limit100 = (matchType & 0x20) != 0;
        IRfMacroVisitor visitor = new IRfMacroVisitor(){

            @Override
            public boolean visit(VlogMacroInfo macroInfo) {
                if (DVTStringUtil.regionMatches((String)macroInfo.getName(), (String)prefix, (int)matchType)) {
                    result.add(macroInfo);
                    if (limit100 && result.size() >= 100) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.visitMacrosBeforeLineInFile(rfFileDef, line, visitor);
        return result;
    }

    public Map<String, VlogMacroInfo> getMacrosBeforeLineInFile(ParserPath parserPath, int line) {
        final LinkedHashMap<String, VlogMacroInfo> result = new LinkedHashMap<String, VlogMacroInfo>();
        IRfMacroVisitor visitor = new IRfMacroVisitor(){

            @Override
            public boolean visit(VlogMacroInfo macroInfo) {
                if (!result.containsKey(macroInfo.getName())) {
                    result.put(macroInfo.getName(), macroInfo);
                }
                return true;
            }
        };
        this.visitMacrosBeforeLineInFile(parserPath, line, visitor);
        return result;
    }

    private void removeAllCommentsTables() {
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        preprocessing.cleanAllComments(true);
    }

    private void removeInstanceCommentsTable(VlogFileInstance instance) {
        instance.cleanAllComments(false);
        instance.cleanCustomPragmas();
    }

    public RfClass[] getAllClasses() {
        ArrayList result = new ArrayList();
        this.accept((RfNamedElement namedElement) -> {
            if (namedElement instanceof RfClass && !namedElement.isPredefined()) {
                result.add((RfClass)namedElement);
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            return CLASS_CONTAINERS.contains(namedElement.getClass());
        });
        return result.toArray(new RfClass[result.size()]);
    }

    public List<IRfInstanceElement> collectInstances(IRfDesignElement moduleOrEntity) {
        List<RfInstanceHolder> allModules = this.getAllInstanceHolders(this.fRfProjectContent.fLibraries.values(), null, false, false, false);
        ArrayList<IRfInstanceElement> result = new ArrayList<IRfInstanceElement>();
        for (RfInstanceHolder module : allModules) {
            ArrayList instances = new ArrayList();
            DesignUtils.getInstancesIncludingGenerate(instances, (IRfDesignElement)module, (boolean)false);
            for (IRfInstanceElement instance : instances) {
                IRfNamedElement instanceDesign = instance.getGenericDesign(null);
                if (instanceDesign instanceof RfInstance.RfInstanceList) {
                    instanceDesign = ((RfInstance.RfInstanceList)instanceDesign).getAssociatedBaseType();
                }
                if (instanceDesign != moduleOrEntity) continue;
                result.add(instance);
            }
        }
        List designs = this.getMixedLangProjectParent().getDesignsWithPrefix((IRfSingleLangProject)this, "", 2);
        if (designs != null && !designs.isEmpty()) {
            for (IRfDesignElement design : designs) {
                Collection instances = design.getLocalInstances();
                if (instances == null || instances.isEmpty()) continue;
                for (IRfInstanceElement instance : instances) {
                    IRfNamedElement genericDesign = instance.getGenericDesign(null);
                    if (genericDesign instanceof RfInstance.RfInstanceList) {
                        genericDesign = ((RfInstance.RfInstanceList)genericDesign).getAssociatedBaseType();
                    }
                    if (genericDesign != moduleOrEntity) continue;
                    result.add(instance);
                }
            }
        }
        return result;
    }

    public RfModule[] getAllModules() {
        if (this.fRfProjectContent.fLibraries == null) {
            return new RfModule[0];
        }
        List<RfInstanceHolder> modules = this.getAllInstanceHolders(this.fRfProjectContent.fLibraries.values(), null, false, false, false);
        return modules.toArray(new RfModule[modules.size()]);
    }

    public List<RfInstanceHolder> getAllInstanceHolders(Collection<? extends IRfNamedElement> elements, Set<ParserPath> changedFiles, boolean collectInterfaces, boolean collectCheckers, boolean collectPrograms) {
        ArrayList<RfInstanceHolder> result = new ArrayList<RfInstanceHolder>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfModule || collectInterfaces && namedElement instanceof RfInterface || collectCheckers && namedElement instanceof RfChecker || collectPrograms && namedElement instanceof RfProgram) {
                if (changedFiles != null && !changedFiles.isEmpty()) {
                    RfDefElement declaration = namedElement.getDeclaration();
                    if (declaration == null) {
                        return true;
                    }
                    RfFileDef defFile = declaration.getDefFile();
                    if (defFile == null) {
                        return true;
                    }
                    if (!changedFiles.contains(defFile.getParserPath())) {
                        return true;
                    }
                }
                result.add((RfInstanceHolder)namedElement);
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            return namedElement instanceof RfInstanceHolder && ((RfInstanceHolder)namedElement).hasInnerInstanceHolders();
        };
        if (elements != null && !elements.isEmpty()) {
            for (IRfNamedElement iRfNamedElement : elements) {
                if (!(iRfNamedElement instanceof RfNamedElement)) continue;
                ((RfNamedElement)iRfNamedElement).accept(this, visitor);
            }
        }
        return result;
    }

    public List<IRfDesignElement> getInstanceHoldersWithPrefix(Collection<? extends RfNamedElement> elements, String prefix, int matchType, int maxNofProposals) {
        ArrayList<IRfDesignElement> result = new ArrayList<IRfDesignElement>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (result.size() >= maxNofProposals) {
                return false;
            }
            if ((namedElement instanceof RfModule || namedElement instanceof RfInterface || namedElement instanceof RfChecker || namedElement instanceof RfProgram) && DVTStringUtil.regionMatches((String)namedElement.getName(), (String)prefix, (int)matchType)) {
                result.add((IRfDesignElement)namedElement);
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            return namedElement instanceof RfInstanceHolder && ((RfInstanceHolder)namedElement).hasInnerInstanceHolders();
        };
        if (elements != null && !elements.isEmpty()) {
            for (RfNamedElement rfNamedElement : elements) {
                rfNamedElement.accept(this, visitor);
            }
        }
        return result;
    }

    public Set<String> getAvailableElementsToInstantiate(RfLibrary library) {
        HashSet<String> result = new HashSet<String>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfModule || namedElement instanceof RfInterface || namedElement instanceof RfChecker || namedElement instanceof RfProgram || namedElement instanceof RfPrimitive) {
                result.add(namedElement.getName());
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            return namedElement instanceof RfInstanceHolder && ((RfInstanceHolder)namedElement).hasInnerInstanceHolders();
        };
        library.accept(this, visitor);
        return result;
    }

    public RfConstraint[] getAllConstraints() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfConstraint) {
                result.add((RfConstraint)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfConstraint[result.size()]);
    }

    public RfClockingBlock[] getAllClockingBlocks() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfClockingBlock) {
                result.add((RfClockingBlock)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfClockingBlock[result.size()]);
    }

    public RfModport[] getAllModports() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfModport) {
                result.add((RfModport)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfModport[result.size()]);
    }

    public List<RfInstanceHolder> getAllModulesAndInterfaces(String libraryName) {
        ArrayList<RfInstanceHolder> result = new ArrayList<RfInstanceHolder>();
        ArrayList<RfNamedElement> elements = new ArrayList<RfNamedElement>();
        RfLibrary library = this.getOrCreateLibrary(libraryName);
        if (library != null) {
            elements.add(library);
        } else {
            elements.add(this);
        }
        this.collectRecursiveModulesAndInterfaces(result, elements);
        return result;
    }

    private void collectRecursiveModulesAndInterfaces(List<RfInstanceHolder> result, Collection<? extends RfNamedElement> elements) {
        for (RfNamedElement rfNamedElement : elements) {
            List<RfModule> modules = rfNamedElement.getLocalMembers(RfModule.class);
            List<RfInterface> interfaces = rfNamedElement.getLocalMembers(RfInterface.class);
            if (modules != null && !modules.isEmpty()) {
                result.addAll(modules);
                this.collectRecursiveModulesAndInterfaces(result, modules);
            }
            if (interfaces == null || interfaces.isEmpty()) continue;
            result.addAll(interfaces);
            this.collectRecursiveModulesAndInterfaces(result, interfaces);
        }
    }

    public RfFunction[] getAllFunctionsAndTasks(boolean includePredefined) {
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfFunction && !(namedElement.getEnclosingScope() instanceof RfModport)) {
                result.add((RfFunction)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        if (includePredefined) {
            result.addAll(PREDEFINED_GLOBAL.getAllFunctionsAndTasks());
        }
        return result.toArray(new RfFunction[result.size()]);
    }

    public RfFunction[] getAllFunctionsAndTasks() {
        return this.getAllFunctionsAndTasks(false);
    }

    public List<RfActionBlock> getAllActionBlocks() {
        ArrayList<RfActionBlock> result = new ArrayList<RfActionBlock>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfActionBlock) {
                result.add((RfActionBlock)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result;
    }

    public RfField[] getAllEvents() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfField && ((RfField)namedElement).isEvent()) {
                result.add((RfField)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfField[result.size()]);
    }

    public RfCovergroup[] getAllCovergroups() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfCovergroup) {
                result.add((RfCovergroup)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfCovergroup[result.size()]);
    }

    public RfChecker[] getAllCheckers() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfChecker) {
                result.add((RfChecker)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfChecker[result.size()]);
    }

    public RfConfiguration[] getAllConfigurations() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfConfiguration) {
                result.add((RfConfiguration)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfConfiguration[result.size()]);
    }

    public RfAssertExpect[] getAllAssertExpects() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfAssertExpect) {
                result.add((RfAssertExpect)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfAssertExpect[result.size()]);
    }

    public RfWait[] getAllWaits() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfWait) {
                result.add((RfWait)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfWait[result.size()]);
    }

    public RfStruct[] getAllStructsUnions() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfStruct && !((RfStruct)namedElement).isEnum()) {
                result.add((RfStruct)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfStruct[result.size()]);
    }

    public List<RfStruct> getAllStructsUnionsEnums() {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfStruct) {
                result.add((RfStruct)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result;
    }

    public RfField[] getAllFields() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            List<RfField> localFields;
            if ((namedElement instanceof RfLibrary || namedElement instanceof RfPackage || namedElement instanceof RfClass || namedElement instanceof RfInterface || namedElement instanceof RfGenerateBlock || namedElement instanceof RfModule || namedElement instanceof RfProgram || namedElement instanceof RfChecker) && (localFields = namedElement.getLocalFields()) != null && !localFields.isEmpty()) {
                result.addAll(localFields);
            }
            if (namedElement instanceof RfStruct && !((RfStruct)namedElement).isEnum() && (localFields = namedElement.getLocalFields()) != null && !localFields.isEmpty()) {
                result.addAll(localFields);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfField[result.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public RfNamedElement[] getAllFunctionCallContainers() {
        List<RfPackage> allPackages;
        Object properties;
        RfNamedElement[] result = new RfNamedElement[]{};
        result = this.addTo(result, this.getAllFunctionsAndTasks());
        RfNamedElement[] allTypes = this.getAllTypes(false, false);
        result = this.addTo(result, allTypes);
        if (allTypes != null) {
            RfNamedElement[] rfNamedElementArray = allTypes;
            int n = allTypes.length;
            int n2 = 0;
            while (n2 < n) {
                RfNamedElement type = rfNamedElementArray[n2];
                properties = type.getLocalMembers(RfPropertySequence.class);
                if (properties != null && !properties.isEmpty()) {
                    result = this.addTo(result, properties.toArray(new RfNamedElement[properties.size()]));
                }
                ++n2;
            }
        }
        result = this.addTo(result, this.getAllAssertExpects());
        result = this.addTo(result, this.getAllCovergroups());
        RfClass[] classes = this.getAllClasses();
        if (classes != null) {
            void var5_7;
            properties = classes;
            int n3 = classes.length;
            boolean bl = false;
            while (var5_7 < n3) {
                RfClass classs = properties[var5_7];
                List<RfConstraint> constraints = classs.getLocalMembers(RfConstraint.class);
                if (constraints != null && !constraints.isEmpty()) {
                    result = this.addTo(result, constraints.toArray(new RfNamedElement[constraints.size()]));
                }
                ++var5_7;
            }
        }
        if ((allPackages = this.getAllPackages(true)) != null) {
            for (RfNamedElement rfNamedElement : allPackages) {
                properties = rfNamedElement.getLocalMembers(RfPropertySequence.class);
                if (properties == null || properties.isEmpty()) continue;
                result = this.addTo(result, properties.toArray(new RfNamedElement[properties.size()]));
            }
        }
        ArrayList<RfFunctionCall> arrayList = new ArrayList<RfFunctionCall>();
        RfNamedElement[] rfNamedElementArray = result;
        int n = result.length;
        int n3 = 0;
        while (n3 < n) {
            RfNamedElement callContainer = rfNamedElementArray[n3];
            List<RfFunctionCall> allCalls = callContainer.getFunctionCallsWithPrefix("", 2);
            if (allCalls != null) {
                for (RfFunctionCall call : allCalls) {
                    if (!call.hasWith()) continue;
                    arrayList.add(call);
                }
            }
            ++n3;
        }
        if (!arrayList.isEmpty()) {
            result = this.addTo(result, arrayList.toArray(new RfNamedElement[arrayList.size()]));
        }
        return result;
    }

    private RfNamedElement[] addTo(RfNamedElement[] result, RfNamedElement[] containers) {
        if (containers == null || containers.length == 0) {
            return result;
        }
        if (result == null || result.length == 0) {
            return containers;
        }
        RfNamedElement[] newResult = new RfNamedElement[result.length + containers.length];
        System.arraycopy(result, 0, newResult, 0, result.length);
        System.arraycopy(containers, 0, newResult, result.length, containers.length);
        return newResult;
    }

    public RfInterface[] getAllInterfaces() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfInterface) {
                result.add((RfInterface)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfInterface[result.size()]);
    }

    public RfPrimitive[] getAllPrimitives() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfPrimitive) {
                result.add((RfPrimitive)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfPrimitive[result.size()]);
    }

    public RfProgram[] getAllPrograms() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfProgram) {
                result.add((RfProgram)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfProgram[result.size()]);
    }

    public RfPropertySequence[] getAllProperties() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfPropertySequence && ((RfPropertySequence)namedElement).isProperty()) {
                result.add((RfPropertySequence)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfPropertySequence[result.size()]);
    }

    public RfPropertySequence[] getAllSequences() {
        ArrayList result = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfPropertySequence && ((RfPropertySequence)namedElement).isSequence()) {
                result.add((RfPropertySequence)namedElement);
            }
            return true;
        };
        this.accept(visitor);
        return result.toArray(new RfPropertySequence[result.size()]);
    }

    private RfClass getLocalProjectClass(String className) {
        RfClass[] classes;
        RfClass[] rfClassArray = classes = this.getAllClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            if (clazz.getName().equals(className)) {
                return clazz;
            }
            ++n2;
        }
        return null;
    }

    public RfClass getClass(String className, boolean useFullName) {
        RfClass[] classes;
        if (!useFullName) {
            return this.getLocalProjectClass(className);
        }
        RfClass[] rfClassArray = classes = this.getAllClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            if (clazz.getFullName().equals(className)) {
                return clazz;
            }
            ++n2;
        }
        return null;
    }

    public RfClass getClassFromLibrary(String fullClassName, RfLibrary scope) {
        RfClass[] classes;
        RfClass[] rfClassArray = classes = this.getAllClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            if (clazz.getFullName().equals(fullClassName) && clazz.getEnclosingLibrary().equals(scope)) {
                return clazz;
            }
            ++n2;
        }
        return null;
    }

    public RfDefElement[] getAllClassDefs(String className) {
        RfClass[] classes = this.getAllClasses();
        int length = 0;
        RfClass[] rfClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            if (className.equals(clazz.getName())) {
                length += ((RfNamedElement)clazz).getDeclarations().size();
            }
            ++n2;
        }
        RfDefElement[] result = new RfDefElement[length];
        int offset = 0;
        RfClass[] rfClassArray2 = classes;
        int n3 = classes.length;
        int n4 = 0;
        while (n4 < n3) {
            RfClass clazz = rfClassArray2[n4];
            if (clazz.getName().equals(className)) {
                Collection classDefs = ((RfNamedElement)clazz).getDeclarations();
                int index = 0;
                Iterator iterator = classDefs.iterator();
                while (iterator.hasNext()) {
                    RfDefElement classDef;
                    result[index + offset] = classDef = (RfDefElement)iterator.next();
                    ++index;
                }
                offset += classDefs.size();
            }
            ++n4;
        }
        return result;
    }

    @NotNull
    public VlogPreprocessingInfo getPreprocessingTable() {
        if (this.fRfProjectContent.fPreprocessingTable == null) {
            this.fRfProjectContent.fPreprocessingTable = new VlogPreprocessingInfo(this);
        }
        return this.fRfProjectContent.fPreprocessingTable;
    }

    public void addSourceFileToBuildFileMappingTopFiles(Integer invocNumber, Map<Integer, BuildFilePathLine> includedTopFiles) {
        if (this.fRfProjectContent.fSourceFileToBuildFileMapping == null) {
            return;
        }
        this.fRfProjectContent.fSourceFileToBuildFileMapping.addIncludedTopFiles(invocNumber, includedTopFiles);
    }

    public void addSourceFileToBuildFileMappingLibrary(Integer invocNumber, String fullLibPath, BuildFilePathLine includedLibrary) {
        if (this.fRfProjectContent.fSourceFileToBuildFileMapping == null) {
            return;
        }
        this.fRfProjectContent.fSourceFileToBuildFileMapping.addIncludedLibrary(invocNumber, fullLibPath, includedLibrary);
    }

    public SourceFileToBuildFileMapping getSourceFileToBuildFileMapping() {
        if (this.fRfProjectContent.fSourceFileToBuildFileMapping == null) {
            this.fRfProjectContent.fSourceFileToBuildFileMapping = new SourceFileToBuildFileMapping();
        }
        return this.fRfProjectContent.fSourceFileToBuildFileMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSemanticError(int severity, String pattern, LibraryPackageScope libraryPackageScope, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fProject)) {
            if (severity == 1) {
                PrecompiledDBManager.getInstance().reportLibrarySemanticError(libraryPackageScope.getLibraryName());
            }
            return true;
        }
        if (severity == 1 && !this.isSemanticErrorCheck()) {
            return true;
        }
        if (severity == 2 && !this.isSemanticWarningCheck()) {
            return true;
        }
        if (parserPath == null) {
            return true;
        }
        String resourcePath = this.parser2resource(parserPath);
        Object object = this.fSemanticErrorsLock;
        synchronized (object) {
            SemanticErrorsTable.LastProblemEntry removedProblem;
            boolean maxSizeReached;
            int nofProblems;
            SemanticErrorsTable.ErrorsAndWarnings errorsAndWarnings;
            int maxSemanticIssuesPerFile;
            block14: {
                maxSemanticIssuesPerFile = this.getMaxSemanticIssuesPerFile();
                this.addLintingSemanticError(severity, pattern, line, parserPath, arguments);
                errorsAndWarnings = this.fSemanticErrors.getNofErrorsAndWarnings(this.fSemanticErrorCategory, resourcePath);
                nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
                maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
                removedProblem = null;
                if (maxSizeReached) {
                    removedProblem = errorsAndWarnings.removeLastErrorOrWarningAfterLine(this.fSemanticErrorCategory, severity, line);
                    nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
                    boolean bl = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
                }
                if (!maxSizeReached) break block14;
                return true;
            }
            if (DVTLogger.INSTANCE.isDebugMode()) {
                fCount5.incrementAndGet();
            }
            String libraryName = libraryPackageScope.getLibraryName();
            String packageName = libraryPackageScope.getPackageName();
            String message = MessageFormat.format(pattern, arguments);
            if (PreprocDiffManager.INSTANCE.hasPreprocMacros(parserPath)) {
                int errorLength = PreprocDiffManager.INSTANCE.computePreprocErrorLength(parserPath, offsetStart, offsetEnd - offsetStart);
                offsetEnd = offsetStart + errorLength;
            }
            RfSemanticError error = new RfSemanticError(severity, message, this.getFileIndex(parserPath), libraryName, packageName, line, resourcePath);
            if (offsetStart != -1 && offsetEnd != -1) {
                error.setOffsetStart(offsetStart);
                error.setOffsetEnd(offsetEnd);
            }
            error.setAttributes(attributes);
            errorsAndWarnings.addErrorOrWarning(this.fSemanticErrorCategory, libraryPackageScope.getClosestTypeContainer(), error, this);
            nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
            boolean bl = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            if (removedProblem != null && !maxSizeReached) {
                errorsAndWarnings.addErrorOrWarning(this.fSemanticErrorCategory, removedProblem.lastTypeContainer, removedProblem.lastProblem, this);
            }
        }
        return true;
    }

    private void addLintingSemanticError(int severity, String pattern, int line, ParserPath parserPath, Object[] arguments) {
        if (this.ovmProject == null) {
            return;
        }
        this.ovmProject.addLintingSemanticError(severity, pattern, line, parserPath, arguments);
    }

    public final int getFileIndex(ParserPath parserPath) {
        RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return -1;
        }
        return fileDef.getIndex();
    }

    private void resolveClassParents(RfProject project) {
        ELManager localManager = new ELManager(project.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), this.fMixedLangProjectParent.getNonElabConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        IdentityHSet classes = new IdentityHSet(16);
        this.accept((RfNamedElement namedElement) -> {
            if (namedElement.isPredefined()) {
                return false;
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            if (namedElement instanceof RfClass) {
                ((RfClass)namedElement).resolveClassParent(project, null, null, (IdentityHSet<RfClass>)classes, RfTypesResolver.create(namedElement, null, localManager, 22), true);
            }
            return CLASS_CONTAINERS.contains(namedElement.getClass());
        });
        for (RfClass clazz : classes) {
            clazz.checkCircularInheritence(this);
        }
    }

    private void resolveClassParents(RfProject rfProject, IncrementalDeltaContainer container) {
        Map<ParserPath, Set<IRfNamedElement>> delta;
        IdentityHSet classes = new IdentityHSet(16);
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement.isPredefined()) {
                return false;
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            if (namedElement instanceof RfClass) {
                ((RfClass)namedElement).resolveClassParent(rfProject, null, incrementalDeltaContainer.changedTypeNames, (IdentityHSet<RfClass>)classes, RfTypesResolver.create((IRfScopeElement)namedElement, rfProject, 22), incrementalDeltaContainer.changedImports);
            }
            return CLASS_CONTAINERS.contains(namedElement.getClass());
        };
        Map<ParserPath, Collection<RfNamedElement>> firstLevelElementsInFile = container.firstLevelElements;
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        if (firstLevelElementsInFile != null && !firstLevelElementsInFile.isEmpty()) {
            for (Collection<RfNamedElement> firstLevelElements : firstLevelElementsInFile.values()) {
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    if (this.alreadyVisited(visited, firstLevelElement)) continue;
                    firstLevelElement.accept(rfProject, visitor);
                }
            }
        }
        if ((delta = container.delta) != null && !delta.isEmpty()) {
            for (Set<IRfNamedElement> changedElements : delta.values()) {
                if (changedElements == null || changedElements.isEmpty()) continue;
                for (IRfNamedElement changedElement : changedElements) {
                    if (!(changedElement instanceof RfNamedElement) || this.alreadyVisited(visited, changedElement)) continue;
                    ((RfNamedElement)changedElement).accept(rfProject, visitor);
                }
            }
        }
        for (RfClass clazz : classes) {
            clazz.checkCircularInheritence(this);
        }
    }

    private final boolean alreadyVisited(Set<IRfNamedElement> visited, IRfNamedElement element) {
        if (visited == null) {
            return false;
        }
        if (visited.contains(element)) {
            return true;
        }
        visited.add(element);
        return false;
    }

    private void resolveImports(final boolean report, final boolean thisLanguage, final boolean otherLanguage, final boolean force) {
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement.isPredefined()) {
                    return false;
                }
                if (namedElement instanceof RfDuplicate) {
                    return true;
                }
                if (namedElement instanceof RfMembersHolder || namedElement instanceof RfFunction) {
                    namedElement.resolveImports(RfProject.this, report, thisLanguage, otherLanguage, force, null, null);
                    return true;
                }
                return false;
            }
        };
        this.accept(visitor);
    }

    private void resolveImports(final IncrementalDeltaContainer container, final RfProject rfProject, final boolean report, final boolean thisLanguage, final boolean otherLanguage) {
        Map<ParserPath, Set<IRfNamedElement>> delta;
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement.isPredefined()) {
                    return false;
                }
                if (namedElement instanceof RfDuplicate) {
                    return true;
                }
                if (namedElement instanceof RfMembersHolder || namedElement instanceof RfFunction) {
                    namedElement.resolveImports(rfProject, report, thisLanguage, otherLanguage, false, container.changedTypeNames, container.addedImportInfos);
                    return true;
                }
                return false;
            }
        };
        Map<ParserPath, Collection<RfNamedElement>> firstLevelElementsInFile = container.firstLevelElements;
        RfNamedElement enclosingScopeOfCurrentFile = null;
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        if (firstLevelElementsInFile != null && !firstLevelElementsInFile.isEmpty()) {
            for (Collection<RfNamedElement> firstLevelElements : firstLevelElementsInFile.values()) {
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    if (enclosingScopeOfCurrentFile == null) {
                        enclosingScopeOfCurrentFile = firstLevelElement.getEnclosingScope();
                    }
                    if (this.alreadyVisited(visited, firstLevelElement)) continue;
                    firstLevelElement.accept(rfProject, visitor);
                }
            }
        }
        if (enclosingScopeOfCurrentFile != null) {
            enclosingScopeOfCurrentFile.resolveImports(rfProject, report, thisLanguage, otherLanguage, false, container.changedTypeNames, container.addedImportInfos);
        }
        if ((delta = container.delta) != null && !delta.isEmpty()) {
            for (Set<IRfNamedElement> changedElements : delta.values()) {
                if (changedElements == null || changedElements.isEmpty()) continue;
                for (IRfNamedElement changedElement : changedElements) {
                    if (!(changedElement instanceof RfNamedElement) || this.alreadyVisited(visited, changedElement)) continue;
                    ((RfNamedElement)changedElement).accept(rfProject, visitor);
                }
            }
        }
    }

    @Override
    public final String getDefaultNetType(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
        if (declaration == null || declaration.getDefFile() == null) {
            return "wire";
        }
        ParserPath parserPath = declaration.getParserPath();
        int elementLine = declaration.getStartLine();
        return this.getDefaultNetType(parserPath, elementLine);
    }

    private final String getDefaultNetType(ParserPath parserPath, int elementLine) {
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        String defaultNettype = topInstance.getDefaultNetType(parserPath, elementLine);
        if (defaultNettype == null) {
            defaultNettype = "wire";
        }
        return defaultNettype;
    }

    @Override
    public HidImplicit[] getTimescale(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
        if (declaration == null || declaration.getDefFile() == null) {
            return RfInstanceHolder.DEFAULT_TIMESCALE;
        }
        ParserPath parserPath = declaration.getParserPath();
        int elementLine = declaration.getStartLine();
        return this.getTimescaleType(parserPath, elementLine);
    }

    private final HidImplicit[] getTimescaleType(ParserPath parserPath, int elementLine) {
        BuildConfigProperty overrideTimescaleProperty = BuildConfigManager.getOverrideTimescaleConfigurationProperty((IProject)this.fProject);
        HidImplicit[] overrideTimescale = Utils.getInstance().computeTimescale(overrideTimescaleProperty);
        if (overrideTimescale != null) {
            return overrideTimescale;
        }
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        HidImplicit[] fileTimescale = topInstance.getTimescale(parserPath, elementLine);
        if (fileTimescale != null) {
            return fileTimescale;
        }
        BuildConfigProperty buildConfigTimescaleProperty = BuildConfigManager.getTimescaleConfigurationProperty((IProject)this.fProject);
        HidImplicit[] buildConfigTimescale = Utils.getInstance().computeTimescale(buildConfigTimescaleProperty);
        return buildConfigTimescale != null ? buildConfigTimescale : RfInstanceHolder.DEFAULT_TIMESCALE;
    }

    public final void cleanResolvedConfigurations() {
        if (this.fRfProjectContent.fLibraries == null || this.fRfProjectContent.fLibraries.isEmpty()) {
            return;
        }
        for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
            List<RfConfiguration> configurations = library.getLocalMembers(RfConfiguration.class);
            if (configurations == null) continue;
            for (RfConfiguration config : configurations) {
                config.cleanResolved();
            }
        }
    }

    private static List<IRfLibraryElement> resolveLiblist(RfProject rfProject, List<Identifier> liblist) {
        block4: {
            if (liblist != null && !liblist.isEmpty()) break block4;
            return null;
        }
        try {
            ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
            for (Identifier libraryName : liblist) {
                List<IRfLibraryElement> libraries = RfProject.getLibraries(rfProject, libraryName.getName());
                if (libraries == null || libraries.isEmpty()) continue;
                result.addAll(libraries);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static List<IRfLibraryElement> getLibraries(RfProject rfProject, String libraryName) {
        RfMixedLangProject mixedLangProject;
        IRfLibraryElement otherLibrary;
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        RfLibrary library = rfProject.getLibraryWithPrefix(libraryName, 1);
        if (library != null) {
            result.add(library);
        }
        if ((otherLibrary = (mixedLangProject = rfProject.getMixedLangProjectParent()).getLibraryWithPrefix((IRfSingleLangProject)rfProject, libraryName, 1)) != null) {
            result.add(otherLibrary);
        }
        return result;
    }

    public void resolveConfigurations() {
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        for (RfLibrary library : libraries) {
            List<RfConfiguration> configs = library.getConfigurationsWithPrefix("", 2);
            if (configs == null || configs.isEmpty()) continue;
            for (RfConfiguration config : configs) {
                config.resolveConfiguration(this);
            }
        }
    }

    public IRfConfiguration resolveDesignOrConfigInLibrary(IRfLibraryElement library, String configName, boolean isConfigOnly) {
        if (!(library instanceof RfLibrary) || configName == null) {
            return null;
        }
        if (isConfigOnly) {
            return ((RfLibrary)library).getLocalMember(RfConfiguration.class, configName, true);
        }
        final IRfNamedElement topElement = library.getLocalMember(DVTRfUtils.MEMBERS_DESIGN, configName, null);
        if (topElement != null) {
            DVTImplicitConfiguration implicitConfig = new DVTImplicitConfiguration(topElement.getName(), topElement.getEnclosingLibrary(), new ArrayList<IRfDesignElement>(Arrays.asList((IRfDesignElement)topElement))){
                private static final long serialVersionUID = 1L;
                private List<IRfLibraryElement> defaultLiblist;

                public void init() {
                    this.defaultLiblist = RfProject.resolveLiblist(RfProject.this, RfProject.this.getNoConfigLiblist());
                }

                public List<IRfLibraryElement> getDefaultLiblist() {
                    return this.defaultLiblist;
                }

                public void setDefaultLiblist(List<IRfLibraryElement> libList) {
                    this.defaultLiblist = libList;
                }

                public boolean isDummyConfig() {
                    return true;
                }

                public IRfSingleLangProject getRfProject() {
                    return topElement.getRfProject();
                }
            };
            return implicitConfig;
        }
        IRfNamedElement topPackage = ((RfLibrary)library).getLocalMember(Collections.singleton(RfPackage.class), configName, (IRfNamedElement)null);
        if (topPackage instanceof IRfPackageElement) {
            return new DVTPackageConfiguration(configName, (IRfLibraryElement)topPackage.getEnclosingLibrary(), (IRfPackageElement)topPackage);
        }
        return ((RfLibrary)library).getLocalMember(RfConfiguration.class, configName, true);
    }

    private List<Identifier> getNoConfigLiblist() {
        String libName;
        HashSet<String> alreadyIncluded = new HashSet<String>();
        ArrayList<Identifier> result = new ArrayList<Identifier>();
        List invocations = BuildConfigManager.getInvocations((IProject)this.fProject);
        if (invocations != null) {
            for (Invocation invocation : invocations) {
                libName = invocation.getLibName();
                if (alreadyIncluded.contains(libName)) continue;
                alreadyIncluded.add(libName);
                result.add(new Identifier(libName, -1, -1));
            }
        }
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
                libName = this.adjustLibraryName(library.getName());
                if (alreadyIncluded.contains(libName)) continue;
                alreadyIncluded.add(libName);
                result.add(new Identifier(libName, -1, -1));
            }
        }
        return result;
    }

    public void checkIfExistImplicitIncludedGenerateBlocks(RfNamedElement scope, RfDefElement def) {
        if (!(def instanceof RfGenerateHolderDef) || scope == null) {
            return;
        }
        RfGenerateHolderDef holderDef = (RfGenerateHolderDef)def;
        List<RfGenerateBlock> generateBlocks = scope.getLocalMembers(RfGenerateBlock.class);
        if (generateBlocks != null && !generateBlocks.isEmpty()) {
            for (RfGenerateBlock generateBlock : generateBlocks) {
                if (!generateBlock.hasImplicitName() || generateBlock.hasNoDefs(true)) continue;
                holderDef.setHasImplicitIncludedGenerateBlocks(true);
                holderDef.setHasImplicitGenerateBlocks(true);
                return;
            }
        }
    }

    private void resolveLocalImplicitGenerateBlocksInElement(RfDefElement def, RfNamedElement scope) {
        if (!(scope != null && def instanceof RfGenerateHolderDef && (((RfGenerateHolderDef)def).hasImplicitGenerateBlocks() || this.fIncrementalBuild && ((RfGenerateHolderDef)def).hasImplicitIncludedGenerateBlocks()))) {
            return;
        }
        DVTLinkedHashMap<String, RfNamedElement> originalMembers = scope.getLocalMembers(true);
        if (originalMembers == null || originalMembers.isEmpty()) {
            return;
        }
        RfGenerateHolderDef holderDef = (RfGenerateHolderDef)def;
        ArrayList members = new ArrayList(originalMembers.values());
        List<RfGenerateBlock> generateBlocks = scope.getLocalMembers(RfGenerateBlock.class);
        if (generateBlocks != null && !generateBlocks.isEmpty()) {
            if (this.fIncrementalBuild && holderDef.hasImplicitIncludedGenerateBlocks()) {
                ArrayList<RfGenerateBlock> newGenerateBlocks = new ArrayList<RfGenerateBlock>(generateBlocks.size());
                for (RfGenerateBlock generateBlock : generateBlocks) {
                    if (generateBlock.hasNoDefs(true)) continue;
                    newGenerateBlocks.add(generateBlock);
                }
                newGenerateBlocks.sort((generateBlock1, generateBlock2) -> generateBlock1.isDeclaredBefore(this, (RfNamedElement)generateBlock2) ? -1 : 1);
                int constructIndex = 0;
                Iterator<RfNamedElement> iterator = newGenerateBlocks.iterator();
                while (iterator.hasNext()) {
                    RfGenerateBlock generateBlock;
                    generateBlock.setGenerateConstructIndex((generateBlock = (RfGenerateBlock)iterator.next()).isOptionalBranch() ? constructIndex : ++constructIndex);
                }
            }
            for (RfGenerateBlock generateBlock : generateBlocks) {
                if (generateBlock.hasNoDefs(true) || !generateBlock.hasImplicitName()) continue;
                int index = generateBlock.getGenerateConstructIndex();
                StringBuilder implicitName = new StringBuilder("genblk");
                while (scope.hasNamedMember(new StringBuilder(implicitName).append(index).toString())) {
                    implicitName.append("0");
                }
                implicitName.append(index);
                generateBlock.setName(implicitName.toString(), false);
            }
        }
        scope.internalGetMembers().clear();
        for (RfNamedElement member : members) {
            if (this.fIncrementalBuild && member instanceof RfDuplicate) {
                for (RfNamedElement duplicateMember : member.getMembers()) {
                    if (duplicateMember.hasNoDefs(true)) continue;
                    scope.addMember(duplicateMember);
                }
                continue;
            }
            if (this.fIncrementalBuild && member.hasNoDefs(true)) continue;
            scope.addMember(member);
        }
        holderDef.setHasImplicitGenerateBlocks(false);
        holderDef.setHasImplicitIncludedGenerateBlocks(false);
    }

    private final void checkForDuplicates(Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.checkForDuplicates(visited, libraries, fullChecksKind, onlyLibAndPkgNames);
    }

    private final void checkForDuplicates(IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.checkForDuplicates(visited, container, fullChecksKind, onlyLibAndPkgNames);
    }

    private final void checkForDuplicates(Set<IRfNamedElement> visited, Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        for (RfNamedElement rfNamedElement : libraries) {
            Set<String> onlyPkgNames = null;
            if (onlyLibAndPkgNames != null) {
                String libraryName = rfNamedElement.getName();
                if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
            }
            this.checkForDuplicates(rfNamedElement, fullChecksKind, onlyPkgNames, visited, null);
        }
    }

    private final void checkForDuplicates(Set<IRfNamedElement> visited, IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        if (container.firstLevelElements != null && !container.firstLevelElements.isEmpty()) {
            for (Collection<RfNamedElement> firstLevelElements : container.firstLevelElements.values()) {
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    RfNamedElement enclosingScope;
                    Set<String> onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library = firstLevelElement.getEnclosingLibrary();
                        if (library == null) continue;
                        String libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                        onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                    }
                    if ((enclosingScope = firstLevelElement.getEnclosingScope()) == null) continue;
                    RfDuplicate duplicateCandidate = enclosingScope.getLocalMember(RfDuplicate.class, firstLevelElement.getName(), false, false);
                    if (duplicateCandidate != null) {
                        this.checkForDuplicates(duplicateCandidate, fullChecksKind, onlyPkgNames, visited, null);
                        continue;
                    }
                    this.checkForDuplicates(firstLevelElement, fullChecksKind, onlyPkgNames, visited, null);
                }
            }
        }
        if (container.currentFileScopes != null && !container.currentFileScopes.isEmpty()) {
            Set<ParserPath> changedFiles = container.getParserPaths();
            for (RfNamedElement currentFileEnclosingScope : container.currentFileScopes) {
                Set<String> onlyPkgNames = null;
                if (onlyLibAndPkgNames != null) {
                    RfLibrary library = currentFileEnclosingScope.getEnclosingLibrary();
                    if (library == null) continue;
                    String libraryName = library.getName();
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                    onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                }
                this.checkForDuplicates(changedFiles, currentFileEnclosingScope);
            }
        }
    }

    private final void checkForDuplicates(RfNamedElement root, FullChecksKind fullChecksKind, Set<String> onlyPkgNames, Set<IRfNamedElement> visited, final Set<ParserPath> changedFiles) {
        if (root.isPredefined() && root.hasNoDefs(false)) {
            return;
        }
        if (visited.contains(root)) {
            return;
        }
        visited.add(root);
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement element) {
                try {
                    return RfProject.this.checkForDuplicates(changedFiles, element);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return true;
                }
            }
        };
        if (onlyPkgNames != null && root instanceof RfPackage) {
            if (fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(root.getName())) {
                return;
            }
            if (fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(root.getName())) {
                return;
            }
        }
        root.accept(this, visitor);
    }

    private boolean checkForDuplicates(Set<ParserPath> changedFiles, RfNamedElement element) {
        block64: {
            Map<String, RfNamedElement> enumElements;
            block73: {
                int endOffset;
                RfDefElement declaration;
                RfNamedElement clazz;
                RfDefElement prevImplementation;
                RfDefElement prevPrototype;
                String constraintName;
                RfConstraint constraint;
                block74: {
                    block72: {
                        IRfElementFilter composedFilter;
                        RfNamedElement duplicateElement;
                        String name;
                        block68: {
                            int protoArgsSize;
                            List<ArgInfo> implArgs;
                            List<ArgInfo> protoArgs;
                            RfNamedElement clazz2;
                            RfDefElement prevImplementation2;
                            String funcName;
                            RfFunction func;
                            block71: {
                                int implArgsSize;
                                RfDefElement prevPrototype2;
                                block70: {
                                    block69: {
                                        block66: {
                                            Iterator fieldDefs;
                                            RfDefElement firstDef;
                                            RfFunctionDef enclosingFuncDef;
                                            RfNamedElement enclosing;
                                            block67: {
                                                block65: {
                                                    block63: {
                                                        if (element.isPredefined() && element.hasNoDefs(false)) {
                                                            return false;
                                                        }
                                                        if (element.isAnonymous()) {
                                                            return true;
                                                        }
                                                        if (!(element instanceof RfDuplicate)) break block63;
                                                        Map<Boolean, List<RfNamedElement>> membersPerKind = this.getDuplicateMembersPerKind(element);
                                                        if (membersPerKind == null) break block64;
                                                        for (List<RfNamedElement> members : membersPerKind.values()) {
                                                            if (members.size() == 1) continue;
                                                            RfNamedElement member0 = null;
                                                            RfDefElement declaration0 = null;
                                                            RfDefElement declaration2 = null;
                                                            for (RfNamedElement member : members) {
                                                                int endOffset2;
                                                                if (member instanceof RfForwardTypedef || member instanceof RfActionBlock || member instanceof RfCovergroup && member.isAnonymous()) continue;
                                                                if (member0 == null && declaration0 == null) {
                                                                    declaration0 = member.getDeclaration();
                                                                    member0 = member;
                                                                } else {
                                                                    declaration2 = member.getDeclaration();
                                                                }
                                                                if (member0 instanceof RfFragment || member0 instanceof RfField && !(member0 instanceof RfCoverpoint) && member instanceof RfCoverpoint || member instanceof RfFragment || member instanceof RfField && !(member instanceof RfCoverpoint) && member0 instanceof RfCoverpoint || member instanceof RfGenerateBlock && declaration2 != null && declaration0 != null && declaration0.getNamedElement() instanceof RfGenerateBlock && ((RfGenerateBlock)member).getGenerateConstructIndex() == ((RfGenerateBlock)declaration0.getNamedElement()).getGenerateConstructIndex() || this.checkForDuplicatesOfClassPredefinedMethod(member) || member0 == null || declaration0 == null || declaration2 == null) continue;
                                                                LibraryPackageScope libPkgScope = member.getLibPkgScope();
                                                                int line0 = declaration0.getLabelStartLine();
                                                                int line = declaration2.getLabelStartLine();
                                                                ParserPath parserPath0 = declaration0.getParserPath();
                                                                ParserPath parserPath = declaration2.getParserPath();
                                                                boolean hasImplicitName = member instanceof RfGenerateBlock && ((RfGenerateBlock)member).hasImplicitName();
                                                                int startOffset = hasImplicitName ? -1 : declaration2.getLabelStartOffset();
                                                                String name2 = member.getName();
                                                                int n = endOffset2 = hasImplicitName ? -1 : startOffset + name2.length();
                                                                if (declaration0.getDefFile() == declaration2.getDefFile() && declaration0.getStartOffset() == declaration2.getStartOffset()) continue;
                                                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                                                attributes.put("QUICKFIX_ELEMENT_NAME", name2);
                                                                attributes.put("QUICKFIX_KIND", 11);
                                                                if (member instanceof RfForwardTypedef && member0 instanceof RfForwardTypedef || this.isForwardDeclaration(member, member0)) continue;
                                                                if (!member.getClass().equals(member0.getClass())) {
                                                                    this.addSemanticError(1, "DUPLICATE_NAME: Duplicate name ''{0}'', already declared\n    at line {1,number,#######} in {2}", libPkgScope, startOffset, endOffset2, attributes, line, parserPath, name2, line0, parserPath0);
                                                                    continue;
                                                                }
                                                                this.addSemanticError(member.getSemanticErrorSeverityForDuplicate(), member.getSemanticErrorCodeForDuplicate(), libPkgScope, startOffset, endOffset2, attributes, line, parserPath, name2, line0, parserPath0);
                                                            }
                                                        }
                                                        break block64;
                                                    }
                                                    if (this.checkForDuplicatesOfClassPredefinedMethod(element)) {
                                                        return true;
                                                    }
                                                    name = element.getName();
                                                    if (!(element instanceof RfPort)) break block65;
                                                    RfNamedElement enclosing2 = element.getEnclosingScope();
                                                    Collection declarations = element.getDeclarations();
                                                    if (!(enclosing2 instanceof RfInstanceHolder) || declarations.size() <= 1) break block64;
                                                    boolean isAnsi = !((RfInstanceHolder)enclosing2).isNonAnsi();
                                                    DataType dataType = ((RfPort)element).getDataType();
                                                    Iterator declIterator = declarations.iterator();
                                                    RfDefElement firstDef2 = (RfDefElement)declIterator.next();
                                                    if (firstDef2 instanceof RfPortDef) {
                                                        boolean hasDirection;
                                                        boolean firstDefIsInListOfPorts = ((RfPortDef)firstDef2).isInListOfPorts();
                                                        boolean isAnsiRedeclaration = isAnsi && firstDefIsInListOfPorts && !((RfPortDef)firstDef2).getRawDataType(element).isFullyEmpty();
                                                        boolean hasUnpackedDimension = isAnsi && firstDefIsInListOfPorts && dataType.getUnpackedDimension() == null;
                                                        boolean bl = hasDirection = !isAnsi && !dataType.hasImplicitDirection();
                                                        if (isAnsiRedeclaration || hasDirection || hasUnpackedDimension) {
                                                            int directionCounter;
                                                            LibraryPackageScope libPkgScope = element.getLibPkgScope();
                                                            DataType firstDefDataType = firstDef2.getRawDataType(element);
                                                            int n = directionCounter = !isAnsi && firstDefDataType != null && !firstDefIsInListOfPorts && !firstDefDataType.hasImplicitDirection() ? 1 : 0;
                                                            int directionSelector = ((RfPort)element).isInout() ? 2 : (((RfPort)element).isOutput() ? 1 : 0);
                                                            while (declIterator.hasNext()) {
                                                                DataType declDataType;
                                                                RfDefElement declaration3 = (RfDefElement)declIterator.next();
                                                                if (!(declaration3 instanceof RfPortDef)) continue;
                                                                int line = declaration3.getStartLine();
                                                                int startOffset = declaration3.getStartOffset();
                                                                int endOffset3 = startOffset + name.length();
                                                                ParserPath parserPath = declaration3.getParserPath();
                                                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                                                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                                                attributes.put("QUICKFIX_KIND", 11);
                                                                boolean declIsInListOfPorts = ((RfPortDef)declaration3).isInListOfPorts();
                                                                boolean declHasDirection = false;
                                                                if (hasDirection && !declIsInListOfPorts && (declDataType = declaration3.getRawDataType(element)) != null && !declDataType.hasImplicitDirection()) {
                                                                    declHasDirection = true;
                                                                    ++directionCounter;
                                                                }
                                                                if (hasUnpackedDimension && declIsInListOfPorts) {
                                                                    this.addSemanticError(element.getSemanticErrorSeverityForDuplicate(), "DUPLICATE_PORT: Duplicate port ''{0}'', already declared\n    at line {1,number,#######} in {2}", libPkgScope, startOffset, endOffset3, attributes, line, parserPath, name, firstDef2.getStartLine(), firstDef2.getParserPath());
                                                                    continue;
                                                                }
                                                                if (isAnsiRedeclaration) {
                                                                    this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_ANSI_PORT_REDECLARATION, libPkgScope, startOffset, endOffset3, attributes, line, parserPath, name);
                                                                    continue;
                                                                }
                                                                if (!declHasDirection || directionCounter <= true) continue;
                                                                this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_REDUNDANT_NON_ANSI_PORT_DIRECTION, libPkgScope, startOffset, endOffset3, attributes, line, parserPath, name, directionSelector);
                                                            }
                                                        }
                                                    }
                                                    break block64;
                                                }
                                                if (!(element instanceof RfField) || element instanceof RfPredefinedField) break block66;
                                                enclosing = element.getEnclosingScope();
                                                if (!(enclosing instanceof RfFunction) || enclosing.isPredefined()) break block64;
                                                if (!name.equals(enclosing.getName())) break block67;
                                                DataType dataType = ((RfFunction)enclosing).getDataType();
                                                if (dataType == null || "void".equals(dataType.getType())) break block64;
                                                RfDefElement declaration1 = enclosing.getDeclaration();
                                                RfDefElement declaration2 = element.getDeclaration();
                                                if (declaration1 != null && declaration2 != null && declaration1.getDefFile() != null && declaration2.getDefFile() != null) {
                                                    int line = declaration2.getStartLine();
                                                    int startOffset = declaration2.getStartOffset();
                                                    int endOffset4 = startOffset + name.length();
                                                    ParserPath parserPath = declaration2.getParserPath();
                                                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                                    attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                                    attributes.put("QUICKFIX_KIND", 11);
                                                    if (declaration1.getDefFile() != declaration2.getDefFile() || declaration1.getStartOffset() != declaration2.getStartOffset()) {
                                                        this.addSemanticError(element.getSemanticErrorSeverityForDuplicate(), "DUPLICATE_VARIABLE: Duplicate variable ''{0}'', already declared\n    at line {1,number,#######} in {2}", element.getLibPkgScope(), startOffset, endOffset4, attributes, line, parserPath, name, declaration1.getStartLine(), declaration1.getParserPath());
                                                    }
                                                }
                                                break block64;
                                            }
                                            if (!((RfField)element).isArgument() || ((RfFunction)enclosing).isExtern() || ((RfFunction)enclosing).isImportDPI() || (enclosingFuncDef = (RfFunctionDef)((RfFunction)enclosing).getImplementation()) == null || !enclosingFuncDef.isANSIStyle() || !((firstDef = (RfDefElement)(fieldDefs = ((RfField)element).getDeclarations().iterator()).next()) instanceof RfFieldDef) || ((RfFieldDef)firstDef).getRawDataType(element).isFullyEmpty()) break block64;
                                            LibraryPackageScope libPkgScope = element.getLibPkgScope();
                                            while (fieldDefs.hasNext()) {
                                                RfDefElement declaration4 = (RfDefElement)fieldDefs.next();
                                                int line = declaration4.getStartLine();
                                                int startOffset = declaration4.getStartOffset();
                                                int endOffset5 = startOffset + name.length();
                                                ParserPath parserPath = declaration4.getParserPath();
                                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                                attributes.put("QUICKFIX_KIND", 11);
                                                this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_ANSI_ARGUMENT_REDECLARATION, libPkgScope, startOffset, endOffset5, attributes, line, parserPath, name);
                                            }
                                            break block64;
                                        }
                                        if (!(element instanceof RfFunction) || element instanceof RfPredefinedFunction) break block68;
                                        func = (RfFunction)element;
                                        Collection funcDefs = func.getDeclarations();
                                        funcName = name;
                                        prevPrototype2 = null;
                                        prevImplementation2 = null;
                                        RfDefElement prevCompleteDecl = null;
                                        RfDefElement prevExportDPI = null;
                                        clazz2 = func.getEnclosingScope();
                                        for (RfDefElement funcDef : funcDefs) {
                                            int line = funcDef.getStartLine();
                                            int startOffset = funcDef.getStartOffset();
                                            int endOffset6 = startOffset + funcName.length();
                                            ParserPath parserPath = funcDef.getParserPath();
                                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                            attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                            attributes.put("QUICKFIX_KIND", 11);
                                            if (((RfFunctionDef)funcDef).isPrototype() && func.isExtern()) {
                                                if (prevPrototype2 != null && RfProject.areInTheSameParentLayer(funcDef, prevPrototype2, clazz2)) {
                                                    this.addSemanticError(func.getSemanticErrorSeverityForDuplicate(), func.getSemanticErrorCodeForDuplicate(), func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, prevPrototype2.getStartLine(), prevPrototype2.getParserPath());
                                                }
                                                prevPrototype2 = funcDef;
                                            } else if (((RfFunctionDef)funcDef).isOutOfClassDefinition()) {
                                                if (prevImplementation2 != null) {
                                                    this.addSemanticError(1, func.getSemanticErrorCodeForDuplicateImpl(), func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, prevImplementation2.getStartLine(), prevImplementation2.getParserPath());
                                                }
                                                if (((RfFunctionDef)funcDef).getFunctionKind() != func.getFunctionKind()) {
                                                    this.addSemanticError(1, "EXTERN_METHOD_KIND: {1} ''{0}'' was declared as a {2} inside class ''{3}''", func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, DVTStringUtil.toTitleCase((String)RfFunction.getFunctionKindName(((RfFunctionDef)funcDef).getFunctionKind())), RfFunction.getFunctionKindName(func.getFunctionKind()), clazz2.getName(), funcDef.getStartLine(), funcDef.getParserPath());
                                                }
                                                prevImplementation2 = funcDef;
                                            } else if (((RfFunctionDef)funcDef).isExportDPI()) {
                                                if (prevExportDPI != null) {
                                                    this.addSemanticError(1, func.getSemanticErrorCodeForDuplicate(), func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, prevExportDPI.getStartLine(), prevExportDPI.getParserPath());
                                                }
                                                prevExportDPI = funcDef;
                                            } else {
                                                if (prevCompleteDecl != null && RfProject.areInTheSameParentLayer(funcDef, prevCompleteDecl, clazz2)) {
                                                    this.addSemanticError(func.getSemanticErrorSeverityForDuplicate(), func.getSemanticErrorCodeForDuplicate(), func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, prevCompleteDecl.getStartLine(), prevCompleteDecl.getParserPath());
                                                }
                                                prevCompleteDecl = funcDef;
                                            }
                                            if (!((RfFunctionDef)funcDef).isOutOfClassScope()) continue;
                                            this.addSemanticError(RfSemanticError.getNonStandardSeverity(), func.getSemanticErrorCodeForImplementationScope(), func.getLibPkgScope(), startOffset, endOffset6, attributes, line, parserPath, funcName, clazz2.getName());
                                        }
                                        if (prevPrototype2 == null || prevImplementation2 != null) break block69;
                                        Set<RfNamedElement> namedElementsWithEncryptedCode = this.getNamedElementsWithEncryptedCode();
                                        int semanticErrorType = element.getEnclosingScope() != null && (namedElementsWithEncryptedCode.contains(element.getEnclosingScope()) || namedElementsWithEncryptedCode.contains(element.getEnclosingScope().getEnclosingScope())) ? 2 : 1;
                                        RfDefElement declaration5 = func.getDeclaration();
                                        int line = declaration5.getStartLine();
                                        int startOffset = declaration5.getStartOffset();
                                        int endOffset7 = startOffset + funcName.length();
                                        ParserPath parserPath = declaration5.getParserPath();
                                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 33);
                                        this.addSemanticError(semanticErrorType, func.getSemanticErrorCodeForUnimplemented(), func.getLibPkgScope(), startOffset, endOffset7, attributes, line, parserPath, funcName);
                                        break block64;
                                    }
                                    if (prevImplementation2 == null || prevPrototype2 != null || clazz2 == null || clazz2 instanceof RfFragment) break block70;
                                    RfDefElement declaration6 = func.getDeclaration();
                                    int line = declaration6.getStartLine();
                                    int startOffset = declaration6.getStartOffset();
                                    int endOffset8 = startOffset + funcName.length();
                                    ParserPath parserPath = declaration6.getParserPath();
                                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                    attributes.put("QUICKFIX_KIND", 60);
                                    this.addSemanticError(1, func.getSemanticErrorCodeForNotExtern(), func.getLibPkgScope(), startOffset, endOffset8, attributes, line, parserPath, funcName, clazz2.getName());
                                    break block64;
                                }
                                if (!(prevPrototype2 instanceof RfFunctionDef) || !(prevImplementation2 instanceof RfFunctionDef)) break block64;
                                String typeName = func.implicitTypeName();
                                DataType protoDataType = ((RfFunctionDef)prevPrototype2).getTypeInfoOrImplicit(typeName, func);
                                DataType implDataType = ((RfFunctionDef)prevImplementation2).getTypeInfoOrImplicit(typeName, func);
                                IRfNamedElement assocType = func.getAssociatedType();
                                protoArgs = ((RfFunctionDef)prevPrototype2).getArgumentInfos();
                                implArgs = ((RfFunctionDef)prevImplementation2).getArgumentInfos();
                                protoArgsSize = protoArgs == null ? 0 : protoArgs.size();
                                int n = implArgsSize = implArgs == null ? 0 : implArgs.size();
                                if (!func.isLet() && !func.isConstructor() && protoDataType != null && protoDataType.getType() != null && implDataType != null && this.isNonStdAliasImplReturnType(protoDataType, implDataType)) {
                                    implTypeName = implDataType.getTypeName("logic", null);
                                    line = implDataType.getLine() < 0 ? prevImplementation2.getStartLine() : implDataType.getLine();
                                    startOffset = implDataType.getOffset();
                                    endOffset = startOffset + implTypeName.length();
                                    parserPath = prevImplementation2.getParserPath();
                                    attributes = new HashMap<String, Object>(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                    attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)func).toString());
                                    attributes.put("QUICKFIX_KIND", 34);
                                    if (this.equalsReturnType(func, clazz2, protoDataType, implDataType)) {
                                        this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_EXTERN_METHOD_RETURN_TYPE_3, func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implTypeName, funcName);
                                    } else {
                                        this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Return type ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implTypeName, funcName);
                                    }
                                } else if (!(func.isLet() || func.isConstructor() || protoDataType == null || protoDataType.getType() == null || implDataType == null || assocType == null || !this.compareTypeEnclosing(assocType, func) || implDataType.getPackageScope() != null && implDataType.getPackageScope().getType() != null && assocType.getEnclosingScope().getName().equals(implDataType.getPackageScope().getType()))) {
                                    implTypeName = implDataType.getTypeName("logic", null);
                                    line = implDataType.getLine() < 0 ? prevImplementation2.getStartLine() : (implDataType.getPackageScope() == null ? implDataType.getLine() : implDataType.getPackageScope().getLine());
                                    startOffset = implDataType.getPackageScope() == null ? implDataType.getOffset() : implDataType.getPackageScope().getOffset();
                                    endOffset = startOffset + implTypeName.length();
                                    parserPath = prevImplementation2.getParserPath();
                                    if (implDataType.getPackageScope() == null || implDataType.getPackageScope().getType() == null) {
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", implTypeName);
                                        attributes.put("QUICKFIX_KIND", 49);
                                        this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_EXTERN_METHOD_RETURN_TYPE_2, func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implTypeName, funcName);
                                    } else {
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)func).toString());
                                        attributes.put("QUICKFIX_KIND", 34);
                                        this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Return type ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implTypeName, funcName);
                                    }
                                } else if (!(func.isLet() || func.isConstructor() || protoDataType == null || protoDataType.getType() == null || implDataType == null || protoDataType.equalsDataTypeDimension(implDataType, String.valueOf(func.getEnclosingScope().getName()) + "::"))) {
                                    implTypeName = implDataType.getTypeName("logic", null);
                                    line = implDataType.getLine() < 0 ? prevImplementation2.getStartLine() : implDataType.getLine();
                                    startOffset = implDataType.getOffset();
                                    endOffset = startOffset + implTypeName.length();
                                    parserPath = prevImplementation2.getParserPath();
                                    attributes = new HashMap(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                    attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)func).toString());
                                    attributes.put("QUICKFIX_KIND", 34);
                                    this.addSemanticError(2, "EXTERN_METHOD_SIGNATURE: Return type ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implTypeName, funcName);
                                }
                                if (protoArgsSize == implArgsSize) break block71;
                                int line = prevImplementation2.getStartLine();
                                int startOffset = prevImplementation2.getStartOffset();
                                int endOffset9 = startOffset + func.getName().length();
                                ParserPath parserPath = prevImplementation2.getParserPath();
                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)func).toString());
                                attributes.put("QUICKFIX_KIND", 34);
                                this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Number of arguments ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset9, attributes, line, parserPath, implArgsSize, funcName);
                                break block64;
                            }
                            if (protoArgs == null || implArgs == null || protoArgsSize <= 0) break block64;
                            int i = 0;
                            while (i < protoArgsSize) {
                                ArgInfo protoArg = protoArgs.get(i);
                                ArgInfo implArg = implArgs.get(i);
                                String protoArgName = protoArg.getName();
                                String implArgName = implArg.getName();
                                String protoArgInitVal = protoArg.getInitialValue();
                                String implArgInitVal = implArg.getInitialValue();
                                DataType protoArgDT = protoArg.getDataType();
                                DataType implArgDT = implArg.getDataType();
                                if (protoArgName != null && implArgName != null) {
                                    if (!protoArgName.startsWith("<unknown_arg_name_") && !protoArgName.equals(implArgName)) {
                                        line = implArg.getStartLine();
                                        startOffset = implArg.getStartInfo().realOffset;
                                        endOffset = startOffset + implArgName.length();
                                        parserPath = prevImplementation2.getParserPath();
                                        attributes = new HashMap<String, Object>(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 34);
                                        this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Name of argument ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                    } else if (protoArgDT != null && !protoArgDT.equalsDataTypeTypeName(implArgDT)) {
                                        line = implArg.getStartLine();
                                        startOffset = implArg.getStartInfo().realOffset;
                                        endOffset = startOffset + implArgName.length();
                                        parserPath = prevImplementation2.getParserPath();
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 34);
                                        if (this.equalsReturnType(func, clazz2, protoArgDT, implArgDT)) {
                                            this.addSemanticError(RfSemanticError.getNonStandardSeverity(), RfSemanticError.NON_STANDARD_EXTERN_METHOD_ARG_TYPE_2, func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                        } else {
                                            this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Type of argument ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                        }
                                    } else if (protoArgDT != null && !protoArgDT.equalsDataTypeDimension(implArgDT, String.valueOf(func.getEnclosingScope().getName()) + "::")) {
                                        line = implArg.getStartLine();
                                        startOffset = implArg.getStartInfo().realOffset;
                                        endOffset = startOffset + implArgName.length();
                                        parserPath = prevImplementation2.getParserPath();
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 34);
                                        this.addSemanticError(2, "EXTERN_METHOD_SIGNATURE: Type of argument ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                    } else if (protoArgDT != null && protoArgDT.getDirection() != implArgDT.getDirection()) {
                                        line = implArg.getStartLine();
                                        startOffset = implArg.getStartInfo().realOffset;
                                        endOffset = startOffset + implArgName.length();
                                        parserPath = prevImplementation2.getParserPath();
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 34);
                                        this.addSemanticError(1, "EXTERN_METHOD_SIGNATURE: Direction of argument ''{0}'' for extern method ''{1}'' does not match prototype", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                    } else if (!(protoArgInitVal == null && implArgInitVal == null || protoArgInitVal != null && implArgInitVal != null && protoArgInitVal.equals(implArgInitVal) || implArgInitVal == null || implArgInitVal.equals(protoArgInitVal))) {
                                        line = implArg.getStartLine();
                                        startOffset = implArg.getStartInfo().realOffset;
                                        endOffset = startOffset + implArgName.length();
                                        parserPath = prevImplementation2.getParserPath();
                                        attributes = new HashMap(4);
                                        attributes.put("QUICKFIX_ELEMENT_NAME", funcName);
                                        attributes.put("QUICKFIX_KIND", 34);
                                        this.addSemanticError(2, "EXTERN_METHOD_SIGNATURE: Default value of argument ''{0}'' for extern method ''{1}'' does not match prototype; the prototype declaration is used", func.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, implArgName, funcName);
                                    }
                                }
                                ++i;
                            }
                            break block64;
                        }
                        if (!(element instanceof RfAssertExpect) && !(element instanceof RfNamedActionBlock)) break block72;
                        RfNamedElement enclosingScope = element;
                        while (!(enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isLoopStatementLabel() || enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isForOrForeach() || (enclosingScope = enclosingScope.getEnclosingScope()) instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isCaseItem() || enclosingScope instanceof RfNamedActionBlock || enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).hasVarOrTypeDeclaration() || !(enclosingScope instanceof RfActionBlock))) {
                        }
                        if (enclosingScope == null || (duplicateElement = enclosingScope.getElementVisibleTroughAnonymousActionBlocks(this, name, composedFilter = R2LFilters.and(R2LFilters.sameReference(false, element), R2LFilters.namedElementIsDeclaredBefore(true, this, element), R2LFilters.allowEnum(false), R2LFilters.maxSize(0)))) == null || duplicateElement == element) break block64;
                        RfDefElement firstDecl = duplicateElement.getDeclaration();
                        RfDefElement secondDecl = element.getDeclaration();
                        if (firstDecl != null && secondDecl != null) {
                            ParserPath parserPath = secondDecl.getParserPath();
                            int line = secondDecl.getStartLine();
                            int startOffset = secondDecl.getStartOffset();
                            int endOffset10 = startOffset + name.length();
                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", name);
                            attributes.put("QUICKFIX_KIND", 11);
                            this.addSemanticError(element.getSemanticErrorSeverityForDuplicate(), element.getSemanticErrorCodeForDuplicate(), element.getLibPkgScope(), startOffset, endOffset10, attributes, line, parserPath, name, firstDecl.getStartLine(), firstDecl.getParserPath());
                        }
                        break block64;
                    }
                    if (!(element instanceof RfConstraint)) break block73;
                    constraint = (RfConstraint)element;
                    Collection constraintDefs = constraint.getDeclarations();
                    constraintName = constraint.getName();
                    prevPrototype = null;
                    prevImplementation = null;
                    RfDefElement prevCompleteDecl = null;
                    clazz = constraint.getEnclosingScope();
                    for (RfDefElement constraintDef : constraintDefs) {
                        ParserPath parserPath = constraintDef.getParserPath();
                        int line = constraintDef.getStartLine();
                        int startOffset = constraintDef.getStartOffset();
                        int endOffset11 = startOffset + constraintName.length();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", constraintName);
                        attributes.put("QUICKFIX_KIND", 11);
                        if (((RfConstraintDef)constraintDef).isPrototype()) {
                            if (prevPrototype != null && RfProject.areInTheSameParentLayer(constraintDef, prevPrototype, clazz)) {
                                this.addSemanticError(constraint.getSemanticErrorSeverityForDuplicate(), constraint.getSemanticErrorCodeForDuplicate(), constraint.getLibPkgScope(), startOffset, endOffset11, attributes, line, parserPath, constraintName, prevPrototype.getStartLine(), prevPrototype.getParserPath());
                            }
                            prevPrototype = constraintDef;
                        } else if (((RfConstraintDef)constraintDef).isOutOfClassDefinition()) {
                            if (prevImplementation != null) {
                                this.addSemanticError(1, constraint.getSemanticErrorCodeForDuplicateImpl(), constraint.getLibPkgScope(), startOffset, endOffset11, attributes, line, parserPath, constraintName, prevImplementation.getStartLine(), prevImplementation.getParserPath());
                            }
                            prevImplementation = constraintDef;
                        } else {
                            if (prevCompleteDecl != null && RfProject.areInTheSameParentLayer(constraintDef, prevCompleteDecl, clazz)) {
                                this.addSemanticError(constraint.getSemanticErrorSeverityForDuplicate(), constraint.getSemanticErrorCodeForDuplicate(), constraint.getLibPkgScope(), startOffset, endOffset11, attributes, line, parserPath, constraintName, prevCompleteDecl.getStartLine(), prevCompleteDecl.getParserPath());
                            }
                            prevCompleteDecl = constraintDef;
                        }
                        if (!((RfConstraintDef)constraintDef).isOutOfClassScope()) continue;
                        this.addSemanticError(RfSemanticError.getNonStandardSeverity(), constraint.getSemanticErrorCodeForImplementationScope(), constraint.getLibPkgScope(), startOffset, endOffset11, attributes, line, parserPath, constraintName, constraint.getEnclosingScope().getName());
                    }
                    if (prevPrototype == null || prevImplementation != null) break block74;
                    declaration = constraint.getDeclaration();
                    int line = declaration.getStartLine();
                    int startOffset = declaration.getStartOffset();
                    endOffset = startOffset + constraintName.length();
                    ParserPath parserPath = declaration.getParserPath();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    attributes.put("QUICKFIX_ELEMENT_NAME", constraintName);
                    attributes.put("QUICKFIX_KIND", 11);
                    attributes.put("QUICKFIX_KIND", 68);
                    this.addSemanticError(constraint.getSemanticErrorSeverityForUnimplemented(), constraint.getSemanticErrorCodeForUnimplemented(), constraint.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, constraintName);
                    break block64;
                }
                if (prevImplementation == null || prevPrototype != null || clazz == null || clazz instanceof RfFragment) break block64;
                declaration = constraint.getDeclaration();
                int line = declaration.getStartLine();
                int startOffset = declaration.getStartOffset();
                endOffset = startOffset + constraintName.length();
                ParserPath parserPath = declaration.getParserPath();
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", constraintName);
                attributes.put("QUICKFIX_KIND", 11);
                attributes.put("QUICKFIX_KIND", 67);
                this.addSemanticError(1, "EXTERN_CONSTRAINT_UNDECLARED: Outer class constraint ''{0}'' was not declared extern inside class ''{1}''", constraint.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, constraintName, clazz.getName());
                break block64;
            }
            if ((DVTRfUtils.MEMBERS_TYPES.contains(element.getClass()) || element instanceof RfLibrary) && (enumElements = element.getEnumNames()) != null && !enumElements.isEmpty()) {
                for (RfNamedElement enumElement : enumElements.values()) {
                    ParserPath firstElementParserPath;
                    if (!(enumElement instanceof RfDuplicate)) continue;
                    Collection<RfNamedElement> enumElementMembers = enumElement.getMembers();
                    RfNamedElement firstEnumElementMember = ((RfDuplicate)enumElement).getFirstMember(RfField.class);
                    if (firstEnumElementMember == null) continue;
                    RfFileDef firstEnumElementMemberFileDef = firstEnumElementMember.getFile();
                    ParserPath parserPath = firstElementParserPath = firstEnumElementMemberFileDef != null ? firstEnumElementMemberFileDef.getParserPath() : null;
                    if (firstElementParserPath == null) continue;
                    int firstEnumElementMemberLine = firstEnumElementMember.getLine();
                    enumElementMembers.stream().skip(1L).forEach(enumMember -> {
                        ParserPath parserPath2;
                        if (enumMember == null) {
                            return;
                        }
                        RfFileDef enumMemberFileDef = enumMember.getFile();
                        ParserPath parserPath3 = parserPath2 = enumMemberFileDef != null ? enumMemberFileDef.getParserPath() : null;
                        if (parserPath2 == null) {
                            return;
                        }
                        if (changedFiles != null && !changedFiles.contains(parserPath2)) {
                            return;
                        }
                        String enumMemberName = enumMember.getName();
                        RfDefElement enumMemberDeclaration = enumMember.getDeclaration();
                        int enumMemberLine = enumMemberDeclaration.getStartLine();
                        int enumMemberStartOffset = enumMemberDeclaration.getStartOffset();
                        int enumMemberEndOffset = enumMemberStartOffset + enumMemberName.length();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", enumMemberName);
                        attributes.put("QUICKFIX_KIND", 11);
                        this.addSemanticError(enumMember.getSemanticErrorSeverityForDuplicate(), enumMember.getSemanticErrorCodeForDuplicate(), enumMember.getLibPkgScope(), enumMemberStartOffset, enumMemberEndOffset, attributes, enumMemberLine, parserPath2, enumMemberName, firstEnumElementMemberLine, firstElementParserPath);
                    });
                }
            }
        }
        return true;
    }

    private boolean isForwardDeclaration(IRfNamedElement member1, IRfNamedElement member2) {
        IRfScopeElement enclosingScope2;
        IRfScopeElement enclosingScope1 = member1.getEnclosingScope();
        if (enclosingScope1 != (enclosingScope2 = member2.getEnclosingScope())) {
            return false;
        }
        if (member1 instanceof RfForwardTypedef) {
            int iterationLimit = 0;
            while (member2 instanceof RfTypeAlias && !(member2 instanceof RfForwardTypedef) && iterationLimit < 20) {
                member2 = ((RfTypeAlias)member2).getResolvedType(true);
                ++iterationLimit;
            }
            if (member2 instanceof RfClass && ((RfClass)member2).isInterfaceClass() && ((RfForwardTypedef)member1).isInterfaceTypedef()) {
                return true;
            }
            if (member2 instanceof RfClass && ((RfForwardTypedef)member1).isClassTypedef()) {
                return true;
            }
            if (member2 instanceof RfStruct && ((RfStruct)member2).isStruct() && ((RfForwardTypedef)member1).isStructTypedef()) {
                return true;
            }
            if (member2 instanceof RfStruct && ((RfStruct)member2).isUnion() && ((RfForwardTypedef)member1).isUnionTypedef()) {
                return true;
            }
            return member2 instanceof RfStruct && ((RfStruct)member2).isEnum() && ((RfForwardTypedef)member1).isEnumTypedef();
        }
        if (member2 instanceof RfForwardTypedef) {
            return this.isForwardDeclaration(member2, member1);
        }
        return false;
    }

    private static IRfNamedElement getFunctionReturnTypeForAlias(RfFunction func, IRfNamedElement clazz, Set<DataType> visited) {
        while (clazz instanceof RfTypeAlias) {
            DataType translatedDataType = ((RfTypeAlias)clazz).getDataType();
            if (translatedDataType == null) continue;
            IRfNamedElement firstScope = (IRfNamedElement)clazz.getEnclosingScope();
            IRfNamedElement resultedClazz = RfProject.getFunctionReturnType(func, firstScope, translatedDataType, visited);
            if (resultedClazz != null || firstScope == null) {
                clazz = resultedClazz;
            }
            if (clazz == null || visited.contains(translatedDataType)) {
                return null;
            }
            visited.add(translatedDataType);
        }
        return clazz;
    }

    private static IRfNamedElement getFunctionReturnType(RfFunction func, IRfNamedElement clazz, DataType dataType, Set<DataType> visited) {
        if (dataType == null || clazz == null) {
            return null;
        }
        DataType packageScope = dataType.getPackageScope();
        if (packageScope != null && (clazz = RfProject.getFunctionReturnType(func, clazz, packageScope, visited)) == null) {
            return null;
        }
        if (clazz instanceof RfTypeAlias) {
            clazz = RfProject.getFunctionReturnTypeForAlias(func, clazz, visited);
        }
        if ((clazz = clazz.semanticGetMember(dataType.getType(), null, null, (IRfNamedElement)func, null, true, true, false)) instanceof RfTypeAlias) {
            clazz = RfProject.getFunctionReturnTypeForAlias(func, clazz, visited);
        }
        if (clazz == null) {
            return null;
        }
        List<DataType> innerClassesInfo = dataType.getInnerClassesInfo();
        if (innerClassesInfo == null || innerClassesInfo.isEmpty()) {
            return clazz;
        }
        for (DataType innerData : innerClassesInfo) {
            if ((clazz = RfProject.getFunctionReturnType(func, clazz, innerData, visited)) != null) continue;
            return null;
        }
        return clazz;
    }

    private boolean equalsReturnType(RfFunction func, RfNamedElement clazz, DataType protoDataType, DataType implDataType) {
        RfScalarType implAssocType;
        String protoType = protoDataType.getType();
        String implType = implDataType.getType();
        if (protoType == null || implType == null) {
            return protoType == null && implType == null;
        }
        RfScalarType protoAssocType = PREDEFINED_GLOBAL.getScalarTypeWithPrefix(protoType, 1);
        if (protoAssocType == null) {
            protoAssocType = RfProject.getFunctionReturnType(func, clazz, protoDataType, new HashSet<DataType>());
        }
        if (protoAssocType instanceof RfTypeAlias) {
            protoAssocType = ((RfTypeAlias)((Object)protoAssocType)).getTranslatedType();
        }
        if ((implAssocType = PREDEFINED_GLOBAL.getScalarTypeWithPrefix(implType, 1)) == null) {
            implAssocType = RfProject.getFunctionReturnType(func, clazz, implDataType, new HashSet<DataType>());
        }
        if (implAssocType instanceof RfTypeAlias) {
            implAssocType = ((RfTypeAlias)((Object)implAssocType)).getTranslatedType();
        }
        return protoAssocType != null && ((Object)protoAssocType).equals(implAssocType);
    }

    private boolean isNonStdAliasImplReturnType(DataType protoDataType, DataType implDataType) {
        DataType lastImplDataType;
        DataType lastProtoDataType = this.getLastDataType(protoDataType);
        return !lastProtoDataType.equalsDataTypeTypeName(lastImplDataType = this.getLastDataType(implDataType));
    }

    private DataType getLastDataType(DataType dataType) {
        List<DataType> protoInnerClasses = dataType.getInnerClassesInfo();
        if (protoInnerClasses == null || protoInnerClasses.isEmpty()) {
            return dataType;
        }
        return protoInnerClasses.get(protoInnerClasses.size() - 1);
    }

    private boolean compareTypeEnclosing(IRfNamedElement assocType, RfFunction func) {
        int i = 0;
        while (assocType instanceof RfListType && i < 50) {
            assocType = ((RfListType)assocType).getAssociatedType();
            ++i;
        }
        if (assocType == null) {
            return false;
        }
        return assocType.getEnclosingScope() == func.getEnclosingScope();
    }

    private boolean checkForDuplicatesOfClassPredefinedMethod(RfNamedElement element) {
        if (!(element.getEnclosingScope() instanceof RfClass) || !RfClass.ILLEGAL_OVERRIDDEN_PREDEFINED_METHODS.contains(element.getName())) {
            return false;
        }
        String name = element.getName();
        Collection defs = element.getDeclarations();
        if (defs == null) {
            return true;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_ELEMENT_NAME", name);
        attributes.put("QUICKFIX_KIND", 11);
        for (RfDefElement def : defs) {
            int line = def.getStartLine();
            ParserPath parserPath = def.getParserPath();
            int startOffset = def.getStartOffset();
            int endOffset = startOffset + name.length();
            if (element instanceof RfFunction) {
                this.addSemanticError(1, "ILLEGAL_OVERRIDE: Illegal override of built-in method ''{0}''", element.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, name);
                continue;
            }
            this.addSemanticError(1, "DUPLICATE_NAME: Duplicate name ''{0}'', already built-in method", element.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, name);
        }
        return true;
    }

    private Map<Boolean, List<RfNamedElement>> getDuplicateMembersPerKind(RfNamedElement element) {
        LinkedHashMap<Boolean, List<RfNamedElement>> result = new LinkedHashMap<Boolean, List<RfNamedElement>>();
        if (element instanceof RfDuplicate) {
            Collection<RfNamedElement> members = element.getMembers();
            if (members != null && !members.isEmpty()) {
                for (RfNamedElement member : members) {
                    boolean isDesign = DVTRfUtils.MEMBERS_DESIGN.contains(member.getClass()) || RfPackage.class == member.getClass();
                    ArrayList<RfNamedElement> membersOfKind = (ArrayList<RfNamedElement>)result.get(isDesign);
                    if (membersOfKind == null) {
                        membersOfKind = new ArrayList<RfNamedElement>();
                        result.put(isDesign, membersOfKind);
                    }
                    membersOfKind.add(member);
                }
            }
        } else {
            boolean isDesign = DVTRfUtils.MEMBERS_DESIGN.contains(element.getClass()) || RfPackage.class == element.getClass();
            ArrayList<RfNamedElement> membersOfKind = (ArrayList<RfNamedElement>)result.get(isDesign);
            if (membersOfKind == null) {
                membersOfKind = new ArrayList<RfNamedElement>();
                result.put(isDesign, membersOfKind);
            }
            membersOfKind.add(element);
        }
        return result;
    }

    public static boolean areInTheSameParentLayer(RfDefElement elem1, RfDefElement elem2, RfNamedElement parent) {
        if (parent == null) {
            return true;
        }
        Collection declarations = parent.getDeclarations();
        if (declarations.size() <= 1) {
            return true;
        }
        Iterator it = declarations.iterator();
        RfDefElement elem1ParentDef = null;
        RfDefElement elem2ParentDef = null;
        while (it.hasNext()) {
            RfDefElement parentDef = (RfDefElement)it.next();
            if (elem1ParentDef == null && elem1.isInsideOtherDef(parentDef)) {
                elem1ParentDef = parentDef;
            }
            if (elem2ParentDef != null || !elem2.isInsideOtherDef(parentDef)) continue;
            elem2ParentDef = parentDef;
        }
        return elem1ParentDef == elem2ParentDef;
    }

    public List<RfPackage> getAllPackages(boolean createNonePkg) {
        NullProtectedList<RfPackage> result = new NullProtectedList<RfPackage>();
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
                if (library.isPredefined()) continue;
                result.addAll(library.getAllPackages(createNonePkg));
            }
        }
        return result;
    }

    public List<RfPackage> getPackages() {
        NullProtectedList<RfPackage> result = new NullProtectedList<RfPackage>();
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
                result.addAll(library.getLocalMembers(RfPackage.class));
            }
        }
        return result;
    }

    @Override
    public Collection<RfNamedElement> getMembers() {
        return this.getMembers(false, false);
    }

    @Override
    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        if (this.fRfProjectContent.fLibraries != null) {
            return new ArrayList<RfNamedElement>(this.fRfProjectContent.fLibraries.values());
        }
        return null;
    }

    public Collection<RfLibrary> getLibraries() {
        return this.fRfProjectContent.fLibraries != null ? this.fRfProjectContent.fLibraries.values() : null;
    }

    public Collection<RfLibrary> getAllLibraries() {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        ArrayList<RfLibrary> libraries = new ArrayList<RfLibrary>(this.fRfProjectContent.fLibraries.size());
        for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
            if (library.isPredefined()) continue;
            libraries.add(library);
        }
        return libraries;
    }

    public Collection<RfLibrary> getLibrariesByNames(Collection<String> libraryNames) {
        if (libraryNames == null) {
            return this.fRfProjectContent.fLibraries.values();
        }
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>();
        for (String libraryName : libraryNames) {
            RfLibrary library = this.getLocalLibrary(libraryName);
            boolean isCadence = IBuildConfigParserConstants.IUS_TOOLS.contains(this.fRfProjectContent.fToolCompat);
            if (library == null && isCadence && "worklib".equals(libraryName)) {
                library = this.getLocalLibrary("work");
            }
            if (library == null) continue;
            result.add(library);
        }
        return result;
    }

    public Map<ParserPath, DVTEditor> getFileEditors() {
        return this.fParserPathToEditorMap;
    }

    public RfFileDef getFileDefUsingParserPath(ParserPath parserPath) {
        if (parserPath == null || this.fRfProjectContent == null || this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath.toCanonical());
    }

    public RfFileDef getFileDefIgnoringCanonicalPath(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        LinkedHashMap<ParserPath, RfFileDef> updatedParserPath2FileDefMap = new LinkedHashMap<ParserPath, RfFileDef>();
        for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            ParserPath fileDefParserPath = fileDef.getParserPath();
            if (fileDefParserPath.path.equals(parserPath.path)) {
                fileDefParserPath.resetCanonical();
            }
            updatedParserPath2FileDefMap.put((ParserPath)fileDefParserPath.toCanonical(), fileDef);
        }
        this.fRfProjectContent.fParserPath2FileDefMap = updatedParserPath2FileDefMap;
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath.toCanonical());
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.fMixedLangProjectParent;
    }

    public String getNature() {
        return "ro.amiq.vlogdt.VlogNature";
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public void getSortCandidatesForContentAssist(IRfNamedElement[] sortedCandidates, String prefix) {
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
    }

    private void lintInit() {
        this.fLintTokensTableMap = new LinkedHashMap<ParserPath, LightTokenList>();
        SingleFileLintingBuilder.clearMarkers(this.fProject);
    }

    private void lintClean() {
        Set<ParserPath> parserPaths;
        this.getPreprocessingTable().lintClean();
        if (this.fLintTrackMacroCallNames != null) {
            parserPaths = this.fLintTrackMacroCallNames.keySet();
            if (parserPaths != null) {
                for (ParserPath parserPath : parserPaths) {
                    Set<String> names = this.fLintTrackMacroCallNames.get(parserPath);
                    if (names == null) continue;
                    names.clear();
                }
            }
            this.fLintTrackMacroCallNames.clear();
        }
        if (this.fLintTokensTableMap != null) {
            parserPaths = this.fLintTokensTableMap.keySet();
            if (parserPaths != null) {
                for (ParserPath parserPath : parserPaths) {
                    LightTokenList tokens = this.fLintTokensTableMap.get(parserPath);
                    if (tokens == null) continue;
                    tokens.clean();
                }
            }
            this.fLintTokensTableMap.clear();
        } else {
            this.fLintTokensTableMap = new LinkedHashMap<ParserPath, LightTokenList>();
        }
        this.lintCleanOVMProject();
        if (this.fLintingEnabled) {
            VerissimoAfterCompilationLauncher.getInstance().projectClean(this.fProject);
        }
    }

    private void lintCleanOVMProject() {
        if (this.ovmProject != null) {
            this.ovmProject.cleanLintingSemanticErrors();
        }
    }

    private void lintCleanOVMProject(Set<ParserPath> parserPaths) {
        if (this.ovmProject != null) {
            this.ovmProject.cleanLintingSemanticErrors(parserPaths);
        }
    }

    public boolean isLintingEnabled() {
        return this.fLintingEnabled;
    }

    public void startLintTracking() {
        this.fLintingEnabled = true;
        this.setDisabledChecks(this.fLintingEnabled);
        this.fLintTrackP2LInfo = new IntOpenHashSet();
        this.fLintTrackP2LInfo.add(77);
        this.fLintTrackP2LInfo.add(33);
    }

    public void stopLintTracking() {
        this.fLintingEnabled = false;
        this.setDisabledChecks(this.fLintingEnabled);
        this.fLintTrackP2LInfo = null;
        this.fLintTrackMacrosByNamesPerScope = null;
        this.fLintTrackMacrosByDeprecatedComments = null;
        this.lintClean();
        this.ovmProject = null;
    }

    public void lintTrackP2LInfo(int aKind) {
        if (this.fLintTrackP2LInfo == null) {
            this.fLintTrackP2LInfo = new IntOpenHashSet();
        }
        this.fLintTrackP2LInfo.add(aKind);
    }

    public boolean lintIsTrackedP2LInfo(int aKind) {
        if (this.fLintTrackP2LInfo == null) {
            return false;
        }
        return this.fLintTrackP2LInfo.contains(aKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lintAddSVTBIssuePT(ParserPath parserPath, int kind, int line, int offset, int virtualOffset, int optional, String info, String additionalInfo, String extraAdditionalInfo, Map<String, Object> meta, ReparseInfo reparseInfo) {
        if (!this.isLintingEnabled()) {
            return;
        }
        Object object = this.fSvtbIssueLockObject;
        synchronized (object) {
            this.lintAddSVTBIssue(parserPath, kind, line, offset, virtualOffset, optional, info, additionalInfo, extraAdditionalInfo, meta, reparseInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lintAddSVTBIssueLT(ParserPath parserPath, int kind, int line, int offset, int virtualOffset, int optional, String info, String additionalInfo, String extraAdditionalInfo, Map<String, Object> meta, ReparseInfo reparseInfo) {
        if (!this.isLintingEnabled()) {
            return;
        }
        Object object = this.fSvtbIssueLockObject;
        synchronized (object) {
            this.lintAddSVTBIssue(parserPath, kind, line, offset, virtualOffset, optional, info, additionalInfo, extraAdditionalInfo, meta, reparseInfo);
        }
    }

    private final void lintAddSVTBIssue(ParserPath parserPath, int kind, int line, int offset, int virtualOffset, int optional, String info, String additionalInfo, String extraAdditionalInfo, Map<String, Object> meta, ReparseInfo reparseInfo) {
        if (!this.lintIsTrackedP2LInfo(kind)) {
            return;
        }
        if (126 == kind) {
            if (info != null) {
                return;
            }
            if (additionalInfo == null) {
                return;
            }
            if (additionalInfo.indexOf(39) != -1) {
                return;
            }
            if (additionalInfo.length() < 10) {
                return;
            }
        }
        if (this.fRfProjectContent.fPreprocessingTable != null) {
            this.fRfProjectContent.fPreprocessingTable.addSVTBIssue(parserPath, kind, line, offset, virtualOffset, optional, info, additionalInfo, extraAdditionalInfo, meta, reparseInfo);
        }
    }

    public void lintTrackMacrosByNames(String aScope, HashSet<String> aMacroNames) {
        HashSet<String> perScope;
        if (aScope == null || aMacroNames == null) {
            return;
        }
        if (this.fLintTrackMacrosByNamesPerScope == null) {
            this.fLintTrackMacrosByNamesPerScope = new HashMap<String, HashSet<String>>();
        }
        if ((perScope = this.fLintTrackMacrosByNamesPerScope.get(aScope)) == null) {
            perScope = new HashSet();
            this.fLintTrackMacrosByNamesPerScope.put(aScope, perScope);
        }
        perScope.addAll(aMacroNames);
    }

    public Set<String> lintGetTrackMacrosByNames(String aScope) {
        if (this.fLintTrackMacrosByNamesPerScope != null) {
            return this.fLintTrackMacrosByNamesPerScope.get(aScope);
        }
        return null;
    }

    public void lintTrackMacrosByDeprecatedComments(HashSet<String> aComments) {
        if (aComments == null) {
            return;
        }
        if (this.fLintTrackMacrosByDeprecatedComments == null) {
            this.fLintTrackMacrosByDeprecatedComments = new HashSet<String>();
        }
        this.fLintTrackMacrosByDeprecatedComments.addAll(aComments);
    }

    public Set<String> lintGetTrackMacrosByDeprecatedComments() {
        return this.fLintTrackMacrosByDeprecatedComments;
    }

    public void lintTrackMacroCall(ParserPath parserPath, String macroName) {
        Set<String> perPath;
        if (!this.isLintingEnabled()) {
            return;
        }
        if (macroName == null || parserPath == null) {
            return;
        }
        if (this.fLintTrackMacroCallNames == null) {
            this.fLintTrackMacroCallNames = new HashMap<ParserPath, Set<String>>();
        }
        if ((perPath = this.fLintTrackMacroCallNames.get(parserPath)) == null) {
            perPath = new HashSet<String>();
            this.fLintTrackMacroCallNames.put(parserPath, perPath);
        }
        perPath.add(macroName);
    }

    private void lintPreIncremental(ParserPath parserPath) {
        if (!this.isLintingEnabled()) {
            return;
        }
        if (parserPath == null || this.fLintTrackMacroCallNames == null) {
            return;
        }
        this.fLintTrackMacroCallNames.remove(parserPath);
    }

    public boolean lintIsMacroCalled(VlogMacroInfo macro) {
        if (macro == null || this.fLintTrackMacroCallNames == null) {
            return false;
        }
        for (Set<String> perPath : this.fLintTrackMacroCallNames.values()) {
            if (!perPath.contains(macro.getName())) continue;
            return true;
        }
        return false;
    }

    public LintExprFactory getLintExprFactory() {
        return this.fLintExprFactory;
    }

    public void initLintExprFactory() {
        this.fLintExprFactory = new LintExprFactory(this);
    }

    public boolean lintIsStoreTokens() {
        return this.fLintStoreTokens;
    }

    public void lintSetStoreTokens(boolean store) {
        this.fLintStoreTokens = store;
    }

    public boolean lintIsIncrementalBuild() {
        return this.fLintIncrementalBuild;
    }

    public void lintSetIncrementalBuild(boolean incrementalBuild) {
        this.fLintIncrementalBuildStarted = incrementalBuild;
        this.fLintIncrementalBuild = incrementalBuild;
    }

    public void lintStoreToken(Token token) {
        LightTokenList tokensPerFile;
        if (token == null) {
            return;
        }
        if (token.getType() == 1) {
            return;
        }
        DVTCustomToken dvtToken = (DVTCustomToken)token;
        VlogFileInstance fileInstance = dvtToken.getFileInstance();
        if (fileInstance == null || fileInstance.getIndex() <= 0) {
            return;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        if (parserPath == null) {
            return;
        }
        if (this.fLintIncrementalBuildStarted) {
            tokensPerFile = null;
            this.fLintIncrementalBuildStarted = false;
        } else {
            tokensPerFile = this.fLintTokensTableMap.get(parserPath);
            if (!this.fLintIncrementalBuild && dvtToken.getType() == 565 && dvtToken.getText() != null && dvtToken.getText().startsWith("`include")) {
                tokensPerFile = null;
                VlogFileInstance includingFileInstance = fileInstance.getIncludingFileInfo();
                if (includingFileInstance != null && includingFileInstance.getIndex() > 0) {
                    dvtToken.setFileInstance(includingFileInstance);
                    ParserPath includingParserPath = includingFileInstance.getParserPath();
                    if (includingParserPath != null) {
                        LightTokenList includingTokensPerFile = this.fLintTokensTableMap.get(includingParserPath);
                        if (includingTokensPerFile == null) {
                            includingTokensPerFile = new LightTokenList();
                            this.fLintTokensTableMap.put(includingParserPath, includingTokensPerFile);
                        }
                        includingTokensPerFile.add(this.lighten(dvtToken));
                    }
                }
                dvtToken = null;
            }
        }
        if (tokensPerFile == null) {
            tokensPerFile = new LightTokenList();
            this.fLintTokensTableMap.put(parserPath, tokensPerFile);
        }
        if (dvtToken != null) {
            tokensPerFile.add(this.lighten(dvtToken));
        }
    }

    private LightToken lighten(DVTCustomToken dvtToken) {
        LightToken result = LightToken.create(dvtToken.getType(), dvtToken.getText());
        result.setLine(dvtToken.getLine());
        result.setColumn(dvtToken.getColumn());
        return result;
    }

    public Map<ParserPath, LightTokenList> lintGetTokensMap() {
        return this.fLintTokensTableMap;
    }

    public int lintCheckSVTBSystemTaskIdentifiers(String identifier) {
        if (!this.isLintingEnabled()) {
            return -1;
        }
        if (SVTBIssues.SYSTEM_TASKS_SIMULATION_CONTROL.contains(identifier)) {
            return 30;
        }
        if (SVTBIssues.SYSTEM_TASKS_RANDOM.contains(identifier)) {
            return 32;
        }
        if (SVTBIssues.SYSTEM_TASKS_MATH.contains(identifier)) {
            return 31;
        }
        if ("$size".equals(identifier)) {
            return 66;
        }
        if (SVTBIssues.SYSTEM_TASKS_COVERAGE.contains(identifier)) {
            return 67;
        }
        if (SVTBIssues.SYSTEM_TASKS_GLOBAL_CLOCKING_PAST_FUTURE.contains(identifier)) {
            return 91;
        }
        if ("$global_clock".equals(identifier)) {
            return 90;
        }
        if ("$changed".equals(identifier)) {
            return 102;
        }
        if (SVTBIssues.SYSTEM_TASKS_SAMPLED_VALUE_EXCEPT_CHANGED.contains(identifier)) {
            return 103;
        }
        return -1;
    }

    public String parser2resource(ParserPath parserPath) {
        return DVTFileUtils.getInstance().parser2resource(this.fProject, parserPath);
    }

    public ParserPath resource2parser(IResource file) {
        return DVTFileUtils.getInstance().resource2parser(file);
    }

    private Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        return DVTFileUtils.getInstance().resource2parser(changedFiles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            RfLibrary library;
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null) return true;
            Iterator<RfLibrary> iterator = libraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((library = iterator.next()).visitHidObject(rfProject, visitor));
            return false;
        }
        catch (OperationCanceledException | ElementFromCursorDetectionException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    @Override
    protected void visitNamedElements(RfProject rfProject, IRfNamedElementVisitor visitor) throws Exception {
        if (this.fRfProjectContent.fLibraries == null) {
            return;
        }
        this.visitNamedElement(rfProject, visitor, (Iterable<? extends RfNamedElement>)this.fRfProjectContent.fLibraries);
    }

    public void accept(IRfNamedElementVisitor visitor) {
        try {
            super.accept(this, visitor);
        }
        catch (Exception e) {
            if (e instanceof RfNamedElementVisitorException) {
                throw e;
            }
            throw new RfNamedElementVisitorException(e);
        }
    }

    public void visitDirectMembersOfLibraries(IRfNamedElementVisitor visitor) {
        try {
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return;
            }
            for (RfLibrary library : libraries) {
                Collection<RfNamedElement> libraryMembers = library.getMembers();
                if (libraryMembers == null || libraryMembers.isEmpty()) continue;
                for (RfNamedElement member : libraryMembers) {
                    if (member instanceof RfDuplicate) {
                        Collection<RfNamedElement> duplicateMembers = member.getMembers();
                        if (duplicateMembers == null || member.isEmpty()) continue;
                        for (RfNamedElement duplicateMember : duplicateMembers) {
                            visitor.visit(duplicateMember);
                        }
                        continue;
                    }
                    visitor.visit(member);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RfNamedElementVisitorException) {
                throw e;
            }
            throw new RfNamedElementVisitorException(e);
        }
    }

    public void acceptMixedProxy(final IRfMixedNamedElementVisitorProxy proxy) {
        this.accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                return proxy.visit((IRfNamedElement)namedElement);
            }
        });
    }

    public void accept(IRfDefElementVisitor visitor) throws Exception {
        if (this.fRfCompiledFiles == null) {
            return;
        }
        for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            fileDef.visit(visitor);
        }
    }

    @Override
    public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        if (idType == 285) {
            return false;
        }
        RfNamedElement scope = this.getOrCreateBuildScope(fileInstance);
        if (scope instanceof RfFunction || scope instanceof RfModule || scope instanceof RfClass || scope instanceof RfInterface || scope instanceof RfConstraint || scope instanceof RfConfiguration || scope instanceof RfStruct || scope instanceof RfAssertExpect || scope instanceof RfWait || scope instanceof RfActionBlock || scope instanceof RfGenerateBlock || scope instanceof RfClockingBlock || scope instanceof RfModport || scope instanceof RfLibrary || scope instanceof RfPackage || scope instanceof RfProgram || scope instanceof RfChecker || scope instanceof RfPrimitive || scope instanceof RfPropertySequence || scope instanceof RfCovergroup || scope instanceof RfCoverpoint) {
            if (!this.isUndeclaredIdentifierChecks()) {
                RfNamedElement enclosingFunction = null;
                if (scope instanceof RfActionBlock) {
                    enclosingFunction = scope.getEnclosingScope(RfFunction.class);
                } else if (scope instanceof RfFunction) {
                    enclosingFunction = scope;
                }
                if (enclosingFunction != null && enclosingFunction.getName().equals("__m_uvm_field_automation")) {
                    return true;
                }
                return enclosingFunction != null && enclosingFunction.getName().equals("start");
            }
            return true;
        }
        return false;
    }

    public boolean isInMethodScope() {
        if (this.fBuildScope == null) {
            return false;
        }
        RfNamedElement scope = this.fBuildScope.getScope();
        while (scope instanceof RfAbstractBlock) {
            scope = scope.getEnclosingScope();
        }
        return scope instanceof RfFunction;
    }

    public RfNamedElement getOrCreateBuildScope(IDVTFileInstance fileInstance) {
        if (this.fBuildScope == null) {
            return null;
        }
        RfNamedElement scope = this.fBuildScope.getScope();
        if (scope != null) {
            return scope;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        return this.fBuildScope.getScope();
    }

    public void newTempHidHolder(boolean force, boolean[] hasTempHidHolder) {
        if (!force && !this.isUndeclaredIdentifierChecks()) {
            return;
        }
        hasTempHidHolder[0] = true;
        this.fOverridedHidHolder.push((IHidHolder)new RfHidHolder(null));
    }

    public IHidHolder getTempHidHolder(boolean[] hasTempHidHolder) {
        if (!hasTempHidHolder[0]) {
            return null;
        }
        hasTempHidHolder[0] = false;
        return this.fOverridedHidHolder.isEmpty() ? null : this.fOverridedHidHolder.pop();
    }

    @Override
    public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return null;
        }
        return hidHolder.addOperator(operatorRequest);
    }

    @Override
    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return null;
        }
        if (!this.fOverridedHidHolder.isEmpty()) {
            hidRequest.hid.setSecondaryScope((IRfNamedElement)this.getSemanticScope());
        }
        return hidHolder.addIdentifier(hidRequest, access);
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.updateHolder(updater);
    }

    @Override
    public void addIdentifiers(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.addIdentifiers(updater);
    }

    @Override
    public void addOperators(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.addOperators(updater);
    }

    @Override
    public boolean removeIdentifier(String name) {
        if (name == null) {
            return false;
        }
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return false;
        }
        return hidHolder.removeIdentifier(name);
    }

    public RfNamedElement getSemanticScope() {
        return this.fBuildScope != null ? this.fBuildScope.getScope() : null;
    }

    public boolean isInClassScope() {
        return this.fBuildScope != null && this.fBuildScope.getScope() != null && this.fBuildScope.getScope().getEnclosingScope(RfClass.class) != null;
    }

    private IHidHolder getHidHolderParent() {
        IHidHolder hidHolder;
        IHidHolder iHidHolder = hidHolder = this.fOverridedHidHolder.isEmpty() ? null : this.fOverridedHidHolder.peek();
        if (hidHolder != null && hidHolder != this) {
            return hidHolder;
        }
        return this.getSemanticScope();
    }

    @Override
    public RfHidHolder internalGetHidHolder() {
        return null;
    }

    @Override
    public RfHidHolder getOrCreateHidHolder() {
        return null;
    }

    @Override
    public void setHidHolder(RfHidHolder hidHolder) {
    }

    public boolean isUndeclaredIdentifierChecks() {
        Set onlyPackages;
        FullChecksKind fullChecksKind;
        block19: {
            block18: {
                Map onlyLibAndPkgNames;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    try {
                                        if (this.fFullCompileChecks != null) break block13;
                                        return false;
                                    }
                                    catch (Exception ex) {
                                        DVTLogger.INSTANCE.logError((Throwable)ex);
                                        return true;
                                    }
                                }
                                fullChecksKind = this.fFullCompileChecks.getFullChecksKind(this.fLintingEnabled);
                                onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
                                if (fullChecksKind != FullChecksKind.FULL) break block14;
                                return true;
                            }
                            if (fullChecksKind != FullChecksKind.OFF) break block15;
                            return false;
                        }
                        if (this.fCurrentLibraryName != null) break block16;
                        return false;
                    }
                    if (onlyLibAndPkgNames != null) break block17;
                    return false;
                }
                if (fullChecksKind == FullChecksKind.LIBS) {
                    return onlyLibAndPkgNames.containsKey(this.fCurrentLibraryName);
                }
                if (fullChecksKind == FullChecksKind.NOT_LIBS) {
                    return !onlyLibAndPkgNames.containsKey(this.fCurrentLibraryName);
                }
                onlyPackages = (Set)onlyLibAndPkgNames.get(this.fCurrentLibraryName);
                if (onlyPackages != null) break block18;
                return false;
            }
            if (this.fCurrentPackageName != null) break block19;
            return false;
        }
        if (fullChecksKind == FullChecksKind.PKGS) {
            return onlyPackages.contains(this.fCurrentPackageName);
        }
        if (fullChecksKind == FullChecksKind.NOT_PKGS) {
            return !onlyPackages.contains(this.fCurrentPackageName);
        }
        return false;
    }

    protected synchronized boolean isUndeclaredIdentifierChecks(RfLibrary library) {
        if (this.fFullCompileChecks == null) {
            return false;
        }
        FullChecksKind fullChecksKind = this.fFullCompileChecks.getFullChecksKind(this.fLintingEnabled);
        Map onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
        return this.isUndeclaredIdentifierChecks(fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, library);
    }

    private synchronized boolean isUndeclaredIdentifierChecks(FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, RfLibrary library) {
        if (fullChecksKind == FullChecksKind.FULL) {
            return true;
        }
        if (fullChecksKind == FullChecksKind.OFF) {
            return false;
        }
        if (library == null) {
            return false;
        }
        if (onlyLibAndPkgNames == null) {
            return false;
        }
        String libraryName = library.getName();
        if (fullChecksKind == FullChecksKind.LIBS) {
            return onlyLibAndPkgNames.containsKey(libraryName);
        }
        if (fullChecksKind == FullChecksKind.NOT_LIBS) {
            return !onlyLibAndPkgNames.containsKey(libraryName);
        }
        return false;
    }

    protected synchronized boolean isUndeclaredIdentifierChecks(RfPackage packag) {
        if (this.fFullCompileChecks == null) {
            return false;
        }
        FullChecksKind fullChecksKind = this.fFullCompileChecks.getFullChecksKind(this.fLintingEnabled);
        Map onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
        return this.isUndeclaredIdentifierChecks(fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, packag);
    }

    private synchronized boolean isUndeclaredIdentifierChecks(FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, RfPackage packag) {
        if (fullChecksKind == FullChecksKind.FULL) {
            return true;
        }
        if (fullChecksKind == FullChecksKind.OFF) {
            return false;
        }
        if (packag == null) {
            return false;
        }
        if (onlyLibAndPkgNames == null) {
            return false;
        }
        RfLibrary library = packag.getEnclosingLibrary();
        if (library == null) {
            return false;
        }
        String libraryName = library.getName();
        if (fullChecksKind == FullChecksKind.LIBS) {
            return onlyLibAndPkgNames.containsKey(libraryName);
        }
        if (fullChecksKind == FullChecksKind.NOT_LIBS) {
            return !onlyLibAndPkgNames.containsKey(libraryName);
        }
        Set<String> onlyPackages = onlyLibAndPkgNames.get(libraryName);
        if (onlyPackages == null) {
            return false;
        }
        String packageName = packag.getName();
        if (fullChecksKind == FullChecksKind.PKGS) {
            return onlyPackages.contains(packageName);
        }
        if (fullChecksKind == FullChecksKind.NOT_PKGS) {
            return !onlyPackages.contains(packageName);
        }
        return false;
    }

    public boolean isIrunRNMTech() {
        return this.fIrunRNMTech;
    }

    public boolean isStrictNonStandardChecks() {
        return this.fStrictNonStandardChecks;
    }

    public boolean isElabSkipLongExpressions() {
        return this.fElabSkipLongExpressions;
    }

    public Set<ElaborationExpressionControl> getElabExpressionControl() {
        return this.fElabExpressionControl;
    }

    public Set<String> getElabExpressionOperatorControl() {
        return this.fElabExpressionOperatorControl;
    }

    public boolean isElabMethodEvalDisabled() {
        return this.fElabMethodEvalDisabled;
    }

    protected void resolveHidsIncremental(ConfigInfo configInfo, boolean triggerError, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, Set<IRfNamedElement> visited) {
        try {
            Set<String> onlyPkgNames;
            String libraryName;
            RfLibrary library;
            if (DVTLogger.INSTANCE.isDebugMode()) {
                fCount1.set(0);
                fCount2.set(0);
                fCount4.set(0);
            }
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> collection : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    if (collection == null || collection.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : collection) {
                        if (firstLevelElement instanceof RfInstance.RfBindInstance) continue;
                        if (onlyLibAndPkgNames != null) {
                            library = firstLevelElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, firstLevelElement)) continue;
                        configInfo.enclosingLibrary = firstLevelElement.getEnclosingLibrary();
                        firstLevelElement.resolveHids(configInfo, true, false, (byte)3, null);
                    }
                    this.checkAssociatedTypes(configInfo, collection, triggerError, false);
                }
            }
            if (this.fIncrementalDeltaContainer.delta != null && !this.fIncrementalDeltaContainer.delta.isEmpty()) {
                for (Set set : this.fIncrementalDeltaContainer.delta.values()) {
                    if (set == null || set.isEmpty()) continue;
                    for (IRfNamedElement changedElement : set) {
                        if (!(changedElement instanceof RfNamedElement) || changedElement instanceof RfInstance.RfBindInstance) continue;
                        if (onlyLibAndPkgNames != null) {
                            library = (RfLibrary)changedElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, changedElement)) continue;
                        configInfo.enclosingLibrary = ((RfNamedElement)changedElement).getEnclosingLibrary();
                        ((RfNamedElement)changedElement).resolveHids(configInfo, triggerError, false, (byte)3, IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.currentFileScopes != null && !this.fIncrementalDeltaContainer.currentFileScopes.isEmpty()) {
                for (RfNamedElement rfNamedElement : this.fIncrementalDeltaContainer.currentFileScopes) {
                    if (rfNamedElement == null || rfNamedElement instanceof RfInstance.RfBindInstance) continue;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library2 = rfNamedElement.getEnclosingLibrary();
                        if (library2 == null) continue;
                        String libraryName2 = library2.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName2) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName2)) continue;
                        Set<String> onlyPkgNames2 = onlyLibAndPkgNames.get(libraryName2);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames2 == null || onlyPkgNames2.isEmpty())) continue;
                    }
                    if (this.alreadyVisited(visited, rfNamedElement)) continue;
                    configInfo.enclosingLibrary = rfNamedElement.getEnclosingLibrary();
                    rfNamedElement.resolveLocalHids(configInfo, triggerError);
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
        if (DVTLogger.INSTANCE.isDebugMode()) {
            ro.amiq.vlogdt.test.TestHelper.out.println("Nof hids checks = " + fCount1);
            ro.amiq.vlogdt.test.TestHelper.out.println("Nof associated types = " + fCount2);
            ro.amiq.vlogdt.test.TestHelper.out.println("Compute associated types time = " + fCount4 + " ms");
            ro.amiq.vlogdt.test.TestHelper.out.println("Nof errors reported = " + fCount5);
        }
    }

    private void checkIsElaborated(RfLibrary library, ConfigInfo configInfo, boolean triggerError, Set<IRfNamedElement> visited) {
        this.checkBuildCanceled();
        if (library.getSemanticEnableRaw() == 0) {
            if (this.alreadyVisited(visited, library)) {
                return;
            }
            if (this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.NONE) {
                return;
            }
            library.resolveHids(configInfo, true, !this.fIncrementalBuild, (byte)3, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            library.resolveHidOperators(configInfo, true, (byte)3, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            library.setSemanticEnable((byte)1);
        }
    }

    private void checkIsElaborated(IRfPackageElement pkg, ConfigInfo configInfo, boolean triggerError, FullChecksKind fullChecksKind, Set<String> onlyPkgNames, Set<IRfNamedElement> visited) {
        this.checkBuildCanceled();
        if (pkg instanceof RfPackage && pkg.getSemanticEnableRaw() == 0) {
            if (this.alreadyVisited(visited, (IRfNamedElement)pkg)) {
                return;
            }
            IRfLibraryElement enclosingLibrary = pkg.getEnclosingLibrary();
            IRfDefElement declaration = pkg.getDeclaration();
            String pkgName = pkg.getName();
            if (!this.fPackageConstantsDisabled && triggerError && declaration != null && enclosingLibrary != null) {
                this.addSemanticError(2, "UNELABORATED_{0}: {1} ''{2}.{3}'' is not elaborated", pkg.getLibPkgScope(), declaration.getStartOffset(), declaration.getStartOffset() + pkgName.length(), null, pkg.getLine(), declaration.getParserPath(), "PACKAGE", "Package", enclosingLibrary.getName(), pkgName);
            }
            if (this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.NONE) {
                return;
            }
            if (onlyPkgNames != null && fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(pkgName)) {
                return;
            }
            if (onlyPkgNames != null && fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(pkgName)) {
                return;
            }
            ((RfPackage)pkg).resolveHids(configInfo, true, !this.fIncrementalBuild, (byte)3, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            ((RfPackage)pkg).resolveHidOperators(configInfo, true, (byte)3, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            pkg.setSemanticEnable((byte)1);
        }
    }

    private void checkIsElaborated(RfInstanceHolder top, ELManagerConfiguration elabLocalConfig, boolean triggerError, EnumSet<ElaborationDebugZone> elabDebug, Set<IRfNamedElement> visited, Set<ParserPath> visitedLibraryFiles) {
        this.checkBuildCanceled();
        if (top == null) {
            return;
        }
        if (this.alreadyVisited(visited, top)) {
            return;
        }
        if (top.getSemanticEnableRaw() == 0) {
            RfLibrary enclosingLibrary = top.getEnclosingLibrary();
            if (enclosingLibrary == null) {
                return;
            }
            RfDefElement rfDefElement = top.getDeclaration();
            if (rfDefElement == null) {
                return;
            }
            if (triggerError) {
                String type = DesignUtils.getDesignKindInstanceText((IRfScopeElement)top);
                String name = top.getName();
                this.addSemanticError(2, "UNELABORATED_{0}: {1} ''{2}.{3}'' is not elaborated", top.getLibPkgScope(), top.getOffset(), top.getOffset() + name.length(), null, top.getLine(), rfDefElement.getParserPath(), type.toUpperCase(), DVTStringUtil.toTitleCase((String)type), enclosingLibrary.getName(), name);
            }
            if (this.fUnelaboratedCompileChecks != UnelaboratedChecksKind.FULL && top.isMinusYLibfileParsed()) {
                return;
            }
            if (this.fUnelaboratedCompileChecks != UnelaboratedChecksKind.FULL && top.isShallowCompiled()) {
                return;
            }
            if (this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.DISCRETE && this.internalIsDesignLibraryFile(rfDefElement.getDefFile(), visitedLibraryFiles)) {
                return;
            }
            if (this.fUnelaboratedCompileChecks != UnelaboratedChecksKind.DISCRETE && this.fUnelaboratedCompileChecks != UnelaboratedChecksKind.FULL) {
                return;
            }
            top.elaborateLocal(ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), elabDebug, (IProgressMonitor)(this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor()));
        }
        if (this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.GENERATE_BLOCKS || this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.DISCRETE || this.fUnelaboratedCompileChecks == UnelaboratedChecksKind.FULL) {
            Collection<? extends IRfBlockElement> firstLevelGenerates = top.getLocalGenerateBlocks();
            if (firstLevelGenerates == null) {
                return;
            }
            for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
                RfProject.internalCheckIsElaboratedGenerate(iRfBlockElement, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), elabDebug, (IProgressMonitor)(this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor()));
            }
        }
    }

    private static void internalCheckIsElaboratedGenerate(IRfBlockElement top, ELManagerConfiguration elabLocalConfig, ELConstantsManager constantsManager, EnumSet<ElaborationDebugZone> elabDebug, IProgressMonitor progressMonitor) {
        Collection<? extends IRfBlockElement> firstLevelGenerates;
        if (!(top instanceof RfGenerateBlock)) {
            return;
        }
        RfGenerateBlock generateTop = (RfGenerateBlock)top;
        if (generateTop.getSemanticEnableRaw() == 0) {
            top.elaborateLocal(ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, constantsManager, elabDebug, progressMonitor);
        }
        if ((firstLevelGenerates = generateTop.getLocalGenerateBlocks()) != null) {
            for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
                RfProject.internalCheckIsElaboratedGenerate(iRfBlockElement, elabLocalConfig, constantsManager, elabDebug, progressMonitor);
            }
        }
    }

    private boolean internalIsDesignLibraryFile(RfFileDef fileDef, Set<ParserPath> visitedLibraryFiles) {
        if (fileDef == null) {
            return false;
        }
        ParserPath parserPath = fileDef.getParserPath();
        if (parserPath == null) {
            return false;
        }
        if (visitedLibraryFiles != null && visitedLibraryFiles.contains(parserPath)) {
            return true;
        }
        Collection<RfDefElement> firstLevelChildren = fileDef.getChildren();
        if (firstLevelChildren == null) {
            return true;
        }
        if (firstLevelChildren.size() < 10) {
            return false;
        }
        int count = 0;
        for (RfDefElement child : firstLevelChildren) {
            if (child instanceof RfModuleDef || child instanceof RfPrimitiveDef || child instanceof RfInterfaceDef || child instanceof RfProgramDef) {
                ++count;
            }
            if (count <= 10) continue;
            if (visitedLibraryFiles != null) {
                visitedLibraryFiles.add(parserPath);
            }
            return true;
        }
        return false;
    }

    protected void resolveOperatorsIncremental(ConfigInfo configInfo, boolean triggerError, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, Set<IRfNamedElement> visited) {
        try {
            Set<String> onlyPkgNames;
            String libraryName;
            RfLibrary library;
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> collection : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    if (collection == null || collection.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : collection) {
                        if (firstLevelElement instanceof RfInstance) continue;
                        if (onlyLibAndPkgNames != null) {
                            library = firstLevelElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, firstLevelElement)) continue;
                        configInfo.enclosingLibrary = firstLevelElement.getEnclosingLibrary();
                        firstLevelElement.resolveHidOperators(configInfo, triggerError, (byte)3, null);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.delta != null && !this.fIncrementalDeltaContainer.delta.isEmpty()) {
                for (Set set : this.fIncrementalDeltaContainer.delta.values()) {
                    if (set == null || set.isEmpty()) continue;
                    for (IRfNamedElement changedElement : set) {
                        if (!(changedElement instanceof RfNamedElement) || changedElement instanceof RfInstance) continue;
                        if (onlyLibAndPkgNames != null) {
                            library = (RfLibrary)changedElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, changedElement)) continue;
                        configInfo.enclosingLibrary = ((RfNamedElement)changedElement).getEnclosingLibrary();
                        ((RfNamedElement)changedElement).resolveHidOperators(configInfo, triggerError, (byte)3, IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.currentFileScopes != null && !this.fIncrementalDeltaContainer.currentFileScopes.isEmpty()) {
                for (RfNamedElement rfNamedElement : this.fIncrementalDeltaContainer.currentFileScopes) {
                    if (rfNamedElement == null || rfNamedElement instanceof RfInstance) continue;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library2 = rfNamedElement.getEnclosingLibrary();
                        if (library2 == null) continue;
                        String libraryName2 = library2.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName2) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName2)) continue;
                        Set<String> onlyPkgNames2 = onlyLibAndPkgNames.get(libraryName2);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames2 == null || onlyPkgNames2.isEmpty())) continue;
                    }
                    if (this.alreadyVisited(visited, rfNamedElement)) continue;
                    configInfo.enclosingLibrary = rfNamedElement.getEnclosingLibrary();
                    rfNamedElement.resolveLocalHidOperators(configInfo, triggerError);
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
    }

    @Override
    protected void checkAssociatedTypeMember(ConfigInfo configInfo, boolean triggerError, boolean ignoreDirty, RfNamedElement member) throws BuildCancelException {
        super.checkAssociatedTypeMember(configInfo, triggerError, ignoreDirty, member);
        if (member instanceof RfAssociatedType) {
            IRfNamedElement associatedType = ((RfAssociatedType)member).internalGetTransientAssociatedType();
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedBaseType();
            }
            if (associatedType instanceof RfNamedElement && !(associatedType instanceof RfAssociatedType.RfUnresolvedTypeInfo)) {
                ((RfAssociatedType)member).checkParamValues(associatedType, configInfo);
            }
        }
    }

    private boolean checkEnryptedPragmas() {
        long time = System.currentTimeMillis();
        Map<ParserPath, Set<EncryptedPragmaInfo>> encrypedInfoMap = this.getPreprocessingTable().getEncrypedPragmaFileInfos();
        if (encrypedInfoMap == null || encrypedInfoMap.isEmpty()) {
            return false;
        }
        IRfScopeElement protectedStartScope = null;
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        for (Map.Entry<ParserPath, Set<EncryptedPragmaInfo>> entry : encrypedInfoMap.entrySet()) {
            try {
                RfFileDef fileDef;
                ParserPath parserPath = entry.getKey();
                Set<EncryptedPragmaInfo> pragmas = entry.getValue();
                if (pragmas == null || pragmas.isEmpty() || (fileDef = this.getFileDefUsingParserPath(parserPath)) == null) continue;
                boolean protectedZone = false;
                EncryptedPragmaInfo lastStartPragma = null;
                ParserPath lastStartParserPath = null;
                for (EncryptedPragmaInfo pragma : pragmas) {
                    if (pragma.getKind() == EncryptedPragmaInfo.EncryptedPragmaKind.START_PROTECT) {
                        protectedStartScope = fileDef.getScope(pragma.getOffset());
                        if (protectedZone && lastStartPragma != null && lastStartParserPath != null) {
                            this.addSemanticError(1, "Unexpected `protect directive encountered\n    (already in protected area started at line {1} in {0})", libPkgScope, pragma.getOffset(), pragma.getOffset() + pragma.getLength(), null, pragma.getLine(), parserPath, lastStartParserPath, lastStartPragma.getLine());
                        }
                        lastStartParserPath = parserPath;
                        lastStartPragma = pragma;
                        protectedZone = true;
                        continue;
                    }
                    if (pragma.getKind() != EncryptedPragmaInfo.EncryptedPragmaKind.END_PROTECT) continue;
                    IRfScopeElement protectedEndScope = fileDef.getScope(pragma.getOffset());
                    if (protectedEndScope instanceof RfDefElement) {
                        if (!protectedZone) {
                            this.addSemanticError(1, "Unexpected `endprotect (no starting `protect found)", libPkgScope, pragma.getOffset(), pragma.getOffset() + pragma.getLength(), null, pragma.getLine(), parserPath, new Object[0]);
                        }
                        if (protectedStartScope instanceof RfDefElement && protectedEndScope != protectedStartScope) {
                            this.addSemanticError(1, "`endprotect is not in the same semantic scope as `protect\n    (should be placed before line {1} in {0})", libPkgScope, pragma.getOffset(), pragma.getOffset() + pragma.getLength(), null, pragma.getLine(), parserPath, ((RfDefElement)protectedStartScope).getParserPath(), ((RfDefElement)protectedStartScope).getEndLine());
                        }
                    }
                    protectedZone = false;
                }
                if (!protectedZone || lastStartPragma == null || lastStartParserPath == null) continue;
                protectedStartScope = fileDef.getScope(lastStartPragma.getOffset());
                this.addSemanticError(1, "No corresponding `endprotect directive found by the end-of-file", libPkgScope, lastStartPragma.getOffset(), lastStartPragma.getOffset() + lastStartPragma.getLength(), null, lastStartPragma.getLine(), lastStartParserPath, new Object[0]);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        DVTLogger.INSTANCE.logInfo("VLOGDT Encrypted (`protect/`endprotect) pragma checks time = " + (System.currentTimeMillis() - time) + " ms");
        return true;
    }

    private boolean checkCustomPragmas(Set<ParserPath> parserPaths) {
        if (parserPaths == null) {
            return false;
        }
        List customPragmas = BuildConfigManager.getCustomPragmas((IProject)this.getProject());
        Set preprocessTranslatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)this.getProject());
        if ((customPragmas == null || customPragmas.isEmpty()) && (preprocessTranslatePragmas == null || preprocessTranslatePragmas.isEmpty())) {
            return false;
        }
        boolean printResult = false;
        long time = System.currentTimeMillis();
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        VlogPreprocessingInfo preprocessing = this.getPreprocessingTable();
        VlogFileInstance topInstance = preprocessing.getTopFileInstance();
        LinkedHashMap customPragmaUsagesMap = new LinkedHashMap();
        try {
            topInstance.visitInstances(fileInstance -> {
                ParserPath parserPath = fileInstance.getParserPath();
                if (!parserPaths.contains(parserPath)) {
                    return true;
                }
                CheckCustomPragmasHelper customPragmasHelper = (CheckCustomPragmasHelper)customPragmaUsagesMap.get(parserPath);
                if (customPragmasHelper == null) {
                    customPragmasHelper = new CheckCustomPragmasHelper();
                }
                customPragmasHelper.customPragmaUsage.addAll(fileInstance.getCustomPragmas());
                if (customPragmasHelper.firstFileInstance == null) {
                    customPragmasHelper.firstFileInstance = fileInstance;
                }
                fileInstance.cleanCustomPragmas();
                customPragmaUsagesMap.put(parserPath, customPragmasHelper);
                return true;
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        for (Map.Entry entry : customPragmaUsagesMap.entrySet()) {
            CheckCustomPragmasHelper customPragmasHelper = (CheckCustomPragmasHelper)entry.getValue();
            ParserPath parserPath = (ParserPath)entry.getKey();
            List<CustomPragmaUsage> customPragmaUsages = customPragmasHelper.customPragmaUsage;
            if (customPragmaUsages == null || customPragmaUsages.isEmpty()) continue;
            printResult = true;
            ArrayDeque<CustomPragmaUsage> workingPragmas = new ArrayDeque<CustomPragmaUsage>();
            ArrayList<CustomPragmaUsage> sortedPragmas = new ArrayList<CustomPragmaUsage>();
            for (CustomPragmaUsage pragma : customPragmaUsages) {
                int errorType;
                int n = errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
                if (pragma.getKind() == CustomPragmaUsage.Kind.START) {
                    if (workingPragmas.size() < 3) {
                        workingPragmas.push(pragma);
                        continue;
                    }
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, new Object[0]);
                    continue;
                }
                if (workingPragmas.isEmpty()) {
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getStartPragma());
                    sortedPragmas.add(pragma);
                    continue;
                }
                CustomPragmaUsage stackPragma = (CustomPragmaUsage)workingPragmas.pop();
                if (!stackPragma.getPragmaName().equals(pragma.getPragmaName())) {
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, stackPragma.getPragma().getEndPragma(), pragma.getPragma().getEndPragma());
                    sortedPragmas.add(pragma);
                    workingPragmas.push(stackPragma);
                    continue;
                }
                stackPragma.setValid();
                pragma.setValid();
                sortedPragmas.add(stackPragma);
                sortedPragmas.add(pragma);
            }
            while (!workingPragmas.isEmpty()) {
                CustomPragmaUsage pragma;
                pragma = (CustomPragmaUsage)workingPragmas.pop();
                sortedPragmas.add(pragma);
                int errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getEndPragma());
            }
            customPragmasHelper.firstFileInstance.setCustomPragmas(sortedPragmas);
        }
        DVTLogger.INSTANCE.logInfo("VLOGDT Custom pragma checks time = " + (System.currentTimeMillis() - time) + " ms");
        return printResult;
    }

    private void checkUnused(Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean triggerError, boolean disableRTLChecks) throws BuildCancelException {
        long time = System.currentTimeMillis();
        if (!triggerError || disableRTLChecks) {
            return;
        }
        try {
            BuildConfigManagerCommon.PrecompileGlobalMode precompileMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.getProject());
            final boolean isPrecompiledLoad = precompileMode.isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE, BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD});
            LibraryWorker libraryWorker = new LibraryWorker(){

                @Override
                void work(ExecutorService executorService, RfLibrary library, Set<String> onlyPkgNames) {
                    try {
                        List<RfInstanceHolder> instanceHolders = RfProject.this.getAllInstanceHolders(Collections.singletonList(library), null, true, false, true);
                        if (instanceHolders.isEmpty()) {
                            return;
                        }
                        for (RfInstanceHolder instanceHolder : instanceHolders) {
                            instanceHolder.checkUnused(RfProject.this, isPrecompiledLoad);
                        }
                    }
                    catch (BuildCancelException buildCancelException) {}
                }
            };
            this.multiThreadLibraryWorker(libraries, fullChecksKind, onlyLibAndPkgNames, libraryWorker);
        }
        catch (BuildCancelException buildCancelException) {}
        DVTLogger.INSTANCE.logInfo("VLOGDT Unused signal checks time = " + (System.currentTimeMillis() - time) + " ms");
    }

    private final ExecutorService initExecutorService() {
        Integer maxNofThreads = BuildConfigManager.getMaxNofThreads((IProject)this.fProject);
        if (DVTLogger.INSTANCE.isDebugMode()) {
            ro.amiq.vlogdt.test.TestHelper.out.println("Max nof threads = " + maxNofThreads);
        }
        if (maxNofThreads == null || maxNofThreads < 1) {
            maxNofThreads = 1;
        }
        return Executors.newFixedThreadPool(maxNofThreads);
    }

    private final void shutdownExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            DVTJobsUtils.delay((long)50L);
        }
    }

    private final void multiThreadLibraryWorker(Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, LibraryWorker libraryWorker) throws BuildCancelException {
        RfLibrary[] workingCopy;
        this.checkBuildCanceled();
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        ExecutorService executorService = this.initExecutorService();
        RfLibrary[] rfLibraryArray = workingCopy = libraries.toArray(new RfLibrary[libraries.size()]);
        int n = workingCopy.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Set<String> onlyPkgNames;
                RfLibrary library;
                block5: {
                    library = rfLibraryArray[n2];
                    this.checkBuildCanceled();
                    onlyPkgNames = null;
                    if (onlyLibAndPkgNames == null) break block5;
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(library.getName()) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(library.getName())) break block6;
                    onlyPkgNames = onlyLibAndPkgNames.get(library.getName());
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) break block6;
                }
                libraryWorker.executeOnThread(executorService, library, onlyPkgNames);
            }
            ++n2;
        }
        this.shutdownExecutorService(executorService);
    }

    private void checkUnused(IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean triggerError, boolean disableRTLChecks) {
        if (!triggerError || disableRTLChecks) {
            return;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        BuildConfigManagerCommon.PrecompileGlobalMode precompileMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.getProject());
        boolean isPrecompiledLoad = precompileMode.isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE, BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD});
        if (container.firstLevelElements != null && !container.firstLevelElements.isEmpty()) {
            for (Collection collection : container.firstLevelElements.values()) {
                List<RfInstanceHolder> modules;
                if (collection == null || collection.isEmpty() || (modules = this.getAllInstanceHolders(collection, container.getParserPaths(), true, false, true)).isEmpty()) continue;
                for (RfInstanceHolder module : modules) {
                    Set<String> onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library = module.getEnclosingLibrary();
                        if (library == null) continue;
                        String libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                        onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                    }
                    if (visited.contains(module)) continue;
                    visited.add(module);
                    module.checkUnused(this, isPrecompiledLoad);
                }
            }
        }
        if (container.currentFileScopes != null && !container.currentFileScopes.isEmpty()) {
            for (RfNamedElement rfNamedElement : container.currentFileScopes) {
                ParserPath parserPath;
                Set<String> onlyPkgNames = null;
                if (onlyLibAndPkgNames != null) {
                    RfLibrary library = rfNamedElement.getEnclosingLibrary();
                    if (library == null) continue;
                    String libraryName = library.getName();
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                    onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                }
                if (!(rfNamedElement instanceof RfModule) && !(rfNamedElement instanceof RfProgram) || visited.contains(rfNamedElement)) continue;
                visited.add(rfNamedElement);
                RfDefElement declaration = rfNamedElement.getDeclaration();
                if (declaration == null || (parserPath = declaration.getParserPath()) == null) continue;
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, this, Collections.singleton(parserPath));
                ((RfInstanceHolder)rfNamedElement).checkUnused(this, isPrecompiledLoad);
            }
        }
    }

    public void checkUnelaborated(final boolean triggerError, final boolean incremental) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS;
        long time = System.currentTimeMillis();
        try {
            final boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.getProject());
            final boolean isPrecompiledSave = BuildConfigManager.isPrecompiledDbSaveMode((IProject)this.fProject);
            boolean semanticShowAliasName = DVTPlugin.getDefault().getPreferenceStore().getBoolean("semantic.show.alias.name");
            EnumSet<ElaborationControl> elabControlSet = !isPrecompiledSave ? ElaborationControl.UNELABORATED_CONTROL_SET : EnumSet.of(ElaborationControl.EACH_GENERATE_BLOCK_ONCE);
            final ELManagerConfiguration elabLocalConfig = ELManagerConfiguration.newElabLocalConfig((IProject)this.getProject(), (int)1, (byte)1, (boolean)semanticShowAliasName, (int)1, (int)(!isPrecompiledSave ? 1 : Integer.MAX_VALUE), (boolean)isPrecompiledSave, elabControlSet);
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.getProject());
            final Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            final FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            EnumSet elabDebug = BuildConfigManager.getElaborationDebug((IProject)this.fProject);
            final EnumSet<ElaborationDebugZone> localDebug = elabDebug.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
            final ELManager localManager = new ELManager(this.fMixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), localDebug);
            LibraryWorker libraryWorker = new LibraryWorker(){

                void checkUnelabInstanceHolders(RfLibrary library) {
                    List<RfInstanceHolder> instanceHolders = RfProject.this.getAllInstanceHolders(Collections.singletonList(library), null, true, true, true);
                    if (instanceHolders.isEmpty()) {
                        return;
                    }
                    for (RfInstanceHolder module : instanceHolders) {
                        RfProject.this.checkIsElaborated(module, elabLocalConfig, triggerError && !isPrecompiledSave, localDebug, null, new HashSet<ParserPath>());
                    }
                }

                void checkUnelabPkgAndLibs(RfLibrary library) {
                    if (library == null) {
                        return;
                    }
                    Set onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        String libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                            return;
                        }
                        if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                            return;
                        }
                        onlyPkgNames = (Set)onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) {
                            return;
                        }
                    }
                    ConfigInfo configInfo = new ConfigInfo(incremental, RfProject.this, library, disableRTLChecks, RfProject.this.getToolCompat());
                    configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, Collections.emptyList(), (ELManager)localManager));
                    configInfo.setElabWidthCheckDisabled(true);
                    configInfo.setElabWidthCheckFiltered(true);
                    RfProject.this.checkIsElaborated(library, configInfo, triggerError && !isPrecompiledSave, null);
                    List<RfPackage> packagesInLibrary = library.getLocalMembers(RfPackage.class);
                    if (packagesInLibrary == null || packagesInLibrary.isEmpty()) {
                        return;
                    }
                    for (RfPackage pkg : packagesInLibrary) {
                        RfProject.this.checkIsElaborated(pkg, configInfo, triggerError && !isPrecompiledSave, fullChecksKind, onlyPkgNames, null);
                    }
                }

                @Override
                void work(ExecutorService executorService, RfLibrary library, Set<String> onlyPkgNames) {
                    try {
                        this.checkUnelabInstanceHolders(library);
                        this.checkUnelabPkgAndLibs(library);
                    }
                    catch (BuildCancelException buildCancelException) {}
                }
            };
            this.multiThreadLibraryWorker(this.getLibraries(), null, null, libraryWorker);
        }
        catch (BuildCancelException buildCancelException) {}
        DVTLogger.INSTANCE.logInfo("VLOGDT Check unelaborated time = " + (System.currentTimeMillis() - time) + " ms");
    }

    public void checkUnelaboratedIncremental(boolean triggerError, Set<IRfNamedElement> unelaboratedDesigns, Set<IRfPackageElement> dirtyPackages, Set<IRfNamedElement> dirtyNonDesignElements) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS;
        long time = System.currentTimeMillis();
        try {
            if (this.fRfProjectContent.fIncrementalElaborationKind == null || this.fRfProjectContent.fIncrementalElaborationKind == IncrementalElaborationKind.NONE) {
                return;
            }
            if (this.fIncrementalDeltaContainer == null) {
                return;
            }
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            HashSet<ParserPath> visitedLibraryFiles = new HashSet<ParserPath>();
            ELManagerConfiguration elabLocalConfig = ELManagerConfiguration.newElabLocalConfig((IProject)this.getProject(), (int)1, (byte)1, (boolean)false, (int)1, (int)1, (boolean)false, (EnumSet)ElaborationControl.UNELABORATED_CONTROL_SET);
            EnumSet elabDebug = BuildConfigManager.getElaborationDebug((IProject)this.fProject);
            EnumSet<ElaborationDebugZone> localDebug = elabDebug.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
            ELManager localManager = new ELManager(this.fMixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), localDebug);
            ConfigInfo configInfo = new ConfigInfo(true, this, null, disableRTLChecks, this.getToolCompat());
            configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, Collections.emptyList(), (ELManager)localManager));
            configInfo.setElabWidthCheckDisabled(true);
            configInfo.setElabWidthCheckFiltered(true);
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> firstLevelElements : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    Object designs;
                    if (firstLevelElements == null || firstLevelElements.isEmpty() || (designs = this.getAllInstanceHolders(firstLevelElements, null, true, true, true)).isEmpty()) continue;
                    Iterator iterator = designs.iterator();
                    while (iterator.hasNext()) {
                        RfInstanceHolder design = (RfInstanceHolder)iterator.next();
                        this.checkIsElaborated(design, elabLocalConfig, triggerError, localDebug, visited, visitedLibraryFiles);
                    }
                }
            }
            List<RfInstanceHolder> designs = this.getAllInstanceHolders(unelaboratedDesigns, null, true, true, true);
            for (RfInstanceHolder unelabDesign : designs) {
                this.checkIsElaborated(unelabDesign, elabLocalConfig, triggerError, localDebug, visited, visitedLibraryFiles);
            }
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.getProject());
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(this.fLintingEnabled);
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(this.fLintingEnabled);
            for (IRfPackageElement pkg : dirtyPackages) {
                IRfLibraryElement enclosingLibrary = pkg.getEnclosingLibrary();
                if (!(enclosingLibrary instanceof RfLibrary)) continue;
                Set onlyPkgNames = null;
                if (onlyLibAndPkgNames != null) {
                    String libraryName = enclosingLibrary.getName();
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                        return;
                    }
                    if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                        return;
                    }
                    onlyPkgNames = (Set)onlyLibAndPkgNames.get(libraryName);
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) {
                        return;
                    }
                }
                configInfo.enclosingLibrary = enclosingLibrary;
                this.checkIsElaborated((RfLibrary)enclosingLibrary, configInfo, triggerError, visited);
                this.checkIsElaborated(pkg, configInfo, triggerError, fullChecksKind, onlyPkgNames, visited);
            }
            Set<IRfNamedElement> visitedCopy = Collections.newSetFromMap(new IdentityHashMap());
            if (dirtyNonDesignElements != null && !dirtyNonDesignElements.isEmpty()) {
                visited.addAll(dirtyNonDesignElements);
            }
            if (!visited.isEmpty()) {
                visitedCopy.addAll(visited);
            }
            this.resolveHidsIncremental(configInfo, true, fullChecksKind, onlyLibAndPkgNames, visitedCopy);
            this.resolveOperatorsIncremental(configInfo, true, fullChecksKind, onlyLibAndPkgNames, visited);
        }
        catch (BuildCancelException buildCancelException) {}
        DVTLogger.INSTANCE.logInfo("VLOGDT Incremental check unelaborated time = " + (System.currentTimeMillis() - time) + " ms");
    }

    public static void debugDelay() {
    }

    public DefNamedElementPair startConfig(String rawName, LineInfo startInfo, VlogFileInstance fileInstance, VlogMacroZone macroZone) {
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        this.fCurrentMacroZone = macroZone;
        String name = DVTStringUtil.unescapeIdentifier((String)rawName, (boolean)true);
        boolean isEscaped = name != null && rawName.length() != name.length();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        RfConfiguration configuration = enclosing instanceof RfLibrary ? ((RfLibrary)enclosing).getLocalConfiguration(name) : null;
        RfDefElement configurationDef = new RfConfigurationDef(this.fCurrentFileDef, name, startInfo);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(configurationDef);
        if (foundElem != null) {
            configurationDef = foundElem;
            if (this.isAlreadyDefined(configuration, foundElem)) {
                this.increaseDuplicateScope(configuration);
                this.pushScope(configurationDef, configuration);
                return new DefNamedElementPair(configurationDef, configuration);
            }
        }
        RfConfiguration rfConfiguration = configuration = configuration == null || !configuration.hasNoDefs(true) ? null : configuration;
        if (configuration != null) {
            configuration.clean();
        } else {
            RfLibrary currLibrary = null;
            currLibrary = enclosing instanceof RfLibrary ? (RfLibrary)enclosing : this.getOrCreateLibrary(this.getLibraryNameForFile(fileInstance));
            if (currLibrary == null) {
                return null;
            }
            configuration = new RfConfiguration(name, isEscaped, fileInstance.getParserPath(), currLibrary);
            currLibrary.addConfiguration(configuration);
        }
        configurationDef = configuration.addDeclaration(configurationDef);
        this.pushScope(configurationDef, configuration);
        return new DefNamedElementPair(configurationDef, configuration);
    }

    public void addConfigDefaultLiblist(RfConfiguration config, List<Identifier> libList, VlogFileInstance fileInstance, LineInfo startInfo) {
        if (config == null) {
            return;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        config.addDefaultLiblist(libList, this.fCurrentFileDef, startInfo);
    }

    public void addConfigInstanceLiblist(RfConfiguration config, List<Identifier> instancePath, List<Identifier> libList, VlogFileInstance fileInstance, LineInfo startInfo) {
        if (config == null) {
            return;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        config.addInstanceLiblist(instancePath, libList, this.fCurrentFileDef, startInfo);
    }

    public void addConfigInstanceUse(RfConfiguration config, List<Identifier> instancePath, List<Identifier> useName, VlogFileInstance fileInstance, LineInfo startInfo, DataType parametersDataType) {
        if (config == null) {
            return;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        config.addInstanceUse(instancePath, useName, this.fCurrentFileDef, startInfo, parametersDataType);
    }

    public void addConfigCellLiblist(RfConfiguration config, List<Identifier> cellName, List<Identifier> libList, VlogFileInstance fileInstance, LineInfo startInfo) {
        if (config == null) {
            return;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        config.addCellLiblist(cellName, libList, this.fCurrentFileDef, startInfo);
    }

    public void addConfigCellUse(RfConfiguration config, List<Identifier> cellName, List<Identifier> useName, VlogFileInstance fileInstance, LineInfo startInfo, DataType parametersDataType) {
        if (config == null) {
            return;
        }
        this.fCurrentFileDef = this.getFileDefinition(fileInstance);
        config.addCellUse(cellName, useName, this.fCurrentFileDef, startInfo, parametersDataType);
    }

    public void endConfig(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment, int endLabel) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement module = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, module);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        def.setDefComment(comment);
        def.setEndLabel(endLabel);
        this.popScope(fileInstance, module);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
    }

    public void cfgDefaultLibraryDecl(String defaultLibraryName) {
        this.fDefaultLibraryName = defaultLibraryName;
        this.fRfProjectContent.fFileToLibraryWildcardMapping.clear();
        this.fRfProjectContent.fFileToLibraryExplicitMapping.clear();
    }

    public void cfgLibraryDecl(String fileName, String libraryName) {
        if (fileName.contains("*") || fileName.contains("?") || fileName.contains("...")) {
            this.fRfProjectContent.fFileToLibraryWildcardMapping.put(fileName, libraryName);
        } else {
            this.fRfProjectContent.fFileToLibraryExplicitMapping.put(fileName, libraryName);
        }
    }

    private String getLibraryNameForFile(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        String libraryName = this.fRfProjectContent.fFileToLibraryExplicitMapping.get(parserPath.path);
        if (libraryName != null) {
            return libraryName;
        }
        VlogFileInstance includingFile = fileInstance.getIncludingFileInfo();
        if (includingFile != null && includingFile.getParserPath().path.indexOf("__vlog__") == -1) {
            libraryName = this.getLibraryNameForFile(includingFile);
            this.fRfProjectContent.fFileToLibraryExplicitMapping.put(parserPath.path, libraryName);
            return libraryName;
        }
        IPath filePath = Path.fromOSString((String)parserPath.path);
        Set<String> libmapFileNames = this.fRfProjectContent.fFileToLibraryWildcardMapping.keySet();
        if (libmapFileNames != null && !libmapFileNames.isEmpty()) {
            for (String libmapFileName : libmapFileNames) {
                IPath libmapPath = Path.fromOSString((String)libmapFileName);
                boolean matches = true;
                int libmapPathSegCount = libmapPath.segmentCount();
                int filePathSegCount = filePath.segmentCount();
                int matchingFirst = libmapPath.matchingFirstSegments(filePath);
                boolean anySubFolder = false;
                int fileIndex = matchingFirst;
                int libmapIndex = matchingFirst;
                while (fileIndex < filePathSegCount && libmapIndex < libmapPathSegCount) {
                    String libmapSegment = libmapPath.segment(libmapIndex);
                    if ("...".equals(libmapSegment)) {
                        anySubFolder = true;
                        ++libmapIndex;
                        continue;
                    }
                    String regExp = libmapSegment.replace(".", "\\.");
                    regExp = regExp.replace("*", ".*");
                    regExp = regExp.replace("?", ".");
                    String segment = filePath.segment(fileIndex);
                    try {
                        if (!segment.matches(regExp)) {
                            if (!anySubFolder) {
                                matches = false;
                                break;
                            }
                            ++fileIndex;
                            continue;
                        }
                        if (anySubFolder) {
                            anySubFolder = false;
                        }
                    }
                    catch (Exception exception) {}
                    ++fileIndex;
                    ++libmapIndex;
                }
                if (!matches || fileIndex <= filePathSegCount - 1 || libmapIndex <= libmapPathSegCount - 1) continue;
                libraryName = this.fRfProjectContent.fFileToLibraryWildcardMapping.get(libmapFileName);
                this.fRfProjectContent.fFileToLibraryExplicitMapping.put(parserPath.path, libraryName);
                return libraryName;
            }
        }
        IPath parentPath = filePath;
        while (parentPath.segmentCount() > 0) {
            String parentName = (parentPath = parentPath.removeLastSegments(1)).toOSString();
            libraryName = this.fRfProjectContent.fFileToLibraryExplicitMapping.get(parentName);
            if (libraryName == null) continue;
            this.fRfProjectContent.fFileToLibraryExplicitMapping.put(parserPath.path, libraryName);
            return libraryName;
        }
        this.fRfProjectContent.fFileToLibraryExplicitMapping.put(parserPath.path, this.fDefaultLibraryName);
        return this.fDefaultLibraryName;
    }

    public void computeFilesIncludedByMatchingTop(Map<StringMatcher, Set<String>> expanded) {
        VlogFileInstance topFileInstance = this.getPreprocessingTable().getTopFileInstance();
        if (topFileInstance.getParserPath() == null) {
            return;
        }
        this.computeImportedFilesRecursive(topFileInstance, expanded, new HashSet<StringMatcher>());
    }

    private void computeImportedFilesRecursive(VlogFileInstance topFileInstance, Map<StringMatcher, Set<String>> expanded, Set<StringMatcher> collect) {
        List<VlogFileInstance> includedInstances;
        if (topFileInstance == null) {
            return;
        }
        String shortFileName = topFileInstance.getShortFileName();
        if (shortFileName != null && !shortFileName.startsWith("__vlog__")) {
            for (Map.Entry<StringMatcher, Set<String>> entry : expanded.entrySet()) {
                StringMatcher matcher = entry.getKey();
                Set<String> importedFiles = entry.getValue();
                if (collect.contains(matcher)) {
                    importedFiles.add(topFileInstance.getParserPath().path);
                    continue;
                }
                if (!matcher.match(topFileInstance.getParserPath().path)) continue;
                importedFiles.add(topFileInstance.getParserPath().path);
                collect.add(matcher);
            }
        }
        if ((includedInstances = topFileInstance.getIncludedInstances()) == null) {
            return;
        }
        for (VlogFileInstance included : includedInstances) {
            this.computeImportedFilesRecursive(included, expanded, new HashSet<StringMatcher>(collect));
        }
    }

    public Set<String> computeFilesInMacroReparseStack(IRfDefElement declaration) {
        ReparseInfo.ReparseElement[] reparseStack;
        if (!(declaration instanceof RfDefElement)) {
            return null;
        }
        ReparseInfo reparseInfo = ((RfDefElement)declaration).getReparseInfo();
        if (reparseInfo == null || reparseInfo.getReparseStackSize() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        ReparseInfo.ReparseElement[] reparseElementArray = reparseStack = reparseInfo.getReparseStack();
        int n = reparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement entry = reparseElementArray[n2];
            if (entry.getReparseMacroFile() != null && entry.getReparseMacroFile().path != null) {
                result.add(entry.getReparseMacroFile().path);
            }
            ++n2;
        }
        return result;
    }

    public void setToolCompat(IBuildConfigParserConstants.ToolCompat toolCompat) {
        this.fRfProjectContent.fToolCompat = toolCompat;
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fRfProjectContent.fToolCompat;
    }

    public void setElaborationEnabled(IncrementalElaborationKind incrementalElaborationKind) {
        this.fRfProjectContent.fIncrementalElaborationKind = incrementalElaborationKind;
    }

    public ElementType computeElementType(IRfNamedElement namedElement, ElementPath instancePath) {
        if (namedElement instanceof RfActionBlock) {
            return new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfAssertExpect) {
            if (((RfAssertExpect)namedElement).isExpect()) {
                return new ElementType(ElementType.ElementTypeName.EXPECT, ElementType.ElementTypeLanguage.SV);
            }
            return new ElementType(ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfChecker) {
            return new ElementType(ElementType.ElementTypeName.CHECKER, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfClass) {
            return new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfClockingBlock) {
            return new ElementType(ElementType.ElementTypeName.CLOCKING_BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfConstraint) {
            return new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfCovergroup) {
            return new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfField) {
            if (namedElement instanceof RfInstance) {
                IRfNamedElement assocType;
                RfInstance instance = (RfInstance)namedElement;
                IRfNamedElement iRfNamedElement = assocType = instancePath == null ? instance.getAssociatedType() : instance.getGenericDesign(instancePath);
                if (assocType instanceof RfInterface) {
                    return new ElementType(ElementType.ElementTypeName.INTERFACE_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfModule) {
                    return new ElementType(ElementType.ElementTypeName.MODULE_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfChecker) {
                    return new ElementType(ElementType.ElementTypeName.CHECKER_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfProgram) {
                    return new ElementType(ElementType.ElementTypeName.PROGRAM_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                return new ElementType(ElementType.ElementTypeName.INSTANCE, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)namedElement).isEvent()) {
                return new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)namedElement).isVariable()) {
                return new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)namedElement).isParameter()) {
                return new ElementType(ElementType.ElementTypeName.PARAMETER, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)namedElement).isTypeParameter()) {
                return new ElementType(ElementType.ElementTypeName.TYPE_PARAMETER, ElementType.ElementTypeLanguage.SV);
            }
            if (namedElement instanceof RfCovercross && !namedElement.getName().contains("@")) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.SV);
            }
            if (namedElement instanceof RfCoverpoint && !namedElement.getName().contains(".")) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.SV);
            }
            if (namedElement instanceof RfPort) {
                return new ElementType(ElementType.ElementTypeName.PORT, ElementType.ElementTypeLanguage.SV);
            }
            return new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfFunction && !((RfFunction)namedElement).isTask()) {
            return new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isTask()) {
            return new ElementType(ElementType.ElementTypeName.TASK, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfGenerateBlock) {
            return new ElementType(ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfInterface) {
            return new ElementType(ElementType.ElementTypeName.INTERFACE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfModule) {
            return new ElementType(ElementType.ElementTypeName.MODULE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfPackage) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfLibrary) {
            return new ElementType(ElementType.ElementTypeName.LIBRARY, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfPrimitive) {
            return new ElementType(ElementType.ElementTypeName.PRIMITIVE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfProgram) {
            return new ElementType(ElementType.ElementTypeName.PROGRAM, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfPropertySequence) {
            return new ElementType(ElementType.ElementTypeName.PROPERTY_SEQUENCE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfTypeAlias) {
            return new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfConfiguration) {
            return new ElementType(ElementType.ElementTypeName.CONFIGURATION, ElementType.ElementTypeLanguage.SV);
        }
        if (namedElement instanceof RfModport) {
            return new ElementType(ElementType.ElementTypeName.MODPORT, ElementType.ElementTypeLanguage.SV);
        }
        return null;
    }

    public ElementType computeElementType(IRfDefElement defElement, IRfNamedElement namedElement, ElementPath instancePath) {
        if (defElement instanceof RfActionBlockDef) {
            return new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfAssertExpectDef) {
            if (((RfAssertExpect)defElement.getNamedElement()).isExpect()) {
                return new ElementType(ElementType.ElementTypeName.EXPECT, ElementType.ElementTypeLanguage.SV);
            }
            return new ElementType(ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfCheckerDef) {
            return new ElementType(ElementType.ElementTypeName.CHECKER, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfClassDef) {
            return new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfClockingBlockDef) {
            return new ElementType(ElementType.ElementTypeName.CLOCKING_BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfConstraintDef) {
            return new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfCovergroupDef) {
            return new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfFieldDef) {
            if ((RfField)defElement.getNamedElement() instanceof RfInstance) {
                IRfNamedElement assocType;
                RfInstance instance = (RfInstance)defElement.getNamedElement();
                IRfNamedElement iRfNamedElement = assocType = instancePath == null ? instance.getAssociatedType() : instance.getGenericDesign(instancePath);
                if (assocType instanceof RfInterface) {
                    return new ElementType(ElementType.ElementTypeName.INTERFACE_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfModule) {
                    return new ElementType(ElementType.ElementTypeName.MODULE_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfChecker) {
                    return new ElementType(ElementType.ElementTypeName.CHECKER_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                if (assocType instanceof RfProgram) {
                    return new ElementType(ElementType.ElementTypeName.PROGRAM_INSTANCE, ElementType.ElementTypeLanguage.SV);
                }
                return new ElementType(ElementType.ElementTypeName.INSTANCE, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)defElement.getNamedElement()).isEvent()) {
                return new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)defElement.getNamedElement()).isVariable()) {
                return new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)defElement.getNamedElement()).isParameter()) {
                return new ElementType(ElementType.ElementTypeName.PARAMETER, ElementType.ElementTypeLanguage.SV);
            }
            if (((RfField)defElement.getNamedElement()).isTypeParameter()) {
                return new ElementType(ElementType.ElementTypeName.TYPE_PARAMETER, ElementType.ElementTypeLanguage.SV);
            }
            if (defElement.getNamedElement() instanceof RfCovercross && !defElement.getNamedElement().getName().contains("@")) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.SV);
            }
            if (defElement.getNamedElement() instanceof RfCoverpoint && !defElement.getNamedElement().getName().contains(".")) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.SV);
            }
            if (defElement.getNamedElement() instanceof RfPort) {
                return new ElementType(ElementType.ElementTypeName.PORT, ElementType.ElementTypeLanguage.SV);
            }
            return new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfFunctionDef && !((RfFunction)defElement.getNamedElement()).isTask()) {
            return new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfFunctionDef && ((RfFunction)defElement.getNamedElement()).isTask()) {
            return new ElementType(ElementType.ElementTypeName.TASK, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfGenerateBlockDef) {
            return new ElementType(ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfInterfaceDef) {
            return new ElementType(ElementType.ElementTypeName.INTERFACE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfModuleDef) {
            return new ElementType(ElementType.ElementTypeName.MODULE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfPackageDef) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfPrimitiveDef) {
            return new ElementType(ElementType.ElementTypeName.PRIMITIVE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfProgramDef) {
            return new ElementType(ElementType.ElementTypeName.PROGRAM, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfPropertySequenceDef) {
            return new ElementType(ElementType.ElementTypeName.PROPERTY_SEQUENCE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfTypeAliasDef) {
            return new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfConfigurationDef) {
            return new ElementType(ElementType.ElementTypeName.CONFIGURATION, ElementType.ElementTypeLanguage.SV);
        }
        if (defElement instanceof RfModportDef) {
            return new ElementType(ElementType.ElementTypeName.MODPORT, ElementType.ElementTypeLanguage.SV);
        }
        return null;
    }

    public RfProjectState getProjectState() {
        return this.fProjectState;
    }

    public void setProjectState(RfProjectState state) {
        this.fProjectState = state;
    }

    public IIdleListener getIdleListener() {
        if (this.fIdleListener != null) {
            return this.fIdleListener;
        }
        this.fIdleListener = new IIdleListener(){

            public void platformIsIdle() {
                Utils.getInstance().saveRFDM(RfProject.this, false, true, false);
            }

            public boolean isWriteDone() {
                return Utils.getInstance().isWriteDone(RfProject.this.fProject);
            }
        };
        return this.fIdleListener;
    }

    @Override
    public void deepClean() {
        this.fRfProjectContent.deepClean();
        if (this.fDuplicatesScopeStack != null) {
            this.fDuplicatesScopeStack.clear();
        }
        this.getPreprocessingTable();
        this.getSourceFileToBuildFileMapping();
        super.deepClean();
        this.initPredefinedStdPackageLibrary();
        RfHidImplicit.cleanCaches();
    }

    public static void debugIncrement1() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount1.incrementAndGet();
        }
    }

    public static void incrementTime1(int time) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount4.addAndGet(time);
        }
    }

    public static void debugIncrement2() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount2.incrementAndGet();
        }
    }

    public final RfCompiledFiles readCompiledFiles(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        return persistence.readCompiledFiles(persistenceModeWrapper);
    }

    public boolean preRestore() {
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fProject);
        boolean precompiledDbSaveMode = precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.MANUAL_SAVE;
        return persistence.preRestore(this, precompiledDbSaveMode ? BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave() : BuildConfigManagerCommon.PersistenceModeWrapper.regular());
    }

    public void restore(IProgressMonitor monitor) {
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fProject);
        boolean precompiledDbSaveMode = precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.MANUAL_SAVE;
        persistence.restore(this, monitor, null, precompiledDbSaveMode ? BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave() : BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (precompiledDbSaveMode) {
            PropertiesManager.addSessionProperty((IResource)BuildConfigManager.getActiveBuildConfigIFile((IProject)this.fProject), (String)PropertyTypes.QN_IMPORTED_FILE, (String)"ro.amiq.dvt.ui.editor.BuildConfigEditor");
        }
        Utils.getInstance().connectActiveOpenEditor(this);
    }

    public void postReadObject() {
        for (RfFileDef rfFileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            rfFileDef.setRfProject(this);
        }
    }

    public DefNamedElementPair startAmsDiscipline(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfDiscipline discipline = enclosing.getLocalMember(RfDiscipline.class, name, false, this.fIncrementalBuild);
        RfDefElement disciplineDef = new RfDisciplineDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(disciplineDef);
        if (foundElem != null) {
            disciplineDef = foundElem;
            if (this.isAlreadyDefined(discipline, foundElem)) {
                this.increaseDuplicateScope(discipline);
                this.pushScope(disciplineDef, discipline);
                return new DefNamedElementPair(disciplineDef, discipline);
            }
        }
        RfDiscipline rfDiscipline = discipline = discipline == null || !discipline.hasNoDefs(true) ? null : discipline;
        if (discipline == null) {
            discipline = new RfDiscipline(name, info.isEscaped());
            enclosing.addMember(discipline);
        }
        discipline.setMacroZone(this.fCurrentMacroZone);
        disciplineDef = discipline.addDeclaration(disciplineDef);
        this.pushScope(disciplineDef, discipline);
        return new DefNamedElementPair(disciplineDef, discipline);
    }

    public void endAmsDiscipline(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement discipline = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, discipline);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        if (comment != null) {
            def.setDefComment(comment);
        }
        this.popScope(fileInstance, discipline);
    }

    public void setAmsNatureBinding(WrapperInfo info, String text) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        if (enclosing instanceof RfDiscipline) {
            if ("flow".equals(text)) {
                ((RfDiscipline)enclosing).setFlowNatureName(info.getName());
            } else {
                ((RfDiscipline)enclosing).setPotentialNatureName(info.getName());
            }
        }
    }

    public DefNamedElementPair startAmsNature(WrapperInfo info, NatureParent natureParent) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfNature nature = enclosing.getLocalMember(RfNature.class, name, false, this.fIncrementalBuild);
        RfDefElement natureDef = new RfNatureDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(natureDef);
        if (foundElem != null) {
            natureDef = foundElem;
            if (this.isAlreadyDefined(nature, foundElem)) {
                this.increaseDuplicateScope(nature);
                this.pushScope(natureDef, nature);
                return new DefNamedElementPair(natureDef, nature);
            }
        }
        RfNature rfNature = nature = nature == null || !nature.hasNoDefs(true) ? null : nature;
        if (nature == null) {
            nature = new RfNature(name, info.isEscaped());
            enclosing.addMember(nature);
        }
        nature.setParent(natureParent);
        nature.setMacroZone(this.fCurrentMacroZone);
        natureDef = nature.addDeclaration(natureDef);
        this.pushScope(natureDef, nature);
        return new DefNamedElementPair(natureDef, nature);
    }

    public void startAmsNatureAttr(WrapperInfo info, String value) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfNatureAttr natureAttr = enclosing.getLocalMember(RfNatureAttr.class, name, false, this.fIncrementalBuild);
        RfDefElement natureAttrDef = new RfNatureAttrDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(natureAttrDef);
        if (foundElem != null) {
            natureAttrDef = foundElem;
            if (this.isAlreadyDefined(natureAttr, foundElem)) {
                this.fCurrentFileDef.addChildDef(natureAttrDef);
                return;
            }
        }
        RfNatureAttr rfNatureAttr = natureAttr = natureAttr == null || !natureAttr.hasNoDefs(true) ? null : natureAttr;
        if (natureAttr == null) {
            natureAttr = new RfNatureAttr(name, info.isEscaped());
            enclosing.addMember(natureAttr);
        }
        natureAttr.setValue(value);
        natureAttr.setMacroZone(this.fCurrentMacroZone);
        natureAttrDef = natureAttr.addDeclaration(natureAttrDef);
        this.fCurrentFileDef.addChildDef(natureAttrDef);
    }

    public void endAmsNature(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement nature = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, nature);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        if (comment != null) {
            def.setDefComment(comment);
        }
        this.popScope(fileInstance, nature);
    }

    public DefNamedElementPair startAmsConnectRules(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfConnectRules connectRules = enclosing.getLocalMember(RfConnectRules.class, name, false, this.fIncrementalBuild);
        RfDefElement connectRulesDef = new RfConnectRulesDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(connectRulesDef);
        if (foundElem != null) {
            connectRulesDef = foundElem;
            if (this.isAlreadyDefined(connectRules, foundElem)) {
                this.increaseDuplicateScope(connectRules);
                this.pushScope(connectRulesDef, connectRules);
                return new DefNamedElementPair(connectRulesDef, connectRules);
            }
        }
        RfConnectRules rfConnectRules = connectRules = connectRules == null || !connectRules.hasNoDefs(true) ? null : connectRules;
        if (connectRules == null) {
            connectRules = new RfConnectRules(name, info.isEscaped());
            enclosing.addMember(connectRules);
        }
        connectRules.setMacroZone(this.fCurrentMacroZone);
        connectRulesDef = connectRules.addDeclaration(connectRulesDef);
        this.pushScope(connectRulesDef, connectRules);
        return new DefNamedElementPair(connectRulesDef, connectRules);
    }

    public void endAmsConnectRules(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement connectRules = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, connectRules);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        if (comment != null) {
            def.setDefComment(comment);
        }
        this.popScope(fileInstance, connectRules);
    }

    public DefNamedElementPair startAmsParamset(WrapperInfo info) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfParamset paramset = enclosing.getLocalMember(RfParamset.class, name, false, this.fIncrementalBuild);
        RfDefElement paramsetDef = new RfParamsetDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(paramsetDef);
        if (foundElem != null) {
            paramsetDef = foundElem;
            if (this.isAlreadyDefined(paramset, foundElem)) {
                this.increaseDuplicateScope(paramset);
                this.pushScope(paramsetDef, paramset);
                return new DefNamedElementPair(paramsetDef, paramset);
            }
        }
        RfParamset rfParamset = paramset = paramset == null || !paramset.hasNoDefs(true) ? null : paramset;
        if (paramset == null) {
            paramset = new RfParamset(name, info.isEscaped());
            enclosing.addMember(paramset);
        }
        paramset.setMacroZone(this.fCurrentMacroZone);
        paramsetDef = paramset.addDeclaration(paramsetDef);
        this.pushScope(paramsetDef, paramset);
        return new DefNamedElementPair(paramsetDef, paramset);
    }

    public void endAmsParamset(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo, CommentBlock comment) {
        if (defNamedElementPair == null) {
            return;
        }
        RfNamedElement paramset = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, paramset);
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        def.setEndOffset(endInfo);
        if (comment != null) {
            def.setDefComment(comment);
        }
        this.popScope(fileInstance, paramset);
    }

    public void syncCancelSave() {
        RfManager.getInstance().getPersistence(this.fProject).syncCancelSave();
    }

    public static IPath getVlogTopPath(IProject project) {
        IPath stateLocation = Utils.getInstance().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append("__vlog__" + project.getName() + "__top.sv");
        return topLocation;
    }

    public DefNamedElementPair startVunit(WrapperInfo info, String defaultNetType, HidImplicit[] timescale) {
        this.fCurrentFileDef = this.getFileDefinition(info.getFileInstance());
        this.fCurrentMacroZone = info.getMacroZone();
        RfNamedElement enclosing = this.fBuildScope.getScope();
        String name = info.getName();
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        RfVunit vunit = enclosing.getLocalMember(RfVunit.class, name, false, this.fIncrementalBuild);
        RfDefElement vunitDef = new RfVunitDef(this.fCurrentFileDef, info);
        RfDefElement foundElem = this.fCurrentFileDef.findDefElement(vunitDef);
        if (foundElem != null) {
            vunitDef = foundElem;
            if (this.isAlreadyDefined(vunit, foundElem)) {
                this.increaseDuplicateScope(vunit);
                this.pushScope(vunitDef, vunit, true);
                return new DefNamedElementPair(vunitDef, vunit);
            }
        }
        RfVunit rfVunit = vunit = vunit == null || !vunit.hasNoDefs(true) ? null : vunit;
        if (vunit == null) {
            vunit = new RfVunit(name, info.isEscaped(), defaultNetType, timescale);
            enclosing.addMember(vunit);
        } else {
            vunit.setTimescale(timescale);
            this.checkIfExistImplicitIncludedGenerateBlocks(vunit, vunitDef);
        }
        vunit.setTargetModuleOrInstance(info.getPslTargetInstances());
        vunitDef = vunit.addDeclaration(vunitDef);
        this.pushScope(vunitDef, vunit, true);
        return new DefNamedElementPair(vunitDef, vunit);
    }

    public void endVunit(IDVTFileInstance fileInstance, DefNamedElementPair defNamedElementPair, LineInfo endInfo) {
        if (defNamedElementPair == null) {
            return;
        }
        RfDefElement def = defNamedElementPair.getDefElement();
        if (def == null) {
            return;
        }
        RfNamedElement vunit = defNamedElementPair.getNamedElement();
        if (this.getCountDuplicateScopes() > 0) {
            this.popScope(fileInstance, vunit, true);
            return;
        }
        def.setEndOffset(endInfo);
        this.popScope(fileInstance, vunit, true);
        if (fileInstance != null) {
            fileInstance.endDefElement((IRfDefElement)def);
        }
        this.resolveLocalImplicitGenerateBlocksInElement(def, vunit);
    }

    public void addReference(RfLibrary library, String typeName, RfNamedElement referencedIn) {
        if (library == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        library.addReference(typeName, (IRfNamedElement)referencedIn);
    }

    public Collection<IRfNamedElement> getReferences(RfLibrary library, String dependsOnTypeName) {
        if (dependsOnTypeName == null || library == null) {
            return null;
        }
        return library.getReferences(dependsOnTypeName);
    }

    private boolean isAlreadyDefined(RfNamedElement element, RfDefElement foundDefElem) {
        if (element == null) {
            return false;
        }
        List<RfNamedElement> foundNamedElements = foundDefElem.getNamedElements();
        if (foundNamedElements == null || foundNamedElements.isEmpty()) {
            return false;
        }
        for (RfNamedElement foundNamedElement : foundNamedElements) {
            if (foundNamedElement != element) continue;
            return true;
        }
        return false;
    }

    public DVTPFModel getPFModel() {
        return this.fPowerFormatModel;
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
        this.fPowerFormatModel = powerFormatModel;
    }

    private void setUserDefinedSystemTasks() {
        PREDEFINED_GLOBAL.addUserDefinedFunctions(BuildConfigManager.getUserDefinedSystemFunctions((IProject)this.fProject));
        PREDEFINED_GLOBAL.addUserDefinedTasks(BuildConfigManager.getUserDefinedSystemTasks((IProject)this.fProject));
        PREDEFINED_GLOBAL.addSimulatorSpecificSystemMethods();
    }

    public void setOvmProject(OVMProject ovmProject) {
        this.ovmProject = ovmProject;
    }

    public OVMProject getOvmProject() {
        return this.ovmProject;
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        VlogMacroInfo macroBeforeLineInFile;
        if (classes == null || !classes.contains(VlogMacroInfo.class)) {
            return super.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, parserPath, line);
        }
        if (parserPath != null && line != -1 && (macroBeforeLineInFile = this.getMacroBeforeLineInFile(name, parserPath, line)) != null) {
            return macroBeforeLineInFile;
        }
        List<RfNamedElement> candidates = this.getMacrosWithPrefix(name, 1);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        return candidates.get(0);
    }

    public static boolean isEnableDefBeforeUseCheck(RfProject rfProject, IRfDefElement usageDef, IRfDefElement defDef) {
        if (rfProject == null || !(usageDef instanceof RfDefElement) || !(defDef instanceof RfDefElement)) {
            return false;
        }
        return rfProject.isEnableDefBeforeUseCheck(usageDef.getParserPath(), defDef.getParserPath());
    }

    private boolean isEnableDefBeforeUseCheck(ParserPath usageParserPath, ParserPath defParserPath) {
        if (usageParserPath == null || defParserPath == null) {
            return false;
        }
        if (this.getFileIndex(usageParserPath) == 0 || this.getFileIndex(defParserPath) == 0) {
            return false;
        }
        if (this.orderAnalysisScope == null) {
            this.orderAnalysisScope = BuildConfigManager.getUsageBeforeDeclarationScope((IProject)this.getProject());
        }
        boolean wildcard = this.fRfProjectContent.fWildcardConfiguredParserPaths != null && (this.fRfProjectContent.fWildcardConfiguredParserPaths.contains(defParserPath) || this.fRfProjectContent.fWildcardConfiguredParserPaths.contains(usageParserPath));
        boolean autoconf = this.fRfProjectContent.fAutoConfiguredParserPaths != null && (this.fRfProjectContent.fAutoConfiguredParserPaths.contains(defParserPath) || this.fRfProjectContent.fAutoConfiguredParserPaths.contains(usageParserPath));
        boolean sameFile = usageParserPath.equals((Object)defParserPath);
        boolean haveCommonInvoc = this.haveCommonInvocation(usageParserPath, defParserPath);
        switch (this.orderAnalysisScope) {
            case INVOCATION: {
                if (!haveCommonInvoc) {
                    return false;
                }
            }
            case ALL: {
                if (wildcard || autoconf) {
                    return sameFile;
                }
                return true;
            }
            case FILE: {
                return sameFile;
            }
        }
        return false;
    }

    private boolean haveCommonInvocation(ParserPath usageParserPath, ParserPath defParserPath) {
        if (this.fRfProjectContent.fInvocationIndicesByPath == null) {
            return false;
        }
        Set<Integer> usageInvocations = this.fRfProjectContent.fInvocationIndicesByPath.get(usageParserPath);
        if (usageInvocations == null || usageInvocations.isEmpty()) {
            return false;
        }
        Set<Integer> defInvocations = this.fRfProjectContent.fInvocationIndicesByPath.get(defParserPath);
        if (defInvocations == null || defInvocations.isEmpty()) {
            return false;
        }
        for (Integer in : usageInvocations) {
            if (!defInvocations.contains(in)) continue;
            return true;
        }
        return false;
    }

    private void computeAutoConfiguredParserPaths() {
        this.fRfProjectContent.fAutoConfiguredParserPaths = new HashSet<ParserPath>();
        this.fRfProjectContent.fWildcardConfiguredParserPaths = new HashSet<ParserPath>();
        List invocations = BuildConfigManager.getInvocations((IProject)this.fProject);
        if (invocations == null) {
            return;
        }
        HashSet<Integer> autoConfiguredInvocNumbers = new HashSet<Integer>();
        for (Invocation i : invocations) {
            boolean hasAutoParent = this.hasAutoParent(i);
            if (hasAutoParent) {
                autoConfiguredInvocNumbers.add(invocations.indexOf(i));
            }
            List topFiles = BuildConfigManager.getTopFiles((Invocation)i, (LanguageKind)LanguageKind.VLOG);
            for (BuildConfigProperty topFile : topFiles) {
                String topFileName = topFile.getValue();
                if (topFile.hasAttribute("ATTRIBUTE_WILDCARD_FILE")) {
                    this.fRfProjectContent.fWildcardConfiguredParserPaths.add(new ParserPath(topFileName));
                }
                if (!hasAutoParent) continue;
                this.fRfProjectContent.fAutoConfiguredParserPaths.add(new ParserPath(topFileName));
            }
        }
        if (autoConfiguredInvocNumbers.isEmpty()) {
            return;
        }
        VlogFileInstance artificialTop = this.fRfProjectContent.fPreprocessingTable.getTopFileInstance();
        if (artificialTop == null) {
            return;
        }
        List<VlogFileInstance> tops = artificialTop.getIncludedInstances();
        if (tops == null || tops.isEmpty()) {
            return;
        }
        for (VlogFileInstance top : tops) {
            if (!autoConfiguredInvocNumbers.contains(top.getInvocNumber())) {
                return;
            }
            LinkedList<VlogFileInstance> queue = new LinkedList<VlogFileInstance>();
            queue.addAll(top.getIncludedInstances());
            while (!queue.isEmpty()) {
                VlogFileInstance polled = (VlogFileInstance)queue.poll();
                this.fRfProjectContent.fAutoConfiguredParserPaths.add(polled.getParserPath());
                queue.addAll(polled.getIncludedInstances());
            }
        }
    }

    public void addInvocationIndexForPath(ParserPath path, int invocIndex) {
        if (this.fRfProjectContent.fInvocationIndicesByPath == null || path == null) {
            return;
        }
        Set<Integer> set = this.fRfProjectContent.fInvocationIndicesByPath.get(path);
        if (set == null) {
            set = new HashSet<Integer>();
            this.fRfProjectContent.fInvocationIndicesByPath.put(path, set);
        }
        set.add(invocIndex);
    }

    public void updateInvocationIndexForPath(ParserPath path, int invocIndex, int newInvocNumber) {
        if (this.fRfProjectContent.fInvocationIndicesByPath == null || path == null) {
            return;
        }
        Set<Integer> set = this.fRfProjectContent.fInvocationIndicesByPath.get(path);
        if (set == null) {
            return;
        }
        if (!set.remove(invocIndex)) {
            return;
        }
        set.add(newInvocNumber);
    }

    private boolean hasAutoParent(Invocation i) {
        do {
            if (i.getState().fKind == BuildConfigParser.InvocationKind.REGULAR) continue;
            return true;
        } while ((i = i.getState().fParentInvocation) != null);
        return false;
    }

    public boolean isExprEvaluatorDisabled() {
        return false;
    }

    public boolean xIsStaticValueHolder(XValueHolderFactory factory) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void computeNamedElementsWithEncryptedDefBuildPhase() {
        block12: {
            if (this.fNamedElementsWithEncryptedDefSet == null) {
                this.fNamedElementsWithEncryptedDefSet = new LinkedHashSet<RfNamedElement>();
            }
            this.fNamedElementsWithEncryptedDefSet.clear();
            docManager = new DocumentManager();
            try {
                docManager.activate();
                encryptedFileInfos = this.fRfProjectContent.fPreprocessingTable.getCodePreprocFileInfos();
                block6: for (Map.Entry<ParserPath, CodePreprocFileInfo> e : encryptedFileInfos.entrySet()) {
                    encryptedFileDef = this.fRfProjectContent.fParserPath2FileDefMap.get(e.getKey());
                    if (encryptedFileDef == null || (value = e.getValue()) == null || (codePreprocLineInfo = value.getCodePreprocLineInfo()) == null) continue;
                    document = null;
                    var12_13 = codePreprocLineInfo;
                    var11_12 = codePreprocLineInfo.length;
                    var10_11 = 0;
                    while (var10_11 < var11_12) {
                        epi = var12_13[var10_11];
                        if (!(epi instanceof EncryptedCodeLineInfo)) ** GOTO lbl29
                        if (document == null && (document = docManager.getDocument(e.getKey(), this.getProject())) == null) continue block6;
                        offset = document.getLineOffset(epi.getLine() - 1) + epi.getColumn();
                        encryptedDef = encryptedFileDef.getScope(offset);
                        if (encryptedDef == null) {
                            return;
                        }
                        try {
                            if (encryptedDef instanceof IRfDefElement && ((IRfDefElement)encryptedDef).getNamedElement() != null) {
                                encryptedDef = ((IRfDefElement)encryptedDef).getNamedElement();
                            }
                            if (encryptedDef instanceof RfNamedElement) {
                                this.fNamedElementsWithEncryptedDefSet.add((RfNamedElement)encryptedDef);
                            }
lbl29:
                            // 4 sources

                            ++var10_11;
                            continue;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                        break block12;
                    }
                }
            }
            finally {
                docManager.deactivate();
            }
        }
    }

    public Set<RfNamedElement> getNamedElementsWithEncryptedCode() {
        if (this.fNamedElementsWithEncryptedDefSet == null) {
            this.computeNamedElementsWithEncryptedDefBuildPhase();
        }
        return this.fNamedElementsWithEncryptedDefSet;
    }

    public boolean xHasEncryptedCode(IRfScopeElement element) {
        Set<RfNamedElement> namedElementsWithEncryptedCode = this.getNamedElementsWithEncryptedCode();
        return namedElementsWithEncryptedCode != null && namedElementsWithEncryptedCode.contains(element);
    }

    public Map<String, String> getPreprocessingParamsForDiagrams(IRfNamedElement element, String path, int line) {
        List localParameters;
        LinkedHashMap<String, String> parameterValues = new LinkedHashMap<String, String>();
        if (element instanceof IRfDesignElement && (localParameters = ((IRfDesignElement)element).getLocalParameters()) != null) {
            localParameters.stream().filter(e -> e instanceof IRfFieldElement).forEach(e -> {
                String string = parameterValues.put("#" + e.getName(), ((IRfFieldElement)e).getInitialValue(true));
            });
        }
        this.getMacrosBeforeLineInFile(new ParserPath(path), line).entrySet().stream().filter(e -> !((VlogMacroInfo)e.getValue()).hasParams() && ((VlogMacroInfo)e.getValue()).hasReplacement() && !((VlogMacroInfo)e.getValue()).isPredefined()).forEach(e -> {
            String string = parameterValues.put("`" + (String)e.getKey(), ((VlogMacroInfo)e.getValue()).getLabelProviderReplacement().trim());
        });
        return parameterValues;
    }

    public EncryptedCodeAutoFilter getEncryptedCodeAutoFilter() {
        if (this.fEncryptedCodeAutoFilter == null) {
            this.fEncryptedCodeAutoFilter = BuildConfigManager.getEncryptedCodeAutoDefineFilter((IProject)this.getProject());
        }
        return this.fEncryptedCodeAutoFilter;
    }

    public void addModulesByLibrary(String lib, String fullPath, TreeSet<String> modulesNamesByLibrary) {
        this.fRfProjectContent.addModulesByLibrary(lib, fullPath, modulesNamesByLibrary);
    }

    public TreeMap<String, TreeMap<String, TreeSet<String>>> getModulesNamesByLibrary() {
        return this.fRfProjectContent.getModulesNamesByLibrary();
    }

    public RfFileDef getCurrentFileDef() {
        return this.fCurrentFileDef;
    }

    public boolean hasLintingTimedOut() {
        if (!this.isLintingEnabled()) {
            return false;
        }
        OVMProject ovmProject = this.getOvmProject();
        if (ovmProject == null) {
            return false;
        }
        return ovmProject.hasTimedOutDuringBuild();
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    public IXValueHolderFactoryContributor getFactoryContributor(IRfSingleLangProject.FactoryContributorKind contributorKind, IXSim xSim) {
        switch (contributorKind) {
            case CHS: {
                return new XVlogCHSValueHolderFactory(this.getProject().getLocation().toOSString(), (XSimVlogCHS)xSim);
            }
            case UVM: {
                return new XVlogUVMValueHolderFactory();
            }
        }
        return null;
    }

    public ChangedFilesManager getChangedFilesManager() {
        if (this.fChangedFilesManager == null) {
            this.fChangedFilesManager = new ChangedFilesManager();
        }
        return this.fChangedFilesManager;
    }

    public void editorInputChanged(IFile currentFile, IEditorInput newInput, VlogEditor vlogEditor) {
        if (currentFile == null) {
            return;
        }
        IPath currentFileLocation = currentFile.getLocation();
        if (currentFileLocation == null) {
            return;
        }
        IFile newFile = (IFile)newInput.getAdapter(IFile.class);
        if (newFile == null) {
            return;
        }
        IPath newFileLocation = newFile.getLocation();
        if (newFileLocation == null) {
            return;
        }
        ParserPath currentFileParserPath = new ParserPath(currentFileLocation.toOSString());
        DVTEditor mapppedEditor = this.fParserPathToEditorMap.get(currentFileParserPath);
        if (mapppedEditor != vlogEditor) {
            DVTLogger.INSTANCE.logInfo("Inconsistent parser path to editor map, expected: " + (Object)((Object)vlogEditor) + " but was: " + mapppedEditor);
        }
        this.disconnectFileFromDocument(currentFileParserPath);
    }

    public IRfNamedElement getPackage(String name) {
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries == null || libraries.isEmpty()) {
            return null;
        }
        HashSet packages = new HashSet();
        for (RfLibrary rfLibrary : libraries) {
            try {
                rfLibrary.getLocalMembers(packages, RfPackage.class, name, Arrays.asList(name), 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, R2LFilters.or(R2LFilters.isPackage(true)));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (packages.isEmpty()) {
            return null;
        }
        return (IRfNamedElement)packages.iterator().next();
    }

    public void reparseFilesAffectedByMacroChanges(RfProject rfProject, Set<FileCompileInfo> changedFiles, IProgressMonitor monitor) {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fIncrementalDeltaContainer.reparseForFilesAffectedByMacroChanges(rfProject, changedFiles, monitor);
    }

    public void xCollectVirtualInterfaces(Set<IRfNamedElement> virtualInterfaces) {
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfInterface && ((RfInterface)namedElement).hasVirtualInterfaceRef()) {
                virtualInterfaces.add(namedElement);
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            return CLASS_CONTAINERS.contains(namedElement.getClass());
        };
        this.accept(visitor);
    }

    public Set<String> getIncludingFilesForFilePath(String filePath) {
        VlogFileInstance topInstance = this.getPreprocessingTable().getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        List<VlogFileInstance> fileInstances = topInstance.getFileInstances(new ParserPath(filePath));
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (VlogFileInstance fileInstance : fileInstances) {
            ParserPath includingFileParserPath;
            VlogFileInstance includingInstance;
            VlogIncludingScope includingScope = fileInstance.getIncludingScope();
            if (includingScope == null || (includingInstance = includingScope.getIncludingInstance()) == null || (includingFileParserPath = includingInstance.getParserPath()) == null || includingFileParserPath.path == null || includingFileParserPath.path.startsWith(System.getProperty("java.io.tmpdir"))) continue;
            result.add(includingFileParserPath.path);
        }
        return result;
    }

    private void increaseDuplicateScope(RfNamedElement newElement) {
        if (newElement == null) {
            return;
        }
        if (this.fDuplicatesScopeStack == null) {
            this.fDuplicatesScopeStack = new ArrayDeque<RfNamedElement>();
        }
        this.fDuplicatesScopeStack.addFirst(newElement);
    }

    private void decreaseDuplicateScope(RfNamedElement elementToBeDeleted) {
        if (this.fDuplicatesScopeStack == null) {
            return;
        }
        if (elementToBeDeleted == null || !this.fDuplicatesScopeStack.peekFirst().equals(elementToBeDeleted)) {
            return;
        }
        this.fDuplicatesScopeStack.removeFirst();
    }

    public int getCountDuplicateScopes() {
        if (this.fDuplicatesScopeStack == null) {
            return 0;
        }
        return this.fDuplicatesScopeStack.size();
    }

    private static class BuildScope {
        private transient Deque<RfNamedElement> fSemanticScopes;
        private transient RfLibrary fCurrentLibrary;
        private IntStack fGenerateConstructIndex = new IntArrayList();

        public BuildScope() {
            this.fSemanticScopes = new ArrayDeque<RfNamedElement>();
            this.fGenerateConstructIndex = new IntArrayList();
        }

        public RfNamedElement getScope() {
            return this.isEmpty() ? this.fCurrentLibrary : this.fSemanticScopes.peek();
        }

        public void setCurrentLibrary(RfLibrary library) {
            this.fCurrentLibrary = library;
        }

        public RfLibrary getCurrentLibrary() {
            return this.fCurrentLibrary;
        }

        public void pushGenerateConstructIndex() {
            this.fGenerateConstructIndex.push(0);
        }

        public void popGenerateConstructIndex() {
            if (this.fGenerateConstructIndex.isEmpty()) {
                return;
            }
            this.fGenerateConstructIndex.pop();
        }

        public int incrementAndGetGenerateConstructIndex() {
            if (this.fGenerateConstructIndex.isEmpty()) {
                return -1;
            }
            int index = this.fGenerateConstructIndex.popInt();
            this.fGenerateConstructIndex.push(index + 1);
            return index + 1;
        }

        public int getGenerateConstructIndex() {
            if (this.fGenerateConstructIndex.isEmpty()) {
                return -1;
            }
            return this.fGenerateConstructIndex.topInt();
        }

        public void pushSemanticScope(RfNamedElement scope) {
            if (this.fSemanticScopes != null) {
                this.fSemanticScopes.push(scope);
            }
        }

        public RfNamedElement peekSemanticScope() {
            if (!this.isEmpty()) {
                return this.fSemanticScopes.peek();
            }
            return null;
        }

        public RfNamedElement popSemanticScope() {
            if (!this.isEmpty()) {
                return this.fSemanticScopes.pop();
            }
            return null;
        }

        public void clean() {
            this.fSemanticScopes.clear();
            this.fCurrentLibrary = null;
        }

        public void setScope(RfNamedElement scope) {
            this.fSemanticScopes.clear();
            if (!(scope instanceof RfLibrary)) {
                this.fSemanticScopes.push(scope);
                this.fCurrentLibrary = scope.getEnclosingLibrary();
            } else {
                this.fCurrentLibrary = (RfLibrary)scope;
            }
        }

        public boolean isEmpty() {
            return this.fSemanticScopes == null || this.fSemanticScopes.isEmpty();
        }
    }

    private static class CheckCustomPragmasHelper {
        private VlogFileInstance firstFileInstance;
        private List<CustomPragmaUsage> customPragmaUsage = new ArrayList<CustomPragmaUsage>();
    }

    static abstract class LibraryWorker {
        LibraryWorker() {
        }

        abstract void work(ExecutorService var1, RfLibrary var2, Set<String> var3);

        public void executeOnThread(ExecutorService executorService, RfLibrary library, Set<String> onlyPkgNames) {
            executorService.execute(() -> this.work(executorService, library, onlyPkgNames));
        }
    }

    static class PropertyConfig {
        private IRfConfiguration configuration;
        private BuildConfigProperty property;

        public PropertyConfig(IRfConfiguration configuration, BuildConfigProperty property) {
            this.configuration = configuration;
            this.property = property;
        }

        public <T extends IRfConfiguration> T getConfiguration(Class<T> clazz) {
            if (clazz == null) {
                return null;
            }
            return (T)(clazz.isInstance(this.configuration) ? this.configuration : null);
        }

        public BuildConfigProperty getProperty() {
            return this.property;
        }
    }

    private class RfNamedElementComparator
    implements Comparator<RfNamedElement> {
        private RfNamedElementComparator() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            if (o1.getName() == null || o2.getName() == null) {
                return 0;
            }
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class RfProjectContent
    implements Serializable,
    IRfProjectContent {
        private static final long serialVersionUID = 23000L;
        protected IBuildConfigParserConstants.ToolCompat fToolCompat;
        protected IncrementalElaborationKind fIncrementalElaborationKind;
        protected Map<ParserPath, RfFileDef> fParserPath2FileDefMap;
        protected DVTLinkedHashMap<String, RfLibrary> fLibraries;
        protected VlogPreprocessingInfo fPreprocessingTable;
        protected Map<String, String> fFileToLibraryWildcardMapping;
        protected Map<String, String> fFileToLibraryExplicitMapping;
        protected SourceFileToBuildFileMapping fSourceFileToBuildFileMapping;
        public Set<ParserPath> fAutoConfiguredParserPaths;
        public Set<ParserPath> fWildcardConfiguredParserPaths;
        public Map<ParserPath, Set<Integer>> fInvocationIndicesByPath;
        private TreeMap<String, TreeMap<String, TreeSet<String>>> fModulesNamesByLibrary;

        public void setEnclosingScope(IRfSingleLangProject rfProject) throws Exception {
            if (this.fLibraries == null || this.fLibraries.isEmpty()) {
                return;
            }
            for (RfLibrary library : this.fLibraries.values()) {
                library.setEnclosingScope((RfProject)rfProject);
            }
            if (this.fPreprocessingTable == null) {
                return;
            }
            VlogFileInstance topInstance = this.fPreprocessingTable.getTopFileInstance();
            if (topInstance == null) {
                return;
            }
            topInstance.visitMacros(macroInfo -> {
                macroInfo.setEnclosingScope((RfProject)rfProject);
                return true;
            });
            topInstance.visitInstances(fileInstance -> {
                fileInstance.setRfProject((RfProject)rfProject);
                return true;
            });
        }

        public void deepClean() {
            if (this.fLibraries != null) {
                this.fLibraries.deepClean();
                this.fLibraries.clear();
            }
            if (this.fParserPath2FileDefMap != null) {
                for (RfFileDef fileDef : this.fParserPath2FileDefMap.values()) {
                    fileDef.deepClean();
                }
                this.fParserPath2FileDefMap.clear();
            }
            if (this.fFileToLibraryWildcardMapping != null) {
                this.fFileToLibraryWildcardMapping.clear();
            }
            if (this.fFileToLibraryExplicitMapping != null) {
                this.fFileToLibraryExplicitMapping.clear();
            }
            if (this.fPreprocessingTable != null) {
                this.fPreprocessingTable.deepClean();
            }
            this.fPreprocessingTable = null;
            if (this.fAutoConfiguredParserPaths != null) {
                this.fAutoConfiguredParserPaths.clear();
            }
            this.fAutoConfiguredParserPaths = null;
            if (this.fWildcardConfiguredParserPaths != null) {
                this.fWildcardConfiguredParserPaths.clear();
            }
            this.fWildcardConfiguredParserPaths = null;
            if (this.fInvocationIndicesByPath != null) {
                this.fInvocationIndicesByPath.clear();
            }
            this.fInvocationIndicesByPath = null;
            if (this.fSourceFileToBuildFileMapping != null) {
                this.fSourceFileToBuildFileMapping.deepClean();
            }
            this.fSourceFileToBuildFileMapping = null;
        }

        public void addModulesByLibrary(String lib, String fullPath, TreeSet<String> modulesNamesByLibrary) {
            TreeSet<String> modules;
            TreeMap<String, TreeSet<String>> modulesByFile;
            if (this.fModulesNamesByLibrary == null) {
                this.fModulesNamesByLibrary = new TreeMap();
            }
            if ((modulesByFile = this.fModulesNamesByLibrary.get(lib)) == null) {
                modulesByFile = new TreeMap();
                this.fModulesNamesByLibrary.put(lib, modulesByFile);
            }
            if ((modules = modulesByFile.get(fullPath)) == null) {
                modules = new TreeSet();
                modulesByFile.put(fullPath, modules);
            }
            modules.addAll(modulesNamesByLibrary);
        }

        public TreeMap<String, TreeMap<String, TreeSet<String>>> getModulesNamesByLibrary() {
            return this.fModulesNamesByLibrary != null ? this.fModulesNamesByLibrary : new TreeMap<String, TreeMap<String, TreeSet<String>>>();
        }

        public Map<ParserPath, Set<Integer>> getInvocationIndicesByPath() {
            return this.fInvocationIndicesByPath;
        }

        public IBuildConfigParserConstants.ToolCompat getToolCompat() {
            return this.fToolCompat;
        }

        public void setToolCompat(IBuildConfigParserConstants.ToolCompat fToolCompat) {
            this.fToolCompat = fToolCompat;
        }

        public Map<ParserPath, RfFileDef> getParserPath2FileDefMap() {
            return this.fParserPath2FileDefMap;
        }

        public void setParserPath2FileDefMap(Map<ParserPath, RfFileDef> fParserPath2FileDefMap) {
            this.fParserPath2FileDefMap = fParserPath2FileDefMap;
        }

        public DVTLinkedHashMap<String, RfLibrary> getLibraries() {
            return this.fLibraries;
        }

        public void setLibraries(DVTLinkedHashMap<String, RfLibrary> fLibraries) {
            this.fLibraries = fLibraries;
        }

        public VlogPreprocessingInfo getPreprocessingTable() {
            return this.fPreprocessingTable;
        }

        public void setPreprocessingTable(VlogPreprocessingInfo fPreprocessingTable) {
            this.fPreprocessingTable = fPreprocessingTable;
        }

        public Map<String, String> getFileToLibraryWildcardMapping() {
            return this.fFileToLibraryWildcardMapping;
        }

        public void setFileToLibraryWildcardMapping(Map<String, String> fFileToLibraryWildcardMapping) {
            this.fFileToLibraryWildcardMapping = fFileToLibraryWildcardMapping;
        }

        public Map<String, String> getFileToLibraryExplicitMapping() {
            return this.fFileToLibraryExplicitMapping;
        }

        public void setFileToLibraryExplicitMapping(Map<String, String> fFileToLibraryExplicitMapping) {
            this.fFileToLibraryExplicitMapping = fFileToLibraryExplicitMapping;
        }

        public SourceFileToBuildFileMapping getSourceFileToBuildFileMapping() {
            return this.fSourceFileToBuildFileMapping;
        }

        public void setSourceFileToBuildFileMapping(SourceFileToBuildFileMapping fSourceFileToBuildFileMapping) {
            this.fSourceFileToBuildFileMapping = fSourceFileToBuildFileMapping;
        }
    }

    static class SemanticErrorsTable {
        private Map<IRfSingleLangProject.SemanticErrorsCategory, Map<String, ErrorsAndWarnings>> fErrorsAndWarnings = new EnumMap<IRfSingleLangProject.SemanticErrorsCategory, Map<String, ErrorsAndWarnings>>(IRfSingleLangProject.SemanticErrorsCategory.class);
        private Map<IRfSingleLangProject.SemanticErrorsCategory, Map<RfSemanticError, RfSemanticError>> fAlreadyReportedSet = new EnumMap<IRfSingleLangProject.SemanticErrorsCategory, Map<RfSemanticError, RfSemanticError>>(IRfSingleLangProject.SemanticErrorsCategory.class);

        public SemanticErrorsTable() {
            this.init();
        }

        public void clearLibsOrPkgs(IRfSingleLangProject.SemanticErrorsCategory category, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            Map<RfSemanticError, RfSemanticError> map = this.fAlreadyReportedSet.get(category);
            if (onlyLibAndPkgNames == null) {
                for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    if (errorsAndWarnings != null && errorsAndWarnings.errorsMap != null) {
                        for (Set set : errorsAndWarnings.errorsMap.values()) {
                            if (map == null) continue;
                            map.keySet().removeAll(set);
                        }
                    }
                    if (errorsAndWarnings == null || errorsAndWarnings.warningsMap == null) continue;
                    for (Set set : errorsAndWarnings.warningsMap.values()) {
                        if (map == null) continue;
                        map.keySet().removeAll(set);
                    }
                }
                errorsAndWarningsPerCategory.clear();
            } else {
                for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    this.clearLibsOrPkgs(category, fullChecksKind, onlyLibAndPkgNames, errorsAndWarnings, errorsAndWarnings.errorsMap);
                    this.clearLibsOrPkgs(category, fullChecksKind, onlyLibAndPkgNames, errorsAndWarnings, errorsAndWarnings.warningsMap);
                }
            }
        }

        private void clearLibsOrPkgs(IRfSingleLangProject.SemanticErrorsCategory category, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, ErrorsAndWarnings semanticErrors, Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap) {
            if (problemsMap == null || problemsMap.isEmpty()) {
                return;
            }
            Map<RfSemanticError, RfSemanticError> map = this.fAlreadyReportedSet.get(category);
            for (Set set : problemsMap.values()) {
                if (set == null || set.isEmpty()) continue;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    RfSemanticError error = (RfSemanticError)iterator.next();
                    if (!error.inLibraryOrPackage((Enum<FullChecksKind>)fullChecksKind, onlyLibAndPkgNames)) continue;
                    iterator.remove();
                    if (map != null) {
                        map.remove(error);
                    }
                    if (error.getSeverity() == 1) {
                        --semanticErrors.nofErrors;
                        continue;
                    }
                    --semanticErrors.nofWarnings;
                }
            }
        }

        public void init() {
            this.fAlreadyReportedSet.clear();
            this.fErrorsAndWarnings.clear();
        }

        public Map<String, ErrorsAndWarnings> get(IRfSingleLangProject.SemanticErrorsCategory category) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.fErrorsAndWarnings.get(category);
            if (errorsAndWarningsPerCategory == null) {
                errorsAndWarningsPerCategory = ro.amiq.vlogdt.test.TestHelper.isTestMode() ? new TreeMap() : new LinkedHashMap();
                this.fErrorsAndWarnings.put(category, errorsAndWarningsPerCategory);
            }
            return errorsAndWarningsPerCategory;
        }

        public void clearDependencies(IRfSingleLangProject.SemanticErrorsCategory category, Map<ParserPath, Set<IRfNamedElement>> delta) {
            if (delta == null || delta.isEmpty()) {
                return;
            }
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            for (Set<IRfNamedElement> namedElements : delta.values()) {
                if (namedElements == null || namedElements.isEmpty()) continue;
                for (IRfNamedElement namedElement : namedElements) {
                    RfElementPath elementPath;
                    IRfNamedElement closestTypeContainer;
                    if (namedElement instanceof RfLibrary) {
                        HashMap<String, Set<String>> onlyLibAndPkgNames = new HashMap<String, Set<String>>();
                        onlyLibAndPkgNames.put(namedElement.getName(), null);
                        this.clearLibsOrPkgs(category, FullChecksKind.LIBS, onlyLibAndPkgNames);
                    }
                    if (namedElement == null || namedElement.hasNoDefs(false) || (closestTypeContainer = (IRfNamedElement)namedElement.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) == null || closestTypeContainer.hasNoDefs(false)) continue;
                    if (closestTypeContainer instanceof RfConfiguration) {
                        closestTypeContainer = closestTypeContainer.getEnclosingLibrary();
                    }
                    if ((elementPath = RfElementPath.path((IRfNamedElement)closestTypeContainer)) == null) continue;
                    for (Map.Entry<String, ErrorsAndWarnings> errorAndWarningEntry : errorsAndWarningsPerCategory.entrySet()) {
                        ErrorsAndWarnings errorsAndWarnings = errorAndWarningEntry.getValue();
                        if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
                        errorsAndWarnings.remove(category, elementPath);
                    }
                }
            }
        }

        public void clearFiles(IRfSingleLangProject.SemanticErrorsCategory category, RfProject rfProject, Collection<ParserPath> changedFiles) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            Map<RfSemanticError, RfSemanticError> map = this.fAlreadyReportedSet.get(category);
            if (changedFiles == null) {
                for (ErrorsAndWarnings removedErrorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    if (removedErrorsAndWarnings != null && removedErrorsAndWarnings.errorsMap != null) {
                        for (Set set : removedErrorsAndWarnings.errorsMap.values()) {
                            if (map == null) continue;
                            map.keySet().removeAll(set);
                        }
                    }
                    if (removedErrorsAndWarnings == null || removedErrorsAndWarnings.warningsMap == null) continue;
                    for (Set set : removedErrorsAndWarnings.warningsMap.values()) {
                        if (map == null) continue;
                        map.keySet().removeAll(set);
                    }
                }
                errorsAndWarningsPerCategory.clear();
            } else {
                for (ParserPath parserPath : changedFiles) {
                    String string;
                    if (parserPath == null || (string = rfProject.parser2resource(parserPath)) == null) continue;
                    ErrorsAndWarnings removedErrorsAndWarnings = errorsAndWarningsPerCategory.remove(string);
                    if (removedErrorsAndWarnings != null && removedErrorsAndWarnings.errorsMap != null) {
                        for (Set set : removedErrorsAndWarnings.errorsMap.values()) {
                            if (map == null) continue;
                            map.keySet().removeAll(set);
                        }
                    }
                    if (removedErrorsAndWarnings == null || removedErrorsAndWarnings.warningsMap == null) continue;
                    for (Set set : removedErrorsAndWarnings.warningsMap.values()) {
                        if (map == null) continue;
                        map.keySet().removeAll(set);
                    }
                }
            }
        }

        public void setObsolete(IRfSingleLangProject.SemanticErrorsCategory category) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
                this.setObsolete(errorsAndWarnings.errorsMap);
                this.setObsolete(errorsAndWarnings.warningsMap);
            }
        }

        private void setObsolete(Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap) {
            if (problemsMap == null || problemsMap.isEmpty()) {
                return;
            }
            for (Set set : problemsMap.values()) {
                if (set == null || set.isEmpty()) continue;
                for (RfSemanticError problem : set) {
                    problem.setObsolete(true);
                }
            }
        }

        public ErrorsAndWarnings getNofErrorsAndWarnings(IRfSingleLangProject.SemanticErrorsCategory category, String resourcePath) {
            ErrorsAndWarnings nofErrorsAndWarnings;
            Map<String, ErrorsAndWarnings> nofErrorsAndWarningsPerCategory = this.fErrorsAndWarnings.get(category);
            if (nofErrorsAndWarningsPerCategory == null) {
                nofErrorsAndWarningsPerCategory = ro.amiq.vlogdt.test.TestHelper.isTestMode() ? new TreeMap() : new LinkedHashMap();
                this.fErrorsAndWarnings.put(category, nofErrorsAndWarningsPerCategory);
            }
            if ((nofErrorsAndWarnings = nofErrorsAndWarningsPerCategory.get(resourcePath)) == null) {
                nofErrorsAndWarnings = new ErrorsAndWarnings();
                nofErrorsAndWarningsPerCategory.put(resourcePath, nofErrorsAndWarnings);
            }
            return nofErrorsAndWarnings;
        }

        public class ErrorsAndWarnings {
            public int nofWarnings;
            public int nofErrors;
            public Map<RfElementPath, TreeSet<RfSemanticError>> errorsMap = new LinkedHashMap<RfElementPath, TreeSet<RfSemanticError>>();
            public Map<RfElementPath, TreeSet<RfSemanticError>> warningsMap = new LinkedHashMap<RfElementPath, TreeSet<RfSemanticError>>();

            public boolean isEmpty() {
                return this.errorsMap.isEmpty() && this.warningsMap.isEmpty();
            }

            public void remove(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath elementPath) {
                this.remove(category, elementPath, 1);
                this.remove(category, elementPath, 2);
            }

            private void remove(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath elementPath, int severity) {
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap = severity == 1 ? this.errorsMap : this.warningsMap;
                TreeSet<RfSemanticError> removedProblems = problemsMap.remove(elementPath);
                if (removedProblems == null || removedProblems.isEmpty()) {
                    return;
                }
                Map<RfSemanticError, RfSemanticError> map = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                if (map != null) {
                    map.keySet().removeAll(removedProblems);
                }
                if (severity == 1) {
                    this.nofErrors -= removedProblems.size();
                } else {
                    this.nofWarnings -= removedProblems.size();
                }
            }

            public void addErrorOrWarning(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath closestTypeContainer, RfSemanticError errorOrWarning, RfProject rfProject) {
                int severity;
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap;
                TreeSet<RfSemanticError> problems;
                Map<RfSemanticError, RfSemanticError> map = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                if (map != null && map.containsKey(errorOrWarning)) {
                    String initialPaths;
                    Map<String, Object> attributes = errorOrWarning.getAttributes();
                    if (attributes == null) {
                        return;
                    }
                    String newElabPaths = (String)attributes.get("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE");
                    if (newElabPaths == null || newElabPaths.isEmpty()) {
                        return;
                    }
                    RfSemanticError registeredError = map.get(errorOrWarning);
                    Map<String, Object> registeredAttributes = registeredError.getAttributes();
                    if (registeredAttributes == null) {
                        registeredAttributes = new HashMap<String, Object>();
                    }
                    if ((initialPaths = (String)registeredAttributes.get("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE")) == null) {
                        initialPaths = "";
                    }
                    initialPaths = initialPaths.isEmpty() ? String.valueOf(initialPaths) + newElabPaths : String.valueOf(initialPaths) + "," + newElabPaths;
                    registeredAttributes.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", initialPaths);
                    if (ro.amiq.vlogdt.test.TestHelper.isTestMode() && ro.amiq.vlogdt.test.TestHelper.isComputingElaborationContext()) {
                        ro.amiq.vlogdt.test.TestHelper.addElabContext((ELManager)rfProject.getELManager(), registeredAttributes);
                    }
                    return;
                }
                if (ro.amiq.vlogdt.test.TestHelper.isTestMode() && ro.amiq.vlogdt.test.TestHelper.isComputingElaborationContext() && errorOrWarning.getAttributes() != null) {
                    ro.amiq.vlogdt.test.TestHelper.addElabContext((ELManager)rfProject.getELManager(), errorOrWarning.getAttributes());
                }
                if ((problems = (problemsMap = (severity = errorOrWarning.getSeverity()) == 1 ? this.errorsMap : this.warningsMap).get(closestTypeContainer)) == null) {
                    problems = new TreeSet();
                    problemsMap.put(closestTypeContainer, problems);
                }
                int size = problems.size();
                problems.add(errorOrWarning);
                if (size < problems.size()) {
                    Map newMap = SemanticErrorsTable.this.fAlreadyReportedSet.computeIfAbsent(category, key -> new HashMap());
                    newMap.put(errorOrWarning, errorOrWarning);
                    if (severity == 1) {
                        ++this.nofErrors;
                    } else {
                        ++this.nofWarnings;
                    }
                }
            }

            public LastProblemEntry removeLastErrorOrWarningAfterLine(IRfSingleLangProject.SemanticErrorsCategory category, int severity, int line) {
                RfSemanticError lastProblem = null;
                TreeSet<RfSemanticError> lastProblemHolder = null;
                RfElementPath lastTypeContainer = null;
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap = severity == 1 ? this.errorsMap : this.warningsMap;
                for (Map.Entry<RfElementPath, TreeSet<RfSemanticError>> problems : problemsMap.entrySet()) {
                    RfSemanticError candidate;
                    if (problems == null || problems.getValue().isEmpty() || (candidate = problems.getValue().last()).getLine() <= line) continue;
                    if (lastProblem == null || candidate.getLine() > lastProblem.getLine()) {
                        lastProblem = candidate;
                        lastProblemHolder = problems.getValue();
                        lastTypeContainer = problems.getKey();
                        continue;
                    }
                    if (candidate.getLine() != lastProblem.getLine() || lastProblem.compareTo(candidate) >= 0) continue;
                    lastProblem = candidate;
                    lastProblemHolder = problems.getValue();
                    lastTypeContainer = problems.getKey();
                }
                if (lastProblemHolder != null && lastProblem != null) {
                    lastProblemHolder.remove(lastProblem);
                    Map<RfSemanticError, RfSemanticError> map = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                    if (map != null) {
                        map.remove(lastProblem);
                    }
                    if (severity == 1) {
                        --this.nofErrors;
                    } else {
                        --this.nofWarnings;
                    }
                    return new LastProblemEntry(lastTypeContainer, lastProblem);
                }
                return null;
            }
        }

        static class LastProblemEntry {
            private RfElementPath lastTypeContainer;
            private RfSemanticError lastProblem;

            public LastProblemEntry(RfElementPath lastTypeContainer, RfSemanticError lastProblem) {
                this.lastTypeContainer = lastTypeContainer;
                this.lastProblem = lastProblem;
            }
        }
    }
}

