/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPropertySequence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfDeprecatedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

public class RfPropertySequence
extends RfMembersHolder
implements IRfPropertySequence {
    private static final long serialVersionUID = 1L;
    public static final int PROPERTY = 1;
    public static final int SEQUENCE = 2;
    private short fKind = 1;
    private IHidObject expression;
    private static final HidOperatorQualifier[] CLOCKING_EVENT_QUALIFIER = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CLOCKING_EVENT};

    public RfPropertySequence(String name, boolean escaped, int kind) {
        super(name, escaped);
        this.fKind = (short)kind;
        if (kind == 2) {
            this.addMember(new RfPredefinedFunction("triggered", RfProject.getSimpleDataType("boolean"), null, 0, "It tests whether its operand sequence has reached its end point at that particular point in time"));
            this.addMember(new RfPredefinedFunction("matched", RfProject.getSimpleDataType("boolean"), null, 0, "Provides synchronization between two clocks by storing the result of the source sequence until the arrival of the first clock tick of the destination sequence after the match"));
            this.addMember(new RfDeprecatedFunction("ended", RfProject.getSimpleDataType("boolean"), null, 0, "It tests whether its operand sequence has reached its end point at that particular point in time"));
        }
    }

    public IHidObject getExpression() {
        return this.expression;
    }

    public void setExpression(IHidObject expression) {
        this.expression = expression;
    }

    public List<IHidOperator> getClockingEvents() {
        return this.getHidOperators(CLOCKING_EVENT_QUALIFIER, true);
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        switch (this.fKind) {
            case 1: {
                return "property " + this.getName();
            }
            case 2: {
                return "sequence " + this.getName();
            }
        }
        return "";
    }

    public List<IRfFieldElement> getArguments() {
        if (this.fMembers == null) {
            return Collections.emptyList();
        }
        ArrayList<IRfFieldElement> arguments = new ArrayList<IRfFieldElement>();
        for (RfNamedElement member : this.fMembers) {
            if (!(member instanceof IRfFieldElement) || !((IRfFieldElement)member).isArgument()) continue;
            arguments.add((IRfFieldElement)member);
        }
        return arguments;
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public boolean hasProperty(int kind) {
        return (this.fKind & kind) != 0;
    }

    public boolean isProperty() {
        return this.fKind == 1;
    }

    public boolean isSequence() {
        return this.fKind == 2;
    }

    public short getKind() {
        return this.fKind;
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public List<RfStruct> getStructsUnionsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getStructUnionWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfStruct> getEnumTypesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getEnumTypeWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getEnumElementsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfTypeAlias> getTypeAliasesWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfScalarType> getScalarTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfScalarType getScalarTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfFunction> getTasksWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfCovergroup> getCovergroupsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfActionBlock> getNamedBlocksWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfAssertExpect> getAssertsExpectsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public Image getImage() {
        if (this.isProperty()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROPERTY);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
    }
}

