/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.WrapperInfo;

public class RfPropertySequenceDef
extends RfDefElement {
    private static final long serialVersionUID = 1L;
    private short relativeOffsetToLabel;
    private short relativeLineToLabel;

    public RfPropertySequenceDef(RfFileDef file, WrapperInfo info) {
        super(file, info);
        if (info != null) {
            LineInfo startInfo = info.getStartInfo();
            LineInfo labelInfo = info.getLabelInfo();
            this.relativeOffsetToLabel = (short)(labelInfo == null || startInfo == null ? 0 : labelInfo.realOffset - startInfo.realOffset);
            this.relativeLineToLabel = (short)(labelInfo == null || startInfo == null ? 0 : labelInfo.line - startInfo.line);
        }
    }

    public String getInfo() {
        return this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vlogdt.templates.contextType.member";
    }

    public int getLabelStartOffset() {
        return super.getStartOffset() + this.relativeOffsetToLabel;
    }

    public int getLabelStartLine() {
        return super.getStartLine() + this.relativeLineToLabel;
    }
}

