/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IResultImplicitVariable;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;

public class RfResultImplicitVariable
extends RfField
implements IResultImplicitVariable {
    private static final long serialVersionUID = 2L;

    public RfResultImplicitVariable(RfFunction function) {
        super(function.getName(), function.isEscaped(), function.getDataType(), 4, 131072, null);
        this.setEnclosingScope(function);
    }

    public RfResultImplicitVariable(RfResultImplicitVariable field) {
        super(field);
    }

    @Override
    public boolean isPredefined() {
        if (this.getEnclosingScope().isPredefined()) {
            return true;
        }
        return super.isPredefined();
    }

    @Override
    public String getComment() {
        return "PREDEFINED: The result variable which returns a value of the method's return type";
    }

    public SearchMatchKindsWrapper computeEquals(Object obj) {
        if (super.checkEquals(obj)) {
            return SearchMatchKindsWrapper.getStrictMatch();
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        if (obj instanceof RfFunction && enclosing instanceof RfFunction) {
            RfFunction otherFunction = (RfFunction)obj;
            RfFunction currFunction = (RfFunction)enclosing;
            if (!this.getName().equals(otherFunction.getName())) {
                return SearchMatchKindsWrapper.getNoMatch();
            }
            if (otherFunction.isTask() && !currFunction.isTask() || !otherFunction.isTask() && currFunction.isTask()) {
                return SearchMatchKindsWrapper.getNoMatch();
            }
            if (otherFunction == currFunction) {
                return SearchMatchKindsWrapper.getStrictMatch();
            }
            if (!otherFunction.isVirtual() || !currFunction.isVirtual()) {
                return SearchMatchKindsWrapper.getNoMatch();
            }
            LinkedHashSet<RfClass> classFamily = this.computeClassFamily(currFunction, currFunction.getEnclosingScope());
            if (classFamily.contains(otherFunction.getEnclosingScope())) {
                RfNamedElement currScope = otherFunction.getEnclosingScope();
                RfNamedElement rfScope = currFunction.getEnclosingScope();
                if (!(currScope instanceof RfClass) || !(rfScope instanceof RfClass)) {
                    return SearchMatchKindsWrapper.getNoMatch();
                }
                RfClass currClass = (RfClass)currScope;
                RfClass rfClass = (RfClass)rfScope;
                if (currClass.equals(rfClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.STRICT);
                }
                if (rfClass.isChildOfClassOrInterface(currClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.CHILDREN);
                }
                if (currClass.isChildOfClassOrInterface(rfClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.OVERRIDDEN);
                }
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.FULL);
            }
        }
        if (obj instanceof RfResultImplicitVariable) {
            RfResultImplicitVariable variable = (RfResultImplicitVariable)obj;
            if (!this.getName().equals(variable.getName())) {
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.NO_MATCH);
            }
            RfNamedElement enclosingVar = variable.getEnclosingScope();
            if (enclosing == enclosingVar) {
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.STRICT);
            }
            if (!(enclosing instanceof RfFunction) || !(enclosingVar instanceof RfFunction)) {
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.NO_MATCH);
            }
            RfFunction currFunction = (RfFunction)enclosing;
            RfFunction varFunction = (RfFunction)enclosingVar;
            if (!currFunction.isVirtual() || !varFunction.isVirtual()) {
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.NO_MATCH);
            }
            LinkedHashSet<RfClass> classFamily = this.computeClassFamily(currFunction, currFunction.getEnclosingScope());
            if (classFamily.contains(varFunction.getEnclosingScope())) {
                RfNamedElement currScope = currFunction.getEnclosingScope();
                RfNamedElement rfScope = varFunction.getEnclosingScope();
                if (!(currScope instanceof RfClass) || !(rfScope instanceof RfClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.NO_MATCH);
                }
                RfClass currClass = (RfClass)currScope;
                RfClass rfClass = (RfClass)rfScope;
                if (currClass.equals(rfClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.STRICT);
                }
                if (rfClass.isChildOfClassOrInterface(currClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.OVERRIDDEN);
                }
                if (currClass.isChildOfClassOrInterface(rfClass)) {
                    return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.CHILDREN);
                }
                return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.FULL);
            }
        }
        return new SearchMatchKindsWrapper(RfFunction.FunctionCallKind.NO_MATCH);
    }

    @Override
    public boolean checkEquals(Object obj) {
        return this.computeEquals(obj).isMatch();
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        return ((RfFunction)this.getEnclosingScope()).getAssociatedType(typesResolver);
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement function = this.getEnclosingScope();
        if (function == null) {
            return true;
        }
        return function.hasNoDefs(rawDefs);
    }

    @Override
    public boolean isDirtyElement() {
        return this.hasNoDefs(true);
    }

    private LinkedHashSet<RfClass> computeClassFamily(RfFunction function, IRfScopeElement enclosing) {
        RfClass rfClass;
        LinkedHashSet<RfClass> result = new LinkedHashSet<RfClass>();
        if (!(enclosing instanceof RfClass)) {
            return result;
        }
        RfClass firstParent = rfClass = ((RfClass)enclosing).getGenericClass();
        RfClass candidateParent = rfClass;
        Set<RfClass> visited = Collections.newSetFromMap(new IdentityHashMap());
        while ((candidateParent = candidateParent.getParent()) != null) {
            RfClass genericClass = candidateParent.getGenericClass();
            if (visited.contains(genericClass)) break;
            visited.add(genericClass);
            RfFunction candidateFunction = null;
            candidateFunction = function.isTask() ? candidateParent.getLocalTask(function.getName()) : candidateParent.getLocalFunction(function.getName());
            if (candidateFunction == null) continue;
            firstParent = candidateParent;
        }
        visited.clear();
        result.add(firstParent.getGenericClass());
        this.getParentInterfacesRecursive(visited, result, firstParent);
        this.getChildrenRecursive(visited, result, firstParent);
        return result;
    }

    private void getParentInterfacesRecursive(Set<RfClass> visited, LinkedHashSet<RfClass> result, RfClass clazz) {
        RfClass parent2;
        List<RfClass> parents = clazz.getParentInterfaces();
        if (parents == null || parents.isEmpty()) {
            return;
        }
        for (RfClass parent2 : parents) {
            RfClass genericClass = parent2.getGenericClass();
            if (visited.contains(genericClass)) continue;
            visited.add(genericClass);
            result.add(genericClass);
            this.getParentInterfacesRecursive(visited, result, parent2);
            this.getChildrenRecursive(visited, result, genericClass);
        }
        parent2 = clazz.getParent();
        while (parent2 != null) {
            RfClass genericClass = parent2.getGenericClass();
            if (visited.contains(genericClass)) {
                return;
            }
            visited.add(genericClass);
            result.add(genericClass);
            this.getParentInterfacesRecursive(visited, result, genericClass);
            this.getChildrenRecursive(visited, result, genericClass);
        }
    }

    private void getChildrenRecursive(Set<RfClass> visited, LinkedHashSet<RfClass> result, RfClass clazz) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            RfClass genericClass = child.getGenericClass();
            if (visited.contains(genericClass)) continue;
            visited.add(genericClass);
            result.add(genericClass);
            this.getParentInterfacesRecursive(visited, result, genericClass);
            this.getChildrenRecursive(visited, result, genericClass);
        }
    }

    public boolean isFunctionResultImplicit() {
        return true;
    }

    public IRfNamedElement xGetFastAssocType() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        return enclosingScope.xGetFastAssocType();
    }
}

