/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.fast.BaseLinkedHSet;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.vlogdt.model.reflection.IRfSpecializedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfSpecializedClass
extends RfClass
implements IRfSpecializedType {
    private static final long serialVersionUID = 1L;
    private RfClass genericClass;
    private ElementPath hierarchyPath;
    private ELParamValues elabConstantValues;
    private boolean isComplete;
    private boolean hasCachedSpecializedHashCode;
    private int cachedSpecializedHashCode;
    private BaseLinkedHSet<RfNamedElement> specializedOccurrences;

    public RfSpecializedClass(RfClass genericClass, ElementPath hierarchyPath, RfNamedElement specializedEnclosing, boolean hasDesignEnclosing) {
        super(genericClass);
        this.fMembers = new DVTLinkedHashMap();
        this.elabConstantValues = ELParamValues.create((boolean)true);
        if (hasDesignEnclosing) {
            this.hierarchyPath = hierarchyPath;
            this.isComplete = hierarchyPath != null;
        } else {
            this.hierarchyPath = null;
            this.isComplete = !(specializedEnclosing instanceof IRfTypeElement) || ((IRfTypeElement)specializedEnclosing).isComplete();
        }
        this.setEnclosingScope(specializedEnclosing);
    }

    public void initMembers() {
        this.fMembers = this.genericClass.fMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initParents(RfNamedElement sourceElement, RfTypesResolver typesResolver) {
        RfProject rfProject = this.getRfProject();
        RfClass rfClass = this.genericClass;
        synchronized (rfClass) {
            try {
                if (this.hasCompleteParent() && this.hasCompleteImplements()) {
                    return;
                }
                this.resolveClassParent(rfProject, sourceElement, null, null, typesResolver, true);
            }
            finally {
                this.checkNotImplementedPureFunctions(rfProject);
            }
        }
    }

    @Override
    public RfDefElement getDeclaration() {
        return this.genericClass.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return this.genericClass.getDeclarations();
    }

    public synchronized RfDefElement getLastExistingSpecializedOccurrenceDeclaration() {
        if (this.specializedOccurrences == null || this.specializedOccurrences.isEmpty()) {
            return null;
        }
        Iterator iterator = this.specializedOccurrences.entrySet().iterator();
        RfDefElement result = null;
        do {
            RfDefElement specializedOccurrenceDeclarartion;
            if ((specializedOccurrenceDeclarartion = ((RfNamedElement)((Map.Entry)iterator.next()).getValue()).getDeclaration()) == null) {
                iterator.remove();
            }
            result = specializedOccurrenceDeclarartion;
        } while (iterator.hasNext());
        return result;
    }

    @Override
    protected RfNamedElement getCircularInheritanceUsage() {
        return this.getLastSpecializedClassOccurrence();
    }

    public RfClass getGenericElement() {
        return this.genericClass;
    }

    @Override
    public RfClass getGenericClass() {
        return this.genericClass;
    }

    @Override
    public Class<? extends RfNamedElement> getCustomClass() {
        return this.genericClass.getClass();
    }

    public RfNamedElement getLastSpecializedClassOccurrence() {
        return this.specializedOccurrences == null ? null : (RfNamedElement)this.specializedOccurrences.getLastValue();
    }

    public ElementPath getHierarchyPath() {
        return this.hierarchyPath;
    }

    @Override
    public boolean isDirtyElement() {
        return this.genericClass.isDirtyElement();
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.genericClass.hasNoDefs(rawDefs);
    }

    @Override
    public boolean hasLocalMembers() {
        return super.hasLocalMembers() || this.getGenericElement().hasLocalMembers();
    }

    public Map<String, IELParamValue> getLocalElabConstantValues() {
        return this.elabConstantValues.getEntries();
    }

    public IELParamValue getLocalElabConstantValue(String name) {
        return this.elabConstantValues.getValueDirectly(name);
    }

    @Override
    public int getPortListParametersCount() {
        return this.genericClass.getPortListParametersCount();
    }

    @Override
    public List<RfField> getPortListParameters() {
        return this.genericClass.getPortListParameters();
    }

    @Override
    public List<RfField> getLocalParameters() {
        return this.genericClass.getLocalParameters();
    }

    @Override
    public List<RfField> getLocalElabConstants() {
        return this.genericClass.getLocalElabConstants();
    }

    @Override
    public Map<String, IHidObject> getElabConstantDefaultExpressions() {
        return this.genericClass.getElabConstantDefaultExpressions();
    }

    @Override
    protected void setGenericClass(RfClass genericClass) {
        this.genericClass = genericClass;
    }

    @Override
    public void addElabConstantValue(RfField elabConstant, IELParamValue elabConstantValue) {
        IRfNamedElement valueElement;
        if (this.fMembers != this.genericClass.fMembers) {
            this.fMembers.put(null, (IDVTMapElement)elabConstant);
        }
        this.addElabConstantValueDirectly(elabConstant, elabConstantValue);
        this.isComplete &= elabConstantValue instanceof ELParamValues.ParamValueNumber || elabConstantValue instanceof ELParamValues.ParamValueType && elabConstantValue.getNamedElement() != CIRCULAR_ASSIGN_OR_INSTANCE && (!(elabConstantValue.getNamedElement() instanceof IRfTypeElement) || ((IRfTypeElement)elabConstantValue.getNamedElement()).isComplete());
        if (elabConstant.isTypeParameter() && (valueElement = elabConstantValue.getNamedElement()) != null && !(valueElement instanceof IRfFieldElement) && !(valueElement instanceof RfListType) && !valueElement.isPredefined()) {
            RfClass genericClass = this.getGenericClass();
            String valueName = valueElement.getName();
            genericClass.addReference(valueName);
            genericClass.addReferenceToIdentifierName(valueName);
        }
    }

    @Override
    public Set<RfClass> getChildren() {
        return this.isComplete ? super.getChildren() : this.genericClass.getChildren();
    }

    @Override
    public void addElabConstantValueDirectly(RfField elabConstant, IELParamValue value) {
        this.hasCachedSpecializedHashCode &= this.elabConstantValues.put(elabConstant.getName(), value) == null;
    }

    public synchronized void addSpecializedOccurrence(RfNamedElement specializedOccurrence) {
        if (this.specializedOccurrences == null) {
            this.specializedOccurrences = new BaseLinkedHSet<RfNamedElement>(4){
                private static final long serialVersionUID = 1L;

                public int hash(Object key) {
                    return System.identityHashCode(key);
                }
            };
        }
        if (this.specializedOccurrences.putIfAbsent((Object)specializedOccurrence, (Object)specializedOccurrence) != null) {
            this.specializedOccurrences.remove((Object)specializedOccurrence);
            this.specializedOccurrences.put((Object)specializedOccurrence, (Object)specializedOccurrence);
        }
    }

    @Override
    protected RfSpecializedClass addSpecialization(RfSpecializedClass specialization) {
        return null;
    }

    @Override
    public boolean shouldBeSpecialized() {
        return false;
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        if (previous != null && IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
            return;
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options)) {
            if (this.hierarchyPath != null) {
                result.append(this.hierarchyPath).append('.');
            } else {
                RfNamedElement enclosingScope = this.getEnclosingScope();
                if (enclosingScope != null && !(enclosingScope instanceof RfProject)) {
                    enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
                }
            }
        }
        result.append(this.getName());
        if (IRfNamedElement.QualifiedNameOptions.contains((int)4, (int)options)) {
            this.getCompleteNamesForPortListParams(result, this.elabConstantValues, typesResolver, scope, IRfNamedElement.QualifiedNameOptions.remove((int)512, (int)options));
        }
        if (previous != null) {
            result.append(previous.isObjectStatic() ? "::" : ".");
        }
    }

    @Override
    public RfClass getDefaultSpecialization(ElementPath hierarchyPath) {
        return this;
    }

    private boolean equalsSpecialized(RfSpecializedClass other) {
        if (this.hasCachedSpecializedHashCode & other.hasCachedSpecializedHashCode & (this.hasCachedSpecializedHashCode ^ other.hasCachedSpecializedHashCode)) {
            return false;
        }
        if (!Objects.equals(this.hierarchyPath, other.hierarchyPath)) {
            return false;
        }
        int portListParametersCount = this.getPortListParametersCount();
        if (portListParametersCount != other.getPortListParametersCount() || portListParametersCount == 0) {
            return true;
        }
        Iterator thisIt = this.elabConstantValues.getEntriesIterator();
        Iterator otherIt = other.elabConstantValues.getEntriesIterator();
        while (portListParametersCount-- > 0 && thisIt.hasNext() && otherIt.hasNext()) {
            Map.Entry thisNext = (Map.Entry)thisIt.next();
            Map.Entry otherNext = (Map.Entry)otherIt.next();
            if (!((String)thisNext.getKey()).equals(otherNext.getKey())) {
                return false;
            }
            if (IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)thisNext.getValue()).equals(IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)otherNext.getValue()))) continue;
            return false;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        RfNamedElement otherEnclosingScope = other.getEnclosingScope();
        if (enclosingScope.getClass() != otherEnclosingScope.getClass()) {
            return false;
        }
        return enclosingScope.getClass() != RfSpecializedClass.class || ((RfSpecializedClass)enclosingScope).equalsSpecialized((RfSpecializedClass)otherEnclosingScope);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.equalsSpecialized((RfSpecializedClass)obj);
    }

    public int hashCodeSpecialized() {
        if (this.hasCachedSpecializedHashCode) {
            return this.cachedSpecializedHashCode;
        }
        int portListParametersCount = this.getPortListParametersCount();
        Iterator parameterIterator = this.elabConstantValues.getEntriesIterator();
        int result = 1;
        int portListParameterIdx = 0;
        while (portListParameterIdx < portListParametersCount && parameterIterator.hasNext()) {
            result = 31 * result + IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)((Map.Entry)parameterIterator.next()).getValue()).hashCode();
            ++portListParameterIdx;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfSpecializedClass) {
            result = 31 * result + ((RfSpecializedClass)enclosingScope).hashCodeSpecialized();
        } else if (this.hierarchyPath != null) {
            result = 31 * result + this.hierarchyPath.hashCode();
        }
        this.cachedSpecializedHashCode = result;
        this.hasCachedSpecializedHashCode = portListParametersCount == this.elabConstantValues.size();
        return result;
    }

    @Override
    public int hashCode() {
        return 31 * this.hashCodeSpecialized() + super.hashCode();
    }

    @Override
    public String toString() {
        return this.getQualifiedName(5);
    }

    public ELParamValues xGetLocalElabConstantValues() {
        return this.elabConstantValues;
    }
}

