/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.model.reflection.IRfSpecializedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfSpecializedVirtualInterface
extends RfInterface
implements IRfSpecializedType {
    private static final long serialVersionUID = 1L;
    private RfInterface genericInterface;
    private ElementPath hierarchyPath;
    private ELParamValues elabConstantValues;
    private boolean isComplete;
    private boolean hasCachedSpecializedHashCode;
    private int cachedSpecializedHashCode;

    public RfSpecializedVirtualInterface(RfInterface genericInterface, ElementPath hierarchyPath) {
        super(genericInterface.getName(), genericInterface.isEscaped(), genericInterface.getDefaultNetType(null), genericInterface.getTimescale(null));
        this.fMembers = genericInterface.fMembers;
        this.genericInterface = genericInterface;
        this.elabConstantValues = ELParamValues.create((boolean)true);
        this.hierarchyPath = hierarchyPath;
        this.isComplete = true;
        this.setEnclosingScope(genericInterface.getEnclosingScope());
        this.setParamNames(genericInterface.getParamNames());
        this.setTypeParamNames(genericInterface.getTypeParamNames());
        this.setEnumNames(genericInterface.getEnumNames());
        this.setActionBlockNames(genericInterface.getActionBlockNames());
        this.setHidHolder(genericInterface.getHidHolder());
        this.setMacroZone(genericInterface.getMacroZone());
        this.internalSetImportsExports(genericInterface.fImportsExports);
    }

    public RfInterface getGenericElement() {
        return this.genericInterface;
    }

    public ElementPath getHierarchyPath() {
        return this.hierarchyPath;
    }

    @Override
    public void addElabConstantValue(RfField elabConstant, IELParamValue elabConstantValue) {
        IRfNamedElement valueElement;
        this.hasCachedSpecializedHashCode &= this.elabConstantValues.put(elabConstant.getName(), elabConstantValue) == null;
        this.isComplete &= elabConstantValue instanceof ELParamValues.ParamValueNumber || elabConstantValue instanceof ELParamValues.ParamValueType && (!(elabConstantValue.getNamedElement() instanceof IRfTypeElement) || ((IRfTypeElement)elabConstantValue.getNamedElement()).isComplete());
        if (elabConstant.isTypeParameter() && (valueElement = elabConstantValue.getNamedElement()) != null && !(valueElement instanceof IRfFieldElement) && !(valueElement instanceof RfListType) && !valueElement.isPredefined()) {
            RfInterface genericInterface = this.getGenericElement();
            String valueName = valueElement.getName();
            genericInterface.addReference(valueName);
            genericInterface.addReferenceToIdentifierName(valueName);
        }
    }

    @Override
    public RfDefElement getDeclaration() {
        return this.genericInterface.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return this.genericInterface.getDeclarations();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean isDirtyElement() {
        return this.genericInterface.isDirtyElement();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.genericInterface.hasNoDefs(rawDefs);
    }

    @Override
    public boolean hasLocalMembers() {
        return super.hasLocalMembers() || this.getGenericElement().hasLocalMembers();
    }

    public Map<String, IELParamValue> getLocalElabConstantValues() {
        return this.elabConstantValues.getEntries();
    }

    public IELParamValue getLocalElabConstantValue(String name) {
        return this.elabConstantValues.getValueDirectly(name);
    }

    @Override
    public int getPortListParametersCount() {
        return this.genericInterface.getPortListParametersCount();
    }

    @Override
    public List<RfField> getPortListParameters() {
        return this.genericInterface.getPortListParameters();
    }

    public int getBitSize() {
        return -1;
    }

    @Override
    public List<RfField> getLocalParameters() {
        return this.genericInterface.getLocalParameters();
    }

    @Override
    public List<RfField> getLocalElabConstants() {
        return this.genericInterface.getLocalElabConstants();
    }

    @Override
    public Map<String, IHidObject> getElabConstantDefaultExpressions() {
        return this.genericInterface.getElabConstantDefaultExpressions();
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        if (previous != null && IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options) && DVTRfUtils.findScope((IRfScopeElement)scope, (IRfNamedElement)this, (boolean)false) != null) {
            return;
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options)) {
            if (this.hierarchyPath != null) {
                result.append(this.hierarchyPath).append('.');
            } else {
                RfNamedElement enclosingScope = this.getEnclosingScope();
                if (enclosingScope != null && !(enclosingScope instanceof RfProject)) {
                    enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
                }
            }
        }
        result.append(this.getName());
        if (IRfNamedElement.QualifiedNameOptions.contains((int)4, (int)options)) {
            this.getCompleteNamesForPortListParams(result, this.elabConstantValues, typesResolver, scope, IRfNamedElement.QualifiedNameOptions.remove((int)512, (int)options));
        }
        if (previous != null) {
            result.append('.');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RfSpecializedVirtualInterface)) {
            return false;
        }
        RfSpecializedVirtualInterface other = (RfSpecializedVirtualInterface)obj;
        if (this.hasCachedSpecializedHashCode & other.hasCachedSpecializedHashCode & (this.hasCachedSpecializedHashCode ^ other.hasCachedSpecializedHashCode)) {
            return false;
        }
        if (!Objects.equals(this.hierarchyPath, other.hierarchyPath)) {
            return false;
        }
        int portListParametersCount = this.getPortListParametersCount();
        if (portListParametersCount != other.getPortListParametersCount() || portListParametersCount == 0) {
            return true;
        }
        Iterator thisIt = this.elabConstantValues.getEntriesIterator();
        Iterator otherIt = other.elabConstantValues.getEntriesIterator();
        while (portListParametersCount-- > 0 && thisIt.hasNext() && otherIt.hasNext()) {
            Map.Entry thisNext = (Map.Entry)thisIt.next();
            Map.Entry otherNext = (Map.Entry)otherIt.next();
            if (!((String)thisNext.getKey()).equals(otherNext.getKey())) {
                return false;
            }
            if (IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)thisNext.getValue()).equals(IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)otherNext.getValue()))) continue;
            return false;
        }
        return true;
    }

    public int hashCodeSpecialized() {
        if (this.hasCachedSpecializedHashCode) {
            return this.cachedSpecializedHashCode;
        }
        int portListParametersCount = this.getPortListParametersCount();
        Iterator parameterIterator = this.elabConstantValues.getEntriesIterator();
        int result = 1;
        int portListParameterIdx = 0;
        while (portListParameterIdx < portListParametersCount && parameterIterator.hasNext()) {
            result = 31 * result + IRfSpecializedType.getObjectForSpecializedOperations((IELParamValue)((Map.Entry)parameterIterator.next()).getValue()).hashCode();
            ++portListParameterIdx;
        }
        if (this.hierarchyPath != null) {
            result = 31 * result + this.hierarchyPath.hashCode();
        }
        this.cachedSpecializedHashCode = result;
        this.hasCachedSpecializedHashCode = portListParametersCount == this.elabConstantValues.size();
        return result;
    }

    @Override
    public int hashCode() {
        return 31 * this.hashCodeSpecialized() + super.hashCode();
    }

    @Override
    public String toString() {
        return this.getQualifiedName(5);
    }

    public boolean xIsVirtual() {
        return true;
    }

    @Override
    public boolean xIsStaticValueHolder(XValueHolderFactory factory) {
        return false;
    }
}

