/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.optimized.collections.fast.BaseLinkedHSet;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector__structMemberInfo;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IElementValidator;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

public class RfStruct
extends RfMembersHolder
implements IRfCompositeTypeElement,
IRfEnumElement,
IBitFieldRegister {
    private static final long serialVersionUID = 2L;
    protected boolean isPacked;
    protected byte isDefinedInParameterPortListValue;
    protected byte sign;
    protected String aliasName;
    protected DataType enumBaseDataType;
    protected transient IRfTypeElement enumBaseType;
    private transient Map<RfComputedStruct, RfComputedStruct> computedStructsCache;

    public RfStruct(String name, RfNamedElement enclosingScope, int sign, boolean isPacked, boolean escaped) {
        super(name, escaped);
        this.isPacked = isPacked || this.isEnum();
        this.isDefinedInParameterPortListValue = (byte)-1;
        this.sign = (byte)(isPacked & sign == 0 ? 2 : sign);
        this.setEnclosingScope(enclosingScope);
        if (name.startsWith("enum/")) {
            this.addMember(new RfPredefinedFunction("first", RfProject.getSimpleDataType("enum/"), null, 0, true, "Returns the value of the first member of the enumeration", 0));
            this.addMember(new RfPredefinedFunction("last", RfProject.getSimpleDataType("enum/"), null, 0, true, "Returns the value of the last member of the enumeration", 0));
            this.addMember(new RfPredefinedFunction("next", RfProject.getSimpleDataType("enum/"), Arrays.asList(new ArgInfo("N", new DataType("int"), "1", null)), 0, true, "Returns the Nth next enumeration value (default is the next one) starting from the current value of the given variable", 0));
            this.addMember(new RfPredefinedFunction("prev", RfProject.getSimpleDataType("enum/"), Arrays.asList(new ArgInfo("N", new DataType("int"), "1", null)), 0, true, "Returns the Nth previous enumeration value (default is the previous one) starting from the current value of the given variable", 0));
            this.addMember(new RfPredefinedFunction("num", RfProject.getSimpleDataType("int"), null, 0, "Returns the number of elements in the given enumeration"));
            this.addMember(new RfPredefinedFunction("name", RfProject.getSimpleDataType("string"), null, 0, "Returns the string representation of the given enumeration value"));
        }
    }

    public RfStruct(RfStruct other, RfNamedElement enclosingScope) {
        super(other.getName(), other.isEscaped());
        this.isPacked = other.isPacked;
        this.sign = other.sign;
        this.enumBaseDataType = other.enumBaseDataType;
        this.aliasName = other.aliasName;
        this.setEnclosingScope(enclosingScope);
        this.internalSetMembers((DVTLinkedHashMap<String, RfNamedElement>)other.fMembers);
        this.internalSetHidHolder(other.getHidHolder());
        this.internalSetNamesCache(other.internalGetNamesCache());
    }

    public void initStructUnion(boolean isPacked, int sign) {
        this.isPacked = isPacked || this.isEnum();
        this.sign = (byte)(sign | (isPacked & sign == 0 ? 2 : sign));
    }

    public void initEnum(DataType baseDataType) {
        this.isPacked = true;
        if (baseDataType == null) {
            this.enumBaseDataType = new DataType("int");
            this.enumBaseType = RfBitVectorScalarType.INT;
            this.sign = this.enumBaseType.getSign();
        } else {
            this.enumBaseDataType = baseDataType;
            this.enumBaseType = null;
            this.sign = 0;
        }
    }

    @Override
    protected void internalOnReadObject() {
        if (this.isEnum()) {
            this.initEnum(this.enumBaseDataType);
        } else {
            this.initStructUnion(this.isPacked, this.sign);
        }
    }

    public RfStruct getOriginal() {
        return this;
    }

    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        RfStruct computedStruct = RfTypesResolver.create(evaluator, this, guardian.getHierarchyPath(), 0, true).computeStruct(this, new ParametricDependency(1));
        return computedStruct != null && computedStruct != this && computedStruct.isComplete() ? computedStruct.getBitVectorContext(evaluator, guardian, origin) : null;
    }

    public boolean isDefinedInParameterPortList() {
        List<RfField> portListParameters;
        if (this.isDefinedInParameterPortListValue > -1) {
            return this.isDefinedInParameterPortListValue != 0;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfClass && (portListParameters = ((RfClass)enclosingScope).getPortListParameters()) != null && !portListParameters.isEmpty()) {
            int parameterPortListStartOffset = portListParameters.get(0).getDeclaration().getStartOffset();
            int parameterPortListEndOffset = portListParameters.get(portListParameters.size() - 1).getDeclaration().getEndOffset();
            int startOffset = this.getDeclaration().getStartOffset();
            boolean isDefinedInParameterPortList = parameterPortListStartOffset < startOffset && parameterPortListEndOffset > startOffset;
            this.isDefinedInParameterPortListValue = (byte)(isDefinedInParameterPortList ? 1 : 0);
            return isDefinedInParameterPortList;
        }
        this.isDefinedInParameterPortListValue = 0;
        return false;
    }

    public boolean isComplete() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        while (enclosingScope instanceof RfActionBlock || enclosingScope instanceof RfFunction) {
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        if (enclosingScope instanceof IRfTypeElement) {
            return ((IRfTypeElement)enclosingScope).isComplete();
        }
        return !(enclosingScope instanceof IRfDesignElement) || enclosingScope instanceof IRfLibraryElement;
    }

    public byte getSign() {
        if (this.isPacked) {
            this.internalInit();
        }
        return this.sign;
    }

    public IRfListType getSimpleBitVectorType() {
        if (!this.isPacked) {
            return null;
        }
        if (!this.isEnum()) {
            return RfComputedListType.of(this.getBitState() == 1 ? RfBitVectorScalarType.BIT : RfBitVectorScalarType.LOGIC, this.getBitSize(), this.getSign());
        }
        this.internalInit();
        return this.enumBaseType != null ? this.enumBaseType.getSimpleBitVectorType() : null;
    }

    protected final void internalInit() {
        this.internalInit(null, this);
    }

    protected void internalInit(IHidEvaluator evaluator, IRfNamedElement origin) {
        if (this.isEnum()) {
            if (this.enumBaseDataType == null) {
                this.initEnum(null);
            }
            ParametricDependency parametricDependency = new ParametricDependency(1);
            RfTypesResolver typesResolver = evaluator == null ? RfTypesResolver.create(this, null, this.getRfProject().getNonELManager(), 8) : RfTypesResolver.create(evaluator, origin, null, 8, true);
            IRfNamedElement enumBaseTypeCandidate = typesResolver.computeAssociatedType(new RfAssociatedTypeWrapper(this.enumBaseDataType, this.getEnclosingScope()), parametricDependency, this, null, null, true, false, false);
            if (!(enumBaseTypeCandidate instanceof IRfTypeElement) || enumBaseTypeCandidate instanceof RfStruct && ((RfStruct)enumBaseTypeCandidate).isEnum()) {
                return;
            }
            this.enumBaseDataType.updateParametricDependencyValue(parametricDependency.value);
            this.enumBaseType = (IRfTypeElement)enumBaseTypeCandidate;
            this.sign = this.enumBaseType.getSign();
        }
    }

    public IRfNamedElement getEnumBaseType() {
        if (this.enumBaseType == null) {
            this.internalInit();
        }
        return this.enumBaseType;
    }

    public boolean isEnum() {
        return this.getName().startsWith("enum/");
    }

    public boolean isUnion() {
        return this.getName().startsWith("union/");
    }

    public boolean isStruct() {
        return this.getName().startsWith("struct/");
    }

    public boolean isPacked() {
        return this.isPacked;
    }

    public boolean isBitStream() {
        if (this.isPackedBitStream()) {
            return true;
        }
        return this.isBitStream(new HashSet<IRfNamedElement>());
    }

    public boolean isPackedBitStream() {
        return this.isEnum() || this.isPacked();
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public int getMemberSelect() {
        return this.isEnum() ? 7 : 6;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public DataType getEnumBaseDataType() {
        return this.enumBaseDataType;
    }

    @Override
    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (this.aliasName != null) {
            result.append(this.aliasName).append(".");
        } else if (this.getName().startsWith("enum/")) {
            result.append("enum.");
        } else if (this.getName().startsWith("struct/")) {
            result.append("struct.");
        } else if (this.getName().startsWith("union/")) {
            result.append("union.");
        }
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        String name = this.getName();
        int indexOf = name.indexOf(47);
        if (indexOf > 0) {
            name = name.substring(indexOf + 1);
        }
        return "struct " + name;
    }

    @Override
    protected <T extends IRfNamedElement, Z extends IRfNamedElement> void internalGetMembersWithPrefix(Set<IRfNamedElement> visited, Map<String, Z> result, Class<T> localMembersKind, int localMembersSelect, IElementValidator validator, boolean first, int matchType, String prefix, int kind, int local, IRfNamedElement.AccessModifier accessModifier, boolean imported) {
        if (localMembersSelect == 8) {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, 9, validator, first, matchType, prefix, -1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE, false);
        } else {
            super.internalGetMembersWithPrefix(visited, result, localMembersKind, localMembersSelect, validator, first, matchType, prefix, kind, local, accessModifier, imported);
        }
    }

    public boolean typesAreScalar() {
        List<RfField> localFields = this.getLocalMembers(RfField.class);
        if (localFields != null) {
            for (RfField field : localFields) {
                if (field.typeIsScalar()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<RfFunction> getTasksWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfStruct> getEnumTypesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getEnumTypeWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    public String getParticularType() {
        if (this.getName().startsWith("union/")) {
            return "union/".substring(0, "union/".length() - 1);
        }
        if (this.getName().startsWith("enum/")) {
            return "enum/".substring(0, "enum/".length() - 1);
        }
        return "struct/".substring(0, "struct/".length() - 1);
    }

    public Collection<IRfNamedElement> getEnumValues() {
        if (!this.isEnum()) {
            return null;
        }
        List<RfField> enumElements = this.getEnumElementsWithPrefix("", 2, 1);
        if (enumElements == null || enumElements.isEmpty()) {
            return null;
        }
        return new ArrayList<IRfNamedElement>(enumElements);
    }

    @Override
    public RfDefElement getDeclaration() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclaration();
        }
        return super.getDeclaration();
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        RfNamedElement genericElement;
        if (this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.getDeclarations();
        }
        return super.getDeclarations();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement genericElement;
        if (!rawDefs && this.isMemberOfSpecializedElement() && (genericElement = this.getElementInGenericScope()) != null && genericElement != this) {
            return genericElement.hasNoDefs(rawDefs);
        }
        return super.hasNoDefs(rawDefs);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.enumBaseDataType = null;
        this.enumBaseType = null;
        this.sign = 0;
        if (this.computedStructsCache != null) {
            this.computedStructsCache.clear();
        }
        this.computedStructsCache = null;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
        this.enumBaseDataType = null;
        this.enumBaseType = null;
        this.sign = 0;
        this.computedStructsCache = null;
    }

    public RfForwardTypedef getTypedefDeclaration() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        RfForwardTypedef typedef = enclosingScope.getFirstLocalMember(RfForwardTypedef.class, this.getName());
        if (typedef == null) {
            return null;
        }
        if (typedef.getDeclarationIndex() < this.getDeclarationIndex()) {
            return typedef;
        }
        if (typedef.getDeclarationIndex() == this.getDeclarationIndex()) {
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null) {
                return null;
            }
            RfDefElement declaration2 = typedef.getDeclaration();
            if (declaration2 == null) {
                return null;
            }
            if (declaration2.getStartOffset() < declaration.getStartOffset()) {
                return typedef;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RfComputedStruct cacheComputed(RfComputedStruct computedStruct) {
        if (this.isPredefined()) {
            return computedStruct;
        }
        RfStruct rfStruct = this;
        synchronized (rfStruct) {
            RfComputedStruct cachedComputedStruct;
            if (this.computedStructsCache == null) {
                this.computedStructsCache = new BaseLinkedHSet<RfComputedStruct>(16){
                    private static final long serialVersionUID = 1L;

                    public int hash(Object key) {
                        if (key == null) {
                            return 0;
                        }
                        int hash = ((RfComputedStruct)key).hashCodeComputed();
                        return hash ^ hash >>> 16;
                    }
                };
            }
            RfComputedStruct rfComputedStruct = (cachedComputedStruct = this.computedStructsCache.putIfAbsent(computedStruct, computedStruct)) != null ? cachedComputedStruct : computedStruct;
            return rfComputedStruct;
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RfStruct && this.getName().equals(((RfStruct)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    protected void getQualifiedName(StringBuilder result, RfTypesResolver typesResolver, IRfScopeElement scope, int options, RfNamedElement previous) {
        IRfNamedElement resolverElement;
        RfNamedElement enclosingScope;
        if (previous != null && IRfNamedElement.QualifiedNameOptions.contains((int)32, (int)options)) {
            IRfScopeElement structScope = scope;
            while (structScope instanceof RfStruct) {
                if (this.getName().equals(structScope.getName())) {
                    return;
                }
                structScope = ((RfStruct)structScope).getEnclosingScope();
            }
        }
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = ((resolverElement = typesResolver.getNamedElement()) != null && resolverElement.getName().equals(this.getName()) ? (RfNamedElement)resolverElement : this).getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScope.getQualifiedName(result, typesResolver, scope, options, this);
        }
        if (this.aliasName != null) {
            result.append(this.aliasName);
        } else {
            String name = this.getName();
            result.append(IRfNamedElement.QualifiedNameOptions.contains((int)8, (int)options) ? name : name.substring(0, name.indexOf(47)));
        }
        if (previous != null) {
            result.append(previous.isObjectStatic() ? "::" : ".");
        }
    }

    public int getBitFieldDiagramSize(ElementPath path) {
        ELManager localManager;
        ELParamValuesHidEvaluator evaluator;
        BitVectorContext dataTypeBitVectorContext;
        ELParamValues paramValues;
        if (!this.isPacked || this.isEnum()) {
            return 0;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return 0;
        }
        ELParamValues eLParamValues = paramValues = rfProject.getELManager() != null ? rfProject.getELManager().getMemory().paramValuesFor(path) : null;
        if (paramValues == null) {
            paramValues = ELParamValues.create((boolean)true);
        }
        if ((dataTypeBitVectorContext = this.getBitVectorContext((IHidEvaluator)(evaluator = paramValues.getHidEvaluator(localManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)))), ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, null, (boolean)false, (ELManager)localManager), this)) != null) {
            return dataTypeBitVectorContext.getSize();
        }
        return 0;
    }

    private Set<BitfieldCandidate> collectMembers(BitfieldCandidate parent) {
        if (parent == null || parent.members.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<BitfieldCandidate> result = new HashSet<BitfieldCandidate>();
        int lane = parent.lane + 1;
        int parentLaneIndex = parent.laneIndex;
        for (StructMemberContextInfo member : parent.members) {
            BitfieldCandidate bitfield = new BitfieldCandidate(member, lane > 0 && member.isParentUnion() ? ++lane : lane, member.startingIndex + parentLaneIndex, parent.info != null ? parent.info.name : "");
            result.add(bitfield);
            Set<BitfieldCandidate> collectMembers = this.collectMembers(bitfield);
            result.addAll(collectMembers);
            if ((parent == null || !parent.isUnion) && (parent != null || !this.isUnion())) continue;
            for (BitfieldCandidate c : collectMembers) {
                lane = Math.max(lane, c.lane);
            }
            ++lane;
        }
        return result;
    }

    public Map<Integer, List<BitField>> getBitFields(ElementPath path, int size) {
        ELManager localManager;
        ELParamValuesHidEvaluator evaluator;
        BitVectorContext context;
        ELParamValues paramValues;
        LinkedHashMap<Integer, List<BitField>> lanes = new LinkedHashMap<Integer, List<BitField>>();
        if (!this.isPacked || this.isEnum()) {
            return lanes;
        }
        PriorityQueue<BitfieldCandidate> members = new PriorityQueue<BitfieldCandidate>((b1, b2) -> b1.lane.equals(b2.lane) ? b1.laneIndex.compareTo(b2.laneIndex) : b1.lane.compareTo(b2.lane));
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return lanes;
        }
        ELParamValues eLParamValues = paramValues = rfProject.getELManager() != null ? rfProject.getELManager().getMemory().paramValuesFor(path) : null;
        if (paramValues == null) {
            paramValues = ELParamValues.create((boolean)true);
        }
        if ((context = this.getBitVectorContext((IHidEvaluator)(evaluator = paramValues.getHidEvaluator(localManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)))), ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, null, (boolean)false, (ELManager)localManager), this)) == null) {
            return lanes;
        }
        DVTNumber contextNumber = context.getContextNumber();
        if (!(contextNumber instanceof VlogBitVector__structMemberInfo)) {
            return lanes;
        }
        members.addAll(this.collectMembers(new BitfieldCandidate((VlogBitVector__structMemberInfo)contextNumber, -1, 0)));
        int width = ((VlogBitVector__structMemberInfo)contextNumber).getSize();
        int lane = 0;
        int laneIndex = 0;
        LinkedList<BitField> membersLane = new LinkedList<BitField>();
        while (!members.isEmpty()) {
            BitfieldCandidate member = (BitfieldCandidate)members.poll();
            IRfNamedElement origin = member.info.context.getOrigin();
            String type = "";
            if (origin instanceof RfAssociatedType) {
                type = ((RfAssociatedType)origin).getAssociatedTypeName(this, RfTypesResolver.create(this, paramValues, path, localManager, 6, false), 32, false, true, false);
            } else if (origin instanceof IRfAssociatedType) {
                type = ((IRfAssociatedType)origin).getAssociatedTypeName();
            }
            if ("struct".equals(type) || "union".equals(type)) {
                type = "anonymous";
            }
            if (member.lane != lane) {
                membersLane.add(BitField.BitfieldBuilder.of((int)width, (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(type).build());
                lanes.put(lane++, membersLane);
                membersLane = new LinkedList();
                laneIndex = 0;
            }
            if (member.laneIndex != laneIndex) {
                membersLane.add(BitField.BitfieldBuilder.of((int)(member.laneIndex - laneIndex), (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(type).build());
                laneIndex += member.laneIndex - laneIndex;
            }
            membersLane.add(BitField.BitfieldBuilder.of((int)member.info.context.getSize(), (BitField.Color)member.info.getBitfieldColor()).name(member.info.name).parent(member.parent).position(laneIndex).type(type).build());
            if ((laneIndex += member.info.context.getSize()) < width) {
                BitfieldCandidate next = (BitfieldCandidate)members.peek();
                if ((next == null || next.lane == lane) && !members.isEmpty()) continue;
                membersLane.add(BitField.BitfieldBuilder.of((int)(width - laneIndex), (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(type).build());
            }
            lanes.put(lane++, membersLane);
            membersLane = new LinkedList();
            laneIndex = 0;
        }
        return lanes;
    }

    private Set<BitfieldCandidate> getBitFieldCandidates() {
        ELManager localManager;
        ELParamValuesHidEvaluator evaluator;
        BitVectorContext context;
        ELParamValues paramValues;
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return Collections.emptySet();
        }
        ELParamValues eLParamValues = paramValues = rfProject.getELManager() != null ? rfProject.getELManager().getMemory().paramValuesFor(ElementPath.EMPTY_PATH) : null;
        if (paramValues == null) {
            paramValues = ELParamValues.create((boolean)true);
        }
        if ((context = this.getBitVectorContext((IHidEvaluator)(evaluator = paramValues.getHidEvaluator(localManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)))), ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, null, (boolean)false, (ELManager)localManager), this)) == null) {
            return Collections.emptySet();
        }
        DVTNumber contextNumber = context.getContextNumber();
        if (!(contextNumber instanceof VlogBitVector__structMemberInfo)) {
            return Collections.emptySet();
        }
        return this.collectMembers(new BitfieldCandidate((VlogBitVector__structMemberInfo)contextNumber, -1, 0));
    }

    public List<String> getOrderedBitFieldNames() {
        PriorityQueue<BitfieldCandidate> pq = new PriorityQueue<BitfieldCandidate>((b1, b2) -> b1.lane.equals(b2.lane) ? b1.laneIndex.compareTo(b2.laneIndex) : b1.lane.compareTo(b2.lane));
        Set<BitfieldCandidate> bitFieldCandidates = this.getBitFieldCandidates();
        pq.addAll(bitFieldCandidates);
        final HashMap<String, BitfieldCandidate> nameMap = new HashMap<String, BitfieldCandidate>();
        for (BitfieldCandidate bitField : bitFieldCandidates) {
            nameMap.put(bitField.info.name, bitField);
        }
        final IdentityHashMap fullNameCache = new IdentityHashMap();
        Function<BitfieldCandidate, String> resolveFullName = new Function<BitfieldCandidate, String>(){

            @Override
            public String apply(BitfieldCandidate candidate) {
                return fullNameCache.computeIfAbsent(candidate, mappingFunction -> {
                    if (bitfieldCandidate.parent == null || bitfieldCandidate.parent.isBlank()) {
                        return bitfieldCandidate.info.name;
                    }
                    BitfieldCandidate parent = (BitfieldCandidate)nameMap.get(bitfieldCandidate.parent);
                    if (parent == null) {
                        return bitfieldCandidate.info.name;
                    }
                    return this.apply(parent) + "." + bitfieldCandidate.info.name;
                });
            }
        };
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> alreadyAdded = new HashSet<String>();
        while (!pq.isEmpty()) {
            BitfieldCandidate candidate = (BitfieldCandidate)pq.poll();
            String fullName = (String)resolveFullName.apply(candidate);
            if (alreadyAdded.contains(fullName)) continue;
            alreadyAdded.add(fullName);
            result.add(fullName);
        }
        Collections.reverse(result);
        return result;
    }

    public IBitFieldRegister.BitFieldKind getBitFieldKind() {
        return IBitFieldRegister.BitFieldKind.VLOG_PACKED_STRUCT;
    }

    public String getBitFieldDiagramHeader() {
        return "Bit Fields of packed " + (this.isUnion() ? "union" : "struct");
    }

    public IRfNamedElement xGetComputedElement(IHidEvaluator enclosingOrDescendantScope, boolean isLinterStaticAnalysisMode) {
        if (enclosingOrDescendantScope == null) {
            return this;
        }
        RfTypesResolver resolver = RfTypesResolver.create(enclosingOrDescendantScope, null, null, 0, false);
        return resolver.computeStruct(this, new ParametricDependency(1));
    }

    @Override
    public void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        super.xCollectMemberNames(result, false);
        if (!isAddPredefined || !this.isEnum()) {
            return;
        }
        result.add(DVTStringUtil.intern((String)"first"));
        result.add(DVTStringUtil.intern((String)"last"));
        result.add(DVTStringUtil.intern((String)"next"));
        result.add(DVTStringUtil.intern((String)"prev"));
        result.add(DVTStringUtil.intern((String)"num"));
        result.add(DVTStringUtil.intern((String)"name"));
    }

    private static class BitfieldCandidate {
        StructMemberContextInfo info;
        String parent;
        Integer lane;
        Integer laneIndex;
        List<StructMemberContextInfo> members;
        boolean isUnion;

        public BitfieldCandidate(StructMemberContextInfo info, Integer lane, Integer laneIndex, String parent) {
            this.info = info;
            this.members = new ArrayList<StructMemberContextInfo>(info.getMembers());
            this.isUnion = info.isUnion();
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.parent = parent;
            if (this.isUnion) {
                for (StructMemberContextInfo member : this.members) {
                    member.startingIndex = 0;
                }
            } else {
                int parentSize = info.context.getSize();
                for (StructMemberContextInfo member : this.members) {
                    member.startingIndex = parentSize - member.context.getSize();
                    parentSize -= member.context.getSize();
                }
            }
        }

        public BitfieldCandidate(VlogBitVector__structMemberInfo info, Integer lane, Integer laneIndex) {
            this.members = new ArrayList<StructMemberContextInfo>(info.getMembersInfoOrdered());
            this.isUnion = info.isUnion();
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.parent = "";
            if (this.isUnion) {
                for (StructMemberContextInfo member : this.members) {
                    member.startingIndex = 0;
                }
            } else {
                int parentSize = info.getSize();
                for (StructMemberContextInfo member : this.members) {
                    member.startingIndex = parentSize - member.context.getSize();
                    parentSize -= member.context.getSize();
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.lane, this.laneIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitfieldCandidate other = (BitfieldCandidate)obj;
            return Objects.equals(this.lane, other.lane) && Objects.equals(this.laneIndex, other.laneIndex);
        }
    }
}

