/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfSuperImplicitVariable
extends RfField {
    private static final long serialVersionUID = 1L;
    private static final String SUPER = "super";

    public RfSuperImplicitVariable(RfClass classs) {
        super(SUPER, false, classs.getExtendedType(), 4, 131072, null);
        this.setEnclosingScope(classs);
    }

    @Override
    public String getComment() {
        return "PREDEFINED: The implicit variable 'super' is used from within a derived class to refer to members of the parent class";
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        RfClass parent = ((RfClass)this.getEnclosingScope()).getParent();
        if (parent == null) {
            return null;
        }
        return parent.getGenericClass();
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        if (typesResolver == null) {
            return ((RfClass)this.getEnclosingScope()).getParent();
        }
        RfClass scope = (RfClass)typesResolver.getSpecializedElementScope(this.getEnclosingScope());
        RfField extendedParameter = scope.getExtendedParameter();
        if (extendedParameter != null && !RfTypesResolver.ResolveOptions.contains(2, typesResolver.getOptions()) && scope.shouldBeSpecialized()) {
            return RfTypesResolver.ResolveOptions.contains(8, typesResolver.getOptions()) ? extendedParameter : null;
        }
        RfClass parentScope = scope.getParent();
        typesResolver.update(parentScope, this, false, false);
        return parentScope;
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement parent = this.getEnclosingScope();
        if (parent == null) {
            return true;
        }
        return parent.hasNoDefs(rawDefs);
    }
}

