/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfThisImplicitVariable
extends RfField {
    private static final long serialVersionUID = 1L;
    private static final String THIS = "this";

    public RfThisImplicitVariable(RfClass parent) {
        super(THIS, false, new DataType(parent.getName()), 4, 131072, null);
        this.setEnclosingScope(parent);
    }

    @Override
    public String getComment() {
        return "PREDEFINED: The implicit variable 'this' refers to the current class and can be used anywhere in the class";
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        return this.getEnclosingScope();
    }

    @Override
    public IRfNamedElement getAssociatedType(RfTypesResolver typesResolver) {
        if (typesResolver == null) {
            return this.getEnclosingScope();
        }
        RfNamedElement specializedEnclosingScope = typesResolver.getSpecializedElementScope(this.getEnclosingScope());
        typesResolver.update(specializedEnclosingScope, this, false, false);
        return specializedEnclosingScope;
    }

    @Override
    protected void checkAssociatedType(ConfigInfo configInfo, RfAssociatedType element, boolean translateTypeAlias, boolean ignoreDirty, boolean triggerError) throws BuildCancelException {
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        RfNamedElement parent = this.getEnclosingScope();
        if (parent == null) {
            return true;
        }
        return parent.hasNoDefs(rawDefs);
    }
}

