/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.ParametricDependency;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

public class RfTypeAlias
extends RfAssociatedType
implements IRfTypeAliasElement {
    private static final long serialVersionUID = 1L;
    public static final String DEFINED_LATER = "[defined later]";
    private static final Set<Class<? extends IRfNamedElement>> MEMBERS_TYPE_ALIAS_DOT_PREFIX = new HashSet<Class<? extends IRfNamedElement>>();

    static {
        MEMBERS_TYPE_ALIAS_DOT_PREFIX.add(RfInstance.class);
        MEMBERS_TYPE_ALIAS_DOT_PREFIX.add(RfInstance.RfBindInstance.class);
        MEMBERS_TYPE_ALIAS_DOT_PREFIX.add(RfField.class);
        MEMBERS_TYPE_ALIAS_DOT_PREFIX.add(RfPort.class);
        MEMBERS_TYPE_ALIAS_DOT_PREFIX.add(RfInterface.class);
    }

    public RfTypeAlias(String name, boolean escaped, DataType type, int qualifiers) {
        super(name, escaped, type);
        this.setQualifiers(qualifiers);
    }

    public RfTypeAlias(RfTypeAlias typeAlias) {
        super(typeAlias);
        this.setQualifiers(typeAlias.getQualifiers());
    }

    public void init(DataType type, int qualifiers) {
        super.init(type);
        this.setQualifiers(qualifiers);
    }

    @Override
    public boolean isStaticLikeAccessible() {
        return true;
    }

    @Override
    public void removeDef(IncrementalDeltaContainer incrementalDeltaContainer, RfDefElement def) {
        super.removeDef(incrementalDeltaContainer, def);
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public int getInducedParametricDependencyValue() {
        return this.getLastLevelDataType().getParametricDependencyValue();
    }

    @Override
    public String getSignature(RfTypesResolver resolver) {
        List<RfField> localFields;
        String kind = "";
        DataType dataType = this.getDataType();
        if (dataType != null && dataType.getType() != null) {
            if (dataType.getType().startsWith("enum/")) {
                kind = "enum ";
            } else if (dataType.getType().startsWith("struct/")) {
                kind = "struct ";
            } else if (dataType.getType().startsWith("union/")) {
                kind = "union ";
            }
        }
        StringBuilder fields = new StringBuilder();
        IRfNamedElement assocType = this.getAssociatedType(RfTypesResolver.create(resolver));
        if (assocType instanceof RfStruct && (localFields = ((RfNamedElement)assocType).getLocalMembers(RfField.class)) != null) {
            int size = localFields.size();
            int min = Math.min(3, size);
            int index = 0;
            for (RfField rfField : localFields) {
                if (rfField.isEnumRangeElement()) continue;
                if (rfField.getDataType() != null) {
                    fields.append(rfField.getDataType().getTypeName(null, null)).append(' ').append(rfField.getName()).append(index < min - 1 ? ", " : "");
                } else {
                    fields.append(rfField.getName()).append(index < min - 1 ? ", " : "");
                }
                if (++index == min) break;
            }
            if (min < size) {
                fields.append(" ...");
            }
        }
        String completeName = String.valueOf(this.printScope()) + this.getName();
        if (fields.length() > 0) {
            return "typedef " + kind + completeName + " values " + fields;
        }
        return "typedef " + kind + completeName;
    }

    public DataType getTranslatedAccumulatingDataType() {
        return this.getTranslatedAccumulatingDataTypeRecursive(new HashSet<String>());
    }

    @Override
    public String getKindName() {
        String str = super.getKindName();
        if (str == null) {
            return "";
        }
        IRfNamedElement translatedType = this.getTranslatedType();
        if (translatedType == null) {
            return str;
        }
        return String.valueOf(str) + " (" + RfKind.of(translatedType).getName() + ")";
    }

    private DataType getTranslatedAccumulatingDataTypeRecursive(Set<String> nameList) {
        DataType dataType = this.getDataType();
        if (nameList.contains(this.getName())) {
            return dataType;
        }
        nameList.add(this.getName());
        IRfNamedElement elem = this.getAssociatedType();
        if (elem instanceof RfListType) {
            elem = ((RfListType)elem).getAssociatedType();
        }
        if (elem == null) {
            return dataType;
        }
        if (elem instanceof RfTypeAlias && dataType != null) {
            DataType restDT = ((RfTypeAlias)elem).getTranslatedAccumulatingDataTypeRecursive(nameList);
            DataType newDT = restDT.copy();
            newDT.fUnpackedDimension = DataTypeDimensions.appendDimension(restDT.getUnpackedDimension(), dataType.getUnpackedDimension());
            newDT.fPackedDimension = DataTypeDimensions.appendDimension(dataType.fPackedDimension, restDT.getPackedDimension());
            return newDT;
        }
        return dataType;
    }

    public DataType getTranslatedDataType() {
        return this.getTranslatedDataTypeRecursive(new HashSet<String>());
    }

    private DataType getTranslatedDataTypeRecursive(Set<String> nameList) {
        DataType dataType = this.getDataType();
        if (nameList.contains(this.getName())) {
            return dataType;
        }
        nameList.add(this.getName());
        IRfNamedElement elem = this.getAssociatedType();
        if (elem instanceof RfTypeAlias) {
            return ((RfTypeAlias)elem).getTranslatedDataTypeRecursive(nameList);
        }
        return dataType;
    }

    @Override
    protected IRfNamedElement getAssociatedTypeNoLastLevelParams(RfTypesResolver typesResolver, ParametricDependency parametricDependency) {
        int dotPosition;
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        DataType dataType = this.getDataType();
        if (dataType == null || dataType.fType == null) {
            return null;
        }
        String typeName = dataType.fType;
        int n = dotPosition = typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/") ? -1 : typeName.indexOf(46);
        if (dotPosition != -1 && dotPosition + 1 < typeName.length()) {
            String scopeName = typeName.substring(0, dotPosition);
            IRfNamedElement candidate = enclosingScope.getMember(scopeName, MEMBERS_TYPE_ALIAS_DOT_PREFIX, null, true, false, false, false, false);
            if (candidate == null) {
                return null;
            }
            if (candidate instanceof RfAssociatedType) {
                candidate = ((RfAssociatedType)candidate).getAssociatedType(typesResolver);
            }
            if (candidate == null) {
                return null;
            }
            if (candidate instanceof RfField && ((RfField)candidate).isTypeParameter()) {
                return candidate;
            }
            if (candidate instanceof RfModport) {
                candidate = (IRfNamedElement)candidate.getEnclosingScope();
            }
            String typeAliasName = typeName.substring(dotPosition + 1);
            RfNamedElement assocType = ((RfNamedElement)candidate).getTypeAliasWithPrefix(typeAliasName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidate instanceof RfInterface && assocType == null) {
                assocType = ((RfNamedElement)candidate).getModportWithPrefix(typeAliasName, 1, 1);
            }
            return assocType;
        }
        return super.getAssociatedTypeNoLastLevelParams(typesResolver, parametricDependency);
    }

    public IRfNamedElement getTranslatedType(IRfScopeElement scope) {
        RfTypesResolver resolver = RfTypesResolver.create(scope, this.getRfProject(), 14);
        return resolver.computeTypeAlias(this, new ParametricDependency(1), this, null, null, null, true, false, false);
    }

    public final IRfNamedElement getTranslatedType() {
        return RfTypesResolver.create((IRfScopeElement)this, this.getRfProject(), 6).computeTypeAlias(this, new ParametricDependency(1), this, null, null, null, true, false, false);
    }

    public final IRfNamedElement getTranslatedType(RfTypesResolver typesResolver) {
        return typesResolver.computeTypeAlias(this, new ParametricDependency(1), this, null, null, null, true, false, false);
    }

    public final IRfNamedElement getTranslatedType(RfTypesResolver typesResolver, boolean noLastLevelParams, DataTypeDimensions dimensions, int[] signing) {
        return typesResolver.computeTypeAlias(this, new ParametricDependency(1), this, null, dimensions, signing, true, noLastLevelParams, false);
    }

    public RfNamedElement getTranslatedType2() {
        return this.getTranslatedTypeRecursive2(new HashSet<String>());
    }

    private RfNamedElement getTranslatedTypeRecursive2(Set<String> nameList) {
        if (nameList.contains(this.getName())) {
            return null;
        }
        nameList.add(this.getName());
        RfNamedElement elem = this.getAssociatedTypeNoParams2();
        if (elem instanceof RfTypeAlias) {
            return ((RfTypeAlias)elem).getTranslatedTypeRecursive2(nameList);
        }
        return elem;
    }

    @Override
    public List<RfScalarType> getScalarTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfScalarType getScalarTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfInterface> getInterfacesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfModule> getModulesWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfProgram> getProgramsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfField> getEventsWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public RfThisImplicitVariable getThisImplicitVariable(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfField> getArgumentsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getArgumentWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<RfStruct> getStructsUnionsWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public RfStruct getStructUnionWithPrefix(String prefix, int matchType, int local) {
        return null;
    }

    @Override
    public List<RfFunction> getTasksWithPrefix(String prefix, int matchType, int local, IRfNamedElement.AccessModifier accessModifier) {
        return null;
    }

    @Override
    public List<RfField> getVarsWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public RfField getVarWithPrefix(int offset, String prefix, int matchType) {
        return null;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_TYPEDEF: Duplicate typedef ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getMemberSelect() {
        return 1;
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    public boolean isDefinedLater() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        return DEFINED_LATER.equals(dataType.fType);
    }

    public boolean isBitStream() {
        IRfNamedElement translatedType = this.getTranslatedType();
        return translatedType != null && translatedType.isBitStream();
    }

    public boolean isPackedBitStream() {
        IRfNamedElement translatedType = this.getTranslatedType();
        return translatedType != null && translatedType.isPackedBitStream();
    }

    public RfForwardTypedef getTypedefDeclaration() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        RfForwardTypedef typedef = enclosingScope.getFirstLocalMember(RfForwardTypedef.class, this.getName());
        if (typedef == null) {
            return null;
        }
        if (typedef.getDeclarationIndex() < this.getDeclarationIndex()) {
            return typedef;
        }
        if (typedef.getDeclarationIndex() == this.getDeclarationIndex()) {
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null) {
                return null;
            }
            RfDefElement declaration2 = typedef.getDeclaration();
            if (declaration2 == null) {
                return null;
            }
            if (declaration2.getStartOffset() < declaration.getStartOffset()) {
                return typedef;
            }
        }
        return null;
    }

    public BitVectorContext getBitVectorContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        RfTypesResolver typesResolver = RfTypesResolver.create(evaluator, guardian.getOriginElement(), guardian.getHierarchyPath(), 0, false);
        IRfNamedElement translatedType = this.getTranslatedType(typesResolver);
        if (translatedType == null) {
            return null;
        }
        if (translatedType instanceof IRfTypeElement) {
            return ((IRfTypeElement)translatedType).getBitVectorContext((IHidEvaluator)typesResolver, guardian, origin);
        }
        if (translatedType instanceof IRfAssociatedTypeElement && !(translatedType instanceof RfField)) {
            return ((IRfAssociatedTypeElement)translatedType).getDataTypeBitVectorContext((IHidEvaluator)typesResolver, false, guardian.getHierarchyPath(), typesResolver.getManager());
        }
        return null;
    }

    @Override
    public boolean xIsClass(boolean resolveTypeAlias) {
        if (!resolveTypeAlias) {
            return false;
        }
        int i = 0;
        IRfNamedElement resolved = this.getResolvedType(true);
        while (resolved instanceof IRfTypeAliasElement && i++ < 1000) {
            resolved = ((IRfTypeAliasElement)resolved).getResolvedType(true);
        }
        return resolved != null && resolved.xIsClass(false);
    }
}

