/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection;

public class RfUtilities {
    public static final boolean isRange(String text, int startOffset, int endOffset) {
        if (text == null || text.isEmpty() || endOffset >= text.length()) {
            return false;
        }
        int nested = 0;
        boolean backslash = false;
        RANGE_STATE state = RANGE_STATE.CODE;
        RANGE_STATE returnState = RANGE_STATE.CODE;
        int i = startOffset;
        while (i < endOffset) {
            char ch = text.charAt(i);
            switch (state) {
                case CODE: {
                    returnState = state;
                    if (!backslash && ch == '\"') {
                        state = RANGE_STATE.STRING;
                    } else if (nested == 0 && ch == '?') {
                        state = RANGE_STATE.COND_EXP;
                    } else if (nested == 0 && ch == ':') {
                        if (i < endOffset && text.charAt(i + 1) != ':') {
                            return true;
                        }
                        ++i;
                    }
                    if (ch == '(' || ch == '[' || ch == '{') {
                        ++nested;
                        break;
                    }
                    if (ch != ')' && ch != ']' && ch != '}') break;
                    --nested;
                    break;
                }
                case STRING: {
                    if (backslash || ch != '\"') break;
                    state = returnState;
                    break;
                }
                case COND_EXP: {
                    returnState = state;
                    if (!backslash && ch == '\"') {
                        state = RANGE_STATE.STRING;
                    } else if (nested == 0 && ch == ':') {
                        state = RANGE_STATE.CODE;
                    }
                    if (ch == '(' || ch == '[' || ch == '{') {
                        ++nested;
                        break;
                    }
                    if (ch != ')' && ch != ']' && ch != '}') break;
                    --nested;
                    break;
                }
            }
            if (ch == '\\') {
                backslash = !backslash;
            }
            ++i;
        }
        return false;
    }

    private static enum RANGE_STATE {
        CODE,
        STRING,
        COND_EXP;

    }
}

